/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.policy;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Handler;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.util.Slog;
import java.io.PrintWriter;

public abstract class WindowOrientationListener {
    private static final String TAG = "WindowOrientationListener";
    private static final boolean LOG = SystemProperties.getBoolean("debug.orientation.log", false);
    private static final boolean USE_GRAVITY_SENSOR = false;
    private static final int DEFAULT_BATCH_LATENCY = 100000;
    private Handler mHandler;
    private SensorManager mSensorManager;
    private boolean mEnabled;
    private int mRate;
    private String mSensorType;
    private Sensor mSensor;
    private OrientationJudge mOrientationJudge;
    private int mCurrentRotation = -1;
    private final Object mLock = new Object();

    public WindowOrientationListener(Context context, Handler handler) {
        this(context, handler, 2);
    }

    private WindowOrientationListener(Context context, Handler handler, int rate) {
        this.mHandler = handler;
        this.mSensorManager = (SensorManager)context.getSystemService("sensor");
        this.mRate = rate;
        this.mSensor = this.mSensorManager.getDefaultSensor(27);
        if (this.mSensor != null) {
            this.mOrientationJudge = new OrientationSensorJudge();
        }
        if (this.mOrientationJudge == null) {
            this.mSensor = this.mSensorManager.getDefaultSensor(1);
            if (this.mSensor != null) {
                this.mOrientationJudge = new AccelSensorJudge(context);
            }
        }
    }

    public void enable() {
        this.enable(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enable(boolean clearCurrentRotation) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mSensor == null) {
                Slog.w(TAG, "Cannot detect sensors. Not enabled");
                return;
            }
            if (this.mEnabled) {
                return;
            }
            if (LOG) {
                Slog.d(TAG, "WindowOrientationListener enabled clearCurrentRotation=" + clearCurrentRotation);
            }
            this.mOrientationJudge.resetLocked(clearCurrentRotation);
            if (this.mSensor.getType() == 1) {
                this.mSensorManager.registerListener(this.mOrientationJudge, this.mSensor, this.mRate, 100000, this.mHandler);
            } else {
                this.mSensorManager.registerListener((SensorEventListener)this.mOrientationJudge, this.mSensor, this.mRate, this.mHandler);
            }
            this.mEnabled = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disable() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mSensor == null) {
                Slog.w(TAG, "Cannot detect sensors. Invalid disable");
                return;
            }
            if (this.mEnabled) {
                if (LOG) {
                    Slog.d(TAG, "WindowOrientationListener disabled");
                }
                this.mSensorManager.unregisterListener(this.mOrientationJudge);
                this.mEnabled = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTouchStart() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mOrientationJudge != null) {
                this.mOrientationJudge.onTouchStartLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTouchEnd() {
        long whenElapsedNanos = SystemClock.elapsedRealtimeNanos();
        Object object = this.mLock;
        synchronized (object) {
            if (this.mOrientationJudge != null) {
                this.mOrientationJudge.onTouchEndLocked(whenElapsedNanos);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentRotation(int rotation) {
        Object object = this.mLock;
        synchronized (object) {
            this.mCurrentRotation = rotation;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getProposedRotation() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mEnabled) {
                return this.mOrientationJudge.getProposedRotationLocked();
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canDetectOrientation() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mSensor != null;
        }
    }

    public abstract void onProposedRotationChanged(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(PrintWriter pw, String prefix) {
        Object object = this.mLock;
        synchronized (object) {
            pw.println(prefix + TAG);
            prefix = prefix + "  ";
            pw.println(prefix + "mEnabled=" + this.mEnabled);
            pw.println(prefix + "mCurrentRotation=" + this.mCurrentRotation);
            pw.println(prefix + "mSensorType=" + this.mSensorType);
            pw.println(prefix + "mSensor=" + this.mSensor);
            pw.println(prefix + "mRate=" + this.mRate);
            if (this.mOrientationJudge != null) {
                this.mOrientationJudge.dumpLocked(pw, prefix);
            }
        }
    }

    final class OrientationSensorJudge
    extends OrientationJudge {
        private boolean mTouching;
        private long mTouchEndedTimestampNanos;
        private int mProposedRotation;
        private int mDesiredRotation;
        private boolean mRotationEvaluationScheduled;
        private Runnable mRotationEvaluator;

        OrientationSensorJudge() {
            this.mTouchEndedTimestampNanos = Long.MIN_VALUE;
            this.mProposedRotation = -1;
            this.mDesiredRotation = -1;
            this.mRotationEvaluator = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    int newRotation;
                    Object object = WindowOrientationListener.this.mLock;
                    synchronized (object) {
                        OrientationSensorJudge.this.mRotationEvaluationScheduled = false;
                        newRotation = OrientationSensorJudge.this.evaluateRotationChangeLocked();
                    }
                    if (newRotation >= 0) {
                        WindowOrientationListener.this.onProposedRotationChanged(newRotation);
                    }
                }
            };
        }

        @Override
        public int getProposedRotationLocked() {
            return this.mProposedRotation;
        }

        @Override
        public void onTouchStartLocked() {
            this.mTouching = true;
        }

        @Override
        public void onTouchEndLocked(long whenElapsedNanos) {
            this.mTouching = false;
            this.mTouchEndedTimestampNanos = whenElapsedNanos;
            if (this.mDesiredRotation != this.mProposedRotation) {
                long now = SystemClock.elapsedRealtimeNanos();
                this.scheduleRotationEvaluationIfNecessaryLocked(now);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSensorChanged(SensorEvent event) {
            int newRotation;
            Object object = WindowOrientationListener.this.mLock;
            synchronized (object) {
                this.mDesiredRotation = (int)event.values[0];
                newRotation = this.evaluateRotationChangeLocked();
            }
            if (newRotation >= 0) {
                WindowOrientationListener.this.onProposedRotationChanged(newRotation);
            }
        }

        @Override
        public void onAccuracyChanged(Sensor sensor, int accuracy) {
        }

        @Override
        public void dumpLocked(PrintWriter pw, String prefix) {
            pw.println(prefix + "OrientationSensorJudge");
            prefix = prefix + "  ";
            pw.println(prefix + "mDesiredRotation=" + this.mDesiredRotation);
            pw.println(prefix + "mProposedRotation=" + this.mProposedRotation);
            pw.println(prefix + "mTouching=" + this.mTouching);
            pw.println(prefix + "mTouchEndedTimestampNanos=" + this.mTouchEndedTimestampNanos);
        }

        @Override
        public void resetLocked(boolean clearCurrentRotation) {
            if (clearCurrentRotation) {
                this.mProposedRotation = -1;
                this.mDesiredRotation = -1;
            }
            this.mTouching = false;
            this.mTouchEndedTimestampNanos = Long.MIN_VALUE;
            this.unscheduleRotationEvaluationLocked();
        }

        public int evaluateRotationChangeLocked() {
            this.unscheduleRotationEvaluationLocked();
            if (this.mDesiredRotation == this.mProposedRotation) {
                return -1;
            }
            long now = SystemClock.elapsedRealtimeNanos();
            if (this.isDesiredRotationAcceptableLocked(now)) {
                this.mProposedRotation = this.mDesiredRotation;
                return this.mProposedRotation;
            }
            this.scheduleRotationEvaluationIfNecessaryLocked(now);
            return -1;
        }

        private boolean isDesiredRotationAcceptableLocked(long now) {
            if (this.mTouching) {
                return false;
            }
            return now >= this.mTouchEndedTimestampNanos + 500000000L;
        }

        private void scheduleRotationEvaluationIfNecessaryLocked(long now) {
            if (this.mRotationEvaluationScheduled || this.mDesiredRotation == this.mProposedRotation) {
                if (LOG) {
                    Slog.d(WindowOrientationListener.TAG, "scheduleRotationEvaluationLocked: ignoring, an evaluation is already scheduled or is unnecessary.");
                }
                return;
            }
            if (this.mTouching) {
                if (LOG) {
                    Slog.d(WindowOrientationListener.TAG, "scheduleRotationEvaluationLocked: ignoring, user is still touching the screen.");
                }
                return;
            }
            long timeOfNextPossibleRotationNanos = this.mTouchEndedTimestampNanos + 500000000L;
            if (now >= timeOfNextPossibleRotationNanos) {
                if (LOG) {
                    Slog.d(WindowOrientationListener.TAG, "scheduleRotationEvaluationLocked: ignoring, already past the next possible time of rotation.");
                }
                return;
            }
            long delayMs = (long)Math.ceil((float)(timeOfNextPossibleRotationNanos - now) * 1.0E-6f);
            WindowOrientationListener.this.mHandler.postDelayed(this.mRotationEvaluator, delayMs);
            this.mRotationEvaluationScheduled = true;
        }

        private void unscheduleRotationEvaluationLocked() {
            if (!this.mRotationEvaluationScheduled) {
                return;
            }
            WindowOrientationListener.this.mHandler.removeCallbacks(this.mRotationEvaluator);
            this.mRotationEvaluationScheduled = false;
        }
    }

    final class AccelSensorJudge
    extends OrientationJudge {
        private static final float RADIANS_TO_DEGREES = 57.29578f;
        private static final int ACCELEROMETER_DATA_X = 0;
        private static final int ACCELEROMETER_DATA_Y = 1;
        private static final int ACCELEROMETER_DATA_Z = 2;
        private static final long PROPOSAL_SETTLE_TIME_NANOS = 40000000L;
        private static final long PROPOSAL_MIN_TIME_SINCE_FLAT_ENDED_NANOS = 500000000L;
        private static final long PROPOSAL_MIN_TIME_SINCE_SWING_ENDED_NANOS = 300000000L;
        private static final long PROPOSAL_MIN_TIME_SINCE_ACCELERATION_ENDED_NANOS = 500000000L;
        private static final float FLAT_ANGLE = 80.0f;
        private static final long FLAT_TIME_NANOS = 1000000000L;
        private static final float SWING_AWAY_ANGLE_DELTA = 20.0f;
        private static final long SWING_TIME_NANOS = 300000000L;
        private static final long MAX_FILTER_DELTA_TIME_NANOS = 1000000000L;
        private static final float FILTER_TIME_CONSTANT_MS = 200.0f;
        private static final float NEAR_ZERO_MAGNITUDE = 1.0f;
        private static final float ACCELERATION_TOLERANCE = 4.0f;
        private static final float MIN_ACCELERATION_MAGNITUDE = 5.80665f;
        private static final float MAX_ACCELERATION_MAGNITUDE = 13.80665f;
        private static final int MAX_TILT = 80;
        private static final int TILT_OVERHEAD_ENTER = -40;
        private static final int TILT_OVERHEAD_EXIT = -15;
        private static final int ADJACENT_ORIENTATION_ANGLE_GAP = 45;
        private final int[][] mTiltToleranceConfig;
        private long mLastFilteredTimestampNanos;
        private float mLastFilteredX;
        private float mLastFilteredY;
        private float mLastFilteredZ;
        private int mProposedRotation;
        private int mPredictedRotation;
        private long mPredictedRotationTimestampNanos;
        private long mFlatTimestampNanos;
        private boolean mFlat;
        private long mSwingTimestampNanos;
        private boolean mSwinging;
        private long mAccelerationTimestampNanos;
        private boolean mAccelerating;
        private long mTouchEndedTimestampNanos;
        private boolean mTouched;
        private boolean mOverhead;
        private static final int TILT_HISTORY_SIZE = 200;
        private float[] mTiltHistory;
        private long[] mTiltHistoryTimestampNanos;
        private int mTiltHistoryIndex;

        public AccelSensorJudge(Context context) {
            this.mTiltToleranceConfig = new int[][]{{-25, 70}, {-25, 65}, {-25, 60}, {-25, 65}};
            this.mTouchEndedTimestampNanos = Long.MIN_VALUE;
            this.mTiltHistory = new float[200];
            this.mTiltHistoryTimestampNanos = new long[200];
            int[] tiltTolerance = context.getResources().getIntArray(17235983);
            if (tiltTolerance.length == 8) {
                for (int i = 0; i < 4; ++i) {
                    int min = tiltTolerance[i * 2];
                    int max = tiltTolerance[i * 2 + 1];
                    if (min >= -90 && min <= max && max <= 90) {
                        this.mTiltToleranceConfig[i][0] = min;
                        this.mTiltToleranceConfig[i][1] = max;
                        continue;
                    }
                    Slog.wtf(WindowOrientationListener.TAG, "config_autoRotationTiltTolerance contains invalid range: min=" + min + ", max=" + max);
                }
            } else {
                Slog.wtf(WindowOrientationListener.TAG, "config_autoRotationTiltTolerance should have exactly 8 elements");
            }
        }

        @Override
        public int getProposedRotationLocked() {
            return this.mProposedRotation;
        }

        @Override
        public void dumpLocked(PrintWriter pw, String prefix) {
            pw.println(prefix + "AccelSensorJudge");
            prefix = prefix + "  ";
            pw.println(prefix + "mProposedRotation=" + this.mProposedRotation);
            pw.println(prefix + "mPredictedRotation=" + this.mPredictedRotation);
            pw.println(prefix + "mLastFilteredX=" + this.mLastFilteredX);
            pw.println(prefix + "mLastFilteredY=" + this.mLastFilteredY);
            pw.println(prefix + "mLastFilteredZ=" + this.mLastFilteredZ);
            long delta = SystemClock.elapsedRealtimeNanos() - this.mLastFilteredTimestampNanos;
            pw.println(prefix + "mLastFilteredTimestampNanos=" + this.mLastFilteredTimestampNanos + " (" + (float)delta * 1.0E-6f + "ms ago)");
            pw.println(prefix + "mTiltHistory={last: " + this.getLastTiltLocked() + "}");
            pw.println(prefix + "mFlat=" + this.mFlat);
            pw.println(prefix + "mSwinging=" + this.mSwinging);
            pw.println(prefix + "mAccelerating=" + this.mAccelerating);
            pw.println(prefix + "mOverhead=" + this.mOverhead);
            pw.println(prefix + "mTouched=" + this.mTouched);
            pw.print(prefix + "mTiltToleranceConfig=[");
            for (int i = 0; i < 4; ++i) {
                if (i != 0) {
                    pw.print(", ");
                }
                pw.print("[");
                pw.print(this.mTiltToleranceConfig[i][0]);
                pw.print(", ");
                pw.print(this.mTiltToleranceConfig[i][1]);
                pw.print("]");
            }
            pw.println("]");
        }

        @Override
        public void onAccuracyChanged(Sensor sensor, int accuracy) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSensorChanged(SensorEvent event) {
            int proposedRotation;
            int oldProposedRotation;
            Object object = WindowOrientationListener.this.mLock;
            synchronized (object) {
                boolean skipSample;
                float x = event.values[0];
                float y = event.values[1];
                float z = event.values[2];
                if (LOG) {
                    Slog.v(WindowOrientationListener.TAG, "Raw acceleration vector: x=" + x + ", y=" + y + ", z=" + z + ", magnitude=" + Math.sqrt(x * x + y * y + z * z));
                }
                long now = event.timestamp;
                long then = this.mLastFilteredTimestampNanos;
                float timeDeltaMS = (float)(now - then) * 1.0E-6f;
                if (now < then || now > then + 1000000000L || x == 0.0f && y == 0.0f && z == 0.0f) {
                    if (LOG) {
                        Slog.v(WindowOrientationListener.TAG, "Resetting orientation listener.");
                    }
                    this.resetLocked(true);
                    skipSample = true;
                } else {
                    float alpha = timeDeltaMS / (200.0f + timeDeltaMS);
                    x = alpha * (x - this.mLastFilteredX) + this.mLastFilteredX;
                    y = alpha * (y - this.mLastFilteredY) + this.mLastFilteredY;
                    z = alpha * (z - this.mLastFilteredZ) + this.mLastFilteredZ;
                    if (LOG) {
                        Slog.v(WindowOrientationListener.TAG, "Filtered acceleration vector: x=" + x + ", y=" + y + ", z=" + z + ", magnitude=" + Math.sqrt(x * x + y * y + z * z));
                    }
                    skipSample = false;
                }
                this.mLastFilteredTimestampNanos = now;
                this.mLastFilteredX = x;
                this.mLastFilteredY = y;
                this.mLastFilteredZ = z;
                boolean isAccelerating = false;
                boolean isFlat = false;
                boolean isSwinging = false;
                if (!skipSample) {
                    float magnitude = (float)Math.sqrt(x * x + y * y + z * z);
                    if (magnitude < 1.0f) {
                        if (LOG) {
                            Slog.v(WindowOrientationListener.TAG, "Ignoring sensor data, magnitude too close to zero.");
                        }
                        this.clearPredictedRotationLocked();
                    } else {
                        if (this.isAcceleratingLocked(magnitude)) {
                            isAccelerating = true;
                            this.mAccelerationTimestampNanos = now;
                        }
                        int tiltAngle = (int)Math.round(Math.asin(z / magnitude) * (double)57.29578f);
                        this.addTiltHistoryEntryLocked(now, tiltAngle);
                        if (this.isFlatLocked(now)) {
                            isFlat = true;
                            this.mFlatTimestampNanos = now;
                        }
                        if (this.isSwingingLocked(now, tiltAngle)) {
                            isSwinging = true;
                            this.mSwingTimestampNanos = now;
                        }
                        if (tiltAngle <= -40) {
                            this.mOverhead = true;
                        } else if (tiltAngle >= -15) {
                            this.mOverhead = false;
                        }
                        if (this.mOverhead) {
                            if (LOG) {
                                Slog.v(WindowOrientationListener.TAG, "Ignoring sensor data, device is overhead: tiltAngle=" + tiltAngle);
                            }
                            this.clearPredictedRotationLocked();
                        } else if (Math.abs(tiltAngle) > 80) {
                            if (LOG) {
                                Slog.v(WindowOrientationListener.TAG, "Ignoring sensor data, tilt angle too high: tiltAngle=" + tiltAngle);
                            }
                            this.clearPredictedRotationLocked();
                        } else {
                            int nearestRotation;
                            int orientationAngle = (int)Math.round(-Math.atan2(-x, y) * (double)57.29578f);
                            if (orientationAngle < 0) {
                                orientationAngle += 360;
                            }
                            if ((nearestRotation = (orientationAngle + 45) / 90) == 4) {
                                nearestRotation = 0;
                            }
                            if (this.isTiltAngleAcceptableLocked(nearestRotation, tiltAngle) && this.isOrientationAngleAcceptableLocked(nearestRotation, orientationAngle)) {
                                this.updatePredictedRotationLocked(now, nearestRotation);
                                if (LOG) {
                                    Slog.v(WindowOrientationListener.TAG, "Predicted: tiltAngle=" + tiltAngle + ", orientationAngle=" + orientationAngle + ", predictedRotation=" + this.mPredictedRotation + ", predictedRotationAgeMS=" + (float)(now - this.mPredictedRotationTimestampNanos) * 1.0E-6f);
                                }
                            } else {
                                if (LOG) {
                                    Slog.v(WindowOrientationListener.TAG, "Ignoring sensor data, no predicted rotation: tiltAngle=" + tiltAngle + ", orientationAngle=" + orientationAngle);
                                }
                                this.clearPredictedRotationLocked();
                            }
                        }
                    }
                }
                this.mFlat = isFlat;
                this.mSwinging = isSwinging;
                this.mAccelerating = isAccelerating;
                oldProposedRotation = this.mProposedRotation;
                if (this.mPredictedRotation < 0 || this.isPredictedRotationAcceptableLocked(now)) {
                    this.mProposedRotation = this.mPredictedRotation;
                }
                proposedRotation = this.mProposedRotation;
                if (LOG) {
                    Slog.v(WindowOrientationListener.TAG, "Result: currentRotation=" + WindowOrientationListener.this.mCurrentRotation + ", proposedRotation=" + proposedRotation + ", predictedRotation=" + this.mPredictedRotation + ", timeDeltaMS=" + timeDeltaMS + ", isAccelerating=" + isAccelerating + ", isFlat=" + isFlat + ", isSwinging=" + isSwinging + ", isOverhead=" + this.mOverhead + ", isTouched=" + this.mTouched + ", timeUntilSettledMS=" + this.remainingMS(now, this.mPredictedRotationTimestampNanos + 40000000L) + ", timeUntilAccelerationDelayExpiredMS=" + this.remainingMS(now, this.mAccelerationTimestampNanos + 500000000L) + ", timeUntilFlatDelayExpiredMS=" + this.remainingMS(now, this.mFlatTimestampNanos + 500000000L) + ", timeUntilSwingDelayExpiredMS=" + this.remainingMS(now, this.mSwingTimestampNanos + 300000000L) + ", timeUntilTouchDelayExpiredMS=" + this.remainingMS(now, this.mTouchEndedTimestampNanos + 500000000L));
                }
            }
            if (proposedRotation != oldProposedRotation && proposedRotation >= 0) {
                if (LOG) {
                    Slog.v(WindowOrientationListener.TAG, "Proposed rotation changed!  proposedRotation=" + proposedRotation + ", oldProposedRotation=" + oldProposedRotation);
                }
                WindowOrientationListener.this.onProposedRotationChanged(proposedRotation);
            }
        }

        @Override
        public void onTouchStartLocked() {
            this.mTouched = true;
        }

        @Override
        public void onTouchEndLocked(long whenElapsedNanos) {
            this.mTouched = false;
            this.mTouchEndedTimestampNanos = whenElapsedNanos;
        }

        @Override
        public void resetLocked(boolean clearCurrentRotation) {
            this.mLastFilteredTimestampNanos = Long.MIN_VALUE;
            if (clearCurrentRotation) {
                this.mProposedRotation = -1;
            }
            this.mFlatTimestampNanos = Long.MIN_VALUE;
            this.mFlat = false;
            this.mSwingTimestampNanos = Long.MIN_VALUE;
            this.mSwinging = false;
            this.mAccelerationTimestampNanos = Long.MIN_VALUE;
            this.mAccelerating = false;
            this.mOverhead = false;
            this.clearPredictedRotationLocked();
            this.clearTiltHistoryLocked();
        }

        private boolean isTiltAngleAcceptableLocked(int rotation, int tiltAngle) {
            return tiltAngle >= this.mTiltToleranceConfig[rotation][0] && tiltAngle <= this.mTiltToleranceConfig[rotation][1];
        }

        private boolean isOrientationAngleAcceptableLocked(int rotation, int orientationAngle) {
            int currentRotation = WindowOrientationListener.this.mCurrentRotation;
            if (currentRotation >= 0) {
                if (rotation == currentRotation || rotation == (currentRotation + 1) % 4) {
                    int lowerBound = rotation * 90 - 45 + 22;
                    if (rotation == 0 ? orientationAngle >= 315 && orientationAngle < lowerBound + 360 : orientationAngle < lowerBound) {
                        return false;
                    }
                }
                if (rotation == currentRotation || rotation == (currentRotation + 3) % 4) {
                    int upperBound = rotation * 90 + 45 - 22;
                    if (rotation == 0 ? orientationAngle <= 45 && orientationAngle > upperBound : orientationAngle > upperBound) {
                        return false;
                    }
                }
            }
            return true;
        }

        private boolean isPredictedRotationAcceptableLocked(long now) {
            if (now < this.mPredictedRotationTimestampNanos + 40000000L) {
                return false;
            }
            if (now < this.mFlatTimestampNanos + 500000000L) {
                return false;
            }
            if (now < this.mSwingTimestampNanos + 300000000L) {
                return false;
            }
            if (now < this.mAccelerationTimestampNanos + 500000000L) {
                return false;
            }
            return !this.mTouched && now >= this.mTouchEndedTimestampNanos + 500000000L;
        }

        private void clearPredictedRotationLocked() {
            this.mPredictedRotation = -1;
            this.mPredictedRotationTimestampNanos = Long.MIN_VALUE;
        }

        private void updatePredictedRotationLocked(long now, int rotation) {
            if (this.mPredictedRotation != rotation) {
                this.mPredictedRotation = rotation;
                this.mPredictedRotationTimestampNanos = now;
            }
        }

        private boolean isAcceleratingLocked(float magnitude) {
            return magnitude < 5.80665f || magnitude > 13.80665f;
        }

        private void clearTiltHistoryLocked() {
            this.mTiltHistoryTimestampNanos[0] = Long.MIN_VALUE;
            this.mTiltHistoryIndex = 1;
        }

        private void addTiltHistoryEntryLocked(long now, float tilt) {
            this.mTiltHistory[this.mTiltHistoryIndex] = tilt;
            this.mTiltHistoryTimestampNanos[this.mTiltHistoryIndex] = now;
            this.mTiltHistoryIndex = (this.mTiltHistoryIndex + 1) % 200;
            this.mTiltHistoryTimestampNanos[this.mTiltHistoryIndex] = Long.MIN_VALUE;
        }

        private boolean isFlatLocked(long now) {
            int i = this.mTiltHistoryIndex;
            while ((i = this.nextTiltHistoryIndexLocked(i)) >= 0 && !(this.mTiltHistory[i] < 80.0f)) {
                if (this.mTiltHistoryTimestampNanos[i] + 1000000000L > now) continue;
                return true;
            }
            return false;
        }

        private boolean isSwingingLocked(long now, float tilt) {
            int i = this.mTiltHistoryIndex;
            while ((i = this.nextTiltHistoryIndexLocked(i)) >= 0 && this.mTiltHistoryTimestampNanos[i] + 300000000L >= now) {
                if (!(this.mTiltHistory[i] + 20.0f <= tilt)) continue;
                return true;
            }
            return false;
        }

        private int nextTiltHistoryIndexLocked(int index) {
            index = (index == 0 ? 200 : index) - 1;
            return this.mTiltHistoryTimestampNanos[index] != Long.MIN_VALUE ? index : -1;
        }

        private float getLastTiltLocked() {
            int index = this.nextTiltHistoryIndexLocked(this.mTiltHistoryIndex);
            return index >= 0 ? this.mTiltHistory[index] : Float.NaN;
        }

        private float remainingMS(long now, long until) {
            return now >= until ? 0.0f : (float)(until - now) * 1.0E-6f;
        }
    }

    abstract class OrientationJudge
    implements SensorEventListener {
        protected static final long NANOS_PER_MS = 1000000L;
        protected static final float MILLIS_PER_NANO = 1.0E-6f;
        protected static final long PROPOSAL_MIN_TIME_SINCE_TOUCH_END_NANOS = 500000000L;

        OrientationJudge() {
        }

        public abstract int getProposedRotationLocked();

        public abstract void onTouchStartLocked();

        public abstract void onTouchEndLocked(long var1);

        public abstract void resetLocked(boolean var1);

        public abstract void dumpLocked(PrintWriter var1, String var2);

        @Override
        public abstract void onAccuracyChanged(Sensor var1, int var2);

        @Override
        public abstract void onSensorChanged(SensorEvent var1);
    }
}

