/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm.dex;

import android.content.pm.ApplicationInfo;
import android.util.Slog;
import android.util.SparseArray;
import com.android.internal.os.ClassLoaderFactory;
import java.io.File;
import java.util.List;

public final class DexoptUtils {
    private static final String TAG = "DexoptUtils";

    private DexoptUtils() {
    }

    public static String[] getClassLoaderContexts(ApplicationInfo info, String[] sharedLibraries, boolean[] pathsWithCode) {
        String sharedLibrariesClassPath = DexoptUtils.encodeClasspath(sharedLibraries);
        String baseApkContextClassLoader = DexoptUtils.encodeClassLoader(sharedLibrariesClassPath, info.classLoaderName);
        if (info.getSplitCodePaths() == null) {
            return new String[]{baseApkContextClassLoader};
        }
        String[] splitRelativeCodePaths = DexoptUtils.getSplitRelativeCodePaths(info);
        String baseApkName = new File(info.getBaseCodePath()).getName();
        String sharedLibrariesAndBaseClassPath = DexoptUtils.encodeClasspath(sharedLibrariesClassPath, baseApkName);
        String[] classLoaderContexts = new String[1 + splitRelativeCodePaths.length];
        String string2 = classLoaderContexts[0] = pathsWithCode[0] ? baseApkContextClassLoader : null;
        if (!info.requestsIsolatedSplitLoading() || info.splitDependencies == null) {
            String classpath = sharedLibrariesAndBaseClassPath;
            for (int i = 1; i < classLoaderContexts.length; ++i) {
                classLoaderContexts[i] = pathsWithCode[i] ? DexoptUtils.encodeClassLoader(classpath, info.classLoaderName) : null;
                classpath = DexoptUtils.encodeClasspath(classpath, splitRelativeCodePaths[i - 1]);
            }
        } else {
            int i;
            String[] splitClassLoaderEncodingCache = new String[splitRelativeCodePaths.length];
            for (int i2 = 0; i2 < splitRelativeCodePaths.length; ++i2) {
                splitClassLoaderEncodingCache[i2] = DexoptUtils.encodeClassLoader(splitRelativeCodePaths[i2], info.splitClassLoaderNames[i2]);
            }
            String splitDependencyOnBase = DexoptUtils.encodeClassLoader(sharedLibrariesAndBaseClassPath, info.classLoaderName);
            SparseArray<int[]> splitDependencies = info.splitDependencies;
            for (i = 1; i < splitDependencies.size(); ++i) {
                int splitIndex = splitDependencies.keyAt(i);
                if (!pathsWithCode[splitIndex]) continue;
                DexoptUtils.getParentDependencies(splitIndex, splitClassLoaderEncodingCache, splitDependencies, classLoaderContexts, splitDependencyOnBase);
            }
            for (i = 1; i < classLoaderContexts.length; ++i) {
                String splitClassLoader = DexoptUtils.encodeClassLoader("", info.splitClassLoaderNames[i - 1]);
                classLoaderContexts[i] = pathsWithCode[i] ? (classLoaderContexts[i] == null ? splitClassLoader : DexoptUtils.encodeClassLoaderChain(splitClassLoader, classLoaderContexts[i])) : null;
            }
        }
        return classLoaderContexts;
    }

    private static String getParentDependencies(int index, String[] splitClassLoaderEncodingCache, SparseArray<int[]> splitDependencies, String[] classLoaderContexts, String splitDependencyOnBase) {
        String splitContext;
        if (index == 0) {
            return splitDependencyOnBase;
        }
        if (classLoaderContexts[index] != null) {
            return classLoaderContexts[index];
        }
        int parent = splitDependencies.get(index)[0];
        String parentDependencies = DexoptUtils.getParentDependencies(parent, splitClassLoaderEncodingCache, splitDependencies, classLoaderContexts, splitDependencyOnBase);
        classLoaderContexts[index] = splitContext = parent == 0 ? parentDependencies : DexoptUtils.encodeClassLoaderChain(splitClassLoaderEncodingCache[parent - 1], parentDependencies);
        return splitContext;
    }

    private static String encodeClasspath(String[] classpathElements) {
        if (classpathElements == null || classpathElements.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String element : classpathElements) {
            if (sb.length() != 0) {
                sb.append(":");
            }
            sb.append(element);
        }
        return sb.toString();
    }

    private static String encodeClasspath(String classpath, String newElement) {
        return classpath.isEmpty() ? newElement : classpath + ":" + newElement;
    }

    static String encodeClassLoader(String classpath, String classLoaderName) {
        if (classpath.equals("&")) {
            return classpath;
        }
        String classLoaderDexoptEncoding = classLoaderName;
        if (ClassLoaderFactory.isPathClassLoaderName(classLoaderName)) {
            classLoaderDexoptEncoding = "PCL";
        } else if (ClassLoaderFactory.isDelegateLastClassLoaderName(classLoaderName)) {
            classLoaderDexoptEncoding = "DLC";
        } else {
            Slog.wtf(TAG, "Unsupported classLoaderName: " + classLoaderName);
        }
        return classLoaderDexoptEncoding + "[" + classpath + "]";
    }

    static String encodeClassLoaderChain(String cl1, String cl2) {
        if (cl1.equals("&") || cl2.equals("&")) {
            return "&";
        }
        if (cl1.isEmpty()) {
            return cl2;
        }
        if (cl2.isEmpty()) {
            return cl1;
        }
        return cl1 + ";" + cl2;
    }

    static String[] processContextForDexLoad(List<String> classLoadersNames, List<String> classPaths) {
        if (classLoadersNames.size() != classPaths.size()) {
            throw new IllegalArgumentException("The size of the class loader names and the dex paths do not match.");
        }
        if (classLoadersNames.isEmpty()) {
            throw new IllegalArgumentException("Empty classLoadersNames");
        }
        String parentContext = "";
        for (int i = 1; i < classLoadersNames.size(); ++i) {
            if (!ClassLoaderFactory.isValidClassLoaderName(classLoadersNames.get(i))) {
                return null;
            }
            String classpath = DexoptUtils.encodeClasspath(classPaths.get(i).split(File.pathSeparator));
            parentContext = DexoptUtils.encodeClassLoaderChain(parentContext, DexoptUtils.encodeClassLoader(classpath, classLoadersNames.get(i)));
        }
        String loadingClassLoader = classLoadersNames.get(0);
        if (!ClassLoaderFactory.isValidClassLoaderName(loadingClassLoader)) {
            return null;
        }
        String[] loadedDexPaths = classPaths.get(0).split(File.pathSeparator);
        String[] loadedDexPathsContext = new String[loadedDexPaths.length];
        String currentLoadedDexPathClasspath = "";
        for (int i = 0; i < loadedDexPaths.length; ++i) {
            String dexPath = loadedDexPaths[i];
            String currentContext = DexoptUtils.encodeClassLoader(currentLoadedDexPathClasspath, loadingClassLoader);
            loadedDexPathsContext[i] = DexoptUtils.encodeClassLoaderChain(currentContext, parentContext);
            currentLoadedDexPathClasspath = DexoptUtils.encodeClasspath(currentLoadedDexPathClasspath, dexPath);
        }
        return loadedDexPathsContext;
    }

    private static String[] getSplitRelativeCodePaths(ApplicationInfo info) {
        String baseCodePath = new File(info.getBaseCodePath()).getParent();
        String[] splitCodePaths = info.getSplitCodePaths();
        String[] splitRelativeCodePaths = new String[splitCodePaths.length];
        for (int i = 0; i < splitCodePaths.length; ++i) {
            File pathFile = new File(splitCodePaths[i]);
            splitRelativeCodePaths[i] = pathFile.getName();
            String basePath = pathFile.getParent();
            if (basePath.equals(baseCodePath)) continue;
            Slog.wtf(TAG, "Split paths have different base paths: " + basePath + " and " + baseCodePath);
        }
        return splitRelativeCodePaths;
    }
}

