/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.util.ArraySet;
import com.android.server.pm.PackageSetting;
import com.android.server.pm.PackageSignatures;
import com.android.server.pm.SettingBase;

final class SharedUserSetting
extends SettingBase {
    final String name;
    int userId;
    int uidFlags;
    int uidPrivateFlags;
    final ArraySet<PackageSetting> packages = new ArraySet();
    final PackageSignatures signatures = new PackageSignatures();

    SharedUserSetting(String _name, int _pkgFlags, int _pkgPrivateFlags) {
        super(_pkgFlags, _pkgPrivateFlags);
        this.uidFlags = _pkgFlags;
        this.uidPrivateFlags = _pkgPrivateFlags;
        this.name = _name;
    }

    public String toString() {
        return "SharedUserSetting{" + Integer.toHexString(System.identityHashCode(this)) + " " + this.name + "/" + this.userId + "}";
    }

    void removePackage(PackageSetting packageSetting) {
        if (this.packages.remove(packageSetting)) {
            if ((this.pkgFlags & packageSetting.pkgFlags) != 0) {
                int aggregatedFlags = this.uidFlags;
                for (PackageSetting ps : this.packages) {
                    aggregatedFlags |= ps.pkgFlags;
                }
                this.setFlags(aggregatedFlags);
            }
            if ((this.pkgPrivateFlags & packageSetting.pkgPrivateFlags) != 0) {
                int aggregatedPrivateFlags = this.uidPrivateFlags;
                for (PackageSetting ps : this.packages) {
                    aggregatedPrivateFlags |= ps.pkgPrivateFlags;
                }
                this.setPrivateFlags(aggregatedPrivateFlags);
            }
        }
    }

    void addPackage(PackageSetting packageSetting) {
        if (this.packages.add(packageSetting)) {
            this.setFlags(this.pkgFlags | packageSetting.pkgFlags);
            this.setPrivateFlags(this.pkgPrivateFlags | packageSetting.pkgPrivateFlags);
        }
    }
}

