/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.app.ActivityManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.IIntentSender;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.IntentSender;
import android.content.pm.ActivityInfo;
import android.content.pm.AuxiliaryResolveInfo;
import android.content.pm.InstantAppIntentFilter;
import android.content.pm.InstantAppRequest;
import android.content.pm.InstantAppResolveInfo;
import android.metrics.LogMaker;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.RemoteException;
import android.util.Log;
import com.android.internal.logging.MetricsLogger;
import com.android.server.pm.EphemeralResolverConnection;
import com.android.server.pm.PackageManagerService;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;

public abstract class InstantAppResolver {
    private static final boolean DEBUG_EPHEMERAL = Build.IS_DEBUGGABLE;
    private static final String TAG = "PackageManager";
    private static final int RESOLUTION_SUCCESS = 0;
    private static final int RESOLUTION_FAILURE = 1;
    private static final int RESOLUTION_BIND_TIMEOUT = 2;
    private static final int RESOLUTION_CALL_TIMEOUT = 3;
    private static MetricsLogger sMetricsLogger;

    private static MetricsLogger getLogger() {
        if (sMetricsLogger == null) {
            sMetricsLogger = new MetricsLogger();
        }
        return sMetricsLogger;
    }

    public static AuxiliaryResolveInfo doInstantAppResolutionPhaseOne(Context context, EphemeralResolverConnection connection, InstantAppRequest requestObj) {
        long startTime = System.currentTimeMillis();
        String token = UUID.randomUUID().toString();
        if (DEBUG_EPHEMERAL) {
            Log.d(TAG, "[" + token + "] Phase1; resolving");
        }
        Intent intent = requestObj.origIntent;
        InstantAppResolveInfo.InstantAppDigest digest = new InstantAppResolveInfo.InstantAppDigest(intent.getData().getHost(), 5);
        int[] shaPrefix = digest.getDigestPrefix();
        AuxiliaryResolveInfo resolveInfo = null;
        int resolutionStatus = 0;
        try {
            List<InstantAppResolveInfo> instantAppResolveInfoList = connection.getInstantAppResolveInfoList(shaPrefix, token);
            if (instantAppResolveInfoList != null && instantAppResolveInfoList.size() > 0) {
                resolveInfo = InstantAppResolver.filterInstantAppIntent(instantAppResolveInfoList, intent, requestObj.resolvedType, requestObj.userId, intent.getPackage(), digest, token);
            }
        }
        catch (EphemeralResolverConnection.ConnectionException e) {
            resolutionStatus = e.failure == 1 ? 2 : (e.failure == 2 ? 3 : 1);
        }
        if (requestObj.resolveForStart && resolutionStatus == 0) {
            InstantAppResolver.logMetrics(899, startTime, token, resolutionStatus);
        }
        if (DEBUG_EPHEMERAL && resolveInfo == null) {
            if (resolutionStatus == 2) {
                Log.d(TAG, "[" + token + "] Phase1; bind timed out");
            } else if (resolutionStatus == 3) {
                Log.d(TAG, "[" + token + "] Phase1; call timed out");
            } else if (resolutionStatus != 0) {
                Log.d(TAG, "[" + token + "] Phase1; service connection error");
            } else {
                Log.d(TAG, "[" + token + "] Phase1; No results matched");
            }
        }
        return resolveInfo;
    }

    public static void doInstantAppResolutionPhaseTwo(final Context context, EphemeralResolverConnection connection, final InstantAppRequest requestObj, final ActivityInfo instantAppInstaller, Handler callbackHandler) {
        block5: {
            long startTime = System.currentTimeMillis();
            final String token = requestObj.responseObj.token;
            if (DEBUG_EPHEMERAL) {
                Log.d(TAG, "[" + token + "] Phase2; resolving");
            }
            final Intent intent = requestObj.origIntent;
            String hostName = intent.getData().getHost();
            final InstantAppResolveInfo.InstantAppDigest digest = new InstantAppResolveInfo.InstantAppDigest(hostName, 5);
            int[] shaPrefix = digest.getDigestPrefix();
            EphemeralResolverConnection.PhaseTwoCallback callback = new EphemeralResolverConnection.PhaseTwoCallback(){

                @Override
                void onPhaseTwoResolved(List<InstantAppResolveInfo> instantAppResolveInfoList, long startTime) {
                    Intent failureIntent;
                    int versionCode;
                    String splitName;
                    String packageName;
                    if (instantAppResolveInfoList != null && instantAppResolveInfoList.size() > 0) {
                        AuxiliaryResolveInfo instantAppIntentInfo = InstantAppResolver.filterInstantAppIntent(instantAppResolveInfoList, intent, null, 0, intent.getPackage(), digest, token);
                        if (instantAppIntentInfo != null && instantAppIntentInfo.resolveInfo != null) {
                            packageName = instantAppIntentInfo.resolveInfo.getPackageName();
                            splitName = instantAppIntentInfo.splitName;
                            versionCode = instantAppIntentInfo.resolveInfo.getVersionCode();
                            failureIntent = instantAppIntentInfo.failureIntent;
                        } else {
                            packageName = null;
                            splitName = null;
                            versionCode = -1;
                            failureIntent = null;
                        }
                    } else {
                        packageName = null;
                        splitName = null;
                        versionCode = -1;
                        failureIntent = null;
                    }
                    Intent installerIntent = InstantAppResolver.buildEphemeralInstallerIntent("android.intent.action.RESOLVE_INSTANT_APP_PACKAGE", requestObj.origIntent, failureIntent, requestObj.callingPackage, requestObj.verificationBundle, requestObj.resolvedType, requestObj.userId, packageName, splitName, requestObj.responseObj.installFailureActivity, versionCode, token, false);
                    installerIntent.setComponent(new ComponentName(instantAppInstaller.packageName, instantAppInstaller.name));
                    InstantAppResolver.logMetrics(900, startTime, token, packageName != null ? 0 : 1);
                    context.startActivity(installerIntent);
                }
            };
            try {
                connection.getInstantAppIntentFilterList(shaPrefix, token, hostName, callback, callbackHandler, startTime);
            }
            catch (EphemeralResolverConnection.ConnectionException e) {
                int resolutionStatus = 1;
                if (e.failure == 1) {
                    resolutionStatus = 2;
                }
                InstantAppResolver.logMetrics(900, startTime, token, resolutionStatus);
                if (!DEBUG_EPHEMERAL) break block5;
                if (resolutionStatus == 2) {
                    Log.d(TAG, "[" + token + "] Phase2; bind timed out");
                }
                Log.d(TAG, "[" + token + "] Phase2; service connection error");
            }
        }
    }

    public static Intent buildEphemeralInstallerIntent(String action, Intent origIntent, Intent failureIntent, String callingPackage, Bundle verificationBundle, String resolvedType, int userId, String instantAppPackageName, String instantAppSplitName, ComponentName installFailureActivity, int versionCode, String token, boolean needsPhaseTwo) {
        int flags = origIntent.getFlags();
        Intent intent = new Intent(action);
        intent.setFlags(flags | 0x10000000 | 0x8000 | 0x40000000 | 0x800000);
        if (token != null) {
            intent.putExtra("android.intent.extra.EPHEMERAL_TOKEN", token);
        }
        if (origIntent.getData() != null) {
            intent.putExtra("android.intent.extra.EPHEMERAL_HOSTNAME", origIntent.getData().getHost());
        }
        if (!needsPhaseTwo) {
            if (failureIntent != null || installFailureActivity != null) {
                try {
                    Intent onFailureIntent;
                    if (installFailureActivity != null) {
                        onFailureIntent = new Intent();
                        onFailureIntent.setComponent(installFailureActivity);
                        onFailureIntent.putExtra("android.intent.extra.SPLIT_NAME", instantAppSplitName);
                        onFailureIntent.putExtra("android.intent.extra.INTENT", origIntent);
                    } else {
                        onFailureIntent = failureIntent;
                    }
                    IIntentSender failureIntentTarget = ActivityManager.getService().getIntentSender(2, callingPackage, null, null, 1, new Intent[]{onFailureIntent}, new String[]{resolvedType}, 0x54000000, null, userId);
                    intent.putExtra("android.intent.extra.EPHEMERAL_FAILURE", new IntentSender(failureIntentTarget));
                }
                catch (RemoteException onFailureIntent) {
                    // empty catch block
                }
            }
            Intent successIntent = new Intent(origIntent);
            successIntent.setLaunchToken(token);
            try {
                IIntentSender successIntentTarget = ActivityManager.getService().getIntentSender(2, callingPackage, null, null, 0, new Intent[]{successIntent}, new String[]{resolvedType}, 0x54000000, null, userId);
                intent.putExtra("android.intent.extra.EPHEMERAL_SUCCESS", new IntentSender(successIntentTarget));
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            intent.putExtra("android.intent.extra.PACKAGE_NAME", instantAppPackageName);
            intent.putExtra("android.intent.extra.SPLIT_NAME", instantAppSplitName);
            intent.putExtra("android.intent.extra.VERSION_CODE", versionCode);
            intent.putExtra("android.intent.extra.CALLING_PACKAGE", callingPackage);
            if (verificationBundle != null) {
                intent.putExtra("android.intent.extra.VERIFICATION_BUNDLE", verificationBundle);
            }
        }
        return intent;
    }

    private static AuxiliaryResolveInfo filterInstantAppIntent(List<InstantAppResolveInfo> instantAppResolveInfoList, Intent origIntent, String resolvedType, int userId, String packageName, InstantAppResolveInfo.InstantAppDigest digest, String token) {
        int[] shaPrefix = digest.getDigestPrefix();
        byte[][] digestBytes = digest.getDigestBytes();
        Intent failureIntent = new Intent(origIntent);
        failureIntent.setFlags(failureIntent.getFlags() | 0x200);
        failureIntent.setLaunchToken(token);
        for (int i = shaPrefix.length - 1; i >= 0; --i) {
            for (InstantAppResolveInfo instantAppInfo : instantAppResolveInfoList) {
                if (!Arrays.equals(digestBytes[i], instantAppInfo.getDigestBytes()) || packageName != null && !packageName.equals(instantAppInfo.getPackageName())) continue;
                List<InstantAppIntentFilter> instantAppFilters = instantAppInfo.getIntentFilters();
                if (instantAppFilters == null || instantAppFilters.isEmpty()) {
                    if (DEBUG_EPHEMERAL) {
                        Log.d(TAG, "No app filters; go to phase 2");
                    }
                    return new AuxiliaryResolveInfo(instantAppInfo, new IntentFilter("android.intent.action.VIEW"), null, token, true, null);
                }
                PackageManagerService.EphemeralIntentResolver instantAppResolver = new PackageManagerService.EphemeralIntentResolver();
                for (int j = instantAppFilters.size() - 1; j >= 0; --j) {
                    InstantAppIntentFilter instantAppFilter = instantAppFilters.get(j);
                    List<IntentFilter> splitFilters = instantAppFilter.getFilters();
                    if (splitFilters == null || splitFilters.isEmpty()) continue;
                    for (int k = splitFilters.size() - 1; k >= 0; --k) {
                        AuxiliaryResolveInfo intentInfo = new AuxiliaryResolveInfo(instantAppInfo, splitFilters.get(k), instantAppFilter.getSplitName(), token, false, failureIntent);
                        instantAppResolver.addFilter(intentInfo);
                    }
                }
                List matchedResolveInfoList = instantAppResolver.queryIntent(origIntent, resolvedType, false, userId);
                if (!matchedResolveInfoList.isEmpty()) {
                    if (DEBUG_EPHEMERAL) {
                        AuxiliaryResolveInfo info = (AuxiliaryResolveInfo)matchedResolveInfoList.get(0);
                        Log.d(TAG, "[" + token + "] Found match; package: " + info.packageName + ", split: " + info.splitName + ", versionCode: " + info.versionCode);
                    }
                    return (AuxiliaryResolveInfo)matchedResolveInfoList.get(0);
                }
                if (!DEBUG_EPHEMERAL) continue;
                Log.d(TAG, "[" + token + "] No matches found package: " + instantAppInfo.getPackageName() + ", versionCode: " + instantAppInfo.getVersionCode());
            }
        }
        return null;
    }

    private static void logMetrics(int action, long startTime, String token, int status) {
        LogMaker logMaker = new LogMaker(action).setType(4).addTaggedData(901, new Long(System.currentTimeMillis() - startTime)).addTaggedData(903, token).addTaggedData(902, new Integer(status));
        InstantAppResolver.getLogger().write(logMaker);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ResolutionStatus {
    }
}

