/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.notification;

import android.app.ActivityManager;
import android.app.ActivityManagerInternal;
import android.app.AlarmManager;
import android.app.AppGlobals;
import android.app.AppOpsManager;
import android.app.AutomaticZenRule;
import android.app.IActivityManager;
import android.app.INotificationManager;
import android.app.ITransientNotification;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationChannelGroup;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.backup.BackupManager;
import android.app.usage.UsageStatsManagerInternal;
import android.companion.ICompanionDeviceManager;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.IPackageManager;
import android.content.pm.PackageManager;
import android.content.pm.ParceledListSlice;
import android.content.res.Resources;
import android.database.ContentObserver;
import android.media.AudioAttributes;
import android.media.AudioManager;
import android.media.AudioManagerInternal;
import android.media.IRingtonePlayer;
import android.net.Uri;
import android.os.Binder;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Message;
import android.os.Process;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.ServiceManager;
import android.os.ShellCallback;
import android.os.ShellCommand;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.os.VibrationEffect;
import android.os.Vibrator;
import android.provider.Settings;
import android.service.notification.Adjustment;
import android.service.notification.Condition;
import android.service.notification.IConditionProvider;
import android.service.notification.INotificationListener;
import android.service.notification.IStatusBarNotificationHolder;
import android.service.notification.NotificationRankingUpdate;
import android.service.notification.SnoozeCriterion;
import android.service.notification.StatusBarNotification;
import android.service.notification.ZenModeConfig;
import android.telecom.TelecomManager;
import android.telephony.PhoneStateListener;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.AtomicFile;
import android.util.Log;
import android.util.Slog;
import android.util.SparseArray;
import android.util.Xml;
import android.util.proto.ProtoOutputStream;
import android.view.WindowManagerInternal;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import android.widget.Toast;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.logging.MetricsLogger;
import com.android.internal.os.BackgroundThread;
import com.android.internal.statusbar.NotificationVisibility;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.DumpUtils;
import com.android.internal.util.FastXmlSerializer;
import com.android.internal.util.Preconditions;
import com.android.internal.util.XmlUtils;
import com.android.server.DeviceIdleController;
import com.android.server.EventLogTags;
import com.android.server.LocalServices;
import com.android.server.SystemService;
import com.android.server.lights.Light;
import com.android.server.lights.LightsManager;
import com.android.server.notification.ConditionProviders;
import com.android.server.notification.GroupHelper;
import com.android.server.notification.ManagedServices;
import com.android.server.notification.NotificationDelegate;
import com.android.server.notification.NotificationManagerInternal;
import com.android.server.notification.NotificationRecord;
import com.android.server.notification.NotificationUsageStats;
import com.android.server.notification.RankingHandler;
import com.android.server.notification.RankingHelper;
import com.android.server.notification.RankingReconsideration;
import com.android.server.notification.SnoozeHelper;
import com.android.server.notification.ValidateNotificationPeople;
import com.android.server.notification.ZenLog;
import com.android.server.notification.ZenModeHelper;
import com.android.server.statusbar.StatusBarManagerInternal;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import libcore.io.IoUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class NotificationManagerService
extends SystemService {
    static final String TAG = "NotificationService";
    static final boolean DBG = Log.isLoggable("NotificationService", 3);
    public static final boolean ENABLE_CHILD_NOTIFICATIONS = SystemProperties.getBoolean("debug.child_notifs", true);
    static final int MAX_PACKAGE_NOTIFICATIONS = 50;
    static final float DEFAULT_MAX_NOTIFICATION_ENQUEUE_RATE = 5.0f;
    static final int MESSAGE_TIMEOUT = 2;
    static final int MESSAGE_SAVE_POLICY_FILE = 3;
    static final int MESSAGE_SEND_RANKING_UPDATE = 4;
    static final int MESSAGE_LISTENER_HINTS_CHANGED = 5;
    static final int MESSAGE_LISTENER_NOTIFICATION_FILTER_CHANGED = 6;
    private static final int MESSAGE_RECONSIDER_RANKING = 1000;
    private static final int MESSAGE_RANKING_SORT = 1001;
    static final int LONG_DELAY = 3500;
    static final int SHORT_DELAY = 2000;
    static final long[] DEFAULT_VIBRATE_PATTERN = new long[]{0L, 250L, 250L, 250L};
    static final long SNOOZE_UNTIL_UNSPECIFIED = -1L;
    static final int VIBRATE_PATTERN_MAXLEN = 17;
    static final int DEFAULT_STREAM_TYPE = 5;
    static final boolean ENABLE_BLOCKED_TOASTS = true;
    static final int MATCHES_CALL_FILTER_CONTACTS_TIMEOUT_MS = 3000;
    static final float MATCHES_CALL_FILTER_TIMEOUT_AFFINITY = 1.0f;
    private static final int EVENTLOG_ENQUEUE_STATUS_NEW = 0;
    private static final int EVENTLOG_ENQUEUE_STATUS_UPDATE = 1;
    private static final int EVENTLOG_ENQUEUE_STATUS_IGNORED = 2;
    private static final long MIN_PACKAGE_OVERRATE_LOG_INTERVAL = 5000L;
    private static final long DELAY_FOR_ASSISTANT_TIME = 100L;
    private static final String ACTION_NOTIFICATION_TIMEOUT = NotificationManagerService.class.getSimpleName() + ".TIMEOUT";
    private static final int REQUEST_CODE_TIMEOUT = 1;
    private static final String SCHEME_TIMEOUT = "timeout";
    private static final String EXTRA_KEY = "key";
    private IActivityManager mAm;
    private ActivityManager mActivityManager;
    private IPackageManager mPackageManager;
    private PackageManager mPackageManagerClient;
    AudioManager mAudioManager;
    AudioManagerInternal mAudioManagerInternal;
    StatusBarManagerInternal mStatusBar;
    Vibrator mVibrator;
    private WindowManagerInternal mWindowManagerInternal;
    private AlarmManager mAlarmManager;
    private ICompanionDeviceManager mCompanionManager;
    private AccessibilityManager mAccessibilityManager;
    final IBinder mForegroundToken = new Binder();
    private WorkerHandler mHandler;
    private final HandlerThread mRankingThread = new HandlerThread("ranker", 10);
    private Light mNotificationLight;
    Light mAttentionLight;
    private long[] mFallbackVibrationPattern;
    private boolean mUseAttentionLight;
    boolean mSystemReady;
    private boolean mDisableNotificationEffects;
    private int mCallState;
    private String mSoundNotificationKey;
    private String mVibrateNotificationKey;
    private final SparseArray<ArraySet<ManagedServices.ManagedServiceInfo>> mListenersDisablingEffects = new SparseArray();
    private List<ComponentName> mEffectsSuppressors = new ArrayList<ComponentName>();
    private int mListenerHints;
    private int mInterruptionFilter = 0;
    private boolean mScreenOn = true;
    protected boolean mInCall = false;
    private boolean mNotificationPulseEnabled;
    private Uri mInCallNotificationUri;
    private AudioAttributes mInCallNotificationAudioAttributes;
    private float mInCallNotificationVolume;
    final Object mNotificationLock = new Object();
    @GuardedBy(value="mNotificationLock")
    final ArrayList<NotificationRecord> mNotificationList = new ArrayList();
    @GuardedBy(value="mNotificationLock")
    final ArrayMap<String, NotificationRecord> mNotificationsByKey = new ArrayMap();
    @GuardedBy(value="mNotificationLock")
    final ArrayList<NotificationRecord> mEnqueuedNotifications = new ArrayList();
    @GuardedBy(value="mNotificationLock")
    final ArrayMap<Integer, ArrayMap<String, String>> mAutobundledSummaries = new ArrayMap();
    final ArrayList<ToastRecord> mToastQueue = new ArrayList();
    final ArrayMap<String, NotificationRecord> mSummaryByGroupKey = new ArrayMap();
    ArrayList<String> mLights = new ArrayList();
    private AppOpsManager mAppOps;
    private UsageStatsManagerInternal mAppUsageStats;
    private Archive mArchive;
    private AtomicFile mPolicyFile;
    private static final int DB_VERSION = 1;
    private static final String TAG_NOTIFICATION_POLICY = "notification-policy";
    private static final String ATTR_VERSION = "version";
    private RankingHelper mRankingHelper;
    private final ManagedServices.UserProfiles mUserProfiles = new ManagedServices.UserProfiles();
    private NotificationListeners mListeners;
    private NotificationAssistants mAssistants;
    private ConditionProviders mConditionProviders;
    private NotificationUsageStats mUsageStats;
    private static final int MY_UID = Process.myUid();
    private static final int MY_PID = Process.myPid();
    private static final IBinder WHITELIST_TOKEN = new Binder();
    private RankingHandler mRankingHandler;
    private long mLastOverRateLogTime;
    private float mMaxPackageEnqueueRate = 5.0f;
    private SnoozeHelper mSnoozeHelper;
    private GroupHelper mGroupHelper;
    private boolean mIsTelevision;
    final NotificationDelegate mNotificationDelegate = new NotificationDelegate(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSetDisabled(int status) {
            Object object = NotificationManagerService.this.mNotificationLock;
            synchronized (object) {
                NotificationManagerService.this.mDisableNotificationEffects = (status & 0x40000) != 0;
                if (NotificationManagerService.this.disableNotificationEffects(null) != null) {
                    long identity = Binder.clearCallingIdentity();
                    try {
                        IRingtonePlayer player = NotificationManagerService.this.mAudioManager.getRingtonePlayer();
                        if (player != null) {
                            player.stopAsync();
                        }
                    }
                    catch (RemoteException remoteException) {
                    }
                    finally {
                        Binder.restoreCallingIdentity(identity);
                    }
                    identity = Binder.clearCallingIdentity();
                    try {
                        NotificationManagerService.this.mVibrator.cancel();
                    }
                    finally {
                        Binder.restoreCallingIdentity(identity);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onClearAll(int callingUid, int callingPid, int userId) {
            Object object = NotificationManagerService.this.mNotificationLock;
            synchronized (object) {
                NotificationManagerService.this.cancelAllLocked(callingUid, callingPid, userId, 3, null, true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNotificationClick(int callingUid, int callingPid, String key) {
            Object object = NotificationManagerService.this.mNotificationLock;
            synchronized (object) {
                NotificationRecord r = NotificationManagerService.this.mNotificationsByKey.get(key);
                if (r == null) {
                    Log.w(NotificationManagerService.TAG, "No notification with key: " + key);
                    return;
                }
                long now = System.currentTimeMillis();
                MetricsLogger.action(r.getLogMaker(now).setCategory(128).setType(4));
                EventLogTags.writeNotificationClicked(key, r.getLifespanMs(now), r.getFreshnessMs(now), r.getExposureMs(now));
                StatusBarNotification sbn = r.sbn;
                NotificationManagerService.this.cancelNotification(callingUid, callingPid, sbn.getPackageName(), sbn.getTag(), sbn.getId(), 16, 64, false, r.getUserId(), 1, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNotificationActionClick(int callingUid, int callingPid, String key, int actionIndex) {
            Object object = NotificationManagerService.this.mNotificationLock;
            synchronized (object) {
                NotificationRecord r = NotificationManagerService.this.mNotificationsByKey.get(key);
                if (r == null) {
                    Log.w(NotificationManagerService.TAG, "No notification with key: " + key);
                    return;
                }
                long now = System.currentTimeMillis();
                MetricsLogger.action(r.getLogMaker(now).setCategory(129).setType(4).setSubtype(actionIndex));
                EventLogTags.writeNotificationActionClicked(key, actionIndex, r.getLifespanMs(now), r.getFreshnessMs(now), r.getExposureMs(now));
            }
        }

        @Override
        public void onNotificationClear(int callingUid, int callingPid, String pkg, String tag, int id2, int userId) {
            NotificationManagerService.this.cancelNotification(callingUid, callingPid, pkg, tag, id2, 0, 66, true, userId, 2, null);
        }

        @Override
        public void onPanelRevealed(boolean clearEffects, int items) {
            MetricsLogger.visible(NotificationManagerService.this.getContext(), 127);
            MetricsLogger.histogram(NotificationManagerService.this.getContext(), "note_load", items);
            EventLogTags.writeNotificationPanelRevealed(items);
            if (clearEffects) {
                this.clearEffects();
            }
        }

        @Override
        public void onPanelHidden() {
            MetricsLogger.hidden(NotificationManagerService.this.getContext(), 127);
            EventLogTags.writeNotificationPanelHidden();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clearEffects() {
            Object object = NotificationManagerService.this.mNotificationLock;
            synchronized (object) {
                if (DBG) {
                    Slog.d(NotificationManagerService.TAG, "clearEffects");
                }
                NotificationManagerService.this.clearSoundLocked();
                NotificationManagerService.this.clearVibrateLocked();
                NotificationManagerService.this.clearLightsLocked();
            }
        }

        @Override
        public void onNotificationError(int callingUid, int callingPid, String pkg, String tag, int id2, int uid, int initialPid, String message, int userId) {
            Slog.d(NotificationManagerService.TAG, "onNotification error pkg=" + pkg + " tag=" + tag + " id=" + id2 + "; will crashApplication(uid=" + uid + ", pid=" + initialPid + ")");
            NotificationManagerService.this.cancelNotification(callingUid, callingPid, pkg, tag, id2, 0, 0, false, userId, 4, null);
            long ident = Binder.clearCallingIdentity();
            try {
                ActivityManager.getService().crashApplication(uid, initialPid, pkg, -1, "Bad notification posted from package " + pkg + ": " + message);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            Binder.restoreCallingIdentity(ident);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNotificationVisibilityChanged(NotificationVisibility[] newlyVisibleKeys, NotificationVisibility[] noLongerVisibleKeys) {
            Object object = NotificationManagerService.this.mNotificationLock;
            synchronized (object) {
                NotificationRecord r;
                for (NotificationVisibility nv : newlyVisibleKeys) {
                    r = NotificationManagerService.this.mNotificationsByKey.get(nv.key);
                    if (r == null) continue;
                    r.setVisibility(true, nv.rank);
                    nv.recycle();
                }
                for (NotificationVisibility nv : noLongerVisibleKeys) {
                    r = NotificationManagerService.this.mNotificationsByKey.get(nv.key);
                    if (r == null) continue;
                    r.setVisibility(false, nv.rank);
                    nv.recycle();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNotificationExpansionChanged(String key, boolean userAction, boolean expanded) {
            Object object = NotificationManagerService.this.mNotificationLock;
            synchronized (object) {
                NotificationRecord r = NotificationManagerService.this.mNotificationsByKey.get(key);
                if (r != null) {
                    r.stats.onExpansionChanged(userAction, expanded);
                    long now = System.currentTimeMillis();
                    if (userAction) {
                        MetricsLogger.action(r.getLogMaker(now).setCategory(128).setType(expanded ? 3 : 14));
                    }
                    EventLogTags.writeNotificationExpansion(key, userAction ? 1 : 0, expanded ? 1 : 0, r.getLifespanMs(now), r.getFreshnessMs(now), r.getExposureMs(now));
                }
            }
        }
    };
    protected final BroadcastReceiver mLocaleChangeReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            if ("android.intent.action.LOCALE_CHANGED".equals(intent.getAction())) {
                NotificationManagerService.this.mZenModeHelper.updateDefaultZenRules();
                NotificationManagerService.this.mRankingHelper.onLocaleChanged(context, ActivityManager.getCurrentUser());
            }
        }
    };
    private final BroadcastReceiver mRestoreReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            if ("android.os.action.SETTING_RESTORED".equals(intent.getAction())) {
                try {
                    String element = intent.getStringExtra("setting_name");
                    String newValue = intent.getStringExtra("new_value");
                    int restoredFromSdkInt = intent.getIntExtra("restored_from_sdk_int", 0);
                    NotificationManagerService.this.mListeners.onSettingRestored(element, newValue, restoredFromSdkInt, this.getSendingUserId());
                    NotificationManagerService.this.mConditionProviders.onSettingRestored(element, newValue, restoredFromSdkInt, this.getSendingUserId());
                }
                catch (Exception e) {
                    Slog.wtf(NotificationManagerService.TAG, "Cannot restore managed services from settings", e);
                }
            }
        }
    };
    private final BroadcastReceiver mNotificationTimeoutReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (action == null) {
                return;
            }
            if (ACTION_NOTIFICATION_TIMEOUT.equals(action)) {
                NotificationRecord record;
                Object object = NotificationManagerService.this.mNotificationLock;
                synchronized (object) {
                    record = NotificationManagerService.this.findNotificationByKeyLocked(intent.getStringExtra(NotificationManagerService.EXTRA_KEY));
                }
                if (record != null) {
                    NotificationManagerService.this.cancelNotification(record.sbn.getUid(), record.sbn.getInitialPid(), record.sbn.getPackageName(), record.sbn.getTag(), record.sbn.getId(), 0, 64, true, record.getUserId(), 19, null);
                }
            }
        }
    };
    private final BroadcastReceiver mPackageIntentReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (action == null) {
                return;
            }
            boolean queryRestart = false;
            boolean queryRemove = false;
            boolean packageChanged = false;
            boolean cancelNotifications = true;
            int reason = 5;
            if (action.equals("android.intent.action.PACKAGE_ADDED") || (queryRemove = action.equals("android.intent.action.PACKAGE_REMOVED")) || action.equals("android.intent.action.PACKAGE_RESTARTED") || (packageChanged = action.equals("android.intent.action.PACKAGE_CHANGED")) || (queryRestart = action.equals("android.intent.action.QUERY_PACKAGE_RESTART")) || action.equals("android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE") || action.equals("android.intent.action.PACKAGES_SUSPENDED")) {
                boolean removingPackage;
                int changeUserId = intent.getIntExtra("android.intent.extra.user_handle", -1);
                String[] pkgList = null;
                int[] uidList = null;
                boolean bl = removingPackage = queryRemove && !intent.getBooleanExtra("android.intent.extra.REPLACING", false);
                if (DBG) {
                    Slog.i(NotificationManagerService.TAG, "action=" + action + " removing=" + removingPackage);
                }
                if (action.equals("android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE")) {
                    pkgList = intent.getStringArrayExtra("android.intent.extra.changed_package_list");
                    uidList = intent.getIntArrayExtra("android.intent.extra.changed_uid_list");
                } else if (action.equals("android.intent.action.PACKAGES_SUSPENDED")) {
                    pkgList = intent.getStringArrayExtra("android.intent.extra.changed_package_list");
                    reason = 14;
                } else if (queryRestart) {
                    pkgList = intent.getStringArrayExtra("android.intent.extra.PACKAGES");
                    uidList = new int[]{intent.getIntExtra("android.intent.extra.UID", -1)};
                } else {
                    Uri uri = intent.getData();
                    if (uri == null) {
                        return;
                    }
                    String pkgName = uri.getSchemeSpecificPart();
                    if (pkgName == null) {
                        return;
                    }
                    if (packageChanged) {
                        try {
                            int enabled = NotificationManagerService.this.mPackageManager.getApplicationEnabledSetting(pkgName, changeUserId != -1 ? changeUserId : 0);
                            if (enabled == 1 || enabled == 0) {
                                cancelNotifications = false;
                            }
                        }
                        catch (IllegalArgumentException e) {
                            if (DBG) {
                                Slog.i(NotificationManagerService.TAG, "Exception trying to look up app enabled setting", e);
                            }
                        }
                        catch (RemoteException remoteException) {
                            // empty catch block
                        }
                    }
                    pkgList = new String[]{pkgName};
                    uidList = new int[]{intent.getIntExtra("android.intent.extra.UID", -1)};
                }
                if (pkgList != null && pkgList.length > 0) {
                    for (String pkgName : pkgList) {
                        if (!cancelNotifications) continue;
                        NotificationManagerService.this.cancelAllNotificationsInt(MY_UID, MY_PID, pkgName, null, 0, 0, !queryRestart, changeUserId, reason, null);
                    }
                }
                NotificationManagerService.this.mListeners.onPackagesChanged(removingPackage, pkgList, uidList);
                NotificationManagerService.this.mAssistants.onPackagesChanged(removingPackage, pkgList, uidList);
                NotificationManagerService.this.mConditionProviders.onPackagesChanged(removingPackage, pkgList, uidList);
                NotificationManagerService.this.mRankingHelper.onPackagesChanged(removingPackage, changeUserId, pkgList, uidList);
                NotificationManagerService.this.savePolicyFile();
            }
        }
    };
    private final BroadcastReceiver mIntentReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (action.equals("android.intent.action.SCREEN_ON")) {
                NotificationManagerService.this.mScreenOn = true;
                NotificationManagerService.this.updateNotificationPulse();
            } else if (action.equals("android.intent.action.SCREEN_OFF")) {
                NotificationManagerService.this.mScreenOn = false;
                NotificationManagerService.this.updateNotificationPulse();
            } else if (action.equals("android.intent.action.PHONE_STATE")) {
                NotificationManagerService.this.mInCall = TelephonyManager.EXTRA_STATE_OFFHOOK.equals(intent.getStringExtra("state"));
                NotificationManagerService.this.updateNotificationPulse();
            } else if (action.equals("android.intent.action.USER_STOPPED")) {
                int userHandle = intent.getIntExtra("android.intent.extra.user_handle", -1);
                if (userHandle >= 0) {
                    NotificationManagerService.this.cancelAllNotificationsInt(MY_UID, MY_PID, null, null, 0, 0, true, userHandle, 6, null);
                }
            } else if (action.equals("android.intent.action.MANAGED_PROFILE_UNAVAILABLE")) {
                int userHandle = intent.getIntExtra("android.intent.extra.user_handle", -1);
                if (userHandle >= 0) {
                    NotificationManagerService.this.cancelAllNotificationsInt(MY_UID, MY_PID, null, null, 0, 0, true, userHandle, 15, null);
                }
            } else if (action.equals("android.intent.action.USER_PRESENT")) {
                NotificationManagerService.this.mNotificationLight.turnOff();
            } else if (action.equals("android.intent.action.USER_SWITCHED")) {
                int user = intent.getIntExtra("android.intent.extra.user_handle", -10000);
                NotificationManagerService.this.mSettingsObserver.update(null);
                NotificationManagerService.this.mUserProfiles.updateCache(context);
                NotificationManagerService.this.mConditionProviders.onUserSwitched(user);
                NotificationManagerService.this.mListeners.onUserSwitched(user);
                NotificationManagerService.this.mAssistants.onUserSwitched(user);
                NotificationManagerService.this.mZenModeHelper.onUserSwitched(user);
            } else if (action.equals("android.intent.action.USER_ADDED")) {
                int userId = intent.getIntExtra("android.intent.extra.user_handle", -10000);
                if (userId != -10000) {
                    NotificationManagerService.this.mUserProfiles.updateCache(context);
                    if (!NotificationManagerService.this.mUserProfiles.isManagedProfile(userId)) {
                        NotificationManagerService.this.readDefaultApprovedServices(userId);
                    }
                }
            } else if (action.equals("android.intent.action.USER_REMOVED")) {
                int user = intent.getIntExtra("android.intent.extra.user_handle", -10000);
                NotificationManagerService.this.mZenModeHelper.onUserRemoved(user);
                NotificationManagerService.this.mRankingHelper.onUserRemoved(user);
                NotificationManagerService.this.mListeners.onUserRemoved(user);
                NotificationManagerService.this.mConditionProviders.onUserRemoved(user);
                NotificationManagerService.this.mAssistants.onUserRemoved(user);
                NotificationManagerService.this.savePolicyFile();
            } else if (action.equals("android.intent.action.USER_UNLOCKED")) {
                int user = intent.getIntExtra("android.intent.extra.user_handle", -10000);
                NotificationManagerService.this.mConditionProviders.onUserUnlocked(user);
                NotificationManagerService.this.mListeners.onUserUnlocked(user);
                NotificationManagerService.this.mAssistants.onUserUnlocked(user);
                NotificationManagerService.this.mZenModeHelper.onUserUnlocked(user);
            }
        }
    };
    private SettingsObserver mSettingsObserver;
    protected ZenModeHelper mZenModeHelper;
    private final IBinder mService = new INotificationManager.Stub(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void enqueueToast(String pkg, ITransientNotification callback, int duration) {
            if (DBG) {
                Slog.i(NotificationManagerService.TAG, "enqueueToast pkg=" + pkg + " callback=" + callback + " duration=" + duration);
            }
            if (pkg == null || callback == null) {
                Slog.e(NotificationManagerService.TAG, "Not doing toast. pkg=" + pkg + " callback=" + callback);
                return;
            }
            boolean isSystemToast = NotificationManagerService.this.isCallerSystemOrPhone() || "android".equals(pkg);
            boolean isPackageSuspended = NotificationManagerService.this.isPackageSuspendedForUser(pkg, Binder.getCallingUid());
            if (!(isSystemToast || this.areNotificationsEnabledForPackage(pkg, Binder.getCallingUid()) && !isPackageSuspended)) {
                Slog.e(NotificationManagerService.TAG, "Suppressing toast from package " + pkg + (isPackageSuspended ? " due to package suspended by administrator." : " by user request."));
                return;
            }
            ArrayList<ToastRecord> arrayList = NotificationManagerService.this.mToastQueue;
            synchronized (arrayList) {
                int callingPid = Binder.getCallingPid();
                long callingId = Binder.clearCallingIdentity();
                try {
                    int index = !isSystemToast ? NotificationManagerService.this.indexOfToastPackageLocked(pkg) : NotificationManagerService.this.indexOfToastLocked(pkg, callback);
                    if (index >= 0) {
                        ToastRecord record = NotificationManagerService.this.mToastQueue.get(index);
                        record.update(duration);
                        record.update(callback);
                    } else {
                        Binder token = new Binder();
                        NotificationManagerService.this.mWindowManagerInternal.addWindowToken(token, 2005, 0);
                        ToastRecord record = new ToastRecord(callingPid, pkg, callback, duration, token);
                        NotificationManagerService.this.mToastQueue.add(record);
                        index = NotificationManagerService.this.mToastQueue.size() - 1;
                    }
                    NotificationManagerService.this.keepProcessAliveIfNeededLocked(callingPid);
                    if (index == 0) {
                        NotificationManagerService.this.showNextToastLocked();
                    }
                }
                finally {
                    Binder.restoreCallingIdentity(callingId);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancelToast(String pkg, ITransientNotification callback) {
            Slog.i(NotificationManagerService.TAG, "cancelToast pkg=" + pkg + " callback=" + callback);
            if (pkg == null || callback == null) {
                Slog.e(NotificationManagerService.TAG, "Not cancelling notification. pkg=" + pkg + " callback=" + callback);
                return;
            }
            ArrayList<ToastRecord> arrayList = NotificationManagerService.this.mToastQueue;
            synchronized (arrayList) {
                long callingId = Binder.clearCallingIdentity();
                try {
                    int index = NotificationManagerService.this.indexOfToastLocked(pkg, callback);
                    if (index >= 0) {
                        NotificationManagerService.this.cancelToastLocked(index);
                    } else {
                        Slog.w(NotificationManagerService.TAG, "Toast already cancelled. pkg=" + pkg + " callback=" + callback);
                    }
                }
                finally {
                    Binder.restoreCallingIdentity(callingId);
                }
            }
        }

        @Override
        public void enqueueNotificationWithTag(String pkg, String opPkg, String tag, int id2, Notification notification, int userId) throws RemoteException {
            NotificationManagerService.this.enqueueNotificationInternal(pkg, opPkg, Binder.getCallingUid(), Binder.getCallingPid(), tag, id2, notification, userId);
        }

        @Override
        public void cancelNotificationWithTag(String pkg, String tag, int id2, int userId) {
            NotificationManagerService.this.checkCallerIsSystemOrSameApp(pkg);
            userId = ActivityManager.handleIncomingUser(Binder.getCallingPid(), Binder.getCallingUid(), userId, true, false, "cancelNotificationWithTag", pkg);
            int mustNotHaveFlags = NotificationManagerService.this.isCallingUidSystem() ? 0 : 1088;
            NotificationManagerService.this.cancelNotification(Binder.getCallingUid(), Binder.getCallingPid(), pkg, tag, id2, 0, mustNotHaveFlags, false, userId, 8, null);
        }

        @Override
        public void cancelAllNotifications(String pkg, int userId) {
            NotificationManagerService.this.checkCallerIsSystemOrSameApp(pkg);
            userId = ActivityManager.handleIncomingUser(Binder.getCallingPid(), Binder.getCallingUid(), userId, true, false, "cancelAllNotifications", pkg);
            NotificationManagerService.this.cancelAllNotificationsInt(Binder.getCallingUid(), Binder.getCallingPid(), pkg, null, 0, 64, true, userId, 9, null);
        }

        @Override
        public void setNotificationsEnabledForPackage(String pkg, int uid, boolean enabled) {
            NotificationManagerService.this.checkCallerIsSystem();
            NotificationManagerService.this.mRankingHelper.setEnabled(pkg, uid, enabled);
            if (!enabled) {
                NotificationManagerService.this.cancelAllNotificationsInt(MY_UID, MY_PID, pkg, null, 0, 0, true, UserHandle.getUserId(uid), 7, null);
            }
            NotificationManagerService.this.savePolicyFile();
        }

        @Override
        public boolean areNotificationsEnabled(String pkg) {
            return this.areNotificationsEnabledForPackage(pkg, Binder.getCallingUid());
        }

        @Override
        public boolean areNotificationsEnabledForPackage(String pkg, int uid) {
            NotificationManagerService.this.checkCallerIsSystemOrSameApp(pkg);
            return NotificationManagerService.this.mRankingHelper.getImportance(pkg, uid) != 0;
        }

        @Override
        public int getPackageImportance(String pkg) {
            NotificationManagerService.this.checkCallerIsSystemOrSameApp(pkg);
            return NotificationManagerService.this.mRankingHelper.getImportance(pkg, Binder.getCallingUid());
        }

        @Override
        public boolean canShowBadge(String pkg, int uid) {
            NotificationManagerService.this.checkCallerIsSystem();
            return NotificationManagerService.this.mRankingHelper.canShowBadge(pkg, uid);
        }

        @Override
        public void setShowBadge(String pkg, int uid, boolean showBadge) {
            NotificationManagerService.this.checkCallerIsSystem();
            NotificationManagerService.this.mRankingHelper.setShowBadge(pkg, uid, showBadge);
            NotificationManagerService.this.savePolicyFile();
        }

        @Override
        public void createNotificationChannelGroups(String pkg, ParceledListSlice channelGroupList) throws RemoteException {
            NotificationManagerService.this.checkCallerIsSystemOrSameApp(pkg);
            List groups = channelGroupList.getList();
            int groupSize = groups.size();
            for (int i = 0; i < groupSize; ++i) {
                NotificationChannelGroup group = (NotificationChannelGroup)groups.get(i);
                Preconditions.checkNotNull(group, "group in list is null");
                NotificationManagerService.this.mRankingHelper.createNotificationChannelGroup(pkg, Binder.getCallingUid(), group, true);
                NotificationManagerService.this.mListeners.notifyNotificationChannelGroupChanged(pkg, UserHandle.of(UserHandle.getCallingUserId()), group, 1);
            }
            NotificationManagerService.this.savePolicyFile();
        }

        private void createNotificationChannelsImpl(String pkg, int uid, ParceledListSlice channelsList) {
            List channels = channelsList.getList();
            int channelsSize = channels.size();
            for (int i = 0; i < channelsSize; ++i) {
                NotificationChannel channel = (NotificationChannel)channels.get(i);
                Preconditions.checkNotNull(channel, "channel in list is null");
                NotificationManagerService.this.mRankingHelper.createNotificationChannel(pkg, uid, channel, true);
                NotificationManagerService.this.mListeners.notifyNotificationChannelChanged(pkg, UserHandle.getUserHandleForUid(uid), NotificationManagerService.this.mRankingHelper.getNotificationChannel(pkg, uid, channel.getId(), false), 1);
            }
            NotificationManagerService.this.savePolicyFile();
        }

        @Override
        public void createNotificationChannels(String pkg, ParceledListSlice channelsList) throws RemoteException {
            NotificationManagerService.this.checkCallerIsSystemOrSameApp(pkg);
            this.createNotificationChannelsImpl(pkg, Binder.getCallingUid(), channelsList);
        }

        @Override
        public void createNotificationChannelsForPackage(String pkg, int uid, ParceledListSlice channelsList) throws RemoteException {
            NotificationManagerService.this.checkCallerIsSystem();
            this.createNotificationChannelsImpl(pkg, uid, channelsList);
        }

        @Override
        public NotificationChannel getNotificationChannel(String pkg, String channelId) {
            NotificationManagerService.this.checkCallerIsSystemOrSameApp(pkg);
            return NotificationManagerService.this.mRankingHelper.getNotificationChannel(pkg, Binder.getCallingUid(), channelId, false);
        }

        @Override
        public NotificationChannel getNotificationChannelForPackage(String pkg, int uid, String channelId, boolean includeDeleted) {
            NotificationManagerService.this.checkCallerIsSystem();
            return NotificationManagerService.this.mRankingHelper.getNotificationChannel(pkg, uid, channelId, includeDeleted);
        }

        @Override
        public void deleteNotificationChannel(String pkg, String channelId) {
            NotificationManagerService.this.checkCallerIsSystemOrSameApp(pkg);
            int callingUid = Binder.getCallingUid();
            if ("miscellaneous".equals(channelId)) {
                throw new IllegalArgumentException("Cannot delete default channel");
            }
            NotificationManagerService.this.cancelAllNotificationsInt(MY_UID, MY_PID, pkg, channelId, 0, 0, true, UserHandle.getUserId(callingUid), 17, null);
            NotificationManagerService.this.mRankingHelper.deleteNotificationChannel(pkg, callingUid, channelId);
            NotificationManagerService.this.mListeners.notifyNotificationChannelChanged(pkg, UserHandle.getUserHandleForUid(callingUid), NotificationManagerService.this.mRankingHelper.getNotificationChannel(pkg, callingUid, channelId, true), 3);
            NotificationManagerService.this.savePolicyFile();
        }

        @Override
        public ParceledListSlice<NotificationChannelGroup> getNotificationChannelGroups(String pkg) {
            NotificationManagerService.this.checkCallerIsSystemOrSameApp(pkg);
            return new ParceledListSlice<NotificationChannelGroup>(new ArrayList<NotificationChannelGroup>(NotificationManagerService.this.mRankingHelper.getNotificationChannelGroups(pkg, Binder.getCallingUid())));
        }

        @Override
        public void deleteNotificationChannelGroup(String pkg, String groupId) {
            NotificationManagerService.this.checkCallerIsSystemOrSameApp(pkg);
            int callingUid = Binder.getCallingUid();
            NotificationChannelGroup groupToDelete = NotificationManagerService.this.mRankingHelper.getNotificationChannelGroup(groupId, pkg, callingUid);
            if (groupToDelete != null) {
                List<NotificationChannel> deletedChannels = NotificationManagerService.this.mRankingHelper.deleteNotificationChannelGroup(pkg, callingUid, groupId);
                for (int i = 0; i < deletedChannels.size(); ++i) {
                    NotificationChannel deletedChannel = deletedChannels.get(i);
                    NotificationManagerService.this.cancelAllNotificationsInt(MY_UID, MY_PID, pkg, deletedChannel.getId(), 0, 0, true, UserHandle.getUserId(Binder.getCallingUid()), 17, null);
                    NotificationManagerService.this.mListeners.notifyNotificationChannelChanged(pkg, UserHandle.getUserHandleForUid(callingUid), deletedChannel, 3);
                }
                NotificationManagerService.this.mListeners.notifyNotificationChannelGroupChanged(pkg, UserHandle.getUserHandleForUid(callingUid), groupToDelete, 3);
                NotificationManagerService.this.savePolicyFile();
            }
        }

        @Override
        public void updateNotificationChannelForPackage(String pkg, int uid, NotificationChannel channel) {
            this.enforceSystemOrSystemUI("Caller not system or systemui");
            Preconditions.checkNotNull(channel);
            NotificationManagerService.this.updateNotificationChannelInt(pkg, uid, channel, false);
        }

        @Override
        public ParceledListSlice<NotificationChannel> getNotificationChannelsForPackage(String pkg, int uid, boolean includeDeleted) {
            this.enforceSystemOrSystemUI("getNotificationChannelsForPackage");
            return NotificationManagerService.this.mRankingHelper.getNotificationChannels(pkg, uid, includeDeleted);
        }

        @Override
        public int getNumNotificationChannelsForPackage(String pkg, int uid, boolean includeDeleted) {
            this.enforceSystemOrSystemUI("getNumNotificationChannelsForPackage");
            return NotificationManagerService.this.mRankingHelper.getNotificationChannels(pkg, uid, includeDeleted).getList().size();
        }

        @Override
        public boolean onlyHasDefaultChannel(String pkg, int uid) {
            this.enforceSystemOrSystemUI("onlyHasDefaultChannel");
            return NotificationManagerService.this.mRankingHelper.onlyHasDefaultChannel(pkg, uid);
        }

        @Override
        public int getDeletedChannelCount(String pkg, int uid) {
            this.enforceSystemOrSystemUI("getDeletedChannelCount");
            return NotificationManagerService.this.mRankingHelper.getDeletedChannelCount(pkg, uid);
        }

        @Override
        public ParceledListSlice<NotificationChannelGroup> getNotificationChannelGroupsForPackage(String pkg, int uid, boolean includeDeleted) {
            NotificationManagerService.this.checkCallerIsSystem();
            return NotificationManagerService.this.mRankingHelper.getNotificationChannelGroups(pkg, uid, includeDeleted);
        }

        @Override
        public NotificationChannelGroup getNotificationChannelGroupForPackage(String groupId, String pkg, int uid) {
            this.enforceSystemOrSystemUI("getNotificationChannelGroupForPackage");
            return NotificationManagerService.this.mRankingHelper.getNotificationChannelGroup(groupId, pkg, uid);
        }

        @Override
        public ParceledListSlice<NotificationChannel> getNotificationChannels(String pkg) {
            NotificationManagerService.this.checkCallerIsSystemOrSameApp(pkg);
            return NotificationManagerService.this.mRankingHelper.getNotificationChannels(pkg, Binder.getCallingUid(), false);
        }

        @Override
        public void clearData(String packageName, int uid, boolean fromApp) throws RemoteException {
            NotificationManagerService.this.checkCallerIsSystem();
            NotificationManagerService.this.cancelAllNotificationsInt(MY_UID, MY_PID, packageName, null, 0, 0, true, UserHandle.getUserId(Binder.getCallingUid()), 17, null);
            String[] packages = new String[]{packageName};
            int[] uids = new int[]{uid};
            NotificationManagerService.this.mListeners.onPackagesChanged(true, packages, uids);
            NotificationManagerService.this.mAssistants.onPackagesChanged(true, packages, uids);
            NotificationManagerService.this.mConditionProviders.onPackagesChanged(true, packages, uids);
            if (!fromApp) {
                NotificationManagerService.this.mRankingHelper.onPackagesChanged(true, UserHandle.getCallingUserId(), packages, uids);
            }
            NotificationManagerService.this.savePolicyFile();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public StatusBarNotification[] getActiveNotifications(String callingPkg) {
            NotificationManagerService.this.getContext().enforceCallingOrSelfPermission("android.permission.ACCESS_NOTIFICATIONS", "NotificationManagerService.getActiveNotifications");
            StatusBarNotification[] tmp = null;
            int uid = Binder.getCallingUid();
            if (NotificationManagerService.this.mAppOps.noteOpNoThrow(25, uid, callingPkg) == 0) {
                Object object = NotificationManagerService.this.mNotificationLock;
                synchronized (object) {
                    tmp = new StatusBarNotification[NotificationManagerService.this.mNotificationList.size()];
                    int N = NotificationManagerService.this.mNotificationList.size();
                    for (int i = 0; i < N; ++i) {
                        tmp[i] = NotificationManagerService.this.mNotificationList.get((int)i).sbn;
                    }
                }
            }
            return tmp;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ParceledListSlice<StatusBarNotification> getAppActiveNotifications(String pkg, int incomingUserId) {
            NotificationManagerService.this.checkCallerIsSystemOrSameApp(pkg);
            int userId = ActivityManager.handleIncomingUser(Binder.getCallingPid(), Binder.getCallingUid(), incomingUserId, true, false, "getAppActiveNotifications", pkg);
            Object object = NotificationManagerService.this.mNotificationLock;
            synchronized (object) {
                StatusBarNotification sbn;
                ArrayMap<String, StatusBarNotification> map = new ArrayMap<String, StatusBarNotification>(NotificationManagerService.this.mNotificationList.size() + NotificationManagerService.this.mEnqueuedNotifications.size());
                int N = NotificationManagerService.this.mNotificationList.size();
                for (int i = 0; i < N; ++i) {
                    StatusBarNotification sbn2 = this.sanitizeSbn(pkg, userId, NotificationManagerService.this.mNotificationList.get((int)i).sbn);
                    if (sbn2 == null) continue;
                    map.put(sbn2.getKey(), sbn2);
                }
                for (NotificationRecord snoozed : NotificationManagerService.this.mSnoozeHelper.getSnoozed(userId, pkg)) {
                    sbn = this.sanitizeSbn(pkg, userId, snoozed.sbn);
                    if (sbn == null) continue;
                    map.put(sbn.getKey(), sbn);
                }
                int M = NotificationManagerService.this.mEnqueuedNotifications.size();
                for (int i = 0; i < M; ++i) {
                    sbn = this.sanitizeSbn(pkg, userId, NotificationManagerService.this.mEnqueuedNotifications.get((int)i).sbn);
                    if (sbn == null) continue;
                    map.put(sbn.getKey(), sbn);
                }
                ArrayList list = new ArrayList(map.size());
                list.addAll(map.values());
                return new ParceledListSlice<StatusBarNotification>(list);
            }
        }

        private StatusBarNotification sanitizeSbn(String pkg, int userId, StatusBarNotification sbn) {
            if (sbn.getPackageName().equals(pkg) && sbn.getUserId() == userId) {
                return new StatusBarNotification(sbn.getPackageName(), sbn.getOpPkg(), sbn.getId(), sbn.getTag(), sbn.getUid(), sbn.getInitialPid(), sbn.getNotification().clone(), sbn.getUser(), sbn.getOverrideGroupKey(), sbn.getPostTime());
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public StatusBarNotification[] getHistoricalNotifications(String callingPkg, int count) {
            NotificationManagerService.this.getContext().enforceCallingOrSelfPermission("android.permission.ACCESS_NOTIFICATIONS", "NotificationManagerService.getHistoricalNotifications");
            StatusBarNotification[] tmp = null;
            int uid = Binder.getCallingUid();
            if (NotificationManagerService.this.mAppOps.noteOpNoThrow(25, uid, callingPkg) == 0) {
                Archive archive = NotificationManagerService.this.mArchive;
                synchronized (archive) {
                    tmp = NotificationManagerService.this.mArchive.getArray(count);
                }
            }
            return tmp;
        }

        @Override
        public void registerListener(INotificationListener listener, ComponentName component, int userid) {
            this.enforceSystemOrSystemUI("INotificationManager.registerListener");
            NotificationManagerService.this.mListeners.registerService(listener, component, userid);
        }

        @Override
        public void unregisterListener(INotificationListener token, int userid) {
            NotificationManagerService.this.mListeners.unregisterService(token, userid);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancelNotificationsFromListener(INotificationListener token, String[] keys) {
            int callingUid = Binder.getCallingUid();
            int callingPid = Binder.getCallingPid();
            long identity = Binder.clearCallingIdentity();
            try {
                Object object = NotificationManagerService.this.mNotificationLock;
                synchronized (object) {
                    ManagedServices.ManagedServiceInfo info = NotificationManagerService.this.mListeners.checkServiceTokenLocked(token);
                    if (keys != null) {
                        int N = keys.length;
                        for (int i = 0; i < N; ++i) {
                            NotificationRecord r = NotificationManagerService.this.mNotificationsByKey.get(keys[i]);
                            if (r == null) continue;
                            int userId = r.sbn.getUserId();
                            if (userId != info.userid && userId != -1 && !NotificationManagerService.this.mUserProfiles.isCurrentProfile(userId)) {
                                throw new SecurityException("Disallowed call from listener: " + info.service);
                            }
                            this.cancelNotificationFromListenerLocked(info, callingUid, callingPid, r.sbn.getPackageName(), r.sbn.getTag(), r.sbn.getId(), userId);
                        }
                    } else {
                        NotificationManagerService.this.cancelAllLocked(callingUid, callingPid, info.userid, 11, info, info.supportsProfiles());
                    }
                }
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void requestBindListener(ComponentName component) {
            NotificationManagerService.this.checkCallerIsSystemOrSameApp(component.getPackageName());
            long identity = Binder.clearCallingIdentity();
            try {
                ManagedServices manager = NotificationManagerService.this.mAssistants.isComponentEnabledForCurrentProfiles(component) ? NotificationManagerService.this.mAssistants : NotificationManagerService.this.mListeners;
                manager.setComponentState(component, true);
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void requestUnbindListener(INotificationListener token) {
            long identity = Binder.clearCallingIdentity();
            try {
                Object object = NotificationManagerService.this.mNotificationLock;
                synchronized (object) {
                    ManagedServices.ManagedServiceInfo info = NotificationManagerService.this.mListeners.checkServiceTokenLocked(token);
                    info.getOwner().setComponentState(info.component, false);
                }
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setNotificationsShownFromListener(INotificationListener token, String[] keys) {
            long identity = Binder.clearCallingIdentity();
            try {
                Object object = NotificationManagerService.this.mNotificationLock;
                synchronized (object) {
                    ManagedServices.ManagedServiceInfo info = NotificationManagerService.this.mListeners.checkServiceTokenLocked(token);
                    if (keys != null) {
                        int N = keys.length;
                        for (int i = 0; i < N; ++i) {
                            NotificationRecord r = NotificationManagerService.this.mNotificationsByKey.get(keys[i]);
                            if (r == null) continue;
                            int userId = r.sbn.getUserId();
                            if (userId != info.userid && userId != -1 && !NotificationManagerService.this.mUserProfiles.isCurrentProfile(userId)) {
                                throw new SecurityException("Disallowed call from listener: " + info.service);
                            }
                            if (r.isSeen()) continue;
                            if (DBG) {
                                Slog.d(NotificationManagerService.TAG, "Marking notification as seen " + keys[i]);
                            }
                            NotificationManagerService.this.mAppUsageStats.reportEvent(r.sbn.getPackageName(), userId == -1 ? 0 : userId, 7);
                            r.setSeen();
                        }
                    }
                }
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        @GuardedBy(value="mNotificationLock")
        private void cancelNotificationFromListenerLocked(ManagedServices.ManagedServiceInfo info, int callingUid, int callingPid, String pkg, String tag, int id2, int userId) {
            NotificationManagerService.this.cancelNotification(callingUid, callingPid, pkg, tag, id2, 0, 66, true, userId, 10, info);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void snoozeNotificationUntilContextFromListener(INotificationListener token, String key, String snoozeCriterionId) {
            long identity = Binder.clearCallingIdentity();
            try {
                Object object = NotificationManagerService.this.mNotificationLock;
                synchronized (object) {
                    ManagedServices.ManagedServiceInfo info = NotificationManagerService.this.mListeners.checkServiceTokenLocked(token);
                    NotificationManagerService.this.snoozeNotificationInt(key, -1L, snoozeCriterionId, info);
                }
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void snoozeNotificationUntilFromListener(INotificationListener token, String key, long duration) {
            long identity = Binder.clearCallingIdentity();
            try {
                Object object = NotificationManagerService.this.mNotificationLock;
                synchronized (object) {
                    ManagedServices.ManagedServiceInfo info = NotificationManagerService.this.mListeners.checkServiceTokenLocked(token);
                    NotificationManagerService.this.snoozeNotificationInt(key, duration, null, info);
                }
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void unsnoozeNotificationFromAssistant(INotificationListener token, String key) {
            long identity = Binder.clearCallingIdentity();
            try {
                Object object = NotificationManagerService.this.mNotificationLock;
                synchronized (object) {
                    ManagedServices.ManagedServiceInfo info = NotificationManagerService.this.mAssistants.checkServiceTokenLocked(token);
                    NotificationManagerService.this.unsnoozeNotificationInt(key, info);
                }
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancelNotificationFromListener(INotificationListener token, String pkg, String tag, int id2) {
            int callingUid = Binder.getCallingUid();
            int callingPid = Binder.getCallingPid();
            long identity = Binder.clearCallingIdentity();
            try {
                Object object = NotificationManagerService.this.mNotificationLock;
                synchronized (object) {
                    ManagedServices.ManagedServiceInfo info = NotificationManagerService.this.mListeners.checkServiceTokenLocked(token);
                    if (info.supportsProfiles()) {
                        Log.e(NotificationManagerService.TAG, "Ignoring deprecated cancelNotification(pkg, tag, id) from " + info.component + " use cancelNotification(key) instead.");
                    } else {
                        this.cancelNotificationFromListenerLocked(info, callingUid, callingPid, pkg, tag, id2, info.userid);
                    }
                }
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ParceledListSlice<StatusBarNotification> getActiveNotificationsFromListener(INotificationListener token, String[] keys, int trim) {
            Object object = NotificationManagerService.this.mNotificationLock;
            synchronized (object) {
                ManagedServices.ManagedServiceInfo info = NotificationManagerService.this.mListeners.checkServiceTokenLocked(token);
                boolean getKeys = keys != null;
                int N = getKeys ? keys.length : NotificationManagerService.this.mNotificationList.size();
                ArrayList<StatusBarNotification> list = new ArrayList<StatusBarNotification>(N);
                for (int i = 0; i < N; ++i) {
                    StatusBarNotification sbn;
                    NotificationRecord r;
                    NotificationRecord notificationRecord = r = getKeys ? NotificationManagerService.this.mNotificationsByKey.get(keys[i]) : NotificationManagerService.this.mNotificationList.get(i);
                    if (r == null || !NotificationManagerService.this.isVisibleToListener(sbn = r.sbn, info)) continue;
                    StatusBarNotification sbnToSend = trim == 0 ? sbn : sbn.cloneLight();
                    list.add(sbnToSend);
                }
                return new ParceledListSlice<StatusBarNotification>(list);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ParceledListSlice<StatusBarNotification> getSnoozedNotificationsFromListener(INotificationListener token, int trim) {
            Object object = NotificationManagerService.this.mNotificationLock;
            synchronized (object) {
                ManagedServices.ManagedServiceInfo info = NotificationManagerService.this.mListeners.checkServiceTokenLocked(token);
                List<NotificationRecord> snoozedRecords = NotificationManagerService.this.mSnoozeHelper.getSnoozed();
                int N = snoozedRecords.size();
                ArrayList<StatusBarNotification> list = new ArrayList<StatusBarNotification>(N);
                for (int i = 0; i < N; ++i) {
                    StatusBarNotification sbn;
                    NotificationRecord r = snoozedRecords.get(i);
                    if (r == null || !NotificationManagerService.this.isVisibleToListener(sbn = r.sbn, info)) continue;
                    StatusBarNotification sbnToSend = trim == 0 ? sbn : sbn.cloneLight();
                    list.add(sbnToSend);
                }
                return new ParceledListSlice<StatusBarNotification>(list);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void requestHintsFromListener(INotificationListener token, int hints) {
            long identity = Binder.clearCallingIdentity();
            try {
                Object object = NotificationManagerService.this.mNotificationLock;
                synchronized (object) {
                    boolean disableEffects;
                    ManagedServices.ManagedServiceInfo info = NotificationManagerService.this.mListeners.checkServiceTokenLocked(token);
                    int disableEffectsMask = 7;
                    boolean bl = disableEffects = (hints & 7) != 0;
                    if (disableEffects) {
                        NotificationManagerService.this.addDisabledHints(info, hints);
                    } else {
                        NotificationManagerService.this.removeDisabledHints(info, hints);
                    }
                    NotificationManagerService.this.updateListenerHintsLocked();
                    NotificationManagerService.this.updateEffectsSuppressorLocked();
                }
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getHintsFromListener(INotificationListener token) {
            Object object = NotificationManagerService.this.mNotificationLock;
            synchronized (object) {
                return NotificationManagerService.this.mListenerHints;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void requestInterruptionFilterFromListener(INotificationListener token, int interruptionFilter) throws RemoteException {
            long identity = Binder.clearCallingIdentity();
            try {
                Object object = NotificationManagerService.this.mNotificationLock;
                synchronized (object) {
                    ManagedServices.ManagedServiceInfo info = NotificationManagerService.this.mListeners.checkServiceTokenLocked(token);
                    NotificationManagerService.this.mZenModeHelper.requestFromListener(info.component, interruptionFilter);
                    NotificationManagerService.this.updateInterruptionFilterLocked();
                }
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getInterruptionFilterFromListener(INotificationListener token) throws RemoteException {
            Light light = NotificationManagerService.this.mNotificationLight;
            synchronized (light) {
                return NotificationManagerService.this.mInterruptionFilter;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setOnNotificationPostedTrimFromListener(INotificationListener token, int trim) throws RemoteException {
            Object object = NotificationManagerService.this.mNotificationLock;
            synchronized (object) {
                ManagedServices.ManagedServiceInfo info = NotificationManagerService.this.mListeners.checkServiceTokenLocked(token);
                if (info == null) {
                    return;
                }
                NotificationManagerService.this.mListeners.setOnNotificationPostedTrimLocked(info, trim);
            }
        }

        @Override
        public int getZenMode() {
            return NotificationManagerService.this.mZenModeHelper.getZenMode();
        }

        @Override
        public ZenModeConfig getZenModeConfig() {
            this.enforceSystemOrSystemUI("INotificationManager.getZenModeConfig");
            return NotificationManagerService.this.mZenModeHelper.getConfig();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setZenMode(int mode, Uri conditionId, String reason) throws RemoteException {
            this.enforceSystemOrSystemUI("INotificationManager.setZenMode");
            long identity = Binder.clearCallingIdentity();
            try {
                NotificationManagerService.this.mZenModeHelper.setManualZenMode(mode, conditionId, null, reason);
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        @Override
        public List<ZenModeConfig.ZenRule> getZenRules() throws RemoteException {
            this.enforcePolicyAccess(Binder.getCallingUid(), "getAutomaticZenRules");
            return NotificationManagerService.this.mZenModeHelper.getZenRules();
        }

        @Override
        public AutomaticZenRule getAutomaticZenRule(String id2) throws RemoteException {
            Preconditions.checkNotNull(id2, "Id is null");
            this.enforcePolicyAccess(Binder.getCallingUid(), "getAutomaticZenRule");
            return NotificationManagerService.this.mZenModeHelper.getAutomaticZenRule(id2);
        }

        @Override
        public String addAutomaticZenRule(AutomaticZenRule automaticZenRule) throws RemoteException {
            Preconditions.checkNotNull(automaticZenRule, "automaticZenRule is null");
            Preconditions.checkNotNull(automaticZenRule.getName(), "Name is null");
            Preconditions.checkNotNull(automaticZenRule.getOwner(), "Owner is null");
            Preconditions.checkNotNull(automaticZenRule.getConditionId(), "ConditionId is null");
            this.enforcePolicyAccess(Binder.getCallingUid(), "addAutomaticZenRule");
            return NotificationManagerService.this.mZenModeHelper.addAutomaticZenRule(automaticZenRule, "addAutomaticZenRule");
        }

        @Override
        public boolean updateAutomaticZenRule(String id2, AutomaticZenRule automaticZenRule) throws RemoteException {
            Preconditions.checkNotNull(automaticZenRule, "automaticZenRule is null");
            Preconditions.checkNotNull(automaticZenRule.getName(), "Name is null");
            Preconditions.checkNotNull(automaticZenRule.getOwner(), "Owner is null");
            Preconditions.checkNotNull(automaticZenRule.getConditionId(), "ConditionId is null");
            this.enforcePolicyAccess(Binder.getCallingUid(), "updateAutomaticZenRule");
            return NotificationManagerService.this.mZenModeHelper.updateAutomaticZenRule(id2, automaticZenRule, "updateAutomaticZenRule");
        }

        @Override
        public boolean removeAutomaticZenRule(String id2) throws RemoteException {
            Preconditions.checkNotNull(id2, "Id is null");
            this.enforcePolicyAccess(Binder.getCallingUid(), "removeAutomaticZenRule");
            return NotificationManagerService.this.mZenModeHelper.removeAutomaticZenRule(id2, "removeAutomaticZenRule");
        }

        @Override
        public boolean removeAutomaticZenRules(String packageName) throws RemoteException {
            Preconditions.checkNotNull(packageName, "Package name is null");
            this.enforceSystemOrSystemUI("removeAutomaticZenRules");
            return NotificationManagerService.this.mZenModeHelper.removeAutomaticZenRules(packageName, "removeAutomaticZenRules");
        }

        @Override
        public int getRuleInstanceCount(ComponentName owner) throws RemoteException {
            Preconditions.checkNotNull(owner, "Owner is null");
            this.enforceSystemOrSystemUI("getRuleInstanceCount");
            return NotificationManagerService.this.mZenModeHelper.getCurrentInstanceCount(owner);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setInterruptionFilter(String pkg, int filter) throws RemoteException {
            this.enforcePolicyAccess(pkg, "setInterruptionFilter");
            int zen = NotificationManager.zenModeFromInterruptionFilter(filter, -1);
            if (zen == -1) {
                throw new IllegalArgumentException("Invalid filter: " + filter);
            }
            long identity = Binder.clearCallingIdentity();
            try {
                NotificationManagerService.this.mZenModeHelper.setManualZenMode(zen, null, pkg, "setInterruptionFilter");
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        @Override
        public void notifyConditions(final String pkg, IConditionProvider provider, final Condition[] conditions) {
            final ManagedServices.ManagedServiceInfo info = NotificationManagerService.this.mConditionProviders.checkServiceToken(provider);
            NotificationManagerService.this.checkCallerIsSystemOrSameApp(pkg);
            NotificationManagerService.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    NotificationManagerService.this.mConditionProviders.notifyConditions(pkg, info, conditions);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void requestUnbindProvider(IConditionProvider provider) {
            long identity = Binder.clearCallingIdentity();
            try {
                ManagedServices.ManagedServiceInfo info = NotificationManagerService.this.mConditionProviders.checkServiceToken(provider);
                info.getOwner().setComponentState(info.component, false);
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void requestBindProvider(ComponentName component) {
            NotificationManagerService.this.checkCallerIsSystemOrSameApp(component.getPackageName());
            long identity = Binder.clearCallingIdentity();
            try {
                NotificationManagerService.this.mConditionProviders.setComponentState(component, true);
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        private void enforceSystemOrSystemUI(String message) {
            if (NotificationManagerService.this.isCallerSystemOrPhone()) {
                return;
            }
            NotificationManagerService.this.getContext().enforceCallingPermission("android.permission.STATUS_BAR_SERVICE", message);
        }

        private void enforceSystemOrSystemUIOrSamePackage(String pkg, String message) {
            try {
                NotificationManagerService.this.checkCallerIsSystemOrSameApp(pkg);
            }
            catch (SecurityException e) {
                NotificationManagerService.this.getContext().enforceCallingPermission("android.permission.STATUS_BAR_SERVICE", message);
            }
        }

        private void enforcePolicyAccess(int uid, String method) {
            if (0 == NotificationManagerService.this.getContext().checkCallingPermission("android.permission.MANAGE_NOTIFICATIONS")) {
                return;
            }
            boolean accessAllowed = false;
            String[] packages = NotificationManagerService.this.getContext().getPackageManager().getPackagesForUid(uid);
            int packageCount = packages.length;
            for (int i = 0; i < packageCount; ++i) {
                if (!NotificationManagerService.this.mConditionProviders.isPackageOrComponentAllowed(packages[i], UserHandle.getUserId(uid))) continue;
                accessAllowed = true;
            }
            if (!accessAllowed) {
                Slog.w(NotificationManagerService.TAG, "Notification policy access denied calling " + method);
                throw new SecurityException("Notification policy access denied");
            }
        }

        private void enforcePolicyAccess(String pkg, String method) {
            if (0 == NotificationManagerService.this.getContext().checkCallingPermission("android.permission.MANAGE_NOTIFICATIONS")) {
                return;
            }
            NotificationManagerService.this.checkCallerIsSameApp(pkg);
            if (!this.checkPolicyAccess(pkg)) {
                Slog.w(NotificationManagerService.TAG, "Notification policy access denied calling " + method);
                throw new SecurityException("Notification policy access denied");
            }
        }

        private boolean checkPackagePolicyAccess(String pkg) {
            return NotificationManagerService.this.mConditionProviders.isPackageOrComponentAllowed(pkg, 10.getCallingUserHandle().getIdentifier());
        }

        private boolean checkPolicyAccess(String pkg) {
            try {
                int uid = NotificationManagerService.this.getContext().getPackageManager().getPackageUidAsUser(pkg, UserHandle.getCallingUserId());
                if (0 == ActivityManager.checkComponentPermission("android.permission.MANAGE_NOTIFICATIONS", uid, -1, true)) {
                    return true;
                }
            }
            catch (PackageManager.NameNotFoundException e) {
                return false;
            }
            return this.checkPackagePolicyAccess(pkg) || NotificationManagerService.this.mListeners.isComponentEnabledForPackage(pkg);
        }

        @Override
        protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
            if (!DumpUtils.checkDumpAndUsageStatsPermission(NotificationManagerService.this.getContext(), NotificationManagerService.TAG, pw)) {
                return;
            }
            DumpFilter filter = DumpFilter.parseFromArguments(args);
            if (filter != null && filter.stats) {
                NotificationManagerService.this.dumpJson(pw, filter);
            } else if (filter != null && filter.proto) {
                NotificationManagerService.this.dumpProto(fd, filter);
            } else {
                NotificationManagerService.this.dumpImpl(pw, filter);
            }
        }

        @Override
        public ComponentName getEffectsSuppressor() {
            return !NotificationManagerService.this.mEffectsSuppressors.isEmpty() ? (ComponentName)NotificationManagerService.this.mEffectsSuppressors.get(0) : null;
        }

        @Override
        public boolean matchesCallFilter(Bundle extras) {
            this.enforceSystemOrSystemUI("INotificationManager.matchesCallFilter");
            return NotificationManagerService.this.mZenModeHelper.matchesCallFilter(Binder.getCallingUserHandle(), extras, NotificationManagerService.this.mRankingHelper.findExtractor(ValidateNotificationPeople.class), 3000, 1.0f);
        }

        @Override
        public boolean isSystemConditionProviderEnabled(String path) {
            this.enforceSystemOrSystemUI("INotificationManager.isSystemConditionProviderEnabled");
            return NotificationManagerService.this.mConditionProviders.isSystemProviderEnabled(path);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte[] getBackupPayload(int user) {
            if (DBG) {
                Slog.d(NotificationManagerService.TAG, "getBackupPayload u=" + user);
            }
            if (user != 0) {
                Slog.w(NotificationManagerService.TAG, "getBackupPayload: cannot backup policy for user " + user);
                return null;
            }
            AtomicFile atomicFile = NotificationManagerService.this.mPolicyFile;
            synchronized (atomicFile) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try {
                    NotificationManagerService.this.writePolicyXml(baos, true);
                    return baos.toByteArray();
                }
                catch (IOException e) {
                    Slog.w(NotificationManagerService.TAG, "getBackupPayload: error writing payload for user " + user, e);
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void applyRestore(byte[] payload, int user) {
            if (DBG) {
                Slog.d(NotificationManagerService.TAG, "applyRestore u=" + user + " payload=" + (payload != null ? new String(payload, StandardCharsets.UTF_8) : null));
            }
            if (payload == null) {
                Slog.w(NotificationManagerService.TAG, "applyRestore: no payload to restore for user " + user);
                return;
            }
            if (user != 0) {
                Slog.w(NotificationManagerService.TAG, "applyRestore: cannot restore policy for user " + user);
                return;
            }
            AtomicFile atomicFile = NotificationManagerService.this.mPolicyFile;
            synchronized (atomicFile) {
                ByteArrayInputStream bais = new ByteArrayInputStream(payload);
                try {
                    NotificationManagerService.this.readPolicyXml(bais, true);
                    NotificationManagerService.this.savePolicyFile();
                }
                catch (IOException | NumberFormatException | XmlPullParserException e) {
                    Slog.w(NotificationManagerService.TAG, "applyRestore: error reading payload", e);
                }
            }
        }

        @Override
        public boolean isNotificationPolicyAccessGranted(String pkg) {
            return this.checkPolicyAccess(pkg);
        }

        @Override
        public boolean isNotificationPolicyAccessGrantedForPackage(String pkg) {
            this.enforceSystemOrSystemUIOrSamePackage(pkg, "request policy access status for another package");
            return this.checkPolicyAccess(pkg);
        }

        @Override
        public void setNotificationPolicyAccessGranted(String pkg, boolean granted) throws RemoteException {
            this.setNotificationPolicyAccessGrantedForUser(pkg, 10.getCallingUserHandle().getIdentifier(), granted);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setNotificationPolicyAccessGrantedForUser(String pkg, int userId, boolean granted) {
            NotificationManagerService.this.checkCallerIsSystemOrShell();
            long identity = Binder.clearCallingIdentity();
            try {
                if (!NotificationManagerService.this.mActivityManager.isLowRamDevice()) {
                    NotificationManagerService.this.mConditionProviders.setPackageOrComponentEnabled(pkg, userId, true, granted);
                    NotificationManagerService.this.getContext().sendBroadcastAsUser(new Intent("android.app.action.NOTIFICATION_POLICY_ACCESS_GRANTED_CHANGED").setPackage(pkg).addFlags(0x40000000), UserHandle.of(userId), null);
                    NotificationManagerService.this.savePolicyFile();
                }
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public NotificationManager.Policy getNotificationPolicy(String pkg) {
            this.enforcePolicyAccess(pkg, "getNotificationPolicy");
            long identity = Binder.clearCallingIdentity();
            try {
                NotificationManager.Policy policy = NotificationManagerService.this.mZenModeHelper.getNotificationPolicy();
                return policy;
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setNotificationPolicy(String pkg, NotificationManager.Policy policy) {
            this.enforcePolicyAccess(pkg, "setNotificationPolicy");
            long identity = Binder.clearCallingIdentity();
            try {
                NotificationManagerService.this.mZenModeHelper.setNotificationPolicy(policy);
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        @Override
        public List<String> getEnabledNotificationListenerPackages() {
            NotificationManagerService.this.checkCallerIsSystem();
            return NotificationManagerService.this.mListeners.getAllowedPackages(10.getCallingUserHandle().getIdentifier());
        }

        @Override
        public List<ComponentName> getEnabledNotificationListeners(int userId) {
            NotificationManagerService.this.checkCallerIsSystem();
            return NotificationManagerService.this.mListeners.getAllowedComponents(userId);
        }

        @Override
        public boolean isNotificationListenerAccessGranted(ComponentName listener) {
            Preconditions.checkNotNull(listener);
            NotificationManagerService.this.checkCallerIsSystemOrSameApp(listener.getPackageName());
            return NotificationManagerService.this.mListeners.isPackageOrComponentAllowed(listener.flattenToString(), 10.getCallingUserHandle().getIdentifier());
        }

        @Override
        public boolean isNotificationListenerAccessGrantedForUser(ComponentName listener, int userId) {
            Preconditions.checkNotNull(listener);
            NotificationManagerService.this.checkCallerIsSystem();
            return NotificationManagerService.this.mListeners.isPackageOrComponentAllowed(listener.flattenToString(), userId);
        }

        @Override
        public boolean isNotificationAssistantAccessGranted(ComponentName assistant) {
            Preconditions.checkNotNull(assistant);
            NotificationManagerService.this.checkCallerIsSystemOrSameApp(assistant.getPackageName());
            return NotificationManagerService.this.mAssistants.isPackageOrComponentAllowed(assistant.flattenToString(), 10.getCallingUserHandle().getIdentifier());
        }

        @Override
        public void setNotificationListenerAccessGranted(ComponentName listener, boolean granted) throws RemoteException {
            this.setNotificationListenerAccessGrantedForUser(listener, 10.getCallingUserHandle().getIdentifier(), granted);
        }

        @Override
        public void setNotificationAssistantAccessGranted(ComponentName assistant, boolean granted) throws RemoteException {
            this.setNotificationAssistantAccessGrantedForUser(assistant, 10.getCallingUserHandle().getIdentifier(), granted);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setNotificationListenerAccessGrantedForUser(ComponentName listener, int userId, boolean granted) throws RemoteException {
            Preconditions.checkNotNull(listener);
            NotificationManagerService.this.checkCallerIsSystemOrShell();
            long identity = Binder.clearCallingIdentity();
            try {
                if (!NotificationManagerService.this.mActivityManager.isLowRamDevice()) {
                    NotificationManagerService.this.mConditionProviders.setPackageOrComponentEnabled(listener.flattenToString(), userId, false, granted);
                    NotificationManagerService.this.mListeners.setPackageOrComponentEnabled(listener.flattenToString(), userId, true, granted);
                    NotificationManagerService.this.getContext().sendBroadcastAsUser(new Intent("android.app.action.NOTIFICATION_POLICY_ACCESS_GRANTED_CHANGED").setPackage(listener.getPackageName()).addFlags(0x40000000), UserHandle.of(userId), null);
                    NotificationManagerService.this.savePolicyFile();
                }
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setNotificationAssistantAccessGrantedForUser(ComponentName assistant, int userId, boolean granted) throws RemoteException {
            Preconditions.checkNotNull(assistant);
            NotificationManagerService.this.checkCallerIsSystemOrShell();
            long identity = Binder.clearCallingIdentity();
            try {
                if (!NotificationManagerService.this.mActivityManager.isLowRamDevice()) {
                    NotificationManagerService.this.mConditionProviders.setPackageOrComponentEnabled(assistant.flattenToString(), userId, false, granted);
                    NotificationManagerService.this.mAssistants.setPackageOrComponentEnabled(assistant.flattenToString(), userId, true, granted);
                    NotificationManagerService.this.getContext().sendBroadcastAsUser(new Intent("android.app.action.NOTIFICATION_POLICY_ACCESS_GRANTED_CHANGED").setPackage(assistant.getPackageName()).addFlags(0x40000000), UserHandle.of(userId), null);
                    NotificationManagerService.this.savePolicyFile();
                }
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void applyEnqueuedAdjustmentFromAssistant(INotificationListener token, Adjustment adjustment) throws RemoteException {
            long identity = Binder.clearCallingIdentity();
            try {
                Object object = NotificationManagerService.this.mNotificationLock;
                synchronized (object) {
                    NotificationManagerService.this.mAssistants.checkServiceTokenLocked(token);
                    int N = NotificationManagerService.this.mEnqueuedNotifications.size();
                    for (int i = 0; i < N; ++i) {
                        NotificationRecord n = NotificationManagerService.this.mEnqueuedNotifications.get(i);
                        if (!Objects.equals(adjustment.getKey(), n.getKey()) || !Objects.equals(adjustment.getUser(), n.getUserId())) continue;
                        NotificationManagerService.this.applyAdjustment(n, adjustment);
                        break;
                    }
                }
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void applyAdjustmentFromAssistant(INotificationListener token, Adjustment adjustment) throws RemoteException {
            long identity = Binder.clearCallingIdentity();
            try {
                Object object = NotificationManagerService.this.mNotificationLock;
                synchronized (object) {
                    NotificationManagerService.this.mAssistants.checkServiceTokenLocked(token);
                    NotificationRecord n = NotificationManagerService.this.mNotificationsByKey.get(adjustment.getKey());
                    NotificationManagerService.this.applyAdjustment(n, adjustment);
                }
                NotificationManagerService.this.mRankingHandler.requestSort();
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void applyAdjustmentsFromAssistant(INotificationListener token, List<Adjustment> adjustments) throws RemoteException {
            long identity = Binder.clearCallingIdentity();
            try {
                Object object = NotificationManagerService.this.mNotificationLock;
                synchronized (object) {
                    NotificationManagerService.this.mAssistants.checkServiceTokenLocked(token);
                    for (Adjustment adjustment : adjustments) {
                        NotificationRecord n = NotificationManagerService.this.mNotificationsByKey.get(adjustment.getKey());
                        NotificationManagerService.this.applyAdjustment(n, adjustment);
                    }
                }
                NotificationManagerService.this.mRankingHandler.requestSort();
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        @Override
        public void updateNotificationChannelFromPrivilegedListener(INotificationListener token, String pkg, UserHandle user, NotificationChannel channel) throws RemoteException {
            Preconditions.checkNotNull(channel);
            Preconditions.checkNotNull(pkg);
            Preconditions.checkNotNull(user);
            this.verifyPrivilegedListener(token, user);
            NotificationManagerService.this.updateNotificationChannelInt(pkg, this.getUidForPackageAndUser(pkg, user), channel, true);
        }

        @Override
        public ParceledListSlice<NotificationChannel> getNotificationChannelsFromPrivilegedListener(INotificationListener token, String pkg, UserHandle user) throws RemoteException {
            Preconditions.checkNotNull(pkg);
            Preconditions.checkNotNull(user);
            this.verifyPrivilegedListener(token, user);
            return NotificationManagerService.this.mRankingHelper.getNotificationChannels(pkg, this.getUidForPackageAndUser(pkg, user), false);
        }

        @Override
        public ParceledListSlice<NotificationChannelGroup> getNotificationChannelGroupsFromPrivilegedListener(INotificationListener token, String pkg, UserHandle user) throws RemoteException {
            Preconditions.checkNotNull(pkg);
            Preconditions.checkNotNull(user);
            this.verifyPrivilegedListener(token, user);
            ArrayList<NotificationChannelGroup> groups = new ArrayList<NotificationChannelGroup>();
            groups.addAll(NotificationManagerService.this.mRankingHelper.getNotificationChannelGroups(pkg, this.getUidForPackageAndUser(pkg, user)));
            return new ParceledListSlice<NotificationChannelGroup>(groups);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void verifyPrivilegedListener(INotificationListener token, UserHandle user) {
            ManagedServices.ManagedServiceInfo info;
            Object object = NotificationManagerService.this.mNotificationLock;
            synchronized (object) {
                info = NotificationManagerService.this.mListeners.checkServiceTokenLocked(token);
            }
            if (!NotificationManagerService.this.hasCompanionDevice(info)) {
                throw new SecurityException(info + " does not have access");
            }
            if (!info.enabledAndUserMatches(user.getIdentifier())) {
                throw new SecurityException(info + " does not have access");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int getUidForPackageAndUser(String pkg, UserHandle user) throws RemoteException {
            int uid = 0;
            long identity = Binder.clearCallingIdentity();
            try {
                uid = NotificationManagerService.this.mPackageManager.getPackageUid(pkg, 0, user.getIdentifier());
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
            return uid;
        }

        @Override
        public void onShellCommand(FileDescriptor in, FileDescriptor out, FileDescriptor err, String[] args, ShellCallback callback, ResultReceiver resultReceiver) throws RemoteException {
            new ShellCmd().exec(this, in, out, err, args, callback, resultReceiver);
        }
    };
    private final NotificationManagerInternal mInternalService = new NotificationManagerInternal(){

        @Override
        public NotificationChannel getNotificationChannel(String pkg, int uid, String channelId) {
            return NotificationManagerService.this.mRankingHelper.getNotificationChannel(pkg, uid, channelId, false);
        }

        @Override
        public void enqueueNotification(String pkg, String opPkg, int callingUid, int callingPid, String tag, int id2, Notification notification, int userId) {
            NotificationManagerService.this.enqueueNotificationInternal(pkg, opPkg, callingUid, callingPid, tag, id2, notification, userId);
        }

        @Override
        public void removeForegroundServiceFlagFromNotification(final String pkg, final int notificationId, final int userId) {
            NotificationManagerService.this.checkCallerIsSystem();
            NotificationManagerService.this.mHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = NotificationManagerService.this.mNotificationLock;
                    synchronized (object) {
                        this.removeForegroundServiceFlagByListLocked(NotificationManagerService.this.mEnqueuedNotifications, pkg, notificationId, userId);
                        this.removeForegroundServiceFlagByListLocked(NotificationManagerService.this.mNotificationList, pkg, notificationId, userId);
                    }
                }
            });
        }

        @GuardedBy(value="mNotificationLock")
        private void removeForegroundServiceFlagByListLocked(ArrayList<NotificationRecord> notificationList, String pkg, int notificationId, int userId) {
            NotificationRecord r = NotificationManagerService.this.findNotificationByListLocked(notificationList, pkg, null, notificationId, userId);
            if (r == null) {
                return;
            }
            StatusBarNotification sbn = r.sbn;
            sbn.getNotification().flags = r.mOriginalFlags & 0xFFFFFFBF;
            NotificationManagerService.this.mRankingHelper.sort(NotificationManagerService.this.mNotificationList);
            NotificationManagerService.this.mListeners.notifyPostedLocked(sbn, sbn);
        }
    };

    protected void readDefaultApprovedServices(int userId) {
        String defaultListenerAccess = this.getContext().getResources().getString(17039640);
        if (defaultListenerAccess != null) {
            for (String whitelisted : defaultListenerAccess.split(":")) {
                Set<ComponentName> approvedListeners = this.mListeners.queryPackageForServices(whitelisted, 786432, userId);
                for (ComponentName cn : approvedListeners) {
                    try {
                        this.getBinderService().setNotificationListenerAccessGrantedForUser(cn, userId, true);
                    }
                    catch (RemoteException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        String defaultDndAccess = this.getContext().getResources().getString(17039639);
        if (defaultListenerAccess != null) {
            for (String whitelisted : defaultDndAccess.split(":")) {
                try {
                    this.getBinderService().setNotificationPolicyAccessGranted(whitelisted, true);
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    void readPolicyXml(InputStream stream, boolean forRestore) throws XmlPullParserException, NumberFormatException, IOException {
        XmlPullParser parser = Xml.newPullParser();
        parser.setInput(stream, StandardCharsets.UTF_8.name());
        XmlUtils.beginDocument(parser, TAG_NOTIFICATION_POLICY);
        boolean migratedManagedServices = false;
        int outerDepth = parser.getDepth();
        while (XmlUtils.nextElementWithin(parser, outerDepth)) {
            if ("zen".equals(parser.getName())) {
                this.mZenModeHelper.readXml(parser, forRestore);
            } else if ("ranking".equals(parser.getName())) {
                this.mRankingHelper.readXml(parser, forRestore);
            }
            if (ActivityManager.isLowRamDeviceStatic()) continue;
            if (this.mListeners.getConfig().xmlTag.equals(parser.getName())) {
                this.mListeners.readXml(parser);
                migratedManagedServices = true;
                continue;
            }
            if (this.mAssistants.getConfig().xmlTag.equals(parser.getName())) {
                this.mAssistants.readXml(parser);
                migratedManagedServices = true;
                continue;
            }
            if (!this.mConditionProviders.getConfig().xmlTag.equals(parser.getName())) continue;
            this.mConditionProviders.readXml(parser);
            migratedManagedServices = true;
        }
        if (!migratedManagedServices) {
            this.mListeners.migrateToXml();
            this.mAssistants.migrateToXml();
            this.mConditionProviders.migrateToXml();
            this.savePolicyFile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPolicyFile() {
        if (DBG) {
            Slog.d(TAG, "loadPolicyFile");
        }
        AtomicFile atomicFile = this.mPolicyFile;
        synchronized (atomicFile) {
            FileInputStream infile = null;
            try {
                infile = this.mPolicyFile.openRead();
                this.readPolicyXml(infile, false);
            }
            catch (FileNotFoundException e) {
                this.readDefaultApprovedServices(0);
            }
            catch (IOException e) {
                Log.wtf(TAG, "Unable to read notification policy", e);
            }
            catch (NumberFormatException e) {
                Log.wtf(TAG, "Unable to parse notification policy", e);
            }
            catch (XmlPullParserException e) {
                Log.wtf(TAG, "Unable to parse notification policy", e);
            }
            finally {
                IoUtils.closeQuietly(infile);
            }
        }
    }

    public void savePolicyFile() {
        this.mHandler.removeMessages(3);
        this.mHandler.sendEmptyMessage(3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSavePolicyFile() {
        if (DBG) {
            Slog.d(TAG, "handleSavePolicyFile");
        }
        AtomicFile atomicFile = this.mPolicyFile;
        synchronized (atomicFile) {
            FileOutputStream stream;
            try {
                stream = this.mPolicyFile.startWrite();
            }
            catch (IOException e) {
                Slog.w(TAG, "Failed to save policy file", e);
                return;
            }
            try {
                this.writePolicyXml(stream, false);
                this.mPolicyFile.finishWrite(stream);
            }
            catch (IOException e) {
                Slog.w(TAG, "Failed to save policy file, restoring backup", e);
                this.mPolicyFile.failWrite(stream);
            }
        }
        BackupManager.dataChanged(this.getContext().getPackageName());
    }

    private void writePolicyXml(OutputStream stream, boolean forBackup) throws IOException {
        FastXmlSerializer out = new FastXmlSerializer();
        out.setOutput(stream, StandardCharsets.UTF_8.name());
        out.startDocument(null, true);
        out.startTag(null, TAG_NOTIFICATION_POLICY);
        out.attribute(null, ATTR_VERSION, Integer.toString(1));
        this.mZenModeHelper.writeXml(out, forBackup);
        this.mRankingHelper.writeXml(out, forBackup);
        this.mListeners.writeXml(out, forBackup);
        this.mAssistants.writeXml(out, forBackup);
        this.mConditionProviders.writeXml(out, forBackup);
        out.endTag(null, TAG_NOTIFICATION_POLICY);
        out.endDocument();
    }

    private boolean checkNotificationOp(String pkg, int uid) {
        return this.mAppOps.checkOp(11, uid, pkg) == 0 && !this.isPackageSuspendedForUser(pkg, uid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value="mNotificationLock")
    private void clearSoundLocked() {
        this.mSoundNotificationKey = null;
        long identity = Binder.clearCallingIdentity();
        try {
            IRingtonePlayer player = this.mAudioManager.getRingtonePlayer();
            if (player != null) {
                player.stopAsync();
            }
        }
        catch (RemoteException remoteException) {
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    @GuardedBy(value="mNotificationLock")
    private void clearVibrateLocked() {
        this.mVibrateNotificationKey = null;
        long identity = Binder.clearCallingIdentity();
        try {
            this.mVibrator.cancel();
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    @GuardedBy(value="mNotificationLock")
    private void clearLightsLocked() {
        this.mLights.clear();
        this.updateLightsLocked();
    }

    static long[] getLongArray(Resources r, int resid, int maxlen, long[] def) {
        int[] ar = r.getIntArray(resid);
        if (ar == null) {
            return def;
        }
        int len = ar.length > maxlen ? maxlen : ar.length;
        long[] out = new long[len];
        for (int i = 0; i < len; ++i) {
            out[i] = ar[i];
        }
        return out;
    }

    public NotificationManagerService(Context context) {
        super(context);
        Notification.processWhitelistToken = WHITELIST_TOKEN;
    }

    void setAudioManager(AudioManager audioMananger) {
        this.mAudioManager = audioMananger;
    }

    void setVibrator(Vibrator vibrator) {
        this.mVibrator = vibrator;
    }

    void setLights(Light light) {
        this.mNotificationLight = light;
        this.mAttentionLight = light;
        this.mNotificationPulseEnabled = true;
    }

    void setScreenOn(boolean on) {
        this.mScreenOn = on;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getNotificationRecordCount() {
        Object object = this.mNotificationLock;
        synchronized (object) {
            int count = this.mNotificationList.size() + this.mNotificationsByKey.size() + this.mSummaryByGroupKey.size() + this.mEnqueuedNotifications.size();
            for (NotificationRecord posted : this.mNotificationList) {
                if (this.mNotificationsByKey.containsKey(posted.getKey())) {
                    --count;
                }
                if (!posted.sbn.isGroup() || !posted.getNotification().isGroupSummary()) continue;
                --count;
            }
            return count;
        }
    }

    void clearNotifications() {
        this.mEnqueuedNotifications.clear();
        this.mNotificationList.clear();
        this.mNotificationsByKey.clear();
        this.mSummaryByGroupKey.clear();
    }

    void addNotification(NotificationRecord r) {
        this.mNotificationList.add(r);
        this.mNotificationsByKey.put(r.sbn.getKey(), r);
        if (r.sbn.isGroup()) {
            this.mSummaryByGroupKey.put(r.getGroupKey(), r);
        }
    }

    void addEnqueuedNotification(NotificationRecord r) {
        this.mEnqueuedNotifications.add(r);
    }

    NotificationRecord getNotificationRecord(String key) {
        return this.mNotificationsByKey.get(key);
    }

    void setSystemReady(boolean systemReady) {
        this.mSystemReady = systemReady;
    }

    void setHandler(WorkerHandler handler) {
        this.mHandler = handler;
    }

    void setFallbackVibrationPattern(long[] vibrationPattern) {
        this.mFallbackVibrationPattern = vibrationPattern;
    }

    void setPackageManager(IPackageManager packageManager) {
        this.mPackageManager = packageManager;
    }

    void setRankingHelper(RankingHelper rankingHelper) {
        this.mRankingHelper = rankingHelper;
    }

    void setRankingHandler(RankingHandler rankingHandler) {
        this.mRankingHandler = rankingHandler;
    }

    void setIsTelevision(boolean isTelevision) {
        this.mIsTelevision = isTelevision;
    }

    void setUsageStats(NotificationUsageStats us) {
        this.mUsageStats = us;
    }

    void setAccessibilityManager(AccessibilityManager am) {
        this.mAccessibilityManager = am;
    }

    void init(Looper looper, IPackageManager packageManager, PackageManager packageManagerClient, LightsManager lightsManager, NotificationListeners notificationListeners, NotificationAssistants notificationAssistants, ConditionProviders conditionProviders, ICompanionDeviceManager companionManager, SnoozeHelper snoozeHelper, NotificationUsageStats usageStats, AtomicFile policyFile, ActivityManager activityManager, GroupHelper groupHelper) {
        String[] extractorNames;
        Resources resources = this.getContext().getResources();
        this.mMaxPackageEnqueueRate = Settings.Global.getFloat(this.getContext().getContentResolver(), "max_notification_enqueue_rate", 5.0f);
        this.mAccessibilityManager = (AccessibilityManager)this.getContext().getSystemService("accessibility");
        this.mAm = ActivityManager.getService();
        this.mPackageManager = packageManager;
        this.mPackageManagerClient = packageManagerClient;
        this.mAppOps = (AppOpsManager)this.getContext().getSystemService("appops");
        this.mVibrator = (Vibrator)this.getContext().getSystemService("vibrator");
        this.mAppUsageStats = LocalServices.getService(UsageStatsManagerInternal.class);
        this.mAlarmManager = (AlarmManager)this.getContext().getSystemService("alarm");
        this.mCompanionManager = companionManager;
        this.mActivityManager = activityManager;
        this.mHandler = new WorkerHandler(looper);
        this.mRankingThread.start();
        try {
            extractorNames = resources.getStringArray(17236019);
        }
        catch (Resources.NotFoundException e) {
            extractorNames = new String[]{};
        }
        this.mUsageStats = usageStats;
        this.mRankingHandler = new RankingHandlerWorker(this.mRankingThread.getLooper());
        this.mRankingHelper = new RankingHelper(this.getContext(), this.mPackageManagerClient, this.mRankingHandler, this.mUsageStats, extractorNames);
        this.mConditionProviders = conditionProviders;
        this.mZenModeHelper = new ZenModeHelper(this.getContext(), this.mHandler.getLooper(), this.mConditionProviders);
        this.mZenModeHelper.addCallback(new ZenModeHelper.Callback(){

            @Override
            public void onConfigChanged() {
                NotificationManagerService.this.savePolicyFile();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            void onZenModeChanged() {
                NotificationManagerService.this.sendRegisteredOnlyBroadcast("android.app.action.INTERRUPTION_FILTER_CHANGED");
                NotificationManagerService.this.getContext().sendBroadcastAsUser(new Intent("android.app.action.INTERRUPTION_FILTER_CHANGED_INTERNAL").addFlags(0x4000000), UserHandle.ALL, "android.permission.MANAGE_NOTIFICATIONS");
                Object object = NotificationManagerService.this.mNotificationLock;
                synchronized (object) {
                    NotificationManagerService.this.updateInterruptionFilterLocked();
                }
            }

            @Override
            void onPolicyChanged() {
                NotificationManagerService.this.sendRegisteredOnlyBroadcast("android.app.action.NOTIFICATION_POLICY_CHANGED");
            }
        });
        this.mSnoozeHelper = snoozeHelper;
        this.mGroupHelper = groupHelper;
        this.mListeners = notificationListeners;
        this.mAssistants = notificationAssistants;
        this.mPolicyFile = policyFile;
        this.loadPolicyFile();
        this.mStatusBar = this.getLocalService(StatusBarManagerInternal.class);
        if (this.mStatusBar != null) {
            this.mStatusBar.setNotificationDelegate(this.mNotificationDelegate);
        }
        this.mNotificationLight = lightsManager.getLight(4);
        this.mAttentionLight = lightsManager.getLight(5);
        this.mFallbackVibrationPattern = NotificationManagerService.getLongArray(resources, 17236018, 17, DEFAULT_VIBRATE_PATTERN);
        this.mInCallNotificationUri = Uri.parse("file://" + resources.getString(17039672));
        this.mInCallNotificationAudioAttributes = new AudioAttributes.Builder().setContentType(4).setUsage(2).build();
        this.mInCallNotificationVolume = resources.getFloat(17104951);
        this.mUseAttentionLight = resources.getBoolean(17957043);
        if (0 == Settings.Global.getInt(this.getContext().getContentResolver(), "device_provisioned", 0)) {
            this.mDisableNotificationEffects = true;
        }
        this.mZenModeHelper.initZenMode();
        this.mInterruptionFilter = this.mZenModeHelper.getZenModeListenerInterruptionFilter();
        this.mUserProfiles.updateCache(this.getContext());
        this.listenForCallState();
        this.mSettingsObserver = new SettingsObserver(this.mHandler);
        this.mArchive = new Archive(resources.getInteger(17694824));
        this.mIsTelevision = this.mPackageManagerClient.hasSystemFeature("android.software.leanback") || this.mPackageManagerClient.hasSystemFeature("android.hardware.type.television");
    }

    @Override
    public void onStart() {
        SnoozeHelper snoozeHelper = new SnoozeHelper(this.getContext(), new SnoozeHelper.Callback(){

            @Override
            public void repost(int userId, NotificationRecord r) {
                try {
                    if (DBG) {
                        Slog.d(NotificationManagerService.TAG, "Reposting " + r.getKey());
                    }
                    NotificationManagerService.this.enqueueNotificationInternal(r.sbn.getPackageName(), r.sbn.getOpPkg(), r.sbn.getUid(), r.sbn.getInitialPid(), r.sbn.getTag(), r.sbn.getId(), r.sbn.getNotification(), userId);
                }
                catch (Exception e) {
                    Slog.e(NotificationManagerService.TAG, "Cannot un-snooze notification", e);
                }
            }
        }, this.mUserProfiles);
        File systemDir = new File(Environment.getDataDirectory(), "system");
        this.init(Looper.myLooper(), AppGlobals.getPackageManager(), this.getContext().getPackageManager(), this.getLocalService(LightsManager.class), new NotificationListeners(AppGlobals.getPackageManager()), new NotificationAssistants(AppGlobals.getPackageManager()), new ConditionProviders(this.getContext(), this.mUserProfiles, AppGlobals.getPackageManager()), null, snoozeHelper, new NotificationUsageStats(this.getContext()), new AtomicFile(new File(systemDir, "notification_policy.xml")), (ActivityManager)this.getContext().getSystemService("activity"), this.getGroupHelper());
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.SCREEN_ON");
        filter.addAction("android.intent.action.SCREEN_OFF");
        filter.addAction("android.intent.action.PHONE_STATE");
        filter.addAction("android.intent.action.USER_PRESENT");
        filter.addAction("android.intent.action.USER_STOPPED");
        filter.addAction("android.intent.action.USER_SWITCHED");
        filter.addAction("android.intent.action.USER_ADDED");
        filter.addAction("android.intent.action.USER_REMOVED");
        filter.addAction("android.intent.action.USER_UNLOCKED");
        filter.addAction("android.intent.action.MANAGED_PROFILE_UNAVAILABLE");
        this.getContext().registerReceiver(this.mIntentReceiver, filter);
        IntentFilter pkgFilter = new IntentFilter();
        pkgFilter.addAction("android.intent.action.PACKAGE_ADDED");
        pkgFilter.addAction("android.intent.action.PACKAGE_REMOVED");
        pkgFilter.addAction("android.intent.action.PACKAGE_CHANGED");
        pkgFilter.addAction("android.intent.action.PACKAGE_RESTARTED");
        pkgFilter.addAction("android.intent.action.QUERY_PACKAGE_RESTART");
        pkgFilter.addDataScheme("package");
        this.getContext().registerReceiverAsUser(this.mPackageIntentReceiver, UserHandle.ALL, pkgFilter, null, null);
        IntentFilter suspendedPkgFilter = new IntentFilter();
        suspendedPkgFilter.addAction("android.intent.action.PACKAGES_SUSPENDED");
        this.getContext().registerReceiverAsUser(this.mPackageIntentReceiver, UserHandle.ALL, suspendedPkgFilter, null, null);
        IntentFilter sdFilter = new IntentFilter("android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE");
        this.getContext().registerReceiverAsUser(this.mPackageIntentReceiver, UserHandle.ALL, sdFilter, null, null);
        IntentFilter timeoutFilter = new IntentFilter(ACTION_NOTIFICATION_TIMEOUT);
        timeoutFilter.addDataScheme(SCHEME_TIMEOUT);
        this.getContext().registerReceiver(this.mNotificationTimeoutReceiver, timeoutFilter);
        IntentFilter settingsRestoredFilter = new IntentFilter("android.os.action.SETTING_RESTORED");
        this.getContext().registerReceiver(this.mRestoreReceiver, settingsRestoredFilter);
        IntentFilter localeChangedFilter = new IntentFilter("android.intent.action.LOCALE_CHANGED");
        this.getContext().registerReceiver(this.mLocaleChangeReceiver, localeChangedFilter);
        this.publishBinderService("notification", this.mService);
        this.publishLocalService(NotificationManagerInternal.class, this.mInternalService);
    }

    private GroupHelper getGroupHelper() {
        return new GroupHelper(new GroupHelper.Callback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addAutoGroup(String key) {
                Object object = NotificationManagerService.this.mNotificationLock;
                synchronized (object) {
                    NotificationManagerService.this.addAutogroupKeyLocked(key);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeAutoGroup(String key) {
                Object object = NotificationManagerService.this.mNotificationLock;
                synchronized (object) {
                    NotificationManagerService.this.removeAutogroupKeyLocked(key);
                }
            }

            @Override
            public void addAutoGroupSummary(int userId, String pkg, String triggeringKey) {
                NotificationManagerService.this.createAutoGroupSummary(userId, pkg, triggeringKey);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeAutoGroupSummary(int userId, String pkg) {
                Object object = NotificationManagerService.this.mNotificationLock;
                synchronized (object) {
                    NotificationManagerService.this.clearAutogroupSummaryLocked(userId, pkg);
                }
            }
        });
    }

    private void sendRegisteredOnlyBroadcast(String action) {
        this.getContext().sendBroadcastAsUser(new Intent(action).addFlags(0x40000000), UserHandle.ALL, null);
    }

    @Override
    public void onBootPhase(int phase) {
        if (phase == 500) {
            this.mSystemReady = true;
            this.mAudioManager = (AudioManager)this.getContext().getSystemService("audio");
            this.mAudioManagerInternal = this.getLocalService(AudioManagerInternal.class);
            this.mWindowManagerInternal = LocalServices.getService(WindowManagerInternal.class);
            this.mZenModeHelper.onSystemReady();
        } else if (phase == 600) {
            this.mSettingsObserver.observe();
            this.mListeners.onBootPhaseAppsCanStart();
            this.mAssistants.onBootPhaseAppsCanStart();
            this.mConditionProviders.onBootPhaseAppsCanStart();
        }
    }

    @GuardedBy(value="mNotificationLock")
    private void updateListenerHintsLocked() {
        int hints = this.calculateHints();
        if (hints == this.mListenerHints) {
            return;
        }
        ZenLog.traceListenerHintsChanged(this.mListenerHints, hints, this.mEffectsSuppressors.size());
        this.mListenerHints = hints;
        this.scheduleListenerHintsChanged(hints);
    }

    @GuardedBy(value="mNotificationLock")
    private void updateEffectsSuppressorLocked() {
        long updatedSuppressedEffects = this.calculateSuppressedEffects();
        if (updatedSuppressedEffects == this.mZenModeHelper.getSuppressedEffects()) {
            return;
        }
        ArrayList<ComponentName> suppressors = this.getSuppressors();
        ZenLog.traceEffectsSuppressorChanged(this.mEffectsSuppressors, suppressors, updatedSuppressedEffects);
        this.mEffectsSuppressors = suppressors;
        this.mZenModeHelper.setSuppressedEffects(updatedSuppressedEffects);
        this.sendRegisteredOnlyBroadcast("android.os.action.ACTION_EFFECTS_SUPPRESSOR_CHANGED");
    }

    private void updateNotificationChannelInt(String pkg, int uid, NotificationChannel channel, boolean fromListener) {
        if (channel.getImportance() == 0) {
            this.cancelAllNotificationsInt(MY_UID, MY_PID, pkg, channel.getId(), 0, 0, true, UserHandle.getUserId(uid), 17, null);
            if (this.isUidSystemOrPhone(uid)) {
                for (int profileId : this.mUserProfiles.getCurrentProfileIds()) {
                    this.cancelAllNotificationsInt(MY_UID, MY_PID, pkg, channel.getId(), 0, 0, true, profileId, 17, null);
                }
            }
        }
        this.mRankingHelper.updateNotificationChannel(pkg, uid, channel, true);
        if (!fromListener) {
            NotificationChannel modifiedChannel = this.mRankingHelper.getNotificationChannel(pkg, uid, channel.getId(), false);
            this.mListeners.notifyNotificationChannelChanged(pkg, UserHandle.getUserHandleForUid(uid), modifiedChannel, 2);
        }
        this.savePolicyFile();
    }

    private ArrayList<ComponentName> getSuppressors() {
        ArrayList<ComponentName> names = new ArrayList<ComponentName>();
        for (int i = this.mListenersDisablingEffects.size() - 1; i >= 0; --i) {
            ArraySet<ManagedServices.ManagedServiceInfo> serviceInfoList = this.mListenersDisablingEffects.valueAt(i);
            for (ManagedServices.ManagedServiceInfo info : serviceInfoList) {
                names.add(info.component);
            }
        }
        return names;
    }

    private boolean removeDisabledHints(ManagedServices.ManagedServiceInfo info) {
        return this.removeDisabledHints(info, 0);
    }

    private boolean removeDisabledHints(ManagedServices.ManagedServiceInfo info, int hints) {
        boolean removed = false;
        for (int i = this.mListenersDisablingEffects.size() - 1; i >= 0; --i) {
            int hint = this.mListenersDisablingEffects.keyAt(i);
            ArraySet<ManagedServices.ManagedServiceInfo> listeners = this.mListenersDisablingEffects.valueAt(i);
            if (hints != 0 && (hint & hints) != hint) continue;
            removed = removed || listeners.remove(info);
        }
        return removed;
    }

    private void addDisabledHints(ManagedServices.ManagedServiceInfo info, int hints) {
        if ((hints & 1) != 0) {
            this.addDisabledHint(info, 1);
        }
        if ((hints & 2) != 0) {
            this.addDisabledHint(info, 2);
        }
        if ((hints & 4) != 0) {
            this.addDisabledHint(info, 4);
        }
    }

    private void addDisabledHint(ManagedServices.ManagedServiceInfo info, int hint) {
        if (this.mListenersDisablingEffects.indexOfKey(hint) < 0) {
            this.mListenersDisablingEffects.put(hint, new ArraySet());
        }
        ArraySet<ManagedServices.ManagedServiceInfo> hintListeners = this.mListenersDisablingEffects.get(hint);
        hintListeners.add(info);
    }

    private int calculateHints() {
        int hints = 0;
        for (int i = this.mListenersDisablingEffects.size() - 1; i >= 0; --i) {
            int hint = this.mListenersDisablingEffects.keyAt(i);
            ArraySet<ManagedServices.ManagedServiceInfo> serviceInfoList = this.mListenersDisablingEffects.valueAt(i);
            if (serviceInfoList.isEmpty()) continue;
            hints |= hint;
        }
        return hints;
    }

    private long calculateSuppressedEffects() {
        int hints = this.calculateHints();
        long suppressedEffects = 0L;
        if ((hints & 1) != 0) {
            suppressedEffects |= 3L;
        }
        if ((hints & 2) != 0) {
            suppressedEffects |= 1L;
        }
        if ((hints & 4) != 0) {
            suppressedEffects |= 2L;
        }
        return suppressedEffects;
    }

    @GuardedBy(value="mNotificationLock")
    private void updateInterruptionFilterLocked() {
        int interruptionFilter = this.mZenModeHelper.getZenModeListenerInterruptionFilter();
        if (interruptionFilter == this.mInterruptionFilter) {
            return;
        }
        this.mInterruptionFilter = interruptionFilter;
        this.scheduleInterruptionFilterChanged(interruptionFilter);
    }

    INotificationManager getBinderService() {
        return INotificationManager.Stub.asInterface(this.mService);
    }

    NotificationManagerInternal getInternalService() {
        return this.mInternalService;
    }

    private void applyAdjustment(NotificationRecord r, Adjustment adjustment) {
        if (r == null) {
            return;
        }
        if (adjustment.getSignals() != null) {
            Bundle.setDefusable(adjustment.getSignals(), true);
            r.addAdjustment(adjustment);
        }
    }

    @GuardedBy(value="mNotificationLock")
    void addAutogroupKeyLocked(String key) {
        NotificationRecord r = this.mNotificationsByKey.get(key);
        if (r == null) {
            return;
        }
        if (r.sbn.getOverrideGroupKey() == null) {
            this.addAutoGroupAdjustment(r, "ranker_group");
            EventLogTags.writeNotificationAutogrouped(key);
            this.mRankingHandler.requestSort();
        }
    }

    @GuardedBy(value="mNotificationLock")
    void removeAutogroupKeyLocked(String key) {
        NotificationRecord r = this.mNotificationsByKey.get(key);
        if (r == null) {
            return;
        }
        if (r.sbn.getOverrideGroupKey() != null) {
            this.addAutoGroupAdjustment(r, null);
            EventLogTags.writeNotificationUnautogrouped(key);
            this.mRankingHandler.requestSort();
        }
    }

    private void addAutoGroupAdjustment(NotificationRecord r, String overrideGroupKey) {
        Bundle signals = new Bundle();
        signals.putString("key_group_key", overrideGroupKey);
        Adjustment adjustment = new Adjustment(r.sbn.getPackageName(), r.getKey(), signals, "", r.sbn.getUserId());
        r.addAdjustment(adjustment);
    }

    @GuardedBy(value="mNotificationLock")
    private void clearAutogroupSummaryLocked(int userId, String pkg) {
        NotificationRecord removed;
        ArrayMap<String, String> summaries = this.mAutobundledSummaries.get(userId);
        if (summaries != null && summaries.containsKey(pkg) && (removed = this.findNotificationByKeyLocked(summaries.remove(pkg))) != null) {
            boolean wasPosted = this.removeFromNotificationListsLocked(removed);
            this.cancelNotificationLocked(removed, false, 16, wasPosted, null);
        }
    }

    @GuardedBy(value="mNotificationLock")
    private boolean hasAutoGroupSummaryLocked(StatusBarNotification sbn) {
        ArrayMap<String, String> summaries = this.mAutobundledSummaries.get(sbn.getUserId());
        return summaries != null && summaries.containsKey(sbn.getPackageName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createAutoGroupSummary(int userId, String pkg, String triggeringKey) {
        NotificationRecord summaryRecord = null;
        Object object = this.mNotificationLock;
        synchronized (object) {
            NotificationRecord notificationRecord = this.mNotificationsByKey.get(triggeringKey);
            if (notificationRecord == null) {
                return;
            }
            StatusBarNotification adjustedSbn = notificationRecord.sbn;
            userId = adjustedSbn.getUser().getIdentifier();
            ArrayMap<String, String> summaries = this.mAutobundledSummaries.get(userId);
            if (summaries == null) {
                summaries = new ArrayMap();
            }
            this.mAutobundledSummaries.put(userId, summaries);
            if (!summaries.containsKey(pkg)) {
                ApplicationInfo appInfo = (ApplicationInfo)adjustedSbn.getNotification().extras.getParcelable("android.appInfo");
                Bundle extras = new Bundle();
                extras.putParcelable("android.appInfo", appInfo);
                String channelId = notificationRecord.getChannel().getId();
                Notification summaryNotification = new Notification.Builder(this.getContext(), channelId).setSmallIcon(adjustedSbn.getNotification().getSmallIcon()).setGroupSummary(true).setGroupAlertBehavior(2).setGroup("ranker_group").setFlag(1024, true).setFlag(512, true).setColor(adjustedSbn.getNotification().color).setLocalOnly(true).build();
                summaryNotification.extras.putAll(extras);
                Intent appIntent = this.getContext().getPackageManager().getLaunchIntentForPackage(pkg);
                if (appIntent != null) {
                    summaryNotification.contentIntent = PendingIntent.getActivityAsUser(this.getContext(), 0, appIntent, 0, null, UserHandle.of(userId));
                }
                StatusBarNotification summarySbn = new StatusBarNotification(adjustedSbn.getPackageName(), adjustedSbn.getOpPkg(), Integer.MAX_VALUE, "ranker_group", adjustedSbn.getUid(), adjustedSbn.getInitialPid(), summaryNotification, adjustedSbn.getUser(), "ranker_group", System.currentTimeMillis());
                summaryRecord = new NotificationRecord(this.getContext(), summarySbn, notificationRecord.getChannel());
                summaries.put(pkg, summarySbn.getKey());
            }
        }
        if (summaryRecord != null && this.checkDisqualifyingFeatures(userId, MY_UID, summaryRecord.sbn.getId(), summaryRecord.sbn.getTag(), summaryRecord, true)) {
            this.mHandler.post(new EnqueueNotificationRunnable(userId, summaryRecord));
        }
    }

    private String disableNotificationEffects(NotificationRecord record) {
        if (this.mDisableNotificationEffects) {
            return "booleanState";
        }
        if ((this.mListenerHints & 1) != 0) {
            return "listenerHints";
        }
        if (this.mCallState != 0 && !this.mZenModeHelper.isCall(record)) {
            return "callState";
        }
        return null;
    }

    private void dumpJson(PrintWriter pw, DumpFilter filter) {
        JSONObject dump = new JSONObject();
        try {
            dump.put("service", "Notification Manager");
            dump.put("bans", this.mRankingHelper.dumpBansJson(filter));
            dump.put("ranking", this.mRankingHelper.dumpJson(filter));
            dump.put("stats", this.mUsageStats.dumpJson(filter));
            dump.put("channels", this.mRankingHelper.dumpChannelsJson(filter));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        pw.println(dump);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpProto(FileDescriptor fd, DumpFilter filter) {
        ProtoOutputStream proto = new ProtoOutputStream(fd);
        Object object = this.mNotificationLock;
        synchronized (object) {
            List<NotificationRecord> snoozed;
            NotificationRecord nr;
            int i;
            long records = proto.start(0x21100000001L);
            int N = this.mNotificationList.size();
            if (N > 0) {
                for (i = 0; i < N; ++i) {
                    nr = this.mNotificationList.get(i);
                    if (filter.filtered && !filter.matches(nr.sbn)) continue;
                    nr.dump(proto, filter.redact);
                    proto.write(0x11000000002L, 1);
                }
            }
            if ((N = this.mEnqueuedNotifications.size()) > 0) {
                for (i = 0; i < N; ++i) {
                    nr = this.mEnqueuedNotifications.get(i);
                    if (filter.filtered && !filter.matches(nr.sbn)) continue;
                    nr.dump(proto, filter.redact);
                    proto.write(0x11000000002L, 0);
                }
            }
            if ((N = (snoozed = this.mSnoozeHelper.getSnoozed()).size()) > 0) {
                for (int i2 = 0; i2 < N; ++i2) {
                    NotificationRecord nr2 = snoozed.get(i2);
                    if (filter.filtered && !filter.matches(nr2.sbn)) continue;
                    nr2.dump(proto, filter.redact);
                    proto.write(0x11000000002L, 2);
                }
            }
            proto.end(records);
        }
        long zenLog = proto.start(0x11100000002L);
        this.mZenModeHelper.dump(proto);
        for (ComponentName suppressor : this.mEffectsSuppressors) {
            proto.write(2259152797700L, suppressor.toString());
        }
        proto.end(zenLog);
        proto.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dumpImpl(PrintWriter pw, DumpFilter filter) {
        int i;
        int N;
        Object object;
        boolean zenOnly;
        pw.print("Current Notification Manager state");
        if (filter.filtered) {
            pw.print(" (filtered to ");
            pw.print(filter);
            pw.print(")");
        }
        pw.println(':');
        boolean bl = zenOnly = filter.filtered && filter.zen;
        if (!zenOnly) {
            object = this.mToastQueue;
            synchronized (object) {
                N = this.mToastQueue.size();
                if (N > 0) {
                    pw.println("  Toast Queue:");
                    for (i = 0; i < N; ++i) {
                        this.mToastQueue.get(i).dump(pw, "    ", filter);
                    }
                    pw.println("  ");
                }
            }
        }
        object = this.mNotificationLock;
        synchronized (object) {
            if (!zenOnly) {
                N = this.mNotificationList.size();
                if (N > 0) {
                    pw.println("  Notification List:");
                    for (i = 0; i < N; ++i) {
                        NotificationRecord nr = this.mNotificationList.get(i);
                        if (filter.filtered && !filter.matches(nr.sbn)) continue;
                        nr.dump(pw, "    ", this.getContext(), filter.redact);
                    }
                    pw.println("  ");
                }
                if (!filter.filtered) {
                    N = this.mLights.size();
                    if (N > 0) {
                        pw.println("  Lights List:");
                        for (i = 0; i < N; ++i) {
                            if (i == N - 1) {
                                pw.print("  > ");
                            } else {
                                pw.print("    ");
                            }
                            pw.println(this.mLights.get(i));
                        }
                        pw.println("  ");
                    }
                    pw.println("  mUseAttentionLight=" + this.mUseAttentionLight);
                    pw.println("  mNotificationPulseEnabled=" + this.mNotificationPulseEnabled);
                    pw.println("  mSoundNotificationKey=" + this.mSoundNotificationKey);
                    pw.println("  mVibrateNotificationKey=" + this.mVibrateNotificationKey);
                    pw.println("  mDisableNotificationEffects=" + this.mDisableNotificationEffects);
                    pw.println("  mCallState=" + NotificationManagerService.callStateToString(this.mCallState));
                    pw.println("  mSystemReady=" + this.mSystemReady);
                    pw.println("  mMaxPackageEnqueueRate=" + this.mMaxPackageEnqueueRate);
                }
                pw.println("  mArchive=" + this.mArchive.toString());
                Iterator<StatusBarNotification> iter = this.mArchive.descendingIterator();
                int j = 0;
                while (iter.hasNext()) {
                    StatusBarNotification sbn = iter.next();
                    if (filter != null && !filter.matches(sbn)) continue;
                    pw.println("    " + sbn);
                    if (++j < 5) continue;
                    if (!iter.hasNext()) break;
                    pw.println("    ...");
                    break;
                }
                if (!zenOnly) {
                    N = this.mEnqueuedNotifications.size();
                    if (N > 0) {
                        pw.println("  Enqueued Notification List:");
                        for (int i2 = 0; i2 < N; ++i2) {
                            NotificationRecord nr = this.mEnqueuedNotifications.get(i2);
                            if (filter.filtered && !filter.matches(nr.sbn)) continue;
                            nr.dump(pw, "    ", this.getContext(), filter.redact);
                        }
                        pw.println("  ");
                    }
                    this.mSnoozeHelper.dump(pw, filter);
                }
            }
            if (!zenOnly) {
                pw.println("\n  Ranking Config:");
                this.mRankingHelper.dump(pw, "    ", filter);
                pw.println("\n  Notification listeners:");
                this.mListeners.dump(pw, filter);
                pw.print("    mListenerHints: ");
                pw.println(this.mListenerHints);
                pw.print("    mListenersDisablingEffects: (");
                N = this.mListenersDisablingEffects.size();
                for (int i3 = 0; i3 < N; ++i3) {
                    int hint = this.mListenersDisablingEffects.keyAt(i3);
                    if (i3 > 0) {
                        pw.print(';');
                    }
                    pw.print("hint[" + hint + "]:");
                    ArraySet<ManagedServices.ManagedServiceInfo> listeners = this.mListenersDisablingEffects.valueAt(i3);
                    int listenerSize = listeners.size();
                    for (int j = 0; j < listenerSize; ++j) {
                        if (i3 > 0) {
                            pw.print(',');
                        }
                        ManagedServices.ManagedServiceInfo listener = listeners.valueAt(i3);
                        pw.print(listener.component);
                    }
                }
                pw.println(')');
                pw.println("\n  Notification assistant services:");
                this.mAssistants.dump(pw, filter);
            }
            if (!filter.filtered || zenOnly) {
                pw.println("\n  Zen Mode:");
                pw.print("    mInterruptionFilter=");
                pw.println(this.mInterruptionFilter);
                this.mZenModeHelper.dump(pw, "    ");
                pw.println("\n  Zen Log:");
                ZenLog.dump(pw, "    ");
            }
            pw.println("\n  Condition providers:");
            this.mConditionProviders.dump(pw, filter);
            pw.println("\n  Group summaries:");
            for (Map.Entry<String, NotificationRecord> entry : this.mSummaryByGroupKey.entrySet()) {
                NotificationRecord r = entry.getValue();
                pw.println("    " + entry.getKey() + " -> " + r.getKey());
                if (this.mNotificationsByKey.get(r.getKey()) == r) continue;
                pw.println("!!!!!!LEAK: Record not found in mNotificationsByKey.");
                r.dump(pw, "      ", this.getContext(), filter.redact);
            }
            if (!zenOnly) {
                pw.println("\n  Usage Stats:");
                this.mUsageStats.dump(pw, "    ", filter);
            }
        }
    }

    void enqueueNotificationInternal(String pkg, String opPkg, int callingUid, int callingPid, String tag, int id2, Notification notification, int incomingUserId) {
        int intentCount;
        NotificationChannel channel;
        if (DBG) {
            Slog.v(TAG, "enqueueNotificationInternal: pkg=" + pkg + " id=" + id2 + " notification=" + notification);
        }
        this.checkCallerIsSystemOrSameApp(pkg);
        int userId = ActivityManager.handleIncomingUser(callingPid, callingUid, incomingUserId, true, false, "enqueueNotification", pkg);
        UserHandle user = new UserHandle(userId);
        if (pkg == null || notification == null) {
            throw new IllegalArgumentException("null not allowed: pkg=" + pkg + " id=" + id2 + " notification=" + notification);
        }
        int notificationUid = this.resolveNotificationUid(opPkg, callingUid, userId);
        try {
            ApplicationInfo ai = this.mPackageManagerClient.getApplicationInfoAsUser(pkg, 0x10000000, userId == -1 ? 0 : userId);
            Notification.addFieldsFromContext(ai, notification);
            int canColorize = this.mPackageManagerClient.checkPermission("android.permission.USE_COLORIZED_NOTIFICATIONS", pkg);
            notification.flags = canColorize == 0 ? (notification.flags |= 0x800) : (notification.flags &= 0xFFFFF7FF);
        }
        catch (PackageManager.NameNotFoundException e) {
            Slog.e(TAG, "Cannot create a context for sending app", e);
            return;
        }
        this.mUsageStats.registerEnqueuedByApp(pkg);
        String channelId = notification.getChannelId();
        if (this.mIsTelevision && new Notification.TvExtender(notification).getChannelId() != null) {
            channelId = new Notification.TvExtender(notification).getChannelId();
        }
        if ((channel = this.mRankingHelper.getNotificationChannel(pkg, notificationUid, channelId, false)) == null) {
            String noChannelStr = "No Channel found for pkg=" + pkg + ", channelId=" + channelId + ", id=" + id2 + ", tag=" + tag + ", opPkg=" + opPkg + ", callingUid=" + callingUid + ", userId=" + userId + ", incomingUserId=" + incomingUserId + ", notificationUid=" + notificationUid + ", notification=" + notification;
            Log.e(TAG, noChannelStr);
            this.doChannelWarningToast("Developer warning for package \"" + pkg + "\"\nFailed to post notification on channel \"" + channelId + "\"\nSee log for more details");
            return;
        }
        StatusBarNotification n = new StatusBarNotification(pkg, opPkg, id2, tag, notificationUid, callingPid, notification, user, null, System.currentTimeMillis());
        NotificationRecord r = new NotificationRecord(this.getContext(), n, channel);
        if ((notification.flags & 0x40) != 0 && (channel.getUserLockedFields() & 4) == 0 && (r.getImportance() == 1 || r.getImportance() == 0)) {
            if (TextUtils.isEmpty(channelId) || "miscellaneous".equals(channelId)) {
                r.setImportance(2, "Bumped for foreground service");
            } else {
                channel.setImportance(2);
                this.mRankingHelper.updateNotificationChannel(pkg, notificationUid, channel, false);
                r.updateNotificationChannel(channel);
            }
        }
        if (!this.checkDisqualifyingFeatures(userId, notificationUid, id2, tag, r, r.sbn.getOverrideGroupKey() != null)) {
            return;
        }
        if (notification.allPendingIntents != null && (intentCount = notification.allPendingIntents.size()) > 0) {
            ActivityManagerInternal am = LocalServices.getService(ActivityManagerInternal.class);
            long duration = LocalServices.getService(DeviceIdleController.LocalService.class).getNotificationWhitelistDuration();
            for (int i = 0; i < intentCount; ++i) {
                PendingIntent pendingIntent = notification.allPendingIntents.valueAt(i);
                if (pendingIntent == null) continue;
                am.setPendingIntentWhitelistDuration(pendingIntent.getTarget(), WHITELIST_TOKEN, duration);
            }
        }
        this.mHandler.post(new EnqueueNotificationRunnable(userId, r));
    }

    private void doChannelWarningToast(CharSequence toastText) {
        boolean warningEnabled;
        int defaultWarningEnabled = Build.IS_DEBUGGABLE ? 1 : 0;
        boolean bl = warningEnabled = Settings.Global.getInt(this.getContext().getContentResolver(), "show_notification_channel_warnings", defaultWarningEnabled) != 0;
        if (warningEnabled) {
            Toast toast = Toast.makeText(this.getContext(), this.mHandler.getLooper(), toastText, 0);
            toast.show();
        }
    }

    private int resolveNotificationUid(String opPackageName, int callingUid, int userId) {
        if (this.isCallerSystemOrPhone() && opPackageName != null && !"android".equals(opPackageName)) {
            try {
                return this.getContext().getPackageManager().getPackageUidAsUser(opPackageName, userId);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                // empty catch block
            }
        }
        return callingUid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkDisqualifyingFeatures(int userId, int callingUid, int id2, String tag, NotificationRecord r, boolean isAutogroup) {
        String pkg = r.sbn.getPackageName();
        String dialerPackage = this.getContext().getSystemService(TelecomManager.class).getSystemDialerPackage();
        boolean isSystemNotification = this.isUidSystemOrPhone(callingUid) || "android".equals(pkg) || TextUtils.equals(pkg, dialerPackage);
        boolean isNotificationFromListener = this.mListeners.isListenerPackage(pkg);
        if (!isSystemNotification && !isNotificationFromListener) {
            Object object = this.mNotificationLock;
            synchronized (object) {
                float appEnqueueRate;
                if (this.mNotificationsByKey.get(r.sbn.getKey()) == null && this.isCallerInstantApp(pkg)) {
                    throw new SecurityException("Instant app " + pkg + " cannot create notifications");
                }
                if (this.mNotificationsByKey.get(r.sbn.getKey()) != null && !r.getNotification().hasCompletedProgress() && !isAutogroup && (appEnqueueRate = this.mUsageStats.getAppEnqueueRate(pkg)) > this.mMaxPackageEnqueueRate) {
                    this.mUsageStats.registerOverRateQuota(pkg);
                    long now = SystemClock.elapsedRealtime();
                    if (now - this.mLastOverRateLogTime > 5000L) {
                        Slog.e(TAG, "Package enqueue rate is " + appEnqueueRate + ". Shedding " + r.sbn.getKey() + ". package=" + pkg);
                        this.mLastOverRateLogTime = now;
                    }
                    return false;
                }
                int count = this.getNotificationCountLocked(pkg, userId, id2, tag);
                if (count >= 50) {
                    this.mUsageStats.registerOverCountQuota(pkg);
                    Slog.e(TAG, "Package has already posted or enqueued " + count + " notifications.  Not showing more.  package=" + pkg);
                    return false;
                }
            }
        }
        if (this.mSnoozeHelper.isSnoozed(userId, pkg, r.getKey())) {
            MetricsLogger.action(r.getLogMaker().setType(6).setCategory(831));
            if (DBG) {
                Slog.d(TAG, "Ignored enqueue for snoozed notification " + r.getKey());
            }
            this.mSnoozeHelper.update(userId, r);
            this.savePolicyFile();
            return false;
        }
        return !this.isBlocked(r, this.mUsageStats);
    }

    protected int getNotificationCountLocked(String pkg, int userId, int excludedId, String excludedTag) {
        int count = 0;
        int N = this.mNotificationList.size();
        for (int i = 0; i < N; ++i) {
            NotificationRecord existing = this.mNotificationList.get(i);
            if (!existing.sbn.getPackageName().equals(pkg) || existing.sbn.getUserId() != userId || existing.sbn.getId() == excludedId && TextUtils.equals(existing.sbn.getTag(), excludedTag)) continue;
            ++count;
        }
        int M = this.mEnqueuedNotifications.size();
        for (int i = 0; i < M; ++i) {
            NotificationRecord existing = this.mEnqueuedNotifications.get(i);
            if (!existing.sbn.getPackageName().equals(pkg) || existing.sbn.getUserId() != userId) continue;
            ++count;
        }
        return count;
    }

    protected boolean isBlocked(NotificationRecord r, NotificationUsageStats usageStats) {
        boolean isBlocked;
        int callingUid;
        String pkg = r.sbn.getPackageName();
        boolean isPackageSuspended = this.isPackageSuspendedForUser(pkg, callingUid = r.sbn.getUid());
        if (isPackageSuspended) {
            Slog.e(TAG, "Suppressing notification from package due to package suspended by administrator.");
            usageStats.registerSuspendedByAdmin(r);
            return isPackageSuspended;
        }
        boolean bl = isBlocked = this.mRankingHelper.getImportance(pkg, callingUid) == 0 || r.getChannel().getImportance() == 0;
        if (isBlocked) {
            Slog.e(TAG, "Suppressing notification from package by user request.");
            usageStats.registerBlocked(r);
        }
        return isBlocked;
    }

    @GuardedBy(value="mNotificationLock")
    private void handleGroupedNotificationLocked(NotificationRecord r, NotificationRecord old, int callingUid, int callingPid) {
        NotificationRecord removedSummary;
        boolean oldIsSummary;
        StatusBarNotification sbn = r.sbn;
        Notification n = sbn.getNotification();
        if (n.isGroupSummary() && !sbn.isAppGroup()) {
            n.flags &= 0xFFFFFDFF;
        }
        String group = sbn.getGroupKey();
        boolean isSummary = n.isGroupSummary();
        Notification oldN = old != null ? old.sbn.getNotification() : null;
        String oldGroup = old != null ? old.sbn.getGroupKey() : null;
        boolean bl = oldIsSummary = old != null && oldN.isGroupSummary();
        if (oldIsSummary && (removedSummary = this.mSummaryByGroupKey.remove(oldGroup)) != old) {
            String removedKey = removedSummary != null ? removedSummary.getKey() : "<null>";
            Slog.w(TAG, "Removed summary didn't match old notification: old=" + old.getKey() + ", removed=" + removedKey);
        }
        if (isSummary) {
            this.mSummaryByGroupKey.put(group, r);
        }
        if (!(!oldIsSummary || isSummary && oldGroup.equals(group))) {
            this.cancelGroupChildrenLocked(old, callingUid, callingPid, null, false, null);
        }
    }

    @GuardedBy(value="mNotificationLock")
    void scheduleTimeoutLocked(NotificationRecord record) {
        if (record.getNotification().getTimeoutAfter() > 0L) {
            PendingIntent pi = PendingIntent.getBroadcast(this.getContext(), 1, new Intent(ACTION_NOTIFICATION_TIMEOUT).setData(new Uri.Builder().scheme(SCHEME_TIMEOUT).appendPath(record.getKey()).build()).addFlags(0x10000000).putExtra(EXTRA_KEY, record.getKey()), 0x8000000);
            this.mAlarmManager.setExactAndAllowWhileIdle(2, SystemClock.elapsedRealtime() + record.getNotification().getTimeoutAfter(), pi);
        }
    }

    @GuardedBy(value="mNotificationLock")
    void buzzBeepBlinkLocked(NotificationRecord record) {
        boolean buzz = false;
        boolean beep = false;
        boolean blink = false;
        Notification notification = record.sbn.getNotification();
        String key = record.getKey();
        boolean aboveThreshold = record.getImportance() >= 3;
        boolean wasBeep = key != null && key.equals(this.mSoundNotificationKey);
        boolean wasBuzz = key != null && key.equals(this.mVibrateNotificationKey);
        boolean hasValidVibrate = false;
        boolean hasValidSound = false;
        boolean sentAccessibilityEvent = false;
        if (!record.isUpdate && record.getImportance() > 1) {
            this.sendAccessibilityEvent(notification, record.sbn.getPackageName());
            sentAccessibilityEvent = true;
        }
        if (aboveThreshold && this.isNotificationForCurrentUser(record) && this.mSystemReady && this.mAudioManager != null) {
            boolean hasAudibleAlert;
            Uri soundUri = record.getSound();
            hasValidSound = soundUri != null && !Uri.EMPTY.equals(soundUri);
            long[] vibration = record.getVibration();
            if (vibration == null && hasValidSound && this.mAudioManager.getRingerModeInternal() == 1 && this.mAudioManager.getStreamVolume(AudioAttributes.toLegacyStreamType(record.getAudioAttributes())) == 0) {
                vibration = this.mFallbackVibrationPattern;
            }
            hasValidVibrate = vibration != null;
            boolean bl = hasAudibleAlert = hasValidSound || hasValidVibrate;
            if (hasAudibleAlert && !this.shouldMuteNotificationLocked(record)) {
                boolean ringerModeSilent;
                if (!sentAccessibilityEvent) {
                    this.sendAccessibilityEvent(notification, record.sbn.getPackageName());
                    sentAccessibilityEvent = true;
                }
                if (DBG) {
                    Slog.v(TAG, "Interrupting!");
                }
                if (hasValidSound) {
                    this.mSoundNotificationKey = key;
                    if (this.mInCall) {
                        this.playInCallNotification();
                        beep = true;
                    } else {
                        beep = this.playSound(record, soundUri);
                    }
                }
                boolean bl2 = ringerModeSilent = this.mAudioManager.getRingerModeInternal() == 0;
                if (!this.mInCall && hasValidVibrate && !ringerModeSilent) {
                    this.mVibrateNotificationKey = key;
                    buzz = this.playVibration(record, vibration, hasValidSound);
                }
            }
        }
        if (wasBeep && !hasValidSound) {
            this.clearSoundLocked();
        }
        if (wasBuzz && !hasValidVibrate) {
            this.clearVibrateLocked();
        }
        boolean wasShowLights = this.mLights.remove(key);
        if (record.getLight() != null && aboveThreshold && (record.getSuppressedVisualEffects() & 1) == 0) {
            this.mLights.add(key);
            this.updateLightsLocked();
            if (this.mUseAttentionLight) {
                this.mAttentionLight.pulse();
            }
            blink = true;
        } else if (wasShowLights) {
            this.updateLightsLocked();
        }
        if (buzz || beep || blink) {
            MetricsLogger.action(record.getLogMaker().setCategory(199).setType(1).setSubtype((buzz ? 1 : 0) | (beep ? 2 : 0) | (blink ? 4 : 0)));
            EventLogTags.writeNotificationAlert(key, buzz ? 1 : 0, beep ? 1 : 0, blink ? 1 : 0);
        }
    }

    @GuardedBy(value="mNotificationLock")
    boolean shouldMuteNotificationLocked(NotificationRecord record) {
        Notification notification = record.getNotification();
        if (record.isUpdate && (notification.flags & 8) != 0) {
            return true;
        }
        String disableEffects = this.disableNotificationEffects(record);
        if (disableEffects != null) {
            ZenLog.traceDisableEffects(record, disableEffects);
            return true;
        }
        if (record.isIntercepted()) {
            return true;
        }
        if (record.sbn.isGroup()) {
            return notification.suppressAlertingDueToGrouping();
        }
        String pkg = record.sbn.getPackageName();
        if (this.mUsageStats.isAlertRateLimited(pkg)) {
            Slog.e(TAG, "Muting recently noisy " + record.getKey());
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean playSound(NotificationRecord record, Uri soundUri) {
        boolean looping;
        boolean bl = looping = (record.getNotification().flags & 4) != 0;
        if (!(this.mAudioManager.isAudioFocusExclusive() || this.mAudioManager.getRingerModeInternal() == 1 && this.mAudioManager.getStreamVolume(AudioAttributes.toLegacyStreamType(record.getAudioAttributes())) == 0)) {
            long identity = Binder.clearCallingIdentity();
            try {
                IRingtonePlayer player = this.mAudioManager.getRingtonePlayer();
                if (player != null) {
                    if (DBG) {
                        Slog.v(TAG, "Playing sound " + soundUri + " with attributes " + record.getAudioAttributes());
                    }
                    player.playAsync(soundUri, record.sbn.getUser(), looping, record.getAudioAttributes());
                    boolean bl2 = true;
                    return bl2;
                }
            }
            catch (RemoteException remoteException) {
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean playVibration(NotificationRecord record, long[] vibration, boolean delayVibForSound) {
        long identity = Binder.clearCallingIdentity();
        try {
            VibrationEffect effect;
            try {
                boolean insistent = (record.getNotification().flags & 4) != 0;
                effect = VibrationEffect.createWaveform(vibration, insistent ? 0 : -1);
            }
            catch (IllegalArgumentException e) {
                Slog.e(TAG, "Error creating vibration waveform with pattern: " + Arrays.toString(vibration));
                boolean bl = false;
                Binder.restoreCallingIdentity(identity);
                return bl;
            }
            if (delayVibForSound) {
                new Thread(() -> {
                    int waitMs = this.mAudioManager.getFocusRampTimeMs(3, record.getAudioAttributes());
                    if (DBG) {
                        Slog.v(TAG, "Delaying vibration by " + waitMs + "ms");
                    }
                    try {
                        Thread.sleep(waitMs);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.mVibrator.vibrate(record.sbn.getUid(), record.sbn.getOpPkg(), effect, record.getAudioAttributes());
                }).start();
            } else {
                this.mVibrator.vibrate(record.sbn.getUid(), record.sbn.getOpPkg(), effect, record.getAudioAttributes());
            }
            boolean bl = true;
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isNotificationForCurrentUser(NotificationRecord record) {
        int currentUser;
        long token = Binder.clearCallingIdentity();
        try {
            currentUser = ActivityManager.getCurrentUser();
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
        return record.getUserId() == -1 || record.getUserId() == currentUser || this.mUserProfiles.isCurrentProfile(record.getUserId());
    }

    protected void playInCallNotification() {
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                long identity = Binder.clearCallingIdentity();
                try {
                    IRingtonePlayer player = NotificationManagerService.this.mAudioManager.getRingtonePlayer();
                    if (player != null) {
                        player.play(new Binder(), NotificationManagerService.this.mInCallNotificationUri, NotificationManagerService.this.mInCallNotificationAudioAttributes, NotificationManagerService.this.mInCallNotificationVolume, false);
                    }
                }
                catch (RemoteException remoteException) {
                }
                finally {
                    Binder.restoreCallingIdentity(identity);
                }
            }
        }.start();
    }

    @GuardedBy(value="mToastQueue")
    void showNextToastLocked() {
        ToastRecord record = this.mToastQueue.get(0);
        while (record != null) {
            if (DBG) {
                Slog.d(TAG, "Show pkg=" + record.pkg + " callback=" + record.callback);
            }
            try {
                record.callback.show(record.token);
                this.scheduleTimeoutLocked(record);
                return;
            }
            catch (RemoteException e) {
                Slog.w(TAG, "Object died trying to show notification " + record.callback + " in package " + record.pkg);
                int index = this.mToastQueue.indexOf(record);
                if (index >= 0) {
                    this.mToastQueue.remove(index);
                }
                this.keepProcessAliveIfNeededLocked(record.pid);
                if (this.mToastQueue.size() > 0) {
                    record = this.mToastQueue.get(0);
                    continue;
                }
                record = null;
            }
        }
    }

    @GuardedBy(value="mToastQueue")
    void cancelToastLocked(int index) {
        ToastRecord record = this.mToastQueue.get(index);
        try {
            record.callback.hide();
        }
        catch (RemoteException e) {
            Slog.w(TAG, "Object died trying to hide notification " + record.callback + " in package " + record.pkg);
        }
        ToastRecord lastToast = this.mToastQueue.remove(index);
        this.mWindowManagerInternal.removeWindowToken(lastToast.token, true, 0);
        this.keepProcessAliveIfNeededLocked(record.pid);
        if (this.mToastQueue.size() > 0) {
            this.showNextToastLocked();
        }
    }

    @GuardedBy(value="mToastQueue")
    private void scheduleTimeoutLocked(ToastRecord r) {
        this.mHandler.removeCallbacksAndMessages(r);
        Message m = Message.obtain(this.mHandler, 2, r);
        long delay = r.duration == 1 ? 3500L : 2000L;
        this.mHandler.sendMessageDelayed(m, delay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleTimeout(ToastRecord record) {
        if (DBG) {
            Slog.d(TAG, "Timeout pkg=" + record.pkg + " callback=" + record.callback);
        }
        ArrayList<ToastRecord> arrayList = this.mToastQueue;
        synchronized (arrayList) {
            int index = this.indexOfToastLocked(record.pkg, record.callback);
            if (index >= 0) {
                this.cancelToastLocked(index);
            }
        }
    }

    @GuardedBy(value="mToastQueue")
    int indexOfToastLocked(String pkg, ITransientNotification callback) {
        IBinder cbak = callback.asBinder();
        ArrayList<ToastRecord> list = this.mToastQueue;
        int len = list.size();
        for (int i = 0; i < len; ++i) {
            ToastRecord r = list.get(i);
            if (!r.pkg.equals(pkg) || !r.callback.asBinder().equals(cbak)) continue;
            return i;
        }
        return -1;
    }

    @GuardedBy(value="mToastQueue")
    int indexOfToastPackageLocked(String pkg) {
        ArrayList<ToastRecord> list = this.mToastQueue;
        int len = list.size();
        for (int i = 0; i < len; ++i) {
            ToastRecord r = list.get(i);
            if (!r.pkg.equals(pkg)) continue;
            return i;
        }
        return -1;
    }

    @GuardedBy(value="mToastQueue")
    void keepProcessAliveIfNeededLocked(int pid) {
        int toastCount = 0;
        ArrayList<ToastRecord> list = this.mToastQueue;
        int N = list.size();
        for (int i = 0; i < N; ++i) {
            ToastRecord r = list.get(i);
            if (r.pid != pid) continue;
            ++toastCount;
        }
        try {
            this.mAm.setProcessImportant(this.mForegroundToken, pid, toastCount > 0, "toast");
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRankingReconsideration(Message message) {
        boolean changed;
        if (!(message.obj instanceof RankingReconsideration)) {
            return;
        }
        RankingReconsideration recon = (RankingReconsideration)message.obj;
        recon.run();
        Object object = this.mNotificationLock;
        synchronized (object) {
            NotificationRecord record = this.mNotificationsByKey.get(recon.getKey());
            if (record == null) {
                return;
            }
            int indexBefore = this.findNotificationRecordIndexLocked(record);
            boolean interceptBefore = record.isIntercepted();
            float contactAffinityBefore = record.getContactAffinity();
            int visibilityBefore = record.getPackageVisibilityOverride();
            recon.applyChangesLocked(record);
            this.applyZenModeLocked(record);
            this.mRankingHelper.sort(this.mNotificationList);
            int indexAfter = this.findNotificationRecordIndexLocked(record);
            boolean interceptAfter = record.isIntercepted();
            float contactAffinityAfter = record.getContactAffinity();
            int visibilityAfter = record.getPackageVisibilityOverride();
            boolean bl = changed = indexBefore != indexAfter || interceptBefore != interceptAfter || visibilityBefore != visibilityAfter;
            if (interceptBefore && !interceptAfter && Float.compare(contactAffinityBefore, contactAffinityAfter) != 0) {
                this.buzzBeepBlinkLocked(record);
            }
        }
        if (changed) {
            this.mHandler.scheduleSendRankingUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleRankingSort() {
        if (this.mRankingHelper == null) {
            return;
        }
        Object object = this.mNotificationLock;
        synchronized (object) {
            NotificationRecord r;
            int i;
            int N = this.mNotificationList.size();
            ArrayList<String> orderBefore = new ArrayList<String>(N);
            int[] visibilities = new int[N];
            boolean[] showBadges = new boolean[N];
            ArrayList<NotificationChannel> channelBefore = new ArrayList<NotificationChannel>(N);
            ArrayList<String> groupKeyBefore = new ArrayList<String>(N);
            ArrayList<ArrayList<String>> overridePeopleBefore = new ArrayList<ArrayList<String>>(N);
            ArrayList<ArrayList<SnoozeCriterion>> snoozeCriteriaBefore = new ArrayList<ArrayList<SnoozeCriterion>>(N);
            for (i = 0; i < N; ++i) {
                r = this.mNotificationList.get(i);
                orderBefore.add(r.getKey());
                visibilities[i] = r.getPackageVisibilityOverride();
                showBadges[i] = r.canShowBadge();
                channelBefore.add(r.getChannel());
                groupKeyBefore.add(r.getGroupKey());
                overridePeopleBefore.add(r.getPeopleOverride());
                snoozeCriteriaBefore.add(r.getSnoozeCriteria());
                this.mRankingHelper.extractSignals(r);
            }
            this.mRankingHelper.sort(this.mNotificationList);
            for (i = 0; i < N; ++i) {
                r = this.mNotificationList.get(i);
                if (((String)orderBefore.get(i)).equals(r.getKey()) && visibilities[i] == r.getPackageVisibilityOverride() && showBadges[i] == r.canShowBadge() && Objects.equals(channelBefore.get(i), r.getChannel()) && Objects.equals(groupKeyBefore.get(i), r.getGroupKey()) && Objects.equals(overridePeopleBefore.get(i), r.getPeopleOverride()) && Objects.equals(snoozeCriteriaBefore.get(i), r.getSnoozeCriteria())) continue;
                this.mHandler.scheduleSendRankingUpdate();
                return;
            }
        }
    }

    @GuardedBy(value="mNotificationLock")
    private void recordCallerLocked(NotificationRecord record) {
        if (this.mZenModeHelper.isCall(record)) {
            this.mZenModeHelper.recordCaller(record);
        }
    }

    @GuardedBy(value="mNotificationLock")
    private void applyZenModeLocked(NotificationRecord record) {
        record.setIntercepted(this.mZenModeHelper.shouldIntercept(record));
        if (record.isIntercepted()) {
            int suppressed = (this.mZenModeHelper.shouldSuppressWhenScreenOff() ? 1 : 0) | (this.mZenModeHelper.shouldSuppressWhenScreenOn() ? 2 : 0);
            record.setSuppressedVisualEffects(suppressed);
        } else {
            record.setSuppressedVisualEffects(0);
        }
    }

    @GuardedBy(value="mNotificationLock")
    private int findNotificationRecordIndexLocked(NotificationRecord target) {
        return this.mRankingHelper.indexOf(this.mNotificationList, target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSendRankingUpdate() {
        Object object = this.mNotificationLock;
        synchronized (object) {
            this.mListeners.notifyRankingUpdateLocked();
        }
    }

    private void scheduleListenerHintsChanged(int state) {
        this.mHandler.removeMessages(5);
        this.mHandler.obtainMessage(5, state, 0).sendToTarget();
    }

    private void scheduleInterruptionFilterChanged(int listenerInterruptionFilter) {
        this.mHandler.removeMessages(6);
        this.mHandler.obtainMessage(6, listenerInterruptionFilter, 0).sendToTarget();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleListenerHintsChanged(int hints) {
        Object object = this.mNotificationLock;
        synchronized (object) {
            this.mListeners.notifyListenerHintsChangedLocked(hints);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleListenerInterruptionFilterChanged(int interruptionFilter) {
        Object object = this.mNotificationLock;
        synchronized (object) {
            this.mListeners.notifyInterruptionFilterChanged(interruptionFilter);
        }
    }

    static int clamp(int x, int low, int high) {
        return x < low ? low : (x > high ? high : x);
    }

    void sendAccessibilityEvent(Notification notification, CharSequence packageName) {
        if (!this.mAccessibilityManager.isEnabled()) {
            return;
        }
        AccessibilityEvent event = AccessibilityEvent.obtain(64);
        event.setPackageName(packageName);
        event.setClassName(Notification.class.getName());
        event.setParcelableData(notification);
        CharSequence tickerText = notification.tickerText;
        if (!TextUtils.isEmpty(tickerText)) {
            event.getText().add(tickerText);
        }
        this.mAccessibilityManager.sendAccessibilityEvent(event);
    }

    @GuardedBy(value="mNotificationLock")
    private boolean removeFromNotificationListsLocked(NotificationRecord r) {
        boolean wasPosted = false;
        NotificationRecord recordInList = null;
        recordInList = this.findNotificationByListLocked(this.mNotificationList, r.getKey());
        if (recordInList != null) {
            this.mNotificationList.remove(recordInList);
            this.mNotificationsByKey.remove(recordInList.sbn.getKey());
            wasPosted = true;
        }
        while ((recordInList = this.findNotificationByListLocked(this.mEnqueuedNotifications, r.getKey())) != null) {
            this.mEnqueuedNotifications.remove(recordInList);
        }
        return wasPosted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value="mNotificationLock")
    private void cancelNotificationLocked(final NotificationRecord r, boolean sendDelete, int reason, boolean wasPosted, String listenerName) {
        ArrayMap<String, String> summaries;
        String canceledKey = r.getKey();
        this.recordCallerLocked(r);
        if (sendDelete && r.getNotification().deleteIntent != null) {
            try {
                r.getNotification().deleteIntent.send();
            }
            catch (PendingIntent.CanceledException ex) {
                Slog.w(TAG, "canceled PendingIntent for " + r.sbn.getPackageName(), ex);
            }
        }
        if (wasPosted) {
            long identity;
            if (r.getNotification().getSmallIcon() != null) {
                if (reason != 18) {
                    r.isCanceled = true;
                }
                this.mListeners.notifyRemovedLocked(r.sbn, reason);
                this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        NotificationManagerService.this.mGroupHelper.onNotificationRemoved(r.sbn);
                    }
                });
            }
            if (canceledKey.equals(this.mSoundNotificationKey)) {
                this.mSoundNotificationKey = null;
                identity = Binder.clearCallingIdentity();
                try {
                    IRingtonePlayer player = this.mAudioManager.getRingtonePlayer();
                    if (player != null) {
                        player.stopAsync();
                    }
                }
                catch (RemoteException player) {
                }
                finally {
                    Binder.restoreCallingIdentity(identity);
                }
            }
            if (canceledKey.equals(this.mVibrateNotificationKey)) {
                this.mVibrateNotificationKey = null;
                identity = Binder.clearCallingIdentity();
                try {
                    this.mVibrator.cancel();
                }
                finally {
                    Binder.restoreCallingIdentity(identity);
                }
            }
            this.mLights.remove(canceledKey);
        }
        switch (reason) {
            case 2: 
            case 3: 
            case 10: 
            case 11: {
                this.mUsageStats.registerDismissedByUser(r);
                break;
            }
            case 8: 
            case 9: {
                this.mUsageStats.registerRemovedByApp(r);
            }
        }
        String groupKey = r.getGroupKey();
        NotificationRecord groupSummary = this.mSummaryByGroupKey.get(groupKey);
        if (groupSummary != null && groupSummary.getKey().equals(canceledKey)) {
            this.mSummaryByGroupKey.remove(groupKey);
        }
        if ((summaries = this.mAutobundledSummaries.get(r.sbn.getUserId())) != null && r.sbn.getKey().equals(summaries.get(r.sbn.getPackageName()))) {
            summaries.remove(r.sbn.getPackageName());
        }
        this.mArchive.record(r.sbn);
        long now = System.currentTimeMillis();
        MetricsLogger.action(r.getLogMaker(now).setCategory(128).setType(5).setSubtype(reason));
        EventLogTags.writeNotificationCanceled(canceledKey, reason, r.getLifespanMs(now), r.getFreshnessMs(now), r.getExposureMs(now), listenerName);
    }

    void cancelNotification(final int callingUid, final int callingPid, final String pkg, final String tag, final int id2, final int mustHaveFlags, final int mustNotHaveFlags, final boolean sendDelete, final int userId, final int reason, final ManagedServices.ManagedServiceInfo listener) {
        this.mHandler.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String listenerName;
                String string2 = listenerName = listener == null ? null : listener.component.toShortString();
                if (DBG) {
                    EventLogTags.writeNotificationCancel(callingUid, callingPid, pkg, id2, tag, userId, mustHaveFlags, mustNotHaveFlags, reason, listenerName);
                }
                Object object = NotificationManagerService.this.mNotificationLock;
                synchronized (object) {
                    boolean wasSnoozed;
                    NotificationRecord r = NotificationManagerService.this.findNotificationLocked(pkg, tag, id2, userId);
                    if (r != null) {
                        if (reason == 1) {
                            NotificationManagerService.this.mUsageStats.registerClickedByUser(r);
                        }
                        if ((r.getNotification().flags & mustHaveFlags) != mustHaveFlags) {
                            return;
                        }
                        if ((r.getNotification().flags & mustNotHaveFlags) != 0) {
                            return;
                        }
                        boolean wasPosted = NotificationManagerService.this.removeFromNotificationListsLocked(r);
                        NotificationManagerService.this.cancelNotificationLocked(r, sendDelete, reason, wasPosted, listenerName);
                        NotificationManagerService.this.cancelGroupChildrenLocked(r, callingUid, callingPid, listenerName, sendDelete, null);
                        NotificationManagerService.this.updateLightsLocked();
                    } else if (reason != 18 && (wasSnoozed = NotificationManagerService.this.mSnoozeHelper.cancel(userId, pkg, tag, id2))) {
                        NotificationManagerService.this.savePolicyFile();
                    }
                }
            }
        });
    }

    private boolean notificationMatchesUserId(NotificationRecord r, int userId) {
        return userId == -1 || r.getUserId() == -1 || r.getUserId() == userId;
    }

    private boolean notificationMatchesCurrentProfiles(NotificationRecord r, int userId) {
        return this.notificationMatchesUserId(r, userId) || this.mUserProfiles.isCurrentProfile(r.getUserId());
    }

    void cancelAllNotificationsInt(final int callingUid, final int callingPid, final String pkg, final String channelId, final int mustHaveFlags, final int mustNotHaveFlags, final boolean doit, final int userId, final int reason, final ManagedServices.ManagedServiceInfo listener) {
        this.mHandler.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String listenerName = listener == null ? null : listener.component.toShortString();
                EventLogTags.writeNotificationCancelAll(callingUid, callingPid, pkg, userId, mustHaveFlags, mustNotHaveFlags, reason, listenerName);
                if (!doit) {
                    return;
                }
                Object object = NotificationManagerService.this.mNotificationLock;
                synchronized (object) {
                    FlagChecker flagChecker = flags -> {
                        if ((flags & mustHaveFlags) != mustHaveFlags) {
                            return false;
                        }
                        return (flags & mustNotHaveFlags) == 0;
                    };
                    NotificationManagerService.this.cancelAllNotificationsByListLocked(NotificationManagerService.this.mNotificationList, callingUid, callingPid, pkg, true, channelId, flagChecker, false, userId, false, reason, listenerName, true);
                    NotificationManagerService.this.cancelAllNotificationsByListLocked(NotificationManagerService.this.mEnqueuedNotifications, callingUid, callingPid, pkg, true, channelId, flagChecker, false, userId, false, reason, listenerName, false);
                    NotificationManagerService.this.mSnoozeHelper.cancel(userId, pkg);
                }
            }
        });
    }

    @GuardedBy(value="mNotificationLock")
    private void cancelAllNotificationsByListLocked(ArrayList<NotificationRecord> notificationList, int callingUid, int callingPid, String pkg, boolean nullPkgIndicatesUserSwitch, String channelId, FlagChecker flagChecker, boolean includeCurrentProfiles, int userId, boolean sendDelete, int reason, String listenerName, boolean wasPosted) {
        ArrayList<NotificationRecord> canceledNotifications = null;
        for (int i = notificationList.size() - 1; i >= 0; --i) {
            NotificationRecord r = notificationList.get(i);
            if (!includeCurrentProfiles ? !this.notificationMatchesUserId(r, userId) : !this.notificationMatchesCurrentProfiles(r, userId)) continue;
            if (nullPkgIndicatesUserSwitch && pkg == null && r.getUserId() == -1 || !flagChecker.apply(r.getFlags()) || pkg != null && !r.sbn.getPackageName().equals(pkg) || channelId != null && !channelId.equals(r.getChannel().getId())) continue;
            if (canceledNotifications == null) {
                canceledNotifications = new ArrayList<NotificationRecord>();
            }
            notificationList.remove(i);
            this.mNotificationsByKey.remove(r.getKey());
            canceledNotifications.add(r);
            this.cancelNotificationLocked(r, sendDelete, reason, wasPosted, listenerName);
        }
        if (canceledNotifications != null) {
            int M = canceledNotifications.size();
            for (int i = 0; i < M; ++i) {
                this.cancelGroupChildrenLocked((NotificationRecord)canceledNotifications.get(i), callingUid, callingPid, listenerName, false, flagChecker);
            }
            this.updateLightsLocked();
        }
    }

    void snoozeNotificationInt(String key, long duration, String snoozeCriterionId, ManagedServices.ManagedServiceInfo listener) {
        String listenerName;
        String string2 = listenerName = listener == null ? null : listener.component.toShortString();
        if (duration <= 0L && snoozeCriterionId == null || key == null) {
            return;
        }
        if (DBG) {
            Slog.d(TAG, String.format("snooze event(%s, %d, %s, %s)", key, duration, snoozeCriterionId, listenerName));
        }
        this.mHandler.post(new SnoozeNotificationRunnable(key, duration, snoozeCriterionId));
    }

    void unsnoozeNotificationInt(String key, ManagedServices.ManagedServiceInfo listener) {
        String listenerName;
        String string2 = listenerName = listener == null ? null : listener.component.toShortString();
        if (DBG) {
            Slog.d(TAG, String.format("unsnooze event(%s, %s)", key, listenerName));
        }
        this.mSnoozeHelper.repost(key);
        this.savePolicyFile();
    }

    @GuardedBy(value="mNotificationLock")
    void cancelAllLocked(final int callingUid, final int callingPid, final int userId, final int reason, final ManagedServices.ManagedServiceInfo listener, final boolean includeCurrentProfiles) {
        this.mHandler.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = NotificationManagerService.this.mNotificationLock;
                synchronized (object) {
                    String listenerName = listener == null ? null : listener.component.toShortString();
                    EventLogTags.writeNotificationCancelAll(callingUid, callingPid, null, userId, 0, 0, reason, listenerName);
                    FlagChecker flagChecker = flags -> (flags & 0x22) == 0;
                    NotificationManagerService.this.cancelAllNotificationsByListLocked(NotificationManagerService.this.mNotificationList, callingUid, callingPid, null, false, null, flagChecker, includeCurrentProfiles, userId, true, reason, listenerName, true);
                    NotificationManagerService.this.cancelAllNotificationsByListLocked(NotificationManagerService.this.mEnqueuedNotifications, callingUid, callingPid, null, false, null, flagChecker, includeCurrentProfiles, userId, true, reason, listenerName, false);
                    NotificationManagerService.this.mSnoozeHelper.cancel(userId, includeCurrentProfiles);
                }
            }
        });
    }

    @GuardedBy(value="mNotificationLock")
    private void cancelGroupChildrenLocked(NotificationRecord r, int callingUid, int callingPid, String listenerName, boolean sendDelete, FlagChecker flagChecker) {
        Notification n = r.getNotification();
        if (!n.isGroupSummary()) {
            return;
        }
        String pkg = r.sbn.getPackageName();
        if (pkg == null) {
            if (DBG) {
                Log.e(TAG, "No package for group summary: " + r.getKey());
            }
            return;
        }
        this.cancelGroupChildrenByListLocked(this.mNotificationList, r, callingUid, callingPid, listenerName, sendDelete, true, flagChecker);
        this.cancelGroupChildrenByListLocked(this.mEnqueuedNotifications, r, callingUid, callingPid, listenerName, sendDelete, false, flagChecker);
    }

    @GuardedBy(value="mNotificationLock")
    private void cancelGroupChildrenByListLocked(ArrayList<NotificationRecord> notificationList, NotificationRecord parentNotification, int callingUid, int callingPid, String listenerName, boolean sendDelete, boolean wasPosted, FlagChecker flagChecker) {
        String pkg = parentNotification.sbn.getPackageName();
        int userId = parentNotification.getUserId();
        int reason = 12;
        for (int i = notificationList.size() - 1; i >= 0; --i) {
            NotificationRecord childR = notificationList.get(i);
            StatusBarNotification childSbn = childR.sbn;
            if (!childSbn.isGroup() || childSbn.getNotification().isGroupSummary() || !childR.getGroupKey().equals(parentNotification.getGroupKey()) || (childR.getFlags() & 0x40) != 0 || flagChecker != null && !flagChecker.apply(childR.getFlags())) continue;
            EventLogTags.writeNotificationCancel(callingUid, callingPid, pkg, childSbn.getId(), childSbn.getTag(), userId, 0, 0, 12, listenerName);
            notificationList.remove(i);
            this.mNotificationsByKey.remove(childR.getKey());
            this.cancelNotificationLocked(childR, sendDelete, 12, wasPosted, listenerName);
        }
    }

    @GuardedBy(value="mNotificationLock")
    void updateLightsLocked() {
        NotificationRecord ledNotification = null;
        while (ledNotification == null && !this.mLights.isEmpty()) {
            String owner = this.mLights.get(this.mLights.size() - 1);
            ledNotification = this.mNotificationsByKey.get(owner);
            if (ledNotification != null) continue;
            Slog.wtfStack(TAG, "LED Notification does not exist: " + owner);
            this.mLights.remove(owner);
        }
        if (ledNotification == null || this.mInCall || this.mScreenOn) {
            this.mNotificationLight.turnOff();
        } else {
            NotificationRecord.Light light = ledNotification.getLight();
            if (light != null && this.mNotificationPulseEnabled) {
                this.mNotificationLight.setFlashing(light.color, 1, light.onMs, light.offMs);
            }
        }
    }

    @GuardedBy(value="mNotificationLock")
    List<NotificationRecord> findGroupNotificationsLocked(String pkg, String groupKey, int userId) {
        ArrayList<NotificationRecord> records = new ArrayList<NotificationRecord>();
        records.addAll(this.findGroupNotificationByListLocked(this.mNotificationList, pkg, groupKey, userId));
        records.addAll(this.findGroupNotificationByListLocked(this.mEnqueuedNotifications, pkg, groupKey, userId));
        return records;
    }

    @GuardedBy(value="mNotificationLock")
    private List<NotificationRecord> findGroupNotificationByListLocked(ArrayList<NotificationRecord> list, String pkg, String groupKey, int userId) {
        ArrayList<NotificationRecord> records = new ArrayList<NotificationRecord>();
        int len = list.size();
        for (int i = 0; i < len; ++i) {
            NotificationRecord r = list.get(i);
            if (!this.notificationMatchesUserId(r, userId) || !r.getGroupKey().equals(groupKey) || !r.sbn.getPackageName().equals(pkg)) continue;
            records.add(r);
        }
        return records;
    }

    @GuardedBy(value="mNotificationLock")
    private NotificationRecord findNotificationByKeyLocked(String key) {
        NotificationRecord r = this.findNotificationByListLocked(this.mNotificationList, key);
        if (r != null) {
            return r;
        }
        r = this.findNotificationByListLocked(this.mEnqueuedNotifications, key);
        if (r != null) {
            return r;
        }
        return null;
    }

    @GuardedBy(value="mNotificationLock")
    NotificationRecord findNotificationLocked(String pkg, String tag, int id2, int userId) {
        NotificationRecord r = this.findNotificationByListLocked(this.mNotificationList, pkg, tag, id2, userId);
        if (r != null) {
            return r;
        }
        r = this.findNotificationByListLocked(this.mEnqueuedNotifications, pkg, tag, id2, userId);
        if (r != null) {
            return r;
        }
        return null;
    }

    @GuardedBy(value="mNotificationLock")
    private NotificationRecord findNotificationByListLocked(ArrayList<NotificationRecord> list, String pkg, String tag, int id2, int userId) {
        int len = list.size();
        for (int i = 0; i < len; ++i) {
            NotificationRecord r = list.get(i);
            if (!this.notificationMatchesUserId(r, userId) || r.sbn.getId() != id2 || !TextUtils.equals(r.sbn.getTag(), tag) || !r.sbn.getPackageName().equals(pkg)) continue;
            return r;
        }
        return null;
    }

    @GuardedBy(value="mNotificationLock")
    private NotificationRecord findNotificationByListLocked(ArrayList<NotificationRecord> list, String key) {
        int N = list.size();
        for (int i = 0; i < N; ++i) {
            if (!key.equals(list.get(i).getKey())) continue;
            return list.get(i);
        }
        return null;
    }

    @GuardedBy(value="mNotificationLock")
    int indexOfNotificationLocked(String key) {
        int N = this.mNotificationList.size();
        for (int i = 0; i < N; ++i) {
            if (!key.equals(this.mNotificationList.get(i).getKey())) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNotificationPulse() {
        Object object = this.mNotificationLock;
        synchronized (object) {
            this.updateLightsLocked();
        }
    }

    protected boolean isCallingUidSystem() {
        int uid = Binder.getCallingUid();
        return uid == 1000;
    }

    protected boolean isUidSystemOrPhone(int uid) {
        int appid = UserHandle.getAppId(uid);
        return appid == 1000 || appid == 1001 || uid == 0;
    }

    protected boolean isCallerSystemOrPhone() {
        return this.isUidSystemOrPhone(Binder.getCallingUid());
    }

    private void checkCallerIsSystemOrShell() {
        if (Binder.getCallingUid() == 2000) {
            return;
        }
        this.checkCallerIsSystem();
    }

    private void checkCallerIsSystem() {
        if (this.isCallerSystemOrPhone()) {
            return;
        }
        throw new SecurityException("Disallowed call for uid " + Binder.getCallingUid());
    }

    private void checkCallerIsSystemOrSameApp(String pkg) {
        if (this.isCallerSystemOrPhone()) {
            return;
        }
        this.checkCallerIsSameApp(pkg);
    }

    private boolean isCallerInstantApp(String pkg) {
        if (this.isCallerSystemOrPhone()) {
            return false;
        }
        this.mAppOps.checkPackage(Binder.getCallingUid(), pkg);
        try {
            ApplicationInfo ai = this.mPackageManager.getApplicationInfo(pkg, 0, UserHandle.getCallingUserId());
            if (ai == null) {
                throw new SecurityException("Unknown package " + pkg);
            }
            return ai.isInstantApp();
        }
        catch (RemoteException re) {
            throw new SecurityException("Unknown package " + pkg, re);
        }
    }

    private void checkCallerIsSameApp(String pkg) {
        int uid = Binder.getCallingUid();
        try {
            ApplicationInfo ai = this.mPackageManager.getApplicationInfo(pkg, 0, UserHandle.getCallingUserId());
            if (ai == null) {
                throw new SecurityException("Unknown package " + pkg);
            }
            if (!UserHandle.isSameApp(ai.uid, uid)) {
                throw new SecurityException("Calling uid " + uid + " gave package " + pkg + " which is owned by uid " + ai.uid);
            }
        }
        catch (RemoteException re) {
            throw new SecurityException("Unknown package " + pkg + "\n" + re);
        }
    }

    private static String callStateToString(int state) {
        switch (state) {
            case 0: {
                return "CALL_STATE_IDLE";
            }
            case 1: {
                return "CALL_STATE_RINGING";
            }
            case 2: {
                return "CALL_STATE_OFFHOOK";
            }
        }
        return "CALL_STATE_UNKNOWN_" + state;
    }

    private void listenForCallState() {
        TelephonyManager.from(this.getContext()).listen(new PhoneStateListener(){

            @Override
            public void onCallStateChanged(int state, String incomingNumber) {
                if (NotificationManagerService.this.mCallState == state) {
                    return;
                }
                if (DBG) {
                    Slog.d(NotificationManagerService.TAG, "Call state changed: " + NotificationManagerService.callStateToString(state));
                }
                NotificationManagerService.this.mCallState = state;
            }
        }, 32);
    }

    @GuardedBy(value="mNotificationLock")
    private NotificationRankingUpdate makeRankingUpdateLocked(ManagedServices.ManagedServiceInfo info) {
        int N = this.mNotificationList.size();
        ArrayList<String> keys = new ArrayList<String>(N);
        ArrayList<String> interceptedKeys = new ArrayList<String>(N);
        ArrayList<Integer> importance = new ArrayList<Integer>(N);
        Bundle overrideGroupKeys = new Bundle();
        Bundle visibilityOverrides = new Bundle();
        Bundle suppressedVisualEffects = new Bundle();
        Bundle explanation = new Bundle();
        Bundle channels = new Bundle();
        Bundle overridePeople = new Bundle();
        Bundle snoozeCriteria = new Bundle();
        Bundle showBadge = new Bundle();
        for (int i = 0; i < N; ++i) {
            NotificationRecord record = this.mNotificationList.get(i);
            if (!this.isVisibleToListener(record.sbn, info)) continue;
            String key = record.sbn.getKey();
            keys.add(key);
            importance.add(record.getImportance());
            if (record.getImportanceExplanation() != null) {
                explanation.putCharSequence(key, record.getImportanceExplanation());
            }
            if (record.isIntercepted()) {
                interceptedKeys.add(key);
            }
            suppressedVisualEffects.putInt(key, record.getSuppressedVisualEffects());
            if (record.getPackageVisibilityOverride() != -1000) {
                visibilityOverrides.putInt(key, record.getPackageVisibilityOverride());
            }
            overrideGroupKeys.putString(key, record.sbn.getOverrideGroupKey());
            channels.putParcelable(key, record.getChannel());
            overridePeople.putStringArrayList(key, record.getPeopleOverride());
            snoozeCriteria.putParcelableArrayList(key, record.getSnoozeCriteria());
            showBadge.putBoolean(key, record.canShowBadge());
        }
        int M = keys.size();
        String[] keysAr = keys.toArray(new String[M]);
        String[] interceptedKeysAr = interceptedKeys.toArray(new String[interceptedKeys.size()]);
        int[] importanceAr = new int[M];
        for (int i = 0; i < M; ++i) {
            importanceAr[i] = (Integer)importance.get(i);
        }
        return new NotificationRankingUpdate(keysAr, interceptedKeysAr, visibilityOverrides, suppressedVisualEffects, importanceAr, explanation, overrideGroupKeys, channels, overridePeople, snoozeCriteria, showBadge);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasCompanionDevice(ManagedServices.ManagedServiceInfo info) {
        if (this.mCompanionManager == null) {
            this.mCompanionManager = this.getCompanionManager();
        }
        if (this.mCompanionManager == null) {
            return false;
        }
        long identity = Binder.clearCallingIdentity();
        try {
            List<String> associations = this.mCompanionManager.getAssociations(info.component.getPackageName(), info.userid);
            if (!ArrayUtils.isEmpty(associations)) {
                boolean bl = true;
                return bl;
            }
        }
        catch (SecurityException associations) {
        }
        catch (RemoteException re) {
            Slog.e(TAG, "Cannot reach companion device service", re);
        }
        catch (Exception e) {
            Slog.e(TAG, "Cannot verify listener " + info, e);
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
        return false;
    }

    protected ICompanionDeviceManager getCompanionManager() {
        return ICompanionDeviceManager.Stub.asInterface(ServiceManager.getService("companiondevice"));
    }

    private boolean isVisibleToListener(StatusBarNotification sbn, ManagedServices.ManagedServiceInfo listener) {
        return listener.enabledAndUserMatches(sbn.getUserId());
    }

    private boolean isPackageSuspendedForUser(String pkg, int uid) {
        int userId = UserHandle.getUserId(uid);
        try {
            return this.mPackageManager.isPackageSuspendedForUser(pkg, userId);
        }
        catch (RemoteException re) {
            throw new SecurityException("Could not talk to package manager service");
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    private class ShellCmd
    extends ShellCommand {
        public static final String USAGE = "help\nallow_listener COMPONENT [user_id]\ndisallow_listener COMPONENT [user_id]\nset_assistant COMPONENT\nremove_assistant COMPONENT\nallow_dnd PACKAGE\ndisallow_dnd PACKAGE";

        private ShellCmd() {
        }

        @Override
        public int onCommand(String cmd) {
            if (cmd == null) {
                return this.handleDefaultCommands(cmd);
            }
            PrintWriter pw = this.getOutPrintWriter();
            try {
                switch (cmd) {
                    case "allow_dnd": {
                        NotificationManagerService.this.getBinderService().setNotificationPolicyAccessGranted(this.getNextArgRequired(), true);
                        break;
                    }
                    case "disallow_dnd": {
                        NotificationManagerService.this.getBinderService().setNotificationPolicyAccessGranted(this.getNextArgRequired(), false);
                        break;
                    }
                    case "allow_listener": {
                        ComponentName cn = ComponentName.unflattenFromString(this.getNextArgRequired());
                        if (cn == null) {
                            pw.println("Invalid listener - must be a ComponentName");
                            return -1;
                        }
                        String userId = this.getNextArg();
                        if (userId == null) {
                            NotificationManagerService.this.getBinderService().setNotificationListenerAccessGranted(cn, true);
                            break;
                        }
                        NotificationManagerService.this.getBinderService().setNotificationListenerAccessGrantedForUser(cn, Integer.parseInt(userId), true);
                        break;
                    }
                    case "disallow_listener": {
                        ComponentName cn = ComponentName.unflattenFromString(this.getNextArgRequired());
                        if (cn == null) {
                            pw.println("Invalid listener - must be a ComponentName");
                            return -1;
                        }
                        String userId = this.getNextArg();
                        if (userId == null) {
                            NotificationManagerService.this.getBinderService().setNotificationListenerAccessGranted(cn, false);
                            break;
                        }
                        NotificationManagerService.this.getBinderService().setNotificationListenerAccessGrantedForUser(cn, Integer.parseInt(userId), false);
                        break;
                    }
                    case "allow_assistant": {
                        ComponentName cn = ComponentName.unflattenFromString(this.getNextArgRequired());
                        if (cn == null) {
                            pw.println("Invalid assistant - must be a ComponentName");
                            return -1;
                        }
                        NotificationManagerService.this.getBinderService().setNotificationAssistantAccessGranted(cn, true);
                        break;
                    }
                    case "disallow_assistant": {
                        ComponentName cn = ComponentName.unflattenFromString(this.getNextArgRequired());
                        if (cn == null) {
                            pw.println("Invalid assistant - must be a ComponentName");
                            return -1;
                        }
                        NotificationManagerService.this.getBinderService().setNotificationAssistantAccessGranted(cn, false);
                        break;
                    }
                    default: {
                        return this.handleDefaultCommands(cmd);
                    }
                }
            }
            catch (Exception e) {
                pw.println("Error occurred. Check logcat for details. " + e.getMessage());
                Slog.e(NotificationManagerService.TAG, "Error running shell command", e);
            }
            return 0;
        }

        @Override
        public void onHelp() {
            this.getOutPrintWriter().println(USAGE);
        }
    }

    private static final class StatusBarNotificationHolder
    extends IStatusBarNotificationHolder.Stub {
        private StatusBarNotification mValue;

        public StatusBarNotificationHolder(StatusBarNotification value) {
            this.mValue = value;
        }

        @Override
        public StatusBarNotification get() {
            StatusBarNotification value = this.mValue;
            this.mValue = null;
            return value;
        }
    }

    public static final class DumpFilter {
        public boolean filtered = false;
        public String pkgFilter;
        public boolean zen;
        public long since;
        public boolean stats;
        public boolean redact = true;
        public boolean proto = false;

        public static DumpFilter parseFromArguments(String[] args) {
            DumpFilter filter = new DumpFilter();
            for (int ai = 0; ai < args.length; ++ai) {
                String a = args[ai];
                if ("--proto".equals(args[0])) {
                    filter.proto = true;
                }
                if ("--noredact".equals(a) || "--reveal".equals(a)) {
                    filter.redact = false;
                    continue;
                }
                if ("p".equals(a) || "pkg".equals(a) || "--package".equals(a)) {
                    if (ai >= args.length - 1) continue;
                    filter.pkgFilter = args[++ai].trim().toLowerCase();
                    if (filter.pkgFilter.isEmpty()) {
                        filter.pkgFilter = null;
                        continue;
                    }
                    filter.filtered = true;
                    continue;
                }
                if ("--zen".equals(a) || "zen".equals(a)) {
                    filter.filtered = true;
                    filter.zen = true;
                    continue;
                }
                if (!"--stats".equals(a)) continue;
                filter.stats = true;
                filter.since = ai < args.length - 1 ? Long.parseLong(args[++ai]) : 0L;
            }
            return filter;
        }

        public boolean matches(StatusBarNotification sbn) {
            if (!this.filtered) {
                return true;
            }
            return this.zen ? true : sbn != null && (this.matches(sbn.getPackageName()) || this.matches(sbn.getOpPkg()));
        }

        public boolean matches(ComponentName component) {
            if (!this.filtered) {
                return true;
            }
            return this.zen ? true : component != null && this.matches(component.getPackageName());
        }

        public boolean matches(String pkg) {
            if (!this.filtered) {
                return true;
            }
            return this.zen ? true : pkg != null && pkg.toLowerCase().contains(this.pkgFilter);
        }

        public String toString() {
            return this.stats ? "stats" : (this.zen ? "zen" : '\'' + this.pkgFilter + '\'');
        }
    }

    public class NotificationListeners
    extends ManagedServices {
        static final String TAG_ENABLED_NOTIFICATION_LISTENERS = "enabled_listeners";
        private final ArraySet<ManagedServices.ManagedServiceInfo> mLightTrimListeners;

        public NotificationListeners(IPackageManager pm) {
            super(NotificationManagerService.this.getContext(), NotificationManagerService.this.mNotificationLock, NotificationManagerService.this.mUserProfiles, pm);
            this.mLightTrimListeners = new ArraySet();
        }

        @Override
        protected ManagedServices.Config getConfig() {
            ManagedServices.Config c = new ManagedServices.Config();
            c.caption = "notification listener";
            c.serviceInterface = "android.service.notification.NotificationListenerService";
            c.xmlTag = TAG_ENABLED_NOTIFICATION_LISTENERS;
            c.secureSettingName = "enabled_notification_listeners";
            c.bindPermission = "android.permission.BIND_NOTIFICATION_LISTENER_SERVICE";
            c.settingsAction = "android.settings.ACTION_NOTIFICATION_LISTENER_SETTINGS";
            c.clientLabel = 17040313;
            return c;
        }

        @Override
        protected IInterface asInterface(IBinder binder) {
            return INotificationListener.Stub.asInterface(binder);
        }

        @Override
        protected boolean checkType(IInterface service) {
            return service instanceof INotificationListener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onServiceAdded(ManagedServices.ManagedServiceInfo info) {
            NotificationRankingUpdate update;
            INotificationListener listener = (INotificationListener)info.service;
            Object object = NotificationManagerService.this.mNotificationLock;
            synchronized (object) {
                update = NotificationManagerService.this.makeRankingUpdateLocked(info);
            }
            try {
                listener.onListenerConnected(update);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }

        @Override
        @GuardedBy(value="mNotificationLock")
        protected void onServiceRemovedLocked(ManagedServices.ManagedServiceInfo removed) {
            if (NotificationManagerService.this.removeDisabledHints(removed)) {
                NotificationManagerService.this.updateListenerHintsLocked();
                NotificationManagerService.this.updateEffectsSuppressorLocked();
            }
            this.mLightTrimListeners.remove(removed);
        }

        @GuardedBy(value="mNotificationLock")
        public void setOnNotificationPostedTrimLocked(ManagedServices.ManagedServiceInfo info, int trim) {
            if (trim == 1) {
                this.mLightTrimListeners.add(info);
            } else {
                this.mLightTrimListeners.remove(info);
            }
        }

        public int getOnNotificationPostedTrim(ManagedServices.ManagedServiceInfo info) {
            return this.mLightTrimListeners.contains(info) ? 1 : 0;
        }

        @GuardedBy(value="mNotificationLock")
        public void notifyPostedLocked(StatusBarNotification sbn, StatusBarNotification oldSbn) {
            TrimCache trimCache = new TrimCache(sbn);
            for (final ManagedServices.ManagedServiceInfo info : this.getServices()) {
                boolean oldSbnVisible;
                boolean sbnVisible = NotificationManagerService.this.isVisibleToListener(sbn, info);
                boolean bl = oldSbnVisible = oldSbn != null ? NotificationManagerService.this.isVisibleToListener(oldSbn, info) : false;
                if (!oldSbnVisible && !sbnVisible) continue;
                final NotificationRankingUpdate update = NotificationManagerService.this.makeRankingUpdateLocked(info);
                if (oldSbnVisible && !sbnVisible) {
                    final StatusBarNotification oldSbnLightClone = oldSbn.cloneLight();
                    NotificationManagerService.this.mHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            NotificationListeners.this.notifyRemoved(info, oldSbnLightClone, update, 6);
                        }
                    });
                    continue;
                }
                final StatusBarNotification sbnToPost = trimCache.ForListener(info);
                NotificationManagerService.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        NotificationListeners.this.notifyPosted(info, sbnToPost, update);
                    }
                });
            }
        }

        @GuardedBy(value="mNotificationLock")
        public void notifyRemovedLocked(StatusBarNotification sbn, final int reason) {
            final StatusBarNotification sbnLight = sbn.cloneLight();
            for (final ManagedServices.ManagedServiceInfo info : this.getServices()) {
                if (!NotificationManagerService.this.isVisibleToListener(sbn, info)) continue;
                final NotificationRankingUpdate update = NotificationManagerService.this.makeRankingUpdateLocked(info);
                NotificationManagerService.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        NotificationListeners.this.notifyRemoved(info, sbnLight, update, reason);
                    }
                });
            }
        }

        @GuardedBy(value="mNotificationLock")
        public void notifyRankingUpdateLocked() {
            for (final ManagedServices.ManagedServiceInfo serviceInfo : this.getServices()) {
                if (!serviceInfo.isEnabledForCurrentProfiles()) continue;
                final NotificationRankingUpdate update = NotificationManagerService.this.makeRankingUpdateLocked(serviceInfo);
                NotificationManagerService.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        NotificationListeners.this.notifyRankingUpdate(serviceInfo, update);
                    }
                });
            }
        }

        @GuardedBy(value="mNotificationLock")
        public void notifyListenerHintsChangedLocked(final int hints) {
            for (final ManagedServices.ManagedServiceInfo serviceInfo : this.getServices()) {
                if (!serviceInfo.isEnabledForCurrentProfiles()) continue;
                NotificationManagerService.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        NotificationListeners.this.notifyListenerHintsChanged(serviceInfo, hints);
                    }
                });
            }
        }

        public void notifyInterruptionFilterChanged(final int interruptionFilter) {
            for (final ManagedServices.ManagedServiceInfo serviceInfo : this.getServices()) {
                if (!serviceInfo.isEnabledForCurrentProfiles()) continue;
                NotificationManagerService.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        NotificationListeners.this.notifyInterruptionFilterChanged(serviceInfo, interruptionFilter);
                    }
                });
            }
        }

        protected void notifyNotificationChannelChanged(String pkg, UserHandle user, NotificationChannel channel, int modificationType) {
            if (channel == null) {
                return;
            }
            for (ManagedServices.ManagedServiceInfo serviceInfo : this.getServices()) {
                if (!serviceInfo.enabledAndUserMatches(UserHandle.getCallingUserId())) continue;
                BackgroundThread.getHandler().post(() -> {
                    if (NotificationManagerService.this.hasCompanionDevice(serviceInfo)) {
                        this.notifyNotificationChannelChanged(serviceInfo, pkg, user, channel, modificationType);
                    }
                });
            }
        }

        protected void notifyNotificationChannelGroupChanged(String pkg, UserHandle user, NotificationChannelGroup group, int modificationType) {
            if (group == null) {
                return;
            }
            for (ManagedServices.ManagedServiceInfo serviceInfo : this.getServices()) {
                if (!serviceInfo.enabledAndUserMatches(UserHandle.getCallingUserId())) continue;
                BackgroundThread.getHandler().post(() -> {
                    if (NotificationManagerService.this.hasCompanionDevice(serviceInfo)) {
                        this.notifyNotificationChannelGroupChanged(serviceInfo, pkg, user, group, modificationType);
                    }
                });
            }
        }

        private void notifyPosted(ManagedServices.ManagedServiceInfo info, StatusBarNotification sbn, NotificationRankingUpdate rankingUpdate) {
            INotificationListener listener = (INotificationListener)info.service;
            StatusBarNotificationHolder sbnHolder = new StatusBarNotificationHolder(sbn);
            try {
                listener.onNotificationPosted(sbnHolder, rankingUpdate);
            }
            catch (RemoteException ex) {
                Log.e(this.TAG, "unable to notify listener (posted): " + listener, ex);
            }
        }

        private void notifyRemoved(ManagedServices.ManagedServiceInfo info, StatusBarNotification sbn, NotificationRankingUpdate rankingUpdate, int reason) {
            if (!info.enabledAndUserMatches(sbn.getUserId())) {
                return;
            }
            INotificationListener listener = (INotificationListener)info.service;
            StatusBarNotificationHolder sbnHolder = new StatusBarNotificationHolder(sbn);
            try {
                listener.onNotificationRemoved(sbnHolder, rankingUpdate, reason);
            }
            catch (RemoteException ex) {
                Log.e(this.TAG, "unable to notify listener (removed): " + listener, ex);
            }
        }

        private void notifyRankingUpdate(ManagedServices.ManagedServiceInfo info, NotificationRankingUpdate rankingUpdate) {
            INotificationListener listener = (INotificationListener)info.service;
            try {
                listener.onNotificationRankingUpdate(rankingUpdate);
            }
            catch (RemoteException ex) {
                Log.e(this.TAG, "unable to notify listener (ranking update): " + listener, ex);
            }
        }

        private void notifyListenerHintsChanged(ManagedServices.ManagedServiceInfo info, int hints) {
            INotificationListener listener = (INotificationListener)info.service;
            try {
                listener.onListenerHintsChanged(hints);
            }
            catch (RemoteException ex) {
                Log.e(this.TAG, "unable to notify listener (listener hints): " + listener, ex);
            }
        }

        private void notifyInterruptionFilterChanged(ManagedServices.ManagedServiceInfo info, int interruptionFilter) {
            INotificationListener listener = (INotificationListener)info.service;
            try {
                listener.onInterruptionFilterChanged(interruptionFilter);
            }
            catch (RemoteException ex) {
                Log.e(this.TAG, "unable to notify listener (interruption filter): " + listener, ex);
            }
        }

        void notifyNotificationChannelChanged(ManagedServices.ManagedServiceInfo info, String pkg, UserHandle user, NotificationChannel channel, int modificationType) {
            INotificationListener listener = (INotificationListener)info.service;
            try {
                listener.onNotificationChannelModification(pkg, user, channel, modificationType);
            }
            catch (RemoteException ex) {
                Log.e(this.TAG, "unable to notify listener (channel changed): " + listener, ex);
            }
        }

        private void notifyNotificationChannelGroupChanged(ManagedServices.ManagedServiceInfo info, String pkg, UserHandle user, NotificationChannelGroup group, int modificationType) {
            INotificationListener listener = (INotificationListener)info.service;
            try {
                listener.onNotificationChannelGroupModification(pkg, user, group, modificationType);
            }
            catch (RemoteException ex) {
                Log.e(this.TAG, "unable to notify listener (channel group changed): " + listener, ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean isListenerPackage(String packageName) {
            if (packageName == null) {
                return false;
            }
            Object object = NotificationManagerService.this.mNotificationLock;
            synchronized (object) {
                ManagedServices.ManagedServiceInfo serviceInfo;
                Iterator<ManagedServices.ManagedServiceInfo> iterator = this.getServices().iterator();
                do {
                    if (!iterator.hasNext()) return false;
                    serviceInfo = iterator.next();
                } while (!packageName.equals(serviceInfo.component.getPackageName()));
                return true;
            }
        }
    }

    public class NotificationAssistants
    extends ManagedServices {
        static final String TAG_ENABLED_NOTIFICATION_ASSISTANTS = "enabled_assistants";

        public NotificationAssistants(IPackageManager pm) {
            super(NotificationManagerService.this.getContext(), NotificationManagerService.this.mNotificationLock, NotificationManagerService.this.mUserProfiles, pm);
        }

        @Override
        protected ManagedServices.Config getConfig() {
            ManagedServices.Config c = new ManagedServices.Config();
            c.caption = "notification assistant service";
            c.serviceInterface = "android.service.notification.NotificationAssistantService";
            c.xmlTag = TAG_ENABLED_NOTIFICATION_ASSISTANTS;
            c.secureSettingName = "enabled_notification_assistant";
            c.bindPermission = "android.permission.BIND_NOTIFICATION_ASSISTANT_SERVICE";
            c.settingsAction = "android.settings.MANAGE_DEFAULT_APPS_SETTINGS";
            c.clientLabel = 17040315;
            return c;
        }

        @Override
        protected IInterface asInterface(IBinder binder) {
            return INotificationListener.Stub.asInterface(binder);
        }

        @Override
        protected boolean checkType(IInterface service) {
            return service instanceof INotificationListener;
        }

        @Override
        protected void onServiceAdded(ManagedServices.ManagedServiceInfo info) {
            NotificationManagerService.this.mListeners.registerGuestService(info);
        }

        @Override
        @GuardedBy(value="mNotificationLock")
        protected void onServiceRemovedLocked(ManagedServices.ManagedServiceInfo removed) {
            NotificationManagerService.this.mListeners.unregisterService(removed.service, removed.userid);
        }

        public void onNotificationEnqueued(NotificationRecord r) {
            StatusBarNotification sbn = r.sbn;
            TrimCache trimCache = new TrimCache(sbn);
            for (final ManagedServices.ManagedServiceInfo info : this.getServices()) {
                boolean sbnVisible = NotificationManagerService.this.isVisibleToListener(sbn, info);
                if (!sbnVisible) continue;
                int importance = r.getImportance();
                boolean fromUser = r.isImportanceFromUser();
                final StatusBarNotification sbnToPost = trimCache.ForListener(info);
                NotificationManagerService.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        NotificationAssistants.this.notifyEnqueued(info, sbnToPost);
                    }
                });
            }
        }

        private void notifyEnqueued(ManagedServices.ManagedServiceInfo info, StatusBarNotification sbn) {
            INotificationListener assistant = (INotificationListener)info.service;
            StatusBarNotificationHolder sbnHolder = new StatusBarNotificationHolder(sbn);
            try {
                assistant.onNotificationEnqueued(sbnHolder);
            }
            catch (RemoteException ex) {
                Log.e(this.TAG, "unable to notify assistant (enqueued): " + assistant, ex);
            }
        }

        @GuardedBy(value="mNotificationLock")
        public void notifyAssistantSnoozedLocked(StatusBarNotification sbn, final String snoozeCriterionId) {
            TrimCache trimCache = new TrimCache(sbn);
            for (final ManagedServices.ManagedServiceInfo info : this.getServices()) {
                final StatusBarNotification sbnToPost = trimCache.ForListener(info);
                NotificationManagerService.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        INotificationListener assistant = (INotificationListener)info.service;
                        StatusBarNotificationHolder sbnHolder = new StatusBarNotificationHolder(sbnToPost);
                        try {
                            assistant.onNotificationSnoozedUntilContext(sbnHolder, snoozeCriterionId);
                        }
                        catch (RemoteException ex) {
                            Log.e(NotificationAssistants.this.TAG, "unable to notify assistant (snoozed): " + assistant, ex);
                        }
                    }
                });
            }
        }

        public boolean isEnabled() {
            return !this.getServices().isEmpty();
        }
    }

    private class TrimCache {
        StatusBarNotification heavy;
        StatusBarNotification sbnClone;
        StatusBarNotification sbnCloneLight;

        TrimCache(StatusBarNotification sbn) {
            this.heavy = sbn;
        }

        StatusBarNotification ForListener(ManagedServices.ManagedServiceInfo info) {
            if (NotificationManagerService.this.mListeners.getOnNotificationPostedTrim(info) == 1) {
                if (this.sbnCloneLight == null) {
                    this.sbnCloneLight = this.heavy.cloneLight();
                }
                return this.sbnCloneLight;
            }
            if (this.sbnClone == null) {
                this.sbnClone = this.heavy.clone();
            }
            return this.sbnClone;
        }
    }

    private static interface FlagChecker {
        public boolean apply(int var1);
    }

    private final class RankingHandlerWorker
    extends Handler
    implements RankingHandler {
        public RankingHandlerWorker(Looper looper) {
            super(looper);
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1000: {
                    NotificationManagerService.this.handleRankingReconsideration(msg);
                    break;
                }
                case 1001: {
                    NotificationManagerService.this.handleRankingSort();
                }
            }
        }

        @Override
        public void requestSort() {
            this.removeMessages(1001);
            Message msg = Message.obtain();
            msg.what = 1001;
            this.sendMessage(msg);
        }

        @Override
        public void requestReconsideration(RankingReconsideration recon) {
            Message m = Message.obtain(this, 1000, recon);
            long delay = recon.getDelay(TimeUnit.MILLISECONDS);
            this.sendMessageDelayed(m, delay);
        }
    }

    protected class WorkerHandler
    extends Handler {
        public WorkerHandler(Looper looper) {
            super(looper);
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 2: {
                    NotificationManagerService.this.handleTimeout((ToastRecord)msg.obj);
                    break;
                }
                case 3: {
                    NotificationManagerService.this.handleSavePolicyFile();
                    break;
                }
                case 4: {
                    NotificationManagerService.this.handleSendRankingUpdate();
                    break;
                }
                case 5: {
                    NotificationManagerService.this.handleListenerHintsChanged(msg.arg1);
                    break;
                }
                case 6: {
                    NotificationManagerService.this.handleListenerInterruptionFilterChanged(msg.arg1);
                }
            }
        }

        protected void scheduleSendRankingUpdate() {
            if (!this.hasMessages(4)) {
                Message m = Message.obtain((Handler)this, 4);
                this.sendMessage(m);
            }
        }
    }

    protected class PostNotificationRunnable
    implements Runnable {
        private final String key;

        PostNotificationRunnable(String key) {
            this.key = key;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = NotificationManagerService.this.mNotificationLock;
            synchronized (object) {
                try {
                    NotificationRecord r = null;
                    int N = NotificationManagerService.this.mEnqueuedNotifications.size();
                    for (int i = 0; i < N; ++i) {
                        NotificationRecord enqueued = NotificationManagerService.this.mEnqueuedNotifications.get(i);
                        if (!Objects.equals(this.key, enqueued.getKey())) continue;
                        r = enqueued;
                        break;
                    }
                    if (r == null) {
                        Slog.i(NotificationManagerService.TAG, "Cannot find enqueued record for key: " + this.key);
                        return;
                    }
                    NotificationRecord old = NotificationManagerService.this.mNotificationsByKey.get(this.key);
                    final StatusBarNotification n = r.sbn;
                    Notification notification = n.getNotification();
                    int index = NotificationManagerService.this.indexOfNotificationLocked(n.getKey());
                    if (index < 0) {
                        NotificationManagerService.this.mNotificationList.add(r);
                        NotificationManagerService.this.mUsageStats.registerPostedByApp(r);
                    } else {
                        old = NotificationManagerService.this.mNotificationList.get(index);
                        NotificationManagerService.this.mNotificationList.set(index, r);
                        NotificationManagerService.this.mUsageStats.registerUpdatedByApp(r, old);
                        notification.flags |= old.getNotification().flags & 0x40;
                        r.isUpdate = true;
                    }
                    NotificationManagerService.this.mNotificationsByKey.put(n.getKey(), r);
                    if ((notification.flags & 0x40) != 0) {
                        notification.flags |= 0x22;
                    }
                    NotificationManagerService.this.applyZenModeLocked(r);
                    NotificationManagerService.this.mRankingHelper.sort(NotificationManagerService.this.mNotificationList);
                    if (notification.getSmallIcon() != null) {
                        StatusBarNotification oldSbn = old != null ? old.sbn : null;
                        NotificationManagerService.this.mListeners.notifyPostedLocked(n, oldSbn);
                        if (oldSbn == null || !Objects.equals(oldSbn.getGroup(), n.getGroup())) {
                            NotificationManagerService.this.mHandler.post(new Runnable(){

                                @Override
                                public void run() {
                                    NotificationManagerService.this.mGroupHelper.onNotificationPosted(n, NotificationManagerService.this.hasAutoGroupSummaryLocked(n));
                                }
                            });
                        }
                    } else {
                        Slog.e(NotificationManagerService.TAG, "Not posting notification without small icon: " + notification);
                        if (old != null && !old.isCanceled) {
                            NotificationManagerService.this.mListeners.notifyRemovedLocked(n, 4);
                            NotificationManagerService.this.mHandler.post(new Runnable(){

                                @Override
                                public void run() {
                                    NotificationManagerService.this.mGroupHelper.onNotificationRemoved(n);
                                }
                            });
                        }
                        Slog.e(NotificationManagerService.TAG, "WARNING: In a future release this will crash the app: " + n.getPackageName());
                    }
                    NotificationManagerService.this.buzzBeepBlinkLocked(r);
                }
                finally {
                    int N = NotificationManagerService.this.mEnqueuedNotifications.size();
                    for (int i = 0; i < N; ++i) {
                        NotificationRecord enqueued = NotificationManagerService.this.mEnqueuedNotifications.get(i);
                        if (!Objects.equals(this.key, enqueued.getKey())) continue;
                        NotificationManagerService.this.mEnqueuedNotifications.remove(i);
                        break;
                    }
                }
            }
        }
    }

    protected class EnqueueNotificationRunnable
    implements Runnable {
        private final NotificationRecord r;
        private final int userId;

        EnqueueNotificationRunnable(int userId, NotificationRecord r) {
            this.userId = userId;
            this.r = r;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = NotificationManagerService.this.mNotificationLock;
            synchronized (object) {
                NotificationRecord old;
                NotificationManagerService.this.mEnqueuedNotifications.add(this.r);
                NotificationManagerService.this.scheduleTimeoutLocked(this.r);
                StatusBarNotification n = this.r.sbn;
                if (DBG) {
                    Slog.d(NotificationManagerService.TAG, "EnqueueNotificationRunnable.run for: " + n.getKey());
                }
                if ((old = NotificationManagerService.this.mNotificationsByKey.get(n.getKey())) != null) {
                    this.r.copyRankingInformation(old);
                }
                int callingUid = n.getUid();
                int callingPid = n.getInitialPid();
                Notification notification = n.getNotification();
                String pkg = n.getPackageName();
                int id2 = n.getId();
                String tag = n.getTag();
                NotificationManagerService.this.handleGroupedNotificationLocked(this.r, old, callingUid, callingPid);
                if (n.isGroup() && notification.isGroupChild()) {
                    NotificationManagerService.this.mSnoozeHelper.repostGroupSummary(pkg, this.r.getUserId(), n.getGroupKey());
                }
                if (!pkg.equals("com.android.providers.downloads") || Log.isLoggable("DownloadManager", 2)) {
                    int enqueueStatus = 0;
                    if (old != null) {
                        enqueueStatus = 1;
                    }
                    EventLogTags.writeNotificationEnqueue(callingUid, callingPid, pkg, id2, tag, this.userId, notification.toString(), enqueueStatus);
                }
                NotificationManagerService.this.mRankingHelper.extractSignals(this.r);
                if (NotificationManagerService.this.mAssistants.isEnabled()) {
                    NotificationManagerService.this.mAssistants.onNotificationEnqueued(this.r);
                    NotificationManagerService.this.mHandler.postDelayed(new PostNotificationRunnable(this.r.getKey()), 100L);
                } else {
                    NotificationManagerService.this.mHandler.post(new PostNotificationRunnable(this.r.getKey()));
                }
            }
        }
    }

    protected class SnoozeNotificationRunnable
    implements Runnable {
        private final String mKey;
        private final long mDuration;
        private final String mSnoozeCriterionId;

        SnoozeNotificationRunnable(String key, long duration, String snoozeCriterionId) {
            this.mKey = key;
            this.mDuration = duration;
            this.mSnoozeCriterionId = snoozeCriterionId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = NotificationManagerService.this.mNotificationLock;
            synchronized (object) {
                NotificationRecord r = NotificationManagerService.this.findNotificationByKeyLocked(this.mKey);
                if (r != null) {
                    this.snoozeLocked(r);
                }
            }
        }

        @GuardedBy(value="mNotificationLock")
        void snoozeLocked(NotificationRecord r) {
            if (r.sbn.isGroup()) {
                List<NotificationRecord> groupNotifications = NotificationManagerService.this.findGroupNotificationsLocked(r.sbn.getPackageName(), r.sbn.getGroupKey(), r.sbn.getUserId());
                if (r.getNotification().isGroupSummary()) {
                    for (int i = 0; i < groupNotifications.size(); ++i) {
                        this.snoozeNotificationLocked(groupNotifications.get(i));
                    }
                } else if (NotificationManagerService.this.mSummaryByGroupKey.containsKey(r.sbn.getGroupKey())) {
                    if (groupNotifications.size() != 2) {
                        this.snoozeNotificationLocked(r);
                    } else {
                        for (int i = 0; i < groupNotifications.size(); ++i) {
                            this.snoozeNotificationLocked(groupNotifications.get(i));
                        }
                    }
                } else {
                    this.snoozeNotificationLocked(r);
                }
            } else {
                this.snoozeNotificationLocked(r);
            }
        }

        @GuardedBy(value="mNotificationLock")
        void snoozeNotificationLocked(NotificationRecord r) {
            MetricsLogger.action(r.getLogMaker().setCategory(831).setType(2).addTaggedData(1139, this.mDuration).addTaggedData(832, this.mSnoozeCriterionId == null ? 0 : 1));
            boolean wasPosted = NotificationManagerService.this.removeFromNotificationListsLocked(r);
            NotificationManagerService.this.cancelNotificationLocked(r, false, 18, wasPosted, null);
            NotificationManagerService.this.updateLightsLocked();
            if (this.mSnoozeCriterionId != null) {
                NotificationManagerService.this.mAssistants.notifyAssistantSnoozedLocked(r.sbn, this.mSnoozeCriterionId);
                NotificationManagerService.this.mSnoozeHelper.snooze(r);
            } else {
                NotificationManagerService.this.mSnoozeHelper.snooze(r, this.mDuration);
            }
            NotificationManagerService.this.savePolicyFile();
        }
    }

    private final class SettingsObserver
    extends ContentObserver {
        private final Uri NOTIFICATION_BADGING_URI;
        private final Uri NOTIFICATION_LIGHT_PULSE_URI;
        private final Uri NOTIFICATION_RATE_LIMIT_URI;

        SettingsObserver(Handler handler) {
            super(handler);
            this.NOTIFICATION_BADGING_URI = Settings.Secure.getUriFor("notification_badging");
            this.NOTIFICATION_LIGHT_PULSE_URI = Settings.System.getUriFor("notification_light_pulse");
            this.NOTIFICATION_RATE_LIMIT_URI = Settings.Global.getUriFor("max_notification_enqueue_rate");
        }

        void observe() {
            ContentResolver resolver = NotificationManagerService.this.getContext().getContentResolver();
            resolver.registerContentObserver(this.NOTIFICATION_BADGING_URI, false, this, -1);
            resolver.registerContentObserver(this.NOTIFICATION_LIGHT_PULSE_URI, false, this, -1);
            resolver.registerContentObserver(this.NOTIFICATION_RATE_LIMIT_URI, false, this, -1);
            this.update(null);
        }

        @Override
        public void onChange(boolean selfChange, Uri uri) {
            this.update(uri);
        }

        public void update(Uri uri) {
            ContentResolver resolver = NotificationManagerService.this.getContext().getContentResolver();
            if (uri == null || this.NOTIFICATION_LIGHT_PULSE_URI.equals(uri)) {
                boolean pulseEnabled;
                boolean bl = pulseEnabled = Settings.System.getIntForUser(resolver, "notification_light_pulse", 0, -2) != 0;
                if (NotificationManagerService.this.mNotificationPulseEnabled != pulseEnabled) {
                    NotificationManagerService.this.mNotificationPulseEnabled = pulseEnabled;
                    NotificationManagerService.this.updateNotificationPulse();
                }
            }
            if (uri == null || this.NOTIFICATION_RATE_LIMIT_URI.equals(uri)) {
                NotificationManagerService.this.mMaxPackageEnqueueRate = Settings.Global.getFloat(resolver, "max_notification_enqueue_rate", NotificationManagerService.this.mMaxPackageEnqueueRate);
            }
            if (uri == null || this.NOTIFICATION_BADGING_URI.equals(uri)) {
                NotificationManagerService.this.mRankingHelper.updateBadgingEnabled();
            }
        }
    }

    private static final class ToastRecord {
        final int pid;
        final String pkg;
        ITransientNotification callback;
        int duration;
        Binder token;

        ToastRecord(int pid, String pkg, ITransientNotification callback, int duration, Binder token) {
            this.pid = pid;
            this.pkg = pkg;
            this.callback = callback;
            this.duration = duration;
            this.token = token;
        }

        void update(int duration) {
            this.duration = duration;
        }

        void update(ITransientNotification callback) {
            this.callback = callback;
        }

        void dump(PrintWriter pw, String prefix, DumpFilter filter) {
            if (filter != null && !filter.matches(this.pkg)) {
                return;
            }
            pw.println(prefix + this);
        }

        public final String toString() {
            return "ToastRecord{" + Integer.toHexString(System.identityHashCode(this)) + " pkg=" + this.pkg + " callback=" + this.callback + " duration=" + this.duration;
        }
    }

    private static class Archive {
        final int mBufferSize;
        final ArrayDeque<StatusBarNotification> mBuffer;

        public Archive(int size) {
            this.mBufferSize = size;
            this.mBuffer = new ArrayDeque(this.mBufferSize);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            int N = this.mBuffer.size();
            sb.append("Archive (");
            sb.append(N);
            sb.append(" notification");
            sb.append(N == 1 ? ")" : "s)");
            return sb.toString();
        }

        public void record(StatusBarNotification nr) {
            if (this.mBuffer.size() == this.mBufferSize) {
                this.mBuffer.removeFirst();
            }
            this.mBuffer.addLast(nr.cloneLight());
        }

        public Iterator<StatusBarNotification> descendingIterator() {
            return this.mBuffer.descendingIterator();
        }

        public StatusBarNotification[] getArray(int count) {
            if (count == 0) {
                count = this.mBufferSize;
            }
            StatusBarNotification[] a = new StatusBarNotification[Math.min(count, this.mBuffer.size())];
            Iterator<StatusBarNotification> iter = this.descendingIterator();
            int i = 0;
            while (iter.hasNext() && i < count) {
                a[i++] = iter.next();
            }
            return a;
        }
    }
}

