/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.hdmi;

import android.os.SystemClock;
import android.util.Log;
import android.util.Pair;
import android.util.Slog;
import java.util.HashMap;

final class HdmiLogger {
    private static final String TAG = "HDMI";
    private static final long ERROR_LOG_DURATTION_MILLIS = 20000L;
    private static final boolean DEBUG = Log.isLoggable("HDMI", 3);
    private static final ThreadLocal<HdmiLogger> sLogger = new ThreadLocal();
    private final HashMap<String, Pair<Long, Integer>> mWarningTimingCache = new HashMap();
    private final HashMap<String, Pair<Long, Integer>> mErrorTimingCache = new HashMap();

    private HdmiLogger() {
    }

    static final void warning(String logMessage, Object ... objs) {
        HdmiLogger.getLogger().warningInternal(HdmiLogger.toLogString(logMessage, objs));
    }

    private void warningInternal(String logMessage) {
        String log = HdmiLogger.updateLog(this.mWarningTimingCache, logMessage);
        if (!log.isEmpty()) {
            Slog.w(TAG, log);
        }
    }

    static final void error(String logMessage, Object ... objs) {
        HdmiLogger.getLogger().errorInternal(HdmiLogger.toLogString(logMessage, objs));
    }

    private void errorInternal(String logMessage) {
        String log = HdmiLogger.updateLog(this.mErrorTimingCache, logMessage);
        if (!log.isEmpty()) {
            Slog.e(TAG, log);
        }
    }

    static final void debug(String logMessage, Object ... objs) {
        HdmiLogger.getLogger().debugInternal(HdmiLogger.toLogString(logMessage, objs));
    }

    private void debugInternal(String logMessage) {
        if (DEBUG) {
            Slog.d(TAG, logMessage);
        }
    }

    private static final String toLogString(String logMessage, Object[] objs) {
        if (objs.length > 0) {
            return String.format(logMessage, objs);
        }
        return logMessage;
    }

    private static HdmiLogger getLogger() {
        HdmiLogger logger = sLogger.get();
        if (logger == null) {
            logger = new HdmiLogger();
            sLogger.set(logger);
        }
        return logger;
    }

    private static String updateLog(HashMap<String, Pair<Long, Integer>> cache, String logMessage) {
        long curTime = SystemClock.uptimeMillis();
        Pair<Long, Integer> timing = cache.get(logMessage);
        if (HdmiLogger.shouldLogNow(timing, curTime)) {
            String log = HdmiLogger.buildMessage(logMessage, timing);
            cache.put(logMessage, new Pair<Long, Integer>(curTime, 1));
            return log;
        }
        HdmiLogger.increaseLogCount(cache, logMessage);
        return "";
    }

    private static String buildMessage(String message, Pair<Long, Integer> timing) {
        return "[" + (timing == null ? 1 : (Integer)timing.second) + "]:" + message;
    }

    private static void increaseLogCount(HashMap<String, Pair<Long, Integer>> cache, String message) {
        Pair<Long, Integer> timing = cache.get(message);
        if (timing != null) {
            cache.put(message, new Pair(timing.first, (Integer)timing.second + 1));
        }
    }

    private static boolean shouldLogNow(Pair<Long, Integer> timing, long curTime) {
        return timing == null || curTime - (Long)timing.first > 20000L;
    }
}

