/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.display;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.app.AlarmManager;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.database.ContentObserver;
import android.net.Uri;
import android.opengl.Matrix;
import android.os.Handler;
import android.os.Looper;
import android.os.RemoteException;
import android.provider.Settings;
import android.service.vr.IVrManager;
import android.service.vr.IVrStateCallbacks;
import android.util.MathUtils;
import android.util.Slog;
import android.view.animation.AnimationUtils;
import com.android.internal.app.NightDisplayController;
import com.android.server.SystemService;
import com.android.server.display.DisplayTransformManager;
import com.android.server.twilight.TwilightListener;
import com.android.server.twilight.TwilightManager;
import com.android.server.twilight.TwilightState;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.concurrent.atomic.AtomicBoolean;

public final class NightDisplayService
extends SystemService
implements NightDisplayController.Callback {
    private static final String TAG = "NightDisplayService";
    private static final long TRANSITION_DURATION = 3000L;
    private static final float[] MATRIX_IDENTITY = new float[16];
    private static final ColorMatrixEvaluator COLOR_MATRIX_EVALUATOR;
    private final Handler mHandler;
    private final AtomicBoolean mIgnoreAllColorMatrixChanges = new AtomicBoolean();
    private final IVrStateCallbacks mVrStateCallbacks = new IVrStateCallbacks.Stub(){

        @Override
        public void onVrStateChanged(final boolean enabled) {
            NightDisplayService.this.mIgnoreAllColorMatrixChanges.set(enabled);
            NightDisplayService.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (NightDisplayService.this.mColorMatrixAnimator != null) {
                        NightDisplayService.this.mColorMatrixAnimator.cancel();
                    }
                    DisplayTransformManager dtm = (DisplayTransformManager)NightDisplayService.this.getLocalService(DisplayTransformManager.class);
                    if (enabled) {
                        dtm.setColorMatrix(100, MATRIX_IDENTITY);
                    } else if (NightDisplayService.this.mController != null && NightDisplayService.this.mController.isActivated()) {
                        NightDisplayService.this.setMatrix(NightDisplayService.this.mController.getColorTemperature(), NightDisplayService.this.mMatrixNight);
                        dtm.setColorMatrix(100, NightDisplayService.this.mMatrixNight);
                    }
                }
            });
        }
    };
    private float[] mMatrixNight = new float[16];
    private final float[] mColorTempCoefficients = new float[9];
    private int mCurrentUser = -10000;
    private ContentObserver mUserSetupObserver;
    private boolean mBootCompleted;
    private NightDisplayController mController;
    private ValueAnimator mColorMatrixAnimator;
    private Boolean mIsActivated;
    private AutoMode mAutoMode;

    public NightDisplayService(Context context) {
        super(context);
        this.mHandler = new Handler(Looper.getMainLooper());
    }

    @Override
    public void onStart() {
    }

    @Override
    public void onBootPhase(int phase) {
        IVrManager vrManager;
        if (phase >= 500 && (vrManager = IVrManager.Stub.asInterface(this.getBinderService("vrmanager"))) != null) {
            try {
                vrManager.registerListener(this.mVrStateCallbacks);
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Failed to register VR mode state listener: " + e);
            }
        }
        if (phase >= 1000) {
            this.mBootCompleted = true;
            if (this.mCurrentUser != -10000 && this.mUserSetupObserver == null) {
                this.setUp();
            }
        }
    }

    @Override
    public void onStartUser(int userHandle) {
        super.onStartUser(userHandle);
        if (this.mCurrentUser == -10000) {
            this.onUserChanged(userHandle);
        }
    }

    @Override
    public void onSwitchUser(int userHandle) {
        super.onSwitchUser(userHandle);
        this.onUserChanged(userHandle);
    }

    @Override
    public void onStopUser(int userHandle) {
        super.onStopUser(userHandle);
        if (this.mCurrentUser == userHandle) {
            this.onUserChanged(-10000);
        }
    }

    private void onUserChanged(int userHandle) {
        final ContentResolver cr = this.getContext().getContentResolver();
        if (this.mCurrentUser != -10000) {
            if (this.mUserSetupObserver != null) {
                cr.unregisterContentObserver(this.mUserSetupObserver);
                this.mUserSetupObserver = null;
            } else if (this.mBootCompleted) {
                this.tearDown();
            }
        }
        this.mCurrentUser = userHandle;
        if (this.mCurrentUser != -10000) {
            if (!NightDisplayService.isUserSetupCompleted(cr, this.mCurrentUser)) {
                this.mUserSetupObserver = new ContentObserver(this.mHandler){

                    @Override
                    public void onChange(boolean selfChange, Uri uri) {
                        if (NightDisplayService.isUserSetupCompleted(cr, NightDisplayService.this.mCurrentUser)) {
                            cr.unregisterContentObserver(this);
                            NightDisplayService.this.mUserSetupObserver = null;
                            if (NightDisplayService.this.mBootCompleted) {
                                NightDisplayService.this.setUp();
                            }
                        }
                    }
                };
                cr.registerContentObserver(Settings.Secure.getUriFor("user_setup_complete"), false, this.mUserSetupObserver, this.mCurrentUser);
            } else if (this.mBootCompleted) {
                this.setUp();
            }
        }
    }

    private static boolean isUserSetupCompleted(ContentResolver cr, int userHandle) {
        return Settings.Secure.getIntForUser(cr, "user_setup_complete", 0, userHandle) == 1;
    }

    private void setUp() {
        Slog.d(TAG, "setUp: currentUser=" + this.mCurrentUser);
        this.mController = new NightDisplayController(this.getContext(), this.mCurrentUser);
        this.mController.setListener(this);
        this.setCoefficientMatrix(this.getContext());
        this.setMatrix(this.mController.getColorTemperature(), this.mMatrixNight);
        this.onAutoModeChanged(this.mController.getAutoMode());
        if (this.mIsActivated == null) {
            this.onActivated(this.mController.isActivated());
        }
        this.applyTint(false);
    }

    private void tearDown() {
        Slog.d(TAG, "tearDown: currentUser=" + this.mCurrentUser);
        if (this.mController != null) {
            this.mController.setListener(null);
            this.mController = null;
        }
        if (this.mAutoMode != null) {
            this.mAutoMode.onStop();
            this.mAutoMode = null;
        }
        if (this.mColorMatrixAnimator != null) {
            this.mColorMatrixAnimator.end();
            this.mColorMatrixAnimator = null;
        }
        this.mIsActivated = null;
    }

    @Override
    public void onActivated(boolean activated) {
        if (this.mIsActivated == null || this.mIsActivated != activated) {
            Slog.i(TAG, activated ? "Turning on night display" : "Turning off night display");
            this.mIsActivated = activated;
            if (this.mAutoMode != null) {
                this.mAutoMode.onActivated(activated);
            }
            this.applyTint(false);
        }
    }

    @Override
    public void onAutoModeChanged(int autoMode) {
        Slog.d(TAG, "onAutoModeChanged: autoMode=" + autoMode);
        if (this.mAutoMode != null) {
            this.mAutoMode.onStop();
            this.mAutoMode = null;
        }
        if (autoMode == 1) {
            this.mAutoMode = new CustomAutoMode();
        } else if (autoMode == 2) {
            this.mAutoMode = new TwilightAutoMode();
        }
        if (this.mAutoMode != null) {
            this.mAutoMode.onStart();
        }
    }

    @Override
    public void onCustomStartTimeChanged(LocalTime startTime) {
        Slog.d(TAG, "onCustomStartTimeChanged: startTime=" + startTime);
        if (this.mAutoMode != null) {
            this.mAutoMode.onCustomStartTimeChanged(startTime);
        }
    }

    @Override
    public void onCustomEndTimeChanged(LocalTime endTime) {
        Slog.d(TAG, "onCustomEndTimeChanged: endTime=" + endTime);
        if (this.mAutoMode != null) {
            this.mAutoMode.onCustomEndTimeChanged(endTime);
        }
    }

    @Override
    public void onColorTemperatureChanged(int colorTemperature) {
        this.setMatrix(colorTemperature, this.mMatrixNight);
        this.applyTint(true);
    }

    @Override
    public void onDisplayColorModeChanged(int colorMode) {
        DisplayTransformManager dtm = this.getLocalService(DisplayTransformManager.class);
        dtm.setColorMode(colorMode);
        this.setCoefficientMatrix(this.getContext());
        this.setMatrix(this.mController.getColorTemperature(), this.mMatrixNight);
        if (this.mController.isActivated()) {
            this.applyTint(true);
        }
    }

    private void setCoefficientMatrix(Context context) {
        boolean isNative = DisplayTransformManager.isNativeModeEnabled();
        String[] coefficients = context.getResources().getStringArray(isNative ? 17236016 : 17236015);
        for (int i = 0; i < 9 && i < coefficients.length; ++i) {
            this.mColorTempCoefficients[i] = Float.parseFloat(coefficients[i]);
        }
    }

    private void applyTint(boolean immediate) {
        float[] to;
        if (this.mColorMatrixAnimator != null) {
            this.mColorMatrixAnimator.cancel();
        }
        if (this.mIgnoreAllColorMatrixChanges.get()) {
            return;
        }
        final DisplayTransformManager dtm = this.getLocalService(DisplayTransformManager.class);
        float[] from = dtm.getColorMatrix(100);
        float[] fArray = to = this.mIsActivated != false ? this.mMatrixNight : MATRIX_IDENTITY;
        if (immediate) {
            dtm.setColorMatrix(100, to);
        } else {
            this.mColorMatrixAnimator = ValueAnimator.ofObject(COLOR_MATRIX_EVALUATOR, from == null ? MATRIX_IDENTITY : from, to);
            this.mColorMatrixAnimator.setDuration(3000L);
            this.mColorMatrixAnimator.setInterpolator(AnimationUtils.loadInterpolator(this.getContext(), 17563661));
            this.mColorMatrixAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                @Override
                public void onAnimationUpdate(ValueAnimator animator2) {
                    float[] value = (float[])animator2.getAnimatedValue();
                    dtm.setColorMatrix(100, value);
                }
            });
            this.mColorMatrixAnimator.addListener(new AnimatorListenerAdapter(){
                private boolean mIsCancelled;

                @Override
                public void onAnimationCancel(Animator animator2) {
                    this.mIsCancelled = true;
                }

                @Override
                public void onAnimationEnd(Animator animator2) {
                    if (!this.mIsCancelled) {
                        dtm.setColorMatrix(100, to);
                    }
                    NightDisplayService.this.mColorMatrixAnimator = null;
                }
            });
            this.mColorMatrixAnimator.start();
        }
    }

    private void setMatrix(int colorTemperature, float[] outTemp) {
        if (outTemp.length != 16) {
            Slog.d(TAG, "The display transformation matrix must be 4x4");
            return;
        }
        Matrix.setIdentityM(outTemp, 0);
        float squareTemperature = colorTemperature * colorTemperature;
        float red = squareTemperature * this.mColorTempCoefficients[0] + (float)colorTemperature * this.mColorTempCoefficients[1] + this.mColorTempCoefficients[2];
        float green = squareTemperature * this.mColorTempCoefficients[3] + (float)colorTemperature * this.mColorTempCoefficients[4] + this.mColorTempCoefficients[5];
        float blue = squareTemperature * this.mColorTempCoefficients[6] + (float)colorTemperature * this.mColorTempCoefficients[7] + this.mColorTempCoefficients[8];
        outTemp[0] = red;
        outTemp[5] = green;
        outTemp[10] = blue;
    }

    public static LocalDateTime getDateTimeBefore(LocalTime localTime, LocalDateTime compareTime) {
        LocalDateTime ldt = LocalDateTime.of(compareTime.getYear(), compareTime.getMonth(), compareTime.getDayOfMonth(), localTime.getHour(), localTime.getMinute());
        return ldt.isAfter(compareTime) ? ldt.minusDays(1L) : ldt;
    }

    public static LocalDateTime getDateTimeAfter(LocalTime localTime, LocalDateTime compareTime) {
        LocalDateTime ldt = LocalDateTime.of(compareTime.getYear(), compareTime.getMonth(), compareTime.getDayOfMonth(), localTime.getHour(), localTime.getMinute());
        return ldt.isBefore(compareTime) ? ldt.plusDays(1L) : ldt;
    }

    static {
        Matrix.setIdentityM(MATRIX_IDENTITY, 0);
        COLOR_MATRIX_EVALUATOR = new ColorMatrixEvaluator();
    }

    private static class ColorMatrixEvaluator
    implements TypeEvaluator<float[]> {
        private final float[] mResultMatrix = new float[16];

        private ColorMatrixEvaluator() {
        }

        @Override
        public float[] evaluate(float fraction2, float[] startValue, float[] endValue) {
            for (int i = 0; i < this.mResultMatrix.length; ++i) {
                this.mResultMatrix[i] = MathUtils.lerp(startValue[i], endValue[i], fraction2);
            }
            return this.mResultMatrix;
        }
    }

    private class TwilightAutoMode
    extends AutoMode
    implements TwilightListener {
        private final TwilightManager mTwilightManager;

        TwilightAutoMode() {
            this.mTwilightManager = (TwilightManager)NightDisplayService.this.getLocalService(TwilightManager.class);
        }

        private void updateActivated(TwilightState state) {
            if (state == null) {
                return;
            }
            boolean activate = state.isNight();
            LocalDateTime lastActivatedTime = NightDisplayService.this.mController.getLastActivatedTime();
            if (lastActivatedTime != null) {
                LocalDateTime now = LocalDateTime.now();
                LocalDateTime sunrise = state.sunrise();
                LocalDateTime sunset = state.sunset();
                if (lastActivatedTime.isBefore(now) && lastActivatedTime.isBefore(sunrise) ^ lastActivatedTime.isBefore(sunset)) {
                    activate = NightDisplayService.this.mController.isActivated();
                }
            }
            if (NightDisplayService.this.mIsActivated == null || NightDisplayService.this.mIsActivated != activate) {
                NightDisplayService.this.mController.setActivated(activate);
            }
        }

        @Override
        public void onStart() {
            this.mTwilightManager.registerListener(this, NightDisplayService.this.mHandler);
            this.updateActivated(this.mTwilightManager.getLastTwilightState());
        }

        @Override
        public void onStop() {
            this.mTwilightManager.unregisterListener(this);
        }

        @Override
        public void onActivated(boolean activated) {
        }

        @Override
        public void onTwilightStateChanged(TwilightState state) {
            Slog.d(NightDisplayService.TAG, "onTwilightStateChanged: isNight=" + (state == null ? null : Boolean.valueOf(state.isNight())));
            this.updateActivated(state);
        }
    }

    private class CustomAutoMode
    extends AutoMode
    implements AlarmManager.OnAlarmListener {
        private final AlarmManager mAlarmManager;
        private final BroadcastReceiver mTimeChangedReceiver;
        private LocalTime mStartTime;
        private LocalTime mEndTime;
        private LocalDateTime mLastActivatedTime;

        CustomAutoMode() {
            this.mAlarmManager = (AlarmManager)NightDisplayService.this.getContext().getSystemService("alarm");
            this.mTimeChangedReceiver = new BroadcastReceiver(){

                @Override
                public void onReceive(Context context, Intent intent) {
                    CustomAutoMode.this.updateActivated();
                }
            };
        }

        private void updateActivated() {
            LocalDateTime now = LocalDateTime.now();
            LocalDateTime start = NightDisplayService.getDateTimeBefore(this.mStartTime, now);
            LocalDateTime end = NightDisplayService.getDateTimeAfter(this.mEndTime, start);
            boolean activate = now.isBefore(end);
            if (this.mLastActivatedTime != null && this.mLastActivatedTime.isBefore(now) && this.mLastActivatedTime.isAfter(start) && (this.mLastActivatedTime.isAfter(end) || now.isBefore(end))) {
                activate = NightDisplayService.this.mController.isActivated();
            }
            if (NightDisplayService.this.mIsActivated == null || NightDisplayService.this.mIsActivated != activate) {
                NightDisplayService.this.mController.setActivated(activate);
            }
            this.updateNextAlarm(NightDisplayService.this.mIsActivated, now);
        }

        private void updateNextAlarm(Boolean activated, LocalDateTime now) {
            if (activated != null) {
                LocalDateTime next = activated != false ? NightDisplayService.getDateTimeAfter(this.mEndTime, now) : NightDisplayService.getDateTimeAfter(this.mStartTime, now);
                long millis = next.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
                this.mAlarmManager.setExact(1, millis, NightDisplayService.TAG, this, null);
            }
        }

        @Override
        public void onStart() {
            IntentFilter intentFilter = new IntentFilter("android.intent.action.TIME_SET");
            intentFilter.addAction("android.intent.action.TIMEZONE_CHANGED");
            NightDisplayService.this.getContext().registerReceiver(this.mTimeChangedReceiver, intentFilter);
            this.mStartTime = NightDisplayService.this.mController.getCustomStartTime();
            this.mEndTime = NightDisplayService.this.mController.getCustomEndTime();
            this.mLastActivatedTime = NightDisplayService.this.mController.getLastActivatedTime();
            this.updateActivated();
        }

        @Override
        public void onStop() {
            NightDisplayService.this.getContext().unregisterReceiver(this.mTimeChangedReceiver);
            this.mAlarmManager.cancel(this);
            this.mLastActivatedTime = null;
        }

        @Override
        public void onActivated(boolean activated) {
            this.mLastActivatedTime = NightDisplayService.this.mController.getLastActivatedTime();
            this.updateNextAlarm(activated, LocalDateTime.now());
        }

        @Override
        public void onCustomStartTimeChanged(LocalTime startTime) {
            this.mStartTime = startTime;
            this.mLastActivatedTime = null;
            this.updateActivated();
        }

        @Override
        public void onCustomEndTimeChanged(LocalTime endTime) {
            this.mEndTime = endTime;
            this.mLastActivatedTime = null;
            this.updateActivated();
        }

        @Override
        public void onAlarm() {
            Slog.d(NightDisplayService.TAG, "onAlarm");
            this.updateActivated();
        }
    }

    private abstract class AutoMode
    implements NightDisplayController.Callback {
        private AutoMode() {
        }

        public abstract void onStart();

        public abstract void onStop();
    }
}

