/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.display;

import android.app.ActivityManager;
import android.opengl.Matrix;
import android.os.IBinder;
import android.os.Parcel;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemProperties;
import android.util.Log;
import android.util.Slog;
import android.util.SparseArray;
import com.android.internal.annotations.GuardedBy;
import java.util.Arrays;

public class DisplayTransformManager {
    private static final String TAG = "DisplayTransformManager";
    public static final int LEVEL_COLOR_MATRIX_NIGHT_DISPLAY = 100;
    public static final int LEVEL_COLOR_MATRIX_GRAYSCALE = 200;
    public static final int LEVEL_COLOR_MATRIX_INVERT_COLOR = 300;
    private static final int SURFACE_FLINGER_TRANSACTION_COLOR_MATRIX = 1015;
    private static final int SURFACE_FLINGER_TRANSACTION_DALTONIZER = 1014;
    static final String PERSISTENT_PROPERTY_SATURATION = "persist.sys.sf.color_saturation";
    static final String PERSISTENT_PROPERTY_NATIVE_MODE = "persist.sys.sf.native_mode";
    private static final int SURFACE_FLINGER_TRANSACTION_SATURATION = 1022;
    private static final int SURFACE_FLINGER_TRANSACTION_NATIVE_MODE = 1023;
    static final float COLOR_SATURATION_NATURAL = 1.0f;
    static final float COLOR_SATURATION_BOOSTED = 1.1f;
    @GuardedBy(value="mColorMatrix")
    private final SparseArray<float[]> mColorMatrix = new SparseArray(3);
    @GuardedBy(value="mColorMatrix")
    private final float[][] mTempColorMatrix = new float[2][16];
    private final Object mDaltonizerModeLock = new Object();
    @GuardedBy(value="mDaltonizerModeLock")
    private int mDaltonizerMode = -1;
    private IBinder mSurfaceFlinger;

    DisplayTransformManager() {
    }

    public IBinder getSurfaceFlinger() {
        if (this.mSurfaceFlinger == null) {
            this.mSurfaceFlinger = ServiceManager.getService("SurfaceFlinger");
        }
        return this.mSurfaceFlinger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float[] getColorMatrix(int key) {
        SparseArray<float[]> sparseArray = this.mColorMatrix;
        synchronized (sparseArray) {
            float[] value = this.mColorMatrix.get(key);
            return value == null ? null : Arrays.copyOf(value, value.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setColorMatrix(int level, float[] value) {
        if (value != null && value.length != 16) {
            throw new IllegalArgumentException("Expected length: 16 (4x4 matrix), actual length: " + value.length);
        }
        SparseArray<float[]> sparseArray = this.mColorMatrix;
        synchronized (sparseArray) {
            float[] oldValue = this.mColorMatrix.get(level);
            if (!Arrays.equals(oldValue, value)) {
                if (value == null) {
                    this.mColorMatrix.remove(level);
                } else if (oldValue == null) {
                    this.mColorMatrix.put(level, Arrays.copyOf(value, value.length));
                } else {
                    System.arraycopy((float[])value, (int)0, (float[])oldValue, (int)0, (int)value.length);
                }
                DisplayTransformManager.applyColorMatrix(this.computeColorMatrixLocked());
            }
        }
    }

    @GuardedBy(value="mColorMatrix")
    private float[] computeColorMatrixLocked() {
        int count = this.mColorMatrix.size();
        if (count == 0) {
            return null;
        }
        float[][] result = this.mTempColorMatrix;
        Matrix.setIdentityM(result[0], 0);
        for (int i = 0; i < count; ++i) {
            float[] rhs = this.mColorMatrix.valueAt(i);
            Matrix.multiplyMM(result[(i + 1) % 2], 0, result[i % 2], 0, rhs, 0);
        }
        return result[count % 2];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDaltonizerMode() {
        Object object = this.mDaltonizerModeLock;
        synchronized (object) {
            return this.mDaltonizerMode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDaltonizerMode(int mode) {
        Object object = this.mDaltonizerModeLock;
        synchronized (object) {
            if (this.mDaltonizerMode != mode) {
                this.mDaltonizerMode = mode;
                DisplayTransformManager.applyDaltonizerMode(mode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void applyColorMatrix(float[] m) {
        IBinder flinger = ServiceManager.getService("SurfaceFlinger");
        if (flinger != null) {
            Parcel data = Parcel.obtain();
            data.writeInterfaceToken("android.ui.ISurfaceComposer");
            if (m != null) {
                data.writeInt(1);
                for (int i = 0; i < 16; ++i) {
                    data.writeFloat(m[i]);
                }
            } else {
                data.writeInt(0);
            }
            try {
                flinger.transact(1015, data, null, 0);
            }
            catch (RemoteException ex) {
                Slog.e(TAG, "Failed to set color transform", ex);
            }
            finally {
                data.recycle();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void applyDaltonizerMode(int mode) {
        IBinder flinger = ServiceManager.getService("SurfaceFlinger");
        if (flinger != null) {
            Parcel data = Parcel.obtain();
            data.writeInterfaceToken("android.ui.ISurfaceComposer");
            data.writeInt(mode);
            try {
                flinger.transact(1014, data, null, 0);
            }
            catch (RemoteException ex) {
                Slog.e(TAG, "Failed to set Daltonizer mode", ex);
            }
            finally {
                data.recycle();
            }
        }
    }

    public static boolean isNativeModeEnabled() {
        return SystemProperties.getBoolean(PERSISTENT_PROPERTY_NATIVE_MODE, false);
    }

    public boolean setColorMode(int colorMode) {
        if (colorMode == 0) {
            this.applySaturation(1.0f);
            this.setNativeMode(false);
        } else if (colorMode == 1) {
            this.applySaturation(1.1f);
            this.setNativeMode(false);
        } else if (colorMode == 2) {
            this.applySaturation(1.0f);
            this.setNativeMode(true);
        }
        this.updateConfiguration();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applySaturation(float saturation) {
        SystemProperties.set(PERSISTENT_PROPERTY_SATURATION, Float.toString(saturation));
        if (this.getSurfaceFlinger() != null) {
            Parcel data = Parcel.obtain();
            data.writeInterfaceToken("android.ui.ISurfaceComposer");
            data.writeFloat(saturation);
            try {
                this.getSurfaceFlinger().transact(1022, data, null, 0);
            }
            catch (RemoteException ex) {
                Log.e(TAG, "Failed to set saturation", ex);
            }
            finally {
                data.recycle();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setNativeMode(boolean enabled) {
        SystemProperties.set(PERSISTENT_PROPERTY_NATIVE_MODE, enabled ? "1" : "0");
        if (this.getSurfaceFlinger() != null) {
            Parcel data = Parcel.obtain();
            data.writeInterfaceToken("android.ui.ISurfaceComposer");
            data.writeInt(enabled ? 1 : 0);
            try {
                this.getSurfaceFlinger().transact(1023, data, null, 0);
            }
            catch (RemoteException ex) {
                Log.e(TAG, "Failed to set native mode", ex);
            }
            finally {
                data.recycle();
            }
        }
    }

    void updateConfiguration() {
        try {
            ActivityManager.getService().updateConfiguration(null);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Could not update configuration", e);
        }
    }
}

