/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.content;

import android.accounts.Account;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.PersistableBundle;
import android.os.SystemClock;
import android.os.UserHandle;
import android.util.Slog;
import com.android.server.content.SyncManager;
import com.android.server.content.SyncStorageEngine;

public class SyncOperation {
    public static final String TAG = "SyncManager";
    public static final int NO_JOB_ID = -1;
    public static final int REASON_BACKGROUND_DATA_SETTINGS_CHANGED = -1;
    public static final int REASON_ACCOUNTS_UPDATED = -2;
    public static final int REASON_SERVICE_CHANGED = -3;
    public static final int REASON_PERIODIC = -4;
    public static final int REASON_IS_SYNCABLE = -5;
    public static final int REASON_SYNC_AUTO = -6;
    public static final int REASON_MASTER_SYNC_AUTO = -7;
    public static final int REASON_USER_START = -8;
    private static String[] REASON_NAMES = new String[]{"DataSettingsChanged", "AccountsUpdated", "ServiceChanged", "Periodic", "IsSyncable", "AutoSync", "MasterSyncAuto", "UserStart"};
    public final SyncStorageEngine.EndPoint target;
    public final int owningUid;
    public final String owningPackage;
    public final int reason;
    public final int syncSource;
    public final boolean allowParallelSyncs;
    public final Bundle extras;
    public final boolean isPeriodic;
    public final int sourcePeriodicId;
    public final String key;
    public final long periodMillis;
    public final long flexMillis;
    public String wakeLockName;
    public long expectedRuntime;
    int retries;
    public int jobId;

    public SyncOperation(Account account, int userId, int owningUid, String owningPackage, int reason, int source, String provider, Bundle extras, boolean allowParallelSyncs) {
        this(new SyncStorageEngine.EndPoint(account, provider, userId), owningUid, owningPackage, reason, source, extras, allowParallelSyncs);
    }

    private SyncOperation(SyncStorageEngine.EndPoint info, int owningUid, String owningPackage, int reason, int source, Bundle extras, boolean allowParallelSyncs) {
        this(info, owningUid, owningPackage, reason, source, extras, allowParallelSyncs, false, -1, 0L, 0L);
    }

    public SyncOperation(SyncOperation op, long periodMillis, long flexMillis) {
        this(op.target, op.owningUid, op.owningPackage, op.reason, op.syncSource, new Bundle(op.extras), op.allowParallelSyncs, op.isPeriodic, op.sourcePeriodicId, periodMillis, flexMillis);
    }

    public SyncOperation(SyncStorageEngine.EndPoint info, int owningUid, String owningPackage, int reason, int source, Bundle extras, boolean allowParallelSyncs, boolean isPeriodic, int sourcePeriodicId, long periodMillis, long flexMillis) {
        this.target = info;
        this.owningUid = owningUid;
        this.owningPackage = owningPackage;
        this.reason = reason;
        this.syncSource = source;
        this.extras = new Bundle(extras);
        this.allowParallelSyncs = allowParallelSyncs;
        this.isPeriodic = isPeriodic;
        this.sourcePeriodicId = sourcePeriodicId;
        this.periodMillis = periodMillis;
        this.flexMillis = flexMillis;
        this.jobId = -1;
        this.key = this.toKey();
    }

    public SyncOperation createOneTimeSyncOperation() {
        if (!this.isPeriodic) {
            return null;
        }
        SyncOperation op = new SyncOperation(this.target, this.owningUid, this.owningPackage, this.reason, this.syncSource, new Bundle(this.extras), this.allowParallelSyncs, false, this.jobId, this.periodMillis, this.flexMillis);
        return op;
    }

    public SyncOperation(SyncOperation other) {
        this.target = other.target;
        this.owningUid = other.owningUid;
        this.owningPackage = other.owningPackage;
        this.reason = other.reason;
        this.syncSource = other.syncSource;
        this.allowParallelSyncs = other.allowParallelSyncs;
        this.extras = new Bundle(other.extras);
        this.wakeLockName = other.wakeLockName();
        this.isPeriodic = other.isPeriodic;
        this.sourcePeriodicId = other.sourcePeriodicId;
        this.periodMillis = other.periodMillis;
        this.flexMillis = other.flexMillis;
        this.key = other.key;
    }

    PersistableBundle toJobInfoExtras() {
        PersistableBundle jobInfoExtras = new PersistableBundle();
        PersistableBundle syncExtrasBundle = new PersistableBundle();
        for (String key : this.extras.keySet()) {
            Object value = this.extras.get(key);
            if (value instanceof Account) {
                Account account = (Account)value;
                PersistableBundle accountBundle = new PersistableBundle();
                accountBundle.putString("accountName", account.name);
                accountBundle.putString("accountType", account.type);
                jobInfoExtras.putPersistableBundle("ACCOUNT:" + key, accountBundle);
                continue;
            }
            if (value instanceof Long) {
                syncExtrasBundle.putLong(key, (Long)value);
                continue;
            }
            if (value instanceof Integer) {
                syncExtrasBundle.putInt(key, (Integer)value);
                continue;
            }
            if (value instanceof Boolean) {
                syncExtrasBundle.putBoolean(key, (Boolean)value);
                continue;
            }
            if (value instanceof Float) {
                syncExtrasBundle.putDouble(key, ((Float)value).floatValue());
                continue;
            }
            if (value instanceof Double) {
                syncExtrasBundle.putDouble(key, (Double)value);
                continue;
            }
            if (value instanceof String) {
                syncExtrasBundle.putString(key, (String)value);
                continue;
            }
            if (value == null) {
                syncExtrasBundle.putString(key, null);
                continue;
            }
            Slog.e(TAG, "Unknown extra type.");
        }
        jobInfoExtras.putPersistableBundle("syncExtras", syncExtrasBundle);
        jobInfoExtras.putBoolean("SyncManagerJob", true);
        jobInfoExtras.putString("provider", this.target.provider);
        jobInfoExtras.putString("accountName", this.target.account.name);
        jobInfoExtras.putString("accountType", this.target.account.type);
        jobInfoExtras.putInt("userId", this.target.userId);
        jobInfoExtras.putInt("owningUid", this.owningUid);
        jobInfoExtras.putString("owningPackage", this.owningPackage);
        jobInfoExtras.putInt("reason", this.reason);
        jobInfoExtras.putInt("source", this.syncSource);
        jobInfoExtras.putBoolean("allowParallelSyncs", this.allowParallelSyncs);
        jobInfoExtras.putInt("jobId", this.jobId);
        jobInfoExtras.putBoolean("isPeriodic", this.isPeriodic);
        jobInfoExtras.putInt("sourcePeriodicId", this.sourcePeriodicId);
        jobInfoExtras.putLong("periodMillis", this.periodMillis);
        jobInfoExtras.putLong("flexMillis", this.flexMillis);
        jobInfoExtras.putLong("expectedRuntime", this.expectedRuntime);
        jobInfoExtras.putInt("retries", this.retries);
        return jobInfoExtras;
    }

    static SyncOperation maybeCreateFromJobExtras(PersistableBundle jobExtras) {
        if (jobExtras == null) {
            return null;
        }
        if (!jobExtras.getBoolean("SyncManagerJob", false)) {
            return null;
        }
        String accountName = jobExtras.getString("accountName");
        String accountType = jobExtras.getString("accountType");
        String provider = jobExtras.getString("provider");
        int userId = jobExtras.getInt("userId", Integer.MAX_VALUE);
        int owningUid = jobExtras.getInt("owningUid");
        String owningPackage = jobExtras.getString("owningPackage");
        int reason = jobExtras.getInt("reason", Integer.MAX_VALUE);
        int source = jobExtras.getInt("source", Integer.MAX_VALUE);
        boolean allowParallelSyncs = jobExtras.getBoolean("allowParallelSyncs", false);
        boolean isPeriodic = jobExtras.getBoolean("isPeriodic", false);
        int initiatedBy = jobExtras.getInt("sourcePeriodicId", -1);
        long periodMillis = jobExtras.getLong("periodMillis");
        long flexMillis = jobExtras.getLong("flexMillis");
        Bundle extras = new Bundle();
        PersistableBundle syncExtras = jobExtras.getPersistableBundle("syncExtras");
        if (syncExtras != null) {
            extras.putAll(syncExtras);
        }
        for (String key : jobExtras.keySet()) {
            if (key == null || !key.startsWith("ACCOUNT:")) continue;
            String newKey = key.substring(8);
            PersistableBundle accountsBundle = jobExtras.getPersistableBundle(key);
            Account account = new Account(accountsBundle.getString("accountName"), accountsBundle.getString("accountType"));
            extras.putParcelable(newKey, account);
        }
        Account account = new Account(accountName, accountType);
        SyncStorageEngine.EndPoint target = new SyncStorageEngine.EndPoint(account, provider, userId);
        SyncOperation op = new SyncOperation(target, owningUid, owningPackage, reason, source, extras, allowParallelSyncs, isPeriodic, initiatedBy, periodMillis, flexMillis);
        op.jobId = jobExtras.getInt("jobId");
        op.expectedRuntime = jobExtras.getLong("expectedRuntime");
        op.retries = jobExtras.getInt("retries");
        return op;
    }

    boolean isConflict(SyncOperation toRun) {
        SyncStorageEngine.EndPoint other = toRun.target;
        return this.target.account.type.equals(other.account.type) && this.target.provider.equals(other.provider) && this.target.userId == other.userId && (!this.allowParallelSyncs || this.target.account.name.equals(other.account.name));
    }

    boolean isReasonPeriodic() {
        return this.reason == -4;
    }

    boolean matchesPeriodicOperation(SyncOperation other) {
        return this.target.matchesSpec(other.target) && SyncManager.syncExtrasEquals(this.extras, other.extras, true) && this.periodMillis == other.periodMillis && this.flexMillis == other.flexMillis;
    }

    boolean isDerivedFromFailedPeriodicSync() {
        return this.sourcePeriodicId != -1;
    }

    int findPriority() {
        if (this.isInitialization()) {
            return 20;
        }
        if (this.isExpedited()) {
            return 10;
        }
        return 0;
    }

    private String toKey() {
        StringBuilder sb = new StringBuilder();
        sb.append("provider: ").append(this.target.provider);
        sb.append(" account {name=" + this.target.account.name + ", user=" + this.target.userId + ", type=" + this.target.account.type + "}");
        sb.append(" isPeriodic: ").append(this.isPeriodic);
        sb.append(" period: ").append(this.periodMillis);
        sb.append(" flex: ").append(this.flexMillis);
        sb.append(" extras: ");
        SyncOperation.extrasToStringBuilder(this.extras, sb);
        return sb.toString();
    }

    public String toString() {
        return this.dump(null, true);
    }

    String dump(PackageManager pm, boolean shorter) {
        StringBuilder sb = new StringBuilder();
        sb.append("JobId=").append(this.jobId).append(" ").append(this.target.account.name).append("/").append(this.target.account.type).append(" u").append(this.target.userId).append(" [").append(this.target.provider).append("] ");
        sb.append(SyncStorageEngine.SOURCES[this.syncSource]);
        if (this.expectedRuntime != 0L) {
            sb.append(" ExpectedIn=");
            SyncManager.formatDurationHMS(sb, this.expectedRuntime - SystemClock.elapsedRealtime());
        }
        if (this.extras.getBoolean("expedited", false)) {
            sb.append(" EXPEDITED");
        }
        sb.append(" Reason=");
        sb.append(SyncOperation.reasonToString(pm, this.reason));
        if (this.isPeriodic) {
            sb.append(" (period=");
            SyncManager.formatDurationHMS(sb, this.periodMillis);
            sb.append(" flex=");
            SyncManager.formatDurationHMS(sb, this.flexMillis);
            sb.append(")");
        }
        if (!shorter) {
            sb.append(" Owner={");
            UserHandle.formatUid(sb, this.owningUid);
            sb.append(" ");
            sb.append(this.owningPackage);
            sb.append("}");
            if (!this.extras.keySet().isEmpty()) {
                sb.append(" ");
                SyncOperation.extrasToStringBuilder(this.extras, sb);
            }
        }
        return sb.toString();
    }

    static String reasonToString(PackageManager pm, int reason) {
        if (reason >= 0) {
            if (pm != null) {
                String[] packages = pm.getPackagesForUid(reason);
                if (packages != null && packages.length == 1) {
                    return packages[0];
                }
                String name = pm.getNameForUid(reason);
                if (name != null) {
                    return name;
                }
                return String.valueOf(reason);
            }
            return String.valueOf(reason);
        }
        int index = -reason - 1;
        if (index >= REASON_NAMES.length) {
            return String.valueOf(reason);
        }
        return REASON_NAMES[index];
    }

    boolean isInitialization() {
        return this.extras.getBoolean("initialize", false);
    }

    boolean isExpedited() {
        return this.extras.getBoolean("expedited", false);
    }

    boolean ignoreBackoff() {
        return this.extras.getBoolean("ignore_backoff", false);
    }

    boolean isNotAllowedOnMetered() {
        return this.extras.getBoolean("allow_metered", false);
    }

    boolean isManual() {
        return this.extras.getBoolean("force", false);
    }

    boolean isIgnoreSettings() {
        return this.extras.getBoolean("ignore_settings", false);
    }

    static void extrasToStringBuilder(Bundle bundle, StringBuilder sb) {
        if (bundle == null) {
            sb.append("null");
            return;
        }
        sb.append("[");
        for (String key : bundle.keySet()) {
            sb.append(key).append("=").append(bundle.get(key)).append(" ");
        }
        sb.append("]");
    }

    static String extrasToString(Bundle bundle) {
        StringBuilder sb = new StringBuilder();
        SyncOperation.extrasToStringBuilder(bundle, sb);
        return sb.toString();
    }

    String wakeLockName() {
        if (this.wakeLockName != null) {
            return this.wakeLockName;
        }
        this.wakeLockName = this.target.provider + "/" + this.target.account.type + "/" + this.target.account.name;
        return this.wakeLockName;
    }

    public Object[] toEventLog(int event) {
        Object[] logArray = new Object[4];
        logArray[1] = event;
        logArray[2] = this.syncSource;
        logArray[0] = this.target.provider;
        logArray[3] = this.target.account.name.hashCode();
        return logArray;
    }
}

