/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.backup.utils;

import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.net.Uri;
import android.util.Slog;
import com.android.server.backup.FileMetadata;
import com.android.server.backup.restore.RestoreDeleteObserver;
import com.android.server.backup.restore.RestoreInstallObserver;
import com.android.server.backup.restore.RestorePolicy;
import com.android.server.backup.utils.AppBackupUtils;
import com.android.server.backup.utils.BytesReadListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;

public class RestoreUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean installApk(InputStream instream, PackageManager packageManager, RestoreInstallObserver installObserver, RestoreDeleteObserver deleteObserver, HashMap<String, Signature[]> manifestSignatures, HashMap<String, RestorePolicy> packagePolicies, FileMetadata info, String installerPackage, BytesReadListener bytesReadListener, File dataDir) {
        boolean okay;
        block19: {
            okay = true;
            Slog.d("BackupManagerService", "Installing from backup: " + info.packageName);
            File apkFile = new File(dataDir, info.packageName);
            try {
                int didRead;
                FileOutputStream apkStream = new FileOutputStream(apkFile);
                byte[] buffer = new byte[32768];
                for (long size = info.size; size > 0L; size -= (long)didRead) {
                    long toRead = (long)buffer.length < size ? (long)buffer.length : size;
                    didRead = instream.read(buffer, 0, (int)toRead);
                    if (didRead >= 0) {
                        bytesReadListener.onBytesRead(didRead);
                    }
                    apkStream.write(buffer, 0, didRead);
                }
                apkStream.close();
                apkFile.setReadable(true, false);
                Uri packageUri = Uri.fromFile(apkFile);
                installObserver.reset();
                packageManager.installPackage(packageUri, installObserver, 34, installerPackage);
                installObserver.waitForCompletion();
                if (installObserver.getResult() != 1) {
                    if (packagePolicies.get(info.packageName) != RestorePolicy.ACCEPT) {
                        okay = false;
                    }
                    break block19;
                }
                boolean uninstall = false;
                if (!installObserver.getPackageName().equals(info.packageName)) {
                    Slog.w("BackupManagerService", "Restore stream claimed to include apk for " + info.packageName + " but apk was really " + installObserver.getPackageName());
                    okay = false;
                    uninstall = true;
                } else {
                    try {
                        PackageInfo pkg = packageManager.getPackageInfo(info.packageName, 64);
                        if ((pkg.applicationInfo.flags & 0x8000) == 0) {
                            Slog.w("BackupManagerService", "Restore stream contains apk of package " + info.packageName + " but it disallows backup/restore");
                            okay = false;
                        } else {
                            Signature[] sigs = manifestSignatures.get(info.packageName);
                            if (AppBackupUtils.signaturesMatch(sigs, pkg)) {
                                if (pkg.applicationInfo.uid < 10000 && pkg.applicationInfo.backupAgentName == null) {
                                    Slog.w("BackupManagerService", "Installed app " + info.packageName + " has restricted uid and no agent");
                                    okay = false;
                                }
                            } else {
                                Slog.w("BackupManagerService", "Installed app " + info.packageName + " signatures do not match restore manifest");
                                okay = false;
                                uninstall = true;
                            }
                        }
                    }
                    catch (PackageManager.NameNotFoundException e) {
                        Slog.w("BackupManagerService", "Install of package " + info.packageName + " succeeded but now not found");
                        okay = false;
                    }
                }
                if (uninstall) {
                    deleteObserver.reset();
                    packageManager.deletePackage(installObserver.getPackageName(), deleteObserver, 0);
                    deleteObserver.waitForCompletion();
                }
            }
            catch (IOException e) {
                Slog.e("BackupManagerService", "Unable to transcribe restored apk for install");
                okay = false;
            }
            finally {
                apkFile.delete();
            }
        }
        return okay;
    }
}

