/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.backup.utils;

import android.util.Slog;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

public class PasswordUtils {
    public static final int PBKDF2_HASH_ROUNDS = 10000;
    private static final int PBKDF2_KEY_SIZE = 256;
    public static final int PBKDF2_SALT_SIZE = 512;
    public static final String ENCRYPTION_ALGORITHM_NAME = "AES-256";

    public static SecretKey buildPasswordKey(String algorithm, String pw, byte[] salt, int rounds) {
        return PasswordUtils.buildCharArrayKey(algorithm, pw.toCharArray(), salt, rounds);
    }

    public static String buildPasswordHash(String algorithm, String pw, byte[] salt, int rounds) {
        SecretKey key = PasswordUtils.buildPasswordKey(algorithm, pw, salt, rounds);
        if (key != null) {
            return PasswordUtils.byteArrayToHex(key.getEncoded());
        }
        return null;
    }

    public static String byteArrayToHex(byte[] data) {
        StringBuilder buf = new StringBuilder(data.length * 2);
        for (int i = 0; i < data.length; ++i) {
            buf.append(Byte.toHexString((byte)data[i], (boolean)true));
        }
        return buf.toString();
    }

    public static byte[] hexToByteArray(String digits) {
        int bytes = digits.length() / 2;
        if (2 * bytes != digits.length()) {
            throw new IllegalArgumentException("Hex string must have an even number of digits");
        }
        byte[] result = new byte[bytes];
        for (int i = 0; i < digits.length(); i += 2) {
            result[i / 2] = (byte)Integer.parseInt(digits.substring(i, i + 2), 16);
        }
        return result;
    }

    public static byte[] makeKeyChecksum(String algorithm, byte[] pwBytes, byte[] salt, int rounds) {
        char[] mkAsChar = new char[pwBytes.length];
        for (int i = 0; i < pwBytes.length; ++i) {
            mkAsChar[i] = (char)pwBytes[i];
        }
        SecretKey checksum = PasswordUtils.buildCharArrayKey(algorithm, mkAsChar, salt, rounds);
        return checksum.getEncoded();
    }

    private static SecretKey buildCharArrayKey(String algorithm, char[] pwArray, byte[] salt, int rounds) {
        try {
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(algorithm);
            PBEKeySpec ks = new PBEKeySpec(pwArray, salt, rounds, 256);
            return keyFactory.generateSecret(ks);
        }
        catch (InvalidKeySpecException e) {
            Slog.e("BackupManagerService", "Invalid key spec for PBKDF2!");
        }
        catch (NoSuchAlgorithmException e) {
            Slog.e("BackupManagerService", "PBKDF2 unavailable!");
        }
        return null;
    }
}

