/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.backup.utils;

import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.Signature;
import com.android.internal.util.ArrayUtils;

public class AppBackupUtils {
    public static boolean appIsEligibleForBackup(ApplicationInfo app) {
        if ((app.flags & 0x8000) == 0) {
            return false;
        }
        if (app.uid < 10000 && app.backupAgentName == null) {
            return false;
        }
        return !app.packageName.equals("com.android.sharedstoragebackup");
    }

    public static boolean appIsStopped(ApplicationInfo app) {
        return (app.flags & 0x200000) != 0;
    }

    public static boolean appGetsFullBackup(PackageInfo pkg) {
        if (pkg.applicationInfo.backupAgentName != null) {
            return (pkg.applicationInfo.flags & 0x4000000) != 0;
        }
        return true;
    }

    public static boolean appIsKeyValueOnly(PackageInfo pkg) {
        return !AppBackupUtils.appGetsFullBackup(pkg);
    }

    public static boolean signaturesMatch(Signature[] storedSigs, PackageInfo target) {
        if (target == null) {
            return false;
        }
        if ((target.applicationInfo.flags & 1) != 0) {
            return true;
        }
        Signature[] deviceSigs = target.signatures;
        if (ArrayUtils.isEmpty(storedSigs) || ArrayUtils.isEmpty(deviceSigs)) {
            return false;
        }
        int nStored = storedSigs.length;
        int nDevice = deviceSigs.length;
        for (int i = 0; i < nStored; ++i) {
            boolean match = false;
            for (int j = 0; j < nDevice; ++j) {
                if (!storedSigs[i].equals(deviceSigs[j])) continue;
                match = true;
                break;
            }
            if (match) continue;
            return false;
        }
        return true;
    }
}

