/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.backup.restore;

import android.app.PackageInstallObserver;
import android.os.Bundle;
import com.android.internal.annotations.GuardedBy;
import java.util.concurrent.atomic.AtomicBoolean;

public class RestoreInstallObserver
extends PackageInstallObserver {
    @GuardedBy(value="mDone")
    private final AtomicBoolean mDone = new AtomicBoolean();
    private String mPackageName;
    private int mResult;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        AtomicBoolean atomicBoolean = this.mDone;
        synchronized (atomicBoolean) {
            this.mDone.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForCompletion() {
        AtomicBoolean atomicBoolean = this.mDone;
        synchronized (atomicBoolean) {
            while (!this.mDone.get()) {
                try {
                    this.mDone.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public int getResult() {
        return this.mResult;
    }

    public String getPackageName() {
        return this.mPackageName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onPackageInstalled(String packageName, int returnCode, String msg, Bundle extras) {
        AtomicBoolean atomicBoolean = this.mDone;
        synchronized (atomicBoolean) {
            this.mResult = returnCode;
            this.mPackageName = packageName;
            this.mDone.set(true);
            this.mDone.notifyAll();
        }
    }
}

