/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.backup.restore;

import android.util.Slog;
import com.android.server.backup.BackupRestoreTask;
import com.android.server.backup.RefactoredBackupManagerService;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class AdbRestoreFinishedLatch
implements BackupRestoreTask {
    private static final String TAG = "AdbRestoreFinishedLatch";
    private RefactoredBackupManagerService backupManagerService;
    final CountDownLatch mLatch;
    private final int mCurrentOpToken;

    public AdbRestoreFinishedLatch(RefactoredBackupManagerService backupManagerService, int currentOpToken) {
        this.backupManagerService = backupManagerService;
        this.mLatch = new CountDownLatch(1);
        this.mCurrentOpToken = currentOpToken;
    }

    void await() {
        boolean latched = false;
        try {
            latched = this.mLatch.await(300000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Slog.w(TAG, "Interrupted!");
        }
    }

    @Override
    public void execute() {
    }

    @Override
    public void operationComplete(long result) {
        this.mLatch.countDown();
        this.backupManagerService.removeOperation(this.mCurrentOpToken);
    }

    @Override
    public void handleCancel(boolean cancelAll) {
        Slog.w(TAG, "adb onRestoreFinished() timed out");
        this.mLatch.countDown();
        this.backupManagerService.removeOperation(this.mCurrentOpToken);
    }
}

