/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.os.Binder;
import android.os.UserHandle;
import android.util.ArraySet;
import android.util.Log;
import android.util.Slog;
import com.android.server.am.ActivityManagerService;
import com.android.server.am.UriPermissionOwner;
import com.google.android.collect.Sets;
import java.io.PrintWriter;
import java.util.Comparator;

final class UriPermission {
    private static final String TAG = "UriPermission";
    public static final int STRENGTH_NONE = 0;
    public static final int STRENGTH_OWNED = 1;
    public static final int STRENGTH_GLOBAL = 2;
    public static final int STRENGTH_PERSISTABLE = 3;
    final int targetUserId;
    final String sourcePkg;
    final String targetPkg;
    final int targetUid;
    final ActivityManagerService.GrantUri uri;
    int modeFlags = 0;
    int ownedModeFlags = 0;
    int globalModeFlags = 0;
    int persistableModeFlags = 0;
    int persistedModeFlags = 0;
    long persistedCreateTime = Long.MIN_VALUE;
    private static final long INVALID_TIME = Long.MIN_VALUE;
    private ArraySet<UriPermissionOwner> mReadOwners;
    private ArraySet<UriPermissionOwner> mWriteOwners;
    private String stringName;

    UriPermission(String sourcePkg, String targetPkg, int targetUid, ActivityManagerService.GrantUri uri) {
        this.targetUserId = UserHandle.getUserId(targetUid);
        this.sourcePkg = sourcePkg;
        this.targetPkg = targetPkg;
        this.targetUid = targetUid;
        this.uri = uri;
    }

    private void updateModeFlags() {
        int oldModeFlags = this.modeFlags;
        this.modeFlags = this.ownedModeFlags | this.globalModeFlags | this.persistableModeFlags | this.persistedModeFlags;
        if (Log.isLoggable(TAG, 2) && this.modeFlags != oldModeFlags) {
            Slog.d(TAG, "Permission for " + this.targetPkg + " to " + this.uri + " is changing from 0x" + Integer.toHexString(oldModeFlags) + " to 0x" + Integer.toHexString(this.modeFlags) + " via calling UID " + Binder.getCallingUid() + " PID " + Binder.getCallingPid(), new Throwable());
        }
    }

    void initPersistedModes(int modeFlags, long createdTime) {
        this.persistableModeFlags = modeFlags &= 3;
        this.persistedModeFlags = modeFlags;
        this.persistedCreateTime = createdTime;
        this.updateModeFlags();
    }

    void grantModes(int modeFlags, UriPermissionOwner owner) {
        boolean persistable = (modeFlags & 0x40) != 0;
        modeFlags &= 3;
        if (persistable) {
            this.persistableModeFlags |= modeFlags;
        }
        if (owner == null) {
            this.globalModeFlags |= modeFlags;
        } else {
            if ((modeFlags & 1) != 0) {
                this.addReadOwner(owner);
            }
            if ((modeFlags & 2) != 0) {
                this.addWriteOwner(owner);
            }
        }
        this.updateModeFlags();
    }

    boolean takePersistableModes(int modeFlags) {
        if (((modeFlags &= 3) & this.persistableModeFlags) != modeFlags) {
            Slog.w(TAG, "Requested flags 0x" + Integer.toHexString(modeFlags) + ", but only 0x" + Integer.toHexString(this.persistableModeFlags) + " are allowed");
            return false;
        }
        int before = this.persistedModeFlags;
        this.persistedModeFlags |= this.persistableModeFlags & modeFlags;
        if (this.persistedModeFlags != 0) {
            this.persistedCreateTime = System.currentTimeMillis();
        }
        this.updateModeFlags();
        return this.persistedModeFlags != before;
    }

    boolean releasePersistableModes(int modeFlags) {
        int before = this.persistedModeFlags;
        this.persistableModeFlags &= ~(modeFlags &= 3);
        this.persistedModeFlags &= ~modeFlags;
        if (this.persistedModeFlags == 0) {
            this.persistedCreateTime = Long.MIN_VALUE;
        }
        this.updateModeFlags();
        return this.persistedModeFlags != before;
    }

    boolean revokeModes(int modeFlags, boolean includingOwners) {
        boolean persistable = (modeFlags & 0x40) != 0;
        int before = this.persistedModeFlags;
        if (((modeFlags &= 3) & 1) != 0) {
            if (persistable) {
                this.persistableModeFlags &= 0xFFFFFFFE;
                this.persistedModeFlags &= 0xFFFFFFFE;
            }
            this.globalModeFlags &= 0xFFFFFFFE;
            if (this.mReadOwners != null && includingOwners) {
                this.ownedModeFlags &= 0xFFFFFFFE;
                for (UriPermissionOwner r : this.mReadOwners) {
                    r.removeReadPermission(this);
                }
                this.mReadOwners = null;
            }
        }
        if ((modeFlags & 2) != 0) {
            if (persistable) {
                this.persistableModeFlags &= 0xFFFFFFFD;
                this.persistedModeFlags &= 0xFFFFFFFD;
            }
            this.globalModeFlags &= 0xFFFFFFFD;
            if (this.mWriteOwners != null && includingOwners) {
                this.ownedModeFlags &= 0xFFFFFFFD;
                for (UriPermissionOwner r : this.mWriteOwners) {
                    r.removeWritePermission(this);
                }
                this.mWriteOwners = null;
            }
        }
        if (this.persistedModeFlags == 0) {
            this.persistedCreateTime = Long.MIN_VALUE;
        }
        this.updateModeFlags();
        return this.persistedModeFlags != before;
    }

    public int getStrength(int modeFlags) {
        if ((this.persistableModeFlags & (modeFlags &= 3)) == modeFlags) {
            return 3;
        }
        if ((this.globalModeFlags & modeFlags) == modeFlags) {
            return 2;
        }
        if ((this.ownedModeFlags & modeFlags) == modeFlags) {
            return 1;
        }
        return 0;
    }

    private void addReadOwner(UriPermissionOwner owner) {
        if (this.mReadOwners == null) {
            this.mReadOwners = Sets.newArraySet();
            this.ownedModeFlags |= 1;
            this.updateModeFlags();
        }
        if (this.mReadOwners.add(owner)) {
            owner.addReadPermission(this);
        }
    }

    void removeReadOwner(UriPermissionOwner owner) {
        if (!this.mReadOwners.remove(owner)) {
            Slog.wtf(TAG, "Unknown read owner " + owner + " in " + this);
        }
        if (this.mReadOwners.size() == 0) {
            this.mReadOwners = null;
            this.ownedModeFlags &= 0xFFFFFFFE;
            this.updateModeFlags();
        }
    }

    private void addWriteOwner(UriPermissionOwner owner) {
        if (this.mWriteOwners == null) {
            this.mWriteOwners = Sets.newArraySet();
            this.ownedModeFlags |= 2;
            this.updateModeFlags();
        }
        if (this.mWriteOwners.add(owner)) {
            owner.addWritePermission(this);
        }
    }

    void removeWriteOwner(UriPermissionOwner owner) {
        if (!this.mWriteOwners.remove(owner)) {
            Slog.wtf(TAG, "Unknown write owner " + owner + " in " + this);
        }
        if (this.mWriteOwners.size() == 0) {
            this.mWriteOwners = null;
            this.ownedModeFlags &= 0xFFFFFFFD;
            this.updateModeFlags();
        }
    }

    public String toString() {
        if (this.stringName != null) {
            return this.stringName;
        }
        StringBuilder sb = new StringBuilder(128);
        sb.append("UriPermission{");
        sb.append(Integer.toHexString(System.identityHashCode(this)));
        sb.append(' ');
        sb.append(this.uri);
        sb.append('}');
        this.stringName = sb.toString();
        return this.stringName;
    }

    void dump(PrintWriter pw, String prefix) {
        pw.print(prefix);
        pw.print("targetUserId=" + this.targetUserId);
        pw.print(" sourcePkg=" + this.sourcePkg);
        pw.println(" targetPkg=" + this.targetPkg);
        pw.print(prefix);
        pw.print("mode=0x" + Integer.toHexString(this.modeFlags));
        pw.print(" owned=0x" + Integer.toHexString(this.ownedModeFlags));
        pw.print(" global=0x" + Integer.toHexString(this.globalModeFlags));
        pw.print(" persistable=0x" + Integer.toHexString(this.persistableModeFlags));
        pw.print(" persisted=0x" + Integer.toHexString(this.persistedModeFlags));
        if (this.persistedCreateTime != Long.MIN_VALUE) {
            pw.print(" persistedCreate=" + this.persistedCreateTime);
        }
        pw.println();
        if (this.mReadOwners != null) {
            pw.print(prefix);
            pw.println("readOwners:");
            for (UriPermissionOwner owner : this.mReadOwners) {
                pw.print(prefix);
                pw.println("  * " + owner);
            }
        }
        if (this.mWriteOwners != null) {
            pw.print(prefix);
            pw.println("writeOwners:");
            for (UriPermissionOwner owner : this.mReadOwners) {
                pw.print(prefix);
                pw.println("  * " + owner);
            }
        }
    }

    public Snapshot snapshot() {
        return new Snapshot(this);
    }

    public android.content.UriPermission buildPersistedPublicApiObject() {
        return new android.content.UriPermission(this.uri.uri, this.persistedModeFlags, this.persistedCreateTime);
    }

    public static class Snapshot {
        final int targetUserId;
        final String sourcePkg;
        final String targetPkg;
        final ActivityManagerService.GrantUri uri;
        final int persistedModeFlags;
        final long persistedCreateTime;

        private Snapshot(UriPermission perm) {
            this.targetUserId = perm.targetUserId;
            this.sourcePkg = perm.sourcePkg;
            this.targetPkg = perm.targetPkg;
            this.uri = perm.uri;
            this.persistedModeFlags = perm.persistedModeFlags;
            this.persistedCreateTime = perm.persistedCreateTime;
        }
    }

    public static class PersistedTimeComparator
    implements Comparator<UriPermission> {
        @Override
        public int compare(UriPermission lhs, UriPermission rhs) {
            return Long.compare(lhs.persistedCreateTime, rhs.persistedCreateTime);
        }
    }
}

