/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.app.ActivityManager;
import android.app.ITaskStackListener;
import android.content.ComponentName;
import android.os.Binder;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Process;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import com.android.server.am.ActivityManagerService;
import com.android.server.am.ActivityStackSupervisor;
import java.util.ArrayList;

class TaskChangeNotificationController {
    private static final int LOG_STACK_STATE_MSG = 1;
    private static final int NOTIFY_TASK_STACK_CHANGE_LISTENERS_MSG = 2;
    private static final int NOTIFY_ACTIVITY_PINNED_LISTENERS_MSG = 3;
    private static final int NOTIFY_PINNED_ACTIVITY_RESTART_ATTEMPT_LISTENERS_MSG = 4;
    private static final int NOTIFY_PINNED_STACK_ANIMATION_ENDED_LISTENERS_MSG = 5;
    private static final int NOTIFY_FORCED_RESIZABLE_MSG = 6;
    private static final int NOTIFY_ACTIVITY_DISMISSING_DOCKED_STACK_MSG = 7;
    private static final int NOTIFY_TASK_ADDED_LISTENERS_MSG = 8;
    private static final int NOTIFY_TASK_REMOVED_LISTENERS_MSG = 9;
    private static final int NOTIFY_TASK_MOVED_TO_FRONT_LISTENERS_MSG = 10;
    private static final int NOTIFY_TASK_DESCRIPTION_CHANGED_LISTENERS_MSG = 11;
    private static final int NOTIFY_ACTIVITY_REQUESTED_ORIENTATION_CHANGED_LISTENERS = 12;
    private static final int NOTIFY_TASK_REMOVAL_STARTED_LISTENERS = 13;
    private static final int NOTIFY_TASK_PROFILE_LOCKED_LISTENERS_MSG = 14;
    private static final int NOTIFY_TASK_SNAPSHOT_CHANGED_LISTENERS_MSG = 15;
    private static final int NOTIFY_PINNED_STACK_ANIMATION_STARTED_LISTENERS_MSG = 16;
    private static final int NOTIFY_ACTIVITY_UNPINNED_LISTENERS_MSG = 17;
    private static final int NOTIFY_ACTIVITY_LAUNCH_ON_SECONDARY_DISPLAY_FAILED_MSG = 18;
    private static final int NOTIFY_TASK_STACK_CHANGE_LISTENERS_DELAY = 100;
    private final ActivityManagerService mService;
    private final ActivityStackSupervisor mStackSupervisor;
    private final Handler mHandler;
    private final RemoteCallbackList<ITaskStackListener> mRemoteTaskStackListeners = new RemoteCallbackList();
    private final ArrayList<ITaskStackListener> mLocalTaskStackListeners = new ArrayList();
    private final TaskStackConsumer mNotifyTaskStackChanged = (l, m) -> l.onTaskStackChanged();
    private final TaskStackConsumer mNotifyTaskCreated = (l, m) -> l.onTaskCreated(m.arg1, (ComponentName)m.obj);
    private final TaskStackConsumer mNotifyTaskRemoved = (l, m) -> l.onTaskRemoved(m.arg1);
    private final TaskStackConsumer mNotifyTaskMovedToFront = (l, m) -> l.onTaskMovedToFront(m.arg1);
    private final TaskStackConsumer mNotifyTaskDescriptionChanged = (l, m) -> l.onTaskDescriptionChanged(m.arg1, (ActivityManager.TaskDescription)m.obj);
    private final TaskStackConsumer mNotifyActivityRequestedOrientationChanged = (l, m) -> l.onActivityRequestedOrientationChanged(m.arg1, m.arg2);
    private final TaskStackConsumer mNotifyTaskRemovalStarted = (l, m) -> l.onTaskRemovalStarted(m.arg1);
    private final TaskStackConsumer mNotifyActivityPinned = (l, m) -> l.onActivityPinned((String)m.obj, m.arg1, m.arg2);
    private final TaskStackConsumer mNotifyActivityUnpinned = (l, m) -> l.onActivityUnpinned();
    private final TaskStackConsumer mNotifyPinnedActivityRestartAttempt = (l, m) -> l.onPinnedActivityRestartAttempt(m.arg1 != 0);
    private final TaskStackConsumer mNotifyPinnedStackAnimationStarted = (l, m) -> l.onPinnedStackAnimationStarted();
    private final TaskStackConsumer mNotifyPinnedStackAnimationEnded = (l, m) -> l.onPinnedStackAnimationEnded();
    private final TaskStackConsumer mNotifyActivityForcedResizable = (l, m) -> l.onActivityForcedResizable((String)m.obj, m.arg1, m.arg2);
    private final TaskStackConsumer mNotifyActivityDismissingDockedStack = (l, m) -> l.onActivityDismissingDockedStack();
    private final TaskStackConsumer mNotifyActivityLaunchOnSecondaryDisplayFailed = (l, m) -> l.onActivityLaunchOnSecondaryDisplayFailed();
    private final TaskStackConsumer mNotifyTaskProfileLocked = (l, m) -> l.onTaskProfileLocked(m.arg1, m.arg2);
    private final TaskStackConsumer mNotifyTaskSnapshotChanged = (l, m) -> l.onTaskSnapshotChanged(m.arg1, (ActivityManager.TaskSnapshot)m.obj);

    public TaskChangeNotificationController(ActivityManagerService service, ActivityStackSupervisor stackSupervisor, Handler handler) {
        this.mService = service;
        this.mStackSupervisor = stackSupervisor;
        this.mHandler = new MainHandler(handler.getLooper());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerTaskStackListener(ITaskStackListener listener) {
        ActivityManagerService activityManagerService = this.mService;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                if (listener != null) {
                    if (Binder.getCallingPid() == Process.myPid()) {
                        if (!this.mLocalTaskStackListeners.contains(listener)) {
                            this.mLocalTaskStackListeners.add(listener);
                        }
                    } else {
                        this.mRemoteTaskStackListeners.register(listener);
                    }
                }
                // MONITOREXIT @DISABLED, blocks:[0, 1] lbl14 : MonitorExitStatement: MONITOREXIT : var2_2
                ActivityManagerService.resetPriorityAfterLockedSection();
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl18 : MonitorExitStatement: MONITOREXIT : var2_2
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterTaskStackListener(ITaskStackListener listener) {
        ActivityManagerService activityManagerService = this.mService;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                if (listener != null) {
                    if (Binder.getCallingPid() == Process.myPid()) {
                        this.mLocalTaskStackListeners.remove(listener);
                    } else {
                        this.mRemoteTaskStackListeners.unregister(listener);
                    }
                }
                // MONITOREXIT @DISABLED, blocks:[0, 1] lbl12 : MonitorExitStatement: MONITOREXIT : var2_2
                ActivityManagerService.resetPriorityAfterLockedSection();
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl16 : MonitorExitStatement: MONITOREXIT : var2_2
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forAllRemoteListeners(TaskStackConsumer callback, Message message) {
        ActivityManagerService activityManagerService = this.mService;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                for (int i = this.mRemoteTaskStackListeners.beginBroadcast() - 1; i >= 0; --i) {
                    try {
                        callback.accept(this.mRemoteTaskStackListeners.getBroadcastItem(i), message);
                        continue;
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
                this.mRemoteTaskStackListeners.finishBroadcast();
                // MONITOREXIT @DISABLED, blocks:[0, 2] lbl13 : MonitorExitStatement: MONITOREXIT : var3_3
                ActivityManagerService.resetPriorityAfterLockedSection();
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[2, 4] lbl17 : MonitorExitStatement: MONITOREXIT : var3_3
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forAllLocalListeners(TaskStackConsumer callback, Message message) {
        ActivityManagerService activityManagerService = this.mService;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                for (int i = this.mLocalTaskStackListeners.size() - 1; i >= 0; --i) {
                    try {
                        callback.accept(this.mLocalTaskStackListeners.get(i), message);
                        continue;
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
                // MONITOREXIT @DISABLED, blocks:[0, 2] lbl12 : MonitorExitStatement: MONITOREXIT : var3_3
                ActivityManagerService.resetPriorityAfterLockedSection();
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[2, 4] lbl16 : MonitorExitStatement: MONITOREXIT : var3_3
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
    }

    void notifyTaskStackChanged() {
        this.mHandler.sendEmptyMessage(1);
        this.mHandler.removeMessages(2);
        Message msg = this.mHandler.obtainMessage(2);
        this.forAllLocalListeners(this.mNotifyTaskStackChanged, msg);
        this.mHandler.sendMessageDelayed(msg, 100L);
    }

    void notifyActivityPinned(String packageName, int userId, int taskId) {
        this.mHandler.removeMessages(3);
        Message msg = this.mHandler.obtainMessage(3, userId, taskId, packageName);
        this.forAllLocalListeners(this.mNotifyActivityPinned, msg);
        msg.sendToTarget();
    }

    void notifyActivityUnpinned() {
        this.mHandler.removeMessages(17);
        Message msg = this.mHandler.obtainMessage(17);
        this.forAllLocalListeners(this.mNotifyActivityUnpinned, msg);
        msg.sendToTarget();
    }

    void notifyPinnedActivityRestartAttempt(boolean clearedTask) {
        this.mHandler.removeMessages(4);
        Message msg = this.mHandler.obtainMessage(4, clearedTask ? 1 : 0, 0);
        this.forAllLocalListeners(this.mNotifyPinnedActivityRestartAttempt, msg);
        msg.sendToTarget();
    }

    void notifyPinnedStackAnimationStarted() {
        this.mHandler.removeMessages(16);
        Message msg = this.mHandler.obtainMessage(16);
        this.forAllLocalListeners(this.mNotifyPinnedStackAnimationStarted, msg);
        msg.sendToTarget();
    }

    void notifyPinnedStackAnimationEnded() {
        this.mHandler.removeMessages(5);
        Message msg = this.mHandler.obtainMessage(5);
        this.forAllLocalListeners(this.mNotifyPinnedStackAnimationEnded, msg);
        msg.sendToTarget();
    }

    void notifyActivityDismissingDockedStack() {
        this.mHandler.removeMessages(7);
        Message msg = this.mHandler.obtainMessage(7);
        this.forAllLocalListeners(this.mNotifyActivityDismissingDockedStack, msg);
        msg.sendToTarget();
    }

    void notifyActivityForcedResizable(int taskId, int reason, String packageName) {
        this.mHandler.removeMessages(6);
        Message msg = this.mHandler.obtainMessage(6, taskId, reason, packageName);
        this.forAllLocalListeners(this.mNotifyActivityForcedResizable, msg);
        msg.sendToTarget();
    }

    void notifyActivityLaunchOnSecondaryDisplayFailed() {
        this.mHandler.removeMessages(18);
        Message msg = this.mHandler.obtainMessage(18);
        this.forAllLocalListeners(this.mNotifyActivityLaunchOnSecondaryDisplayFailed, msg);
        msg.sendToTarget();
    }

    void notifyTaskCreated(int taskId, ComponentName componentName) {
        Message msg = this.mHandler.obtainMessage(8, taskId, 0, componentName);
        this.forAllLocalListeners(this.mNotifyTaskCreated, msg);
        msg.sendToTarget();
    }

    void notifyTaskRemoved(int taskId) {
        Message msg = this.mHandler.obtainMessage(9, taskId, 0);
        this.forAllLocalListeners(this.mNotifyTaskRemoved, msg);
        msg.sendToTarget();
    }

    void notifyTaskMovedToFront(int taskId) {
        Message msg = this.mHandler.obtainMessage(10, taskId, 0);
        this.forAllLocalListeners(this.mNotifyTaskMovedToFront, msg);
        msg.sendToTarget();
    }

    void notifyTaskDescriptionChanged(int taskId, ActivityManager.TaskDescription taskDescription) {
        Message msg = this.mHandler.obtainMessage(11, taskId, 0, taskDescription);
        this.forAllLocalListeners(this.mNotifyTaskDescriptionChanged, msg);
        msg.sendToTarget();
    }

    void notifyActivityRequestedOrientationChanged(int taskId, int orientation) {
        Message msg = this.mHandler.obtainMessage(12, taskId, orientation);
        this.forAllLocalListeners(this.mNotifyActivityRequestedOrientationChanged, msg);
        msg.sendToTarget();
    }

    void notifyTaskRemovalStarted(int taskId) {
        Message msg = this.mHandler.obtainMessage(13, taskId, 0);
        this.forAllLocalListeners(this.mNotifyTaskRemovalStarted, msg);
        msg.sendToTarget();
    }

    void notifyTaskProfileLocked(int taskId, int userId) {
        Message msg = this.mHandler.obtainMessage(14, taskId, userId);
        this.forAllLocalListeners(this.mNotifyTaskProfileLocked, msg);
        msg.sendToTarget();
    }

    void notifyTaskSnapshotChanged(int taskId, ActivityManager.TaskSnapshot snapshot) {
        Message msg = this.mHandler.obtainMessage(15, taskId, 0, snapshot);
        this.forAllLocalListeners(this.mNotifyTaskSnapshotChanged, msg);
        msg.sendToTarget();
    }

    private class MainHandler
    extends Handler {
        public MainHandler(Looper looper) {
            super(looper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    ActivityManagerService activityManagerService = TaskChangeNotificationController.this.mService;
                    synchronized (activityManagerService) {
                        try {
                            ActivityManagerService.boostPriorityForLockedSection();
                            TaskChangeNotificationController.this.mStackSupervisor.logStackState();
                            // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 3] lbl8 : MonitorExitStatement: MONITOREXIT : var2_2
                            ActivityManagerService.resetPriorityAfterLockedSection();
                            break;
                        }
                        catch (Throwable throwable) {
                            // MONITOREXIT @DISABLED, blocks:[1, 2, 3, 22] lbl12 : MonitorExitStatement: MONITOREXIT : var2_2
                            ActivityManagerService.resetPriorityAfterLockedSection();
                            throw throwable;
                        }
                    }
                }
                case 2: {
                    TaskChangeNotificationController.this.forAllRemoteListeners(TaskChangeNotificationController.this.mNotifyTaskStackChanged, msg);
                    break;
                }
                case 8: {
                    TaskChangeNotificationController.this.forAllRemoteListeners(TaskChangeNotificationController.this.mNotifyTaskCreated, msg);
                    break;
                }
                case 9: {
                    TaskChangeNotificationController.this.forAllRemoteListeners(TaskChangeNotificationController.this.mNotifyTaskRemoved, msg);
                    break;
                }
                case 10: {
                    TaskChangeNotificationController.this.forAllRemoteListeners(TaskChangeNotificationController.this.mNotifyTaskMovedToFront, msg);
                    break;
                }
                case 11: {
                    TaskChangeNotificationController.this.forAllRemoteListeners(TaskChangeNotificationController.this.mNotifyTaskDescriptionChanged, msg);
                    break;
                }
                case 12: {
                    TaskChangeNotificationController.this.forAllRemoteListeners(TaskChangeNotificationController.this.mNotifyActivityRequestedOrientationChanged, msg);
                    break;
                }
                case 13: {
                    TaskChangeNotificationController.this.forAllRemoteListeners(TaskChangeNotificationController.this.mNotifyTaskRemovalStarted, msg);
                    break;
                }
                case 3: {
                    TaskChangeNotificationController.this.forAllRemoteListeners(TaskChangeNotificationController.this.mNotifyActivityPinned, msg);
                    break;
                }
                case 17: {
                    TaskChangeNotificationController.this.forAllRemoteListeners(TaskChangeNotificationController.this.mNotifyActivityUnpinned, msg);
                    break;
                }
                case 4: {
                    TaskChangeNotificationController.this.forAllRemoteListeners(TaskChangeNotificationController.this.mNotifyPinnedActivityRestartAttempt, msg);
                    break;
                }
                case 16: {
                    TaskChangeNotificationController.this.forAllRemoteListeners(TaskChangeNotificationController.this.mNotifyPinnedStackAnimationStarted, msg);
                    break;
                }
                case 5: {
                    TaskChangeNotificationController.this.forAllRemoteListeners(TaskChangeNotificationController.this.mNotifyPinnedStackAnimationEnded, msg);
                    break;
                }
                case 6: {
                    TaskChangeNotificationController.this.forAllRemoteListeners(TaskChangeNotificationController.this.mNotifyActivityForcedResizable, msg);
                    break;
                }
                case 7: {
                    TaskChangeNotificationController.this.forAllRemoteListeners(TaskChangeNotificationController.this.mNotifyActivityDismissingDockedStack, msg);
                    break;
                }
                case 18: {
                    TaskChangeNotificationController.this.forAllRemoteListeners(TaskChangeNotificationController.this.mNotifyActivityLaunchOnSecondaryDisplayFailed, msg);
                    break;
                }
                case 14: {
                    TaskChangeNotificationController.this.forAllRemoteListeners(TaskChangeNotificationController.this.mNotifyTaskProfileLocked, msg);
                    break;
                }
                case 15: {
                    TaskChangeNotificationController.this.forAllRemoteListeners(TaskChangeNotificationController.this.mNotifyTaskSnapshotChanged, msg);
                }
            }
        }
    }

    @FunctionalInterface
    public static interface TaskStackConsumer {
        public void accept(ITaskStackListener var1, Message var2) throws RemoteException;
    }
}

