/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.content.Context;
import android.content.res.Resources;
import android.os.Handler;
import android.os.Message;
import com.android.server.am.ActivityManagerService;
import com.android.server.am.AppErrorResult;
import com.android.server.am.BaseErrorDialog;
import com.android.server.am.ProcessRecord;

final class StrictModeViolationDialog
extends BaseErrorDialog {
    private static final String TAG = "StrictModeViolationDialog";
    private final ActivityManagerService mService;
    private final AppErrorResult mResult;
    private final ProcessRecord mProc;
    static final int ACTION_OK = 0;
    static final int ACTION_OK_AND_REPORT = 1;
    static final long DISMISS_TIMEOUT = 60000L;
    private final Handler mHandler = new Handler(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            ActivityManagerService activityManagerService = StrictModeViolationDialog.this.mService;
            synchronized (activityManagerService) {
                try {
                    ActivityManagerService.boostPriorityForLockedSection();
                    if (StrictModeViolationDialog.this.mProc != null && ((StrictModeViolationDialog)StrictModeViolationDialog.this).mProc.crashDialog == StrictModeViolationDialog.this) {
                        ((StrictModeViolationDialog)StrictModeViolationDialog.this).mProc.crashDialog = null;
                    }
                    // MONITOREXIT @DISABLED, blocks:[0, 1] lbl7 : MonitorExitStatement: MONITOREXIT : var2_2
                    ActivityManagerService.resetPriorityAfterLockedSection();
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[1, 2] lbl11 : MonitorExitStatement: MONITOREXIT : var2_2
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            StrictModeViolationDialog.this.mResult.set(msg.what);
            StrictModeViolationDialog.this.dismiss();
        }
    };

    public StrictModeViolationDialog(Context context, ActivityManagerService service, AppErrorResult result, ProcessRecord app) {
        super(context);
        CharSequence name;
        Resources res = context.getResources();
        this.mService = service;
        this.mProc = app;
        this.mResult = result;
        if (app.pkgList.size() == 1 && (name = context.getPackageManager().getApplicationLabel(app.info)) != null) {
            this.setMessage(res.getString(17040799, name.toString(), app.info.processName));
        } else {
            name = app.processName;
            this.setMessage(res.getString(17040800, name.toString()));
        }
        this.setCancelable(false);
        this.setButton(-1, res.getText(17039773), this.mHandler.obtainMessage(0));
        if (app.errorReportReceiver != null) {
            this.setButton(-2, res.getText(17040676), this.mHandler.obtainMessage(1));
        }
        this.getWindow().addPrivateFlags(256);
        this.getWindow().setTitle("Strict Mode Violation: " + app.info.processName);
        this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(0), 60000L);
    }
}

