/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.app.ActivityManager;
import android.content.Context;
import android.metrics.LogMaker;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import android.util.Slog;
import android.util.SparseArray;
import android.util.SparseIntArray;
import com.android.internal.logging.MetricsLogger;
import com.android.internal.os.SomeArgs;
import com.android.server.am.ActivityManagerService;
import com.android.server.am.ActivityRecord;
import com.android.server.am.ActivityStack;
import com.android.server.am.ActivityStackSupervisor;
import com.android.server.am.ProcessRecord;
import com.android.server.am.TaskRecord;
import java.util.ArrayList;

class ActivityMetricsLogger {
    private static final String TAG = "ActivityManager";
    private static final int WINDOW_STATE_STANDARD = 0;
    private static final int WINDOW_STATE_SIDE_BY_SIDE = 1;
    private static final int WINDOW_STATE_FREEFORM = 2;
    private static final int WINDOW_STATE_ASSISTANT = 3;
    private static final int WINDOW_STATE_INVALID = -1;
    private static final long INVALID_START_TIME = -1L;
    private static final int MSG_CHECK_VISIBILITY = 0;
    private static final String[] TRON_WINDOW_STATE_VARZ_STRINGS = new String[]{"window_time_0", "window_time_1", "window_time_2", "window_time_3"};
    private int mWindowState = 0;
    private long mLastLogTimeSecs;
    private final ActivityStackSupervisor mSupervisor;
    private final Context mContext;
    private final MetricsLogger mMetricsLogger = new MetricsLogger();
    private long mCurrentTransitionStartTime = -1L;
    private long mLastTransitionStartTime = -1L;
    private int mCurrentTransitionDeviceUptime;
    private int mCurrentTransitionDelayMs;
    private boolean mLoggedTransitionStarting;
    private final SparseArray<StackTransitionInfo> mStackTransitionInfo = new SparseArray();
    private final SparseArray<StackTransitionInfo> mLastStackTransitionInfo = new SparseArray();
    private final H mHandler;

    ActivityMetricsLogger(ActivityStackSupervisor supervisor, Context context, Looper looper) {
        this.mLastLogTimeSecs = SystemClock.elapsedRealtime() / 1000L;
        this.mSupervisor = supervisor;
        this.mContext = context;
        this.mHandler = new H(looper);
    }

    void logWindowState() {
        long now = SystemClock.elapsedRealtime() / 1000L;
        if (this.mWindowState != -1) {
            MetricsLogger.count(this.mContext, TRON_WINDOW_STATE_VARZ_STRINGS[this.mWindowState], (int)(now - this.mLastLogTimeSecs));
        }
        this.mLastLogTimeSecs = now;
        Object stack = this.mSupervisor.getStack(3);
        if (stack != null && ((ActivityStack)stack).shouldBeVisible(null) != 0) {
            this.mWindowState = 1;
            return;
        }
        this.mWindowState = -1;
        stack = this.mSupervisor.getFocusedStack();
        if (((ActivityStack)stack).mStackId == 4) {
            stack = this.mSupervisor.findStackBehind((ActivityStack)stack);
        }
        if (ActivityManager.StackId.isHomeOrRecentsStack(((ActivityStack)stack).mStackId) || ((ActivityStack)stack).mStackId == 1) {
            this.mWindowState = 0;
        } else if (((ActivityStack)stack).mStackId == 3) {
            Slog.wtf(TAG, "Docked stack shouldn't be the focused stack, because it reported not being visible.");
            this.mWindowState = -1;
        } else if (((ActivityStack)stack).mStackId == 2) {
            this.mWindowState = 2;
        } else if (((ActivityStack)stack).mStackId == 6) {
            this.mWindowState = 3;
        } else if (ActivityManager.StackId.isStaticStack(((ActivityStack)stack).mStackId)) {
            throw new IllegalStateException("Unknown stack=" + stack);
        }
    }

    void notifyActivityLaunching() {
        if (!this.isAnyTransitionActive()) {
            this.mLastTransitionStartTime = this.mCurrentTransitionStartTime = SystemClock.uptimeMillis();
        }
    }

    void notifyActivityLaunched(int resultCode, ActivityRecord launchedActivity) {
        ProcessRecord processRecord = launchedActivity != null ? this.mSupervisor.mService.mProcessNames.get(launchedActivity.processName, launchedActivity.appInfo.uid) : null;
        boolean processRunning = processRecord != null;
        boolean processSwitch = processRecord == null || !this.hasStartedActivity(processRecord, launchedActivity);
        this.notifyActivityLaunched(resultCode, launchedActivity, processRunning, processSwitch);
    }

    private boolean hasStartedActivity(ProcessRecord record, ActivityRecord launchedActivity) {
        ArrayList<ActivityRecord> activities = record.activities;
        for (int i = activities.size() - 1; i >= 0; --i) {
            ActivityRecord activity = activities.get(i);
            if (launchedActivity == activity || activity.stopped) continue;
            return true;
        }
        return false;
    }

    private void notifyActivityLaunched(int resultCode, ActivityRecord launchedActivity, boolean processRunning, boolean processSwitch) {
        boolean otherStacksLaunching;
        int stackId;
        int n = stackId = launchedActivity != null && launchedActivity.getStack() != null ? ((ActivityStack)launchedActivity.getStack()).mStackId : -1;
        if (this.mCurrentTransitionStartTime == -1L) {
            return;
        }
        StackTransitionInfo info = this.mStackTransitionInfo.get(stackId);
        if (launchedActivity != null && info != null) {
            info.launchedActivity = launchedActivity;
            return;
        }
        boolean bl = otherStacksLaunching = this.mStackTransitionInfo.size() > 0 && info == null;
        if (!(resultCode >= 0 && launchedActivity != null && processSwitch && stackId != -1 || otherStacksLaunching)) {
            this.reset(true);
            return;
        }
        if (otherStacksLaunching) {
            return;
        }
        StackTransitionInfo newInfo = new StackTransitionInfo();
        newInfo.launchedActivity = launchedActivity;
        newInfo.currentTransitionProcessRunning = processRunning;
        newInfo.startResult = resultCode;
        this.mStackTransitionInfo.put(stackId, newInfo);
        this.mLastStackTransitionInfo.put(stackId, newInfo);
        this.mCurrentTransitionDeviceUptime = (int)(SystemClock.uptimeMillis() / 1000L);
    }

    void notifyWindowsDrawn(int stackId, long timestamp) {
        StackTransitionInfo info = this.mStackTransitionInfo.get(stackId);
        if (info == null || info.loggedWindowsDrawn) {
            return;
        }
        info.windowsDrawnDelayMs = this.calculateDelay(timestamp);
        info.loggedWindowsDrawn = true;
        if (this.allStacksWindowsDrawn() && this.mLoggedTransitionStarting) {
            this.reset(false);
        }
    }

    void notifyStartingWindowDrawn(int stackId, long timestamp) {
        StackTransitionInfo info = this.mStackTransitionInfo.get(stackId);
        if (info == null || info.loggedStartingWindowDrawn) {
            return;
        }
        info.loggedStartingWindowDrawn = true;
        info.startingWindowDelayMs = this.calculateDelay(timestamp);
    }

    void notifyTransitionStarting(SparseIntArray stackIdReasons, long timestamp) {
        if (!this.isAnyTransitionActive() || this.mLoggedTransitionStarting) {
            return;
        }
        this.mCurrentTransitionDelayMs = this.calculateDelay(timestamp);
        this.mLoggedTransitionStarting = true;
        for (int index = stackIdReasons.size() - 1; index >= 0; --index) {
            int stackId = stackIdReasons.keyAt(index);
            StackTransitionInfo info = this.mStackTransitionInfo.get(stackId);
            if (info == null) continue;
            info.reason = stackIdReasons.valueAt(index);
        }
        if (this.allStacksWindowsDrawn()) {
            this.reset(false);
        }
    }

    void notifyVisibilityChanged(ActivityRecord activityRecord) {
        StackTransitionInfo info = this.mStackTransitionInfo.get(activityRecord.getStackId());
        if (info == null) {
            return;
        }
        if (info.launchedActivity != activityRecord) {
            return;
        }
        TaskRecord t = activityRecord.getTask();
        SomeArgs args = SomeArgs.obtain();
        args.arg1 = t;
        args.arg2 = activityRecord;
        this.mHandler.obtainMessage(0, args).sendToTarget();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkVisibility(TaskRecord t, ActivityRecord r) {
        ActivityManagerService activityManagerService = this.mSupervisor.mService;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                StackTransitionInfo info = this.mStackTransitionInfo.get(r.getStackId());
                if (info != null && !t.isVisible()) {
                    this.logAppTransitionCancel(info);
                    this.mStackTransitionInfo.remove(r.getStackId());
                    if (this.mStackTransitionInfo.size() == 0) {
                        this.reset(true);
                    }
                }
                // MONITOREXIT @DISABLED, blocks:[0, 1] lbl11 : MonitorExitStatement: MONITOREXIT : var3_3
                ActivityManagerService.resetPriorityAfterLockedSection();
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl15 : MonitorExitStatement: MONITOREXIT : var3_3
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
    }

    void notifyBindApplication(ProcessRecord app) {
        for (int i = this.mStackTransitionInfo.size() - 1; i >= 0; --i) {
            StackTransitionInfo info = this.mStackTransitionInfo.valueAt(i);
            if (((StackTransitionInfo)info).launchedActivity.appInfo != app.info) continue;
            info.bindApplicationDelayMs = this.calculateCurrentDelay();
        }
    }

    private boolean allStacksWindowsDrawn() {
        for (int index = this.mStackTransitionInfo.size() - 1; index >= 0; --index) {
            if (this.mStackTransitionInfo.valueAt(index).loggedWindowsDrawn) continue;
            return false;
        }
        return true;
    }

    private boolean isAnyTransitionActive() {
        return this.mCurrentTransitionStartTime != -1L && this.mStackTransitionInfo.size() > 0;
    }

    private void reset(boolean abort) {
        if (!abort && this.isAnyTransitionActive()) {
            this.logAppTransitionMultiEvents();
        }
        this.mCurrentTransitionStartTime = -1L;
        this.mCurrentTransitionDelayMs = -1;
        this.mLoggedTransitionStarting = false;
        this.mStackTransitionInfo.clear();
    }

    private int calculateCurrentDelay() {
        return (int)(SystemClock.uptimeMillis() - this.mCurrentTransitionStartTime);
    }

    private int calculateDelay(long timestamp) {
        return (int)(timestamp - this.mCurrentTransitionStartTime);
    }

    private void logAppTransitionCancel(StackTransitionInfo info) {
        int type = this.getTransitionType(info);
        if (type == -1) {
            return;
        }
        LogMaker builder = new LogMaker(1144);
        builder.setPackageName(((StackTransitionInfo)info).launchedActivity.packageName);
        builder.setType(type);
        builder.addTaggedData(871, ((StackTransitionInfo)info).launchedActivity.info.name);
        this.mMetricsLogger.write(builder);
    }

    private void logAppTransitionMultiEvents() {
        for (int index = this.mStackTransitionInfo.size() - 1; index >= 0; --index) {
            StackTransitionInfo info = this.mStackTransitionInfo.valueAt(index);
            int type = this.getTransitionType(info);
            if (type == -1) {
                return;
            }
            LogMaker builder = new LogMaker(761);
            builder.setPackageName(((StackTransitionInfo)info).launchedActivity.packageName);
            builder.setType(type);
            builder.addTaggedData(871, ((StackTransitionInfo)info).launchedActivity.info.name);
            boolean isInstantApp = ((StackTransitionInfo)info).launchedActivity.info.applicationInfo.isInstantApp();
            if (((StackTransitionInfo)info).launchedActivity.launchedFromPackage != null) {
                builder.addTaggedData(904, ((StackTransitionInfo)info).launchedActivity.launchedFromPackage);
            }
            if (((StackTransitionInfo)info).launchedActivity.info.launchToken != null) {
                builder.addTaggedData(903, ((StackTransitionInfo)info).launchedActivity.info.launchToken);
                ((StackTransitionInfo)info).launchedActivity.info.launchToken = null;
            }
            builder.addTaggedData(905, isInstantApp ? 1 : 0);
            builder.addTaggedData(325, this.mCurrentTransitionDeviceUptime);
            builder.addTaggedData(319, this.mCurrentTransitionDelayMs);
            builder.setSubtype(info.reason);
            if (info.startingWindowDelayMs != -1) {
                builder.addTaggedData(321, info.startingWindowDelayMs);
            }
            if (info.bindApplicationDelayMs != -1) {
                builder.addTaggedData(945, info.bindApplicationDelayMs);
            }
            builder.addTaggedData(322, info.windowsDrawnDelayMs);
            this.mMetricsLogger.write(builder);
        }
    }

    void logAppTransitionReportedDrawn(ActivityRecord r, boolean restoredFromBundle) {
        StackTransitionInfo info = this.mLastStackTransitionInfo.get(r.getStackId());
        if (info == null) {
            return;
        }
        LogMaker builder = new LogMaker(1090);
        builder.setPackageName(r.packageName);
        builder.addTaggedData(871, r.info.name);
        builder.addTaggedData(1091, SystemClock.uptimeMillis() - this.mLastTransitionStartTime);
        builder.setType(restoredFromBundle ? 13 : 12);
        builder.addTaggedData(324, info.currentTransitionProcessRunning ? 1 : 0);
        this.mMetricsLogger.write(builder);
    }

    private int getTransitionType(StackTransitionInfo info) {
        if (info.currentTransitionProcessRunning) {
            if (info.startResult == 0) {
                return 8;
            }
            if (info.startResult == 2) {
                return 9;
            }
        } else if (info.startResult == 0) {
            return 7;
        }
        return -1;
    }

    private final class StackTransitionInfo {
        private ActivityRecord launchedActivity;
        private int startResult;
        private boolean currentTransitionProcessRunning;
        private int windowsDrawnDelayMs;
        private int startingWindowDelayMs = -1;
        private int bindApplicationDelayMs = -1;
        private int reason = 3;
        private boolean loggedWindowsDrawn;
        private boolean loggedStartingWindowDrawn;

        private StackTransitionInfo() {
        }
    }

    private final class H
    extends Handler {
        public H(Looper looper) {
            super(looper);
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 0: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    ActivityMetricsLogger.this.checkVisibility((TaskRecord)args.arg1, (ActivityRecord)args.arg2);
                }
            }
        }
    }
}

