/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.app.ActivityManager;
import android.app.AppOpsManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.LinkProperties;
import android.net.NetworkCapabilities;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.RemoteException;
import android.os.UserHandle;
import android.telephony.CellInfo;
import android.telephony.CellLocation;
import android.telephony.PreciseCallState;
import android.telephony.PreciseDataConnectionState;
import android.telephony.Rlog;
import android.telephony.ServiceState;
import android.telephony.SignalStrength;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import android.telephony.VoLteServiceState;
import android.text.TextUtils;
import android.util.LocalLog;
import com.android.internal.app.IBatteryStats;
import com.android.internal.telephony.IOnSubscriptionsChangedListener;
import com.android.internal.telephony.IPhoneStateListener;
import com.android.internal.telephony.ITelephonyRegistry;
import com.android.internal.telephony.PhoneConstantConversions;
import com.android.internal.util.DumpUtils;
import com.android.internal.util.IndentingPrintWriter;
import com.android.server.am.BatteryStatsService;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class TelephonyRegistry
extends ITelephonyRegistry.Stub {
    private static final String TAG = "TelephonyRegistry";
    private static final boolean DBG = false;
    private static final boolean DBG_LOC = false;
    private static final boolean VDBG = false;
    private final Context mContext;
    private final ArrayList<IBinder> mRemoveList = new ArrayList();
    private final ArrayList<Record> mRecords = new ArrayList();
    private final IBatteryStats mBatteryStats;
    private final AppOpsManager mAppOps;
    private boolean hasNotifySubscriptionInfoChangedOccurred = false;
    private int mNumPhones;
    private int[] mCallState;
    private String[] mCallIncomingNumber;
    private ServiceState[] mServiceState;
    private int[] mVoiceActivationState;
    private int[] mDataActivationState;
    private SignalStrength[] mSignalStrength;
    private boolean[] mMessageWaiting;
    private boolean[] mCallForwarding;
    private int[] mDataActivity;
    private int[] mDataConnectionState;
    private ArrayList<String>[] mConnectedApns;
    private LinkProperties[] mDataConnectionLinkProperties;
    private NetworkCapabilities[] mDataConnectionNetworkCapabilities;
    private Bundle[] mCellLocation;
    private int[] mDataConnectionNetworkType;
    private int mOtaspMode = 1;
    private ArrayList<List<CellInfo>> mCellInfo = null;
    private VoLteServiceState mVoLteServiceState = new VoLteServiceState();
    private int mDefaultSubId = -1;
    private int mDefaultPhoneId = -1;
    private int mRingingCallState = 0;
    private int mForegroundCallState = 0;
    private int mBackgroundCallState = 0;
    private PreciseCallState mPreciseCallState = new PreciseCallState();
    private boolean mCarrierNetworkChangeState = false;
    private final LocalLog mLocalLog = new LocalLog(100);
    private PreciseDataConnectionState mPreciseDataConnectionState = new PreciseDataConnectionState();
    static final int ENFORCE_PHONE_STATE_PERMISSION_MASK = 16396;
    static final int CHECK_PHONE_STATE_PERMISSION_MASK = 224;
    static final int PRECISE_PHONE_STATE_PERMISSION_MASK = 6144;
    private static final int MSG_USER_SWITCHED = 1;
    private static final int MSG_UPDATE_DEFAULT_SUB = 2;
    private final Handler mHandler = new Handler(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    int numPhones = TelephonyManager.getDefault().getPhoneCount();
                    for (int sub = 0; sub < numPhones; ++sub) {
                        TelephonyRegistry.this.notifyCellLocationForSubscriber(sub, TelephonyRegistry.this.mCellLocation[sub]);
                    }
                    break;
                }
                case 2: {
                    int newDefaultPhoneId = msg.arg1;
                    int newDefaultSubId = (Integer)msg.obj;
                    ArrayList arrayList = TelephonyRegistry.this.mRecords;
                    synchronized (arrayList) {
                        for (Record r : TelephonyRegistry.this.mRecords) {
                            if (r.subId != Integer.MAX_VALUE) continue;
                            TelephonyRegistry.this.checkPossibleMissNotify(r, newDefaultPhoneId);
                        }
                        TelephonyRegistry.this.handleRemoveListLocked();
                    }
                    TelephonyRegistry.this.mDefaultSubId = newDefaultSubId;
                    TelephonyRegistry.this.mDefaultPhoneId = newDefaultPhoneId;
                }
            }
        }
    };
    private final BroadcastReceiver mBroadcastReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if ("android.intent.action.USER_SWITCHED".equals(action)) {
                int userHandle = intent.getIntExtra("android.intent.extra.user_handle", 0);
                TelephonyRegistry.this.mHandler.sendMessage(TelephonyRegistry.this.mHandler.obtainMessage(1, userHandle, 0));
            } else if (action.equals("android.telephony.action.DEFAULT_SUBSCRIPTION_CHANGED")) {
                Integer newDefaultSubIdObj = new Integer(intent.getIntExtra("subscription", SubscriptionManager.getDefaultSubscriptionId()));
                int newDefaultPhoneId = intent.getIntExtra("slot", SubscriptionManager.getPhoneId(TelephonyRegistry.this.mDefaultSubId));
                if (TelephonyRegistry.this.validatePhoneId(newDefaultPhoneId) && (!newDefaultSubIdObj.equals(TelephonyRegistry.this.mDefaultSubId) || newDefaultPhoneId != TelephonyRegistry.this.mDefaultPhoneId)) {
                    TelephonyRegistry.this.mHandler.sendMessage(TelephonyRegistry.this.mHandler.obtainMessage(2, newDefaultPhoneId, 0, newDefaultSubIdObj));
                }
            }
        }
    };

    TelephonyRegistry(Context context) {
        int i;
        int numPhones;
        CellLocation location = CellLocation.getEmpty();
        this.mContext = context;
        this.mBatteryStats = BatteryStatsService.getService();
        this.mNumPhones = numPhones = TelephonyManager.getDefault().getPhoneCount();
        this.mConnectedApns = new ArrayList[numPhones];
        this.mCallState = new int[numPhones];
        this.mDataActivity = new int[numPhones];
        this.mDataConnectionState = new int[numPhones];
        this.mDataConnectionNetworkType = new int[numPhones];
        this.mCallIncomingNumber = new String[numPhones];
        this.mServiceState = new ServiceState[numPhones];
        this.mVoiceActivationState = new int[numPhones];
        this.mDataActivationState = new int[numPhones];
        this.mSignalStrength = new SignalStrength[numPhones];
        this.mMessageWaiting = new boolean[numPhones];
        this.mCallForwarding = new boolean[numPhones];
        this.mCellLocation = new Bundle[numPhones];
        this.mDataConnectionLinkProperties = new LinkProperties[numPhones];
        this.mDataConnectionNetworkCapabilities = new NetworkCapabilities[numPhones];
        this.mCellInfo = new ArrayList();
        for (i = 0; i < numPhones; ++i) {
            this.mCallState[i] = 0;
            this.mDataActivity[i] = 0;
            this.mDataConnectionState[i] = -1;
            this.mVoiceActivationState[i] = 0;
            this.mDataActivationState[i] = 0;
            this.mCallIncomingNumber[i] = "";
            this.mServiceState[i] = new ServiceState();
            this.mSignalStrength[i] = new SignalStrength();
            this.mMessageWaiting[i] = false;
            this.mCallForwarding[i] = false;
            this.mCellLocation[i] = new Bundle();
            this.mCellInfo.add(i, null);
            this.mConnectedApns[i] = new ArrayList();
        }
        if (location != null) {
            for (i = 0; i < numPhones; ++i) {
                location.fillInNotifierBundle(this.mCellLocation[i]);
            }
        }
        this.mAppOps = this.mContext.getSystemService(AppOpsManager.class);
    }

    public void systemRunning() {
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.USER_SWITCHED");
        filter.addAction("android.intent.action.USER_REMOVED");
        filter.addAction("android.telephony.action.DEFAULT_SUBSCRIPTION_CHANGED");
        TelephonyRegistry.log("systemRunning register for intents");
        this.mContext.registerReceiver(this.mBroadcastReceiver, filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addOnSubscriptionsChangedListener(String callingPackage, IOnSubscriptionsChangedListener callback) {
        int callerUserId;
        block11: {
            callerUserId = UserHandle.getCallingUserId();
            try {
                this.mContext.enforceCallingOrSelfPermission("android.permission.READ_PRIVILEGED_PHONE_STATE", "addOnSubscriptionsChangedListener");
            }
            catch (SecurityException e) {
                this.mContext.enforceCallingOrSelfPermission("android.permission.READ_PHONE_STATE", "addOnSubscriptionsChangedListener");
                if (this.mAppOps.noteOp(51, Binder.getCallingUid(), callingPackage) == 0) break block11;
                return;
            }
        }
        ArrayList<Record> arrayList = this.mRecords;
        synchronized (arrayList) {
            Record r;
            block12: {
                IBinder b = callback.asBinder();
                int N = this.mRecords.size();
                for (int i = 0; i < N; ++i) {
                    r = this.mRecords.get(i);
                    if (b != r.binder) {
                        continue;
                    }
                    break block12;
                }
                r = new Record();
                r.binder = b;
                this.mRecords.add(r);
            }
            r.onSubscriptionsChangedListenerCallback = callback;
            r.callingPackage = callingPackage;
            r.callerUserId = callerUserId;
            r.events = 0;
            r.canReadPhoneState = true;
            if (this.hasNotifySubscriptionInfoChangedOccurred) {
                try {
                    r.onSubscriptionsChangedListenerCallback.onSubscriptionsChanged();
                }
                catch (RemoteException e) {
                    this.remove(r.binder);
                }
            } else {
                TelephonyRegistry.log("listen oscl: hasNotifySubscriptionInfoChangedOccurred==false no callback");
            }
        }
    }

    @Override
    public void removeOnSubscriptionsChangedListener(String pkgForDebug, IOnSubscriptionsChangedListener callback) {
        this.remove(callback.asBinder());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifySubscriptionInfoChanged() {
        ArrayList<Record> arrayList = this.mRecords;
        synchronized (arrayList) {
            if (!this.hasNotifySubscriptionInfoChangedOccurred) {
                TelephonyRegistry.log("notifySubscriptionInfoChanged: first invocation mRecords.size=" + this.mRecords.size());
            }
            this.hasNotifySubscriptionInfoChangedOccurred = true;
            this.mRemoveList.clear();
            for (Record r : this.mRecords) {
                if (!r.matchOnSubscriptionsChangedListener()) continue;
                try {
                    r.onSubscriptionsChangedListenerCallback.onSubscriptionsChanged();
                }
                catch (RemoteException ex) {
                    this.mRemoveList.add(r.binder);
                }
            }
            this.handleRemoveListLocked();
        }
    }

    @Override
    public void listen(String pkgForDebug, IPhoneStateListener callback, int events, boolean notifyNow) {
        this.listenForSubscriber(Integer.MAX_VALUE, pkgForDebug, callback, events, notifyNow);
    }

    @Override
    public void listenForSubscriber(int subId, String pkgForDebug, IPhoneStateListener callback, int events, boolean notifyNow) {
        this.listen(pkgForDebug, callback, events, notifyNow, subId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void listen(String callingPackage, IPhoneStateListener callback, int events, boolean notifyNow, int subId) {
        int callerUserId = UserHandle.getCallingUserId();
        if (events != 0) {
            block58: {
                this.checkListenerPermission(events);
                if ((events & 0x400C) != 0) {
                    try {
                        this.mContext.enforceCallingOrSelfPermission("android.permission.READ_PRIVILEGED_PHONE_STATE", null);
                    }
                    catch (SecurityException e) {
                        if (this.mAppOps.noteOp(51, Binder.getCallingUid(), callingPackage) == 0) break block58;
                        return;
                    }
                }
            }
            ArrayList<Record> arrayList = this.mRecords;
            synchronized (arrayList) {
                Record r;
                block59: {
                    IBinder b = callback.asBinder();
                    int N = this.mRecords.size();
                    for (int i = 0; i < N; ++i) {
                        r = this.mRecords.get(i);
                        if (b != r.binder) {
                            continue;
                        }
                        break block59;
                    }
                    r = new Record();
                    r.binder = b;
                    this.mRecords.add(r);
                }
                r.callback = callback;
                r.callingPackage = callingPackage;
                r.callerUserId = callerUserId;
                boolean isPhoneStateEvent = (events & 0x40EC) != 0;
                r.canReadPhoneState = isPhoneStateEvent && this.canReadPhoneState(callingPackage);
                r.subId = !SubscriptionManager.isValidSubscriptionId(subId) ? Integer.MAX_VALUE : subId;
                int phoneId = r.phoneId = SubscriptionManager.getPhoneId(r.subId);
                r.events = events;
                if (notifyNow && this.validatePhoneId(phoneId)) {
                    if ((events & 1) != 0) {
                        try {
                            r.callback.onServiceStateChanged(new ServiceState(this.mServiceState[phoneId]));
                        }
                        catch (RemoteException ex) {
                            this.remove(r.binder);
                        }
                    }
                    if ((events & 2) != 0) {
                        try {
                            int gsmSignalStrength = this.mSignalStrength[phoneId].getGsmSignalStrength();
                            r.callback.onSignalStrengthChanged(gsmSignalStrength == 99 ? -1 : gsmSignalStrength);
                        }
                        catch (RemoteException ex) {
                            this.remove(r.binder);
                        }
                    }
                    if ((events & 4) != 0) {
                        try {
                            r.callback.onMessageWaitingIndicatorChanged(this.mMessageWaiting[phoneId]);
                        }
                        catch (RemoteException ex) {
                            this.remove(r.binder);
                        }
                    }
                    if ((events & 8) != 0) {
                        try {
                            r.callback.onCallForwardingIndicatorChanged(this.mCallForwarding[phoneId]);
                        }
                        catch (RemoteException ex) {
                            this.remove(r.binder);
                        }
                    }
                    if (this.validateEventsAndUserLocked(r, 16)) {
                        try {
                            r.callback.onCellLocationChanged(new Bundle(this.mCellLocation[phoneId]));
                        }
                        catch (RemoteException ex) {
                            this.remove(r.binder);
                        }
                    }
                    if ((events & 0x20) != 0) {
                        try {
                            r.callback.onCallStateChanged(this.mCallState[phoneId], this.getCallIncomingNumber(r, phoneId));
                        }
                        catch (RemoteException ex) {
                            this.remove(r.binder);
                        }
                    }
                    if ((events & 0x40) != 0) {
                        try {
                            r.callback.onDataConnectionStateChanged(this.mDataConnectionState[phoneId], this.mDataConnectionNetworkType[phoneId]);
                        }
                        catch (RemoteException ex) {
                            this.remove(r.binder);
                        }
                    }
                    if ((events & 0x80) != 0) {
                        try {
                            r.callback.onDataActivity(this.mDataActivity[phoneId]);
                        }
                        catch (RemoteException ex) {
                            this.remove(r.binder);
                        }
                    }
                    if ((events & 0x100) != 0) {
                        try {
                            r.callback.onSignalStrengthsChanged(this.mSignalStrength[phoneId]);
                        }
                        catch (RemoteException ex) {
                            this.remove(r.binder);
                        }
                    }
                    if ((events & 0x200) != 0) {
                        try {
                            r.callback.onOtaspChanged(this.mOtaspMode);
                        }
                        catch (RemoteException ex) {
                            this.remove(r.binder);
                        }
                    }
                    if (this.validateEventsAndUserLocked(r, 1024)) {
                        try {
                            r.callback.onCellInfoChanged(this.mCellInfo.get(phoneId));
                        }
                        catch (RemoteException ex) {
                            this.remove(r.binder);
                        }
                    }
                    if ((events & 0x800) != 0) {
                        try {
                            r.callback.onPreciseCallStateChanged(this.mPreciseCallState);
                        }
                        catch (RemoteException ex) {
                            this.remove(r.binder);
                        }
                    }
                    if ((events & 0x1000) != 0) {
                        try {
                            r.callback.onPreciseDataConnectionStateChanged(this.mPreciseDataConnectionState);
                        }
                        catch (RemoteException ex) {
                            this.remove(r.binder);
                        }
                    }
                    if ((events & 0x10000) != 0) {
                        try {
                            r.callback.onCarrierNetworkChange(this.mCarrierNetworkChangeState);
                        }
                        catch (RemoteException ex) {
                            this.remove(r.binder);
                        }
                    }
                    if ((events & 0x20000) != 0) {
                        try {
                            r.callback.onVoiceActivationStateChanged(this.mVoiceActivationState[phoneId]);
                        }
                        catch (RemoteException ex) {
                            this.remove(r.binder);
                        }
                    }
                    if ((events & 0x40000) != 0) {
                        try {
                            r.callback.onDataActivationStateChanged(this.mDataActivationState[phoneId]);
                        }
                        catch (RemoteException ex) {
                            this.remove(r.binder);
                        }
                    }
                }
            }
        }
        this.remove(callback.asBinder());
    }

    private boolean canReadPhoneState(String callingPackage) {
        boolean canReadPhoneState;
        if (this.mContext.checkCallingOrSelfPermission("android.permission.READ_PRIVILEGED_PHONE_STATE") == 0) {
            return true;
        }
        boolean bl = canReadPhoneState = this.mContext.checkCallingOrSelfPermission("android.permission.READ_PHONE_STATE") == 0;
        if (canReadPhoneState && this.mAppOps.noteOp(51, Binder.getCallingUid(), callingPackage) != 0) {
            return false;
        }
        return canReadPhoneState;
    }

    private String getCallIncomingNumber(Record record, int phoneId) {
        return record.canReadPhoneState ? this.mCallIncomingNumber[phoneId] : "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(IBinder binder) {
        ArrayList<Record> arrayList = this.mRecords;
        synchronized (arrayList) {
            int recordCount = this.mRecords.size();
            for (int i = 0; i < recordCount; ++i) {
                if (this.mRecords.get((int)i).binder != binder) continue;
                this.mRecords.remove(i);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyCallState(int state, String incomingNumber) {
        if (!this.checkNotifyPermission("notifyCallState()")) {
            return;
        }
        ArrayList<Record> arrayList = this.mRecords;
        synchronized (arrayList) {
            for (Record r : this.mRecords) {
                if (!r.matchPhoneStateListenerEvent(32) || r.subId != Integer.MAX_VALUE) continue;
                try {
                    String incomingNumberOrEmpty = r.canReadPhoneState ? incomingNumber : "";
                    r.callback.onCallStateChanged(state, incomingNumberOrEmpty);
                }
                catch (RemoteException ex) {
                    this.mRemoveList.add(r.binder);
                }
            }
            this.handleRemoveListLocked();
        }
        this.broadcastCallStateChanged(state, incomingNumber, -1, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyCallStateForPhoneId(int phoneId, int subId, int state, String incomingNumber) {
        if (!this.checkNotifyPermission("notifyCallState()")) {
            return;
        }
        ArrayList<Record> arrayList = this.mRecords;
        synchronized (arrayList) {
            if (this.validatePhoneId(phoneId)) {
                this.mCallState[phoneId] = state;
                this.mCallIncomingNumber[phoneId] = incomingNumber;
                for (Record r : this.mRecords) {
                    if (!r.matchPhoneStateListenerEvent(32) || r.subId != subId || r.subId == Integer.MAX_VALUE) continue;
                    try {
                        String incomingNumberOrEmpty = this.getCallIncomingNumber(r, phoneId);
                        r.callback.onCallStateChanged(state, incomingNumberOrEmpty);
                    }
                    catch (RemoteException ex) {
                        this.mRemoveList.add(r.binder);
                    }
                }
            }
            this.handleRemoveListLocked();
        }
        this.broadcastCallStateChanged(state, incomingNumber, phoneId, subId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyServiceStateForPhoneId(int phoneId, int subId, ServiceState state) {
        if (!this.checkNotifyPermission("notifyServiceState()")) {
            return;
        }
        ArrayList<Record> arrayList = this.mRecords;
        synchronized (arrayList) {
            String str = "notifyServiceStateForSubscriber: subId=" + subId + " phoneId=" + phoneId + " state=" + state;
            this.mLocalLog.log(str);
            if (this.validatePhoneId(phoneId)) {
                this.mServiceState[phoneId] = state;
                for (Record r : this.mRecords) {
                    if (!r.matchPhoneStateListenerEvent(1) || !this.idMatch(r.subId, subId, phoneId)) continue;
                    try {
                        r.callback.onServiceStateChanged(new ServiceState(state));
                    }
                    catch (RemoteException ex) {
                        this.mRemoveList.add(r.binder);
                    }
                }
            } else {
                TelephonyRegistry.log("notifyServiceStateForSubscriber: INVALID phoneId=" + phoneId);
            }
            this.handleRemoveListLocked();
        }
        this.broadcastServiceStateChanged(state, phoneId, subId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifySimActivationStateChangedForPhoneId(int phoneId, int subId, int activationType, int activationState) {
        if (!this.checkNotifyPermission("notifySimActivationState()")) {
            return;
        }
        ArrayList<Record> arrayList = this.mRecords;
        synchronized (arrayList) {
            if (this.validatePhoneId(phoneId)) {
                switch (activationType) {
                    case 0: {
                        this.mVoiceActivationState[phoneId] = activationState;
                        break;
                    }
                    case 1: {
                        this.mDataActivationState[phoneId] = activationState;
                        break;
                    }
                    default: {
                        return;
                    }
                }
                for (Record r : this.mRecords) {
                    try {
                        if (activationType == 0 && r.matchPhoneStateListenerEvent(131072) && this.idMatch(r.subId, subId, phoneId)) {
                            r.callback.onVoiceActivationStateChanged(activationState);
                        }
                        if (activationType != 1 || !r.matchPhoneStateListenerEvent(262144) || !this.idMatch(r.subId, subId, phoneId)) continue;
                        r.callback.onDataActivationStateChanged(activationState);
                    }
                    catch (RemoteException ex) {
                        this.mRemoveList.add(r.binder);
                    }
                }
            } else {
                TelephonyRegistry.log("notifySimActivationStateForPhoneId: INVALID phoneId=" + phoneId);
            }
            this.handleRemoveListLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifySignalStrengthForPhoneId(int phoneId, int subId, SignalStrength signalStrength) {
        if (!this.checkNotifyPermission("notifySignalStrength()")) {
            return;
        }
        ArrayList<Record> arrayList = this.mRecords;
        synchronized (arrayList) {
            if (this.validatePhoneId(phoneId)) {
                this.mSignalStrength[phoneId] = signalStrength;
                for (Record r : this.mRecords) {
                    if (r.matchPhoneStateListenerEvent(256) && this.idMatch(r.subId, subId, phoneId)) {
                        try {
                            r.callback.onSignalStrengthsChanged(new SignalStrength(signalStrength));
                        }
                        catch (RemoteException ex) {
                            this.mRemoveList.add(r.binder);
                        }
                    }
                    if (!r.matchPhoneStateListenerEvent(2) || !this.idMatch(r.subId, subId, phoneId)) continue;
                    try {
                        int gsmSignalStrength = signalStrength.getGsmSignalStrength();
                        int ss = gsmSignalStrength == 99 ? -1 : gsmSignalStrength;
                        r.callback.onSignalStrengthChanged(ss);
                    }
                    catch (RemoteException ex) {
                        this.mRemoveList.add(r.binder);
                    }
                }
            } else {
                TelephonyRegistry.log("notifySignalStrengthForPhoneId: invalid phoneId=" + phoneId);
            }
            this.handleRemoveListLocked();
        }
        this.broadcastSignalStrengthChanged(signalStrength, phoneId, subId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyCarrierNetworkChange(boolean active) {
        this.enforceNotifyPermissionOrCarrierPrivilege("notifyCarrierNetworkChange()");
        ArrayList<Record> arrayList = this.mRecords;
        synchronized (arrayList) {
            this.mCarrierNetworkChangeState = active;
            for (Record r : this.mRecords) {
                if (!r.matchPhoneStateListenerEvent(65536)) continue;
                try {
                    r.callback.onCarrierNetworkChange(active);
                }
                catch (RemoteException ex) {
                    this.mRemoveList.add(r.binder);
                }
            }
            this.handleRemoveListLocked();
        }
    }

    @Override
    public void notifyCellInfo(List<CellInfo> cellInfo) {
        this.notifyCellInfoForSubscriber(Integer.MAX_VALUE, cellInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyCellInfoForSubscriber(int subId, List<CellInfo> cellInfo) {
        if (!this.checkNotifyPermission("notifyCellInfo()")) {
            return;
        }
        ArrayList<Record> arrayList = this.mRecords;
        synchronized (arrayList) {
            int phoneId = SubscriptionManager.getPhoneId(subId);
            if (this.validatePhoneId(phoneId)) {
                this.mCellInfo.set(phoneId, cellInfo);
                for (Record r : this.mRecords) {
                    if (!this.validateEventsAndUserLocked(r, 1024) || !this.idMatch(r.subId, subId, phoneId)) continue;
                    try {
                        r.callback.onCellInfoChanged(cellInfo);
                    }
                    catch (RemoteException ex) {
                        this.mRemoveList.add(r.binder);
                    }
                }
            }
            this.handleRemoveListLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyMessageWaitingChangedForPhoneId(int phoneId, int subId, boolean mwi) {
        if (!this.checkNotifyPermission("notifyMessageWaitingChanged()")) {
            return;
        }
        ArrayList<Record> arrayList = this.mRecords;
        synchronized (arrayList) {
            if (this.validatePhoneId(phoneId)) {
                this.mMessageWaiting[phoneId] = mwi;
                for (Record r : this.mRecords) {
                    if (!r.matchPhoneStateListenerEvent(4) || !this.idMatch(r.subId, subId, phoneId)) continue;
                    try {
                        r.callback.onMessageWaitingIndicatorChanged(mwi);
                    }
                    catch (RemoteException ex) {
                        this.mRemoveList.add(r.binder);
                    }
                }
            }
            this.handleRemoveListLocked();
        }
    }

    @Override
    public void notifyCallForwardingChanged(boolean cfi) {
        this.notifyCallForwardingChangedForSubscriber(Integer.MAX_VALUE, cfi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyCallForwardingChangedForSubscriber(int subId, boolean cfi) {
        if (!this.checkNotifyPermission("notifyCallForwardingChanged()")) {
            return;
        }
        ArrayList<Record> arrayList = this.mRecords;
        synchronized (arrayList) {
            int phoneId = SubscriptionManager.getPhoneId(subId);
            if (this.validatePhoneId(phoneId)) {
                this.mCallForwarding[phoneId] = cfi;
                for (Record r : this.mRecords) {
                    if (!r.matchPhoneStateListenerEvent(8) || !this.idMatch(r.subId, subId, phoneId)) continue;
                    try {
                        r.callback.onCallForwardingIndicatorChanged(cfi);
                    }
                    catch (RemoteException ex) {
                        this.mRemoveList.add(r.binder);
                    }
                }
            }
            this.handleRemoveListLocked();
        }
    }

    @Override
    public void notifyDataActivity(int state) {
        this.notifyDataActivityForSubscriber(Integer.MAX_VALUE, state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyDataActivityForSubscriber(int subId, int state) {
        if (!this.checkNotifyPermission("notifyDataActivity()")) {
            return;
        }
        ArrayList<Record> arrayList = this.mRecords;
        synchronized (arrayList) {
            int phoneId = SubscriptionManager.getPhoneId(subId);
            if (this.validatePhoneId(phoneId)) {
                this.mDataActivity[phoneId] = state;
                for (Record r : this.mRecords) {
                    if (!r.matchPhoneStateListenerEvent(128) || !this.idMatch(r.subId, subId, phoneId)) continue;
                    try {
                        r.callback.onDataActivity(state);
                    }
                    catch (RemoteException ex) {
                        this.mRemoveList.add(r.binder);
                    }
                }
            }
            this.handleRemoveListLocked();
        }
    }

    @Override
    public void notifyDataConnection(int state, boolean isDataAllowed, String reason, String apn, String apnType, LinkProperties linkProperties, NetworkCapabilities networkCapabilities, int networkType, boolean roaming) {
        this.notifyDataConnectionForSubscriber(Integer.MAX_VALUE, state, isDataAllowed, reason, apn, apnType, linkProperties, networkCapabilities, networkType, roaming);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyDataConnectionForSubscriber(int subId, int state, boolean isDataAllowed, String reason, String apn, String apnType, LinkProperties linkProperties, NetworkCapabilities networkCapabilities, int networkType, boolean roaming) {
        if (!this.checkNotifyPermission("notifyDataConnection()")) {
            return;
        }
        ArrayList<Record> arrayList = this.mRecords;
        synchronized (arrayList) {
            int phoneId = SubscriptionManager.getPhoneId(subId);
            if (this.validatePhoneId(phoneId)) {
                boolean modified = false;
                if (state == 2) {
                    if (!this.mConnectedApns[phoneId].contains(apnType)) {
                        this.mConnectedApns[phoneId].add(apnType);
                        if (this.mDataConnectionState[phoneId] != state) {
                            this.mDataConnectionState[phoneId] = state;
                            modified = true;
                        }
                    }
                } else if (this.mConnectedApns[phoneId].remove(apnType) && this.mConnectedApns[phoneId].isEmpty()) {
                    this.mDataConnectionState[phoneId] = state;
                    modified = true;
                }
                this.mDataConnectionLinkProperties[phoneId] = linkProperties;
                this.mDataConnectionNetworkCapabilities[phoneId] = networkCapabilities;
                if (this.mDataConnectionNetworkType[phoneId] != networkType) {
                    this.mDataConnectionNetworkType[phoneId] = networkType;
                    modified = true;
                }
                if (modified) {
                    String str = "onDataConnectionStateChanged(" + this.mDataConnectionState[phoneId] + ", " + this.mDataConnectionNetworkType[phoneId] + ")";
                    TelephonyRegistry.log(str);
                    this.mLocalLog.log(str);
                    for (Record r : this.mRecords) {
                        if (!r.matchPhoneStateListenerEvent(64) || !this.idMatch(r.subId, subId, phoneId)) continue;
                        try {
                            r.callback.onDataConnectionStateChanged(this.mDataConnectionState[phoneId], this.mDataConnectionNetworkType[phoneId]);
                        }
                        catch (RemoteException ex) {
                            this.mRemoveList.add(r.binder);
                        }
                    }
                    this.handleRemoveListLocked();
                }
                this.mPreciseDataConnectionState = new PreciseDataConnectionState(state, networkType, apnType, apn, reason, linkProperties, "");
                for (Record r : this.mRecords) {
                    if (!r.matchPhoneStateListenerEvent(4096)) continue;
                    try {
                        r.callback.onPreciseDataConnectionStateChanged(this.mPreciseDataConnectionState);
                    }
                    catch (RemoteException ex) {
                        this.mRemoveList.add(r.binder);
                    }
                }
            }
            this.handleRemoveListLocked();
        }
        this.broadcastDataConnectionStateChanged(state, isDataAllowed, reason, apn, apnType, linkProperties, networkCapabilities, roaming, subId);
        this.broadcastPreciseDataConnectionStateChanged(state, networkType, apnType, apn, reason, linkProperties, "");
    }

    @Override
    public void notifyDataConnectionFailed(String reason, String apnType) {
        this.notifyDataConnectionFailedForSubscriber(Integer.MAX_VALUE, reason, apnType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyDataConnectionFailedForSubscriber(int subId, String reason, String apnType) {
        if (!this.checkNotifyPermission("notifyDataConnectionFailed()")) {
            return;
        }
        ArrayList<Record> arrayList = this.mRecords;
        synchronized (arrayList) {
            this.mPreciseDataConnectionState = new PreciseDataConnectionState(-1, 0, apnType, "", reason, null, "");
            for (Record r : this.mRecords) {
                if (!r.matchPhoneStateListenerEvent(4096)) continue;
                try {
                    r.callback.onPreciseDataConnectionStateChanged(this.mPreciseDataConnectionState);
                }
                catch (RemoteException ex) {
                    this.mRemoveList.add(r.binder);
                }
            }
            this.handleRemoveListLocked();
        }
        this.broadcastDataConnectionFailed(reason, apnType, subId);
        this.broadcastPreciseDataConnectionStateChanged(-1, 0, apnType, "", reason, null, "");
    }

    @Override
    public void notifyCellLocation(Bundle cellLocation) {
        this.notifyCellLocationForSubscriber(Integer.MAX_VALUE, cellLocation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyCellLocationForSubscriber(int subId, Bundle cellLocation) {
        TelephonyRegistry.log("notifyCellLocationForSubscriber: subId=" + subId + " cellLocation=" + cellLocation);
        if (!this.checkNotifyPermission("notifyCellLocation()")) {
            return;
        }
        ArrayList<Record> arrayList = this.mRecords;
        synchronized (arrayList) {
            int phoneId = SubscriptionManager.getPhoneId(subId);
            if (this.validatePhoneId(phoneId)) {
                this.mCellLocation[phoneId] = cellLocation;
                for (Record r : this.mRecords) {
                    if (!this.validateEventsAndUserLocked(r, 16) || !this.idMatch(r.subId, subId, phoneId)) continue;
                    try {
                        r.callback.onCellLocationChanged(new Bundle(cellLocation));
                    }
                    catch (RemoteException ex) {
                        this.mRemoveList.add(r.binder);
                    }
                }
            }
            this.handleRemoveListLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyOtaspChanged(int otaspMode) {
        if (!this.checkNotifyPermission("notifyOtaspChanged()")) {
            return;
        }
        ArrayList<Record> arrayList = this.mRecords;
        synchronized (arrayList) {
            this.mOtaspMode = otaspMode;
            for (Record r : this.mRecords) {
                if (!r.matchPhoneStateListenerEvent(512)) continue;
                try {
                    r.callback.onOtaspChanged(otaspMode);
                }
                catch (RemoteException ex) {
                    this.mRemoveList.add(r.binder);
                }
            }
            this.handleRemoveListLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyPreciseCallState(int ringingCallState, int foregroundCallState, int backgroundCallState) {
        if (!this.checkNotifyPermission("notifyPreciseCallState()")) {
            return;
        }
        ArrayList<Record> arrayList = this.mRecords;
        synchronized (arrayList) {
            this.mRingingCallState = ringingCallState;
            this.mForegroundCallState = foregroundCallState;
            this.mBackgroundCallState = backgroundCallState;
            this.mPreciseCallState = new PreciseCallState(ringingCallState, foregroundCallState, backgroundCallState, -1, -1);
            for (Record r : this.mRecords) {
                if (!r.matchPhoneStateListenerEvent(2048)) continue;
                try {
                    r.callback.onPreciseCallStateChanged(this.mPreciseCallState);
                }
                catch (RemoteException ex) {
                    this.mRemoveList.add(r.binder);
                }
            }
            this.handleRemoveListLocked();
        }
        this.broadcastPreciseCallStateChanged(ringingCallState, foregroundCallState, backgroundCallState, -1, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyDisconnectCause(int disconnectCause, int preciseDisconnectCause) {
        if (!this.checkNotifyPermission("notifyDisconnectCause()")) {
            return;
        }
        ArrayList<Record> arrayList = this.mRecords;
        synchronized (arrayList) {
            this.mPreciseCallState = new PreciseCallState(this.mRingingCallState, this.mForegroundCallState, this.mBackgroundCallState, disconnectCause, preciseDisconnectCause);
            for (Record r : this.mRecords) {
                if (!r.matchPhoneStateListenerEvent(2048)) continue;
                try {
                    r.callback.onPreciseCallStateChanged(this.mPreciseCallState);
                }
                catch (RemoteException ex) {
                    this.mRemoveList.add(r.binder);
                }
            }
            this.handleRemoveListLocked();
        }
        this.broadcastPreciseCallStateChanged(this.mRingingCallState, this.mForegroundCallState, this.mBackgroundCallState, disconnectCause, preciseDisconnectCause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyPreciseDataConnectionFailed(String reason, String apnType, String apn, String failCause) {
        if (!this.checkNotifyPermission("notifyPreciseDataConnectionFailed()")) {
            return;
        }
        ArrayList<Record> arrayList = this.mRecords;
        synchronized (arrayList) {
            this.mPreciseDataConnectionState = new PreciseDataConnectionState(-1, 0, apnType, apn, reason, null, failCause);
            for (Record r : this.mRecords) {
                if (!r.matchPhoneStateListenerEvent(4096)) continue;
                try {
                    r.callback.onPreciseDataConnectionStateChanged(this.mPreciseDataConnectionState);
                }
                catch (RemoteException ex) {
                    this.mRemoveList.add(r.binder);
                }
            }
            this.handleRemoveListLocked();
        }
        this.broadcastPreciseDataConnectionStateChanged(-1, 0, apnType, apn, reason, null, failCause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyVoLteServiceStateChanged(VoLteServiceState lteState) {
        if (!this.checkNotifyPermission("notifyVoLteServiceStateChanged()")) {
            return;
        }
        ArrayList<Record> arrayList = this.mRecords;
        synchronized (arrayList) {
            this.mVoLteServiceState = lteState;
            for (Record r : this.mRecords) {
                if (!r.matchPhoneStateListenerEvent(16384)) continue;
                try {
                    r.callback.onVoLteServiceStateChanged(new VoLteServiceState(this.mVoLteServiceState));
                }
                catch (RemoteException ex) {
                    this.mRemoveList.add(r.binder);
                }
            }
            this.handleRemoveListLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyOemHookRawEventForSubscriber(int subId, byte[] rawData) {
        if (!this.checkNotifyPermission("notifyOemHookRawEventForSubscriber")) {
            return;
        }
        ArrayList<Record> arrayList = this.mRecords;
        synchronized (arrayList) {
            for (Record r : this.mRecords) {
                if (!r.matchPhoneStateListenerEvent(32768) || r.subId != subId && r.subId != Integer.MAX_VALUE) continue;
                try {
                    r.callback.onOemHookRawEvent(rawData);
                }
                catch (RemoteException ex) {
                    this.mRemoveList.add(r.binder);
                }
            }
            this.handleRemoveListLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dump(FileDescriptor fd, PrintWriter writer, String[] args) {
        IndentingPrintWriter pw = new IndentingPrintWriter((Writer)writer, "  ");
        if (!DumpUtils.checkDumpPermission(this.mContext, TAG, pw)) {
            return;
        }
        ArrayList<Record> arrayList = this.mRecords;
        synchronized (arrayList) {
            int recordCount = this.mRecords.size();
            pw.println("last known state:");
            pw.increaseIndent();
            for (int i = 0; i < TelephonyManager.getDefault().getPhoneCount(); ++i) {
                pw.println("Phone Id=" + i);
                pw.increaseIndent();
                pw.println("mCallState=" + this.mCallState[i]);
                pw.println("mCallIncomingNumber=" + this.mCallIncomingNumber[i]);
                pw.println("mServiceState=" + this.mServiceState[i]);
                pw.println("mVoiceActivationState= " + this.mVoiceActivationState[i]);
                pw.println("mDataActivationState= " + this.mDataActivationState[i]);
                pw.println("mSignalStrength=" + this.mSignalStrength[i]);
                pw.println("mMessageWaiting=" + this.mMessageWaiting[i]);
                pw.println("mCallForwarding=" + this.mCallForwarding[i]);
                pw.println("mDataActivity=" + this.mDataActivity[i]);
                pw.println("mDataConnectionState=" + this.mDataConnectionState[i]);
                pw.println("mDataConnectionLinkProperties=" + this.mDataConnectionLinkProperties[i]);
                pw.println("mDataConnectionNetworkCapabilities=" + this.mDataConnectionNetworkCapabilities[i]);
                pw.println("mCellLocation=" + this.mCellLocation[i]);
                pw.println("mCellInfo=" + this.mCellInfo.get(i));
                pw.decreaseIndent();
            }
            pw.println("mConnectedApns=" + Arrays.toString(this.mConnectedApns));
            pw.println("mPreciseDataConnectionState=" + this.mPreciseDataConnectionState);
            pw.println("mPreciseCallState=" + this.mPreciseCallState);
            pw.println("mCarrierNetworkChangeState=" + this.mCarrierNetworkChangeState);
            pw.println("mRingingCallState=" + this.mRingingCallState);
            pw.println("mForegroundCallState=" + this.mForegroundCallState);
            pw.println("mBackgroundCallState=" + this.mBackgroundCallState);
            pw.println("mVoLteServiceState=" + this.mVoLteServiceState);
            pw.decreaseIndent();
            pw.println("local logs:");
            pw.increaseIndent();
            this.mLocalLog.dump(fd, pw, args);
            pw.decreaseIndent();
            pw.println("registrations: count=" + recordCount);
            pw.increaseIndent();
            for (Record r : this.mRecords) {
                pw.println(r);
            }
            pw.decreaseIndent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void broadcastServiceStateChanged(ServiceState state, int phoneId, int subId) {
        long ident = Binder.clearCallingIdentity();
        try {
            this.mBatteryStats.notePhoneState(state.getState());
        }
        catch (RemoteException remoteException) {
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
        Intent intent = new Intent("android.intent.action.SERVICE_STATE");
        intent.addFlags(0x1000000);
        Bundle data = new Bundle();
        state.fillInNotifierBundle(data);
        intent.putExtras(data);
        intent.putExtra("subscription", subId);
        intent.putExtra("slot", phoneId);
        this.mContext.sendStickyBroadcastAsUser(intent, UserHandle.ALL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void broadcastSignalStrengthChanged(SignalStrength signalStrength, int phoneId, int subId) {
        long ident = Binder.clearCallingIdentity();
        try {
            this.mBatteryStats.notePhoneSignalStrength(signalStrength);
        }
        catch (RemoteException remoteException) {
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
        Intent intent = new Intent("android.intent.action.SIG_STR");
        Bundle data = new Bundle();
        signalStrength.fillInNotifierBundle(data);
        intent.putExtras(data);
        intent.putExtra("subscription", subId);
        intent.putExtra("slot", phoneId);
        this.mContext.sendStickyBroadcastAsUser(intent, UserHandle.ALL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void broadcastCallStateChanged(int state, String incomingNumber, int phoneId, int subId) {
        long ident = Binder.clearCallingIdentity();
        try {
            if (state == 0) {
                this.mBatteryStats.notePhoneOff();
            } else {
                this.mBatteryStats.notePhoneOn();
            }
        }
        catch (RemoteException remoteException) {
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
        Intent intent = new Intent("android.intent.action.PHONE_STATE");
        intent.putExtra("state", PhoneConstantConversions.convertCallState(state).toString());
        if (!TextUtils.isEmpty(incomingNumber)) {
            intent.putExtra("incoming_number", incomingNumber);
        }
        if (subId != -1) {
            intent.setAction("android.intent.action.SUBSCRIPTION_PHONE_STATE");
            intent.putExtra("subscription", subId);
        }
        if (phoneId != -1) {
            intent.putExtra("slot", phoneId);
        }
        intent.addFlags(0x1000000);
        this.mContext.sendBroadcastAsUser(intent, UserHandle.ALL, "android.permission.READ_PRIVILEGED_PHONE_STATE");
        this.mContext.sendBroadcastAsUser(intent, UserHandle.ALL, "android.permission.READ_PHONE_STATE", 51);
    }

    private void broadcastDataConnectionStateChanged(int state, boolean isDataAllowed, String reason, String apn, String apnType, LinkProperties linkProperties, NetworkCapabilities networkCapabilities, boolean roaming, int subId) {
        Intent intent = new Intent("android.intent.action.ANY_DATA_STATE");
        intent.putExtra("state", PhoneConstantConversions.convertDataState(state).toString());
        if (!isDataAllowed) {
            intent.putExtra("networkUnvailable", true);
        }
        if (reason != null) {
            intent.putExtra("reason", reason);
        }
        if (linkProperties != null) {
            intent.putExtra("linkProperties", linkProperties);
            String iface = linkProperties.getInterfaceName();
            if (iface != null) {
                intent.putExtra("iface", iface);
            }
        }
        if (networkCapabilities != null) {
            intent.putExtra("networkCapabilities", networkCapabilities);
        }
        if (roaming) {
            intent.putExtra("networkRoaming", true);
        }
        intent.putExtra("apn", apn);
        intent.putExtra("apnType", apnType);
        intent.putExtra("subscription", subId);
        this.mContext.sendStickyBroadcastAsUser(intent, UserHandle.ALL);
    }

    private void broadcastDataConnectionFailed(String reason, String apnType, int subId) {
        Intent intent = new Intent("android.intent.action.DATA_CONNECTION_FAILED");
        intent.putExtra("reason", reason);
        intent.putExtra("apnType", apnType);
        intent.putExtra("subscription", subId);
        this.mContext.sendStickyBroadcastAsUser(intent, UserHandle.ALL);
    }

    private void broadcastPreciseCallStateChanged(int ringingCallState, int foregroundCallState, int backgroundCallState, int disconnectCause, int preciseDisconnectCause) {
        Intent intent = new Intent("android.intent.action.PRECISE_CALL_STATE");
        intent.putExtra("ringing_state", ringingCallState);
        intent.putExtra("foreground_state", foregroundCallState);
        intent.putExtra("background_state", backgroundCallState);
        intent.putExtra("disconnect_cause", disconnectCause);
        intent.putExtra("precise_disconnect_cause", preciseDisconnectCause);
        this.mContext.sendBroadcastAsUser(intent, UserHandle.ALL, "android.permission.READ_PRECISE_PHONE_STATE");
    }

    private void broadcastPreciseDataConnectionStateChanged(int state, int networkType, String apnType, String apn, String reason, LinkProperties linkProperties, String failCause) {
        Intent intent = new Intent("android.intent.action.PRECISE_DATA_CONNECTION_STATE_CHANGED");
        intent.putExtra("state", state);
        intent.putExtra("networkType", networkType);
        if (reason != null) {
            intent.putExtra("reason", reason);
        }
        if (apnType != null) {
            intent.putExtra("apnType", apnType);
        }
        if (apn != null) {
            intent.putExtra("apn", apn);
        }
        if (linkProperties != null) {
            intent.putExtra("linkProperties", linkProperties);
        }
        if (failCause != null) {
            intent.putExtra("failCause", failCause);
        }
        this.mContext.sendBroadcastAsUser(intent, UserHandle.ALL, "android.permission.READ_PRECISE_PHONE_STATE");
    }

    private void enforceNotifyPermissionOrCarrierPrivilege(String method) {
        if (this.checkNotifyPermission()) {
            return;
        }
        this.enforceCarrierPrivilege();
    }

    private boolean checkNotifyPermission(String method) {
        if (this.checkNotifyPermission()) {
            return true;
        }
        String msg = "Modify Phone State Permission Denial: " + method + " from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid();
        return false;
    }

    private boolean checkNotifyPermission() {
        return this.mContext.checkCallingOrSelfPermission("android.permission.MODIFY_PHONE_STATE") == 0;
    }

    private void enforceCarrierPrivilege() {
        String[] pkgs;
        TelephonyManager tm = TelephonyManager.getDefault();
        for (String pkg : pkgs = this.mContext.getPackageManager().getPackagesForUid(Binder.getCallingUid())) {
            if (tm.checkCarrierPrivilegesForPackage(pkg) != 1) continue;
            return;
        }
        String msg = "Carrier Privilege Permission Denial: from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid();
        throw new SecurityException(msg);
    }

    private void checkListenerPermission(int events) {
        if ((events & 0x10) != 0) {
            this.mContext.enforceCallingOrSelfPermission("android.permission.ACCESS_COARSE_LOCATION", null);
        }
        if ((events & 0x400) != 0) {
            this.mContext.enforceCallingOrSelfPermission("android.permission.ACCESS_COARSE_LOCATION", null);
        }
        if ((events & 0x400C) != 0) {
            try {
                this.mContext.enforceCallingOrSelfPermission("android.permission.READ_PRIVILEGED_PHONE_STATE", null);
            }
            catch (SecurityException e) {
                this.mContext.enforceCallingOrSelfPermission("android.permission.READ_PHONE_STATE", null);
            }
        }
        if ((events & 0x1800) != 0) {
            this.mContext.enforceCallingOrSelfPermission("android.permission.READ_PRECISE_PHONE_STATE", null);
        }
        if ((events & 0x8000) != 0) {
            this.mContext.enforceCallingOrSelfPermission("android.permission.READ_PRIVILEGED_PHONE_STATE", null);
        }
    }

    private void handleRemoveListLocked() {
        int size = this.mRemoveList.size();
        if (size > 0) {
            for (IBinder b : this.mRemoveList) {
                this.remove(b);
            }
            this.mRemoveList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean validateEventsAndUserLocked(Record r, int events) {
        long callingIdentity = Binder.clearCallingIdentity();
        boolean valid = false;
        try {
            int foregroundUser = ActivityManager.getCurrentUser();
            valid = r.callerUserId == foregroundUser && r.matchPhoneStateListenerEvent(events);
        }
        finally {
            Binder.restoreCallingIdentity(callingIdentity);
        }
        return valid;
    }

    private boolean validatePhoneId(int phoneId) {
        boolean valid = phoneId >= 0 && phoneId < this.mNumPhones;
        return valid;
    }

    private static void log(String s) {
        Rlog.d(TAG, s);
    }

    boolean idMatch(int rSubId, int subId, int phoneId) {
        if (subId < 0) {
            return this.mDefaultPhoneId == phoneId;
        }
        if (rSubId == Integer.MAX_VALUE) {
            return subId == this.mDefaultSubId;
        }
        return rSubId == subId;
    }

    private void checkPossibleMissNotify(Record r, int phoneId) {
        int events = r.events;
        if ((events & 1) != 0) {
            try {
                r.callback.onServiceStateChanged(new ServiceState(this.mServiceState[phoneId]));
            }
            catch (RemoteException ex) {
                this.mRemoveList.add(r.binder);
            }
        }
        if ((events & 0x100) != 0) {
            try {
                SignalStrength signalStrength = this.mSignalStrength[phoneId];
                r.callback.onSignalStrengthsChanged(new SignalStrength(signalStrength));
            }
            catch (RemoteException ex) {
                this.mRemoveList.add(r.binder);
            }
        }
        if ((events & 2) != 0) {
            try {
                int gsmSignalStrength = this.mSignalStrength[phoneId].getGsmSignalStrength();
                r.callback.onSignalStrengthChanged(gsmSignalStrength == 99 ? -1 : gsmSignalStrength);
            }
            catch (RemoteException ex) {
                this.mRemoveList.add(r.binder);
            }
        }
        if (this.validateEventsAndUserLocked(r, 1024)) {
            try {
                r.callback.onCellInfoChanged(this.mCellInfo.get(phoneId));
            }
            catch (RemoteException ex) {
                this.mRemoveList.add(r.binder);
            }
        }
        if ((events & 4) != 0) {
            try {
                r.callback.onMessageWaitingIndicatorChanged(this.mMessageWaiting[phoneId]);
            }
            catch (RemoteException ex) {
                this.mRemoveList.add(r.binder);
            }
        }
        if ((events & 8) != 0) {
            try {
                r.callback.onCallForwardingIndicatorChanged(this.mCallForwarding[phoneId]);
            }
            catch (RemoteException ex) {
                this.mRemoveList.add(r.binder);
            }
        }
        if (this.validateEventsAndUserLocked(r, 16)) {
            try {
                r.callback.onCellLocationChanged(new Bundle(this.mCellLocation[phoneId]));
            }
            catch (RemoteException ex) {
                this.mRemoveList.add(r.binder);
            }
        }
        if ((events & 0x40) != 0) {
            try {
                r.callback.onDataConnectionStateChanged(this.mDataConnectionState[phoneId], this.mDataConnectionNetworkType[phoneId]);
            }
            catch (RemoteException ex) {
                this.mRemoveList.add(r.binder);
            }
        }
    }

    private static class Record {
        String callingPackage;
        IBinder binder;
        IPhoneStateListener callback;
        IOnSubscriptionsChangedListener onSubscriptionsChangedListenerCallback;
        int callerUserId;
        int events;
        int subId = -1;
        int phoneId = -1;
        boolean canReadPhoneState;

        private Record() {
        }

        boolean matchPhoneStateListenerEvent(int events) {
            return this.callback != null && (events & this.events) != 0;
        }

        boolean matchOnSubscriptionsChangedListener() {
            return this.onSubscriptionsChangedListenerCallback != null;
        }

        public String toString() {
            return "{callingPackage=" + this.callingPackage + " binder=" + this.binder + " callback=" + this.callback + " onSubscriptionsChangedListenererCallback=" + this.onSubscriptionsChangedListenerCallback + " callerUserId=" + this.callerUserId + " subId=" + this.subId + " phoneId=" + this.phoneId + " events=" + Integer.toHexString(this.events) + " canReadPhoneState=" + this.canReadPhoneState + "}";
        }
    }
}

