/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.content.Context;
import android.net.IIpSecService;
import android.net.INetd;
import android.net.IpSecAlgorithm;
import android.net.IpSecConfig;
import android.net.IpSecSpiResponse;
import android.net.IpSecTransformResponse;
import android.net.IpSecUdpEncapResponse;
import android.net.util.NetdService;
import android.os.Binder;
import android.os.IBinder;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.os.ServiceSpecificException;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.util.Log;
import android.util.Slog;
import android.util.SparseArray;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.Preconditions;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.concurrent.atomic.AtomicInteger;
import libcore.io.IoUtils;

public class IpSecService
extends IIpSecService.Stub {
    private static final String TAG = "IpSecService";
    private static final boolean DBG = Log.isLoggable("IpSecService", 3);
    private static final String NETD_SERVICE_NAME = "netd";
    private static final int[] DIRECTIONS = new int[]{1, 0};
    private static final int NETD_FETCH_TIMEOUT = 5000;
    private static final int MAX_PORT_BIND_ATTEMPTS = 10;
    private static final InetAddress INADDR_ANY;
    static final int FREE_PORT_MIN = 1024;
    static final int PORT_MAX = 65535;
    private final Context mContext;
    private static AtomicInteger mNextResourceId;
    @GuardedBy(value="this")
    private final ManagedResourceArray<SpiRecord> mSpiRecords = new ManagedResourceArray();
    @GuardedBy(value="this")
    private final ManagedResourceArray<TransformRecord> mTransformRecords = new ManagedResourceArray();
    @GuardedBy(value="this")
    private final ManagedResourceArray<UdpSocketRecord> mUdpSocketRecords = new ManagedResourceArray();

    private IpSecService(Context context) {
        this.mContext = context;
    }

    static IpSecService create(Context context) throws InterruptedException {
        IpSecService service = new IpSecService(context);
        service.connectNativeNetdService();
        return service;
    }

    public void systemReady() {
        if (this.isNetdAlive()) {
            Slog.d(TAG, "IpSecService is ready");
        } else {
            Slog.wtf(TAG, "IpSecService not ready: failed to connect to NetD Native Service!");
        }
    }

    private void connectNativeNetdService() {
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                IpSecService ipSecService = IpSecService.this;
                synchronized (ipSecService) {
                    NetdService.get(5000L);
                }
            }
        }.start();
    }

    INetd getNetdInstance() throws RemoteException {
        INetd netd = NetdService.getInstance();
        if (netd == null) {
            throw new RemoteException("Failed to Get Netd Instance");
        }
        return netd;
    }

    synchronized boolean isNetdAlive() {
        try {
            INetd netd = this.getNetdInstance();
            if (netd == null) {
                return false;
            }
            return netd.isAlive();
        }
        catch (RemoteException re) {
            return false;
        }
    }

    @Override
    public synchronized IpSecSpiResponse reserveSecurityParameterIndex(int direction, String remoteAddress, int requestedSpi, IBinder binder) throws RemoteException {
        int resourceId = mNextResourceId.getAndIncrement();
        int spi = 0;
        String localAddress = "";
        try {
            spi = this.getNetdInstance().ipSecAllocateSpi(resourceId, direction, localAddress, remoteAddress, requestedSpi);
            Log.d(TAG, "Allocated SPI " + spi);
            this.mSpiRecords.put(resourceId, new SpiRecord(resourceId, binder, direction, localAddress, remoteAddress, spi));
        }
        catch (ServiceSpecificException e) {
            return new IpSecSpiResponse(2, 0, spi);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        return new IpSecSpiResponse(0, resourceId, spi);
    }

    private synchronized <T extends ManagedResource> void releaseManagedResource(ManagedResourceArray<T> resArray, int resourceId, String typeName) throws RemoteException {
        T record = resArray.get(resourceId);
        if (record == null) {
            throw new IllegalArgumentException(typeName + " " + resourceId + " is not available to be deleted");
        }
        ((ManagedResource)record).release();
        resArray.remove(resourceId);
    }

    @Override
    public void releaseSecurityParameterIndex(int resourceId) throws RemoteException {
        this.releaseManagedResource(this.mSpiRecords, resourceId, "SecurityParameterIndex");
    }

    private void bindToRandomPort(FileDescriptor sockFd) throws IOException {
        for (int i = 10; i > 0; --i) {
            try {
                FileDescriptor probeSocket = Os.socket(OsConstants.AF_INET, OsConstants.SOCK_DGRAM, OsConstants.IPPROTO_UDP);
                Os.bind(probeSocket, INADDR_ANY, 0);
                int port = ((InetSocketAddress)Os.getsockname(probeSocket)).getPort();
                Os.close(probeSocket);
                Log.v(TAG, "Binding to port " + port);
                Os.bind(sockFd, INADDR_ANY, port);
                return;
            }
            catch (ErrnoException e) {
                if (e.errno == OsConstants.EADDRINUSE) continue;
                throw e.rethrowAsIOException();
            }
        }
        throw new IOException("Failed 10 attempts to bind to a port");
    }

    @Override
    public synchronized IpSecUdpEncapResponse openUdpEncapsulationSocket(int port, IBinder binder) throws RemoteException {
        if (port != 0 && (port < 1024 || port > 65535)) {
            throw new IllegalArgumentException("Specified port number must be a valid non-reserved UDP port");
        }
        int resourceId = mNextResourceId.getAndIncrement();
        FileDescriptor sockFd = null;
        try {
            sockFd = Os.socket(OsConstants.AF_INET, OsConstants.SOCK_DGRAM, OsConstants.IPPROTO_UDP);
            if (port != 0) {
                Log.v(TAG, "Binding to port " + port);
                Os.bind(sockFd, INADDR_ANY, port);
            } else {
                this.bindToRandomPort(sockFd);
            }
            Os.setsockoptInt(sockFd, OsConstants.IPPROTO_UDP, OsConstants.UDP_ENCAP, OsConstants.UDP_ENCAP_ESPINUDP);
            this.mUdpSocketRecords.put(resourceId, new UdpSocketRecord(resourceId, binder, sockFd, port));
            return new IpSecUdpEncapResponse(0, resourceId, port, sockFd);
        }
        catch (ErrnoException | IOException e) {
            IoUtils.closeQuietly(sockFd);
            return new IpSecUdpEncapResponse(1);
        }
    }

    @Override
    public void closeUdpEncapsulationSocket(int resourceId) throws RemoteException {
        this.releaseManagedResource(this.mUdpSocketRecords, resourceId, "UdpEncapsulationSocket");
    }

    @Override
    public synchronized IpSecTransformResponse createTransportModeTransform(IpSecConfig c, IBinder binder) throws RemoteException {
        int resourceId = mNextResourceId.getAndIncrement();
        SpiRecord[] spis = new SpiRecord[DIRECTIONS.length];
        int encapLocalPort = 0;
        int encapRemotePort = 0;
        UdpSocketRecord socketRecord = null;
        int encapType = c.getEncapType();
        if (encapType != 0) {
            socketRecord = this.mUdpSocketRecords.get(c.getEncapLocalResourceId());
            encapLocalPort = socketRecord.getPort();
            encapRemotePort = c.getEncapRemotePort();
        }
        for (int direction : DIRECTIONS) {
            IpSecAlgorithm auth = c.getAuthentication(direction);
            IpSecAlgorithm crypt = c.getEncryption(direction);
            spis[direction] = this.mSpiRecords.get(c.getSpiResourceId(direction));
            int spi = spis[direction].getSpi();
            try {
                this.getNetdInstance().ipSecAddSecurityAssociation(resourceId, c.getMode(), direction, c.getLocalAddress() != null ? c.getLocalAddress().getHostAddress() : "", c.getRemoteAddress() != null ? c.getRemoteAddress().getHostAddress() : "", c.getNetwork() != null ? c.getNetwork().getNetworkHandle() : 0L, spi, auth != null ? auth.getName() : "", auth != null ? auth.getKey() : null, auth != null ? auth.getTruncationLengthBits() : 0, crypt != null ? crypt.getName() : "", crypt != null ? crypt.getKey() : null, crypt != null ? crypt.getTruncationLengthBits() : 0, encapType, encapLocalPort, encapRemotePort);
            }
            catch (ServiceSpecificException e) {
                return new IpSecTransformResponse(1);
            }
        }
        this.mTransformRecords.put(resourceId, new TransformRecord(resourceId, binder, c, spis, socketRecord));
        return new IpSecTransformResponse(0, resourceId);
    }

    @Override
    public void deleteTransportModeTransform(int resourceId) throws RemoteException {
        this.releaseManagedResource(this.mTransformRecords, resourceId, "IpSecTransform");
    }

    @Override
    public synchronized void applyTransportModeTransform(ParcelFileDescriptor socket, int resourceId) throws RemoteException {
        TransformRecord info = this.mTransformRecords.get(resourceId);
        if (info == null) {
            throw new IllegalArgumentException("Transform " + resourceId + " is not active");
        }
        if (info.pid != IpSecService.getCallingPid() || info.uid != IpSecService.getCallingUid()) {
            throw new SecurityException("Only the owner of an IpSec Transform may apply it!");
        }
        IpSecConfig c = info.getConfig();
        try {
            for (int direction : DIRECTIONS) {
                this.getNetdInstance().ipSecApplyTransportModeTransform(socket.getFileDescriptor(), resourceId, direction, c.getLocalAddress() != null ? c.getLocalAddress().getHostAddress() : "", c.getRemoteAddress() != null ? c.getRemoteAddress().getHostAddress() : "", info.getSpiRecord(direction).getSpi());
            }
        }
        catch (ServiceSpecificException serviceSpecificException) {
            // empty catch block
        }
    }

    @Override
    public void removeTransportModeTransform(ParcelFileDescriptor socket, int resourceId) throws RemoteException {
        try {
            this.getNetdInstance().ipSecRemoveTransportModeTransform(socket.getFileDescriptor());
        }
        catch (ServiceSpecificException serviceSpecificException) {
            // empty catch block
        }
    }

    @Override
    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.DUMP", TAG);
        pw.println("IpSecService Log:");
        pw.println("NetdNativeService Connection: " + (this.isNetdAlive() ? "alive" : "dead"));
        pw.println();
    }

    static {
        try {
            INADDR_ANY = InetAddress.getByAddress(new byte[]{0, 0, 0, 0});
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
        mNextResourceId = new AtomicInteger(16441040);
    }

    private final class UdpSocketRecord
    extends ManagedResource {
        private FileDescriptor mSocket;
        private final int mPort;

        UdpSocketRecord(int resourceId, IBinder binder, FileDescriptor socket, int port) {
            super(resourceId, binder);
            this.mSocket = socket;
            this.mPort = port;
        }

        @Override
        protected void releaseResources() {
            Log.d(IpSecService.TAG, "Closing port " + this.mPort);
            IoUtils.closeQuietly(this.mSocket);
            this.mSocket = null;
        }

        public int getPort() {
            return this.mPort;
        }

        public FileDescriptor getSocket() {
            return this.mSocket;
        }
    }

    private final class SpiRecord
    extends ManagedResource {
        private final int mDirection;
        private final String mLocalAddress;
        private final String mRemoteAddress;
        private int mSpi;
        private boolean mOwnedByTransform;

        SpiRecord(int resourceId, IBinder binder, int direction, String localAddress, String remoteAddress, int spi) {
            super(resourceId, binder);
            this.mOwnedByTransform = false;
            this.mDirection = direction;
            this.mLocalAddress = localAddress;
            this.mRemoteAddress = remoteAddress;
            this.mSpi = spi;
        }

        @Override
        protected void releaseResources() {
            if (this.mOwnedByTransform) {
                Log.d(IpSecService.TAG, "Cannot release Spi " + this.mSpi + ": Currently locked by a Transform");
                return;
            }
            try {
                IpSecService.this.getNetdInstance().ipSecDeleteSecurityAssociation(this.mResourceId, this.mDirection, this.mLocalAddress, this.mRemoteAddress, this.mSpi);
            }
            catch (ServiceSpecificException serviceSpecificException) {
            }
            catch (RemoteException e) {
                Log.e(IpSecService.TAG, "Failed to delete SPI reservation with ID: " + this.mResourceId);
            }
            this.mSpi = 0;
        }

        public int getSpi() {
            return this.mSpi;
        }

        public void setOwnedByTransform() {
            if (this.mOwnedByTransform) {
                throw new IllegalStateException("Cannot own an SPI twice!");
            }
            this.mOwnedByTransform = true;
        }
    }

    private final class TransformRecord
    extends ManagedResource {
        private final IpSecConfig mConfig;
        private final SpiRecord[] mSpis;
        private final UdpSocketRecord mSocket;

        TransformRecord(int resourceId, IBinder binder, IpSecConfig config, SpiRecord[] spis, UdpSocketRecord socket) {
            super(resourceId, binder);
            this.mConfig = config;
            this.mSpis = spis;
            this.mSocket = socket;
            for (int direction : DIRECTIONS) {
                this.mSpis[direction].addReference();
                this.mSpis[direction].setOwnedByTransform();
            }
            if (this.mSocket != null) {
                this.mSocket.addReference();
            }
        }

        public IpSecConfig getConfig() {
            return this.mConfig;
        }

        public SpiRecord getSpiRecord(int direction) {
            return this.mSpis[direction];
        }

        @Override
        protected void releaseResources() {
            for (int direction : DIRECTIONS) {
                int spi = this.mSpis[direction].getSpi();
                try {
                    IpSecService.this.getNetdInstance().ipSecDeleteSecurityAssociation(this.mResourceId, direction, this.mConfig.getLocalAddress() != null ? this.mConfig.getLocalAddress().getHostAddress() : "", this.mConfig.getRemoteAddress() != null ? this.mConfig.getRemoteAddress().getHostAddress() : "", spi);
                }
                catch (ServiceSpecificException serviceSpecificException) {
                }
                catch (RemoteException e) {
                    Log.e(IpSecService.TAG, "Failed to delete SA with ID: " + this.mResourceId);
                }
            }
            for (int direction : DIRECTIONS) {
                this.mSpis[direction].removeReference();
            }
            if (this.mSocket != null) {
                this.mSocket.removeReference();
            }
        }
    }

    private class ManagedResourceArray<T extends ManagedResource> {
        SparseArray<T> mArray = new SparseArray();

        private ManagedResourceArray() {
        }

        T get(int key) {
            ManagedResource val = (ManagedResource)this.mArray.get(key);
            if (val != null) {
                val.checkOwnerOrSystemAndThrow();
            }
            return (T)val;
        }

        void put(int key, T obj) {
            Preconditions.checkNotNull(obj, "Null resources cannot be added");
            this.mArray.put(key, obj);
        }

        void remove(int key) {
            this.mArray.remove(key);
        }
    }

    private abstract class ManagedResource
    implements IBinder.DeathRecipient {
        final int pid;
        final int uid;
        private IBinder mBinder;
        protected int mResourceId;
        private AtomicInteger mReferenceCount = new AtomicInteger(0);

        ManagedResource(int resourceId, IBinder binder) {
            this.mBinder = binder;
            this.mResourceId = resourceId;
            this.pid = Binder.getCallingPid();
            this.uid = Binder.getCallingUid();
            try {
                this.mBinder.linkToDeath(this, 0);
            }
            catch (RemoteException e) {
                this.binderDied();
            }
        }

        public void addReference() {
            this.mReferenceCount.incrementAndGet();
        }

        public void removeReference() {
            if (this.mReferenceCount.decrementAndGet() < 0) {
                Log.wtf(IpSecService.TAG, "Programming error: negative reference count");
            }
        }

        public boolean isReferenced() {
            return this.mReferenceCount.get() > 0;
        }

        public void checkOwnerOrSystemAndThrow() {
            if (this.uid != Binder.getCallingUid() && 1000 != Binder.getCallingUid()) {
                throw new SecurityException("Only the owner may access managed resources!");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void release() throws RemoteException {
            IpSecService ipSecService = IpSecService.this;
            synchronized (ipSecService) {
                if (this.isReferenced()) {
                    throw new IllegalStateException("Cannot release a resource that has active references!");
                }
                if (this.mResourceId == 0) {
                    return;
                }
                this.releaseResources();
                if (this.mBinder != null) {
                    this.mBinder.unlinkToDeath(this, 0);
                }
                this.mBinder = null;
                this.mResourceId = 0;
            }
        }

        @Override
        public final void binderDied() {
            try {
                this.release();
            }
            catch (Exception e) {
                Log.e(IpSecService.TAG, "Failed to release resource: " + e);
            }
        }

        protected abstract void releaseResources() throws RemoteException;
    }
}

