/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.conscrypt;

import com.android.org.conscrypt.AbstractSessionContext;
import com.android.org.conscrypt.NativeCrypto;
import com.android.org.conscrypt.SSLServerSessionCache;
import com.android.org.conscrypt.SslSessionWrapper;

public final class ServerSessionContext
extends AbstractSessionContext {
    private SSLServerSessionCache persistentCache;

    ServerSessionContext() {
        super(100);
        NativeCrypto.SSL_CTX_set_session_id_context(this.sslCtxNativePointer, new byte[]{32});
    }

    public void setPersistentCache(SSLServerSessionCache persistentCache) {
        this.persistentCache = persistentCache;
    }

    @Override
    SslSessionWrapper getSessionFromPersistentCache(byte[] sessionId) {
        SslSessionWrapper session;
        byte[] data;
        if (this.persistentCache != null && (data = this.persistentCache.getSessionData(sessionId)) != null && (session = SslSessionWrapper.newInstance(this, data, null, -1)) != null && session.isValid()) {
            this.cacheSession(session);
            return session;
        }
        return null;
    }

    @Override
    void onBeforeAddSession(SslSessionWrapper session) {
        byte[] data;
        if (this.persistentCache != null && (data = session.toBytes()) != null) {
            this.persistentCache.putSessionData(session.toSSLSession(), data);
        }
    }

    @Override
    void onBeforeRemoveSession(SslSessionWrapper session) {
    }
}

