/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.conscrypt;

import com.android.org.conscrypt.AbstractSessionContext;
import com.android.org.conscrypt.EmptyArray;
import com.android.org.conscrypt.OpenSSLX509Certificate;
import com.android.org.conscrypt.Preconditions;
import com.android.org.conscrypt.SSLUtils;
import com.android.org.conscrypt.SslWrapper;
import java.security.Principal;
import java.security.cert.Certificate;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionBindingEvent;
import javax.net.ssl.SSLSessionBindingListener;
import javax.net.ssl.SSLSessionContext;
import javax.security.cert.X509Certificate;

final class ActiveSession
implements SSLSession {
    private final SslWrapper ssl;
    private AbstractSessionContext sessionContext;
    private byte[] id;
    private long creationTime;
    private String cipherSuite;
    private String protocol;
    private String peerHost;
    private int peerPort = -1;
    private long lastAccessedTime = 0L;
    private volatile X509Certificate[] peerCertificateChain;
    private java.security.cert.X509Certificate[] localCertificates;
    private java.security.cert.X509Certificate[] peerCertificates;
    private byte[] peerCertificateOcspData;
    private byte[] peerTlsSctData;
    private Map<String, Object> values;

    ActiveSession(SslWrapper ssl, AbstractSessionContext sessionContext) {
        this.ssl = Preconditions.checkNotNull(ssl, "ssl");
        this.sessionContext = Preconditions.checkNotNull(sessionContext, "sessionContext");
    }

    @Override
    public byte[] getId() {
        if (this.id == null) {
            this.id = this.ssl.getSessionId();
        }
        return this.id != null ? (byte[])this.id.clone() : EmptyArray.BYTE;
    }

    void resetId() {
        this.id = null;
    }

    @Override
    public SSLSessionContext getSessionContext() {
        return this.isValid() ? this.sessionContext : null;
    }

    @Override
    public long getCreationTime() {
        if (this.creationTime == 0L) {
            this.creationTime = this.ssl.getTime();
        }
        return this.creationTime;
    }

    @Override
    public long getLastAccessedTime() {
        return this.lastAccessedTime == 0L ? this.getCreationTime() : this.lastAccessedTime;
    }

    void setLastAccessedTime(long accessTimeMillis) {
        this.lastAccessedTime = accessTimeMillis;
    }

    public List<byte[]> getStatusResponses() {
        if (this.peerCertificateOcspData == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(this.peerCertificateOcspData.clone());
    }

    byte[] getPeerSignedCertificateTimestamp() {
        if (this.peerTlsSctData == null) {
            return null;
        }
        return (byte[])this.peerTlsSctData.clone();
    }

    String getRequestedServerName() {
        return this.ssl.getRequestedServerName();
    }

    @Override
    public void invalidate() {
        this.ssl.setTimeout(0L);
    }

    @Override
    public boolean isValid() {
        long creationTimeMillis = this.ssl.getTime();
        long timeoutMillis = this.ssl.getTimeout();
        return System.currentTimeMillis() - timeoutMillis < creationTimeMillis;
    }

    @Override
    public void putValue(String name, Object value) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        Map<String, Object> values = this.values;
        if (values == null) {
            values = this.values = new HashMap<String, Object>(2);
        }
        Object old = values.put(name, value);
        if (value instanceof SSLSessionBindingListener) {
            ((SSLSessionBindingListener)value).valueBound(new SSLSessionBindingEvent(this, name));
        }
        if (old instanceof SSLSessionBindingListener) {
            ((SSLSessionBindingListener)old).valueUnbound(new SSLSessionBindingEvent(this, name));
        }
        this.notifyUnbound(old, name);
    }

    @Override
    public Object getValue(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (this.values == null) {
            return null;
        }
        return this.values.get(name);
    }

    @Override
    public void removeValue(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        Map<String, Object> values = this.values;
        if (values == null) {
            return;
        }
        Object old = values.remove(name);
        this.notifyUnbound(old, name);
    }

    @Override
    public String[] getValueNames() {
        Map<String, Object> values = this.values;
        if (values == null || values.isEmpty()) {
            return EmptyArray.STRING;
        }
        return values.keySet().toArray(new String[values.size()]);
    }

    public java.security.cert.X509Certificate[] getPeerCertificates() throws SSLPeerUnverifiedException {
        this.checkPeerCertificatesPresent();
        return (java.security.cert.X509Certificate[])this.peerCertificates.clone();
    }

    @Override
    public Certificate[] getLocalCertificates() {
        return this.localCertificates == null ? null : (java.security.cert.X509Certificate[])this.localCertificates.clone();
    }

    @Override
    public X509Certificate[] getPeerCertificateChain() throws SSLPeerUnverifiedException {
        this.checkPeerCertificatesPresent();
        X509Certificate[] result = this.peerCertificateChain;
        if (result == null) {
            result = SSLUtils.toCertificateChain(this.peerCertificates);
            this.peerCertificateChain = result;
        }
        return result;
    }

    @Override
    public Principal getPeerPrincipal() throws SSLPeerUnverifiedException {
        this.checkPeerCertificatesPresent();
        return this.peerCertificates[0].getSubjectX500Principal();
    }

    @Override
    public Principal getLocalPrincipal() {
        if (this.localCertificates != null && this.localCertificates.length > 0) {
            return this.localCertificates[0].getSubjectX500Principal();
        }
        return null;
    }

    @Override
    public String getCipherSuite() {
        if (this.cipherSuite == null) {
            this.cipherSuite = this.ssl.getCipherSuite();
        }
        return this.cipherSuite;
    }

    @Override
    public String getProtocol() {
        String protocol = this.protocol;
        if (protocol == null) {
            this.protocol = protocol = this.ssl.getVersion();
        }
        return protocol;
    }

    @Override
    public String getPeerHost() {
        return this.peerHost;
    }

    @Override
    public int getPeerPort() {
        return this.peerPort;
    }

    @Override
    public int getPacketBufferSize() {
        return 16709;
    }

    @Override
    public int getApplicationBufferSize() {
        return 16384;
    }

    void onPeerCertificatesReceived(String peerHost, int peerPort, OpenSSLX509Certificate[] peerCertificates) {
        this.configurePeer(peerHost, peerPort, peerCertificates);
    }

    void onSessionEstablished(String peerHost, int peerPort) {
        this.id = null;
        this.localCertificates = this.ssl.getLocalCertificates();
        this.configurePeer(peerHost, peerPort, this.ssl.getPeerCertificates());
    }

    private void configurePeer(String peerHost, int peerPort, OpenSSLX509Certificate[] peerCertificates) {
        this.peerHost = peerHost;
        this.peerPort = peerPort;
        this.peerCertificates = peerCertificates;
        this.peerCertificateOcspData = this.ssl.getPeerCertificateOcspData();
        this.peerTlsSctData = this.ssl.getPeerTlsSctData();
    }

    private java.security.cert.X509Certificate[] getX509PeerCertificates() throws SSLPeerUnverifiedException {
        if (this.peerCertificates == null || this.peerCertificates.length == 0) {
            throw new SSLPeerUnverifiedException("No peer certificates");
        }
        return this.peerCertificates;
    }

    private void checkPeerCertificatesPresent() throws SSLPeerUnverifiedException {
        if (this.peerCertificates == null || this.peerCertificates.length == 0) {
            throw new SSLPeerUnverifiedException("No peer certificates");
        }
    }

    private void notifyUnbound(Object value, String name) {
        if (value instanceof SSLSessionBindingListener) {
            ((SSLSessionBindingListener)value).valueUnbound(new SSLSessionBindingEvent(this, name));
        }
    }
}

