/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view;

import android.os.Handler;
import android.os.Message;
import android.view.Choreographer;
import android.view.Display;

public class SurfaceFlingerVsyncChoreographer {
    private static final long ONE_MS_IN_NS = 1000000L;
    private static final long ONE_S_IN_NS = 1000000000L;
    private final Handler mHandler;
    private final Choreographer mChoreographer;
    private long mSurfaceFlingerOffsetMs;

    public SurfaceFlingerVsyncChoreographer(Handler handler, Display display, Choreographer choreographer) {
        this.mHandler = handler;
        this.mChoreographer = choreographer;
        this.mSurfaceFlingerOffsetMs = this.calculateAppSurfaceFlingerVsyncOffsetMs(display);
    }

    public long getSurfaceFlingerOffsetMs() {
        return this.mSurfaceFlingerOffsetMs;
    }

    private long calculateAppSurfaceFlingerVsyncOffsetMs(Display display) {
        long vsyncPeriod = (long)(1.0E9f / display.getRefreshRate());
        long sfVsyncOffset = vsyncPeriod - (display.getPresentationDeadlineNanos() - 1000000L);
        return Math.max(0L, (sfVsyncOffset - display.getAppVsyncOffsetNanos()) / 1000000L);
    }

    public void scheduleAtSfVsync(Runnable r) {
        long delay = this.calculateDelay();
        if (delay <= 0L) {
            r.run();
        } else {
            this.mHandler.postDelayed(r, delay);
        }
    }

    public void scheduleAtSfVsync(Handler h, Message m) {
        long delay = this.calculateDelay();
        if (delay <= 0L) {
            h.handleMessage(m);
        } else {
            m.setAsynchronous(true);
            h.sendMessageDelayed(m, delay);
        }
    }

    private long calculateDelay() {
        long sinceFrameStart = System.nanoTime() - this.mChoreographer.getLastFrameTimeNanos();
        return this.mSurfaceFlingerOffsetMs - sinceFrameStart / 1000000L;
    }
}

