/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.imsphone;

import android.telecom.ConferenceParticipant;
import android.telephony.Rlog;
import com.android.ims.ImsCall;
import com.android.ims.ImsException;
import com.android.ims.ImsStreamMediaProfile;
import com.android.internal.telephony.Call;
import com.android.internal.telephony.CallStateException;
import com.android.internal.telephony.Connection;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.imsphone.ImsPhoneCallTracker;
import com.android.internal.telephony.imsphone.ImsPhoneConnection;
import java.util.List;

public class ImsPhoneCall
extends Call {
    private static final String LOG_TAG = "ImsPhoneCall";
    private static final boolean FORCE_DEBUG = false;
    private static final boolean DBG = Rlog.isLoggable("ImsPhoneCall", 3);
    private static final boolean VDBG = Rlog.isLoggable("ImsPhoneCall", 2);
    public static final String CONTEXT_UNKNOWN = "UK";
    public static final String CONTEXT_RINGING = "RG";
    public static final String CONTEXT_FOREGROUND = "FG";
    public static final String CONTEXT_BACKGROUND = "BG";
    public static final String CONTEXT_HANDOVER = "HO";
    ImsPhoneCallTracker mOwner;
    private boolean mRingbackTonePlayed = false;
    private final String mCallContext;

    ImsPhoneCall() {
        this.mCallContext = CONTEXT_UNKNOWN;
    }

    public ImsPhoneCall(ImsPhoneCallTracker owner, String context) {
        this.mOwner = owner;
        this.mCallContext = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        try {
            this.mOwner.hangup(this);
        }
        catch (CallStateException i) {
            int s = this.mConnections.size();
            for (int i2 = 0; i2 < s; ++i2) {
                ImsPhoneConnection c = (ImsPhoneConnection)this.mConnections.get(i2);
                c.onDisconnect(14);
            }
        }
        finally {
            int s = this.mConnections.size();
            for (int i = 0; i < s; ++i) {
                ImsPhoneConnection c = (ImsPhoneConnection)this.mConnections.get(i);
                c.onDisconnect(14);
            }
        }
    }

    @Override
    public List<Connection> getConnections() {
        return this.mConnections;
    }

    @Override
    public Phone getPhone() {
        return this.mOwner.mPhone;
    }

    @Override
    public boolean isMultiparty() {
        ImsCall imsCall = this.getImsCall();
        if (imsCall == null) {
            return false;
        }
        return imsCall.isMultiparty();
    }

    @Override
    public void hangup() throws CallStateException {
        this.mOwner.hangup(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[ImsPhoneCall ");
        sb.append(this.mCallContext);
        sb.append(" state: ");
        sb.append(this.mState.toString());
        sb.append(" ");
        if (this.mConnections.size() > 1) {
            sb.append(" ERROR_MULTIPLE ");
        }
        for (Connection conn : this.mConnections) {
            sb.append(conn);
            sb.append(" ");
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public List<ConferenceParticipant> getConferenceParticipants() {
        ImsCall call = this.getImsCall();
        if (call == null) {
            return null;
        }
        return call.getConferenceParticipants();
    }

    public void attach(Connection conn) {
        if (VDBG) {
            Rlog.v(LOG_TAG, "attach : " + this.mCallContext + " conn = " + conn);
        }
        this.clearDisconnected();
        this.mConnections.add(conn);
        this.mOwner.logState();
    }

    public void attach(Connection conn, Call.State state) {
        if (VDBG) {
            Rlog.v(LOG_TAG, "attach : " + this.mCallContext + " state = " + state.toString());
        }
        this.attach(conn);
        this.mState = state;
    }

    public void attachFake(Connection conn, Call.State state) {
        this.attach(conn, state);
    }

    public boolean connectionDisconnected(ImsPhoneConnection conn) {
        if (this.mState != Call.State.DISCONNECTED) {
            boolean hasOnlyDisconnectedConnections = true;
            int s = this.mConnections.size();
            for (int i = 0; i < s; ++i) {
                if (((Connection)this.mConnections.get(i)).getState() == Call.State.DISCONNECTED) continue;
                hasOnlyDisconnectedConnections = false;
                break;
            }
            if (hasOnlyDisconnectedConnections) {
                this.mState = Call.State.DISCONNECTED;
                if (VDBG) {
                    Rlog.v(LOG_TAG, "connectionDisconnected : " + this.mCallContext + " state = " + (Object)((Object)this.mState));
                }
                return true;
            }
        }
        return false;
    }

    public void detach(ImsPhoneConnection conn) {
        if (VDBG) {
            Rlog.v(LOG_TAG, "detach : " + this.mCallContext + " conn = " + conn);
        }
        this.mConnections.remove(conn);
        this.clearDisconnected();
        this.mOwner.logState();
    }

    boolean isFull() {
        return this.mConnections.size() == 5;
    }

    void onHangupLocal() {
        int s = this.mConnections.size();
        for (int i = 0; i < s; ++i) {
            ImsPhoneConnection cn = (ImsPhoneConnection)this.mConnections.get(i);
            cn.onHangupLocal();
        }
        this.mState = Call.State.DISCONNECTING;
        if (VDBG) {
            Rlog.v(LOG_TAG, "onHangupLocal : " + this.mCallContext + " state = " + (Object)((Object)this.mState));
        }
    }

    ImsPhoneConnection getFirstConnection() {
        if (this.mConnections.size() == 0) {
            return null;
        }
        return (ImsPhoneConnection)this.mConnections.get(0);
    }

    void setMute(boolean mute) {
        ImsCall imsCall;
        ImsCall imsCall2 = imsCall = this.getFirstConnection() == null ? null : this.getFirstConnection().getImsCall();
        if (imsCall != null) {
            try {
                imsCall.setMute(mute);
            }
            catch (ImsException e) {
                Rlog.e(LOG_TAG, "setMute failed : " + e.getMessage());
            }
        }
    }

    void merge(ImsPhoneCall that, Call.State state) {
        ImsPhoneConnection imsPhoneConnection = this.getFirstConnection();
        if (imsPhoneConnection != null) {
            long conferenceConnectTime = imsPhoneConnection.getConferenceConnectTime();
            if (conferenceConnectTime > 0L) {
                imsPhoneConnection.setConnectTime(conferenceConnectTime);
                imsPhoneConnection.setConnectTimeReal(imsPhoneConnection.getConnectTimeReal());
            } else if (DBG) {
                Rlog.d(LOG_TAG, "merge: conference connect time is 0");
            }
        }
        if (DBG) {
            Rlog.d(LOG_TAG, "merge(" + this.mCallContext + "): " + that + "state = " + (Object)((Object)state));
        }
    }

    public ImsCall getImsCall() {
        return this.getFirstConnection() == null ? null : this.getFirstConnection().getImsCall();
    }

    static boolean isLocalTone(ImsCall imsCall) {
        if (imsCall == null || imsCall.getCallProfile() == null || imsCall.getCallProfile().mMediaProfile == null) {
            return false;
        }
        ImsStreamMediaProfile mediaProfile = imsCall.getCallProfile().mMediaProfile;
        return mediaProfile.mAudioDirection == 0;
    }

    public boolean update(ImsPhoneConnection conn, ImsCall imsCall, Call.State state) {
        boolean changed = false;
        Call.State oldState = this.mState;
        if (state == Call.State.ALERTING) {
            if (this.mRingbackTonePlayed && !ImsPhoneCall.isLocalTone(imsCall)) {
                this.mOwner.mPhone.stopRingbackTone();
                this.mRingbackTonePlayed = false;
            } else if (!this.mRingbackTonePlayed && ImsPhoneCall.isLocalTone(imsCall)) {
                this.mOwner.mPhone.startRingbackTone();
                this.mRingbackTonePlayed = true;
            }
        } else if (this.mRingbackTonePlayed) {
            this.mOwner.mPhone.stopRingbackTone();
            this.mRingbackTonePlayed = false;
        }
        if (state != this.mState && state != Call.State.DISCONNECTED) {
            this.mState = state;
            changed = true;
        } else if (state == Call.State.DISCONNECTED) {
            changed = true;
        }
        if (VDBG) {
            Rlog.v(LOG_TAG, "update : " + this.mCallContext + " state: " + (Object)((Object)oldState) + " --> " + (Object)((Object)this.mState));
        }
        return changed;
    }

    ImsPhoneConnection getHandoverConnection() {
        return (ImsPhoneConnection)this.getEarliestConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchWith(ImsPhoneCall that) {
        if (VDBG) {
            Rlog.v(LOG_TAG, "switchWith : switchCall = " + this + " withCall = " + that);
        }
        Class<ImsPhoneCall> clazz = ImsPhoneCall.class;
        synchronized (ImsPhoneCall.class) {
            ImsPhoneCall tmp = new ImsPhoneCall();
            tmp.takeOver(this);
            this.takeOver(that);
            that.takeOver(tmp);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.mOwner.logState();
            return;
        }
    }

    private void takeOver(ImsPhoneCall that) {
        this.mConnections = that.mConnections;
        this.mState = that.mState;
        for (Connection c : this.mConnections) {
            ((ImsPhoneConnection)c).changeParent(this);
        }
    }
}

