/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cat;

import android.os.SystemProperties;
import android.text.TextUtils;
import com.android.internal.telephony.cat.AppInterface;
import com.android.internal.telephony.cat.CatLog;
import com.android.internal.telephony.cat.ResponseData;
import java.io.ByteArrayOutputStream;
import java.util.Calendar;
import java.util.TimeZone;

class DTTZResponseData
extends ResponseData {
    private Calendar mCalendar;

    public DTTZResponseData(Calendar cal) {
        this.mCalendar = cal;
    }

    @Override
    public void format(ByteArrayOutputStream buf) {
        if (buf == null) {
            return;
        }
        int tag = 0x80 | AppInterface.CommandType.PROVIDE_LOCAL_INFORMATION.value();
        buf.write(tag);
        byte[] data = new byte[8];
        data[0] = 7;
        if (this.mCalendar == null) {
            this.mCalendar = Calendar.getInstance();
        }
        data[1] = this.byteToBCD(this.mCalendar.get(1) % 100);
        data[2] = this.byteToBCD(this.mCalendar.get(2) + 1);
        data[3] = this.byteToBCD(this.mCalendar.get(5));
        data[4] = this.byteToBCD(this.mCalendar.get(11));
        data[5] = this.byteToBCD(this.mCalendar.get(12));
        data[6] = this.byteToBCD(this.mCalendar.get(13));
        String tz = SystemProperties.get("persist.sys.timezone", "");
        if (TextUtils.isEmpty(tz)) {
            data[7] = -1;
        } else {
            TimeZone zone = TimeZone.getTimeZone(tz);
            int zoneOffset = zone.getRawOffset() + zone.getDSTSavings();
            data[7] = this.getTZOffSetByte(zoneOffset);
        }
        for (byte b : data) {
            buf.write(b);
        }
    }

    private byte byteToBCD(int value) {
        if (value < 0 && value > 99) {
            CatLog.d(this, "Err: byteToBCD conversion Value is " + value + " Value has to be between 0 and 99");
            return 0;
        }
        return (byte)(value / 10 | value % 10 << 4);
    }

    private byte getTZOffSetByte(long offSetVal) {
        boolean isNegative = offSetVal < 0L;
        long tzOffset = offSetVal / 900000L;
        tzOffset = (long)(isNegative ? -1 : 1) * tzOffset;
        byte bcdVal = this.byteToBCD((int)tzOffset);
        return isNegative ? (bcdVal = (byte)(bcdVal | 8)) : bcdVal;
    }
}

