/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.ContentResolver;
import android.content.Context;
import android.database.ContentObserver;
import android.net.Uri;
import android.os.Handler;
import android.telephony.Rlog;
import java.util.HashMap;
import java.util.Map;

public class SettingsObserver
extends ContentObserver {
    private final Map<Uri, Integer> mUriEventMap = new HashMap<Uri, Integer>();
    private final Context mContext;
    private final Handler mHandler;
    private static final String TAG = "SettingsObserver";

    public SettingsObserver(Context context, Handler handler) {
        super(null);
        this.mContext = context;
        this.mHandler = handler;
    }

    public void observe(Uri uri, int what) {
        this.mUriEventMap.put(uri, what);
        ContentResolver resolver = this.mContext.getContentResolver();
        resolver.registerContentObserver(uri, false, this);
    }

    public void unobserve() {
        ContentResolver resolver = this.mContext.getContentResolver();
        resolver.unregisterContentObserver(this);
    }

    @Override
    public void onChange(boolean selfChange) {
        Rlog.e(TAG, "Should never be reached.");
    }

    @Override
    public void onChange(boolean selfChange, Uri uri) {
        Integer what = this.mUriEventMap.get(uri);
        if (what != null) {
            this.mHandler.obtainMessage(what).sendToTarget();
        } else {
            Rlog.e(TAG, "No matching event to send for URI=" + uri);
        }
    }
}

