/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.app.AlarmManager;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.content.res.Resources;
import android.database.ContentObserver;
import android.hardware.radio.V1_0.CellIdentityCdma;
import android.hardware.radio.V1_0.CellIdentityGsm;
import android.hardware.radio.V1_0.CellIdentityLte;
import android.hardware.radio.V1_0.CellIdentityTdscdma;
import android.hardware.radio.V1_0.DataRegStateResult;
import android.hardware.radio.V1_0.VoiceRegStateResult;
import android.os.AsyncResult;
import android.os.BaseBundle;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.os.PersistableBundle;
import android.os.PowerManager;
import android.os.Registrant;
import android.os.RegistrantList;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.os.WorkSource;
import android.preference.PreferenceManager;
import android.provider.Settings;
import android.provider.Telephony;
import android.telephony.CarrierConfigManager;
import android.telephony.CellIdentityWcdma;
import android.telephony.CellInfo;
import android.telephony.CellInfoGsm;
import android.telephony.CellInfoLte;
import android.telephony.CellInfoWcdma;
import android.telephony.CellLocation;
import android.telephony.Rlog;
import android.telephony.ServiceState;
import android.telephony.SignalStrength;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import android.telephony.cdma.CdmaCellLocation;
import android.telephony.gsm.GsmCellLocation;
import android.text.TextUtils;
import android.util.EventLog;
import android.util.LocalLog;
import android.util.Pair;
import android.util.TimeUtils;
import com.android.internal.telephony.CarrierServiceStateTracker;
import com.android.internal.telephony.CommandException;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.GsmCdmaPhone;
import com.android.internal.telephony.HbpcdUtils;
import com.android.internal.telephony.MccTable;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.ProxyController;
import com.android.internal.telephony.RatRatcheter;
import com.android.internal.telephony.RestrictedState;
import com.android.internal.telephony.SubscriptionController;
import com.android.internal.telephony.cdma.CdmaSubscriptionSourceManager;
import com.android.internal.telephony.dataconnection.DcTracker;
import com.android.internal.telephony.metrics.TelephonyMetrics;
import com.android.internal.telephony.uicc.IccCardApplicationStatus;
import com.android.internal.telephony.uicc.IccRecords;
import com.android.internal.telephony.uicc.RuimRecords;
import com.android.internal.telephony.uicc.UiccCardApplication;
import com.android.internal.telephony.uicc.UiccController;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.IndentingPrintWriter;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.PatternSyntaxException;

public class ServiceStateTracker
extends Handler {
    private static final String LOG_TAG = "SST";
    private static final boolean DBG = true;
    private static final boolean VDBG = false;
    private static final String PROP_FORCE_ROAMING = "telephony.test.forceRoaming";
    private CommandsInterface mCi;
    private UiccController mUiccController = null;
    private UiccCardApplication mUiccApplcation = null;
    private IccRecords mIccRecords = null;
    private boolean mVoiceCapable;
    public ServiceState mSS;
    private ServiceState mNewSS;
    private static final long LAST_CELL_INFO_LIST_MAX_AGE_MS = 2000L;
    private long mLastCellInfoListTime;
    private List<CellInfo> mLastCellInfoList = null;
    private SignalStrength mSignalStrength;
    public RestrictedState mRestrictedState;
    private int[] mPollingContext;
    private boolean mDesiredPowerState;
    private boolean mDontPollSignalStrength = false;
    private RegistrantList mVoiceRoamingOnRegistrants = new RegistrantList();
    private RegistrantList mVoiceRoamingOffRegistrants = new RegistrantList();
    private RegistrantList mDataRoamingOnRegistrants = new RegistrantList();
    private RegistrantList mDataRoamingOffRegistrants = new RegistrantList();
    protected RegistrantList mAttachedRegistrants = new RegistrantList();
    protected RegistrantList mDetachedRegistrants = new RegistrantList();
    private RegistrantList mDataRegStateOrRatChangedRegistrants = new RegistrantList();
    private RegistrantList mNetworkAttachedRegistrants = new RegistrantList();
    private RegistrantList mNetworkDetachedRegistrants = new RegistrantList();
    private RegistrantList mPsRestrictEnabledRegistrants = new RegistrantList();
    private RegistrantList mPsRestrictDisabledRegistrants = new RegistrantList();
    private boolean mPendingRadioPowerOffAfterDataOff = false;
    private int mPendingRadioPowerOffAfterDataOffTag = 0;
    private static final int POLL_PERIOD_MILLIS = 20000;
    public static final int DEFAULT_GPRS_CHECK_PERIOD_MILLIS = 60000;
    protected static final int EVENT_RADIO_STATE_CHANGED = 1;
    protected static final int EVENT_NETWORK_STATE_CHANGED = 2;
    protected static final int EVENT_GET_SIGNAL_STRENGTH = 3;
    protected static final int EVENT_POLL_STATE_REGISTRATION = 4;
    protected static final int EVENT_POLL_STATE_GPRS = 5;
    protected static final int EVENT_POLL_STATE_OPERATOR = 6;
    protected static final int EVENT_POLL_SIGNAL_STRENGTH = 10;
    protected static final int EVENT_NITZ_TIME = 11;
    protected static final int EVENT_SIGNAL_STRENGTH_UPDATE = 12;
    protected static final int EVENT_POLL_STATE_NETWORK_SELECTION_MODE = 14;
    protected static final int EVENT_GET_LOC_DONE = 15;
    protected static final int EVENT_SIM_RECORDS_LOADED = 16;
    protected static final int EVENT_SIM_READY = 17;
    protected static final int EVENT_LOCATION_UPDATES_ENABLED = 18;
    protected static final int EVENT_GET_PREFERRED_NETWORK_TYPE = 19;
    protected static final int EVENT_SET_PREFERRED_NETWORK_TYPE = 20;
    protected static final int EVENT_RESET_PREFERRED_NETWORK_TYPE = 21;
    protected static final int EVENT_CHECK_REPORT_GPRS = 22;
    protected static final int EVENT_RESTRICTED_STATE_CHANGED = 23;
    protected static final int EVENT_RUIM_READY = 26;
    protected static final int EVENT_RUIM_RECORDS_LOADED = 27;
    protected static final int EVENT_POLL_STATE_CDMA_SUBSCRIPTION = 34;
    protected static final int EVENT_NV_READY = 35;
    protected static final int EVENT_ERI_FILE_LOADED = 36;
    protected static final int EVENT_OTA_PROVISION_STATUS_CHANGE = 37;
    protected static final int EVENT_SET_RADIO_POWER_OFF = 38;
    protected static final int EVENT_CDMA_SUBSCRIPTION_SOURCE_CHANGED = 39;
    protected static final int EVENT_CDMA_PRL_VERSION_CHANGED = 40;
    protected static final int EVENT_RADIO_ON = 41;
    public static final int EVENT_ICC_CHANGED = 42;
    protected static final int EVENT_GET_CELL_INFO_LIST = 43;
    protected static final int EVENT_UNSOL_CELL_INFO_LIST = 44;
    protected static final int EVENT_CHANGE_IMS_STATE = 45;
    protected static final int EVENT_IMS_STATE_CHANGED = 46;
    protected static final int EVENT_IMS_STATE_DONE = 47;
    protected static final int EVENT_IMS_CAPABILITY_CHANGED = 48;
    protected static final int EVENT_ALL_DATA_DISCONNECTED = 49;
    protected static final int EVENT_PHONE_TYPE_SWITCHED = 50;
    protected static final int EVENT_RADIO_POWER_FROM_CARRIER = 51;
    protected static final int EVENT_SIM_NOT_INSERTED = 52;
    protected static final String TIMEZONE_PROPERTY = "persist.sys.timezone";
    protected static final String[] GMT_COUNTRY_CODES = new String[]{"bf", "ci", "eh", "fo", "gb", "gh", "gm", "gn", "gw", "ie", "lr", "is", "ma", "ml", "mr", "pt", "sl", "sn", "st", "tg"};
    protected static final String REGISTRATION_DENIED_GEN = "General";
    protected static final String REGISTRATION_DENIED_AUTH = "Authentication Failure";
    private boolean mImsRegistrationOnOff = false;
    private boolean mAlarmSwitch = false;
    private boolean mRadioDisabledByCarrier = false;
    private PendingIntent mRadioOffIntent = null;
    private static final String ACTION_RADIO_OFF = "android.intent.action.ACTION_RADIO_OFF";
    private boolean mPowerOffDelayNeed = true;
    private boolean mDeviceShuttingDown = false;
    private boolean mSpnUpdatePending = false;
    private String mCurSpn = null;
    private String mCurDataSpn = null;
    private String mCurPlmn = null;
    private boolean mCurShowPlmn = false;
    private boolean mCurShowSpn = false;
    private int mSubId = -1;
    private boolean mImsRegistered = false;
    private SubscriptionManager mSubscriptionManager;
    private SubscriptionController mSubscriptionController;
    private final SstSubscriptionsChangedListener mOnSubscriptionsChangedListener = new SstSubscriptionsChangedListener();
    private final RatRatcheter mRatRatcheter;
    private final LocalLog mRoamingLog = new LocalLog(10);
    private final LocalLog mAttachLog = new LocalLog(10);
    private final LocalLog mPhoneTypeLog = new LocalLog(10);
    private final LocalLog mRatLog = new LocalLog(20);
    private final LocalLog mRadioPowerLog = new LocalLog(20);
    private final LocalLog mTimeLog = new LocalLog(15);
    private final LocalLog mTimeZoneLog = new LocalLog(15);
    private GsmCdmaPhone mPhone;
    public CellLocation mCellLoc;
    private CellLocation mNewCellLoc;
    public static final int MS_PER_HOUR = 3600000;
    private static final int MAX_NITZ_YEAR = 2037;
    private boolean mNeedFixZoneAfterNitz = false;
    private int mZoneOffset;
    private boolean mZoneDst;
    private long mZoneTime;
    private boolean mGotCountryCode = false;
    private String mSavedTimeZone;
    private long mSavedTime;
    private long mSavedAtTime;
    private PowerManager.WakeLock mWakeLock;
    public static final String WAKELOCK_TAG = "ServiceStateTracker";
    private ContentResolver mCr;
    private ContentObserver mAutoTimeObserver = new ContentObserver(new Handler()){

        @Override
        public void onChange(boolean selfChange) {
            Rlog.i(ServiceStateTracker.LOG_TAG, "Auto time state changed");
            ServiceStateTracker.this.revertToNitzTime();
        }
    };
    private ContentObserver mAutoTimeZoneObserver = new ContentObserver(new Handler()){

        @Override
        public void onChange(boolean selfChange) {
            Rlog.i(ServiceStateTracker.LOG_TAG, "Auto time zone state changed");
            ServiceStateTracker.this.revertToNitzTimeZone();
        }
    };
    private int mPreferredNetworkType;
    private int mMaxDataCalls = 1;
    private int mNewMaxDataCalls = 1;
    private int mReasonDataDenied = -1;
    private int mNewReasonDataDenied = -1;
    private int mRejectCode;
    private int mNewRejectCode;
    private boolean mGsmRoaming = false;
    private boolean mDataRoaming = false;
    private boolean mEmergencyOnly = false;
    private boolean mNitzUpdatedTime = false;
    private boolean mStartedGprsRegCheck;
    private boolean mReportedGprsNoReg;
    private CarrierServiceStateTracker mCSST;
    private Notification mNotification;
    public static final int PS_ENABLED = 1001;
    public static final int PS_DISABLED = 1002;
    public static final int CS_ENABLED = 1003;
    public static final int CS_DISABLED = 1004;
    public static final int CS_NORMAL_ENABLED = 1005;
    public static final int CS_EMERGENCY_ENABLED = 1006;
    public static final int CS_REJECT_CAUSE_ENABLED = 2001;
    public static final int PS_NOTIFICATION = 888;
    public static final int CS_NOTIFICATION = 999;
    public static final int CS_REJECT_CAUSE_NOTIFICATION = 111;
    private BroadcastReceiver mIntentReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals("android.telephony.action.CARRIER_CONFIG_CHANGED")) {
                ServiceStateTracker.this.updateLteEarfcnLists();
                return;
            }
            if (!ServiceStateTracker.this.mPhone.isPhoneTypeGsm()) {
                ServiceStateTracker.this.loge("Ignoring intent " + intent + " received on CDMA phone");
                return;
            }
            if (intent.getAction().equals("android.intent.action.LOCALE_CHANGED")) {
                ServiceStateTracker.this.updateSpnDisplay();
            } else if (intent.getAction().equals(ServiceStateTracker.ACTION_RADIO_OFF)) {
                ServiceStateTracker.this.mAlarmSwitch = false;
                DcTracker dcTracker = ((ServiceStateTracker)ServiceStateTracker.this).mPhone.mDcTracker;
                ServiceStateTracker.this.powerOffRadioSafely(dcTracker);
            }
        }
    };
    public static final String UNACTIVATED_MIN2_VALUE = "000000";
    public static final String UNACTIVATED_MIN_VALUE = "1111110111";
    private int mCurrentOtaspMode = 0;
    public static final int NITZ_UPDATE_SPACING_DEFAULT = 600000;
    private int mNitzUpdateSpacing = SystemProperties.getInt("ro.nitz_update_spacing", 600000);
    public static final int NITZ_UPDATE_DIFF_DEFAULT = 2000;
    private int mNitzUpdateDiff = SystemProperties.getInt("ro.nitz_update_diff", 2000);
    private int mRoamingIndicator;
    private boolean mIsInPrl;
    private int mDefaultRoamingIndicator;
    private int mRegistrationState = -1;
    private RegistrantList mCdmaForSubscriptionInfoReadyRegistrants = new RegistrantList();
    private String mMdn;
    private int[] mHomeSystemId = null;
    private int[] mHomeNetworkId = null;
    private String mMin;
    private String mPrlVersion;
    private boolean mIsMinInfoReady = false;
    private boolean mIsEriTextLoaded = false;
    private boolean mIsSubscriptionFromRuim = false;
    private CdmaSubscriptionSourceManager mCdmaSSM;
    public static final String INVALID_MCC = "000";
    public static final String DEFAULT_MNC = "00";
    private HbpcdUtils mHbpcdUtils = null;
    private String mRegistrationDeniedReason;
    private String mCurrentCarrier = null;
    private ArrayList<Pair<Integer, Integer>> mEarfcnPairListForRsrpBoost = null;
    private int mLteRsrpBoost = 0;
    private final Object mLteRsrpBoostLock = new Object();
    private static final int INVALID_LTE_EARFCN = -1;
    private SignalStrength mLastSignalStrength = null;
    private boolean mWantContinuousLocationUpdates;
    private boolean mWantSingleLocationUpdate;

    public ServiceStateTracker(GsmCdmaPhone phone, CommandsInterface ci) {
        this.mPhone = phone;
        this.mCi = ci;
        this.mRatRatcheter = new RatRatcheter(this.mPhone);
        this.mVoiceCapable = this.mPhone.getContext().getResources().getBoolean(17957054);
        this.mUiccController = UiccController.getInstance();
        this.mUiccController.registerForIccChanged(this, 42, null);
        this.mCi.setOnSignalStrengthUpdate(this, 12, null);
        this.mCi.registerForCellInfoList(this, 44, null);
        this.mSubscriptionController = SubscriptionController.getInstance();
        this.mSubscriptionManager = SubscriptionManager.from(phone.getContext());
        this.mSubscriptionManager.addOnSubscriptionsChangedListener(this.mOnSubscriptionsChangedListener);
        this.mRestrictedState = new RestrictedState();
        this.mCi.registerForImsNetworkStateChanged(this, 46, null);
        PowerManager powerManager = (PowerManager)phone.getContext().getSystemService("power");
        this.mWakeLock = powerManager.newWakeLock(1, WAKELOCK_TAG);
        this.mCi.registerForRadioStateChanged(this, 1, null);
        this.mCi.registerForNetworkStateChanged(this, 2, null);
        this.mCi.setOnNITZTime(this, 11, null);
        this.mCr = phone.getContext().getContentResolver();
        int airplaneMode = Settings.Global.getInt(this.mCr, "airplane_mode_on", 0);
        int enableCellularOnBoot = Settings.Global.getInt(this.mCr, "enable_cellular_on_boot", 1);
        this.mDesiredPowerState = enableCellularOnBoot > 0 && airplaneMode <= 0;
        this.mRadioPowerLog.log("init : airplane mode = " + airplaneMode + " enableCellularOnBoot = " + enableCellularOnBoot);
        this.mCr.registerContentObserver(Settings.Global.getUriFor("auto_time"), true, this.mAutoTimeObserver);
        this.mCr.registerContentObserver(Settings.Global.getUriFor("auto_time_zone"), true, this.mAutoTimeZoneObserver);
        this.setSignalStrengthDefaultValues();
        this.mPhone.getCarrierActionAgent().registerForCarrierAction(1, this, 51, null, false);
        Context context = this.mPhone.getContext();
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.LOCALE_CHANGED");
        context.registerReceiver(this.mIntentReceiver, filter);
        filter = new IntentFilter();
        filter.addAction(ACTION_RADIO_OFF);
        context.registerReceiver(this.mIntentReceiver, filter);
        filter = new IntentFilter();
        filter.addAction("android.telephony.action.CARRIER_CONFIG_CHANGED");
        context.registerReceiver(this.mIntentReceiver, filter);
        this.mPhone.notifyOtaspChanged(0);
        this.mCi.setOnRestrictedStateChanged(this, 23, null);
        this.updatePhoneType();
        this.mCSST = new CarrierServiceStateTracker(phone, this);
        this.registerForNetworkAttached(this.mCSST, 101, null);
        this.registerForNetworkDetached(this.mCSST, 102, null);
        this.registerForDataConnectionAttached(this.mCSST, 103, null);
        this.registerForDataConnectionDetached(this.mCSST, 104, null);
    }

    public void updatePhoneType() {
        if (this.mSS != null && this.mSS.getVoiceRoaming()) {
            this.mVoiceRoamingOffRegistrants.notifyRegistrants();
        }
        if (this.mSS != null && this.mSS.getDataRoaming()) {
            this.mDataRoamingOffRegistrants.notifyRegistrants();
        }
        if (this.mSS != null && this.mSS.getDataRegState() == 0) {
            this.mDetachedRegistrants.notifyRegistrants();
        }
        this.mSS = new ServiceState();
        this.mNewSS = new ServiceState();
        this.mLastCellInfoListTime = 0L;
        this.mLastCellInfoList = null;
        this.mSignalStrength = new SignalStrength();
        this.mStartedGprsRegCheck = false;
        this.mReportedGprsNoReg = false;
        this.mMdn = null;
        this.mMin = null;
        this.mPrlVersion = null;
        this.mIsMinInfoReady = false;
        this.mNitzUpdatedTime = false;
        this.cancelPollState();
        if (this.mPhone.isPhoneTypeGsm()) {
            if (this.mCdmaSSM != null) {
                this.mCdmaSSM.dispose(this);
            }
            this.mCi.unregisterForCdmaPrlChanged(this);
            this.mPhone.unregisterForEriFileLoaded(this);
            this.mCi.unregisterForCdmaOtaProvision(this);
            this.mPhone.unregisterForSimRecordsLoaded(this);
            this.mCellLoc = new GsmCellLocation();
            this.mNewCellLoc = new GsmCellLocation();
        } else {
            if (this.mPhone.isPhoneTypeCdmaLte()) {
                this.mPhone.registerForSimRecordsLoaded(this, 16, null);
            }
            this.mCellLoc = new CdmaCellLocation();
            this.mNewCellLoc = new CdmaCellLocation();
            this.mCdmaSSM = CdmaSubscriptionSourceManager.getInstance(this.mPhone.getContext(), this.mCi, this, 39, null);
            this.mIsSubscriptionFromRuim = this.mCdmaSSM.getCdmaSubscriptionSource() == 0;
            this.mCi.registerForCdmaPrlChanged(this, 40, null);
            this.mPhone.registerForEriFileLoaded(this, 36, null);
            this.mCi.registerForCdmaOtaProvision(this, 37, null);
            this.mHbpcdUtils = new HbpcdUtils(this.mPhone.getContext());
            this.updateOtaspState();
        }
        this.onUpdateIccAvailability();
        this.mPhone.setSystemProperty("gsm.network.type", ServiceState.rilRadioTechnologyToString(0));
        this.mCi.getSignalStrength(this.obtainMessage(3));
        this.sendMessage(this.obtainMessage(50));
        this.logPhoneTypeChange();
        this.notifyDataRegStateRilRadioTechnologyChanged();
    }

    public void requestShutdown() {
        if (this.mDeviceShuttingDown) {
            return;
        }
        this.mDeviceShuttingDown = true;
        this.mDesiredPowerState = false;
        this.setPowerStateToDesired();
    }

    public void dispose() {
        this.mCi.unSetOnSignalStrengthUpdate(this);
        this.mUiccController.unregisterForIccChanged(this);
        this.mCi.unregisterForCellInfoList(this);
        this.mSubscriptionManager.removeOnSubscriptionsChangedListener(this.mOnSubscriptionsChangedListener);
        this.mCi.unregisterForImsNetworkStateChanged(this);
        this.mPhone.getCarrierActionAgent().unregisterForCarrierAction(this, 1);
    }

    public boolean getDesiredPowerState() {
        return this.mDesiredPowerState;
    }

    public boolean getPowerStateFromCarrier() {
        return !this.mRadioDisabledByCarrier;
    }

    protected boolean notifySignalStrength() {
        boolean notified = false;
        if (!this.mSignalStrength.equals(this.mLastSignalStrength)) {
            try {
                this.mPhone.notifySignalStrength();
                notified = true;
            }
            catch (NullPointerException ex) {
                this.loge("updateSignalStrength() Phone already destroyed: " + ex + "SignalStrength not notified");
            }
        }
        return notified;
    }

    protected void notifyDataRegStateRilRadioTechnologyChanged() {
        int rat = this.mSS.getRilDataRadioTechnology();
        int drs = this.mSS.getDataRegState();
        this.log("notifyDataRegStateRilRadioTechnologyChanged: drs=" + drs + " rat=" + rat);
        this.mPhone.setSystemProperty("gsm.network.type", ServiceState.rilRadioTechnologyToString(rat));
        this.mDataRegStateOrRatChangedRegistrants.notifyResult(new Pair<Integer, Integer>(drs, rat));
    }

    protected void useDataRegStateForDataOnlyDevices() {
        if (!this.mVoiceCapable) {
            this.log("useDataRegStateForDataOnlyDevice: VoiceRegState=" + this.mNewSS.getVoiceRegState() + " DataRegState=" + this.mNewSS.getDataRegState());
            this.mNewSS.setVoiceRegState(this.mNewSS.getDataRegState());
        }
    }

    protected void updatePhoneObject() {
        if (this.mPhone.getContext().getResources().getBoolean(17957035)) {
            boolean isRegistered;
            boolean bl = isRegistered = this.mSS.getVoiceRegState() == 0 || this.mSS.getVoiceRegState() == 2;
            if (!isRegistered) {
                this.log("updatePhoneObject: Ignore update");
                return;
            }
            this.mPhone.updatePhoneObject(this.mSS.getRilVoiceRadioTechnology());
        }
    }

    public void registerForVoiceRoamingOn(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.mVoiceRoamingOnRegistrants.add(r);
        if (this.mSS.getVoiceRoaming()) {
            r.notifyRegistrant();
        }
    }

    public void unregisterForVoiceRoamingOn(Handler h) {
        this.mVoiceRoamingOnRegistrants.remove(h);
    }

    public void registerForVoiceRoamingOff(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.mVoiceRoamingOffRegistrants.add(r);
        if (!this.mSS.getVoiceRoaming()) {
            r.notifyRegistrant();
        }
    }

    public void unregisterForVoiceRoamingOff(Handler h) {
        this.mVoiceRoamingOffRegistrants.remove(h);
    }

    public void registerForDataRoamingOn(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.mDataRoamingOnRegistrants.add(r);
        if (this.mSS.getDataRoaming()) {
            r.notifyRegistrant();
        }
    }

    public void unregisterForDataRoamingOn(Handler h) {
        this.mDataRoamingOnRegistrants.remove(h);
    }

    public void registerForDataRoamingOff(Handler h, int what, Object obj, boolean notifyNow) {
        Registrant r = new Registrant(h, what, obj);
        this.mDataRoamingOffRegistrants.add(r);
        if (notifyNow && !this.mSS.getDataRoaming()) {
            r.notifyRegistrant();
        }
    }

    public void unregisterForDataRoamingOff(Handler h) {
        this.mDataRoamingOffRegistrants.remove(h);
    }

    public void reRegisterNetwork(Message onComplete) {
        this.mCi.getPreferredNetworkType(this.obtainMessage(19, onComplete));
    }

    public void setRadioPower(boolean power) {
        this.mDesiredPowerState = power;
        this.setPowerStateToDesired();
    }

    public void setRadioPowerFromCarrier(boolean enable) {
        this.mRadioDisabledByCarrier = !enable;
        this.setPowerStateToDesired();
    }

    public void enableSingleLocationUpdate() {
        if (this.mWantSingleLocationUpdate || this.mWantContinuousLocationUpdates) {
            return;
        }
        this.mWantSingleLocationUpdate = true;
        this.mCi.setLocationUpdates(true, this.obtainMessage(18));
    }

    public void enableLocationUpdates() {
        if (this.mWantSingleLocationUpdate || this.mWantContinuousLocationUpdates) {
            return;
        }
        this.mWantContinuousLocationUpdates = true;
        this.mCi.setLocationUpdates(true, this.obtainMessage(18));
    }

    protected void disableSingleLocationUpdate() {
        this.mWantSingleLocationUpdate = false;
        if (!this.mWantSingleLocationUpdate && !this.mWantContinuousLocationUpdates) {
            this.mCi.setLocationUpdates(false, null);
        }
    }

    public void disableLocationUpdates() {
        this.mWantContinuousLocationUpdates = false;
        if (!this.mWantSingleLocationUpdate && !this.mWantContinuousLocationUpdates) {
            this.mCi.setLocationUpdates(false, null);
        }
    }

    private void processCellLocationInfo(CellLocation cellLocation, VoiceRegStateResult voiceRegStateResult) {
        if (this.mPhone.isPhoneTypeGsm()) {
            int psc = -1;
            int cid = -1;
            int lac = -1;
            switch (voiceRegStateResult.cellIdentity.cellInfoType) {
                case 1: {
                    if (voiceRegStateResult.cellIdentity.cellIdentityGsm.size() != 1) break;
                    CellIdentityGsm cellIdentityGsm = voiceRegStateResult.cellIdentity.cellIdentityGsm.get(0);
                    cid = cellIdentityGsm.cid;
                    lac = cellIdentityGsm.lac;
                    break;
                }
                case 4: {
                    if (voiceRegStateResult.cellIdentity.cellIdentityWcdma.size() != 1) break;
                    android.hardware.radio.V1_0.CellIdentityWcdma cellIdentityWcdma = voiceRegStateResult.cellIdentity.cellIdentityWcdma.get(0);
                    cid = cellIdentityWcdma.cid;
                    lac = cellIdentityWcdma.lac;
                    psc = cellIdentityWcdma.psc;
                    break;
                }
                case 5: {
                    if (voiceRegStateResult.cellIdentity.cellIdentityTdscdma.size() != 1) break;
                    CellIdentityTdscdma cellIdentityTdscdma = voiceRegStateResult.cellIdentity.cellIdentityTdscdma.get(0);
                    cid = cellIdentityTdscdma.cid;
                    lac = cellIdentityTdscdma.lac;
                    break;
                }
                case 3: {
                    if (voiceRegStateResult.cellIdentity.cellIdentityLte.size() != 1) break;
                    CellIdentityLte cellIdentityLte = voiceRegStateResult.cellIdentity.cellIdentityLte.get(0);
                    cid = cellIdentityLte.ci;
                    lac = cellIdentityLte.tac;
                    break;
                }
            }
            ((GsmCellLocation)cellLocation).setLacAndCid(lac, cid);
            ((GsmCellLocation)cellLocation).setPsc(psc);
        } else {
            int baseStationId = -1;
            int baseStationLatitude = Integer.MAX_VALUE;
            int baseStationLongitude = Integer.MAX_VALUE;
            int systemId = 0;
            int networkId = 0;
            switch (voiceRegStateResult.cellIdentity.cellInfoType) {
                case 2: {
                    if (voiceRegStateResult.cellIdentity.cellIdentityCdma.size() != 1) break;
                    CellIdentityCdma cellIdentityCdma = voiceRegStateResult.cellIdentity.cellIdentityCdma.get(0);
                    baseStationId = cellIdentityCdma.baseStationId;
                    baseStationLatitude = cellIdentityCdma.latitude;
                    baseStationLongitude = cellIdentityCdma.longitude;
                    systemId = cellIdentityCdma.systemId;
                    networkId = cellIdentityCdma.networkId;
                    break;
                }
            }
            if (baseStationLatitude == 0 && baseStationLongitude == 0) {
                baseStationLatitude = Integer.MAX_VALUE;
                baseStationLongitude = Integer.MAX_VALUE;
            }
            ((CdmaCellLocation)cellLocation).setCellLocationData(baseStationId, baseStationLatitude, baseStationLongitude, systemId, networkId);
        }
    }

    private int getLteEarfcn(DataRegStateResult dataRegStateResult) {
        int lteEarfcn = -1;
        switch (dataRegStateResult.cellIdentity.cellInfoType) {
            case 3: {
                if (dataRegStateResult.cellIdentity.cellIdentityLte.size() != 1) break;
                CellIdentityLte cellIdentityLte = dataRegStateResult.cellIdentity.cellIdentityLte.get(0);
                lteEarfcn = cellIdentityLte.earfcn;
                break;
            }
        }
        return lteEarfcn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 38: {
                ServiceStateTracker serviceStateTracker = this;
                synchronized (serviceStateTracker) {
                    if (this.mPendingRadioPowerOffAfterDataOff && msg.arg1 == this.mPendingRadioPowerOffAfterDataOffTag) {
                        this.log("EVENT_SET_RADIO_OFF, turn radio off now.");
                        this.hangupAndPowerOff();
                        ++this.mPendingRadioPowerOffAfterDataOffTag;
                        this.mPendingRadioPowerOffAfterDataOff = false;
                    } else {
                        this.log("EVENT_SET_RADIO_OFF is stale arg1=" + msg.arg1 + "!= tag=" + this.mPendingRadioPowerOffAfterDataOffTag);
                    }
                    break;
                }
            }
            case 42: {
                this.onUpdateIccAvailability();
                break;
            }
            case 43: {
                AsyncResult ar = (AsyncResult)msg.obj;
                CellInfoResult result = (CellInfoResult)ar.userObj;
                Object object = result.lockObj;
                synchronized (object) {
                    if (ar.exception != null) {
                        this.log("EVENT_GET_CELL_INFO_LIST: error ret null, e=" + ar.exception);
                        result.list = null;
                    } else {
                        result.list = (List)ar.result;
                    }
                    this.mLastCellInfoListTime = SystemClock.elapsedRealtime();
                    this.mLastCellInfoList = result.list;
                    result.lockObj.notify();
                    break;
                }
            }
            case 44: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception != null) {
                    this.log("EVENT_UNSOL_CELL_INFO_LIST: error ignoring, e=" + ar.exception);
                    break;
                }
                List list = (List)ar.result;
                this.mLastCellInfoListTime = SystemClock.elapsedRealtime();
                this.mLastCellInfoList = list;
                this.mPhone.notifyCellInfo(list);
                break;
            }
            case 46: {
                this.mCi.getImsRegistrationState(this.obtainMessage(47));
                break;
            }
            case 47: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception != null) break;
                int[] responseArray = (int[])ar.result;
                this.mImsRegistered = responseArray[0] == 1;
                break;
            }
            case 17: {
                this.mOnSubscriptionsChangedListener.mPreviousSubId.set(-1);
                this.pollState();
                this.queueNextSignalStrengthPoll();
                break;
            }
            case 1: 
            case 50: {
                if (!this.mPhone.isPhoneTypeGsm() && this.mCi.getRadioState() == CommandsInterface.RadioState.RADIO_ON) {
                    this.handleCdmaSubscriptionSource(this.mCdmaSSM.getCdmaSubscriptionSource());
                    this.queueNextSignalStrengthPoll();
                }
                this.setPowerStateToDesired();
                this.modemTriggeredPollState();
                break;
            }
            case 2: {
                this.modemTriggeredPollState();
                break;
            }
            case 3: {
                if (!this.mCi.getRadioState().isOn()) {
                    return;
                }
                AsyncResult ar = (AsyncResult)msg.obj;
                this.onSignalStrengthResult(ar);
                this.queueNextSignalStrengthPoll();
                break;
            }
            case 15: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception == null) {
                    this.processCellLocationInfo(this.mCellLoc, (VoiceRegStateResult)ar.result);
                    this.mPhone.notifyLocationChanged();
                }
                this.disableSingleLocationUpdate();
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                AsyncResult ar = (AsyncResult)msg.obj;
                this.handlePollStateResult(msg.what, ar);
                break;
            }
            case 14: {
                this.log("EVENT_POLL_STATE_NETWORK_SELECTION_MODE");
                AsyncResult ar = (AsyncResult)msg.obj;
                if (this.mPhone.isPhoneTypeGsm()) {
                    this.handlePollStateResult(msg.what, ar);
                    break;
                }
                if (ar.exception == null && ar.result != null) {
                    int[] ints = (int[])ar.result;
                    if (ints[0] != 1) break;
                    this.mPhone.setNetworkSelectionModeAutomatic(null);
                    break;
                }
                this.log("Unable to getNetworkSelectionMode");
                break;
            }
            case 10: {
                this.mCi.getSignalStrength(this.obtainMessage(3));
                break;
            }
            case 11: {
                AsyncResult ar = (AsyncResult)msg.obj;
                String nitzString = (String)((Object[])ar.result)[0];
                long nitzReceiveTime = (Long)((Object[])ar.result)[1];
                this.setTimeFromNITZString(nitzString, nitzReceiveTime);
                break;
            }
            case 12: {
                AsyncResult ar = (AsyncResult)msg.obj;
                this.mDontPollSignalStrength = true;
                this.onSignalStrengthResult(ar);
                break;
            }
            case 16: {
                this.log("EVENT_SIM_RECORDS_LOADED: what=" + msg.what);
                this.updatePhoneObject();
                this.updateOtaspState();
                if (!this.mPhone.isPhoneTypeGsm()) break;
                this.updateSpnDisplay();
                break;
            }
            case 18: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception != null) break;
                this.mCi.getVoiceRegistrationState(this.obtainMessage(15, null));
                break;
            }
            case 20: {
                AsyncResult ar = (AsyncResult)msg.obj;
                Message message = this.obtainMessage(21, ar.userObj);
                this.mCi.setPreferredNetworkType(this.mPreferredNetworkType, message);
                break;
            }
            case 21: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.userObj == null) break;
                AsyncResult.forMessage((Message)((Message)ar.userObj)).exception = ar.exception;
                ((Message)ar.userObj).sendToTarget();
                break;
            }
            case 19: {
                AsyncResult ar = (AsyncResult)msg.obj;
                this.mPreferredNetworkType = ar.exception == null ? ((int[])ar.result)[0] : 7;
                Message message = this.obtainMessage(20, ar.userObj);
                int toggledNetworkType = 7;
                this.mCi.setPreferredNetworkType(toggledNetworkType, message);
                break;
            }
            case 22: {
                if (this.mPhone.isPhoneTypeGsm() && this.mSS != null && !this.isGprsConsistent(this.mSS.getDataRegState(), this.mSS.getVoiceRegState())) {
                    GsmCellLocation loc = (GsmCellLocation)this.mPhone.getCellLocation();
                    EventLog.writeEvent(50107, this.mSS.getOperatorNumeric(), loc != null ? loc.getCid() : -1);
                    this.mReportedGprsNoReg = true;
                }
                this.mStartedGprsRegCheck = false;
                break;
            }
            case 23: {
                if (!this.mPhone.isPhoneTypeGsm()) break;
                this.log("EVENT_RESTRICTED_STATE_CHANGED");
                AsyncResult ar = (AsyncResult)msg.obj;
                this.onRestrictedStateChanged(ar);
                break;
            }
            case 52: {
                this.log("EVENT_SIM_NOT_INSERTED");
                this.cancelAllNotifications();
                this.mMdn = null;
                this.mMin = null;
                this.mIsMinInfoReady = false;
                break;
            }
            case 49: {
                int dds = SubscriptionManager.getDefaultDataSubscriptionId();
                ProxyController.getInstance().unregisterForAllDataDisconnected(dds, this);
                ServiceStateTracker serviceStateTracker = this;
                synchronized (serviceStateTracker) {
                    if (this.mPendingRadioPowerOffAfterDataOff) {
                        this.log("EVENT_ALL_DATA_DISCONNECTED, turn radio off now.");
                        this.hangupAndPowerOff();
                        this.mPendingRadioPowerOffAfterDataOff = false;
                    } else {
                        this.log("EVENT_ALL_DATA_DISCONNECTED is stale");
                    }
                    break;
                }
            }
            case 45: {
                this.log("EVENT_CHANGE_IMS_STATE:");
                this.setPowerStateToDesired();
                break;
            }
            case 48: {
                this.log("EVENT_IMS_CAPABILITY_CHANGED");
                this.updateSpnDisplay();
                break;
            }
            case 39: {
                this.handleCdmaSubscriptionSource(this.mCdmaSSM.getCdmaSubscriptionSource());
                break;
            }
            case 26: {
                if (this.mPhone.getLteOnCdmaMode() == 1) {
                    this.log("Receive EVENT_RUIM_READY");
                    this.pollState();
                } else {
                    this.log("Receive EVENT_RUIM_READY and Send Request getCDMASubscription.");
                    this.getSubscriptionInfoAndStartPollingThreads();
                }
                this.mCi.getNetworkSelectionMode(this.obtainMessage(14));
                break;
            }
            case 35: {
                this.updatePhoneObject();
                this.mCi.getNetworkSelectionMode(this.obtainMessage(14));
                this.getSubscriptionInfoAndStartPollingThreads();
                break;
            }
            case 34: {
                if (this.mPhone.isPhoneTypeGsm()) break;
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception != null) break;
                String[] cdmaSubscription = (String[])ar.result;
                if (cdmaSubscription != null && cdmaSubscription.length >= 5) {
                    this.mMdn = cdmaSubscription[0];
                    this.parseSidNid(cdmaSubscription[1], cdmaSubscription[2]);
                    this.mMin = cdmaSubscription[3];
                    this.mPrlVersion = cdmaSubscription[4];
                    this.log("GET_CDMA_SUBSCRIPTION: MDN=" + this.mMdn);
                    this.mIsMinInfoReady = true;
                    this.updateOtaspState();
                    this.notifyCdmaSubscriptionInfoReady();
                    if (!this.mIsSubscriptionFromRuim && this.mIccRecords != null) {
                        this.log("GET_CDMA_SUBSCRIPTION set imsi in mIccRecords");
                        this.mIccRecords.setImsi(this.getImsi());
                        break;
                    }
                    this.log("GET_CDMA_SUBSCRIPTION either mIccRecords is null or NV type device - not setting Imsi in mIccRecords");
                    break;
                }
                this.log("GET_CDMA_SUBSCRIPTION: error parsing cdmaSubscription params num=" + cdmaSubscription.length);
                break;
            }
            case 27: {
                if (this.mPhone.isPhoneTypeGsm()) break;
                this.log("EVENT_RUIM_RECORDS_LOADED: what=" + msg.what);
                this.updatePhoneObject();
                if (this.mPhone.isPhoneTypeCdma()) {
                    this.updateSpnDisplay();
                    break;
                }
                RuimRecords ruim = (RuimRecords)this.mIccRecords;
                if (ruim != null) {
                    if (ruim.isProvisioned()) {
                        this.mMdn = ruim.getMdn();
                        this.mMin = ruim.getMin();
                        this.parseSidNid(ruim.getSid(), ruim.getNid());
                        this.mPrlVersion = ruim.getPrlVersion();
                        this.mIsMinInfoReady = true;
                    }
                    this.updateOtaspState();
                    this.notifyCdmaSubscriptionInfoReady();
                }
                this.pollState();
                break;
            }
            case 36: {
                this.log("ERI file has been loaded, repolling.");
                this.pollState();
                break;
            }
            case 37: {
                int[] ints;
                int otaStatus;
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception != null || (otaStatus = (ints = (int[])ar.result)[0]) != 8 && otaStatus != 10) break;
                this.log("EVENT_OTA_PROVISION_STATUS_CHANGE: Complete, Reload MDN");
                this.mCi.getCDMASubscription(this.obtainMessage(34));
                break;
            }
            case 40: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception != null) break;
                int[] ints = (int[])ar.result;
                this.mPrlVersion = Integer.toString(ints[0]);
                break;
            }
            case 51: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception != null) break;
                boolean enable = (Boolean)ar.result;
                this.log("EVENT_RADIO_POWER_FROM_CARRIER: " + enable);
                this.setRadioPowerFromCarrier(enable);
                break;
            }
            default: {
                this.log("Unhandled message with number: " + msg.what);
            }
        }
    }

    protected boolean isSidsAllZeros() {
        if (this.mHomeSystemId != null) {
            for (int i = 0; i < this.mHomeSystemId.length; ++i) {
                if (this.mHomeSystemId[i] == 0) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isHomeSid(int sid) {
        if (this.mHomeSystemId != null) {
            for (int i = 0; i < this.mHomeSystemId.length; ++i) {
                if (sid != this.mHomeSystemId[i]) continue;
                return true;
            }
        }
        return false;
    }

    public String getMdnNumber() {
        return this.mMdn;
    }

    public String getCdmaMin() {
        return this.mMin;
    }

    public String getPrlVersion() {
        return this.mPrlVersion;
    }

    public String getImsi() {
        String operatorNumeric = ((TelephonyManager)this.mPhone.getContext().getSystemService("phone")).getSimOperatorNumericForPhone(this.mPhone.getPhoneId());
        if (!TextUtils.isEmpty(operatorNumeric) && this.getCdmaMin() != null) {
            return operatorNumeric + this.getCdmaMin();
        }
        return null;
    }

    public boolean isMinInfoReady() {
        return this.mIsMinInfoReady;
    }

    public int getOtasp() {
        int provisioningState;
        if (!this.mPhone.getIccRecordsLoaded()) {
            this.log("getOtasp: otasp uninitialized due to sim not loaded");
            return 0;
        }
        if (this.mPhone.isPhoneTypeGsm()) {
            this.log("getOtasp: otasp not needed for GSM");
            return 3;
        }
        if (this.mIsSubscriptionFromRuim && this.mMin == null) {
            return 2;
        }
        if (this.mMin == null || this.mMin.length() < 6) {
            this.log("getOtasp: bad mMin='" + this.mMin + "'");
            provisioningState = 1;
        } else {
            provisioningState = this.mMin.equals(UNACTIVATED_MIN_VALUE) || this.mMin.substring(0, 6).equals(UNACTIVATED_MIN2_VALUE) || SystemProperties.getBoolean("test_cdma_setup", false) ? 2 : 3;
        }
        this.log("getOtasp: state=" + provisioningState);
        return provisioningState;
    }

    protected void parseSidNid(String sidStr, String nidStr) {
        int i;
        if (sidStr != null) {
            String[] sid = sidStr.split(",");
            this.mHomeSystemId = new int[sid.length];
            for (i = 0; i < sid.length; ++i) {
                try {
                    this.mHomeSystemId[i] = Integer.parseInt(sid[i]);
                    continue;
                }
                catch (NumberFormatException ex) {
                    this.loge("error parsing system id: " + ex);
                }
            }
        }
        this.log("CDMA_SUBSCRIPTION: SID=" + sidStr);
        if (nidStr != null) {
            String[] nid = nidStr.split(",");
            this.mHomeNetworkId = new int[nid.length];
            for (i = 0; i < nid.length; ++i) {
                try {
                    this.mHomeNetworkId[i] = Integer.parseInt(nid[i]);
                    continue;
                }
                catch (NumberFormatException ex) {
                    this.loge("CDMA_SUBSCRIPTION: error parsing network id: " + ex);
                }
            }
        }
        this.log("CDMA_SUBSCRIPTION: NID=" + nidStr);
    }

    protected void updateOtaspState() {
        int otaspMode = this.getOtasp();
        int oldOtaspMode = this.mCurrentOtaspMode;
        this.mCurrentOtaspMode = otaspMode;
        if (oldOtaspMode != this.mCurrentOtaspMode) {
            this.log("updateOtaspState: call notifyOtaspChanged old otaspMode=" + oldOtaspMode + " new otaspMode=" + this.mCurrentOtaspMode);
            this.mPhone.notifyOtaspChanged(this.mCurrentOtaspMode);
        }
    }

    protected Phone getPhone() {
        return this.mPhone;
    }

    protected void handlePollStateResult(int what, AsyncResult ar) {
        if (ar.userObj != this.mPollingContext) {
            return;
        }
        if (ar.exception != null) {
            CommandException.Error err = null;
            if (ar.exception instanceof CommandException) {
                err = ((CommandException)ar.exception).getCommandError();
            }
            if (err == CommandException.Error.RADIO_NOT_AVAILABLE) {
                this.cancelPollState();
                return;
            }
            if (err != CommandException.Error.OP_NOT_ALLOWED_BEFORE_REG_NW) {
                this.loge("RIL implementation has returned an error where it must succeed" + ar.exception);
            }
        } else {
            try {
                this.handlePollStateResultMessage(what, ar);
            }
            catch (RuntimeException ex) {
                this.loge("Exception while polling service state. Probably malformed RIL response." + ex);
            }
        }
        this.mPollingContext[0] = this.mPollingContext[0] - 1;
        if (this.mPollingContext[0] == 0) {
            if (this.mPhone.isPhoneTypeGsm()) {
                this.updateRoamingState();
                this.mNewSS.setEmergencyOnly(this.mEmergencyOnly);
            } else {
                int dataRat;
                boolean isRoamingBetweenOperators;
                boolean namMatch = false;
                if (!this.isSidsAllZeros() && this.isHomeSid(this.mNewSS.getSystemId())) {
                    namMatch = true;
                }
                if (this.mIsSubscriptionFromRuim && (isRoamingBetweenOperators = this.isRoamingBetweenOperators(this.mNewSS.getVoiceRoaming(), this.mNewSS)) != this.mNewSS.getVoiceRoaming()) {
                    this.log("isRoamingBetweenOperators=" + isRoamingBetweenOperators + ". Override CDMA voice roaming to " + isRoamingBetweenOperators);
                    this.mNewSS.setVoiceRoaming(isRoamingBetweenOperators);
                }
                if (ServiceState.isCdma(dataRat = this.mNewSS.getRilDataRadioTechnology())) {
                    boolean isVoiceInService;
                    boolean bl = isVoiceInService = this.mNewSS.getVoiceRegState() == 0;
                    if (isVoiceInService) {
                        boolean isVoiceRoaming = this.mNewSS.getVoiceRoaming();
                        if (this.mNewSS.getDataRoaming() != isVoiceRoaming) {
                            this.log("Data roaming != Voice roaming. Override data roaming to " + isVoiceRoaming);
                            this.mNewSS.setDataRoaming(isVoiceRoaming);
                        }
                    } else {
                        boolean isRoamIndForHomeSystem = this.isRoamIndForHomeSystem(Integer.toString(this.mRoamingIndicator));
                        if (this.mNewSS.getDataRoaming() == isRoamIndForHomeSystem) {
                            this.log("isRoamIndForHomeSystem=" + isRoamIndForHomeSystem + ", override data roaming to " + !isRoamIndForHomeSystem);
                            this.mNewSS.setDataRoaming(!isRoamIndForHomeSystem);
                        }
                    }
                }
                this.mNewSS.setCdmaDefaultRoamingIndicator(this.mDefaultRoamingIndicator);
                this.mNewSS.setCdmaRoamingIndicator(this.mRoamingIndicator);
                boolean isPrlLoaded = true;
                if (TextUtils.isEmpty(this.mPrlVersion)) {
                    isPrlLoaded = false;
                }
                if (!isPrlLoaded || this.mNewSS.getRilVoiceRadioTechnology() == 0) {
                    this.log("Turn off roaming indicator if !isPrlLoaded or voice RAT is unknown");
                    this.mNewSS.setCdmaRoamingIndicator(1);
                } else if (!this.isSidsAllZeros()) {
                    if (!namMatch && !this.mIsInPrl) {
                        this.mNewSS.setCdmaRoamingIndicator(this.mDefaultRoamingIndicator);
                    } else if (namMatch && !this.mIsInPrl) {
                        if (ServiceState.isLte(this.mNewSS.getRilVoiceRadioTechnology())) {
                            this.log("Turn off roaming indicator as voice is LTE");
                            this.mNewSS.setCdmaRoamingIndicator(1);
                        } else {
                            this.mNewSS.setCdmaRoamingIndicator(2);
                        }
                    } else if (!namMatch && this.mIsInPrl) {
                        this.mNewSS.setCdmaRoamingIndicator(this.mRoamingIndicator);
                    } else if (this.mRoamingIndicator <= 2) {
                        this.mNewSS.setCdmaRoamingIndicator(1);
                    } else {
                        this.mNewSS.setCdmaRoamingIndicator(this.mRoamingIndicator);
                    }
                }
                int roamingIndicator = this.mNewSS.getCdmaRoamingIndicator();
                this.mNewSS.setCdmaEriIconIndex(this.mPhone.mEriManager.getCdmaEriIconIndex(roamingIndicator, this.mDefaultRoamingIndicator));
                this.mNewSS.setCdmaEriIconMode(this.mPhone.mEriManager.getCdmaEriIconMode(roamingIndicator, this.mDefaultRoamingIndicator));
                this.log("Set CDMA Roaming Indicator to: " + this.mNewSS.getCdmaRoamingIndicator() + ". voiceRoaming = " + this.mNewSS.getVoiceRoaming() + ". dataRoaming = " + this.mNewSS.getDataRoaming() + ", isPrlLoaded = " + isPrlLoaded + ". namMatch = " + namMatch + " , mIsInPrl = " + this.mIsInPrl + ", mRoamingIndicator = " + this.mRoamingIndicator + ", mDefaultRoamingIndicator= " + this.mDefaultRoamingIndicator);
            }
            this.pollStateDone();
        }
    }

    private boolean isRoamingBetweenOperators(boolean cdmaRoaming, ServiceState s) {
        return cdmaRoaming && !this.isSameOperatorNameFromSimAndSS(s);
    }

    private int getRegStateFromHalRegState(int regState) {
        switch (regState) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
            case 10: {
                return 10;
            }
            case 12: {
                return 12;
            }
            case 13: {
                return 13;
            }
            case 14: {
                return 14;
            }
        }
        return 0;
    }

    void handlePollStateResultMessage(int what, AsyncResult ar) {
        switch (what) {
            case 4: {
                VoiceRegStateResult voiceRegStateResult = (VoiceRegStateResult)ar.result;
                int registrationState = this.getRegStateFromHalRegState(voiceRegStateResult.regState);
                this.mNewSS.setVoiceRegState(this.regCodeToServiceState(registrationState));
                this.mNewSS.setRilVoiceRadioTechnology(voiceRegStateResult.rat);
                int reasonForDenial = voiceRegStateResult.reasonForDenial;
                if (this.mPhone.isPhoneTypeGsm()) {
                    this.mGsmRoaming = this.regCodeIsRoaming(registrationState);
                    this.mNewRejectCode = reasonForDenial;
                    boolean isVoiceCapable = this.mPhone.getContext().getResources().getBoolean(17957054);
                    this.mEmergencyOnly = (registrationState == 13 || registrationState == 10 || registrationState == 12 || registrationState == 14) && isVoiceCapable;
                } else {
                    int cssIndicator = voiceRegStateResult.cssSupported ? 1 : 0;
                    int roamingIndicator = voiceRegStateResult.roamingIndicator;
                    int systemIsInPrl = voiceRegStateResult.systemIsInPrl;
                    int defaultRoamingIndicator = voiceRegStateResult.defaultRoamingIndicator;
                    this.mRegistrationState = registrationState;
                    boolean cdmaRoaming = this.regCodeIsRoaming(registrationState) && !this.isRoamIndForHomeSystem(Integer.toString(roamingIndicator));
                    this.mNewSS.setVoiceRoaming(cdmaRoaming);
                    this.mNewSS.setCssIndicator(cssIndicator);
                    this.mRoamingIndicator = roamingIndicator;
                    this.mIsInPrl = systemIsInPrl != 0;
                    this.mDefaultRoamingIndicator = defaultRoamingIndicator;
                    int systemId = 0;
                    int networkId = 0;
                    if (voiceRegStateResult.cellIdentity.cellInfoType == 2 && voiceRegStateResult.cellIdentity.cellIdentityCdma.size() == 1) {
                        CellIdentityCdma cellIdentityCdma = voiceRegStateResult.cellIdentity.cellIdentityCdma.get(0);
                        systemId = cellIdentityCdma.systemId;
                        networkId = cellIdentityCdma.networkId;
                    }
                    this.mNewSS.setSystemAndNetworkId(systemId, networkId);
                    this.mRegistrationDeniedReason = reasonForDenial == 0 ? REGISTRATION_DENIED_GEN : (reasonForDenial == 1 ? REGISTRATION_DENIED_AUTH : "");
                    if (this.mRegistrationState == 3) {
                        this.log("Registration denied, " + this.mRegistrationDeniedReason);
                    }
                }
                this.processCellLocationInfo(this.mNewCellLoc, voiceRegStateResult);
                this.log("handlPollVoiceRegResultMessage: regState=" + registrationState + " radioTechnology=" + voiceRegStateResult.rat);
                break;
            }
            case 5: {
                DataRegStateResult dataRegStateResult = (DataRegStateResult)ar.result;
                int regState = this.getRegStateFromHalRegState(dataRegStateResult.regState);
                int dataRegState = this.regCodeToServiceState(regState);
                int newDataRat = dataRegStateResult.rat;
                this.mNewSS.setDataRegState(dataRegState);
                this.mNewSS.setRilDataRadioTechnology(newDataRat);
                if (this.mPhone.isPhoneTypeGsm()) {
                    this.mNewReasonDataDenied = dataRegStateResult.reasonDataDenied;
                    this.mNewMaxDataCalls = dataRegStateResult.maxDataCalls;
                    this.mDataRoaming = this.regCodeIsRoaming(regState);
                    this.mNewSS.setDataRoamingFromRegistration(this.mDataRoaming);
                    this.log("handlPollStateResultMessage: GsmSST setDataRegState=" + dataRegState + " regState=" + regState + " dataRadioTechnology=" + newDataRat);
                } else if (this.mPhone.isPhoneTypeCdma()) {
                    boolean isDataRoaming = this.regCodeIsRoaming(regState);
                    this.mNewSS.setDataRoaming(isDataRoaming);
                    this.mNewSS.setDataRoamingFromRegistration(isDataRoaming);
                    this.log("handlPollStateResultMessage: cdma setDataRegState=" + dataRegState + " regState=" + regState + " dataRadioTechnology=" + newDataRat);
                } else {
                    int oldDataRAT = this.mSS.getRilDataRadioTechnology();
                    if (oldDataRAT == 0 && newDataRat != 0 || ServiceState.isCdma(oldDataRAT) && ServiceState.isLte(newDataRat) || ServiceState.isLte(oldDataRAT) && ServiceState.isCdma(newDataRat)) {
                        this.mCi.getSignalStrength(this.obtainMessage(3));
                    }
                    boolean isDataRoaming = this.regCodeIsRoaming(regState);
                    this.mNewSS.setDataRoaming(isDataRoaming);
                    this.mNewSS.setDataRoamingFromRegistration(isDataRoaming);
                    this.log("handlPollStateResultMessage: CdmaLteSST setDataRegState=" + dataRegState + " regState=" + regState + " dataRadioTechnology=" + newDataRat);
                }
                this.updateServiceStateLteEarfcnBoost(this.mNewSS, this.getLteEarfcn(dataRegStateResult));
                break;
            }
            case 6: {
                if (this.mPhone.isPhoneTypeGsm()) {
                    String brandOverride;
                    String[] opNames = (String[])ar.result;
                    if (opNames == null || opNames.length < 3) break;
                    String string2 = brandOverride = this.mUiccController.getUiccCard(this.getPhoneId()) != null ? this.mUiccController.getUiccCard(this.getPhoneId()).getOperatorBrandOverride() : null;
                    if (brandOverride != null) {
                        this.log("EVENT_POLL_STATE_OPERATOR: use brandOverride=" + brandOverride);
                        this.mNewSS.setOperatorName(brandOverride, brandOverride, opNames[2]);
                        break;
                    }
                    this.mNewSS.setOperatorName(opNames[0], opNames[1], opNames[2]);
                    break;
                }
                String[] opNames = (String[])ar.result;
                if (opNames != null && opNames.length >= 3) {
                    String brandOverride;
                    if (opNames[2] == null || opNames[2].length() < 5 || "00000".equals(opNames[2])) {
                        opNames[2] = SystemProperties.get("ro.cdma.home.operator.numeric", "00000");
                        this.log("RIL_REQUEST_OPERATOR.response[2], the numeric,  is bad. Using SystemProperties 'ro.cdma.home.operator.numeric'= " + opNames[2]);
                    }
                    if (!this.mIsSubscriptionFromRuim) {
                        this.mNewSS.setOperatorName(opNames[0], opNames[1], opNames[2]);
                        break;
                    }
                    String string3 = brandOverride = this.mUiccController.getUiccCard(this.getPhoneId()) != null ? this.mUiccController.getUiccCard(this.getPhoneId()).getOperatorBrandOverride() : null;
                    if (brandOverride != null) {
                        this.mNewSS.setOperatorName(brandOverride, brandOverride, opNames[2]);
                        break;
                    }
                    this.mNewSS.setOperatorName(opNames[0], opNames[1], opNames[2]);
                    break;
                }
                this.log("EVENT_POLL_STATE_OPERATOR_CDMA: error parsing opNames");
                break;
            }
            case 14: {
                int[] ints = (int[])ar.result;
                this.mNewSS.setIsManualSelection(ints[0] == 1);
                if (ints[0] != 1 || !this.mPhone.shouldForceAutoNetworkSelect()) break;
                this.mPhone.setNetworkSelectionModeAutomatic(null);
                this.log(" Forcing Automatic Network Selection, manual selection is not allowed");
                break;
            }
            default: {
                this.loge("handlePollStateResultMessage: Unexpected RIL response received: " + what);
            }
        }
    }

    private boolean isRoamIndForHomeSystem(String roamInd) {
        Object[] homeRoamIndicators = Resources.getSystem().getStringArray(17235989);
        this.log("isRoamIndForHomeSystem: homeRoamIndicators=" + Arrays.toString(homeRoamIndicators));
        if (homeRoamIndicators != null) {
            for (Object homeRoamInd : homeRoamIndicators) {
                if (!((String)homeRoamInd).equals(roamInd)) continue;
                return true;
            }
            this.log("isRoamIndForHomeSystem: No match found against list for roamInd=" + roamInd);
            return false;
        }
        this.log("isRoamIndForHomeSystem: No list found");
        return false;
    }

    protected void updateRoamingState() {
        if (this.mPhone.isPhoneTypeGsm()) {
            CarrierConfigManager configLoader;
            boolean roaming;
            boolean bl = roaming = this.mGsmRoaming || this.mDataRoaming;
            if (this.mGsmRoaming && !this.isOperatorConsideredRoaming(this.mNewSS) && (this.isSameNamedOperators(this.mNewSS) || this.isOperatorConsideredNonRoaming(this.mNewSS))) {
                this.log("updateRoamingState: resource override set non roaming.isSameNamedOperators=" + this.isSameNamedOperators(this.mNewSS) + ",isOperatorConsideredNonRoaming=" + this.isOperatorConsideredNonRoaming(this.mNewSS));
                roaming = false;
            }
            if ((configLoader = (CarrierConfigManager)this.mPhone.getContext().getSystemService("carrier_config")) != null) {
                try {
                    PersistableBundle b = configLoader.getConfigForSubId(this.mPhone.getSubId());
                    if (this.alwaysOnHomeNetwork(b)) {
                        this.log("updateRoamingState: carrier config override always on home network");
                        roaming = false;
                    } else if (this.isNonRoamingInGsmNetwork(b, this.mNewSS.getOperatorNumeric())) {
                        this.log("updateRoamingState: carrier config override set non roaming:" + this.mNewSS.getOperatorNumeric());
                        roaming = false;
                    } else if (this.isRoamingInGsmNetwork(b, this.mNewSS.getOperatorNumeric())) {
                        this.log("updateRoamingState: carrier config override set roaming:" + this.mNewSS.getOperatorNumeric());
                        roaming = true;
                    }
                }
                catch (Exception e) {
                    this.loge("updateRoamingState: unable to access carrier config service");
                }
            } else {
                this.log("updateRoamingState: no carrier config service available");
            }
            this.mNewSS.setVoiceRoaming(roaming);
            this.mNewSS.setDataRoaming(roaming);
        } else {
            CarrierConfigManager configLoader = (CarrierConfigManager)this.mPhone.getContext().getSystemService("carrier_config");
            if (configLoader != null) {
                try {
                    PersistableBundle b = configLoader.getConfigForSubId(this.mPhone.getSubId());
                    String systemId = Integer.toString(this.mNewSS.getSystemId());
                    if (this.alwaysOnHomeNetwork(b)) {
                        this.log("updateRoamingState: carrier config override always on home network");
                        this.setRoamingOff();
                    } else if (this.isNonRoamingInGsmNetwork(b, this.mNewSS.getOperatorNumeric()) || this.isNonRoamingInCdmaNetwork(b, systemId)) {
                        this.log("updateRoamingState: carrier config override set non-roaming:" + this.mNewSS.getOperatorNumeric() + ", " + systemId);
                        this.setRoamingOff();
                    } else if (this.isRoamingInGsmNetwork(b, this.mNewSS.getOperatorNumeric()) || this.isRoamingInCdmaNetwork(b, systemId)) {
                        this.log("updateRoamingState: carrier config override set roaming:" + this.mNewSS.getOperatorNumeric() + ", " + systemId);
                        this.setRoamingOn();
                    }
                }
                catch (Exception e) {
                    this.loge("updateRoamingState: unable to access carrier config service");
                }
            } else {
                this.log("updateRoamingState: no carrier config service available");
            }
            if (Build.IS_DEBUGGABLE && SystemProperties.getBoolean(PROP_FORCE_ROAMING, false)) {
                this.mNewSS.setVoiceRoaming(true);
                this.mNewSS.setDataRoaming(true);
            }
        }
    }

    private void setRoamingOn() {
        this.mNewSS.setVoiceRoaming(true);
        this.mNewSS.setDataRoaming(true);
        this.mNewSS.setCdmaEriIconIndex(0);
        this.mNewSS.setCdmaEriIconMode(0);
    }

    private void setRoamingOff() {
        this.mNewSS.setVoiceRoaming(false);
        this.mNewSS.setDataRoaming(false);
        this.mNewSS.setCdmaEriIconIndex(1);
    }

    protected void updateSpnDisplay() {
        this.updateOperatorNameFromEri();
        String wfcVoiceSpnFormat = null;
        String wfcDataSpnFormat = null;
        int combinedRegState = this.getCombinedRegState();
        if (this.mPhone.getImsPhone() != null && this.mPhone.getImsPhone().isWifiCallingEnabled() && combinedRegState == 0) {
            String[] wfcSpnFormats = this.mPhone.getContext().getResources().getStringArray(17236064);
            int voiceIdx = 0;
            int dataIdx = 0;
            CarrierConfigManager configLoader = (CarrierConfigManager)this.mPhone.getContext().getSystemService("carrier_config");
            if (configLoader != null) {
                try {
                    PersistableBundle b = configLoader.getConfigForSubId(this.mPhone.getSubId());
                    if (b != null) {
                        voiceIdx = b.getInt("wfc_spn_format_idx_int");
                        dataIdx = b.getInt("wfc_data_spn_format_idx_int");
                    }
                }
                catch (Exception e) {
                    this.loge("updateSpnDisplay: carrier config error: " + e);
                }
            }
            wfcVoiceSpnFormat = wfcSpnFormats[voiceIdx];
            wfcDataSpnFormat = wfcSpnFormats[dataIdx];
        }
        if (this.mPhone.isPhoneTypeGsm()) {
            boolean showSpn;
            String spn;
            int rule;
            IccRecords iccRecords = this.mIccRecords;
            String plmn = null;
            boolean showPlmn = false;
            int n = rule = iccRecords != null ? iccRecords.getDisplayRule(this.mSS.getOperatorNumeric()) : 0;
            if (combinedRegState == 1 || combinedRegState == 2) {
                showPlmn = true;
                plmn = this.mEmergencyOnly ? Resources.getSystem().getText(17039790).toString() : Resources.getSystem().getText(17040088).toString();
                this.log("updateSpnDisplay: radio is on but out of service, set plmn='" + plmn + "'");
            } else if (combinedRegState == 0) {
                plmn = this.mSS.getOperatorAlpha();
                showPlmn = !TextUtils.isEmpty(plmn) && (rule & 2) == 2;
            } else {
                showPlmn = true;
                plmn = Resources.getSystem().getText(17040088).toString();
                this.log("updateSpnDisplay: radio is off w/ showPlmn=" + showPlmn + " plmn=" + plmn);
            }
            String dataSpn = spn = iccRecords != null ? iccRecords.getServiceProviderName() : "";
            boolean bl = showSpn = !TextUtils.isEmpty(spn) && (rule & 1) == 1;
            if (!(TextUtils.isEmpty(spn) || TextUtils.isEmpty(wfcVoiceSpnFormat) || TextUtils.isEmpty(wfcDataSpnFormat))) {
                String originalSpn = spn.trim();
                spn = String.format(wfcVoiceSpnFormat, originalSpn);
                dataSpn = String.format(wfcDataSpnFormat, originalSpn);
                showSpn = true;
                showPlmn = false;
            } else if (!TextUtils.isEmpty(plmn) && !TextUtils.isEmpty(wfcVoiceSpnFormat)) {
                String originalPlmn = plmn.trim();
                plmn = String.format(wfcVoiceSpnFormat, originalPlmn);
            } else if (this.mSS.getVoiceRegState() == 3 || showPlmn && TextUtils.equals(spn, plmn)) {
                spn = null;
                showSpn = false;
            }
            int subId = -1;
            int[] subIds = SubscriptionManager.getSubId(this.mPhone.getPhoneId());
            if (subIds != null && subIds.length > 0) {
                subId = subIds[0];
            }
            if (!(this.mSubId == subId && showPlmn == this.mCurShowPlmn && showSpn == this.mCurShowSpn && TextUtils.equals(spn, this.mCurSpn) && TextUtils.equals(dataSpn, this.mCurDataSpn) && TextUtils.equals(plmn, this.mCurPlmn))) {
                this.log(String.format("updateSpnDisplay: changed sending intent rule=" + rule + " showPlmn='%b' plmn='%s' showSpn='%b' spn='%s' dataSpn='%s' subId='%d'", showPlmn, plmn, showSpn, spn, dataSpn, subId));
                Intent intent = new Intent("android.provider.Telephony.SPN_STRINGS_UPDATED");
                intent.putExtra("showSpn", showSpn);
                intent.putExtra("spn", spn);
                intent.putExtra("spnData", dataSpn);
                intent.putExtra("showPlmn", showPlmn);
                intent.putExtra("plmn", plmn);
                SubscriptionManager.putPhoneIdAndSubIdExtra(intent, this.mPhone.getPhoneId());
                this.mPhone.getContext().sendStickyBroadcastAsUser(intent, UserHandle.ALL);
                if (!this.mSubscriptionController.setPlmnSpn(this.mPhone.getPhoneId(), showPlmn, plmn, showSpn, spn)) {
                    this.mSpnUpdatePending = true;
                }
            }
            this.mSubId = subId;
            this.mCurShowSpn = showSpn;
            this.mCurShowPlmn = showPlmn;
            this.mCurSpn = spn;
            this.mCurDataSpn = dataSpn;
            this.mCurPlmn = plmn;
        } else {
            String plmn = this.mSS.getOperatorAlpha();
            boolean showPlmn = false;
            showPlmn = plmn != null;
            int subId = -1;
            int[] subIds = SubscriptionManager.getSubId(this.mPhone.getPhoneId());
            if (subIds != null && subIds.length > 0) {
                subId = subIds[0];
            }
            if (!TextUtils.isEmpty(plmn) && !TextUtils.isEmpty(wfcVoiceSpnFormat)) {
                String originalPlmn = plmn.trim();
                plmn = String.format(wfcVoiceSpnFormat, originalPlmn);
            } else if (this.mCi.getRadioState() == CommandsInterface.RadioState.RADIO_OFF) {
                this.log("updateSpnDisplay: overwriting plmn from " + plmn + " to null as radio state is off");
                plmn = null;
            }
            if (combinedRegState == 1) {
                plmn = Resources.getSystem().getText(17040088).toString();
                this.log("updateSpnDisplay: radio is on but out of svc, set plmn='" + plmn + "'");
            }
            if (this.mSubId != subId || !TextUtils.equals(plmn, this.mCurPlmn)) {
                this.log(String.format("updateSpnDisplay: changed sending intent showPlmn='%b' plmn='%s' subId='%d'", showPlmn, plmn, subId));
                Intent intent = new Intent("android.provider.Telephony.SPN_STRINGS_UPDATED");
                intent.putExtra("showSpn", false);
                intent.putExtra("spn", "");
                intent.putExtra("showPlmn", showPlmn);
                intent.putExtra("plmn", plmn);
                SubscriptionManager.putPhoneIdAndSubIdExtra(intent, this.mPhone.getPhoneId());
                this.mPhone.getContext().sendStickyBroadcastAsUser(intent, UserHandle.ALL);
                if (!this.mSubscriptionController.setPlmnSpn(this.mPhone.getPhoneId(), showPlmn, plmn, false, "")) {
                    this.mSpnUpdatePending = true;
                }
            }
            this.mSubId = subId;
            this.mCurShowSpn = false;
            this.mCurShowPlmn = showPlmn;
            this.mCurSpn = "";
            this.mCurPlmn = plmn;
        }
    }

    protected void setPowerStateToDesired() {
        AlarmManager am;
        Context context;
        String tmpLog = "mDeviceShuttingDown=" + this.mDeviceShuttingDown + ", mDesiredPowerState=" + this.mDesiredPowerState + ", getRadioState=" + (Object)((Object)this.mCi.getRadioState()) + ", mPowerOffDelayNeed=" + this.mPowerOffDelayNeed + ", mAlarmSwitch=" + this.mAlarmSwitch + ", mRadioDisabledByCarrier=" + this.mRadioDisabledByCarrier;
        this.log(tmpLog);
        this.mRadioPowerLog.log(tmpLog);
        if (this.mPhone.isPhoneTypeGsm() && this.mAlarmSwitch) {
            this.log("mAlarmSwitch == true");
            context = this.mPhone.getContext();
            am = (AlarmManager)context.getSystemService("alarm");
            am.cancel(this.mRadioOffIntent);
            this.mAlarmSwitch = false;
        }
        if (this.mDesiredPowerState && !this.mRadioDisabledByCarrier && this.mCi.getRadioState() == CommandsInterface.RadioState.RADIO_OFF) {
            this.mCi.setRadioPower(true, null);
        } else if ((!this.mDesiredPowerState || this.mRadioDisabledByCarrier) && this.mCi.getRadioState().isOn()) {
            DcTracker dcTracker;
            if (this.mPhone.isPhoneTypeGsm() && this.mPowerOffDelayNeed) {
                if (this.mImsRegistrationOnOff && !this.mAlarmSwitch) {
                    this.log("mImsRegistrationOnOff == true");
                    context = this.mPhone.getContext();
                    am = (AlarmManager)context.getSystemService("alarm");
                    Intent intent = new Intent(ACTION_RADIO_OFF);
                    this.mRadioOffIntent = PendingIntent.getBroadcast(context, 0, intent, 0);
                    this.mAlarmSwitch = true;
                    this.log("Alarm setting");
                    am.set(2, SystemClock.elapsedRealtime() + 3000L, this.mRadioOffIntent);
                } else {
                    dcTracker = this.mPhone.mDcTracker;
                    this.powerOffRadioSafely(dcTracker);
                }
            } else {
                dcTracker = this.mPhone.mDcTracker;
                this.powerOffRadioSafely(dcTracker);
            }
        } else if (this.mDeviceShuttingDown && this.mCi.getRadioState().isAvailable()) {
            this.mCi.requestShutdown(null);
        }
    }

    protected void onUpdateIccAvailability() {
        if (this.mUiccController == null) {
            return;
        }
        UiccCardApplication newUiccApplication = this.getUiccCardApplication();
        if (this.mUiccApplcation != newUiccApplication) {
            if (this.mUiccApplcation != null) {
                this.log("Removing stale icc objects.");
                this.mUiccApplcation.unregisterForReady(this);
                if (this.mIccRecords != null) {
                    this.mIccRecords.unregisterForRecordsLoaded(this);
                }
                this.mIccRecords = null;
                this.mUiccApplcation = null;
            }
            if (newUiccApplication != null) {
                this.log("New card found");
                this.mUiccApplcation = newUiccApplication;
                this.mIccRecords = this.mUiccApplcation.getIccRecords();
                if (this.mPhone.isPhoneTypeGsm()) {
                    this.mUiccApplcation.registerForReady(this, 17, null);
                    if (this.mIccRecords != null) {
                        this.mIccRecords.registerForRecordsLoaded(this, 16, null);
                    }
                } else if (this.mIsSubscriptionFromRuim) {
                    this.mUiccApplcation.registerForReady(this, 26, null);
                    if (this.mIccRecords != null) {
                        this.mIccRecords.registerForRecordsLoaded(this, 27, null);
                    }
                }
            }
        }
    }

    private void logRoamingChange() {
        this.mRoamingLog.log(this.mSS.toString());
    }

    private void logAttachChange() {
        this.mAttachLog.log(this.mSS.toString());
    }

    private void logPhoneTypeChange() {
        this.mPhoneTypeLog.log(Integer.toString(this.mPhone.getPhoneType()));
    }

    private void logRatChange() {
        this.mRatLog.log(this.mSS.toString());
    }

    protected void log(String s) {
        Rlog.d(LOG_TAG, s);
    }

    protected void loge(String s) {
        Rlog.e(LOG_TAG, s);
    }

    public int getCurrentDataConnectionState() {
        return this.mSS.getDataRegState();
    }

    public boolean isConcurrentVoiceAndDataAllowed() {
        if (this.mPhone.isPhoneTypeGsm()) {
            return this.mSS.getRilVoiceRadioTechnology() >= 3;
        }
        if (this.mPhone.isPhoneTypeCdma()) {
            return false;
        }
        return this.mSS.getCssIndicator() == 1;
    }

    public void setImsRegistrationState(boolean registered) {
        this.log("ImsRegistrationState - registered : " + registered);
        if (this.mImsRegistrationOnOff && !registered && this.mAlarmSwitch) {
            this.mImsRegistrationOnOff = registered;
            Context context = this.mPhone.getContext();
            AlarmManager am = (AlarmManager)context.getSystemService("alarm");
            am.cancel(this.mRadioOffIntent);
            this.mAlarmSwitch = false;
            this.sendMessage(this.obtainMessage(45));
            return;
        }
        this.mImsRegistrationOnOff = registered;
    }

    public void onImsCapabilityChanged() {
        this.sendMessage(this.obtainMessage(48));
    }

    public boolean isRadioOn() {
        return this.mCi.getRadioState() == CommandsInterface.RadioState.RADIO_ON;
    }

    public void pollState() {
        this.pollState(false);
    }

    private void modemTriggeredPollState() {
        this.pollState(true);
    }

    public void pollState(boolean modemTriggered) {
        this.mPollingContext = new int[1];
        this.mPollingContext[0] = 0;
        this.log("pollState: modemTriggered=" + modemTriggered);
        switch (this.mCi.getRadioState()) {
            case RADIO_UNAVAILABLE: {
                this.mNewSS.setStateOutOfService();
                this.mNewCellLoc.setStateInvalid();
                this.setSignalStrengthDefaultValues();
                this.mGotCountryCode = false;
                this.mNitzUpdatedTime = false;
                this.pollStateDone();
                break;
            }
            case RADIO_OFF: {
                this.mNewSS.setStateOff();
                this.mNewCellLoc.setStateInvalid();
                this.setSignalStrengthDefaultValues();
                this.mGotCountryCode = false;
                this.mNitzUpdatedTime = false;
                if (this.mDeviceShuttingDown || !modemTriggered && 18 != this.mSS.getRilDataRadioTechnology()) {
                    this.pollStateDone();
                    break;
                }
            }
            default: {
                this.mPollingContext[0] = this.mPollingContext[0] + 1;
                this.mCi.getOperator(this.obtainMessage(6, this.mPollingContext));
                this.mPollingContext[0] = this.mPollingContext[0] + 1;
                this.mCi.getDataRegistrationState(this.obtainMessage(5, this.mPollingContext));
                this.mPollingContext[0] = this.mPollingContext[0] + 1;
                this.mCi.getVoiceRegistrationState(this.obtainMessage(4, this.mPollingContext));
                if (!this.mPhone.isPhoneTypeGsm()) break;
                this.mPollingContext[0] = this.mPollingContext[0] + 1;
                this.mCi.getNetworkSelectionMode(this.obtainMessage(14, this.mPollingContext));
            }
        }
    }

    private void pollStateDone() {
        boolean hasLocationChanged;
        if (!this.mPhone.isPhoneTypeGsm()) {
            this.updateRoamingState();
        }
        if (Build.IS_DEBUGGABLE && SystemProperties.getBoolean(PROP_FORCE_ROAMING, false)) {
            this.mNewSS.setVoiceRoaming(true);
            this.mNewSS.setDataRoaming(true);
        }
        this.useDataRegStateForDataOnlyDevices();
        this.resetServiceStateInIwlanMode();
        this.log("Poll ServiceState done:  oldSS=[" + this.mSS + "] newSS=[" + this.mNewSS + "] oldMaxDataCalls=" + this.mMaxDataCalls + " mNewMaxDataCalls=" + this.mNewMaxDataCalls + " oldReasonDataDenied=" + this.mReasonDataDenied + " mNewReasonDataDenied=" + this.mNewReasonDataDenied);
        boolean hasRegistered = this.mSS.getVoiceRegState() != 0 && this.mNewSS.getVoiceRegState() == 0;
        boolean hasDeregistered = this.mSS.getVoiceRegState() == 0 && this.mNewSS.getVoiceRegState() != 0;
        boolean hasDataAttached = this.mSS.getDataRegState() != 0 && this.mNewSS.getDataRegState() == 0;
        boolean hasDataDetached = this.mSS.getDataRegState() == 0 && this.mNewSS.getDataRegState() != 0;
        boolean hasDataRegStateChanged = this.mSS.getDataRegState() != this.mNewSS.getDataRegState();
        boolean hasVoiceRegStateChanged = this.mSS.getVoiceRegState() != this.mNewSS.getVoiceRegState();
        boolean bl = hasLocationChanged = !this.mNewCellLoc.equals(this.mCellLoc);
        if (!hasLocationChanged) {
            this.mRatRatcheter.ratchetRat(this.mSS, this.mNewSS);
        }
        boolean hasRilVoiceRadioTechnologyChanged = this.mSS.getRilVoiceRadioTechnology() != this.mNewSS.getRilVoiceRadioTechnology();
        boolean hasRilDataRadioTechnologyChanged = this.mSS.getRilDataRadioTechnology() != this.mNewSS.getRilDataRadioTechnology();
        boolean hasChanged = !this.mNewSS.equals(this.mSS);
        boolean hasVoiceRoamingOn = !this.mSS.getVoiceRoaming() && this.mNewSS.getVoiceRoaming();
        boolean hasVoiceRoamingOff = this.mSS.getVoiceRoaming() && !this.mNewSS.getVoiceRoaming();
        boolean hasDataRoamingOn = !this.mSS.getDataRoaming() && this.mNewSS.getDataRoaming();
        boolean hasDataRoamingOff = this.mSS.getDataRoaming() && !this.mNewSS.getDataRoaming();
        boolean hasRejectCauseChanged = this.mRejectCode != this.mNewRejectCode;
        boolean has4gHandoff = false;
        boolean hasMultiApnSupport = false;
        boolean hasLostMultiApnSupport = false;
        if (this.mPhone.isPhoneTypeCdmaLte()) {
            has4gHandoff = this.mNewSS.getDataRegState() == 0 && (ServiceState.isLte(this.mSS.getRilDataRadioTechnology()) && this.mNewSS.getRilDataRadioTechnology() == 13 || this.mSS.getRilDataRadioTechnology() == 13 && ServiceState.isLte(this.mNewSS.getRilDataRadioTechnology()));
            hasMultiApnSupport = (ServiceState.isLte(this.mNewSS.getRilDataRadioTechnology()) || this.mNewSS.getRilDataRadioTechnology() == 13) && !ServiceState.isLte(this.mSS.getRilDataRadioTechnology()) && this.mSS.getRilDataRadioTechnology() != 13;
            hasLostMultiApnSupport = this.mNewSS.getRilDataRadioTechnology() >= 4 && this.mNewSS.getRilDataRadioTechnology() <= 8;
        }
        this.log("pollStateDone: hasRegistered=" + hasRegistered + " hasDeregistered=" + hasDeregistered + " hasDataAttached=" + hasDataAttached + " hasDataDetached=" + hasDataDetached + " hasDataRegStateChanged=" + hasDataRegStateChanged + " hasRilVoiceRadioTechnologyChanged= " + hasRilVoiceRadioTechnologyChanged + " hasRilDataRadioTechnologyChanged=" + hasRilDataRadioTechnologyChanged + " hasChanged=" + hasChanged + " hasVoiceRoamingOn=" + hasVoiceRoamingOn + " hasVoiceRoamingOff=" + hasVoiceRoamingOff + " hasDataRoamingOn=" + hasDataRoamingOn + " hasDataRoamingOff=" + hasDataRoamingOff + " hasLocationChanged=" + hasLocationChanged + " has4gHandoff = " + has4gHandoff + " hasMultiApnSupport=" + hasMultiApnSupport + " hasLostMultiApnSupport=" + hasLostMultiApnSupport);
        if (hasVoiceRegStateChanged || hasDataRegStateChanged) {
            EventLog.writeEvent(this.mPhone.isPhoneTypeGsm() ? 50114 : 50116, this.mSS.getVoiceRegState(), this.mSS.getDataRegState(), this.mNewSS.getVoiceRegState(), this.mNewSS.getDataRegState());
        }
        if (this.mPhone.isPhoneTypeGsm()) {
            if (hasRilVoiceRadioTechnologyChanged) {
                int cid = -1;
                GsmCellLocation loc = (GsmCellLocation)this.mNewCellLoc;
                if (loc != null) {
                    cid = loc.getCid();
                }
                EventLog.writeEvent(50123, cid, this.mSS.getRilVoiceRadioTechnology(), this.mNewSS.getRilVoiceRadioTechnology());
                this.log("RAT switched " + ServiceState.rilRadioTechnologyToString(this.mSS.getRilVoiceRadioTechnology()) + " -> " + ServiceState.rilRadioTechnologyToString(this.mNewSS.getRilVoiceRadioTechnology()) + " at cell " + cid);
            }
            this.mReasonDataDenied = this.mNewReasonDataDenied;
            this.mMaxDataCalls = this.mNewMaxDataCalls;
            this.mRejectCode = this.mNewRejectCode;
        }
        ServiceState tss = this.mSS;
        this.mSS = this.mNewSS;
        this.mNewSS = tss;
        this.mNewSS.setStateOutOfService();
        CellLocation tcl = this.mCellLoc;
        this.mCellLoc = this.mNewCellLoc;
        this.mNewCellLoc = tcl;
        if (hasRilVoiceRadioTechnologyChanged) {
            this.updatePhoneObject();
        }
        TelephonyManager tm = (TelephonyManager)this.mPhone.getContext().getSystemService("phone");
        if (hasRilDataRadioTechnologyChanged) {
            tm.setDataNetworkTypeForPhone(this.mPhone.getPhoneId(), this.mSS.getRilDataRadioTechnology());
            if (18 == this.mSS.getRilDataRadioTechnology()) {
                this.log("pollStateDone: IWLAN enabled");
            }
        }
        if (hasRegistered) {
            this.mNetworkAttachedRegistrants.notifyRegistrants();
            this.log("pollStateDone: registering current mNitzUpdatedTime=" + this.mNitzUpdatedTime + " changing to false");
            this.mNitzUpdatedTime = false;
        }
        if (hasDeregistered) {
            this.mNetworkDetachedRegistrants.notifyRegistrants();
        }
        if (hasRejectCauseChanged) {
            this.setNotification(2001);
        }
        if (hasChanged) {
            this.updateSpnDisplay();
            tm.setNetworkOperatorNameForPhone(this.mPhone.getPhoneId(), this.mSS.getOperatorAlpha());
            String prevOperatorNumeric = tm.getNetworkOperatorForPhone(this.mPhone.getPhoneId());
            String operatorNumeric = this.mSS.getOperatorNumeric();
            if (!this.mPhone.isPhoneTypeGsm() && this.isInvalidOperatorNumeric(operatorNumeric)) {
                int sid = this.mSS.getSystemId();
                operatorNumeric = this.fixUnknownMcc(operatorNumeric, sid);
            }
            tm.setNetworkOperatorNumericForPhone(this.mPhone.getPhoneId(), operatorNumeric);
            this.updateCarrierMccMncConfiguration(operatorNumeric, prevOperatorNumeric, this.mPhone.getContext());
            if (this.isInvalidOperatorNumeric(operatorNumeric)) {
                this.log("operatorNumeric " + operatorNumeric + " is invalid");
                tm.setNetworkCountryIsoForPhone(this.mPhone.getPhoneId(), "");
                this.mGotCountryCode = false;
                this.mNitzUpdatedTime = false;
            } else if (this.mSS.getRilDataRadioTechnology() != 18) {
                String iso = "";
                String mcc = "";
                try {
                    mcc = operatorNumeric.substring(0, 3);
                    iso = MccTable.countryCodeForMcc(Integer.parseInt(mcc));
                }
                catch (NumberFormatException | StringIndexOutOfBoundsException ex) {
                    this.loge("pollStateDone: countryCodeForMcc error: " + ex);
                }
                tm.setNetworkCountryIsoForPhone(this.mPhone.getPhoneId(), iso);
                this.mGotCountryCode = true;
                if (!this.mNitzUpdatedTime && !mcc.equals(INVALID_MCC) && !TextUtils.isEmpty(iso) && this.getAutoTimeZone()) {
                    boolean testOneUniqueOffsetPath = SystemProperties.getBoolean("telephony.test.ignore.nitz", false) && (SystemClock.uptimeMillis() & 1L) == 0L;
                    List<String> uniqueZoneIds = TimeUtils.getTimeZoneIdsWithUniqueOffsets(iso);
                    if (uniqueZoneIds.size() == 1 || testOneUniqueOffsetPath) {
                        String zoneId = uniqueZoneIds.get(0);
                        this.log("pollStateDone: no nitz but one TZ for iso-cc=" + iso + " with zone.getID=" + zoneId + " testOneUniqueOffsetPath=" + testOneUniqueOffsetPath);
                        this.mTimeZoneLog.log("pollStateDone: set time zone=" + zoneId + " mcc=" + mcc + " iso=" + iso);
                        this.setAndBroadcastNetworkSetTimeZone(zoneId);
                    } else {
                        this.log("pollStateDone: there are " + uniqueZoneIds.size() + " unique offsets for iso-cc='" + iso + " testOneUniqueOffsetPath=" + testOneUniqueOffsetPath + "', do nothing");
                    }
                }
                if (!this.mPhone.isPhoneTypeGsm()) {
                    this.setOperatorIdd(operatorNumeric);
                }
                if (this.shouldFixTimeZoneNow(this.mPhone, operatorNumeric, prevOperatorNumeric, this.mNeedFixZoneAfterNitz)) {
                    this.fixTimeZone(iso);
                }
            }
            tm.setNetworkRoamingForPhone(this.mPhone.getPhoneId(), this.mPhone.isPhoneTypeGsm() ? this.mSS.getVoiceRoaming() : this.mSS.getVoiceRoaming() || this.mSS.getDataRoaming());
            this.setRoamingType(this.mSS);
            this.log("Broadcasting ServiceState : " + this.mSS);
            this.mPhone.notifyServiceStateChanged(this.mSS);
            this.mPhone.getContext().getContentResolver().insert(Telephony.ServiceStateTable.getUriForSubscriptionId(this.mPhone.getSubId()), Telephony.ServiceStateTable.getContentValuesForServiceState(this.mSS));
            TelephonyMetrics.getInstance().writeServiceStateChanged(this.mPhone.getPhoneId(), this.mSS);
        }
        if (hasDataAttached || has4gHandoff || hasDataDetached || hasRegistered || hasDeregistered) {
            this.logAttachChange();
        }
        if (hasDataAttached || has4gHandoff) {
            this.mAttachedRegistrants.notifyRegistrants();
        }
        if (hasDataDetached) {
            this.mDetachedRegistrants.notifyRegistrants();
        }
        if (hasRilDataRadioTechnologyChanged || hasRilVoiceRadioTechnologyChanged) {
            this.logRatChange();
        }
        if (hasDataRegStateChanged || hasRilDataRadioTechnologyChanged) {
            this.notifyDataRegStateRilRadioTechnologyChanged();
            if (18 == this.mSS.getRilDataRadioTechnology()) {
                this.mPhone.notifyDataConnection("iwlanAvailable");
            } else {
                this.mPhone.notifyDataConnection(null);
            }
        }
        if (hasVoiceRoamingOn || hasVoiceRoamingOff || hasDataRoamingOn || hasDataRoamingOff) {
            this.logRoamingChange();
        }
        if (hasVoiceRoamingOn) {
            this.mVoiceRoamingOnRegistrants.notifyRegistrants();
        }
        if (hasVoiceRoamingOff) {
            this.mVoiceRoamingOffRegistrants.notifyRegistrants();
        }
        if (hasDataRoamingOn) {
            this.mDataRoamingOnRegistrants.notifyRegistrants();
        }
        if (hasDataRoamingOff) {
            this.mDataRoamingOffRegistrants.notifyRegistrants();
        }
        if (hasLocationChanged) {
            this.mPhone.notifyLocationChanged();
        }
        if (this.mPhone.isPhoneTypeGsm()) {
            if (!this.isGprsConsistent(this.mSS.getDataRegState(), this.mSS.getVoiceRegState())) {
                if (!this.mStartedGprsRegCheck && !this.mReportedGprsNoReg) {
                    this.mStartedGprsRegCheck = true;
                    int check_period = Settings.Global.getInt(this.mPhone.getContext().getContentResolver(), "gprs_register_check_period_ms", 60000);
                    this.sendMessageDelayed(this.obtainMessage(22), check_period);
                }
            } else {
                this.mReportedGprsNoReg = false;
            }
        }
    }

    private void updateOperatorNameFromEri() {
        if (this.mPhone.isPhoneTypeCdma()) {
            if (this.mCi.getRadioState().isOn() && !this.mIsSubscriptionFromRuim) {
                String eriText = this.mSS.getVoiceRegState() == 0 ? this.mPhone.getCdmaEriText() : this.mPhone.getContext().getText(17040709).toString();
                this.mSS.setOperatorAlphaLong(eriText);
            }
        } else if (this.mPhone.isPhoneTypeCdmaLte()) {
            boolean hasBrandOverride;
            boolean bl = hasBrandOverride = this.mUiccController.getUiccCard(this.getPhoneId()) != null && this.mUiccController.getUiccCard(this.getPhoneId()).getOperatorBrandOverride() != null;
            if (!hasBrandOverride && this.mCi.getRadioState().isOn() && this.mPhone.isEriFileLoaded() && (!ServiceState.isLte(this.mSS.getRilVoiceRadioTechnology()) || this.mPhone.getContext().getResources().getBoolean(17956867))) {
                String eriText = this.mSS.getOperatorAlpha();
                if (this.mSS.getVoiceRegState() == 0) {
                    eriText = this.mPhone.getCdmaEriText();
                } else if (this.mSS.getVoiceRegState() == 3) {
                    String string2 = eriText = this.mIccRecords != null ? this.mIccRecords.getServiceProviderName() : null;
                    if (TextUtils.isEmpty(eriText)) {
                        eriText = SystemProperties.get("ro.cdma.home.operator.alpha");
                    }
                } else if (this.mSS.getDataRegState() != 0) {
                    eriText = this.mPhone.getContext().getText(17040709).toString();
                }
                this.mSS.setOperatorAlphaLong(eriText);
            }
            if (this.mUiccApplcation != null && this.mUiccApplcation.getState() == IccCardApplicationStatus.AppState.APPSTATE_READY && this.mIccRecords != null && this.getCombinedRegState() == 0 && !ServiceState.isLte(this.mSS.getRilVoiceRadioTechnology())) {
                boolean showSpn = ((RuimRecords)this.mIccRecords).getCsimSpnDisplayCondition();
                int iconIndex = this.mSS.getCdmaEriIconIndex();
                if (showSpn && iconIndex == 1 && this.isInHomeSidNid(this.mSS.getSystemId(), this.mSS.getNetworkId()) && this.mIccRecords != null) {
                    this.mSS.setOperatorAlphaLong(this.mIccRecords.getServiceProviderName());
                }
            }
        }
    }

    private boolean isInHomeSidNid(int sid, int nid) {
        if (this.isSidsAllZeros()) {
            return true;
        }
        if (this.mHomeSystemId.length != this.mHomeNetworkId.length) {
            return true;
        }
        if (sid == 0) {
            return true;
        }
        for (int i = 0; i < this.mHomeSystemId.length; ++i) {
            if (this.mHomeSystemId[i] != sid || this.mHomeNetworkId[i] != 0 && this.mHomeNetworkId[i] != 65535 && nid != 0 && nid != 65535 && this.mHomeNetworkId[i] != nid) continue;
            return true;
        }
        return false;
    }

    protected void setOperatorIdd(String operatorNumeric) {
        String idd = this.mHbpcdUtils.getIddByMcc(Integer.parseInt(operatorNumeric.substring(0, 3)));
        if (idd != null && !idd.isEmpty()) {
            this.mPhone.setSystemProperty("gsm.operator.idpstring", idd);
        } else {
            this.mPhone.setSystemProperty("gsm.operator.idpstring", "+");
        }
    }

    protected boolean isInvalidOperatorNumeric(String operatorNumeric) {
        return operatorNumeric == null || operatorNumeric.length() < 5 || operatorNumeric.startsWith(INVALID_MCC);
    }

    protected String fixUnknownMcc(String operatorNumeric, int sid) {
        if (sid <= 0) {
            return operatorNumeric;
        }
        boolean isNitzTimeZone = false;
        int timeZone = 0;
        TimeZone tzone = null;
        if (this.mSavedTimeZone != null) {
            timeZone = TimeZone.getTimeZone(this.mSavedTimeZone).getRawOffset() / 3600000;
            isNitzTimeZone = true;
        } else {
            tzone = this.getNitzTimeZone(this.mZoneOffset, this.mZoneDst, this.mZoneTime);
            if (tzone != null) {
                timeZone = tzone.getRawOffset() / 3600000;
            }
        }
        int mcc = this.mHbpcdUtils.getMcc(sid, timeZone, this.mZoneDst ? 1 : 0, isNitzTimeZone);
        if (mcc > 0) {
            operatorNumeric = Integer.toString(mcc) + DEFAULT_MNC;
        }
        return operatorNumeric;
    }

    protected void fixTimeZone(String isoCountryCode) {
        TimeZone zone = null;
        String zoneName = SystemProperties.get(TIMEZONE_PROPERTY);
        this.log("fixTimeZone zoneName='" + zoneName + "' mZoneOffset=" + this.mZoneOffset + " mZoneDst=" + this.mZoneDst + " iso-cc='" + isoCountryCode + "' iso-cc-idx=" + Arrays.binarySearch(GMT_COUNTRY_CODES, isoCountryCode));
        if ("".equals(isoCountryCode) && this.mNeedFixZoneAfterNitz) {
            zone = this.getNitzTimeZone(this.mZoneOffset, this.mZoneDst, this.mZoneTime);
            this.log("pollStateDone: using NITZ TimeZone");
        } else if (this.mZoneOffset == 0 && !this.mZoneDst && zoneName != null && zoneName.length() > 0 && Arrays.binarySearch(GMT_COUNTRY_CODES, isoCountryCode) < 0) {
            zone = TimeZone.getDefault();
            if (this.mNeedFixZoneAfterNitz) {
                long ctm = System.currentTimeMillis();
                long tzOffset = zone.getOffset(ctm);
                this.log("fixTimeZone: tzOffset=" + tzOffset + " ltod=" + TimeUtils.logTimeOfDay(ctm));
                if (this.getAutoTime()) {
                    long adj = ctm - tzOffset;
                    this.log("fixTimeZone: adj ltod=" + TimeUtils.logTimeOfDay(adj));
                    this.setAndBroadcastNetworkSetTime(adj);
                } else {
                    this.mSavedTime -= tzOffset;
                    this.log("fixTimeZone: adj mSavedTime=" + this.mSavedTime);
                }
            }
            this.log("fixTimeZone: using default TimeZone");
        } else {
            zone = TimeUtils.getTimeZone(this.mZoneOffset, this.mZoneDst, this.mZoneTime, isoCountryCode);
            this.log("fixTimeZone: using getTimeZone(off, dst, time, iso)");
        }
        String tmpLog = "fixTimeZone zoneName=" + zoneName + " mZoneOffset=" + this.mZoneOffset + " mZoneDst=" + this.mZoneDst + " iso-cc=" + isoCountryCode + " mNeedFixZoneAfterNitz=" + this.mNeedFixZoneAfterNitz + " zone=" + (zone != null ? zone.getID() : "NULL");
        this.mTimeZoneLog.log(tmpLog);
        if (zone != null) {
            this.log("fixTimeZone: zone != null zone.getID=" + zone.getID());
            if (this.getAutoTimeZone()) {
                this.setAndBroadcastNetworkSetTimeZone(zone.getID());
            } else {
                this.log("fixTimeZone: skip changing zone as getAutoTimeZone was false");
            }
            if (this.mNeedFixZoneAfterNitz) {
                this.saveNitzTimeZone(zone.getID());
            }
        } else {
            this.log("fixTimeZone: zone == null, do nothing for zone");
        }
        this.mNeedFixZoneAfterNitz = false;
    }

    private boolean isGprsConsistent(int dataRegState, int voiceRegState) {
        return voiceRegState != 0 || dataRegState == 0;
    }

    private TimeZone getNitzTimeZone(int offset, boolean dst, long when) {
        TimeZone guess = this.findTimeZone(offset, dst, when);
        if (guess == null) {
            guess = this.findTimeZone(offset, !dst, when);
        }
        this.log("getNitzTimeZone returning " + (guess == null ? guess : guess.getID()));
        return guess;
    }

    private TimeZone findTimeZone(int offset, boolean dst, long when) {
        int rawOffset = offset;
        if (dst) {
            rawOffset -= 3600000;
        }
        String[] zones = TimeZone.getAvailableIDs(rawOffset);
        TimeZone guess = null;
        Date d = new Date(when);
        for (String zone : zones) {
            TimeZone tz = TimeZone.getTimeZone(zone);
            if (tz.getOffset(when) != offset || tz.inDaylightTime(d) != dst) continue;
            guess = tz;
            break;
        }
        return guess;
    }

    private int regCodeToServiceState(int code) {
        switch (code) {
            case 1: 
            case 5: {
                return 0;
            }
        }
        return 1;
    }

    private boolean regCodeIsRoaming(int code) {
        return 5 == code;
    }

    private boolean isSameOperatorNameFromSimAndSS(ServiceState s) {
        String spn = ((TelephonyManager)this.mPhone.getContext().getSystemService("phone")).getSimOperatorNameForPhone(this.getPhoneId());
        String onsl = s.getOperatorAlphaLong();
        String onss = s.getOperatorAlphaShort();
        boolean equalsOnsl = !TextUtils.isEmpty(spn) && spn.equalsIgnoreCase(onsl);
        boolean equalsOnss = !TextUtils.isEmpty(spn) && spn.equalsIgnoreCase(onss);
        return equalsOnsl || equalsOnss;
    }

    private boolean isSameNamedOperators(ServiceState s) {
        return this.currentMccEqualsSimMcc(s) && this.isSameOperatorNameFromSimAndSS(s);
    }

    private boolean currentMccEqualsSimMcc(ServiceState s) {
        String simNumeric = ((TelephonyManager)this.mPhone.getContext().getSystemService("phone")).getSimOperatorNumericForPhone(this.getPhoneId());
        String operatorNumeric = s.getOperatorNumeric();
        boolean equalsMcc = true;
        try {
            equalsMcc = simNumeric.substring(0, 3).equals(operatorNumeric.substring(0, 3));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return equalsMcc;
    }

    private boolean isOperatorConsideredNonRoaming(ServiceState s) {
        PersistableBundle config;
        String operatorNumeric = s.getOperatorNumeric();
        CarrierConfigManager configManager = (CarrierConfigManager)this.mPhone.getContext().getSystemService("carrier_config");
        String[] numericArray = null;
        if (configManager != null && (config = configManager.getConfigForSubId(this.mPhone.getSubId())) != null) {
            numericArray = config.getStringArray("non_roaming_operator_string_array");
        }
        if (ArrayUtils.isEmpty(numericArray) || operatorNumeric == null) {
            return false;
        }
        for (String numeric : numericArray) {
            if (TextUtils.isEmpty(numeric) || !operatorNumeric.startsWith(numeric)) continue;
            return true;
        }
        return false;
    }

    private boolean isOperatorConsideredRoaming(ServiceState s) {
        PersistableBundle config;
        String operatorNumeric = s.getOperatorNumeric();
        CarrierConfigManager configManager = (CarrierConfigManager)this.mPhone.getContext().getSystemService("carrier_config");
        String[] numericArray = null;
        if (configManager != null && (config = configManager.getConfigForSubId(this.mPhone.getSubId())) != null) {
            numericArray = config.getStringArray("roaming_operator_string_array");
        }
        if (ArrayUtils.isEmpty(numericArray) || operatorNumeric == null) {
            return false;
        }
        for (String numeric : numericArray) {
            if (TextUtils.isEmpty(numeric) || !operatorNumeric.startsWith(numeric)) continue;
            return true;
        }
        return false;
    }

    private void onRestrictedStateChanged(AsyncResult ar) {
        RestrictedState newRs = new RestrictedState();
        this.log("onRestrictedStateChanged: E rs " + this.mRestrictedState);
        if (ar.exception == null && ar.result != null) {
            int state = (Integer)ar.result;
            newRs.setCsEmergencyRestricted((state & 1) != 0 || (state & 4) != 0);
            if (this.mUiccApplcation != null && this.mUiccApplcation.getState() == IccCardApplicationStatus.AppState.APPSTATE_READY) {
                newRs.setCsNormalRestricted((state & 2) != 0 || (state & 4) != 0);
                newRs.setPsRestricted((state & 0x10) != 0);
            }
            this.log("onRestrictedStateChanged: new rs " + newRs);
            if (!this.mRestrictedState.isPsRestricted() && newRs.isPsRestricted()) {
                this.mPsRestrictEnabledRegistrants.notifyRegistrants();
                this.setNotification(1001);
            } else if (this.mRestrictedState.isPsRestricted() && !newRs.isPsRestricted()) {
                this.mPsRestrictDisabledRegistrants.notifyRegistrants();
                this.setNotification(1002);
            }
            if (this.mRestrictedState.isCsRestricted()) {
                if (!newRs.isAnyCsRestricted()) {
                    this.setNotification(1004);
                } else if (!newRs.isCsNormalRestricted()) {
                    this.setNotification(1006);
                } else if (!newRs.isCsEmergencyRestricted()) {
                    this.setNotification(1005);
                }
            } else if (this.mRestrictedState.isCsEmergencyRestricted() && !this.mRestrictedState.isCsNormalRestricted()) {
                if (!newRs.isAnyCsRestricted()) {
                    this.setNotification(1004);
                } else if (newRs.isCsRestricted()) {
                    this.setNotification(1003);
                } else if (newRs.isCsNormalRestricted()) {
                    this.setNotification(1005);
                }
            } else if (!this.mRestrictedState.isCsEmergencyRestricted() && this.mRestrictedState.isCsNormalRestricted()) {
                if (!newRs.isAnyCsRestricted()) {
                    this.setNotification(1004);
                } else if (newRs.isCsRestricted()) {
                    this.setNotification(1003);
                } else if (newRs.isCsEmergencyRestricted()) {
                    this.setNotification(1006);
                }
            } else if (newRs.isCsRestricted()) {
                this.setNotification(1003);
            } else if (newRs.isCsEmergencyRestricted()) {
                this.setNotification(1006);
            } else if (newRs.isCsNormalRestricted()) {
                this.setNotification(1005);
            }
            this.mRestrictedState = newRs;
        }
        this.log("onRestrictedStateChanged: X rs " + this.mRestrictedState);
    }

    public CellLocation getCellLocation(WorkSource workSource) {
        if (((GsmCellLocation)this.mCellLoc).getLac() >= 0 && ((GsmCellLocation)this.mCellLoc).getCid() >= 0) {
            return this.mCellLoc;
        }
        List<CellInfo> result = this.getAllCellInfo(workSource);
        if (result != null) {
            GsmCellLocation cellLocOther = new GsmCellLocation();
            for (CellInfo ci : result) {
                CellInfoLte cellInfoLte;
                android.telephony.CellIdentityLte cellIdentityLte;
                if (ci instanceof CellInfoGsm) {
                    CellInfoGsm cellInfoGsm = (CellInfoGsm)ci;
                    android.telephony.CellIdentityGsm cellIdentityGsm = cellInfoGsm.getCellIdentity();
                    cellLocOther.setLacAndCid(cellIdentityGsm.getLac(), cellIdentityGsm.getCid());
                    cellLocOther.setPsc(cellIdentityGsm.getPsc());
                    return cellLocOther;
                }
                if (ci instanceof CellInfoWcdma) {
                    CellInfoWcdma cellInfoWcdma = (CellInfoWcdma)ci;
                    CellIdentityWcdma cellIdentityWcdma = cellInfoWcdma.getCellIdentity();
                    cellLocOther.setLacAndCid(cellIdentityWcdma.getLac(), cellIdentityWcdma.getCid());
                    cellLocOther.setPsc(cellIdentityWcdma.getPsc());
                    return cellLocOther;
                }
                if (!(ci instanceof CellInfoLte) || cellLocOther.getLac() >= 0 && cellLocOther.getCid() >= 0 || (cellIdentityLte = (cellInfoLte = (CellInfoLte)ci).getCellIdentity()).getTac() == Integer.MAX_VALUE || cellIdentityLte.getCi() == Integer.MAX_VALUE) continue;
                cellLocOther.setLacAndCid(cellIdentityLte.getTac(), cellIdentityLte.getCi());
                cellLocOther.setPsc(0);
            }
            return cellLocOther;
        }
        return this.mCellLoc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTimeFromNITZString(String nitz, long nitzReceiveTime) {
        long start = SystemClock.elapsedRealtime();
        this.log("NITZ: " + nitz + "," + nitzReceiveTime + " start=" + start + " delay=" + (start - nitzReceiveTime));
        try {
            String ignore;
            Calendar c = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
            c.clear();
            c.set(16, 0);
            String[] nitzSubs = nitz.split("[/:,+-]");
            int year = 2000 + Integer.parseInt(nitzSubs[0]);
            if (year > 2037) {
                this.loge("NITZ year: " + year + " exceeds limit, skip NITZ time update");
                return;
            }
            c.set(1, year);
            int month = Integer.parseInt(nitzSubs[1]) - 1;
            c.set(2, month);
            int date = Integer.parseInt(nitzSubs[2]);
            c.set(5, date);
            int hour = Integer.parseInt(nitzSubs[3]);
            c.set(10, hour);
            int minute = Integer.parseInt(nitzSubs[4]);
            c.set(12, minute);
            int second = Integer.parseInt(nitzSubs[5]);
            c.set(13, second);
            boolean sign = nitz.indexOf(45) == -1;
            int tzOffset = Integer.parseInt(nitzSubs[6]);
            int dst = nitzSubs.length >= 8 ? Integer.parseInt(nitzSubs[7]) : 0;
            tzOffset = (sign ? 1 : -1) * tzOffset * 15 * 60 * 1000;
            TimeZone zone = null;
            if (nitzSubs.length >= 9) {
                String tzname = nitzSubs[8].replace('!', '/');
                zone = TimeZone.getTimeZone(tzname);
            }
            String iso = ((TelephonyManager)this.mPhone.getContext().getSystemService("phone")).getNetworkCountryIsoForPhone(this.mPhone.getPhoneId());
            if (zone == null && this.mGotCountryCode) {
                zone = iso != null && iso.length() > 0 ? TimeUtils.getTimeZone(tzOffset, dst != 0, c.getTimeInMillis(), iso) : this.getNitzTimeZone(tzOffset, dst != 0, c.getTimeInMillis());
            }
            if (zone == null || this.mZoneOffset != tzOffset || this.mZoneDst != (dst != 0)) {
                this.mNeedFixZoneAfterNitz = true;
                this.mZoneOffset = tzOffset;
                this.mZoneDst = dst != 0;
                this.mZoneTime = c.getTimeInMillis();
            }
            String tmpLog = "NITZ: nitz=" + nitz + " nitzReceiveTime=" + nitzReceiveTime + " tzOffset=" + tzOffset + " dst=" + dst + " zone=" + (zone != null ? zone.getID() : "NULL") + " iso=" + iso + " mGotCountryCode=" + this.mGotCountryCode + " mNeedFixZoneAfterNitz=" + this.mNeedFixZoneAfterNitz + " getAutoTimeZone()=" + this.getAutoTimeZone();
            this.log(tmpLog);
            this.mTimeZoneLog.log(tmpLog);
            if (zone != null) {
                if (this.getAutoTimeZone()) {
                    this.setAndBroadcastNetworkSetTimeZone(zone.getID());
                }
                this.saveNitzTimeZone(zone.getID());
            }
            if ((ignore = SystemProperties.get("gsm.ignore-nitz")) != null && ignore.equals("yes")) {
                this.log("NITZ: Not setting clock because gsm.ignore-nitz is set");
                return;
            }
            try {
                this.mWakeLock.acquire();
                if (!this.mPhone.isPhoneTypeGsm() || this.getAutoTime()) {
                    long millisSinceNitzReceived = SystemClock.elapsedRealtime() - nitzReceiveTime;
                    if (millisSinceNitzReceived < 0L) {
                        this.log("NITZ: not setting time, clock has rolled backwards since NITZ time was received, " + nitz);
                        return;
                    }
                    if (millisSinceNitzReceived > Integer.MAX_VALUE) {
                        this.log("NITZ: not setting time, processing has taken " + millisSinceNitzReceived / 86400000L + " days");
                        return;
                    }
                    c.add(14, (int)millisSinceNitzReceived);
                    tmpLog = "NITZ: nitz=" + nitz + " nitzReceiveTime=" + nitzReceiveTime + " Setting time of day to " + c.getTime() + " NITZ receive delay(ms): " + millisSinceNitzReceived + " gained(ms): " + (c.getTimeInMillis() - System.currentTimeMillis()) + " from " + nitz;
                    this.log(tmpLog);
                    this.mTimeLog.log(tmpLog);
                    if (this.mPhone.isPhoneTypeGsm()) {
                        this.setAndBroadcastNetworkSetTime(c.getTimeInMillis());
                        Rlog.i(LOG_TAG, "NITZ: after Setting time of day");
                    } else if (this.getAutoTime()) {
                        long gained = c.getTimeInMillis() - System.currentTimeMillis();
                        long timeSinceLastUpdate = SystemClock.elapsedRealtime() - this.mSavedAtTime;
                        int nitzUpdateSpacing = Settings.Global.getInt(this.mCr, "nitz_update_spacing", this.mNitzUpdateSpacing);
                        int nitzUpdateDiff = Settings.Global.getInt(this.mCr, "nitz_update_diff", this.mNitzUpdateDiff);
                        if (this.mSavedAtTime == 0L || timeSinceLastUpdate > (long)nitzUpdateSpacing || Math.abs(gained) > (long)nitzUpdateDiff) {
                            this.log("NITZ: Auto updating time of day to " + c.getTime() + " NITZ receive delay=" + millisSinceNitzReceived + "ms gained=" + gained + "ms from " + nitz);
                            this.setAndBroadcastNetworkSetTime(c.getTimeInMillis());
                        } else {
                            this.log("NITZ: ignore, a previous update was " + timeSinceLastUpdate + "ms ago and gained=" + gained + "ms");
                            return;
                        }
                    }
                }
                SystemProperties.set("gsm.nitz.time", String.valueOf(c.getTimeInMillis()));
                this.saveNitzTime(c.getTimeInMillis());
                this.mNitzUpdatedTime = true;
            }
            finally {
                long end = SystemClock.elapsedRealtime();
                this.log("NITZ: end=" + end + " dur=" + (end - start));
                this.mWakeLock.release();
            }
        }
        catch (RuntimeException ex) {
            this.loge("NITZ: Parsing NITZ time " + nitz + " ex=" + ex);
        }
    }

    private boolean getAutoTime() {
        try {
            return Settings.Global.getInt(this.mCr, "auto_time") > 0;
        }
        catch (Settings.SettingNotFoundException snfe) {
            return true;
        }
    }

    private boolean getAutoTimeZone() {
        try {
            return Settings.Global.getInt(this.mCr, "auto_time_zone") > 0;
        }
        catch (Settings.SettingNotFoundException snfe) {
            return true;
        }
    }

    private void saveNitzTimeZone(String zoneId) {
        this.mSavedTimeZone = zoneId;
    }

    private void saveNitzTime(long time) {
        this.mSavedTime = time;
        this.mSavedAtTime = SystemClock.elapsedRealtime();
    }

    private void setAndBroadcastNetworkSetTimeZone(String zoneId) {
        this.log("setAndBroadcastNetworkSetTimeZone: setTimeZone=" + zoneId);
        AlarmManager alarm = (AlarmManager)this.mPhone.getContext().getSystemService("alarm");
        alarm.setTimeZone(zoneId);
        Intent intent = new Intent("android.intent.action.NETWORK_SET_TIMEZONE");
        intent.addFlags(0x20000000);
        intent.putExtra("time-zone", zoneId);
        this.mPhone.getContext().sendStickyBroadcastAsUser(intent, UserHandle.ALL);
        this.log("setAndBroadcastNetworkSetTimeZone: call alarm.setTimeZone and broadcast zoneId=" + zoneId);
    }

    private void setAndBroadcastNetworkSetTime(long time) {
        this.log("setAndBroadcastNetworkSetTime: time=" + time + "ms");
        SystemClock.setCurrentTimeMillis(time);
        Intent intent = new Intent("android.intent.action.NETWORK_SET_TIME");
        intent.addFlags(0x20000000);
        intent.putExtra("time", time);
        this.mPhone.getContext().sendStickyBroadcastAsUser(intent, UserHandle.ALL);
        TelephonyMetrics.getInstance().writeNITZEvent(this.mPhone.getPhoneId(), time);
    }

    private void revertToNitzTime() {
        if (Settings.Global.getInt(this.mCr, "auto_time", 0) == 0) {
            return;
        }
        this.log("Reverting to NITZ Time: mSavedTime=" + this.mSavedTime + " mSavedAtTime=" + this.mSavedAtTime);
        if (this.mSavedTime != 0L && this.mSavedAtTime != 0L) {
            long currTime = SystemClock.elapsedRealtime();
            this.mTimeLog.log("Reverting to NITZ time, currTime=" + currTime + " mSavedAtTime=" + this.mSavedAtTime + " mSavedTime=" + this.mSavedTime);
            this.setAndBroadcastNetworkSetTime(this.mSavedTime + (currTime - this.mSavedAtTime));
        }
    }

    private void revertToNitzTimeZone() {
        if (Settings.Global.getInt(this.mCr, "auto_time_zone", 0) == 0) {
            return;
        }
        String tmpLog = "Reverting to NITZ TimeZone: tz=" + this.mSavedTimeZone;
        this.log(tmpLog);
        this.mTimeZoneLog.log(tmpLog);
        if (this.mSavedTimeZone != null) {
            this.setAndBroadcastNetworkSetTimeZone(this.mSavedTimeZone);
        }
    }

    private void cancelAllNotifications() {
        this.log("setNotification: cancelAllNotifications");
        NotificationManager notificationManager = (NotificationManager)this.mPhone.getContext().getSystemService("notification");
        notificationManager.cancelAll();
    }

    public void setNotification(int notifyType) {
        boolean disableVoiceBarringNotification;
        PersistableBundle bundle;
        this.log("setNotification: create notification " + notifyType);
        boolean isSetNotification = this.mPhone.getContext().getResources().getBoolean(17957053);
        if (!isSetNotification) {
            this.log("Ignore all the notifications");
            return;
        }
        Context context = this.mPhone.getContext();
        CarrierConfigManager configManager = (CarrierConfigManager)context.getSystemService("carrier_config");
        if (configManager != null && (bundle = configManager.getConfig()) != null && (disableVoiceBarringNotification = bundle.getBoolean("disable_voice_barring_notification_bool", false)) && (notifyType == 1003 || notifyType == 1005 || notifyType == 1006)) {
            this.log("Voice/emergency call barred notification disabled");
            return;
        }
        CharSequence details = "";
        CharSequence title = "";
        int notificationId = 999;
        int icon = 17301642;
        switch (notifyType) {
            case 1001: {
                long dataSubId = SubscriptionManager.getDefaultDataSubscriptionId();
                if (dataSubId != (long)this.mPhone.getSubId()) {
                    return;
                }
                notificationId = 888;
                title = context.getText(17039412);
                details = context.getText(17039415);
                break;
            }
            case 1002: {
                notificationId = 888;
                break;
            }
            case 1003: {
                title = context.getText(17039411);
                details = context.getText(17039415);
                break;
            }
            case 1005: {
                title = context.getText(17039414);
                details = context.getText(17039415);
                break;
            }
            case 1006: {
                title = context.getText(17039413);
                details = context.getText(17039415);
                break;
            }
            case 1004: {
                break;
            }
            case 2001: {
                notificationId = 111;
                int resId = this.selectResourceForRejectCode(this.mRejectCode);
                if (0 == resId) {
                    this.loge("setNotification: mRejectCode=" + this.mRejectCode + " is not handled.");
                    return;
                }
                icon = 17303422;
                title = Resources.getSystem().getString(resId);
                details = null;
            }
        }
        this.log("setNotification, create notification, notifyType: " + notifyType + ", title: " + title + ", details: " + details);
        this.mNotification = new Notification.Builder(context).setWhen(System.currentTimeMillis()).setAutoCancel(true).setSmallIcon(icon).setTicker(title).setColor(context.getResources().getColor(17170763)).setContentTitle(title).setStyle(new Notification.BigTextStyle().bigText(details)).setContentText(details).setChannel("alert").build();
        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
        if (notifyType == 1002 || notifyType == 1004) {
            notificationManager.cancel(notificationId);
        } else {
            notificationManager.notify(notificationId, this.mNotification);
        }
    }

    private int selectResourceForRejectCode(int rejCode) {
        int rejResourceId = 0;
        switch (rejCode) {
            case 1: {
                rejResourceId = 17040251;
                break;
            }
            case 2: {
                rejResourceId = 17040254;
                break;
            }
            case 3: {
                rejResourceId = 17040253;
                break;
            }
            case 6: {
                rejResourceId = 17040252;
                break;
            }
        }
        return rejResourceId;
    }

    private UiccCardApplication getUiccCardApplication() {
        if (this.mPhone.isPhoneTypeGsm()) {
            return this.mUiccController.getUiccCardApplication(this.mPhone.getPhoneId(), 1);
        }
        return this.mUiccController.getUiccCardApplication(this.mPhone.getPhoneId(), 2);
    }

    private void queueNextSignalStrengthPoll() {
        if (this.mDontPollSignalStrength) {
            return;
        }
        Message msg = this.obtainMessage();
        msg.what = 10;
        this.sendMessageDelayed(msg, 20000L);
    }

    private void notifyCdmaSubscriptionInfoReady() {
        if (this.mCdmaForSubscriptionInfoReadyRegistrants != null) {
            this.log("CDMA_SUBSCRIPTION: call notifyRegistrants()");
            this.mCdmaForSubscriptionInfoReadyRegistrants.notifyRegistrants();
        }
    }

    public void registerForDataConnectionAttached(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.mAttachedRegistrants.add(r);
        if (this.getCurrentDataConnectionState() == 0) {
            r.notifyRegistrant();
        }
    }

    public void unregisterForDataConnectionAttached(Handler h) {
        this.mAttachedRegistrants.remove(h);
    }

    public void registerForDataConnectionDetached(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.mDetachedRegistrants.add(r);
        if (this.getCurrentDataConnectionState() != 0) {
            r.notifyRegistrant();
        }
    }

    public void unregisterForDataConnectionDetached(Handler h) {
        this.mDetachedRegistrants.remove(h);
    }

    public void registerForDataRegStateOrRatChanged(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.mDataRegStateOrRatChangedRegistrants.add(r);
        this.notifyDataRegStateRilRadioTechnologyChanged();
    }

    public void unregisterForDataRegStateOrRatChanged(Handler h) {
        this.mDataRegStateOrRatChangedRegistrants.remove(h);
    }

    public void registerForNetworkAttached(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.mNetworkAttachedRegistrants.add(r);
        if (this.mSS.getVoiceRegState() == 0) {
            r.notifyRegistrant();
        }
    }

    public void unregisterForNetworkAttached(Handler h) {
        this.mNetworkAttachedRegistrants.remove(h);
    }

    public void registerForNetworkDetached(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.mNetworkDetachedRegistrants.add(r);
        if (this.mSS.getVoiceRegState() != 0) {
            r.notifyRegistrant();
        }
    }

    public void unregisterForNetworkDetached(Handler h) {
        this.mNetworkDetachedRegistrants.remove(h);
    }

    public void registerForPsRestrictedEnabled(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.mPsRestrictEnabledRegistrants.add(r);
        if (this.mRestrictedState.isPsRestricted()) {
            r.notifyRegistrant();
        }
    }

    public void unregisterForPsRestrictedEnabled(Handler h) {
        this.mPsRestrictEnabledRegistrants.remove(h);
    }

    public void registerForPsRestrictedDisabled(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.mPsRestrictDisabledRegistrants.add(r);
        if (this.mRestrictedState.isPsRestricted()) {
            r.notifyRegistrant();
        }
    }

    public void unregisterForPsRestrictedDisabled(Handler h) {
        this.mPsRestrictDisabledRegistrants.remove(h);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void powerOffRadioSafely(DcTracker dcTracker) {
        ServiceStateTracker serviceStateTracker = this;
        synchronized (serviceStateTracker) {
            if (!this.mPendingRadioPowerOffAfterDataOff) {
                if (this.mPhone.isPhoneTypeGsm() || this.mPhone.isPhoneTypeCdmaLte()) {
                    int dds = SubscriptionManager.getDefaultDataSubscriptionId();
                    if (dcTracker.isDisconnected() && (dds == this.mPhone.getSubId() || dds != this.mPhone.getSubId() && ProxyController.getInstance().isDataDisconnected(dds))) {
                        dcTracker.cleanUpAllConnections("radioTurnedOff");
                        this.log("Data disconnected, turn off radio right away.");
                        this.hangupAndPowerOff();
                    } else {
                        if (this.mPhone.isPhoneTypeGsm() && this.mPhone.isInCall()) {
                            this.mPhone.mCT.mRingingCall.hangupIfAlive();
                            this.mPhone.mCT.mBackgroundCall.hangupIfAlive();
                            this.mPhone.mCT.mForegroundCall.hangupIfAlive();
                        }
                        dcTracker.cleanUpAllConnections("radioTurnedOff");
                        if (dds != this.mPhone.getSubId() && !ProxyController.getInstance().isDataDisconnected(dds)) {
                            this.log("Data is active on DDS.  Wait for all data disconnect");
                            ProxyController.getInstance().registerForAllDataDisconnected(dds, this, 49, null);
                            this.mPendingRadioPowerOffAfterDataOff = true;
                        }
                        Message msg = Message.obtain(this);
                        msg.what = 38;
                        msg.arg1 = ++this.mPendingRadioPowerOffAfterDataOffTag;
                        if (this.sendMessageDelayed(msg, 30000L)) {
                            this.log("Wait upto 30s for data to disconnect, then turn off radio.");
                            this.mPendingRadioPowerOffAfterDataOff = true;
                        } else {
                            this.log("Cannot send delayed Msg, turn off radio right away.");
                            this.hangupAndPowerOff();
                            this.mPendingRadioPowerOffAfterDataOff = false;
                        }
                    }
                } else {
                    String[] networkNotClearData = this.mPhone.getContext().getResources().getStringArray(17236050);
                    String currentNetwork = this.mSS.getOperatorNumeric();
                    if (networkNotClearData != null && currentNetwork != null) {
                        for (int i = 0; i < networkNotClearData.length; ++i) {
                            if (!currentNetwork.equals(networkNotClearData[i])) continue;
                            this.log("Not disconnecting data for " + currentNetwork);
                            this.hangupAndPowerOff();
                            return;
                        }
                    }
                    if (dcTracker.isDisconnected()) {
                        dcTracker.cleanUpAllConnections("radioTurnedOff");
                        this.log("Data disconnected, turn off radio right away.");
                        this.hangupAndPowerOff();
                    } else {
                        dcTracker.cleanUpAllConnections("radioTurnedOff");
                        Message msg = Message.obtain(this);
                        msg.what = 38;
                        msg.arg1 = ++this.mPendingRadioPowerOffAfterDataOffTag;
                        if (this.sendMessageDelayed(msg, 30000L)) {
                            this.log("Wait upto 30s for data to disconnect, then turn off radio.");
                            this.mPendingRadioPowerOffAfterDataOff = true;
                        } else {
                            this.log("Cannot send delayed Msg, turn off radio right away.");
                            this.hangupAndPowerOff();
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processPendingRadioPowerOffAfterDataOff() {
        ServiceStateTracker serviceStateTracker = this;
        synchronized (serviceStateTracker) {
            if (this.mPendingRadioPowerOffAfterDataOff) {
                this.log("Process pending request to turn radio off.");
                ++this.mPendingRadioPowerOffAfterDataOffTag;
                this.hangupAndPowerOff();
                this.mPendingRadioPowerOffAfterDataOff = false;
                return true;
            }
            return false;
        }
    }

    private boolean containsEarfcnInEarfcnRange(ArrayList<Pair<Integer, Integer>> earfcnPairList, int earfcn) {
        if (earfcnPairList != null) {
            for (Pair<Integer, Integer> earfcnPair : earfcnPairList) {
                if (earfcn < (Integer)earfcnPair.first || earfcn > (Integer)earfcnPair.second) continue;
                return true;
            }
        }
        return false;
    }

    ArrayList<Pair<Integer, Integer>> convertEarfcnStringArrayToPairList(String[] earfcnsList) {
        ArrayList<Pair<Integer, Integer>> earfcnPairList = new ArrayList<Pair<Integer, Integer>>();
        if (earfcnsList != null) {
            for (int i = 0; i < earfcnsList.length; ++i) {
                try {
                    int earfcnEnd;
                    String[] earfcns = earfcnsList[i].split("-");
                    if (earfcns.length != 2) {
                        return null;
                    }
                    int earfcnStart = Integer.parseInt(earfcns[0]);
                    if (earfcnStart > (earfcnEnd = Integer.parseInt(earfcns[1]))) {
                        return null;
                    }
                    earfcnPairList.add(new Pair<Integer, Integer>(earfcnStart, earfcnEnd));
                    continue;
                }
                catch (PatternSyntaxException pse) {
                    return null;
                }
                catch (NumberFormatException nfe) {
                    return null;
                }
            }
        }
        return earfcnPairList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLteEarfcnLists() {
        CarrierConfigManager configManager = (CarrierConfigManager)this.mPhone.getContext().getSystemService("carrier_config");
        PersistableBundle b = configManager.getConfigForSubId(this.mPhone.getSubId());
        Object object = this.mLteRsrpBoostLock;
        synchronized (object) {
            this.mLteRsrpBoost = b.getInt("lte_earfcns_rsrp_boost_int", 0);
            String[] earfcnsStringArrayForRsrpBoost = b.getStringArray("boosted_lte_earfcns_string_array");
            this.mEarfcnPairListForRsrpBoost = this.convertEarfcnStringArrayToPairList(earfcnsStringArrayForRsrpBoost);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateServiceStateLteEarfcnBoost(ServiceState serviceState, int lteEarfcn) {
        Object object = this.mLteRsrpBoostLock;
        synchronized (object) {
            if (lteEarfcn != -1 && this.containsEarfcnInEarfcnRange(this.mEarfcnPairListForRsrpBoost, lteEarfcn)) {
                serviceState.setLteEarfcnRsrpBoost(this.mLteRsrpBoost);
            } else {
                serviceState.setLteEarfcnRsrpBoost(0);
            }
        }
    }

    protected boolean onSignalStrengthResult(AsyncResult ar) {
        boolean isGsm = false;
        int dataRat = this.mSS.getRilDataRadioTechnology();
        int voiceRat = this.mSS.getRilVoiceRadioTechnology();
        if (dataRat != 18 && ServiceState.isGsm(dataRat) || voiceRat != 18 && ServiceState.isGsm(voiceRat)) {
            isGsm = true;
        }
        if (ar.exception == null && ar.result != null) {
            this.mSignalStrength = (SignalStrength)ar.result;
            this.mSignalStrength.validateInput();
            this.mSignalStrength.setGsm(isGsm);
            this.mSignalStrength.setLteRsrpBoost(this.mSS.getLteEarfcnRsrpBoost());
        } else {
            this.log("onSignalStrengthResult() Exception from RIL : " + ar.exception);
            this.mSignalStrength = new SignalStrength(isGsm);
        }
        boolean ssChanged = this.notifySignalStrength();
        return ssChanged;
    }

    protected void hangupAndPowerOff() {
        if (!this.mPhone.isPhoneTypeGsm() || this.mPhone.isInCall()) {
            this.mPhone.mCT.mRingingCall.hangupIfAlive();
            this.mPhone.mCT.mBackgroundCall.hangupIfAlive();
            this.mPhone.mCT.mForegroundCall.hangupIfAlive();
        }
        this.mCi.setRadioPower(false, null);
    }

    protected void cancelPollState() {
        this.mPollingContext = new int[1];
    }

    protected boolean shouldFixTimeZoneNow(Phone phone, String operatorNumeric, String prevOperatorNumeric, boolean needToFixTimeZone) {
        int prevMcc;
        int mcc;
        try {
            mcc = Integer.parseInt(operatorNumeric.substring(0, 3));
        }
        catch (Exception e) {
            this.log("shouldFixTimeZoneNow: no mcc, operatorNumeric=" + operatorNumeric + " retVal=false");
            return false;
        }
        try {
            prevMcc = Integer.parseInt(prevOperatorNumeric.substring(0, 3));
        }
        catch (Exception e) {
            prevMcc = mcc + 1;
        }
        boolean iccCardExist = false;
        if (this.mUiccApplcation != null) {
            iccCardExist = this.mUiccApplcation.getState() != IccCardApplicationStatus.AppState.APPSTATE_UNKNOWN;
        }
        boolean retVal = iccCardExist && mcc != prevMcc || needToFixTimeZone;
        long ctm = System.currentTimeMillis();
        this.log("shouldFixTimeZoneNow: retVal=" + retVal + " iccCardExist=" + iccCardExist + " operatorNumeric=" + operatorNumeric + " mcc=" + mcc + " prevOperatorNumeric=" + prevOperatorNumeric + " prevMcc=" + prevMcc + " needToFixTimeZone=" + needToFixTimeZone + " ltod=" + TimeUtils.logTimeOfDay(ctm));
        return retVal;
    }

    public String getSystemProperty(String property, String defValue) {
        return TelephonyManager.getTelephonyProperty(this.mPhone.getPhoneId(), property, defValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CellInfo> getAllCellInfo(WorkSource workSource) {
        CellInfoResult result = new CellInfoResult();
        int ver = this.mCi.getRilVersion();
        if (ver >= 8) {
            if (this.isCallerOnDifferentThread()) {
                if (SystemClock.elapsedRealtime() - this.mLastCellInfoListTime > 2000L) {
                    Message msg = this.obtainMessage(43, result);
                    Object object = result.lockObj;
                    synchronized (object) {
                        result.list = null;
                        this.mCi.getCellInfoList(msg, workSource);
                        try {
                            result.lockObj.wait(5000L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                }
                this.log("SST.getAllCellInfo(): return last, back to back calls");
                result.list = this.mLastCellInfoList;
            } else {
                this.log("SST.getAllCellInfo(): return last, same thread can't block");
                result.list = this.mLastCellInfoList;
            }
        } else {
            this.log("SST.getAllCellInfo(): not implemented");
            result.list = null;
        }
        Object object = result.lockObj;
        synchronized (object) {
            if (result.list != null) {
                return result.list;
            }
            this.log("SST.getAllCellInfo(): X size=0 list=null");
            return null;
        }
    }

    public SignalStrength getSignalStrength() {
        return this.mSignalStrength;
    }

    public void registerForSubscriptionInfoReady(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.mCdmaForSubscriptionInfoReadyRegistrants.add(r);
        if (this.isMinInfoReady()) {
            r.notifyRegistrant();
        }
    }

    public void unregisterForSubscriptionInfoReady(Handler h) {
        this.mCdmaForSubscriptionInfoReadyRegistrants.remove(h);
    }

    private void saveCdmaSubscriptionSource(int source) {
        this.log("Storing cdma subscription source: " + source);
        Settings.Global.putInt(this.mPhone.getContext().getContentResolver(), "subscription_mode", source);
        this.log("Read from settings: " + Settings.Global.getInt(this.mPhone.getContext().getContentResolver(), "subscription_mode", -1));
    }

    private void getSubscriptionInfoAndStartPollingThreads() {
        this.mCi.getCDMASubscription(this.obtainMessage(34));
        this.pollState();
    }

    private void handleCdmaSubscriptionSource(int newSubscriptionSource) {
        this.log("Subscription Source : " + newSubscriptionSource);
        this.mIsSubscriptionFromRuim = newSubscriptionSource == 0;
        this.log("isFromRuim: " + this.mIsSubscriptionFromRuim);
        this.saveCdmaSubscriptionSource(newSubscriptionSource);
        if (!this.mIsSubscriptionFromRuim) {
            this.sendMessage(this.obtainMessage(35));
        }
    }

    private void dumpEarfcnPairList(PrintWriter pw) {
        pw.print(" mEarfcnPairListForRsrpBoost={");
        if (this.mEarfcnPairListForRsrpBoost != null) {
            int i = this.mEarfcnPairListForRsrpBoost.size();
            for (Pair<Integer, Integer> earfcnPair : this.mEarfcnPairListForRsrpBoost) {
                pw.print("(");
                pw.print(earfcnPair.first);
                pw.print(",");
                pw.print(earfcnPair.second);
                pw.print(")");
                if (--i == 0) continue;
                pw.print(",");
            }
        }
        pw.println("}");
    }

    private void dumpCellInfoList(PrintWriter pw) {
        pw.print(" mLastCellInfoList={");
        if (this.mLastCellInfoList != null) {
            boolean first = true;
            for (CellInfo info : this.mLastCellInfoList) {
                if (!first) {
                    pw.print(",");
                }
                first = false;
                pw.print(info.toString());
            }
        }
        pw.println("}");
    }

    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.println("ServiceStateTracker:");
        pw.println(" mSubId=" + this.mSubId);
        pw.println(" mSS=" + this.mSS);
        pw.println(" mNewSS=" + this.mNewSS);
        pw.println(" mVoiceCapable=" + this.mVoiceCapable);
        pw.println(" mRestrictedState=" + this.mRestrictedState);
        pw.println(" mPollingContext=" + this.mPollingContext + " - " + (this.mPollingContext != null ? Integer.valueOf(this.mPollingContext[0]) : ""));
        pw.println(" mDesiredPowerState=" + this.mDesiredPowerState);
        pw.println(" mDontPollSignalStrength=" + this.mDontPollSignalStrength);
        pw.println(" mSignalStrength=" + this.mSignalStrength);
        pw.println(" mLastSignalStrength=" + this.mLastSignalStrength);
        pw.println(" mRestrictedState=" + this.mRestrictedState);
        pw.println(" mPendingRadioPowerOffAfterDataOff=" + this.mPendingRadioPowerOffAfterDataOff);
        pw.println(" mPendingRadioPowerOffAfterDataOffTag=" + this.mPendingRadioPowerOffAfterDataOffTag);
        pw.println(" mCellLoc=" + Rlog.pii(false, (Object)this.mCellLoc));
        pw.println(" mNewCellLoc=" + Rlog.pii(false, (Object)this.mNewCellLoc));
        pw.println(" mLastCellInfoListTime=" + this.mLastCellInfoListTime);
        this.dumpCellInfoList(pw);
        pw.flush();
        pw.println(" mPreferredNetworkType=" + this.mPreferredNetworkType);
        pw.println(" mMaxDataCalls=" + this.mMaxDataCalls);
        pw.println(" mNewMaxDataCalls=" + this.mNewMaxDataCalls);
        pw.println(" mReasonDataDenied=" + this.mReasonDataDenied);
        pw.println(" mNewReasonDataDenied=" + this.mNewReasonDataDenied);
        pw.println(" mGsmRoaming=" + this.mGsmRoaming);
        pw.println(" mDataRoaming=" + this.mDataRoaming);
        pw.println(" mEmergencyOnly=" + this.mEmergencyOnly);
        pw.println(" mNeedFixZoneAfterNitz=" + this.mNeedFixZoneAfterNitz);
        pw.flush();
        pw.println(" mZoneOffset=" + this.mZoneOffset);
        pw.println(" mZoneDst=" + this.mZoneDst);
        pw.println(" mZoneTime=" + this.mZoneTime);
        pw.println(" mGotCountryCode=" + this.mGotCountryCode);
        pw.println(" mNitzUpdatedTime=" + this.mNitzUpdatedTime);
        pw.println(" mSavedTimeZone=" + this.mSavedTimeZone);
        pw.println(" mSavedTime=" + this.mSavedTime);
        pw.println(" mSavedAtTime=" + this.mSavedAtTime);
        pw.println(" mStartedGprsRegCheck=" + this.mStartedGprsRegCheck);
        pw.println(" mReportedGprsNoReg=" + this.mReportedGprsNoReg);
        pw.println(" mNotification=" + this.mNotification);
        pw.println(" mWakeLock=" + this.mWakeLock);
        pw.println(" mCurSpn=" + this.mCurSpn);
        pw.println(" mCurDataSpn=" + this.mCurDataSpn);
        pw.println(" mCurShowSpn=" + this.mCurShowSpn);
        pw.println(" mCurPlmn=" + this.mCurPlmn);
        pw.println(" mCurShowPlmn=" + this.mCurShowPlmn);
        pw.flush();
        pw.println(" mCurrentOtaspMode=" + this.mCurrentOtaspMode);
        pw.println(" mRoamingIndicator=" + this.mRoamingIndicator);
        pw.println(" mIsInPrl=" + this.mIsInPrl);
        pw.println(" mDefaultRoamingIndicator=" + this.mDefaultRoamingIndicator);
        pw.println(" mRegistrationState=" + this.mRegistrationState);
        pw.println(" mMdn=" + this.mMdn);
        pw.println(" mHomeSystemId=" + this.mHomeSystemId);
        pw.println(" mHomeNetworkId=" + this.mHomeNetworkId);
        pw.println(" mMin=" + this.mMin);
        pw.println(" mPrlVersion=" + this.mPrlVersion);
        pw.println(" mIsMinInfoReady=" + this.mIsMinInfoReady);
        pw.println(" mIsEriTextLoaded=" + this.mIsEriTextLoaded);
        pw.println(" mIsSubscriptionFromRuim=" + this.mIsSubscriptionFromRuim);
        pw.println(" mCdmaSSM=" + this.mCdmaSSM);
        pw.println(" mRegistrationDeniedReason=" + this.mRegistrationDeniedReason);
        pw.println(" mCurrentCarrier=" + this.mCurrentCarrier);
        pw.flush();
        pw.println(" mImsRegistered=" + this.mImsRegistered);
        pw.println(" mImsRegistrationOnOff=" + this.mImsRegistrationOnOff);
        pw.println(" mAlarmSwitch=" + this.mAlarmSwitch);
        pw.println(" mRadioDisabledByCarrier" + this.mRadioDisabledByCarrier);
        pw.println(" mPowerOffDelayNeed=" + this.mPowerOffDelayNeed);
        pw.println(" mDeviceShuttingDown=" + this.mDeviceShuttingDown);
        pw.println(" mSpnUpdatePending=" + this.mSpnUpdatePending);
        pw.println(" mLteRsrpBoost=" + this.mLteRsrpBoost);
        this.dumpEarfcnPairList(pw);
        pw.println(" Roaming Log:");
        IndentingPrintWriter ipw = new IndentingPrintWriter((Writer)pw, "  ");
        ipw.increaseIndent();
        this.mRoamingLog.dump(fd, ipw, args);
        ipw.decreaseIndent();
        ipw.println(" Attach Log:");
        ipw.increaseIndent();
        this.mAttachLog.dump(fd, ipw, args);
        ipw.decreaseIndent();
        ipw.println(" Phone Change Log:");
        ipw.increaseIndent();
        this.mPhoneTypeLog.dump(fd, ipw, args);
        ipw.decreaseIndent();
        ipw.println(" Rat Change Log:");
        ipw.increaseIndent();
        this.mRatLog.dump(fd, ipw, args);
        ipw.decreaseIndent();
        ipw.println(" Radio power Log:");
        ipw.increaseIndent();
        this.mRadioPowerLog.dump(fd, ipw, args);
        ipw.println(" Time Logs:");
        ipw.increaseIndent();
        this.mTimeLog.dump(fd, ipw, args);
        ipw.decreaseIndent();
        ipw.println(" Time zone Logs:");
        ipw.increaseIndent();
        this.mTimeZoneLog.dump(fd, ipw, args);
        ipw.decreaseIndent();
    }

    public boolean isImsRegistered() {
        return this.mImsRegistered;
    }

    protected void checkCorrectThread() {
        if (Thread.currentThread() != this.getLooper().getThread()) {
            throw new RuntimeException("ServiceStateTracker must be used from within one thread");
        }
    }

    protected boolean isCallerOnDifferentThread() {
        boolean value = Thread.currentThread() != this.getLooper().getThread();
        return value;
    }

    protected void updateCarrierMccMncConfiguration(String newOp, String oldOp, Context context) {
        if (newOp == null && !TextUtils.isEmpty(oldOp) || newOp != null && !newOp.equals(oldOp)) {
            this.log("update mccmnc=" + newOp + " fromServiceState=true");
            MccTable.updateMccMncConfiguration(context, newOp, true);
        }
    }

    protected boolean inSameCountry(String operatorNumeric) {
        if (TextUtils.isEmpty(operatorNumeric) || operatorNumeric.length() < 5) {
            return false;
        }
        String homeNumeric = this.getHomeOperatorNumeric();
        if (TextUtils.isEmpty(homeNumeric) || homeNumeric.length() < 5) {
            return false;
        }
        boolean inSameCountry = true;
        String networkMCC = operatorNumeric.substring(0, 3);
        String homeMCC = homeNumeric.substring(0, 3);
        String networkCountry = MccTable.countryCodeForMcc(Integer.parseInt(networkMCC));
        String homeCountry = MccTable.countryCodeForMcc(Integer.parseInt(homeMCC));
        if (networkCountry.isEmpty() || homeCountry.isEmpty()) {
            return false;
        }
        inSameCountry = homeCountry.equals(networkCountry);
        if (inSameCountry) {
            return inSameCountry;
        }
        if ("us".equals(homeCountry) && "vi".equals(networkCountry)) {
            inSameCountry = true;
        } else if ("vi".equals(homeCountry) && "us".equals(networkCountry)) {
            inSameCountry = true;
        }
        return inSameCountry;
    }

    protected void setRoamingType(ServiceState currentServiceState) {
        boolean isVoiceInService;
        boolean bl = isVoiceInService = currentServiceState.getVoiceRegState() == 0;
        if (isVoiceInService) {
            if (currentServiceState.getVoiceRoaming()) {
                if (this.mPhone.isPhoneTypeGsm()) {
                    if (this.inSameCountry(currentServiceState.getVoiceOperatorNumeric())) {
                        currentServiceState.setVoiceRoamingType(2);
                    } else {
                        currentServiceState.setVoiceRoamingType(3);
                    }
                } else {
                    int[] intRoamingIndicators = this.mPhone.getContext().getResources().getIntArray(17235990);
                    if (intRoamingIndicators != null && intRoamingIndicators.length > 0) {
                        currentServiceState.setVoiceRoamingType(2);
                        int curRoamingIndicator = currentServiceState.getCdmaRoamingIndicator();
                        for (int i = 0; i < intRoamingIndicators.length; ++i) {
                            if (curRoamingIndicator != intRoamingIndicators[i]) continue;
                            currentServiceState.setVoiceRoamingType(3);
                            break;
                        }
                    } else if (this.inSameCountry(currentServiceState.getVoiceOperatorNumeric())) {
                        currentServiceState.setVoiceRoamingType(2);
                    } else {
                        currentServiceState.setVoiceRoamingType(3);
                    }
                }
            } else {
                currentServiceState.setVoiceRoamingType(0);
            }
        }
        boolean isDataInService = currentServiceState.getDataRegState() == 0;
        int dataRegType = currentServiceState.getRilDataRadioTechnology();
        if (isDataInService) {
            if (!currentServiceState.getDataRoaming()) {
                currentServiceState.setDataRoamingType(0);
            } else if (this.mPhone.isPhoneTypeGsm()) {
                if (ServiceState.isGsm(dataRegType)) {
                    if (isVoiceInService) {
                        currentServiceState.setDataRoamingType(currentServiceState.getVoiceRoamingType());
                    } else {
                        currentServiceState.setDataRoamingType(1);
                    }
                } else {
                    currentServiceState.setDataRoamingType(1);
                }
            } else if (ServiceState.isCdma(dataRegType)) {
                if (isVoiceInService) {
                    currentServiceState.setDataRoamingType(currentServiceState.getVoiceRoamingType());
                } else {
                    currentServiceState.setDataRoamingType(1);
                }
            } else if (this.inSameCountry(currentServiceState.getDataOperatorNumeric())) {
                currentServiceState.setDataRoamingType(2);
            } else {
                currentServiceState.setDataRoamingType(3);
            }
        }
    }

    private void setSignalStrengthDefaultValues() {
        this.mSignalStrength = new SignalStrength(true);
    }

    protected String getHomeOperatorNumeric() {
        String numeric = ((TelephonyManager)this.mPhone.getContext().getSystemService("phone")).getSimOperatorNumericForPhone(this.mPhone.getPhoneId());
        if (!this.mPhone.isPhoneTypeGsm() && TextUtils.isEmpty(numeric)) {
            numeric = SystemProperties.get("ro.cdma.home.operator.numeric", "");
        }
        return numeric;
    }

    protected int getPhoneId() {
        return this.mPhone.getPhoneId();
    }

    protected void resetServiceStateInIwlanMode() {
        if (this.mCi.getRadioState() == CommandsInterface.RadioState.RADIO_OFF) {
            boolean resetIwlanRatVal = false;
            this.log("set service state as POWER_OFF");
            if (18 == this.mNewSS.getRilDataRadioTechnology()) {
                this.log("pollStateDone: mNewSS = " + this.mNewSS);
                this.log("pollStateDone: reset iwlan RAT value");
                resetIwlanRatVal = true;
            }
            String operator = this.mNewSS.getOperatorAlphaLong();
            this.mNewSS.setStateOff();
            if (resetIwlanRatVal) {
                this.mNewSS.setRilDataRadioTechnology(18);
                this.mNewSS.setDataRegState(0);
                this.mNewSS.setOperatorAlphaLong(operator);
                this.log("pollStateDone: mNewSS = " + this.mNewSS);
            }
        }
    }

    protected final boolean alwaysOnHomeNetwork(BaseBundle b) {
        return b.getBoolean("force_home_network_bool");
    }

    private boolean isInNetwork(BaseBundle b, String network, String key) {
        String[] networks = b.getStringArray(key);
        return networks != null && Arrays.asList(networks).contains(network);
    }

    protected final boolean isRoamingInGsmNetwork(BaseBundle b, String network) {
        return this.isInNetwork(b, network, "gsm_roaming_networks_string_array");
    }

    protected final boolean isNonRoamingInGsmNetwork(BaseBundle b, String network) {
        return this.isInNetwork(b, network, "gsm_nonroaming_networks_string_array");
    }

    protected final boolean isRoamingInCdmaNetwork(BaseBundle b, String network) {
        return this.isInNetwork(b, network, "cdma_roaming_networks_string_array");
    }

    protected final boolean isNonRoamingInCdmaNetwork(BaseBundle b, String network) {
        return this.isInNetwork(b, network, "cdma_nonroaming_networks_string_array");
    }

    public boolean isDeviceShuttingDown() {
        return this.mDeviceShuttingDown;
    }

    protected int getCombinedRegState() {
        int regState = this.mSS.getVoiceRegState();
        int dataRegState = this.mSS.getDataRegState();
        if ((regState == 1 || regState == 3) && dataRegState == 0) {
            this.log("getCombinedRegState: return STATE_IN_SERVICE as Data is in service");
            regState = dataRegState;
        }
        return regState;
    }

    private class SstSubscriptionsChangedListener
    extends SubscriptionManager.OnSubscriptionsChangedListener {
        public final AtomicInteger mPreviousSubId = new AtomicInteger(-1);

        private SstSubscriptionsChangedListener() {
        }

        @Override
        public void onSubscriptionsChanged() {
            ServiceStateTracker.this.log("SubscriptionListener.onSubscriptionInfoChanged");
            int subId = ServiceStateTracker.this.mPhone.getSubId();
            if (this.mPreviousSubId.getAndSet(subId) != subId) {
                if (SubscriptionManager.isValidSubscriptionId(subId)) {
                    Context context = ServiceStateTracker.this.mPhone.getContext();
                    ServiceStateTracker.this.mPhone.notifyPhoneStateChanged();
                    ServiceStateTracker.this.mPhone.notifyCallForwardingIndicator();
                    boolean restoreSelection = !context.getResources().getBoolean(17957088);
                    ServiceStateTracker.this.mPhone.sendSubscriptionSettings(restoreSelection);
                    ServiceStateTracker.this.mPhone.setSystemProperty("gsm.network.type", ServiceState.rilRadioTechnologyToString(ServiceStateTracker.this.mSS.getRilDataRadioTechnology()));
                    if (ServiceStateTracker.this.mSpnUpdatePending) {
                        ServiceStateTracker.this.mSubscriptionController.setPlmnSpn(ServiceStateTracker.this.mPhone.getPhoneId(), ServiceStateTracker.this.mCurShowPlmn, ServiceStateTracker.this.mCurPlmn, ServiceStateTracker.this.mCurShowSpn, ServiceStateTracker.this.mCurSpn);
                        ServiceStateTracker.this.mSpnUpdatePending = false;
                    }
                    SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(context);
                    String oldNetworkSelection = sp.getString("network_selection_key", "");
                    String oldNetworkSelectionName = sp.getString("network_selection_name_key", "");
                    String oldNetworkSelectionShort = sp.getString("network_selection_short_key", "");
                    if (!(TextUtils.isEmpty(oldNetworkSelection) && TextUtils.isEmpty(oldNetworkSelectionName) && TextUtils.isEmpty(oldNetworkSelectionShort))) {
                        SharedPreferences.Editor editor = sp.edit();
                        editor.putString("network_selection_key" + subId, oldNetworkSelection);
                        editor.putString("network_selection_name_key" + subId, oldNetworkSelectionName);
                        editor.putString("network_selection_short_key" + subId, oldNetworkSelectionShort);
                        editor.remove("network_selection_key");
                        editor.remove("network_selection_name_key");
                        editor.remove("network_selection_short_key");
                        editor.commit();
                    }
                    ServiceStateTracker.this.updateSpnDisplay();
                }
                ServiceStateTracker.this.mPhone.updateVoiceMail();
                if (ServiceStateTracker.this.mSubscriptionController.getSlotIndex(subId) == -1) {
                    ServiceStateTracker.this.sendMessage(ServiceStateTracker.this.obtainMessage(52));
                }
            }
        }
    }

    private class CellInfoResult {
        List<CellInfo> list;
        Object lockObj = new Object();

        private CellInfoResult() {
        }
    }
}

