/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.hardware.radio.V1_0.CdmaCallWaiting;
import android.hardware.radio.V1_0.CdmaInformationRecord;
import android.hardware.radio.V1_0.CdmaLineControlInfoRecord;
import android.hardware.radio.V1_0.CdmaNumberInfoRecord;
import android.hardware.radio.V1_0.CdmaRedirectingNumberInfoRecord;
import android.hardware.radio.V1_0.CdmaSignalInfoRecord;
import android.hardware.radio.V1_0.CdmaSmsMessage;
import android.hardware.radio.V1_0.CdmaT53AudioControlInfoRecord;
import android.hardware.radio.V1_0.CellInfo;
import android.hardware.radio.V1_0.CfData;
import android.hardware.radio.V1_0.LceDataInfo;
import android.hardware.radio.V1_0.PcoDataInfo;
import android.hardware.radio.V1_0.SetupDataCallResult;
import android.hardware.radio.V1_0.SimRefreshResult;
import android.hardware.radio.V1_0.SsInfoData;
import android.hardware.radio.V1_0.StkCcUnsolSsResult;
import android.hardware.radio.V1_0.SuppSvcNotification;
import android.hardware.radio.V1_1.IRadioIndication;
import android.hardware.radio.V1_1.KeepaliveStatus;
import android.os.AsyncResult;
import android.os.SystemProperties;
import android.telephony.PcoData;
import android.telephony.SignalStrength;
import android.telephony.SmsMessage;
import com.android.internal.telephony.CallForwardInfo;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.HardwareConfig;
import com.android.internal.telephony.NetworkScanResult;
import com.android.internal.telephony.RIL;
import com.android.internal.telephony.RadioCapability;
import com.android.internal.telephony.cdma.CdmaCallWaitingNotification;
import com.android.internal.telephony.cdma.CdmaInformationRecords;
import com.android.internal.telephony.cdma.SmsMessageConverter;
import com.android.internal.telephony.dataconnection.DataCallResponse;
import com.android.internal.telephony.gsm.SsData;
import com.android.internal.telephony.gsm.SuppServiceNotification;
import com.android.internal.telephony.uicc.IccRefreshResponse;
import com.android.internal.telephony.uicc.IccUtils;
import java.util.ArrayList;

public class RadioIndication
extends IRadioIndication.Stub {
    RIL mRil;

    RadioIndication(RIL ril) {
        this.mRil = ril;
    }

    @Override
    public void radioStateChanged(int indicationType, int radioState) {
        this.mRil.processIndication(indicationType);
        CommandsInterface.RadioState newState = this.getRadioStateFromInt(radioState);
        this.mRil.unsljLogMore(1000, "radioStateChanged: " + (Object)((Object)newState));
        this.mRil.setRadioState(newState);
    }

    @Override
    public void callStateChanged(int indicationType) {
        this.mRil.processIndication(indicationType);
        this.mRil.unsljLog(1001);
        this.mRil.mCallStateRegistrants.notifyRegistrants();
    }

    @Override
    public void networkStateChanged(int indicationType) {
        this.mRil.processIndication(indicationType);
        this.mRil.unsljLog(1002);
        this.mRil.mNetworkStateRegistrants.notifyRegistrants();
    }

    @Override
    public void newSms(int indicationType, ArrayList<Byte> pdu) {
        this.mRil.processIndication(indicationType);
        byte[] pduArray = RIL.arrayListToPrimitiveArray(pdu);
        this.mRil.unsljLog(1003);
        this.mRil.writeMetricsNewSms(1, 1);
        SmsMessage sms = SmsMessage.newFromCMT(pduArray);
        if (this.mRil.mGsmSmsRegistrant != null) {
            this.mRil.mGsmSmsRegistrant.notifyRegistrant(new AsyncResult(null, sms, null));
        }
    }

    @Override
    public void newSmsStatusReport(int indicationType, ArrayList<Byte> pdu) {
        this.mRil.processIndication(indicationType);
        byte[] pduArray = RIL.arrayListToPrimitiveArray(pdu);
        this.mRil.unsljLog(1004);
        if (this.mRil.mSmsStatusRegistrant != null) {
            this.mRil.mSmsStatusRegistrant.notifyRegistrant(new AsyncResult(null, pduArray, null));
        }
    }

    @Override
    public void newSmsOnSim(int indicationType, int recordNumber) {
        this.mRil.processIndication(indicationType);
        this.mRil.unsljLog(1005);
        if (this.mRil.mSmsOnSimRegistrant != null) {
            this.mRil.mSmsOnSimRegistrant.notifyRegistrant(new AsyncResult(null, recordNumber, null));
        }
    }

    @Override
    public void onUssd(int indicationType, int ussdModeType, String msg) {
        this.mRil.processIndication(indicationType);
        this.mRil.unsljLogMore(1006, "" + ussdModeType);
        String[] resp = new String[]{"" + ussdModeType, msg};
        if (this.mRil.mUSSDRegistrant != null) {
            this.mRil.mUSSDRegistrant.notifyRegistrant(new AsyncResult(null, resp, null));
        }
    }

    @Override
    public void nitzTimeReceived(int indicationType, String nitzTime, long receivedTime) {
        this.mRil.processIndication(indicationType);
        this.mRil.unsljLogRet(1008, nitzTime);
        Object[] result = new Object[]{nitzTime, receivedTime};
        boolean ignoreNitz = SystemProperties.getBoolean("telephony.test.ignore.nitz", false);
        if (ignoreNitz) {
            this.mRil.riljLog("ignoring UNSOL_NITZ_TIME_RECEIVED");
        } else {
            if (this.mRil.mNITZTimeRegistrant != null) {
                this.mRil.mNITZTimeRegistrant.notifyRegistrant(new AsyncResult(null, result, null));
            }
            this.mRil.mLastNITZTimeInfo = result;
        }
    }

    @Override
    public void currentSignalStrength(int indicationType, android.hardware.radio.V1_0.SignalStrength signalStrength) {
        this.mRil.processIndication(indicationType);
        SignalStrength ss = RIL.convertHalSignalStrength(signalStrength);
        if (this.mRil.mSignalStrengthRegistrant != null) {
            this.mRil.mSignalStrengthRegistrant.notifyRegistrant(new AsyncResult(null, ss, null));
        }
    }

    @Override
    public void dataCallListChanged(int indicationType, ArrayList<SetupDataCallResult> dcList) {
        this.mRil.processIndication(indicationType);
        ArrayList<DataCallResponse> response = new ArrayList<DataCallResponse>();
        for (SetupDataCallResult dcResult : dcList) {
            response.add(RIL.convertDataCallResult(dcResult));
        }
        this.mRil.unsljLogRet(1010, response);
        this.mRil.mDataCallListChangedRegistrants.notifyRegistrants(new AsyncResult(null, response, null));
    }

    @Override
    public void suppSvcNotify(int indicationType, SuppSvcNotification suppSvcNotification) {
        this.mRil.processIndication(indicationType);
        SuppServiceNotification notification = new SuppServiceNotification();
        notification.notificationType = suppSvcNotification.isMT ? 1 : 0;
        notification.code = suppSvcNotification.code;
        notification.index = suppSvcNotification.index;
        notification.type = suppSvcNotification.type;
        notification.number = suppSvcNotification.number;
        this.mRil.unsljLogRet(1011, notification);
        if (this.mRil.mSsnRegistrant != null) {
            this.mRil.mSsnRegistrant.notifyRegistrant(new AsyncResult(null, notification, null));
        }
    }

    @Override
    public void stkSessionEnd(int indicationType) {
        this.mRil.processIndication(indicationType);
        this.mRil.unsljLog(1012);
        if (this.mRil.mCatSessionEndRegistrant != null) {
            this.mRil.mCatSessionEndRegistrant.notifyRegistrant(new AsyncResult(null, null, null));
        }
    }

    @Override
    public void stkProactiveCommand(int indicationType, String cmd) {
        this.mRil.processIndication(indicationType);
        this.mRil.unsljLog(1013);
        if (this.mRil.mCatProCmdRegistrant != null) {
            this.mRil.mCatProCmdRegistrant.notifyRegistrant(new AsyncResult(null, cmd, null));
        }
    }

    @Override
    public void stkEventNotify(int indicationType, String cmd) {
        this.mRil.processIndication(indicationType);
        this.mRil.unsljLog(1014);
        if (this.mRil.mCatEventRegistrant != null) {
            this.mRil.mCatEventRegistrant.notifyRegistrant(new AsyncResult(null, cmd, null));
        }
    }

    @Override
    public void stkCallSetup(int indicationType, long timeout) {
        this.mRil.processIndication(indicationType);
        this.mRil.unsljLogRet(1015, timeout);
        if (this.mRil.mCatCallSetUpRegistrant != null) {
            this.mRil.mCatCallSetUpRegistrant.notifyRegistrant(new AsyncResult(null, timeout, null));
        }
    }

    @Override
    public void simSmsStorageFull(int indicationType) {
        this.mRil.processIndication(indicationType);
        this.mRil.unsljLog(1016);
        if (this.mRil.mIccSmsFullRegistrant != null) {
            this.mRil.mIccSmsFullRegistrant.notifyRegistrant();
        }
    }

    @Override
    public void simRefresh(int indicationType, SimRefreshResult refreshResult) {
        this.mRil.processIndication(indicationType);
        IccRefreshResponse response = new IccRefreshResponse();
        response.refreshResult = refreshResult.type;
        response.efId = refreshResult.efId;
        response.aid = refreshResult.aid;
        this.mRil.unsljLogRet(1017, response);
        this.mRil.mIccRefreshRegistrants.notifyRegistrants(new AsyncResult(null, response, null));
    }

    @Override
    public void callRing(int indicationType, boolean isGsm, CdmaSignalInfoRecord record) {
        this.mRil.processIndication(indicationType);
        char[] response = null;
        if (!isGsm) {
            response = new char[]{(char)(record.isPresent ? 1 : 0), (char)record.signalType, (char)record.alertPitch, (char)record.signal};
            this.mRil.writeMetricsCallRing(response);
        }
        this.mRil.unsljLogRet(1018, response);
        if (this.mRil.mRingRegistrant != null) {
            this.mRil.mRingRegistrant.notifyRegistrant(new AsyncResult(null, response, null));
        }
    }

    @Override
    public void simStatusChanged(int indicationType) {
        this.mRil.processIndication(indicationType);
        this.mRil.unsljLog(1019);
        this.mRil.mIccStatusChangedRegistrants.notifyRegistrants();
    }

    @Override
    public void cdmaNewSms(int indicationType, CdmaSmsMessage msg) {
        this.mRil.processIndication(indicationType);
        this.mRil.unsljLog(1020);
        this.mRil.writeMetricsNewSms(2, 2);
        SmsMessage sms = SmsMessageConverter.newSmsMessageFromCdmaSmsMessage(msg);
        if (this.mRil.mCdmaSmsRegistrant != null) {
            this.mRil.mCdmaSmsRegistrant.notifyRegistrant(new AsyncResult(null, sms, null));
        }
    }

    @Override
    public void newBroadcastSms(int indicationType, ArrayList<Byte> data) {
        this.mRil.processIndication(indicationType);
        byte[] response = RIL.arrayListToPrimitiveArray(data);
        this.mRil.unsljLogvRet(1021, IccUtils.bytesToHexString(response));
        if (this.mRil.mGsmBroadcastSmsRegistrant != null) {
            this.mRil.mGsmBroadcastSmsRegistrant.notifyRegistrant(new AsyncResult(null, response, null));
        }
    }

    @Override
    public void cdmaRuimSmsStorageFull(int indicationType) {
        this.mRil.processIndication(indicationType);
        this.mRil.unsljLog(1022);
        if (this.mRil.mIccSmsFullRegistrant != null) {
            this.mRil.mIccSmsFullRegistrant.notifyRegistrant();
        }
    }

    @Override
    public void restrictedStateChanged(int indicationType, int state) {
        this.mRil.processIndication(indicationType);
        this.mRil.unsljLogvRet(1023, state);
        if (this.mRil.mRestrictedStateRegistrant != null) {
            this.mRil.mRestrictedStateRegistrant.notifyRegistrant(new AsyncResult(null, state, null));
        }
    }

    @Override
    public void enterEmergencyCallbackMode(int indicationType) {
        this.mRil.processIndication(indicationType);
        this.mRil.unsljLog(1024);
        if (this.mRil.mEmergencyCallbackModeRegistrant != null) {
            this.mRil.mEmergencyCallbackModeRegistrant.notifyRegistrant();
        }
    }

    @Override
    public void cdmaCallWaiting(int indicationType, CdmaCallWaiting callWaitingRecord) {
        this.mRil.processIndication(indicationType);
        CdmaCallWaitingNotification notification = new CdmaCallWaitingNotification();
        notification.number = callWaitingRecord.number;
        notification.numberPresentation = CdmaCallWaitingNotification.presentationFromCLIP(callWaitingRecord.numberPresentation);
        notification.name = callWaitingRecord.name;
        notification.namePresentation = notification.numberPresentation;
        notification.isPresent = callWaitingRecord.signalInfoRecord.isPresent ? 1 : 0;
        notification.signalType = callWaitingRecord.signalInfoRecord.signalType;
        notification.alertPitch = callWaitingRecord.signalInfoRecord.alertPitch;
        notification.signal = callWaitingRecord.signalInfoRecord.signal;
        notification.numberType = callWaitingRecord.numberType;
        notification.numberPlan = callWaitingRecord.numberPlan;
        this.mRil.unsljLogRet(1025, notification);
        this.mRil.mCallWaitingInfoRegistrants.notifyRegistrants(new AsyncResult(null, notification, null));
    }

    @Override
    public void cdmaOtaProvisionStatus(int indicationType, int status) {
        this.mRil.processIndication(indicationType);
        int[] response = new int[]{status};
        this.mRil.unsljLogRet(1026, response);
        this.mRil.mOtaProvisionRegistrants.notifyRegistrants(new AsyncResult(null, response, null));
    }

    @Override
    public void cdmaInfoRec(int indicationType, android.hardware.radio.V1_0.CdmaInformationRecords records) {
        this.mRil.processIndication(indicationType);
        int numberOfInfoRecs = records.infoRec.size();
        for (int i = 0; i < numberOfInfoRecs; ++i) {
            CdmaInformationRecords cdmaInformationRecords;
            CdmaInformationRecord record = records.infoRec.get(i);
            int id2 = record.name;
            switch (id2) {
                case 0: 
                case 7: {
                    CdmaInformationRecords.CdmaDisplayInfoRec cdmaDisplayInfoRec = new CdmaInformationRecords.CdmaDisplayInfoRec(id2, record.display.get((int)0).alphaBuf);
                    cdmaInformationRecords = new CdmaInformationRecords(cdmaDisplayInfoRec);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    CdmaNumberInfoRecord numInfoRecord = record.number.get(0);
                    CdmaInformationRecords.CdmaNumberInfoRec cdmaNumberInfoRec = new CdmaInformationRecords.CdmaNumberInfoRec(id2, numInfoRecord.number, numInfoRecord.numberType, numInfoRecord.numberPlan, numInfoRecord.pi, numInfoRecord.si);
                    cdmaInformationRecords = new CdmaInformationRecords(cdmaNumberInfoRec);
                    break;
                }
                case 4: {
                    CdmaSignalInfoRecord signalInfoRecord = record.signal.get(0);
                    CdmaInformationRecords.CdmaSignalInfoRec cdmaSignalInfoRec = new CdmaInformationRecords.CdmaSignalInfoRec(signalInfoRecord.isPresent ? 1 : 0, signalInfoRecord.signalType, signalInfoRecord.alertPitch, signalInfoRecord.signal);
                    cdmaInformationRecords = new CdmaInformationRecords(cdmaSignalInfoRec);
                    break;
                }
                case 5: {
                    CdmaRedirectingNumberInfoRecord redirectingNumberInfoRecord = record.redir.get(0);
                    CdmaInformationRecords.CdmaRedirectingNumberInfoRec cdmaRedirectingNumberInfoRec = new CdmaInformationRecords.CdmaRedirectingNumberInfoRec(redirectingNumberInfoRecord.redirectingNumber.number, redirectingNumberInfoRecord.redirectingNumber.numberType, redirectingNumberInfoRecord.redirectingNumber.numberPlan, redirectingNumberInfoRecord.redirectingNumber.pi, redirectingNumberInfoRecord.redirectingNumber.si, redirectingNumberInfoRecord.redirectingReason);
                    cdmaInformationRecords = new CdmaInformationRecords(cdmaRedirectingNumberInfoRec);
                    break;
                }
                case 6: {
                    CdmaLineControlInfoRecord lineControlInfoRecord = record.lineCtrl.get(0);
                    CdmaInformationRecords.CdmaLineControlInfoRec cdmaLineControlInfoRec = new CdmaInformationRecords.CdmaLineControlInfoRec(lineControlInfoRecord.lineCtrlPolarityIncluded, lineControlInfoRecord.lineCtrlToggle, lineControlInfoRecord.lineCtrlReverse, lineControlInfoRecord.lineCtrlPowerDenial);
                    cdmaInformationRecords = new CdmaInformationRecords(cdmaLineControlInfoRec);
                    break;
                }
                case 8: {
                    CdmaInformationRecords.CdmaT53ClirInfoRec cdmaT53ClirInfoRec = new CdmaInformationRecords.CdmaT53ClirInfoRec(record.clir.get((int)0).cause);
                    cdmaInformationRecords = new CdmaInformationRecords(cdmaT53ClirInfoRec);
                    break;
                }
                case 10: {
                    CdmaT53AudioControlInfoRecord audioControlInfoRecord = record.audioCtrl.get(0);
                    CdmaInformationRecords.CdmaT53AudioControlInfoRec cdmaT53AudioControlInfoRec = new CdmaInformationRecords.CdmaT53AudioControlInfoRec(audioControlInfoRecord.upLink, audioControlInfoRecord.downLink);
                    cdmaInformationRecords = new CdmaInformationRecords(cdmaT53AudioControlInfoRec);
                    break;
                }
                default: {
                    throw new RuntimeException("RIL_UNSOL_CDMA_INFO_REC: unsupported record. Got " + CdmaInformationRecords.idToString(id2) + " ");
                }
            }
            this.mRil.unsljLogRet(1027, cdmaInformationRecords);
            this.mRil.notifyRegistrantsCdmaInfoRec(cdmaInformationRecords);
        }
    }

    @Override
    public void indicateRingbackTone(int indicationType, boolean start) {
        this.mRil.processIndication(indicationType);
        this.mRil.unsljLogvRet(1029, start);
        this.mRil.mRingbackToneRegistrants.notifyRegistrants(new AsyncResult(null, start, null));
    }

    @Override
    public void resendIncallMute(int indicationType) {
        this.mRil.processIndication(indicationType);
        this.mRil.unsljLog(1030);
        this.mRil.mResendIncallMuteRegistrants.notifyRegistrants();
    }

    @Override
    public void cdmaSubscriptionSourceChanged(int indicationType, int cdmaSource) {
        this.mRil.processIndication(indicationType);
        int[] response = new int[]{cdmaSource};
        this.mRil.unsljLogRet(1031, response);
        this.mRil.mCdmaSubscriptionChangedRegistrants.notifyRegistrants(new AsyncResult(null, response, null));
    }

    @Override
    public void cdmaPrlChanged(int indicationType, int version) {
        this.mRil.processIndication(indicationType);
        int[] response = new int[]{version};
        this.mRil.unsljLogRet(1032, response);
        this.mRil.mCdmaPrlChangedRegistrants.notifyRegistrants(new AsyncResult(null, response, null));
    }

    @Override
    public void exitEmergencyCallbackMode(int indicationType) {
        this.mRil.processIndication(indicationType);
        this.mRil.unsljLog(1033);
        this.mRil.mExitEmergencyCallbackModeRegistrants.notifyRegistrants();
    }

    @Override
    public void rilConnected(int indicationType) {
        this.mRil.processIndication(indicationType);
        this.mRil.unsljLog(1034);
        this.mRil.setRadioPower(false, null);
        this.mRil.setCdmaSubscriptionSource(this.mRil.mCdmaSubscription, null);
        this.mRil.setCellInfoListRate();
        this.mRil.notifyRegistrantsRilConnectionChanged(15);
    }

    @Override
    public void voiceRadioTechChanged(int indicationType, int rat) {
        this.mRil.processIndication(indicationType);
        int[] response = new int[]{rat};
        this.mRil.unsljLogRet(1035, response);
        this.mRil.mVoiceRadioTechChangedRegistrants.notifyRegistrants(new AsyncResult(null, response, null));
    }

    @Override
    public void cellInfoList(int indicationType, ArrayList<CellInfo> records) {
        this.mRil.processIndication(indicationType);
        ArrayList<android.telephony.CellInfo> response = RIL.convertHalCellInfoList(records);
        this.mRil.unsljLogRet(1036, response);
        this.mRil.mRilCellInfoListRegistrants.notifyRegistrants(new AsyncResult(null, response, null));
    }

    @Override
    public void networkScanResult(int indicationType, android.hardware.radio.V1_1.NetworkScanResult result) {
        this.responseCellInfos(indicationType, result);
    }

    @Override
    public void imsNetworkStateChanged(int indicationType) {
        this.mRil.processIndication(indicationType);
        this.mRil.unsljLog(1037);
        this.mRil.mImsNetworkStateChangedRegistrants.notifyRegistrants();
    }

    @Override
    public void subscriptionStatusChanged(int indicationType, boolean activate) {
        this.mRil.processIndication(indicationType);
        int[] response = new int[]{activate ? 1 : 0};
        this.mRil.unsljLogRet(1038, response);
        this.mRil.mSubscriptionStatusRegistrants.notifyRegistrants(new AsyncResult(null, response, null));
    }

    @Override
    public void srvccStateNotify(int indicationType, int state) {
        this.mRil.processIndication(indicationType);
        int[] response = new int[]{state};
        this.mRil.unsljLogRet(1039, response);
        this.mRil.writeMetricsSrvcc(state);
        this.mRil.mSrvccStateRegistrants.notifyRegistrants(new AsyncResult(null, response, null));
    }

    @Override
    public void hardwareConfigChanged(int indicationType, ArrayList<android.hardware.radio.V1_0.HardwareConfig> configs) {
        this.mRil.processIndication(indicationType);
        ArrayList<HardwareConfig> response = RIL.convertHalHwConfigList(configs, this.mRil);
        this.mRil.unsljLogRet(1040, response);
        this.mRil.mHardwareConfigChangeRegistrants.notifyRegistrants(new AsyncResult(null, response, null));
    }

    @Override
    public void radioCapabilityIndication(int indicationType, android.hardware.radio.V1_0.RadioCapability rc) {
        this.mRil.processIndication(indicationType);
        RadioCapability response = RIL.convertHalRadioCapability(rc, this.mRil);
        this.mRil.unsljLogRet(1042, response);
        this.mRil.mPhoneRadioCapabilityChangedRegistrants.notifyRegistrants(new AsyncResult(null, response, null));
    }

    @Override
    public void onSupplementaryServiceIndication(int indicationType, StkCcUnsolSsResult ss) {
        this.mRil.processIndication(indicationType);
        SsData ssData = new SsData();
        ssData.serviceType = ssData.ServiceTypeFromRILInt(ss.serviceType);
        ssData.requestType = ssData.RequestTypeFromRILInt(ss.requestType);
        ssData.teleserviceType = ssData.TeleserviceTypeFromRILInt(ss.teleserviceType);
        ssData.serviceClass = ss.serviceClass;
        ssData.result = ss.result;
        if (ssData.serviceType.isTypeCF() && ssData.requestType.isTypeInterrogation()) {
            CfData cfData = ss.cfData.get(0);
            int num = cfData.cfInfo.size();
            ssData.cfInfo = new CallForwardInfo[num];
            for (int i = 0; i < num; ++i) {
                android.hardware.radio.V1_0.CallForwardInfo cfInfo = cfData.cfInfo.get(i);
                ssData.cfInfo[i] = new CallForwardInfo();
                ssData.cfInfo[i].status = cfInfo.status;
                ssData.cfInfo[i].reason = cfInfo.reason;
                ssData.cfInfo[i].serviceClass = cfInfo.serviceClass;
                ssData.cfInfo[i].toa = cfInfo.toa;
                ssData.cfInfo[i].number = cfInfo.number;
                ssData.cfInfo[i].timeSeconds = cfInfo.timeSeconds;
                this.mRil.riljLog("[SS Data] CF Info " + i + " : " + ssData.cfInfo[i]);
            }
        } else {
            SsInfoData ssInfo = ss.ssInfo.get(0);
            int num = ssInfo.ssInfo.size();
            ssData.ssInfo = new int[num];
            for (int i = 0; i < num; ++i) {
                ssData.ssInfo[i] = ssInfo.ssInfo.get(i);
                this.mRil.riljLog("[SS Data] SS Info " + i + " : " + ssData.ssInfo[i]);
            }
        }
        this.mRil.unsljLogRet(1043, ssData);
        if (this.mRil.mSsRegistrant != null) {
            this.mRil.mSsRegistrant.notifyRegistrant(new AsyncResult(null, ssData, null));
        }
    }

    @Override
    public void stkCallControlAlphaNotify(int indicationType, String alpha) {
        this.mRil.processIndication(indicationType);
        this.mRil.unsljLogRet(1044, alpha);
        if (this.mRil.mCatCcAlphaRegistrant != null) {
            this.mRil.mCatCcAlphaRegistrant.notifyRegistrant(new AsyncResult(null, alpha, null));
        }
    }

    @Override
    public void lceData(int indicationType, LceDataInfo lce) {
        this.mRil.processIndication(indicationType);
        ArrayList<Integer> response = RIL.convertHalLceData(lce, this.mRil);
        this.mRil.unsljLogRet(1045, response);
        if (this.mRil.mLceInfoRegistrant != null) {
            this.mRil.mLceInfoRegistrant.notifyRegistrant(new AsyncResult(null, response, null));
        }
    }

    @Override
    public void pcoData(int indicationType, PcoDataInfo pco) {
        this.mRil.processIndication(indicationType);
        PcoData response = new PcoData(pco.cid, pco.bearerProto, pco.pcoId, RIL.arrayListToPrimitiveArray(pco.contents));
        this.mRil.unsljLogRet(1046, response);
        this.mRil.mPcoDataRegistrants.notifyRegistrants(new AsyncResult(null, response, null));
    }

    @Override
    public void modemReset(int indicationType, String reason) {
        this.mRil.processIndication(indicationType);
        this.mRil.unsljLogRet(1047, reason);
        this.mRil.writeMetricsModemRestartEvent(reason);
        this.mRil.mModemResetRegistrants.notifyRegistrants(new AsyncResult(null, reason, null));
    }

    @Override
    public void carrierInfoForImsiEncryption(int indicationType) {
        this.mRil.processIndication(indicationType);
        this.mRil.unsljLogRet(1048, null);
        this.mRil.mCarrierInfoForImsiEncryptionRegistrants.notifyRegistrants(new AsyncResult(null, null, null));
    }

    @Override
    public void keepaliveStatus(int indicationType, KeepaliveStatus keepaliveStatus) {
        throw new UnsupportedOperationException("keepaliveStatus Indications are not implemented");
    }

    private CommandsInterface.RadioState getRadioStateFromInt(int stateInt) {
        CommandsInterface.RadioState state;
        switch (stateInt) {
            case 0: {
                state = CommandsInterface.RadioState.RADIO_OFF;
                break;
            }
            case 1: {
                state = CommandsInterface.RadioState.RADIO_UNAVAILABLE;
                break;
            }
            case 10: {
                state = CommandsInterface.RadioState.RADIO_ON;
                break;
            }
            default: {
                throw new RuntimeException("Unrecognized RadioState: " + stateInt);
            }
        }
        return state;
    }

    private void responseCellInfos(int indicationType, android.hardware.radio.V1_1.NetworkScanResult result) {
        this.mRil.processIndication(indicationType);
        NetworkScanResult nsr = null;
        ArrayList<android.telephony.CellInfo> infos = RIL.convertHalCellInfoList(result.networkInfos);
        nsr = new NetworkScanResult(result.status, result.error, infos);
        this.mRil.unsljLogRet(1049, nsr);
        this.mRil.mRilNetworkScanResultRegistrants.notifyRegistrants(new AsyncResult(null, nsr, null));
    }
}

