/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.MatchAllNetworkSpecifier;
import android.net.NetworkCapabilities;
import android.net.NetworkFactory;
import android.net.NetworkRequest;
import android.net.NetworkSpecifier;
import android.net.StringNetworkSpecifier;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Registrant;
import android.os.RegistrantList;
import android.os.RemoteException;
import android.telephony.Rlog;
import android.util.LocalLog;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.IOnSubscriptionsChangedListener;
import com.android.internal.telephony.ITelephonyRegistry;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.SubscriptionController;
import com.android.internal.telephony.dataconnection.DcRequest;
import com.android.internal.util.IndentingPrintWriter;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class PhoneSwitcher
extends Handler {
    private static final String LOG_TAG = "PhoneSwitcher";
    private static final boolean VDBG = false;
    private final int mMaxActivePhones;
    private final List<DcRequest> mPrioritizedDcRequests = new ArrayList<DcRequest>();
    private final RegistrantList[] mActivePhoneRegistrants;
    private final SubscriptionController mSubscriptionController;
    private final int[] mPhoneSubscriptions;
    private final CommandsInterface[] mCommandsInterfaces;
    private final Context mContext;
    private final PhoneState[] mPhoneStates;
    private final int mNumPhones;
    private final Phone[] mPhones;
    private final LocalLog mLocalLog;
    private int mDefaultDataSubscription;
    private static final int EVENT_DEFAULT_SUBSCRIPTION_CHANGED = 101;
    private static final int EVENT_SUBSCRIPTION_CHANGED = 102;
    private static final int EVENT_REQUEST_NETWORK = 103;
    private static final int EVENT_RELEASE_NETWORK = 104;
    private static final int EVENT_EMERGENCY_TOGGLE = 105;
    private static final int EVENT_RESEND_DATA_ALLOWED = 106;
    private static final int MAX_LOCAL_LOG_LINES = 30;
    private final BroadcastReceiver mDefaultDataChangedReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            Message msg = PhoneSwitcher.this.obtainMessage(101);
            msg.sendToTarget();
        }
    };
    private final IOnSubscriptionsChangedListener mSubscriptionsChangedListener = new IOnSubscriptionsChangedListener.Stub(){

        @Override
        public void onSubscriptionsChanged() {
            Message msg = PhoneSwitcher.this.obtainMessage(102);
            msg.sendToTarget();
        }
    };
    private static final boolean REQUESTS_CHANGED = true;
    private static final boolean REQUESTS_UNCHANGED = false;

    public PhoneSwitcher(Looper looper) {
        super(looper);
        this.mMaxActivePhones = 0;
        this.mSubscriptionController = null;
        this.mPhoneSubscriptions = null;
        this.mCommandsInterfaces = null;
        this.mContext = null;
        this.mPhoneStates = null;
        this.mPhones = null;
        this.mLocalLog = null;
        this.mActivePhoneRegistrants = null;
        this.mNumPhones = 0;
    }

    public PhoneSwitcher(int maxActivePhones, int numPhones, Context context, SubscriptionController subscriptionController, Looper looper, ITelephonyRegistry tr, CommandsInterface[] cis, Phone[] phones) {
        super(looper);
        this.mContext = context;
        this.mNumPhones = numPhones;
        this.mPhones = phones;
        this.mPhoneSubscriptions = new int[numPhones];
        this.mMaxActivePhones = maxActivePhones;
        this.mLocalLog = new LocalLog(30);
        this.mSubscriptionController = subscriptionController;
        this.mActivePhoneRegistrants = new RegistrantList[numPhones];
        this.mPhoneStates = new PhoneState[numPhones];
        for (int i = 0; i < numPhones; ++i) {
            this.mActivePhoneRegistrants[i] = new RegistrantList();
            this.mPhoneStates[i] = new PhoneState();
            if (this.mPhones[i] == null) continue;
            this.mPhones[i].registerForEmergencyCallToggle(this, 105, null);
        }
        this.mCommandsInterfaces = cis;
        try {
            tr.addOnSubscriptionsChangedListener(LOG_TAG, this.mSubscriptionsChangedListener);
        }
        catch (RemoteException i) {
            // empty catch block
        }
        this.mContext.registerReceiver(this.mDefaultDataChangedReceiver, new IntentFilter("android.intent.action.ACTION_DEFAULT_DATA_SUBSCRIPTION_CHANGED"));
        NetworkCapabilities netCap = new NetworkCapabilities();
        netCap.addTransportType(0);
        netCap.addCapability(0);
        netCap.addCapability(1);
        netCap.addCapability(2);
        netCap.addCapability(3);
        netCap.addCapability(4);
        netCap.addCapability(5);
        netCap.addCapability(7);
        netCap.addCapability(8);
        netCap.addCapability(9);
        netCap.addCapability(10);
        netCap.addCapability(13);
        netCap.addCapability(12);
        netCap.setNetworkSpecifier(new MatchAllNetworkSpecifier());
        PhoneSwitcherNetworkRequestListener networkFactory = new PhoneSwitcherNetworkRequestListener(looper, context, netCap, this);
        networkFactory.setScoreFilter(101);
        networkFactory.register();
        this.log("PhoneSwitcher started");
    }

    @Override
    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 102: {
                this.onEvaluate(false, "subChanged");
                break;
            }
            case 101: {
                this.onEvaluate(false, "defaultChanged");
                break;
            }
            case 103: {
                this.onRequestNetwork((NetworkRequest)msg.obj);
                break;
            }
            case 104: {
                this.onReleaseNetwork((NetworkRequest)msg.obj);
                break;
            }
            case 105: {
                this.onEvaluate(true, "emergencyToggle");
                break;
            }
            case 106: {
                this.onResendDataAllowed(msg);
            }
        }
    }

    private boolean isEmergency() {
        for (Phone p : this.mPhones) {
            if (p == null || !p.isInEcm() && !p.isInEmergencyCall()) continue;
            return true;
        }
        return false;
    }

    private void onRequestNetwork(NetworkRequest networkRequest) {
        DcRequest dcRequest = new DcRequest(networkRequest, this.mContext);
        if (!this.mPrioritizedDcRequests.contains(dcRequest)) {
            this.mPrioritizedDcRequests.add(dcRequest);
            Collections.sort(this.mPrioritizedDcRequests);
            this.onEvaluate(true, "netRequest");
        }
    }

    private void onReleaseNetwork(NetworkRequest networkRequest) {
        DcRequest dcRequest = new DcRequest(networkRequest, this.mContext);
        if (this.mPrioritizedDcRequests.remove(dcRequest)) {
            this.onEvaluate(true, "netReleased");
        }
    }

    private void onEvaluate(boolean requestsChanged, String reason) {
        StringBuilder sb = new StringBuilder(reason);
        if (this.isEmergency()) {
            this.log("onEvalute aborted due to Emergency");
            return;
        }
        boolean diffDetected = requestsChanged;
        int dataSub = this.mSubscriptionController.getDefaultDataSubId();
        if (dataSub != this.mDefaultDataSubscription) {
            sb.append(" default ").append(this.mDefaultDataSubscription).append("->").append(dataSub);
            this.mDefaultDataSubscription = dataSub;
            diffDetected = true;
        }
        for (int i = 0; i < this.mNumPhones; ++i) {
            int sub = this.mSubscriptionController.getSubIdUsingPhoneId(i);
            if (sub == this.mPhoneSubscriptions[i]) continue;
            sb.append(" phone[").append(i).append("] ").append(this.mPhoneSubscriptions[i]);
            sb.append("->").append(sub);
            this.mPhoneSubscriptions[i] = sub;
            diffDetected = true;
        }
        if (diffDetected) {
            this.log("evaluating due to " + sb.toString());
            ArrayList<Integer> newActivePhones = new ArrayList<Integer>();
            for (DcRequest dcRequest : this.mPrioritizedDcRequests) {
                int phoneIdForRequest = this.phoneIdForRequest(dcRequest.networkRequest);
                if (phoneIdForRequest == -1 || newActivePhones.contains(phoneIdForRequest)) continue;
                newActivePhones.add(phoneIdForRequest);
                if (newActivePhones.size() < this.mMaxActivePhones) continue;
                break;
            }
            for (int phoneId = 0; phoneId < this.mNumPhones; ++phoneId) {
                if (newActivePhones.contains(phoneId)) continue;
                this.deactivate(phoneId);
            }
            Iterator iterator = newActivePhones.iterator();
            while (iterator.hasNext()) {
                int phoneId = (Integer)iterator.next();
                this.activate(phoneId);
            }
        }
    }

    private void deactivate(int phoneId) {
        PhoneState state = this.mPhoneStates[phoneId];
        if (!state.active) {
            return;
        }
        state.active = false;
        this.log("deactivate " + phoneId);
        state.lastRequested = System.currentTimeMillis();
        if (this.mNumPhones > 1) {
            this.mCommandsInterfaces[phoneId].setDataAllowed(false, null);
        }
        this.mActivePhoneRegistrants[phoneId].notifyRegistrants();
    }

    private void activate(int phoneId) {
        PhoneState state = this.mPhoneStates[phoneId];
        if (state.active) {
            return;
        }
        state.active = true;
        this.log("activate " + phoneId);
        state.lastRequested = System.currentTimeMillis();
        if (this.mNumPhones > 1) {
            this.mCommandsInterfaces[phoneId].setDataAllowed(true, null);
        }
        this.mActivePhoneRegistrants[phoneId].notifyRegistrants();
    }

    public void resendDataAllowed(int phoneId) {
        this.validatePhoneId(phoneId);
        Message msg = this.obtainMessage(106);
        msg.arg1 = phoneId;
        msg.sendToTarget();
    }

    private void onResendDataAllowed(Message msg) {
        int phoneId = msg.arg1;
        if (this.mNumPhones > 1) {
            this.mCommandsInterfaces[phoneId].setDataAllowed(this.mPhoneStates[phoneId].active, null);
        }
    }

    private int phoneIdForRequest(NetworkRequest netRequest) {
        int subId;
        NetworkSpecifier specifier = netRequest.networkCapabilities.getNetworkSpecifier();
        if (specifier == null) {
            subId = this.mDefaultDataSubscription;
        } else if (specifier instanceof StringNetworkSpecifier) {
            try {
                subId = Integer.parseInt(((StringNetworkSpecifier)specifier).specifier);
            }
            catch (NumberFormatException e) {
                Rlog.e(LOG_TAG, "NumberFormatException on " + ((StringNetworkSpecifier)specifier).specifier);
                subId = -1;
            }
        } else {
            subId = -1;
        }
        int phoneId = -1;
        if (subId == -1) {
            return phoneId;
        }
        for (int i = 0; i < this.mNumPhones; ++i) {
            if (this.mPhoneSubscriptions[i] != subId) continue;
            phoneId = i;
            break;
        }
        return phoneId;
    }

    public boolean isPhoneActive(int phoneId) {
        this.validatePhoneId(phoneId);
        return this.mPhoneStates[phoneId].active;
    }

    public void registerForActivePhoneSwitch(int phoneId, Handler h, int what, Object o) {
        this.validatePhoneId(phoneId);
        Registrant r = new Registrant(h, what, o);
        this.mActivePhoneRegistrants[phoneId].add(r);
        r.notifyRegistrant();
    }

    public void unregisterForActivePhoneSwitch(int phoneId, Handler h) {
        this.validatePhoneId(phoneId);
        this.mActivePhoneRegistrants[phoneId].remove(h);
    }

    private void validatePhoneId(int phoneId) {
        if (phoneId < 0 || phoneId >= this.mNumPhones) {
            throw new IllegalArgumentException("Invalid PhoneId");
        }
    }

    private void log(String l) {
        Rlog.d(LOG_TAG, l);
        this.mLocalLog.log(l);
    }

    public void dump(FileDescriptor fd, PrintWriter writer, String[] args) {
        IndentingPrintWriter pw = new IndentingPrintWriter((Writer)writer, "  ");
        pw.println("PhoneSwitcher:");
        Calendar c = Calendar.getInstance();
        for (int i = 0; i < this.mNumPhones; ++i) {
            PhoneState ps = this.mPhoneStates[i];
            c.setTimeInMillis(ps.lastRequested);
            pw.println("PhoneId(" + i + ") active=" + ps.active + ", lastRequest=" + (ps.lastRequested == 0L ? "never" : String.format("%tm-%td %tH:%tM:%tS.%tL", c, c, c, c, c, c)));
        }
        pw.increaseIndent();
        this.mLocalLog.dump(fd, pw, args);
        pw.decreaseIndent();
    }

    private static class PhoneState {
        public volatile boolean active = false;
        public long lastRequested = 0L;

        private PhoneState() {
        }
    }

    private static class PhoneSwitcherNetworkRequestListener
    extends NetworkFactory {
        private final PhoneSwitcher mPhoneSwitcher;

        public PhoneSwitcherNetworkRequestListener(Looper l, Context c, NetworkCapabilities nc, PhoneSwitcher ps) {
            super(l, c, "PhoneSwitcherNetworkRequstListener", nc);
            this.mPhoneSwitcher = ps;
        }

        @Override
        protected void needNetworkFor(NetworkRequest networkRequest, int score) {
            Message msg = this.mPhoneSwitcher.obtainMessage(103);
            msg.obj = networkRequest;
            msg.sendToTarget();
        }

        @Override
        protected void releaseNetworkFor(NetworkRequest networkRequest) {
            Message msg = this.mPhoneSwitcher.obtainMessage(104);
            msg.obj = networkRequest;
            msg.sendToTarget();
        }
    }
}

