/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.app.AppOpsManager;
import android.content.Context;
import android.os.Binder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.telephony.ImsiEncryptionInfo;
import android.telephony.PhoneNumberUtils;
import android.telephony.Rlog;
import android.telephony.SubscriptionManager;
import com.android.internal.telephony.IPhoneSubInfo;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneFactory;
import com.android.internal.telephony.uicc.IsimRecords;
import com.android.internal.telephony.uicc.UiccCard;
import com.android.internal.telephony.uicc.UiccCardApplication;

public class PhoneSubInfoController
extends IPhoneSubInfo.Stub {
    private static final String TAG = "PhoneSubInfoController";
    private static final boolean DBG = true;
    private static final boolean VDBG = false;
    private final Phone[] mPhone;
    private final Context mContext;
    private final AppOpsManager mAppOps;

    public PhoneSubInfoController(Context context, Phone[] phone) {
        this.mPhone = phone;
        if (ServiceManager.getService("iphonesubinfo") == null) {
            ServiceManager.addService("iphonesubinfo", this);
        }
        this.mContext = context;
        this.mAppOps = (AppOpsManager)this.mContext.getSystemService("appops");
    }

    @Override
    public String getDeviceId(String callingPackage) {
        return this.getDeviceIdForPhone(SubscriptionManager.getPhoneId(this.getDefaultSubscription()), callingPackage);
    }

    @Override
    public String getDeviceIdForPhone(int phoneId, String callingPackage) {
        Phone phone;
        if (!this.checkReadPhoneState(callingPackage, "getDeviceId")) {
            return null;
        }
        if (!SubscriptionManager.isValidPhoneId(phoneId)) {
            phoneId = 0;
        }
        if ((phone = this.mPhone[phoneId]) != null) {
            return phone.getDeviceId();
        }
        this.loge("getDeviceIdForPhone phone " + phoneId + " is null");
        return null;
    }

    @Override
    public String getNaiForSubscriber(int subId, String callingPackage) {
        Phone phone = this.getPhone(subId);
        if (phone != null) {
            if (!this.checkReadPhoneState(callingPackage, "getNai")) {
                return null;
            }
            return phone.getNai();
        }
        this.loge("getNai phone is null for Subscription:" + subId);
        return null;
    }

    @Override
    public String getImeiForSubscriber(int subId, String callingPackage) {
        Phone phone = this.getPhone(subId);
        if (phone != null) {
            if (!this.checkReadPhoneState(callingPackage, "getImei")) {
                return null;
            }
            return phone.getImei();
        }
        this.loge("getDeviceId phone is null for Subscription:" + subId);
        return null;
    }

    @Override
    public ImsiEncryptionInfo getCarrierInfoForImsiEncryption(int subId, int keyType, String callingPackage) {
        Phone phone = this.getPhone(subId);
        if (phone != null) {
            if (!this.checkReadPhoneState(callingPackage, "getCarrierInfoForImsiEncryption")) {
                return null;
            }
            return phone.getCarrierInfoForImsiEncryption(keyType);
        }
        this.loge("getCarrierInfoForImsiEncryption phone is null for Subscription:" + subId);
        return null;
    }

    @Override
    public void setCarrierInfoForImsiEncryption(int subId, String callingPackage, ImsiEncryptionInfo imsiEncryptionInfo) {
        Phone phone = this.getPhone(subId);
        if (phone != null) {
            if (!this.checkReadPhoneState(callingPackage, "setCarrierInfoForImsiEncryption")) {
                return;
            }
        } else {
            this.loge("setCarrierInfoForImsiEncryption phone is null for Subscription:" + subId);
            return;
        }
        phone.setCarrierInfoForImsiEncryption(imsiEncryptionInfo);
    }

    @Override
    public String getDeviceSvn(String callingPackage) {
        return this.getDeviceSvnUsingSubId(this.getDefaultSubscription(), callingPackage);
    }

    @Override
    public String getDeviceSvnUsingSubId(int subId, String callingPackage) {
        Phone phone = this.getPhone(subId);
        if (phone != null) {
            if (!this.checkReadPhoneState(callingPackage, "getDeviceSvn")) {
                return null;
            }
            return phone.getDeviceSvn();
        }
        this.loge("getDeviceSvn phone is null");
        return null;
    }

    @Override
    public String getSubscriberId(String callingPackage) {
        return this.getSubscriberIdForSubscriber(this.getDefaultSubscription(), callingPackage);
    }

    @Override
    public String getSubscriberIdForSubscriber(int subId, String callingPackage) {
        Phone phone = this.getPhone(subId);
        if (phone != null) {
            if (!this.checkReadPhoneState(callingPackage, "getSubscriberId")) {
                return null;
            }
            return phone.getSubscriberId();
        }
        this.loge("getSubscriberId phone is null for Subscription:" + subId);
        return null;
    }

    @Override
    public String getIccSerialNumber(String callingPackage) {
        return this.getIccSerialNumberForSubscriber(this.getDefaultSubscription(), callingPackage);
    }

    @Override
    public String getIccSerialNumberForSubscriber(int subId, String callingPackage) {
        Phone phone = this.getPhone(subId);
        if (phone != null) {
            if (!this.checkReadPhoneState(callingPackage, "getIccSerialNumber")) {
                return null;
            }
            return phone.getIccSerialNumber();
        }
        this.loge("getIccSerialNumber phone is null for Subscription:" + subId);
        return null;
    }

    @Override
    public String getLine1Number(String callingPackage) {
        return this.getLine1NumberForSubscriber(this.getDefaultSubscription(), callingPackage);
    }

    @Override
    public String getLine1NumberForSubscriber(int subId, String callingPackage) {
        Phone phone = this.getPhone(subId);
        if (phone != null) {
            if (!this.checkReadPhoneNumber(callingPackage, "getLine1Number")) {
                return null;
            }
            return phone.getLine1Number();
        }
        this.loge("getLine1Number phone is null for Subscription:" + subId);
        return null;
    }

    @Override
    public String getLine1AlphaTag(String callingPackage) {
        return this.getLine1AlphaTagForSubscriber(this.getDefaultSubscription(), callingPackage);
    }

    @Override
    public String getLine1AlphaTagForSubscriber(int subId, String callingPackage) {
        Phone phone = this.getPhone(subId);
        if (phone != null) {
            if (!this.checkReadPhoneState(callingPackage, "getLine1AlphaTag")) {
                return null;
            }
            return phone.getLine1AlphaTag();
        }
        this.loge("getLine1AlphaTag phone is null for Subscription:" + subId);
        return null;
    }

    @Override
    public String getMsisdn(String callingPackage) {
        return this.getMsisdnForSubscriber(this.getDefaultSubscription(), callingPackage);
    }

    @Override
    public String getMsisdnForSubscriber(int subId, String callingPackage) {
        Phone phone = this.getPhone(subId);
        if (phone != null) {
            if (!this.checkReadPhoneState(callingPackage, "getMsisdn")) {
                return null;
            }
            return phone.getMsisdn();
        }
        this.loge("getMsisdn phone is null for Subscription:" + subId);
        return null;
    }

    @Override
    public String getVoiceMailNumber(String callingPackage) {
        return this.getVoiceMailNumberForSubscriber(this.getDefaultSubscription(), callingPackage);
    }

    @Override
    public String getVoiceMailNumberForSubscriber(int subId, String callingPackage) {
        Phone phone = this.getPhone(subId);
        if (phone != null) {
            if (!this.checkReadPhoneState(callingPackage, "getVoiceMailNumber")) {
                return null;
            }
            String number = PhoneNumberUtils.extractNetworkPortion(phone.getVoiceMailNumber());
            return number;
        }
        this.loge("getVoiceMailNumber phone is null for Subscription:" + subId);
        return null;
    }

    @Override
    public String getCompleteVoiceMailNumber() {
        return this.getCompleteVoiceMailNumberForSubscriber(this.getDefaultSubscription());
    }

    @Override
    public String getCompleteVoiceMailNumberForSubscriber(int subId) {
        Phone phone = this.getPhone(subId);
        if (phone != null) {
            this.mContext.enforceCallingOrSelfPermission("android.permission.CALL_PRIVILEGED", "Requires CALL_PRIVILEGED");
            String number = phone.getVoiceMailNumber();
            return number;
        }
        this.loge("getCompleteVoiceMailNumber phone is null for Subscription:" + subId);
        return null;
    }

    @Override
    public String getVoiceMailAlphaTag(String callingPackage) {
        return this.getVoiceMailAlphaTagForSubscriber(this.getDefaultSubscription(), callingPackage);
    }

    @Override
    public String getVoiceMailAlphaTagForSubscriber(int subId, String callingPackage) {
        Phone phone = this.getPhone(subId);
        if (phone != null) {
            if (!this.checkReadPhoneState(callingPackage, "getVoiceMailAlphaTag")) {
                return null;
            }
            return phone.getVoiceMailAlphaTag();
        }
        this.loge("getVoiceMailAlphaTag phone is null for Subscription:" + subId);
        return null;
    }

    private Phone getPhone(int subId) {
        int phoneId = SubscriptionManager.getPhoneId(subId);
        if (!SubscriptionManager.isValidPhoneId(phoneId)) {
            phoneId = 0;
        }
        return this.mPhone[phoneId];
    }

    private void enforcePrivilegedPermissionOrCarrierPrivilege(Phone phone) {
        int permissionResult = this.mContext.checkCallingOrSelfPermission("android.permission.READ_PRIVILEGED_PHONE_STATE");
        if (permissionResult == 0) {
            return;
        }
        this.log("No read privileged phone permission, check carrier privilege next.");
        UiccCard uiccCard = phone.getUiccCard();
        if (uiccCard == null) {
            throw new SecurityException("No Carrier Privilege: No UICC");
        }
        if (uiccCard.getCarrierPrivilegeStatusForCurrentTransaction(this.mContext.getPackageManager()) != 1) {
            throw new SecurityException("No Carrier Privilege.");
        }
    }

    private int getDefaultSubscription() {
        return PhoneFactory.getDefaultSubscription();
    }

    @Override
    public String getIsimImpi() {
        Phone phone = this.getPhone(this.getDefaultSubscription());
        this.mContext.enforceCallingOrSelfPermission("android.permission.READ_PRIVILEGED_PHONE_STATE", "Requires READ_PRIVILEGED_PHONE_STATE");
        IsimRecords isim = phone.getIsimRecords();
        if (isim != null) {
            return isim.getIsimImpi();
        }
        return null;
    }

    @Override
    public String getIsimDomain() {
        Phone phone = this.getPhone(this.getDefaultSubscription());
        this.mContext.enforceCallingOrSelfPermission("android.permission.READ_PRIVILEGED_PHONE_STATE", "Requires READ_PRIVILEGED_PHONE_STATE");
        IsimRecords isim = phone.getIsimRecords();
        if (isim != null) {
            return isim.getIsimDomain();
        }
        return null;
    }

    @Override
    public String[] getIsimImpu() {
        Phone phone = this.getPhone(this.getDefaultSubscription());
        this.mContext.enforceCallingOrSelfPermission("android.permission.READ_PRIVILEGED_PHONE_STATE", "Requires READ_PRIVILEGED_PHONE_STATE");
        IsimRecords isim = phone.getIsimRecords();
        if (isim != null) {
            return isim.getIsimImpu();
        }
        return null;
    }

    @Override
    public String getIsimIst() throws RemoteException {
        Phone phone = this.getPhone(this.getDefaultSubscription());
        this.mContext.enforceCallingOrSelfPermission("android.permission.READ_PRIVILEGED_PHONE_STATE", "Requires READ_PRIVILEGED_PHONE_STATE");
        IsimRecords isim = phone.getIsimRecords();
        if (isim != null) {
            return isim.getIsimIst();
        }
        return null;
    }

    @Override
    public String[] getIsimPcscf() throws RemoteException {
        Phone phone = this.getPhone(this.getDefaultSubscription());
        this.mContext.enforceCallingOrSelfPermission("android.permission.READ_PRIVILEGED_PHONE_STATE", "Requires READ_PRIVILEGED_PHONE_STATE");
        IsimRecords isim = phone.getIsimRecords();
        if (isim != null) {
            return isim.getIsimPcscf();
        }
        return null;
    }

    @Override
    public String getIsimChallengeResponse(String nonce) throws RemoteException {
        Phone phone = this.getPhone(this.getDefaultSubscription());
        this.mContext.enforceCallingOrSelfPermission("android.permission.READ_PRIVILEGED_PHONE_STATE", "Requires READ_PRIVILEGED_PHONE_STATE");
        IsimRecords isim = phone.getIsimRecords();
        if (isim != null) {
            return isim.getIsimChallengeResponse(nonce);
        }
        return null;
    }

    @Override
    public String getIccSimChallengeResponse(int subId, int appType, int authType, String data) throws RemoteException {
        Phone phone = this.getPhone(subId);
        this.enforcePrivilegedPermissionOrCarrierPrivilege(phone);
        UiccCard uiccCard = phone.getUiccCard();
        if (uiccCard == null) {
            this.loge("getIccSimChallengeResponse() UiccCard is null");
            return null;
        }
        UiccCardApplication uiccApp = uiccCard.getApplicationByType(appType);
        if (uiccApp == null) {
            this.loge("getIccSimChallengeResponse() no app with specified type -- " + appType);
            return null;
        }
        this.loge("getIccSimChallengeResponse() found app " + uiccApp.getAid() + " specified type -- " + appType);
        if (authType != 128 && authType != 129) {
            this.loge("getIccSimChallengeResponse() unsupported authType: " + authType);
            return null;
        }
        return uiccApp.getIccRecords().getIccSimChallengeResponse(authType, data);
    }

    @Override
    public String getGroupIdLevel1(String callingPackage) {
        return this.getGroupIdLevel1ForSubscriber(this.getDefaultSubscription(), callingPackage);
    }

    @Override
    public String getGroupIdLevel1ForSubscriber(int subId, String callingPackage) {
        Phone phone = this.getPhone(subId);
        if (phone != null) {
            if (!this.checkReadPhoneState(callingPackage, "getGroupIdLevel1")) {
                return null;
            }
            return phone.getGroupIdLevel1();
        }
        this.loge("getGroupIdLevel1 phone is null for Subscription:" + subId);
        return null;
    }

    private boolean checkReadPhoneState(String callingPackage, String message) {
        try {
            this.mContext.enforceCallingOrSelfPermission("android.permission.READ_PRIVILEGED_PHONE_STATE", message);
            return true;
        }
        catch (SecurityException e) {
            this.mContext.enforceCallingOrSelfPermission("android.permission.READ_PHONE_STATE", message);
            return this.mAppOps.noteOp(51, Binder.getCallingUid(), callingPackage) == 0;
        }
    }

    private boolean checkReadPhoneNumber(String callingPackage, String message) {
        if (this.mAppOps.noteOp(15, Binder.getCallingUid(), callingPackage) == 0) {
            return true;
        }
        try {
            return this.checkReadPhoneState(callingPackage, message);
        }
        catch (SecurityException securityException) {
            try {
                this.mContext.enforceCallingOrSelfPermission("android.permission.READ_SMS", message);
                int opCode = AppOpsManager.permissionToOpCode("android.permission.READ_SMS");
                if (opCode != -1) {
                    return this.mAppOps.noteOp(opCode, Binder.getCallingUid(), callingPackage) == 0;
                }
                return true;
            }
            catch (SecurityException opCode) {
                try {
                    this.mContext.enforceCallingOrSelfPermission("android.permission.READ_PHONE_NUMBERS", message);
                    int opCode2 = AppOpsManager.permissionToOpCode("android.permission.READ_PHONE_NUMBERS");
                    if (opCode2 != -1) {
                        return this.mAppOps.noteOp(opCode2, Binder.getCallingUid(), callingPackage) == 0;
                    }
                    return true;
                }
                catch (SecurityException securityException2) {
                    throw new SecurityException(message + ": Neither user " + Binder.getCallingUid() + " nor current process has " + "android.permission.READ_PHONE_STATE" + ", " + "android.permission.READ_SMS" + ", or " + "android.permission.READ_PHONE_STATE" + ".");
                }
            }
        }
    }

    private void log(String s) {
        Rlog.d(TAG, s);
    }

    private void loge(String s) {
        Rlog.e(TAG, s);
    }
}

