/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.app.ActivityManager;
import android.content.BroadcastReceiver;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.database.SQLException;
import android.net.Uri;
import android.os.AsyncResult;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.PersistableBundle;
import android.os.PowerManager;
import android.os.Registrant;
import android.os.RegistrantList;
import android.os.ResultReceiver;
import android.os.SystemProperties;
import android.os.WorkSource;
import android.preference.PreferenceManager;
import android.provider.Settings;
import android.provider.Telephony;
import android.telecom.VideoProfile;
import android.telephony.CarrierConfigManager;
import android.telephony.CellLocation;
import android.telephony.ImsiEncryptionInfo;
import android.telephony.NetworkScanRequest;
import android.telephony.PhoneNumberUtils;
import android.telephony.Rlog;
import android.telephony.ServiceState;
import android.telephony.SubscriptionInfo;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import android.telephony.UssdResponse;
import android.telephony.cdma.CdmaCellLocation;
import android.text.TextUtils;
import android.util.Log;
import com.android.ims.ImsManager;
import com.android.internal.telephony.Call;
import com.android.internal.telephony.CallForwardInfo;
import com.android.internal.telephony.CallStateException;
import com.android.internal.telephony.CallTracker;
import com.android.internal.telephony.CarrierInfoManager;
import com.android.internal.telephony.CarrierKeyDownloadManager;
import com.android.internal.telephony.CommandException;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.Connection;
import com.android.internal.telephony.DeviceStateMonitor;
import com.android.internal.telephony.GsmCdmaCall;
import com.android.internal.telephony.GsmCdmaCallTracker;
import com.android.internal.telephony.GsmCdmaConnection;
import com.android.internal.telephony.IccCard;
import com.android.internal.telephony.IccPhoneBookInterfaceManager;
import com.android.internal.telephony.IccSmsInterfaceManager;
import com.android.internal.telephony.MccTable;
import com.android.internal.telephony.MmiCode;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneConstants;
import com.android.internal.telephony.PhoneInternalInterface;
import com.android.internal.telephony.PhoneNotifier;
import com.android.internal.telephony.RadioCapability;
import com.android.internal.telephony.ServiceStateTracker;
import com.android.internal.telephony.SubscriptionController;
import com.android.internal.telephony.TelephonyComponentFactory;
import com.android.internal.telephony.UUSInfo;
import com.android.internal.telephony.cdma.CdmaMmiCode;
import com.android.internal.telephony.cdma.CdmaSubscriptionSourceManager;
import com.android.internal.telephony.cdma.EriManager;
import com.android.internal.telephony.gsm.GsmMmiCode;
import com.android.internal.telephony.gsm.SuppServiceNotification;
import com.android.internal.telephony.test.SimulatedRadioControl;
import com.android.internal.telephony.uicc.IccCardProxy;
import com.android.internal.telephony.uicc.IccException;
import com.android.internal.telephony.uicc.IccRecords;
import com.android.internal.telephony.uicc.IccVmNotSupportedException;
import com.android.internal.telephony.uicc.IsimRecords;
import com.android.internal.telephony.uicc.IsimUiccRecords;
import com.android.internal.telephony.uicc.RuimRecords;
import com.android.internal.telephony.uicc.SIMRecords;
import com.android.internal.telephony.uicc.UiccCard;
import com.android.internal.telephony.uicc.UiccCardApplication;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GsmCdmaPhone
extends Phone {
    public static final String LOG_TAG = "GsmCdmaPhone";
    private static final boolean DBG = true;
    private static final boolean VDBG = false;
    private static final String VM_NUMBER = "vm_number_key";
    private static final String VM_SIM_IMSI = "vm_sim_imsi_key";
    private RegistrantList mSsnRegistrants = new RegistrantList();
    private static final int DEFAULT_ECM_EXIT_TIMER_VALUE = 300000;
    private static final String VM_NUMBER_CDMA = "vm_number_key_cdma";
    public static final int RESTART_ECM_TIMER = 0;
    public static final int CANCEL_ECM_TIMER = 1;
    private CdmaSubscriptionSourceManager mCdmaSSM;
    public int mCdmaSubscriptionSource = -1;
    public EriManager mEriManager;
    private PowerManager.WakeLock mWakeLock;
    private final RegistrantList mEriFileLoadedRegistrants = new RegistrantList();
    private Registrant mEcmExitRespRegistrant;
    private String mEsn;
    private String mMeid;
    private String mCarrierOtaSpNumSchema;
    private Runnable mExitEcmRunnable = new Runnable(){

        @Override
        public void run() {
            GsmCdmaPhone.this.exitEmergencyCallbackMode();
        }
    };
    public static final String PROPERTY_CDMA_HOME_OPERATOR_NUMERIC = "ro.cdma.home.operator.numeric";
    private SIMRecords mSimRecords;
    private IsimUiccRecords mIsimUiccRecords;
    public GsmCdmaCallTracker mCT;
    public ServiceStateTracker mSST;
    private ArrayList<MmiCode> mPendingMMIs = new ArrayList();
    private IccPhoneBookInterfaceManager mIccPhoneBookIntManager;
    private DeviceStateMonitor mDeviceStateMonitor;
    private int mPrecisePhoneType;
    private final RegistrantList mEcmTimerResetRegistrants = new RegistrantList();
    private String mImei;
    private String mImeiSv;
    private String mVmNumber;
    private IccSmsInterfaceManager mIccSmsInterfaceManager;
    private IccCardProxy mIccCardProxy;
    private boolean mResetModemOnRadioTechnologyChange = false;
    private int mRilVersion;
    private boolean mBroadcastEmergencyCallStateChanges = false;
    private CarrierKeyDownloadManager mCDM;
    private BroadcastReceiver mBroadcastReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            Rlog.d(GsmCdmaPhone.LOG_TAG, "mBroadcastReceiver: action " + intent.getAction());
            if (intent.getAction().equals("android.telephony.action.CARRIER_CONFIG_CHANGED")) {
                GsmCdmaPhone.this.sendMessage(GsmCdmaPhone.this.obtainMessage(43));
            }
        }
    };
    private static final String IS683A_FEATURE_CODE = "*228";
    private static final int IS683A_FEATURE_CODE_NUM_DIGITS = 4;
    private static final int IS683A_SYS_SEL_CODE_NUM_DIGITS = 2;
    private static final int IS683A_SYS_SEL_CODE_OFFSET = 4;
    private static final int IS683_CONST_800MHZ_A_BAND = 0;
    private static final int IS683_CONST_800MHZ_B_BAND = 1;
    private static final int IS683_CONST_1900MHZ_A_BLOCK = 2;
    private static final int IS683_CONST_1900MHZ_B_BLOCK = 3;
    private static final int IS683_CONST_1900MHZ_C_BLOCK = 4;
    private static final int IS683_CONST_1900MHZ_D_BLOCK = 5;
    private static final int IS683_CONST_1900MHZ_E_BLOCK = 6;
    private static final int IS683_CONST_1900MHZ_F_BLOCK = 7;
    private static final int INVALID_SYSTEM_SELECTION_CODE = -1;
    private static Pattern pOtaSpNumSchema = Pattern.compile("[,\\s]+");

    public GsmCdmaPhone(Context context, CommandsInterface ci, PhoneNotifier notifier, int phoneId, int precisePhoneType, TelephonyComponentFactory telephonyComponentFactory) {
        this(context, ci, notifier, false, phoneId, precisePhoneType, telephonyComponentFactory);
    }

    public GsmCdmaPhone(Context context, CommandsInterface ci, PhoneNotifier notifier, boolean unitTestMode, int phoneId, int precisePhoneType, TelephonyComponentFactory telephonyComponentFactory) {
        super(precisePhoneType == 1 ? "GSM" : "CDMA", notifier, context, ci, unitTestMode, phoneId, telephonyComponentFactory);
        this.mPrecisePhoneType = precisePhoneType;
        this.initOnce(ci);
        this.initRatSpecific(precisePhoneType);
        this.mCarrierActionAgent = this.mTelephonyComponentFactory.makeCarrierActionAgent(this);
        this.mCarrierSignalAgent = this.mTelephonyComponentFactory.makeCarrierSignalAgent(this);
        this.mSST = this.mTelephonyComponentFactory.makeServiceStateTracker(this, this.mCi);
        this.mDcTracker = this.mTelephonyComponentFactory.makeDcTracker(this);
        this.mSST.registerForNetworkAttached(this, 19, null);
        this.mDeviceStateMonitor = this.mTelephonyComponentFactory.makeDeviceStateMonitor(this);
        this.logd("GsmCdmaPhone: constructor: sub = " + this.mPhoneId);
    }

    private void initOnce(CommandsInterface ci) {
        if (ci instanceof SimulatedRadioControl) {
            this.mSimulatedRadioControl = (SimulatedRadioControl)((Object)ci);
        }
        this.mCT = this.mTelephonyComponentFactory.makeGsmCdmaCallTracker(this);
        this.mIccPhoneBookIntManager = this.mTelephonyComponentFactory.makeIccPhoneBookInterfaceManager(this);
        PowerManager pm = (PowerManager)this.mContext.getSystemService("power");
        this.mWakeLock = pm.newWakeLock(1, LOG_TAG);
        this.mIccSmsInterfaceManager = this.mTelephonyComponentFactory.makeIccSmsInterfaceManager(this);
        this.mIccCardProxy = this.mTelephonyComponentFactory.makeIccCardProxy(this.mContext, this.mCi, this.mPhoneId);
        this.mCi.registerForAvailable(this, 1, null);
        this.mCi.registerForOffOrNotAvailable(this, 8, null);
        this.mCi.registerForOn(this, 5, null);
        this.mCi.setOnSuppServiceNotification(this, 2, null);
        this.mCi.setOnUSSD(this, 7, null);
        this.mCi.setOnSs(this, 36, null);
        this.mCdmaSSM = this.mTelephonyComponentFactory.getCdmaSubscriptionSourceManagerInstance(this.mContext, this.mCi, this, 27, null);
        this.mEriManager = this.mTelephonyComponentFactory.makeEriManager(this, this.mContext, 0);
        this.mCi.setEmergencyCallbackMode(this, 25, null);
        this.mCi.registerForExitEmergencyCallbackMode(this, 26, null);
        this.mCi.registerForModemReset(this, 45, null);
        this.mCarrierOtaSpNumSchema = TelephonyManager.from(this.mContext).getOtaSpNumberSchemaForPhone(this.getPhoneId(), "");
        this.mResetModemOnRadioTechnologyChange = SystemProperties.getBoolean("persist.radio.reset_on_switch", false);
        this.mCi.registerForRilConnected(this, 41, null);
        this.mCi.registerForVoiceRadioTechChanged(this, 39, null);
        this.mContext.registerReceiver(this.mBroadcastReceiver, new IntentFilter("android.telephony.action.CARRIER_CONFIG_CHANGED"));
        this.mCDM = new CarrierKeyDownloadManager(this);
    }

    private void initRatSpecific(int precisePhoneType) {
        this.mPendingMMIs.clear();
        this.mIccPhoneBookIntManager.updateIccRecords(null);
        this.mEsn = null;
        this.mMeid = null;
        this.mPrecisePhoneType = precisePhoneType;
        TelephonyManager tm = TelephonyManager.from(this.mContext);
        if (this.isPhoneTypeGsm()) {
            this.mCi.setPhoneType(1);
            tm.setPhoneType(this.getPhoneId(), 1);
            this.mIccCardProxy.setVoiceRadioTech(3);
        } else {
            this.mCdmaSubscriptionSource = -1;
            this.mIsPhoneInEcmState = GsmCdmaPhone.getInEcmMode();
            if (this.mIsPhoneInEcmState) {
                this.mCi.exitEmergencyCallbackMode(this.obtainMessage(26));
            }
            this.mCi.setPhoneType(2);
            tm.setPhoneType(this.getPhoneId(), 2);
            this.mIccCardProxy.setVoiceRadioTech(6);
            String operatorAlpha = SystemProperties.get("ro.cdma.home.operator.alpha");
            String operatorNumeric = SystemProperties.get(PROPERTY_CDMA_HOME_OPERATOR_NUMERIC);
            this.logd("init: operatorAlpha='" + operatorAlpha + "' operatorNumeric='" + operatorNumeric + "'");
            if (this.mUiccController.getUiccCardApplication(this.mPhoneId, 1) == null || this.isPhoneTypeCdmaLte()) {
                if (!TextUtils.isEmpty(operatorAlpha)) {
                    this.logd("init: set 'gsm.sim.operator.alpha' to operator='" + operatorAlpha + "'");
                    tm.setSimOperatorNameForPhone(this.mPhoneId, operatorAlpha);
                }
                if (!TextUtils.isEmpty(operatorNumeric)) {
                    this.logd("init: set 'gsm.sim.operator.numeric' to operator='" + operatorNumeric + "'");
                    this.logd("update icc_operator_numeric=" + operatorNumeric);
                    tm.setSimOperatorNumericForPhone(this.mPhoneId, operatorNumeric);
                    SubscriptionController.getInstance().setMccMnc(operatorNumeric, this.getSubId());
                    this.setIsoCountryProperty(operatorNumeric);
                    this.logd("update mccmnc=" + operatorNumeric);
                    MccTable.updateMccMncConfiguration(this.mContext, operatorNumeric, false);
                }
            }
            this.updateCurrentCarrierInProvider(operatorNumeric);
        }
    }

    private void setIsoCountryProperty(String operatorNumeric) {
        TelephonyManager tm = TelephonyManager.from(this.mContext);
        if (TextUtils.isEmpty(operatorNumeric)) {
            this.logd("setIsoCountryProperty: clear 'gsm.sim.operator.iso-country'");
            tm.setSimCountryIsoForPhone(this.mPhoneId, "");
        } else {
            String iso = "";
            try {
                iso = MccTable.countryCodeForMcc(Integer.parseInt(operatorNumeric.substring(0, 3)));
            }
            catch (NumberFormatException ex) {
                Rlog.e(LOG_TAG, "setIsoCountryProperty: countryCodeForMcc error", ex);
            }
            catch (StringIndexOutOfBoundsException ex) {
                Rlog.e(LOG_TAG, "setIsoCountryProperty: countryCodeForMcc error", ex);
            }
            this.logd("setIsoCountryProperty: set 'gsm.sim.operator.iso-country' to iso=" + iso);
            tm.setSimCountryIsoForPhone(this.mPhoneId, iso);
        }
    }

    public boolean isPhoneTypeGsm() {
        return this.mPrecisePhoneType == 1;
    }

    public boolean isPhoneTypeCdma() {
        return this.mPrecisePhoneType == 2;
    }

    public boolean isPhoneTypeCdmaLte() {
        return this.mPrecisePhoneType == 6;
    }

    private void switchPhoneType(int precisePhoneType) {
        this.removeCallbacks(this.mExitEcmRunnable);
        this.initRatSpecific(precisePhoneType);
        this.mSST.updatePhoneType();
        this.setPhoneName(precisePhoneType == 1 ? "GSM" : "CDMA");
        this.onUpdateIccAvailability();
        this.mCT.updatePhoneType();
        CommandsInterface.RadioState radioState = this.mCi.getRadioState();
        if (radioState.isAvailable()) {
            this.handleRadioAvailable();
            if (radioState.isOn()) {
                this.handleRadioOn();
            }
        }
        if (!radioState.isAvailable() || !radioState.isOn()) {
            this.handleRadioOffOrNotAvailable();
        }
    }

    protected void finalize() {
        this.logd("GsmCdmaPhone finalized");
        if (this.mWakeLock != null && this.mWakeLock.isHeld()) {
            Rlog.e(LOG_TAG, "UNEXPECTED; mWakeLock is held when finalizing.");
            this.mWakeLock.release();
        }
    }

    @Override
    public ServiceState getServiceState() {
        if ((this.mSST == null || this.mSST.mSS.getState() != 0) && this.mImsPhone != null) {
            return ServiceState.mergeServiceStates(this.mSST == null ? new ServiceState() : this.mSST.mSS, this.mImsPhone.getServiceState());
        }
        if (this.mSST != null) {
            return this.mSST.mSS;
        }
        return new ServiceState();
    }

    @Override
    public CellLocation getCellLocation(WorkSource workSource) {
        if (this.isPhoneTypeGsm()) {
            return this.mSST.getCellLocation(workSource);
        }
        CdmaCellLocation loc = (CdmaCellLocation)this.mSST.mCellLoc;
        int mode = Settings.Secure.getInt(this.getContext().getContentResolver(), "location_mode", 0);
        if (mode == 0) {
            CdmaCellLocation privateLoc = new CdmaCellLocation();
            privateLoc.setCellLocationData(loc.getBaseStationId(), Integer.MAX_VALUE, Integer.MAX_VALUE, loc.getSystemId(), loc.getNetworkId());
            loc = privateLoc;
        }
        return loc;
    }

    @Override
    public PhoneConstants.State getState() {
        PhoneConstants.State imsState;
        if (this.mImsPhone != null && (imsState = this.mImsPhone.getState()) != PhoneConstants.State.IDLE) {
            return imsState;
        }
        return this.mCT.mState;
    }

    @Override
    public int getPhoneType() {
        if (this.mPrecisePhoneType == 1) {
            return 1;
        }
        return 2;
    }

    @Override
    public ServiceStateTracker getServiceStateTracker() {
        return this.mSST;
    }

    @Override
    public CallTracker getCallTracker() {
        return this.mCT;
    }

    @Override
    public void updateVoiceMail() {
        if (this.isPhoneTypeGsm()) {
            int countVoiceMessages = 0;
            IccRecords r = (IccRecords)this.mIccRecords.get();
            if (r != null) {
                countVoiceMessages = r.getVoiceMessageCount();
            }
            if (countVoiceMessages == -2) {
                countVoiceMessages = this.getStoredVoiceMessageCount();
            }
            this.logd("updateVoiceMail countVoiceMessages = " + countVoiceMessages + " subId " + this.getSubId());
            this.setVoiceMessageCount(countVoiceMessages);
        } else {
            this.setVoiceMessageCount(this.getStoredVoiceMessageCount());
        }
    }

    @Override
    public List<? extends MmiCode> getPendingMmiCodes() {
        return this.mPendingMMIs;
    }

    @Override
    public PhoneConstants.DataState getDataConnectionState(String apnType) {
        PhoneConstants.DataState ret = PhoneConstants.DataState.DISCONNECTED;
        if (this.mSST == null) {
            ret = PhoneConstants.DataState.DISCONNECTED;
        } else if (this.mSST.getCurrentDataConnectionState() != 0 && (this.isPhoneTypeCdma() || this.isPhoneTypeGsm() && !apnType.equals("emergency"))) {
            ret = PhoneConstants.DataState.DISCONNECTED;
        } else {
            switch (this.mDcTracker.getState(apnType)) {
                case RETRYING: 
                case FAILED: 
                case IDLE: {
                    ret = PhoneConstants.DataState.DISCONNECTED;
                    break;
                }
                case CONNECTED: 
                case DISCONNECTING: {
                    if (this.mCT.mState != PhoneConstants.State.IDLE && !this.mSST.isConcurrentVoiceAndDataAllowed()) {
                        ret = PhoneConstants.DataState.SUSPENDED;
                        break;
                    }
                    ret = PhoneConstants.DataState.CONNECTED;
                    break;
                }
                case CONNECTING: 
                case SCANNING: {
                    ret = PhoneConstants.DataState.CONNECTING;
                }
            }
        }
        this.logd("getDataConnectionState apnType=" + apnType + " ret=" + (Object)((Object)ret));
        return ret;
    }

    @Override
    public PhoneInternalInterface.DataActivityState getDataActivityState() {
        PhoneInternalInterface.DataActivityState ret = PhoneInternalInterface.DataActivityState.NONE;
        if (this.mSST.getCurrentDataConnectionState() == 0) {
            switch (this.mDcTracker.getActivity()) {
                case DATAIN: {
                    ret = PhoneInternalInterface.DataActivityState.DATAIN;
                    break;
                }
                case DATAOUT: {
                    ret = PhoneInternalInterface.DataActivityState.DATAOUT;
                    break;
                }
                case DATAINANDOUT: {
                    ret = PhoneInternalInterface.DataActivityState.DATAINANDOUT;
                    break;
                }
                case DORMANT: {
                    ret = PhoneInternalInterface.DataActivityState.DORMANT;
                    break;
                }
                default: {
                    ret = PhoneInternalInterface.DataActivityState.NONE;
                }
            }
        }
        return ret;
    }

    public void notifyPhoneStateChanged() {
        this.mNotifier.notifyPhoneState(this);
    }

    public void notifyPreciseCallStateChanged() {
        super.notifyPreciseCallStateChangedP();
    }

    public void notifyNewRingingConnection(Connection c) {
        super.notifyNewRingingConnectionP(c);
    }

    public void notifyDisconnect(Connection cn) {
        this.mDisconnectRegistrants.notifyResult(cn);
        this.mNotifier.notifyDisconnectCause(cn.getDisconnectCause(), cn.getPreciseDisconnectCause());
    }

    public void notifyUnknownConnection(Connection cn) {
        super.notifyUnknownConnectionP(cn);
    }

    @Override
    public boolean isInEmergencyCall() {
        if (this.isPhoneTypeGsm()) {
            return false;
        }
        return this.mCT.isInEmergencyCall();
    }

    @Override
    protected void setIsInEmergencyCall() {
        if (!this.isPhoneTypeGsm()) {
            this.mCT.setIsInEmergencyCall();
        }
    }

    private void sendEmergencyCallbackModeChange() {
        Intent intent = new Intent("android.intent.action.EMERGENCY_CALLBACK_MODE_CHANGED");
        intent.putExtra("phoneinECMState", this.isInEcm());
        SubscriptionManager.putPhoneIdAndSubIdExtra(intent, this.getPhoneId());
        ActivityManager.broadcastStickyIntent(intent, -1);
        this.logd("sendEmergencyCallbackModeChange");
    }

    @Override
    public void sendEmergencyCallStateChange(boolean callActive) {
        if (this.mBroadcastEmergencyCallStateChanges) {
            Intent intent = new Intent("android.intent.action.EMERGENCY_CALL_STATE_CHANGED");
            intent.putExtra("phoneInEmergencyCall", callActive);
            SubscriptionManager.putPhoneIdAndSubIdExtra(intent, this.getPhoneId());
            ActivityManager.broadcastStickyIntent(intent, -1);
            Rlog.d(LOG_TAG, "sendEmergencyCallStateChange: callActive " + callActive);
        }
    }

    @Override
    public void setBroadcastEmergencyCallStateChanges(boolean broadcast) {
        this.mBroadcastEmergencyCallStateChanges = broadcast;
    }

    public void notifySuppServiceFailed(PhoneInternalInterface.SuppService code) {
        this.mSuppServiceFailedRegistrants.notifyResult((Object)code);
    }

    public void notifyServiceStateChanged(ServiceState ss) {
        super.notifyServiceStateChangedP(ss);
    }

    public void notifyLocationChanged() {
        this.mNotifier.notifyCellLocation(this);
    }

    @Override
    public void notifyCallForwardingIndicator() {
        this.mNotifier.notifyCallForwardingChanged(this);
    }

    @Override
    public void setSystemProperty(String property, String value) {
        if (this.getUnitTestMode()) {
            return;
        }
        if (this.isPhoneTypeGsm() || this.isPhoneTypeCdmaLte()) {
            TelephonyManager.setTelephonyProperty(this.mPhoneId, property, value);
        } else {
            super.setSystemProperty(property, value);
        }
    }

    @Override
    public void registerForSuppServiceNotification(Handler h, int what, Object obj) {
        this.mSsnRegistrants.addUnique(h, what, obj);
        if (this.mSsnRegistrants.size() == 1) {
            this.mCi.setSuppServiceNotifications(true, null);
        }
    }

    @Override
    public void unregisterForSuppServiceNotification(Handler h) {
        this.mSsnRegistrants.remove(h);
        if (this.mSsnRegistrants.size() == 0) {
            this.mCi.setSuppServiceNotifications(false, null);
        }
    }

    @Override
    public void registerForSimRecordsLoaded(Handler h, int what, Object obj) {
        this.mSimRecordsLoadedRegistrants.addUnique(h, what, obj);
    }

    @Override
    public void unregisterForSimRecordsLoaded(Handler h) {
        this.mSimRecordsLoadedRegistrants.remove(h);
    }

    @Override
    public void acceptCall(int videoState) throws CallStateException {
        Phone imsPhone = this.mImsPhone;
        if (imsPhone != null && imsPhone.getRingingCall().isRinging()) {
            imsPhone.acceptCall(videoState);
        } else {
            this.mCT.acceptCall();
        }
    }

    @Override
    public void rejectCall() throws CallStateException {
        this.mCT.rejectCall();
    }

    @Override
    public void switchHoldingAndActive() throws CallStateException {
        this.mCT.switchWaitingOrHoldingAndActive();
    }

    @Override
    public String getIccSerialNumber() {
        IccRecords r = (IccRecords)this.mIccRecords.get();
        if (!this.isPhoneTypeGsm() && r == null) {
            r = this.mUiccController.getIccRecords(this.mPhoneId, 1);
        }
        return r != null ? r.getIccId() : null;
    }

    @Override
    public String getFullIccSerialNumber() {
        IccRecords r = (IccRecords)this.mIccRecords.get();
        if (!this.isPhoneTypeGsm() && r == null) {
            r = this.mUiccController.getIccRecords(this.mPhoneId, 1);
        }
        return r != null ? r.getFullIccId() : null;
    }

    @Override
    public boolean canConference() {
        if (this.mImsPhone != null && this.mImsPhone.canConference()) {
            return true;
        }
        if (this.isPhoneTypeGsm()) {
            return this.mCT.canConference();
        }
        this.loge("canConference: not possible in CDMA");
        return false;
    }

    @Override
    public void conference() {
        if (this.mImsPhone != null && this.mImsPhone.canConference()) {
            this.logd("conference() - delegated to IMS phone");
            try {
                this.mImsPhone.conference();
            }
            catch (CallStateException e) {
                this.loge(e.toString());
            }
            return;
        }
        if (this.isPhoneTypeGsm()) {
            this.mCT.conference();
        } else {
            this.loge("conference: not possible in CDMA");
        }
    }

    @Override
    public void enableEnhancedVoicePrivacy(boolean enable, Message onComplete) {
        if (this.isPhoneTypeGsm()) {
            this.loge("enableEnhancedVoicePrivacy: not expected on GSM");
        } else {
            this.mCi.setPreferredVoicePrivacy(enable, onComplete);
        }
    }

    @Override
    public void getEnhancedVoicePrivacy(Message onComplete) {
        if (this.isPhoneTypeGsm()) {
            this.loge("getEnhancedVoicePrivacy: not expected on GSM");
        } else {
            this.mCi.getPreferredVoicePrivacy(onComplete);
        }
    }

    @Override
    public void clearDisconnected() {
        this.mCT.clearDisconnected();
    }

    @Override
    public boolean canTransfer() {
        if (this.isPhoneTypeGsm()) {
            return this.mCT.canTransfer();
        }
        this.loge("canTransfer: not possible in CDMA");
        return false;
    }

    @Override
    public void explicitCallTransfer() {
        if (this.isPhoneTypeGsm()) {
            this.mCT.explicitCallTransfer();
        } else {
            this.loge("explicitCallTransfer: not possible in CDMA");
        }
    }

    @Override
    public GsmCdmaCall getForegroundCall() {
        return this.mCT.mForegroundCall;
    }

    @Override
    public GsmCdmaCall getBackgroundCall() {
        return this.mCT.mBackgroundCall;
    }

    @Override
    public Call getRingingCall() {
        Phone imsPhone = this.mImsPhone;
        if (imsPhone != null && imsPhone.getRingingCall().isRinging()) {
            return imsPhone.getRingingCall();
        }
        return this.mCT.mRingingCall;
    }

    private boolean handleCallDeflectionIncallSupplementaryService(String dialString) {
        if (dialString.length() > 1) {
            return false;
        }
        if (this.getRingingCall().getState() != Call.State.IDLE) {
            this.logd("MmiCode 0: rejectCall");
            try {
                this.mCT.rejectCall();
            }
            catch (CallStateException e) {
                Rlog.d(LOG_TAG, "reject failed", e);
                this.notifySuppServiceFailed(PhoneInternalInterface.SuppService.REJECT);
            }
        } else if (this.getBackgroundCall().getState() != Call.State.IDLE) {
            this.logd("MmiCode 0: hangupWaitingOrBackground");
            this.mCT.hangupWaitingOrBackground();
        }
        return true;
    }

    private boolean handleCallWaitingIncallSupplementaryService(String dialString) {
        int len = dialString.length();
        if (len > 2) {
            return false;
        }
        GsmCdmaCall call = this.getForegroundCall();
        try {
            if (len > 1) {
                char ch = dialString.charAt(1);
                int callIndex = ch - 48;
                if (callIndex >= 1 && callIndex <= 19) {
                    this.logd("MmiCode 1: hangupConnectionByIndex " + callIndex);
                    this.mCT.hangupConnectionByIndex(call, callIndex);
                }
            } else if (call.getState() != Call.State.IDLE) {
                this.logd("MmiCode 1: hangup foreground");
                this.mCT.hangup(call);
            } else {
                this.logd("MmiCode 1: switchWaitingOrHoldingAndActive");
                this.mCT.switchWaitingOrHoldingAndActive();
            }
        }
        catch (CallStateException e) {
            Rlog.d(LOG_TAG, "hangup failed", e);
            this.notifySuppServiceFailed(PhoneInternalInterface.SuppService.HANGUP);
        }
        return true;
    }

    private boolean handleCallHoldIncallSupplementaryService(String dialString) {
        block10: {
            int len = dialString.length();
            if (len > 2) {
                return false;
            }
            GsmCdmaCall call = this.getForegroundCall();
            if (len > 1) {
                try {
                    char ch = dialString.charAt(1);
                    int callIndex = ch - 48;
                    GsmCdmaConnection conn = this.mCT.getConnectionByIndex(call, callIndex);
                    if (conn != null && callIndex >= 1 && callIndex <= 19) {
                        this.logd("MmiCode 2: separate call " + callIndex);
                        this.mCT.separate(conn);
                        break block10;
                    }
                    this.logd("separate: invalid call index " + callIndex);
                    this.notifySuppServiceFailed(PhoneInternalInterface.SuppService.SEPARATE);
                }
                catch (CallStateException e) {
                    Rlog.d(LOG_TAG, "separate failed", e);
                    this.notifySuppServiceFailed(PhoneInternalInterface.SuppService.SEPARATE);
                }
            } else {
                try {
                    if (this.getRingingCall().getState() != Call.State.IDLE) {
                        this.logd("MmiCode 2: accept ringing call");
                        this.mCT.acceptCall();
                    } else {
                        this.logd("MmiCode 2: switchWaitingOrHoldingAndActive");
                        this.mCT.switchWaitingOrHoldingAndActive();
                    }
                }
                catch (CallStateException e) {
                    Rlog.d(LOG_TAG, "switch failed", e);
                    this.notifySuppServiceFailed(PhoneInternalInterface.SuppService.SWITCH);
                }
            }
        }
        return true;
    }

    private boolean handleMultipartyIncallSupplementaryService(String dialString) {
        if (dialString.length() > 1) {
            return false;
        }
        this.logd("MmiCode 3: merge calls");
        this.conference();
        return true;
    }

    private boolean handleEctIncallSupplementaryService(String dialString) {
        int len = dialString.length();
        if (len != 1) {
            return false;
        }
        this.logd("MmiCode 4: explicit call transfer");
        this.explicitCallTransfer();
        return true;
    }

    private boolean handleCcbsIncallSupplementaryService(String dialString) {
        if (dialString.length() > 1) {
            return false;
        }
        Rlog.i(LOG_TAG, "MmiCode 5: CCBS not supported!");
        this.notifySuppServiceFailed(PhoneInternalInterface.SuppService.UNKNOWN);
        return true;
    }

    @Override
    public boolean handleInCallMmiCommands(String dialString) throws CallStateException {
        if (!this.isPhoneTypeGsm()) {
            this.loge("method handleInCallMmiCommands is NOT supported in CDMA!");
            return false;
        }
        Phone imsPhone = this.mImsPhone;
        if (imsPhone != null && imsPhone.getServiceState().getState() == 0) {
            return imsPhone.handleInCallMmiCommands(dialString);
        }
        if (!this.isInCall()) {
            return false;
        }
        if (TextUtils.isEmpty(dialString)) {
            return false;
        }
        boolean result = false;
        char ch = dialString.charAt(0);
        switch (ch) {
            case '0': {
                result = this.handleCallDeflectionIncallSupplementaryService(dialString);
                break;
            }
            case '1': {
                result = this.handleCallWaitingIncallSupplementaryService(dialString);
                break;
            }
            case '2': {
                result = this.handleCallHoldIncallSupplementaryService(dialString);
                break;
            }
            case '3': {
                result = this.handleMultipartyIncallSupplementaryService(dialString);
                break;
            }
            case '4': {
                result = this.handleEctIncallSupplementaryService(dialString);
                break;
            }
            case '5': {
                result = this.handleCcbsIncallSupplementaryService(dialString);
                break;
            }
        }
        return result;
    }

    public boolean isInCall() {
        Call.State foregroundCallState = this.getForegroundCall().getState();
        Call.State backgroundCallState = this.getBackgroundCall().getState();
        Call.State ringingCallState = this.getRingingCall().getState();
        return foregroundCallState.isAlive() || backgroundCallState.isAlive() || ringingCallState.isAlive();
    }

    @Override
    public Connection dial(String dialString, int videoState) throws CallStateException {
        return this.dial(dialString, null, videoState, null);
    }

    @Override
    public Connection dial(String dialString, UUSInfo uusInfo, int videoState, Bundle intentExtras) throws CallStateException {
        if (!this.isPhoneTypeGsm() && uusInfo != null) {
            throw new CallStateException("Sending UUS information NOT supported in CDMA!");
        }
        boolean isEmergency = PhoneNumberUtils.isEmergencyNumber(this.getSubId(), dialString);
        Phone imsPhone = this.mImsPhone;
        CarrierConfigManager configManager = (CarrierConfigManager)this.mContext.getSystemService("carrier_config");
        boolean alwaysTryImsForEmergencyCarrierConfig = configManager.getConfigForSubId(this.getSubId()).getBoolean("carrier_use_ims_first_for_emergency_bool");
        boolean imsUseEnabled = this.isImsUseEnabled() && imsPhone != null && (imsPhone.isVolteEnabled() || imsPhone.isWifiCallingEnabled() || imsPhone.isVideoEnabled() && VideoProfile.isVideo(videoState)) && imsPhone.getServiceState().getState() == 0;
        boolean useImsForEmergency = imsPhone != null && isEmergency && alwaysTryImsForEmergencyCarrierConfig && ImsManager.isNonTtyOrTtyOnVolteEnabled(this.mContext) && imsPhone.isImsAvailable();
        String dialPart = PhoneNumberUtils.extractNetworkPortionAlt(PhoneNumberUtils.stripSeparators(dialString));
        boolean isUt = (dialPart.startsWith("*") || dialPart.startsWith("#")) && dialPart.endsWith("#");
        boolean useImsForUt = imsPhone != null && imsPhone.isUtEnabled();
        this.logd("imsUseEnabled=" + imsUseEnabled + ", useImsForEmergency=" + useImsForEmergency + ", useImsForUt=" + useImsForUt + ", isUt=" + isUt + ", imsPhone=" + imsPhone + ", imsPhone.isVolteEnabled()=" + (imsPhone != null ? Boolean.valueOf(imsPhone.isVolteEnabled()) : "N/A") + ", imsPhone.isVowifiEnabled()=" + (imsPhone != null ? Boolean.valueOf(imsPhone.isWifiCallingEnabled()) : "N/A") + ", imsPhone.isVideoEnabled()=" + (imsPhone != null ? Boolean.valueOf(imsPhone.isVideoEnabled()) : "N/A") + ", imsPhone.getServiceState().getState()=" + (imsPhone != null ? Integer.valueOf(imsPhone.getServiceState().getState()) : "N/A"));
        Phone.checkWfcWifiOnlyModeBeforeDial(this.mImsPhone, this.mContext);
        if (imsUseEnabled && (!isUt || useImsForUt) || useImsForEmergency) {
            try {
                this.logd("Trying IMS PS call");
                return imsPhone.dial(dialString, uusInfo, videoState, intentExtras);
            }
            catch (CallStateException e) {
                this.logd("IMS PS call exception " + e + "imsUseEnabled =" + imsUseEnabled + ", imsPhone =" + imsPhone);
                if ("cs_fallback".equals(e.getMessage()) || isEmergency) {
                    this.logi("IMS call failed with Exception: " + e.getMessage() + ". Falling back to CS.");
                }
                CallStateException ce = new CallStateException(e.getMessage());
                ce.setStackTrace(e.getStackTrace());
                throw ce;
            }
        }
        if (this.mSST != null && this.mSST.mSS.getState() == 1 && this.mSST.mSS.getDataRegState() != 0 && !isEmergency) {
            throw new CallStateException("cannot dial in current state");
        }
        if (this.mSST != null && this.mSST.mSS.getState() == 3 && !VideoProfile.isVideo(videoState) && !isEmergency) {
            throw new CallStateException(2, "cannot dial voice call in airplane mode");
        }
        if (!(this.mSST == null || this.mSST.mSS.getState() != 1 || this.mSST.mSS.getDataRegState() == 0 && ServiceState.isLte(this.mSST.mSS.getRilDataRadioTechnology()) || VideoProfile.isVideo(videoState) || isEmergency)) {
            throw new CallStateException(1, "cannot dial voice call in out of service");
        }
        this.logd("Trying (non-IMS) CS call");
        if (this.isPhoneTypeGsm()) {
            return this.dialInternal(dialString, null, 0, intentExtras);
        }
        return this.dialInternal(dialString, null, videoState, intentExtras);
    }

    public boolean isNotificationOfWfcCallRequired(String dialString) {
        boolean shouldNotifyInternationalCallOnWfc;
        CarrierConfigManager configManager = (CarrierConfigManager)this.mContext.getSystemService("carrier_config");
        PersistableBundle config = configManager.getConfigForSubId(this.getSubId());
        boolean bl = shouldNotifyInternationalCallOnWfc = config != null && config.getBoolean("notify_international_call_on_wfc_bool");
        if (!shouldNotifyInternationalCallOnWfc) {
            return false;
        }
        Phone imsPhone = this.mImsPhone;
        boolean isEmergency = PhoneNumberUtils.isEmergencyNumber(this.getSubId(), dialString);
        boolean shouldConfirmCall = this.isImsUseEnabled() && imsPhone != null && !imsPhone.isVolteEnabled() && imsPhone.isWifiCallingEnabled() && !isEmergency && PhoneNumberUtils.isInternationalNumber(dialString, this.getCountryIso());
        return shouldConfirmCall;
    }

    @Override
    protected Connection dialInternal(String dialString, UUSInfo uusInfo, int videoState, Bundle intentExtras) throws CallStateException {
        return this.dialInternal(dialString, uusInfo, videoState, intentExtras, null);
    }

    protected Connection dialInternal(String dialString, UUSInfo uusInfo, int videoState, Bundle intentExtras, ResultReceiver wrappedCallback) throws CallStateException {
        String newDialString = PhoneNumberUtils.stripSeparators(dialString);
        if (this.isPhoneTypeGsm()) {
            if (this.handleInCallMmiCommands(newDialString)) {
                return null;
            }
            String networkPortion = PhoneNumberUtils.extractNetworkPortionAlt(newDialString);
            GsmMmiCode mmi = GsmMmiCode.newFromDialString(networkPortion, this, (UiccCardApplication)this.mUiccApplication.get(), wrappedCallback);
            this.logd("dialInternal: dialing w/ mmi '" + mmi + "'...");
            if (mmi == null) {
                return this.mCT.dial(newDialString, uusInfo, intentExtras);
            }
            if (mmi.isTemporaryModeCLIR()) {
                return this.mCT.dial(mmi.mDialingNumber, mmi.getCLIRMode(), uusInfo, intentExtras);
            }
            this.mPendingMMIs.add(mmi);
            this.mMmiRegistrants.notifyRegistrants(new AsyncResult(null, mmi, null));
            mmi.processCode();
            return null;
        }
        return this.mCT.dial(newDialString);
    }

    @Override
    public boolean handlePinMmi(String dialString) {
        Handler mmi = this.isPhoneTypeGsm() ? GsmMmiCode.newFromDialString(dialString, this, (UiccCardApplication)this.mUiccApplication.get()) : CdmaMmiCode.newFromDialString(dialString, this, (UiccCardApplication)this.mUiccApplication.get());
        if (mmi != null && mmi.isPinPukCommand()) {
            this.mPendingMMIs.add((MmiCode)((Object)mmi));
            this.mMmiRegistrants.notifyRegistrants(new AsyncResult(null, mmi, null));
            try {
                mmi.processCode();
            }
            catch (CallStateException callStateException) {
                // empty catch block
            }
            return true;
        }
        this.loge("Mmi is null or unrecognized!");
        return false;
    }

    private void sendUssdResponse(String ussdRequest, CharSequence message, int returnCode, ResultReceiver wrappedCallback) {
        UssdResponse response = new UssdResponse(ussdRequest, message);
        Bundle returnData = new Bundle();
        returnData.putParcelable("USSD_RESPONSE", response);
        wrappedCallback.send(returnCode, returnData);
    }

    @Override
    public boolean handleUssdRequest(String ussdRequest, ResultReceiver wrappedCallback) {
        if (!this.isPhoneTypeGsm() || this.mPendingMMIs.size() > 0) {
            this.sendUssdResponse(ussdRequest, null, -1, wrappedCallback);
            return true;
        }
        Phone imsPhone = this.mImsPhone;
        if (imsPhone != null && (imsPhone.getServiceState().getState() == 0 || imsPhone.isUtEnabled())) {
            try {
                this.logd("handleUssdRequest: attempting over IMS");
                return imsPhone.handleUssdRequest(ussdRequest, wrappedCallback);
            }
            catch (CallStateException cse) {
                if (!"cs_fallback".equals(cse.getMessage())) {
                    return false;
                }
                this.logd("handleUssdRequest: fallback to CS required");
            }
        }
        try {
            this.dialInternal(ussdRequest, null, 0, null, wrappedCallback);
        }
        catch (Exception e) {
            this.logd("handleUssdRequest: exception" + e);
            return false;
        }
        return true;
    }

    @Override
    public void sendUssdResponse(String ussdMessge) {
        if (this.isPhoneTypeGsm()) {
            GsmMmiCode mmi = GsmMmiCode.newFromUssdUserInput(ussdMessge, this, (UiccCardApplication)this.mUiccApplication.get());
            this.mPendingMMIs.add(mmi);
            this.mMmiRegistrants.notifyRegistrants(new AsyncResult(null, mmi, null));
            mmi.sendUssd(ussdMessge);
        } else {
            this.loge("sendUssdResponse: not possible in CDMA");
        }
    }

    @Override
    public void sendDtmf(char c) {
        if (!PhoneNumberUtils.is12Key(c)) {
            this.loge("sendDtmf called with invalid character '" + c + "'");
        } else if (this.mCT.mState == PhoneConstants.State.OFFHOOK) {
            this.mCi.sendDtmf(c, null);
        }
    }

    @Override
    public void startDtmf(char c) {
        if (!PhoneNumberUtils.is12Key(c)) {
            this.loge("startDtmf called with invalid character '" + c + "'");
        } else {
            this.mCi.startDtmf(c, null);
        }
    }

    @Override
    public void stopDtmf() {
        this.mCi.stopDtmf(null);
    }

    @Override
    public void sendBurstDtmf(String dtmfString, int on, int off, Message onComplete) {
        if (this.isPhoneTypeGsm()) {
            this.loge("[GsmCdmaPhone] sendBurstDtmf() is a CDMA method");
        } else {
            boolean check = true;
            for (int itr = 0; itr < dtmfString.length(); ++itr) {
                if (PhoneNumberUtils.is12Key(dtmfString.charAt(itr))) continue;
                Rlog.e(LOG_TAG, "sendDtmf called with invalid character '" + dtmfString.charAt(itr) + "'");
                check = false;
                break;
            }
            if (this.mCT.mState == PhoneConstants.State.OFFHOOK && check) {
                this.mCi.sendBurstDtmf(dtmfString, on, off, onComplete);
            }
        }
    }

    @Override
    public void setRadioPower(boolean power) {
        this.mSST.setRadioPower(power);
    }

    private void storeVoiceMailNumber(String number) {
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(this.getContext());
        SharedPreferences.Editor editor = sp.edit();
        if (this.isPhoneTypeGsm()) {
            editor.putString(VM_NUMBER + this.getPhoneId(), number);
            editor.apply();
            this.setVmSimImsi(this.getSubscriberId());
        } else {
            editor.putString(VM_NUMBER_CDMA + this.getPhoneId(), number);
            editor.apply();
        }
    }

    @Override
    public String getVoiceMailNumber() {
        String defaultVmNumber;
        CarrierConfigManager configManager;
        PersistableBundle b;
        String number = null;
        if (this.isPhoneTypeGsm()) {
            IccRecords r = (IccRecords)this.mIccRecords.get();
            String string2 = number = r != null ? r.getVoiceMailNumber() : "";
            if (TextUtils.isEmpty(number)) {
                SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(this.getContext());
                number = sp.getString(VM_NUMBER + this.getPhoneId(), null);
            }
        } else {
            SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(this.getContext());
            number = sp.getString(VM_NUMBER_CDMA + this.getPhoneId(), null);
        }
        if (TextUtils.isEmpty(number) && (b = (configManager = (CarrierConfigManager)this.getContext().getSystemService("carrier_config")).getConfig()) != null && !TextUtils.isEmpty(defaultVmNumber = b.getString("default_vm_number_string"))) {
            number = defaultVmNumber;
        }
        if (!this.isPhoneTypeGsm() && TextUtils.isEmpty(number)) {
            number = this.getContext().getResources().getBoolean(17957037) ? this.getLine1Number() : "*86";
        }
        return number;
    }

    private String getVmSimImsi() {
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(this.getContext());
        return sp.getString(VM_SIM_IMSI + this.getPhoneId(), null);
    }

    private void setVmSimImsi(String imsi) {
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(this.getContext());
        SharedPreferences.Editor editor = sp.edit();
        editor.putString(VM_SIM_IMSI + this.getPhoneId(), imsi);
        editor.apply();
    }

    @Override
    public String getVoiceMailAlphaTag() {
        String ret = "";
        if (this.isPhoneTypeGsm()) {
            IccRecords r = (IccRecords)this.mIccRecords.get();
            String string2 = ret = r != null ? r.getVoiceMailAlphaTag() : "";
        }
        if (ret == null || ret.length() == 0) {
            return this.mContext.getText(0x1040004).toString();
        }
        return ret;
    }

    @Override
    public String getDeviceId() {
        if (this.isPhoneTypeGsm()) {
            return this.mImei;
        }
        CarrierConfigManager configManager = (CarrierConfigManager)this.mContext.getSystemService("carrier_config");
        boolean force_imei = configManager.getConfigForSubId(this.getSubId()).getBoolean("force_imei_bool");
        if (force_imei) {
            return this.mImei;
        }
        String id2 = this.getMeid();
        if (id2 == null || id2.matches("^0*$")) {
            this.loge("getDeviceId(): MEID is not initialized use ESN");
            id2 = this.getEsn();
        }
        return id2;
    }

    @Override
    public String getDeviceSvn() {
        if (this.isPhoneTypeGsm() || this.isPhoneTypeCdmaLte()) {
            return this.mImeiSv;
        }
        this.loge("getDeviceSvn(): return 0");
        return "0";
    }

    @Override
    public IsimRecords getIsimRecords() {
        return this.mIsimUiccRecords;
    }

    @Override
    public String getImei() {
        return this.mImei;
    }

    @Override
    public String getEsn() {
        if (this.isPhoneTypeGsm()) {
            this.loge("[GsmCdmaPhone] getEsn() is a CDMA method");
            return "0";
        }
        return this.mEsn;
    }

    @Override
    public String getMeid() {
        return this.mMeid;
    }

    @Override
    public String getNai() {
        IccRecords r = this.mUiccController.getIccRecords(this.mPhoneId, 2);
        if (Log.isLoggable(LOG_TAG, 2)) {
            Rlog.v(LOG_TAG, "IccRecords is " + r);
        }
        return r != null ? r.getNAI() : null;
    }

    @Override
    public String getSubscriberId() {
        if (this.isPhoneTypeGsm()) {
            IccRecords r = (IccRecords)this.mIccRecords.get();
            return r != null ? r.getIMSI() : null;
        }
        if (this.isPhoneTypeCdma()) {
            return this.mSST.getImsi();
        }
        return this.mSimRecords != null ? this.mSimRecords.getIMSI() : "";
    }

    @Override
    public ImsiEncryptionInfo getCarrierInfoForImsiEncryption(int keyType) {
        return CarrierInfoManager.getCarrierInfoForImsiEncryption(keyType, this.mContext);
    }

    @Override
    public void setCarrierInfoForImsiEncryption(ImsiEncryptionInfo imsiEncryptionInfo) {
        CarrierInfoManager.setCarrierInfoForImsiEncryption(imsiEncryptionInfo, this.mContext);
    }

    @Override
    public String getGroupIdLevel1() {
        if (this.isPhoneTypeGsm()) {
            IccRecords r = (IccRecords)this.mIccRecords.get();
            return r != null ? r.getGid1() : null;
        }
        if (this.isPhoneTypeCdma()) {
            this.loge("GID1 is not available in CDMA");
            return null;
        }
        return this.mSimRecords != null ? this.mSimRecords.getGid1() : "";
    }

    @Override
    public String getGroupIdLevel2() {
        if (this.isPhoneTypeGsm()) {
            IccRecords r = (IccRecords)this.mIccRecords.get();
            return r != null ? r.getGid2() : null;
        }
        if (this.isPhoneTypeCdma()) {
            this.loge("GID2 is not available in CDMA");
            return null;
        }
        return this.mSimRecords != null ? this.mSimRecords.getGid2() : "";
    }

    @Override
    public String getLine1Number() {
        if (this.isPhoneTypeGsm()) {
            IccRecords r = (IccRecords)this.mIccRecords.get();
            return r != null ? r.getMsisdnNumber() : null;
        }
        return this.mSST.getMdnNumber();
    }

    @Override
    public String getCdmaPrlVersion() {
        return this.mSST.getPrlVersion();
    }

    @Override
    public String getCdmaMin() {
        return this.mSST.getCdmaMin();
    }

    @Override
    public boolean isMinInfoReady() {
        return this.mSST.isMinInfoReady();
    }

    @Override
    public String getMsisdn() {
        if (this.isPhoneTypeGsm()) {
            IccRecords r = (IccRecords)this.mIccRecords.get();
            return r != null ? r.getMsisdnNumber() : null;
        }
        if (this.isPhoneTypeCdmaLte()) {
            return this.mSimRecords != null ? this.mSimRecords.getMsisdnNumber() : null;
        }
        this.loge("getMsisdn: not expected on CDMA");
        return null;
    }

    @Override
    public String getLine1AlphaTag() {
        if (this.isPhoneTypeGsm()) {
            IccRecords r = (IccRecords)this.mIccRecords.get();
            return r != null ? r.getMsisdnAlphaTag() : null;
        }
        this.loge("getLine1AlphaTag: not possible in CDMA");
        return null;
    }

    @Override
    public boolean setLine1Number(String alphaTag, String number, Message onComplete) {
        if (this.isPhoneTypeGsm()) {
            IccRecords r = (IccRecords)this.mIccRecords.get();
            if (r != null) {
                r.setMsisdnNumber(alphaTag, number, onComplete);
                return true;
            }
            return false;
        }
        this.loge("setLine1Number: not possible in CDMA");
        return false;
    }

    @Override
    public void setVoiceMailNumber(String alphaTag, String voiceMailNumber, Message onComplete) {
        this.mVmNumber = voiceMailNumber;
        Message resp = this.obtainMessage(20, 0, 0, onComplete);
        IccRecords r = (IccRecords)this.mIccRecords.get();
        if (r != null) {
            r.setVoiceMailNumber(alphaTag, this.mVmNumber, resp);
        }
    }

    private boolean isValidCommandInterfaceCFReason(int commandInterfaceCFReason) {
        switch (commandInterfaceCFReason) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    @Override
    public String getSystemProperty(String property, String defValue) {
        if (this.isPhoneTypeGsm() || this.isPhoneTypeCdmaLte()) {
            if (this.getUnitTestMode()) {
                return null;
            }
            return TelephonyManager.getTelephonyProperty(this.mPhoneId, property, defValue);
        }
        return super.getSystemProperty(property, defValue);
    }

    private boolean isValidCommandInterfaceCFAction(int commandInterfaceCFAction) {
        switch (commandInterfaceCFAction) {
            case 0: 
            case 1: 
            case 3: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    private boolean isCfEnable(int action) {
        return action == 1 || action == 3;
    }

    @Override
    public void getCallForwardingOption(int commandInterfaceCFReason, Message onComplete) {
        if (this.isPhoneTypeGsm()) {
            Phone imsPhone = this.mImsPhone;
            if (imsPhone != null && (imsPhone.getServiceState().getState() == 0 || imsPhone.isUtEnabled())) {
                imsPhone.getCallForwardingOption(commandInterfaceCFReason, onComplete);
                return;
            }
            if (this.isValidCommandInterfaceCFReason(commandInterfaceCFReason)) {
                this.logd("requesting call forwarding query.");
                Message resp = commandInterfaceCFReason == 0 ? this.obtainMessage(13, onComplete) : onComplete;
                this.mCi.queryCallForwardStatus(commandInterfaceCFReason, 0, null, resp);
            }
        } else {
            this.loge("getCallForwardingOption: not possible in CDMA");
        }
    }

    @Override
    public void setCallForwardingOption(int commandInterfaceCFAction, int commandInterfaceCFReason, String dialingNumber, int timerSeconds, Message onComplete) {
        if (this.isPhoneTypeGsm()) {
            Phone imsPhone = this.mImsPhone;
            if (imsPhone != null && (imsPhone.getServiceState().getState() == 0 || imsPhone.isUtEnabled())) {
                imsPhone.setCallForwardingOption(commandInterfaceCFAction, commandInterfaceCFReason, dialingNumber, timerSeconds, onComplete);
                return;
            }
            if (this.isValidCommandInterfaceCFAction(commandInterfaceCFAction) && this.isValidCommandInterfaceCFReason(commandInterfaceCFReason)) {
                Message resp;
                if (commandInterfaceCFReason == 0) {
                    Cfu cfu = new Cfu(dialingNumber, onComplete);
                    resp = this.obtainMessage(12, this.isCfEnable(commandInterfaceCFAction) ? 1 : 0, 0, cfu);
                } else {
                    resp = onComplete;
                }
                this.mCi.setCallForward(commandInterfaceCFAction, commandInterfaceCFReason, 1, dialingNumber, timerSeconds, resp);
            }
        } else {
            this.loge("setCallForwardingOption: not possible in CDMA");
        }
    }

    @Override
    public void getOutgoingCallerIdDisplay(Message onComplete) {
        if (this.isPhoneTypeGsm()) {
            Phone imsPhone = this.mImsPhone;
            if (imsPhone != null && imsPhone.getServiceState().getState() == 0) {
                imsPhone.getOutgoingCallerIdDisplay(onComplete);
                return;
            }
            this.mCi.getCLIR(onComplete);
        } else {
            this.loge("getOutgoingCallerIdDisplay: not possible in CDMA");
        }
    }

    @Override
    public void setOutgoingCallerIdDisplay(int commandInterfaceCLIRMode, Message onComplete) {
        if (this.isPhoneTypeGsm()) {
            Phone imsPhone = this.mImsPhone;
            if (imsPhone != null && imsPhone.getServiceState().getState() == 0) {
                imsPhone.setOutgoingCallerIdDisplay(commandInterfaceCLIRMode, onComplete);
                return;
            }
            this.mCi.setCLIR(commandInterfaceCLIRMode, this.obtainMessage(18, commandInterfaceCLIRMode, 0, onComplete));
        } else {
            this.loge("setOutgoingCallerIdDisplay: not possible in CDMA");
        }
    }

    @Override
    public void getCallWaiting(Message onComplete) {
        if (this.isPhoneTypeGsm()) {
            Phone imsPhone = this.mImsPhone;
            if (imsPhone != null && (imsPhone.getServiceState().getState() == 0 || imsPhone.isUtEnabled())) {
                imsPhone.getCallWaiting(onComplete);
                return;
            }
            this.mCi.queryCallWaiting(0, onComplete);
        } else {
            this.mCi.queryCallWaiting(1, onComplete);
        }
    }

    @Override
    public void setCallWaiting(boolean enable, Message onComplete) {
        if (this.isPhoneTypeGsm()) {
            Phone imsPhone = this.mImsPhone;
            if (imsPhone != null && (imsPhone.getServiceState().getState() == 0 || imsPhone.isUtEnabled())) {
                imsPhone.setCallWaiting(enable, onComplete);
                return;
            }
            this.mCi.setCallWaiting(enable, 1, onComplete);
        } else {
            this.loge("method setCallWaiting is NOT supported in CDMA!");
        }
    }

    @Override
    public void getAvailableNetworks(Message response) {
        if (this.isPhoneTypeGsm() || this.isPhoneTypeCdmaLte()) {
            this.mCi.getAvailableNetworks(response);
        } else {
            this.loge("getAvailableNetworks: not possible in CDMA");
        }
    }

    @Override
    public void startNetworkScan(NetworkScanRequest nsr, Message response) {
        this.mCi.startNetworkScan(nsr, response);
    }

    @Override
    public void stopNetworkScan(Message response) {
        this.mCi.stopNetworkScan(response);
    }

    @Override
    public void getNeighboringCids(Message response, WorkSource workSource) {
        if (this.isPhoneTypeGsm()) {
            this.mCi.getNeighboringCids(response, workSource);
        } else if (response != null) {
            CommandException ce = new CommandException(CommandException.Error.REQUEST_NOT_SUPPORTED);
            AsyncResult.forMessage((Message)response).exception = ce;
            response.sendToTarget();
        }
    }

    @Override
    public void setTTYMode(int ttyMode, Message onComplete) {
        super.setTTYMode(ttyMode, onComplete);
        if (this.mImsPhone != null) {
            this.mImsPhone.setTTYMode(ttyMode, onComplete);
        }
    }

    @Override
    public void setUiTTYMode(int uiTtyMode, Message onComplete) {
        if (this.mImsPhone != null) {
            this.mImsPhone.setUiTTYMode(uiTtyMode, onComplete);
        }
    }

    @Override
    public void setMute(boolean muted) {
        this.mCT.setMute(muted);
    }

    @Override
    public boolean getMute() {
        return this.mCT.getMute();
    }

    @Override
    public void getDataCallList(Message response) {
        this.mCi.getDataCallList(response);
    }

    @Override
    public void updateServiceLocation() {
        this.mSST.enableSingleLocationUpdate();
    }

    @Override
    public void enableLocationUpdates() {
        this.mSST.enableLocationUpdates();
    }

    @Override
    public void disableLocationUpdates() {
        this.mSST.disableLocationUpdates();
    }

    @Override
    public boolean getDataRoamingEnabled() {
        return this.mDcTracker.getDataRoamingEnabled();
    }

    @Override
    public void setDataRoamingEnabled(boolean enable) {
        this.mDcTracker.setDataRoamingEnabledByUser(enable);
    }

    @Override
    public void registerForCdmaOtaStatusChange(Handler h, int what, Object obj) {
        this.mCi.registerForCdmaOtaProvision(h, what, obj);
    }

    @Override
    public void unregisterForCdmaOtaStatusChange(Handler h) {
        this.mCi.unregisterForCdmaOtaProvision(h);
    }

    @Override
    public void registerForSubscriptionInfoReady(Handler h, int what, Object obj) {
        this.mSST.registerForSubscriptionInfoReady(h, what, obj);
    }

    @Override
    public void unregisterForSubscriptionInfoReady(Handler h) {
        this.mSST.unregisterForSubscriptionInfoReady(h);
    }

    @Override
    public void setOnEcbModeExitResponse(Handler h, int what, Object obj) {
        this.mEcmExitRespRegistrant = new Registrant(h, what, obj);
    }

    @Override
    public void unsetOnEcbModeExitResponse(Handler h) {
        this.mEcmExitRespRegistrant.clear();
    }

    @Override
    public void registerForCallWaiting(Handler h, int what, Object obj) {
        this.mCT.registerForCallWaiting(h, what, obj);
    }

    @Override
    public void unregisterForCallWaiting(Handler h) {
        this.mCT.unregisterForCallWaiting(h);
    }

    @Override
    public boolean getDataEnabled() {
        return this.mDcTracker.getDataEnabled();
    }

    @Override
    public void setDataEnabled(boolean enable) {
        this.mDcTracker.setDataEnabled(enable);
    }

    public void onMMIDone(MmiCode mmi) {
        if (this.mPendingMMIs.remove(mmi) || this.isPhoneTypeGsm() && (mmi.isUssdRequest() || ((GsmMmiCode)mmi).isSsInfo())) {
            ResultReceiver receiverCallback = mmi.getUssdCallbackReceiver();
            if (receiverCallback != null) {
                Rlog.i(LOG_TAG, "onMMIDone: invoking callback: " + mmi);
                int returnCode = mmi.getState() == MmiCode.State.COMPLETE ? 100 : -1;
                this.sendUssdResponse(mmi.getDialString(), mmi.getMessage(), returnCode, receiverCallback);
            } else {
                Rlog.i(LOG_TAG, "onMMIDone: notifying registrants: " + mmi);
                this.mMmiCompleteRegistrants.notifyRegistrants(new AsyncResult(null, mmi, null));
            }
        } else {
            Rlog.i(LOG_TAG, "onMMIDone: invalid response or already handled; ignoring: " + mmi);
        }
    }

    public boolean supports3gppCallForwardingWhileRoaming() {
        CarrierConfigManager configManager = (CarrierConfigManager)this.getContext().getSystemService("carrier_config");
        PersistableBundle b = configManager.getConfig();
        if (b != null) {
            return b.getBoolean("support_3gpp_call_forwarding_while_roaming_bool", true);
        }
        return true;
    }

    private void onNetworkInitiatedUssd(MmiCode mmi) {
        Rlog.v(LOG_TAG, "onNetworkInitiatedUssd: mmi=" + mmi);
        this.mMmiCompleteRegistrants.notifyRegistrants(new AsyncResult(null, mmi, null));
    }

    private void onIncomingUSSD(int ussdMode, String ussdMessage) {
        if (!this.isPhoneTypeGsm()) {
            this.loge("onIncomingUSSD: not expected on GSM");
        }
        boolean isUssdRequest = ussdMode == 1;
        boolean isUssdError = ussdMode != 0 && ussdMode != 1;
        boolean isUssdRelease = ussdMode == 2;
        GsmMmiCode found = null;
        int s = this.mPendingMMIs.size();
        for (int i = 0; i < s; ++i) {
            if (!((GsmMmiCode)this.mPendingMMIs.get(i)).isPendingUSSD()) continue;
            found = (GsmMmiCode)this.mPendingMMIs.get(i);
            break;
        }
        if (found != null) {
            if (isUssdRelease) {
                found.onUssdRelease();
            } else if (isUssdError) {
                found.onUssdFinishedError();
            } else {
                found.onUssdFinished(ussdMessage, isUssdRequest);
            }
        } else if (!isUssdError && ussdMessage != null) {
            GsmMmiCode mmi = GsmMmiCode.newNetworkInitiatedUssd(ussdMessage, isUssdRequest, this, (UiccCardApplication)this.mUiccApplication.get());
            this.onNetworkInitiatedUssd(mmi);
        }
    }

    private void syncClirSetting() {
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(this.getContext());
        int clirSetting = sp.getInt("clir_key" + this.getPhoneId(), -1);
        Rlog.i(LOG_TAG, "syncClirSetting: clir_key" + this.getPhoneId() + "=" + clirSetting);
        if (clirSetting >= 0) {
            this.mCi.setCLIR(clirSetting, null);
        }
    }

    private void handleRadioAvailable() {
        this.mCi.getBasebandVersion(this.obtainMessage(6));
        this.mCi.getDeviceIdentity(this.obtainMessage(21));
        this.mCi.getRadioCapability(this.obtainMessage(35));
        this.startLceAfterRadioIsAvailable();
    }

    private void handleRadioOn() {
        this.mCi.getVoiceRadioTechnology(this.obtainMessage(40));
        if (!this.isPhoneTypeGsm()) {
            this.mCdmaSubscriptionSource = this.mCdmaSSM.getCdmaSubscriptionSource();
        }
        this.setPreferredNetworkTypeIfSimLoaded();
    }

    private void handleRadioOffOrNotAvailable() {
        if (this.isPhoneTypeGsm()) {
            for (int i = this.mPendingMMIs.size() - 1; i >= 0; --i) {
                if (!((GsmMmiCode)this.mPendingMMIs.get(i)).isPendingUSSD()) continue;
                ((GsmMmiCode)this.mPendingMMIs.get(i)).onUssdFinishedError();
            }
        }
        this.mRadioOffOrNotAvailableRegistrants.notifyRegistrants();
    }

    @Override
    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 1: {
                this.handleRadioAvailable();
                break;
            }
            case 21: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception != null) break;
                String[] respId = (String[])ar.result;
                this.mImei = respId[0];
                this.mImeiSv = respId[1];
                this.mEsn = respId[2];
                this.mMeid = respId[3];
                break;
            }
            case 25: {
                this.handleEnterEmergencyCallbackMode(msg);
                break;
            }
            case 26: {
                this.handleExitEmergencyCallbackMode(msg);
                break;
            }
            case 45: {
                this.logd("Event EVENT_MODEM_RESET Received isInEcm = " + this.isInEcm() + " isPhoneTypeGsm = " + this.isPhoneTypeGsm() + " mImsPhone = " + this.mImsPhone);
                if (!this.isInEcm()) break;
                if (this.isPhoneTypeGsm()) {
                    if (this.mImsPhone == null) break;
                    this.mImsPhone.handleExitEmergencyCallbackMode();
                    break;
                }
                this.handleExitEmergencyCallbackMode(msg);
                break;
            }
            case 22: {
                this.logd("Event EVENT_RUIM_RECORDS_LOADED Received");
                this.updateCurrentCarrierInProvider();
                break;
            }
            case 5: {
                this.logd("Event EVENT_RADIO_ON Received");
                this.handleRadioOn();
                break;
            }
            case 41: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception == null && ar.result != null) {
                    this.mRilVersion = (Integer)ar.result;
                    break;
                }
                this.logd("Unexpected exception on EVENT_RIL_CONNECTED");
                this.mRilVersion = -1;
                break;
            }
            case 39: 
            case 40: {
                String what = msg.what == 39 ? "EVENT_VOICE_RADIO_TECH_CHANGED" : "EVENT_REQUEST_VOICE_RADIO_TECH_DONE";
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception == null) {
                    if (ar.result != null && ((int[])ar.result).length != 0) {
                        int newVoiceTech = ((int[])ar.result)[0];
                        this.logd(what + ": newVoiceTech=" + newVoiceTech);
                        this.phoneObjectUpdater(newVoiceTech);
                        break;
                    }
                    this.loge(what + ": has no tech!");
                    break;
                }
                this.loge(what + ": exception=" + ar.exception);
                break;
            }
            case 42: {
                this.phoneObjectUpdater(msg.arg1);
                break;
            }
            case 43: {
                if (!this.mContext.getResources().getBoolean(17957035)) {
                    this.mCi.getVoiceRadioTechnology(this.obtainMessage(40));
                }
                ImsManager.updateImsServiceConfig(this.mContext, this.mPhoneId, true);
                CarrierConfigManager configMgr = (CarrierConfigManager)this.getContext().getSystemService("carrier_config");
                PersistableBundle b = configMgr.getConfigForSubId(this.getSubId());
                if (b != null) {
                    boolean broadcastEmergencyCallStateChanges = b.getBoolean("broadcast_emergency_call_state_changes_bool");
                    this.logd("broadcastEmergencyCallStateChanges = " + broadcastEmergencyCallStateChanges);
                    this.setBroadcastEmergencyCallStateChanges(broadcastEmergencyCallStateChanges);
                } else {
                    this.loge("didn't get broadcastEmergencyCallStateChanges from carrier config");
                }
                if (b != null) {
                    int config_cdma_roaming_mode = b.getInt("cdma_roaming_mode_int");
                    int current_cdma_roaming_mode = Settings.Global.getInt(this.getContext().getContentResolver(), "roaming_settings", -1);
                    switch (config_cdma_roaming_mode) {
                        case 0: 
                        case 1: 
                        case 2: {
                            this.logd("cdma_roaming_mode is going to changed to " + config_cdma_roaming_mode);
                            this.setCdmaRoamingPreference(config_cdma_roaming_mode, this.obtainMessage(44));
                            break;
                        }
                        case -1: {
                            if (current_cdma_roaming_mode != config_cdma_roaming_mode) {
                                this.logd("cdma_roaming_mode is going to changed to " + current_cdma_roaming_mode);
                                this.setCdmaRoamingPreference(current_cdma_roaming_mode, this.obtainMessage(44));
                            }
                        }
                        default: {
                            this.loge("Invalid cdma_roaming_mode settings: " + config_cdma_roaming_mode);
                            break;
                        }
                    }
                } else {
                    this.loge("didn't get the cdma_roaming_mode changes from the carrier config.");
                }
                this.prepareEri();
                if (this.isPhoneTypeGsm()) break;
                this.mSST.pollState();
                break;
            }
            case 44: {
                this.logd("cdma_roaming_mode change is done");
                break;
            }
            case 27: {
                this.logd("EVENT_CDMA_SUBSCRIPTION_SOURCE_CHANGED");
                this.mCdmaSubscriptionSource = this.mCdmaSSM.getCdmaSubscriptionSource();
                break;
            }
            case 19: {
                this.logd("Event EVENT_REGISTERED_TO_NETWORK Received");
                if (!this.isPhoneTypeGsm()) break;
                this.syncClirSetting();
                break;
            }
            case 3: {
                this.updateCurrentCarrierInProvider();
                String imsi = this.getVmSimImsi();
                String imsiFromSIM = this.getSubscriberId();
                if (!(this.isPhoneTypeGsm() && imsi == null || imsiFromSIM == null || imsiFromSIM.equals(imsi))) {
                    this.storeVoiceMailNumber(null);
                    this.setVmSimImsi(null);
                }
                this.mSimRecordsLoadedRegistrants.notifyRegistrants();
                break;
            }
            case 6: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception != null) break;
                this.logd("Baseband version: " + ar.result);
                TelephonyManager.from(this.mContext).setBasebandVersionForPhone(this.getPhoneId(), (String)ar.result);
                break;
            }
            case 9: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception != null) break;
                this.mImei = (String)ar.result;
                break;
            }
            case 10: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception != null) break;
                this.mImeiSv = (String)ar.result;
                break;
            }
            case 7: {
                AsyncResult ar = (AsyncResult)msg.obj;
                String[] ussdResult = (String[])ar.result;
                if (ussdResult.length <= 1) break;
                try {
                    this.onIncomingUSSD(Integer.parseInt(ussdResult[0]), ussdResult[1]);
                }
                catch (NumberFormatException e) {
                    Rlog.w(LOG_TAG, "error parsing USSD");
                }
                break;
            }
            case 8: {
                this.logd("Event EVENT_RADIO_OFF_OR_NOT_AVAILABLE Received");
                this.handleRadioOffOrNotAvailable();
                break;
            }
            case 2: {
                this.logd("Event EVENT_SSN Received");
                if (!this.isPhoneTypeGsm()) break;
                AsyncResult ar = (AsyncResult)msg.obj;
                SuppServiceNotification not = (SuppServiceNotification)ar.result;
                this.mSsnRegistrants.notifyRegistrants(ar);
                break;
            }
            case 12: {
                AsyncResult ar = (AsyncResult)msg.obj;
                IccRecords r = (IccRecords)this.mIccRecords.get();
                Cfu cfu = (Cfu)ar.userObj;
                if (ar.exception == null && r != null) {
                    this.setVoiceCallForwardingFlag(1, msg.arg1 == 1, cfu.mSetCfNumber);
                }
                if (cfu.mOnComplete == null) break;
                AsyncResult.forMessage(cfu.mOnComplete, ar.result, ar.exception);
                cfu.mOnComplete.sendToTarget();
                break;
            }
            case 20: {
                Message onComplete;
                AsyncResult ar = (AsyncResult)msg.obj;
                if (this.isPhoneTypeGsm() && IccVmNotSupportedException.class.isInstance(ar.exception) || !this.isPhoneTypeGsm() && IccException.class.isInstance(ar.exception)) {
                    this.storeVoiceMailNumber(this.mVmNumber);
                    ar.exception = null;
                }
                if ((onComplete = (Message)ar.userObj) == null) break;
                AsyncResult.forMessage(onComplete, ar.result, ar.exception);
                onComplete.sendToTarget();
                break;
            }
            case 13: {
                Message onComplete;
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception == null) {
                    this.handleCfuQueryResult((CallForwardInfo[])ar.result);
                }
                if ((onComplete = (Message)ar.userObj) == null) break;
                AsyncResult.forMessage(onComplete, ar.result, ar.exception);
                onComplete.sendToTarget();
                break;
            }
            case 28: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (this.mSST.mSS.getIsManualSelection()) {
                    this.setNetworkSelectionModeAutomatic((Message)ar.result);
                    this.logd("SET_NETWORK_SELECTION_AUTOMATIC: set to automatic");
                    break;
                }
                this.logd("SET_NETWORK_SELECTION_AUTOMATIC: already automatic, ignore");
                break;
            }
            case 29: {
                AsyncResult ar = (AsyncResult)msg.obj;
                this.processIccRecordEvents((Integer)ar.result);
                break;
            }
            case 18: {
                Message onComplete;
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception == null) {
                    this.saveClirSetting(msg.arg1);
                }
                if ((onComplete = (Message)ar.userObj) == null) break;
                AsyncResult.forMessage(onComplete, ar.result, ar.exception);
                onComplete.sendToTarget();
                break;
            }
            case 36: {
                AsyncResult ar = (AsyncResult)msg.obj;
                this.logd("Event EVENT_SS received");
                if (!this.isPhoneTypeGsm()) break;
                GsmMmiCode mmi = new GsmMmiCode(this, (UiccCardApplication)this.mUiccApplication.get());
                mmi.processSsData(ar);
                break;
            }
            case 35: {
                AsyncResult ar = (AsyncResult)msg.obj;
                RadioCapability rc = (RadioCapability)ar.result;
                if (ar.exception != null) {
                    Rlog.d(LOG_TAG, "get phone radio capability fail, no need to change mRadioCapability");
                } else {
                    this.radioCapabilityUpdated(rc);
                }
                Rlog.d(LOG_TAG, "EVENT_GET_RADIO_CAPABILITY: phone rc: " + rc);
                break;
            }
            default: {
                super.handleMessage(msg);
            }
        }
    }

    public UiccCardApplication getUiccCardApplication() {
        if (this.isPhoneTypeGsm()) {
            return this.mUiccController.getUiccCardApplication(this.mPhoneId, 1);
        }
        return this.mUiccController.getUiccCardApplication(this.mPhoneId, 2);
    }

    @Override
    protected void onUpdateIccAvailability() {
        UiccCardApplication app;
        if (this.mUiccController == null) {
            return;
        }
        UiccCardApplication newUiccApplication = null;
        if (this.isPhoneTypeGsm() || this.isPhoneTypeCdmaLte()) {
            newUiccApplication = this.mUiccController.getUiccCardApplication(this.mPhoneId, 3);
            IsimUiccRecords newIsimUiccRecords = null;
            if (newUiccApplication != null) {
                newIsimUiccRecords = (IsimUiccRecords)newUiccApplication.getIccRecords();
                this.logd("New ISIM application found");
            }
            this.mIsimUiccRecords = newIsimUiccRecords;
        }
        if (this.mSimRecords != null) {
            this.mSimRecords.unregisterForRecordsLoaded(this);
        }
        if (this.isPhoneTypeCdmaLte()) {
            newUiccApplication = this.mUiccController.getUiccCardApplication(this.mPhoneId, 1);
            SIMRecords newSimRecords = null;
            if (newUiccApplication != null) {
                newSimRecords = (SIMRecords)newUiccApplication.getIccRecords();
            }
            this.mSimRecords = newSimRecords;
            if (this.mSimRecords != null) {
                this.mSimRecords.registerForRecordsLoaded(this, 3, null);
            }
        } else {
            this.mSimRecords = null;
        }
        newUiccApplication = this.getUiccCardApplication();
        if (!this.isPhoneTypeGsm() && newUiccApplication == null) {
            this.logd("can't find 3GPP2 application; trying APP_FAM_3GPP");
            newUiccApplication = this.mUiccController.getUiccCardApplication(this.mPhoneId, 1);
        }
        if ((app = (UiccCardApplication)this.mUiccApplication.get()) != newUiccApplication) {
            if (app != null) {
                this.logd("Removing stale icc objects.");
                if (this.mIccRecords.get() != null) {
                    this.unregisterForIccRecordEvents();
                    this.mIccPhoneBookIntManager.updateIccRecords(null);
                }
                this.mIccRecords.set(null);
                this.mUiccApplication.set(null);
            }
            if (newUiccApplication != null) {
                this.logd("New Uicc application found. type = " + (Object)((Object)newUiccApplication.getType()));
                this.mUiccApplication.set(newUiccApplication);
                this.mIccRecords.set(newUiccApplication.getIccRecords());
                this.registerForIccRecordEvents();
                this.mIccPhoneBookIntManager.updateIccRecords((IccRecords)this.mIccRecords.get());
            }
        }
    }

    private void processIccRecordEvents(int eventCode) {
        switch (eventCode) {
            case 1: {
                this.logi("processIccRecordEvents: EVENT_CFI");
                this.notifyCallForwardingIndicator();
            }
        }
    }

    @Override
    public boolean updateCurrentCarrierInProvider() {
        if (this.isPhoneTypeGsm() || this.isPhoneTypeCdmaLte()) {
            long currentDds = SubscriptionManager.getDefaultDataSubscriptionId();
            String operatorNumeric = this.getOperatorNumeric();
            this.logd("updateCurrentCarrierInProvider: mSubId = " + this.getSubId() + " currentDds = " + currentDds + " operatorNumeric = " + operatorNumeric);
            if (!TextUtils.isEmpty(operatorNumeric) && (long)this.getSubId() == currentDds) {
                try {
                    Uri uri = Uri.withAppendedPath(Telephony.Carriers.CONTENT_URI, "current");
                    ContentValues map = new ContentValues();
                    map.put("numeric", operatorNumeric);
                    this.mContext.getContentResolver().insert(uri, map);
                    return true;
                }
                catch (SQLException e) {
                    Rlog.e(LOG_TAG, "Can't store current operator", e);
                }
            }
            return false;
        }
        return true;
    }

    private boolean updateCurrentCarrierInProvider(String operatorNumeric) {
        if (this.isPhoneTypeCdma() || this.isPhoneTypeCdmaLte() && this.mUiccController.getUiccCardApplication(this.mPhoneId, 1) == null) {
            this.logd("CDMAPhone: updateCurrentCarrierInProvider called");
            if (!TextUtils.isEmpty(operatorNumeric)) {
                try {
                    Uri uri = Uri.withAppendedPath(Telephony.Carriers.CONTENT_URI, "current");
                    ContentValues map = new ContentValues();
                    map.put("numeric", operatorNumeric);
                    this.logd("updateCurrentCarrierInProvider from system: numeric=" + operatorNumeric);
                    this.getContext().getContentResolver().insert(uri, map);
                    this.logd("update mccmnc=" + operatorNumeric);
                    MccTable.updateMccMncConfiguration(this.mContext, operatorNumeric, false);
                    return true;
                }
                catch (SQLException e) {
                    Rlog.e(LOG_TAG, "Can't store current operator", e);
                }
            }
            return false;
        }
        this.logd("updateCurrentCarrierInProvider not updated X retVal=true");
        return true;
    }

    private void handleCfuQueryResult(CallForwardInfo[] infos) {
        IccRecords r = (IccRecords)this.mIccRecords.get();
        if (r != null) {
            if (infos == null || infos.length == 0) {
                this.setVoiceCallForwardingFlag(1, false, null);
            } else {
                int s = infos.length;
                for (int i = 0; i < s; ++i) {
                    if ((infos[i].serviceClass & 1) == 0) continue;
                    this.setVoiceCallForwardingFlag(1, infos[i].status == 1, infos[i].number);
                    break;
                }
            }
        }
    }

    @Override
    public IccPhoneBookInterfaceManager getIccPhoneBookInterfaceManager() {
        return this.mIccPhoneBookIntManager;
    }

    public void registerForEriFileLoaded(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.mEriFileLoadedRegistrants.add(r);
    }

    public void unregisterForEriFileLoaded(Handler h) {
        this.mEriFileLoadedRegistrants.remove(h);
    }

    public void prepareEri() {
        if (this.mEriManager == null) {
            Rlog.e(LOG_TAG, "PrepareEri: Trying to access stale objects");
            return;
        }
        this.mEriManager.loadEriFile();
        if (this.mEriManager.isEriFileLoaded()) {
            this.logd("ERI read, notify registrants");
            this.mEriFileLoadedRegistrants.notifyRegistrants();
        }
    }

    public boolean isEriFileLoaded() {
        return this.mEriManager.isEriFileLoaded();
    }

    @Override
    public void activateCellBroadcastSms(int activate, Message response) {
        this.loge("[GsmCdmaPhone] activateCellBroadcastSms() is obsolete; use SmsManager");
        response.sendToTarget();
    }

    @Override
    public void getCellBroadcastSmsConfig(Message response) {
        this.loge("[GsmCdmaPhone] getCellBroadcastSmsConfig() is obsolete; use SmsManager");
        response.sendToTarget();
    }

    @Override
    public void setCellBroadcastSmsConfig(int[] configValuesArray, Message response) {
        this.loge("[GsmCdmaPhone] setCellBroadcastSmsConfig() is obsolete; use SmsManager");
        response.sendToTarget();
    }

    @Override
    public boolean needsOtaServiceProvisioning() {
        if (this.isPhoneTypeGsm()) {
            return false;
        }
        return this.mSST.getOtasp() != 3;
    }

    @Override
    public boolean isCspPlmnEnabled() {
        IccRecords r = (IccRecords)this.mIccRecords.get();
        return r != null ? r.isCspPlmnEnabled() : false;
    }

    public boolean shouldForceAutoNetworkSelect() {
        int nwMode = Phone.PREFERRED_NT_MODE;
        int subId = this.getSubId();
        if (!SubscriptionManager.isValidSubscriptionId(subId)) {
            return false;
        }
        nwMode = Settings.Global.getInt(this.mContext.getContentResolver(), "preferred_network_mode" + subId, nwMode);
        this.logd("shouldForceAutoNetworkSelect in mode = " + nwMode);
        if (this.isManualSelProhibitedInGlobalMode() && (nwMode == 10 || nwMode == 7)) {
            this.logd("Should force auto network select mode = " + nwMode);
            return true;
        }
        this.logd("Should not force auto network select mode = " + nwMode);
        return false;
    }

    private boolean isManualSelProhibitedInGlobalMode() {
        String[] configArray;
        boolean isProhibited = false;
        String configString = this.getContext().getResources().getString(17040643);
        if (!TextUtils.isEmpty(configString) && (configArray = configString.split(";")) != null && (configArray.length == 1 && configArray[0].equalsIgnoreCase("true") || configArray.length == 2 && !TextUtils.isEmpty(configArray[1]) && configArray[0].equalsIgnoreCase("true") && this.isMatchGid(configArray[1]))) {
            isProhibited = true;
        }
        this.logd("isManualNetSelAllowedInGlobal in current carrier is " + isProhibited);
        return isProhibited;
    }

    private void registerForIccRecordEvents() {
        IccRecords r = (IccRecords)this.mIccRecords.get();
        if (r == null) {
            return;
        }
        if (this.isPhoneTypeGsm()) {
            r.registerForNetworkSelectionModeAutomatic(this, 28, null);
            r.registerForRecordsEvents(this, 29, null);
            r.registerForRecordsLoaded(this, 3, null);
        } else {
            r.registerForRecordsLoaded(this, 22, null);
            if (this.isPhoneTypeCdmaLte()) {
                r.registerForRecordsLoaded(this, 3, null);
            }
        }
    }

    private void unregisterForIccRecordEvents() {
        IccRecords r = (IccRecords)this.mIccRecords.get();
        if (r == null) {
            return;
        }
        r.unregisterForNetworkSelectionModeAutomatic(this);
        r.unregisterForRecordsEvents(this);
        r.unregisterForRecordsLoaded(this);
    }

    @Override
    public void exitEmergencyCallbackMode() {
        Rlog.d(LOG_TAG, "exitEmergencyCallbackMode: mImsPhone=" + this.mImsPhone + " isPhoneTypeGsm=" + this.isPhoneTypeGsm());
        if (this.isPhoneTypeGsm()) {
            if (this.mImsPhone != null) {
                this.mImsPhone.exitEmergencyCallbackMode();
            }
        } else {
            if (this.mWakeLock.isHeld()) {
                this.mWakeLock.release();
            }
            this.mCi.exitEmergencyCallbackMode(this.obtainMessage(26));
        }
    }

    private void handleEnterEmergencyCallbackMode(Message msg) {
        Rlog.d(LOG_TAG, "handleEnterEmergencyCallbackMode, isInEcm()=" + this.isInEcm());
        if (!this.isInEcm()) {
            this.setIsInEcm(true);
            this.sendEmergencyCallbackModeChange();
            long delayInMillis = SystemProperties.getLong("ro.cdma.ecmexittimer", 300000L);
            this.postDelayed(this.mExitEcmRunnable, delayInMillis);
            this.mWakeLock.acquire();
        }
    }

    private void handleExitEmergencyCallbackMode(Message msg) {
        AsyncResult ar = (AsyncResult)msg.obj;
        Rlog.d(LOG_TAG, "handleExitEmergencyCallbackMode,ar.exception , isInEcm=" + ar.exception + this.isInEcm());
        this.removeCallbacks(this.mExitEcmRunnable);
        if (this.mEcmExitRespRegistrant != null) {
            this.mEcmExitRespRegistrant.notifyRegistrant(ar);
        }
        if (ar.exception == null) {
            if (this.isInEcm()) {
                this.setIsInEcm(false);
            }
            if (this.mWakeLock.isHeld()) {
                this.mWakeLock.release();
            }
            this.sendEmergencyCallbackModeChange();
            this.mDcTracker.setInternalDataEnabled(true);
            this.notifyEmergencyCallRegistrants(false);
        }
    }

    public void notifyEmergencyCallRegistrants(boolean started) {
        this.mEmergencyCallToggledRegistrants.notifyResult(started ? 1 : 0);
    }

    public void handleTimerInEmergencyCallbackMode(int action) {
        switch (action) {
            case 1: {
                this.removeCallbacks(this.mExitEcmRunnable);
                this.mEcmTimerResetRegistrants.notifyResult(Boolean.TRUE);
                break;
            }
            case 0: {
                long delayInMillis = SystemProperties.getLong("ro.cdma.ecmexittimer", 300000L);
                this.postDelayed(this.mExitEcmRunnable, delayInMillis);
                this.mEcmTimerResetRegistrants.notifyResult(Boolean.FALSE);
                break;
            }
            default: {
                Rlog.e(LOG_TAG, "handleTimerInEmergencyCallbackMode, unsupported action " + action);
            }
        }
    }

    private static boolean isIs683OtaSpDialStr(String dialStr) {
        boolean isOtaspDialString = false;
        int dialStrLen = dialStr.length();
        if (dialStrLen == 4) {
            if (dialStr.equals(IS683A_FEATURE_CODE)) {
                isOtaspDialString = true;
            }
        } else {
            int sysSelCodeInt = GsmCdmaPhone.extractSelCodeFromOtaSpNum(dialStr);
            switch (sysSelCodeInt) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    isOtaspDialString = true;
                    break;
                }
            }
        }
        return isOtaspDialString;
    }

    private static int extractSelCodeFromOtaSpNum(String dialStr) {
        int dialStrLen = dialStr.length();
        int sysSelCodeInt = -1;
        if (dialStr.regionMatches(0, IS683A_FEATURE_CODE, 0, 4) && dialStrLen >= 6) {
            sysSelCodeInt = Integer.parseInt(dialStr.substring(4, 6));
        }
        Rlog.d(LOG_TAG, "extractSelCodeFromOtaSpNum " + sysSelCodeInt);
        return sysSelCodeInt;
    }

    private static boolean checkOtaSpNumBasedOnSysSelCode(int sysSelCodeInt, String[] sch) {
        boolean isOtaSpNum = false;
        try {
            int selRc = Integer.parseInt(sch[1]);
            for (int i = 0; i < selRc; ++i) {
                if (TextUtils.isEmpty(sch[i + 2]) || TextUtils.isEmpty(sch[i + 3])) continue;
                int selMin = Integer.parseInt(sch[i + 2]);
                int selMax = Integer.parseInt(sch[i + 3]);
                if (sysSelCodeInt < selMin || sysSelCodeInt > selMax) continue;
                isOtaSpNum = true;
                break;
            }
        }
        catch (NumberFormatException ex) {
            Rlog.e(LOG_TAG, "checkOtaSpNumBasedOnSysSelCode, error", ex);
        }
        return isOtaSpNum;
    }

    private boolean isCarrierOtaSpNum(String dialStr) {
        boolean isOtaSpNum = false;
        int sysSelCodeInt = GsmCdmaPhone.extractSelCodeFromOtaSpNum(dialStr);
        if (sysSelCodeInt == -1) {
            return isOtaSpNum;
        }
        if (!TextUtils.isEmpty(this.mCarrierOtaSpNumSchema)) {
            Matcher m = pOtaSpNumSchema.matcher(this.mCarrierOtaSpNumSchema);
            Rlog.d(LOG_TAG, "isCarrierOtaSpNum,schema" + this.mCarrierOtaSpNumSchema);
            if (m.find()) {
                String[] sch = pOtaSpNumSchema.split(this.mCarrierOtaSpNumSchema);
                if (!TextUtils.isEmpty(sch[0]) && sch[0].equals("SELC")) {
                    if (sysSelCodeInt != -1) {
                        isOtaSpNum = GsmCdmaPhone.checkOtaSpNumBasedOnSysSelCode(sysSelCodeInt, sch);
                    } else {
                        Rlog.d(LOG_TAG, "isCarrierOtaSpNum,sysSelCodeInt is invalid");
                    }
                } else if (!TextUtils.isEmpty(sch[0]) && sch[0].equals("FC")) {
                    String fc = sch[2];
                    int fcLen = Integer.parseInt(sch[1]);
                    if (dialStr.regionMatches(0, fc, 0, fcLen)) {
                        isOtaSpNum = true;
                    } else {
                        Rlog.d(LOG_TAG, "isCarrierOtaSpNum,not otasp number");
                    }
                } else {
                    Rlog.d(LOG_TAG, "isCarrierOtaSpNum,ota schema not supported" + sch[0]);
                }
            } else {
                Rlog.d(LOG_TAG, "isCarrierOtaSpNum,ota schema pattern not right" + this.mCarrierOtaSpNumSchema);
            }
        } else {
            Rlog.d(LOG_TAG, "isCarrierOtaSpNum,ota schema pattern empty");
        }
        return isOtaSpNum;
    }

    @Override
    public boolean isOtaSpNumber(String dialStr) {
        if (this.isPhoneTypeGsm()) {
            return super.isOtaSpNumber(dialStr);
        }
        boolean isOtaSpNum = false;
        String dialableStr = PhoneNumberUtils.extractNetworkPortionAlt(dialStr);
        if (dialableStr != null && !(isOtaSpNum = GsmCdmaPhone.isIs683OtaSpDialStr(dialableStr))) {
            isOtaSpNum = this.isCarrierOtaSpNum(dialableStr);
        }
        Rlog.d(LOG_TAG, "isOtaSpNumber " + isOtaSpNum);
        return isOtaSpNum;
    }

    @Override
    public int getCdmaEriIconIndex() {
        if (this.isPhoneTypeGsm()) {
            return super.getCdmaEriIconIndex();
        }
        return this.getServiceState().getCdmaEriIconIndex();
    }

    @Override
    public int getCdmaEriIconMode() {
        if (this.isPhoneTypeGsm()) {
            return super.getCdmaEriIconMode();
        }
        return this.getServiceState().getCdmaEriIconMode();
    }

    @Override
    public String getCdmaEriText() {
        if (this.isPhoneTypeGsm()) {
            return super.getCdmaEriText();
        }
        int roamInd = this.getServiceState().getCdmaRoamingIndicator();
        int defRoamInd = this.getServiceState().getCdmaDefaultRoamingIndicator();
        return this.mEriManager.getCdmaEriText(roamInd, defRoamInd);
    }

    private void phoneObjectUpdater(int newVoiceRadioTech) {
        this.logd("phoneObjectUpdater: newVoiceRadioTech=" + newVoiceRadioTech);
        if (ServiceState.isLte(newVoiceRadioTech) || newVoiceRadioTech == 0) {
            CarrierConfigManager configMgr = (CarrierConfigManager)this.getContext().getSystemService("carrier_config");
            PersistableBundle b = configMgr.getConfigForSubId(this.getSubId());
            if (b != null) {
                int volteReplacementRat = b.getInt("volte_replacement_rat_int");
                this.logd("phoneObjectUpdater: volteReplacementRat=" + volteReplacementRat);
                if (volteReplacementRat != 0) {
                    newVoiceRadioTech = volteReplacementRat;
                }
            } else {
                this.loge("phoneObjectUpdater: didn't get volteReplacementRat from carrier config");
            }
        }
        if (this.mRilVersion == 6 && this.getLteOnCdmaMode() == 1) {
            if (this.getPhoneType() == 2) {
                this.logd("phoneObjectUpdater: LTE ON CDMA property is set. Use CDMA Phone newVoiceRadioTech=" + newVoiceRadioTech + " mActivePhone=" + this.getPhoneName());
                return;
            }
            this.logd("phoneObjectUpdater: LTE ON CDMA property is set. Switch to CDMALTEPhone newVoiceRadioTech=" + newVoiceRadioTech + " mActivePhone=" + this.getPhoneName());
            newVoiceRadioTech = 6;
        } else {
            if (this.isShuttingDown()) {
                this.logd("Device is shutting down. No need to switch phone now.");
                return;
            }
            boolean matchCdma = ServiceState.isCdma(newVoiceRadioTech);
            boolean matchGsm = ServiceState.isGsm(newVoiceRadioTech);
            if (matchCdma && this.getPhoneType() == 2 || matchGsm && this.getPhoneType() == 1) {
                this.logd("phoneObjectUpdater: No change ignore, newVoiceRadioTech=" + newVoiceRadioTech + " mActivePhone=" + this.getPhoneName());
                return;
            }
            if (!matchCdma && !matchGsm) {
                this.loge("phoneObjectUpdater: newVoiceRadioTech=" + newVoiceRadioTech + " doesn't match either CDMA or GSM - error! No phone change");
                return;
            }
        }
        if (newVoiceRadioTech == 0) {
            this.logd("phoneObjectUpdater: Unknown rat ignore,  newVoiceRadioTech=Unknown. mActivePhone=" + this.getPhoneName());
            return;
        }
        boolean oldPowerState = false;
        if (this.mResetModemOnRadioTechnologyChange && this.mCi.getRadioState().isOn()) {
            oldPowerState = true;
            this.logd("phoneObjectUpdater: Setting Radio Power to Off");
            this.mCi.setRadioPower(false, null);
        }
        this.switchVoiceRadioTech(newVoiceRadioTech);
        if (this.mResetModemOnRadioTechnologyChange && oldPowerState) {
            this.logd("phoneObjectUpdater: Resetting Radio");
            this.mCi.setRadioPower(oldPowerState, null);
        }
        this.mIccCardProxy.setVoiceRadioTech(newVoiceRadioTech);
        Intent intent = new Intent("android.intent.action.RADIO_TECHNOLOGY");
        intent.putExtra("phoneName", this.getPhoneName());
        SubscriptionManager.putPhoneIdAndSubIdExtra(intent, this.mPhoneId);
        ActivityManager.broadcastStickyIntent(intent, -1);
    }

    private void switchVoiceRadioTech(int newVoiceRadioTech) {
        String outgoingPhoneName = this.getPhoneName();
        this.logd("Switching Voice Phone : " + outgoingPhoneName + " >>> " + (ServiceState.isGsm(newVoiceRadioTech) ? "GSM" : "CDMA"));
        if (ServiceState.isCdma(newVoiceRadioTech)) {
            this.switchPhoneType(6);
        } else if (ServiceState.isGsm(newVoiceRadioTech)) {
            this.switchPhoneType(1);
        } else {
            this.loge("deleteAndCreatePhone: newVoiceRadioTech=" + newVoiceRadioTech + " is not CDMA or GSM (error) - aborting!");
            return;
        }
    }

    @Override
    public IccSmsInterfaceManager getIccSmsInterfaceManager() {
        return this.mIccSmsInterfaceManager;
    }

    @Override
    public void updatePhoneObject(int voiceRadioTech) {
        this.logd("updatePhoneObject: radioTechnology=" + voiceRadioTech);
        this.sendMessage(this.obtainMessage(42, voiceRadioTech, 0, null));
    }

    @Override
    public void setImsRegistrationState(boolean registered) {
        this.mSST.setImsRegistrationState(registered);
    }

    @Override
    public boolean getIccRecordsLoaded() {
        return this.mIccCardProxy.getIccRecordsLoaded();
    }

    @Override
    public IccCard getIccCard() {
        return this.mIccCardProxy;
    }

    @Override
    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.println("GsmCdmaPhone extends:");
        super.dump(fd, pw, args);
        pw.println(" mPrecisePhoneType=" + this.mPrecisePhoneType);
        pw.println(" mCT=" + this.mCT);
        pw.println(" mSST=" + this.mSST);
        pw.println(" mPendingMMIs=" + this.mPendingMMIs);
        pw.println(" mIccPhoneBookIntManager=" + this.mIccPhoneBookIntManager);
        pw.println(" mCdmaSSM=" + this.mCdmaSSM);
        pw.println(" mCdmaSubscriptionSource=" + this.mCdmaSubscriptionSource);
        pw.println(" mEriManager=" + this.mEriManager);
        pw.println(" mWakeLock=" + this.mWakeLock);
        pw.println(" isInEcm()=" + this.isInEcm());
        pw.println(" mCarrierOtaSpNumSchema=" + this.mCarrierOtaSpNumSchema);
        if (!this.isPhoneTypeGsm()) {
            pw.println(" getCdmaEriIconIndex()=" + this.getCdmaEriIconIndex());
            pw.println(" getCdmaEriIconMode()=" + this.getCdmaEriIconMode());
            pw.println(" getCdmaEriText()=" + this.getCdmaEriText());
            pw.println(" isMinInfoReady()=" + this.isMinInfoReady());
        }
        pw.println(" isCspPlmnEnabled()=" + this.isCspPlmnEnabled());
        pw.flush();
        pw.println("++++++++++++++++++++++++++++++++");
        try {
            this.mIccCardProxy.dump(fd, pw, args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        pw.flush();
        pw.println("++++++++++++++++++++++++++++++++");
        pw.println("DeviceStateMonitor:");
        this.mDeviceStateMonitor.dump(fd, pw, args);
        pw.println("++++++++++++++++++++++++++++++++");
    }

    @Override
    public boolean setOperatorBrandOverride(String brand) {
        if (this.mUiccController == null) {
            return false;
        }
        UiccCard card = this.mUiccController.getUiccCard(this.getPhoneId());
        if (card == null) {
            return false;
        }
        boolean status = card.setOperatorBrandOverride(brand);
        if (status) {
            IccRecords iccRecords = (IccRecords)this.mIccRecords.get();
            if (iccRecords != null) {
                TelephonyManager.from(this.mContext).setSimOperatorNameForPhone(this.getPhoneId(), iccRecords.getServiceProviderName());
            }
            if (this.mSST != null) {
                this.mSST.pollState();
            }
        }
        return status;
    }

    private String getOperatorNumeric() {
        String operatorNumeric = null;
        if (this.isPhoneTypeGsm()) {
            IccRecords r = (IccRecords)this.mIccRecords.get();
            if (r != null) {
                operatorNumeric = r.getOperatorNumeric();
            }
        } else {
            IccRecords curIccRecords = null;
            if (this.mCdmaSubscriptionSource == 1) {
                operatorNumeric = SystemProperties.get(PROPERTY_CDMA_HOME_OPERATOR_NUMERIC);
            } else if (this.mCdmaSubscriptionSource == 0) {
                curIccRecords = this.mSimRecords;
                if (curIccRecords != null) {
                    operatorNumeric = curIccRecords.getOperatorNumeric();
                } else {
                    curIccRecords = (IccRecords)this.mIccRecords.get();
                    if (curIccRecords != null && curIccRecords instanceof RuimRecords) {
                        RuimRecords csim = (RuimRecords)curIccRecords;
                        operatorNumeric = csim.getRUIMOperatorNumeric();
                    }
                }
            }
            if (operatorNumeric == null) {
                this.loge("getOperatorNumeric: Cannot retrieve operatorNumeric: mCdmaSubscriptionSource = " + this.mCdmaSubscriptionSource + " mIccRecords = " + (curIccRecords != null ? Boolean.valueOf(curIccRecords.getRecordsLoaded()) : null));
            }
            this.logd("getOperatorNumeric: mCdmaSubscriptionSource = " + this.mCdmaSubscriptionSource + " operatorNumeric = " + operatorNumeric);
        }
        return operatorNumeric;
    }

    public String getCountryIso() {
        int subId = this.getSubId();
        SubscriptionInfo subInfo = SubscriptionManager.from(this.getContext()).getActiveSubscriptionInfo(subId);
        if (subInfo == null) {
            return null;
        }
        return subInfo.getCountryIso().toUpperCase();
    }

    public void notifyEcbmTimerReset(Boolean flag) {
        this.mEcmTimerResetRegistrants.notifyResult(flag);
    }

    @Override
    public void registerForEcmTimerReset(Handler h, int what, Object obj) {
        this.mEcmTimerResetRegistrants.addUnique(h, what, obj);
    }

    @Override
    public void unregisterForEcmTimerReset(Handler h) {
        this.mEcmTimerResetRegistrants.remove(h);
    }

    @Override
    public void setVoiceMessageWaiting(int line, int countWaiting) {
        if (this.isPhoneTypeGsm()) {
            IccRecords r = (IccRecords)this.mIccRecords.get();
            if (r != null) {
                r.setVoiceMessageWaiting(line, countWaiting);
            } else {
                this.logd("SIM Records not found, MWI not updated");
            }
        } else {
            this.setVoiceMessageCount(countWaiting);
        }
    }

    private void logd(String s) {
        Rlog.d(LOG_TAG, "[GsmCdmaPhone] " + s);
    }

    private void logi(String s) {
        Rlog.i(LOG_TAG, "[GsmCdmaPhone] " + s);
    }

    private void loge(String s) {
        Rlog.e(LOG_TAG, "[GsmCdmaPhone] " + s);
    }

    @Override
    public boolean isUtEnabled() {
        Phone imsPhone = this.mImsPhone;
        if (imsPhone != null) {
            return imsPhone.isUtEnabled();
        }
        this.logd("isUtEnabled: called for GsmCdma");
        return false;
    }

    public String getDtmfToneDelayKey() {
        return this.isPhoneTypeGsm() ? "gsm_dtmf_tone_delay_int" : "cdma_dtmf_tone_delay_int";
    }

    public PowerManager.WakeLock getWakeLock() {
        return this.mWakeLock;
    }

    private static class Cfu {
        final String mSetCfNumber;
        final Message mOnComplete;

        Cfu(String cfNumber, Message onComplete) {
            this.mSetCfNumber = cfNumber;
            this.mOnComplete = onComplete;
        }
    }
}

