/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.AsyncResult;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.PersistableBundle;
import android.os.Registrant;
import android.os.RegistrantList;
import android.os.SystemProperties;
import android.telephony.CarrierConfigManager;
import android.telephony.CellLocation;
import android.telephony.PhoneNumberUtils;
import android.telephony.Rlog;
import android.telephony.TelephonyManager;
import android.telephony.cdma.CdmaCellLocation;
import android.telephony.gsm.GsmCellLocation;
import android.text.TextUtils;
import android.util.EventLog;
import com.android.internal.telephony.Call;
import com.android.internal.telephony.CallStateException;
import com.android.internal.telephony.CallTracker;
import com.android.internal.telephony.Connection;
import com.android.internal.telephony.DriverCall;
import com.android.internal.telephony.GsmCdmaCall;
import com.android.internal.telephony.GsmCdmaConnection;
import com.android.internal.telephony.GsmCdmaPhone;
import com.android.internal.telephony.LastCallFailCause;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneConstants;
import com.android.internal.telephony.PhoneInternalInterface;
import com.android.internal.telephony.UUSInfo;
import com.android.internal.telephony.cdma.CdmaCallWaitingNotification;
import com.android.internal.telephony.metrics.TelephonyMetrics;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class GsmCdmaCallTracker
extends CallTracker {
    private static final String LOG_TAG = "GsmCdmaCallTracker";
    private static final boolean REPEAT_POLLING = false;
    private static final boolean DBG_POLL = false;
    private static final boolean VDBG = false;
    public static final int MAX_CONNECTIONS_GSM = 19;
    private static final int MAX_CONNECTIONS_PER_CALL_GSM = 5;
    private static final int MAX_CONNECTIONS_CDMA = 8;
    private static final int MAX_CONNECTIONS_PER_CALL_CDMA = 1;
    public GsmCdmaConnection[] mConnections;
    private RegistrantList mVoiceCallEndedRegistrants = new RegistrantList();
    private RegistrantList mVoiceCallStartedRegistrants = new RegistrantList();
    private ArrayList<GsmCdmaConnection> mDroppedDuringPoll = new ArrayList(19);
    public GsmCdmaCall mRingingCall = new GsmCdmaCall(this);
    public GsmCdmaCall mForegroundCall = new GsmCdmaCall(this);
    public GsmCdmaCall mBackgroundCall = new GsmCdmaCall(this);
    private GsmCdmaConnection mPendingMO;
    private boolean mHangupPendingMO;
    private GsmCdmaPhone mPhone;
    private boolean mDesiredMute = false;
    public PhoneConstants.State mState = PhoneConstants.State.IDLE;
    private TelephonyMetrics mMetrics = TelephonyMetrics.getInstance();
    private RegistrantList mCallWaitingRegistrants = new RegistrantList();
    private boolean mPendingCallInEcm;
    private boolean mIsInEmergencyCall;
    private int mPendingCallClirMode;
    private boolean mIsEcmTimerCanceled;
    private int m3WayCallFlashDelay;
    private BroadcastReceiver mEcmExitReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals("android.intent.action.EMERGENCY_CALLBACK_MODE_CHANGED")) {
                boolean isInEcm = intent.getBooleanExtra("phoneinECMState", false);
                GsmCdmaCallTracker.this.log("Received ACTION_EMERGENCY_CALLBACK_MODE_CHANGED isInEcm = " + isInEcm);
                if (!isInEcm) {
                    ArrayList<Connection> toNotify = new ArrayList<Connection>();
                    toNotify.addAll(GsmCdmaCallTracker.this.mRingingCall.getConnections());
                    toNotify.addAll(GsmCdmaCallTracker.this.mForegroundCall.getConnections());
                    toNotify.addAll(GsmCdmaCallTracker.this.mBackgroundCall.getConnections());
                    if (GsmCdmaCallTracker.this.mPendingMO != null) {
                        toNotify.add(GsmCdmaCallTracker.this.mPendingMO);
                    }
                    for (Connection connection : toNotify) {
                        if (connection == null) continue;
                        connection.onExitedEcmMode();
                    }
                }
            }
        }
    };

    public GsmCdmaCallTracker(GsmCdmaPhone phone) {
        this.mPhone = phone;
        this.mCi = phone.mCi;
        this.mCi.registerForCallStateChanged(this, 2, null);
        this.mCi.registerForOn(this, 9, null);
        this.mCi.registerForNotAvailable(this, 10, null);
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.EMERGENCY_CALLBACK_MODE_CHANGED");
        this.mPhone.getContext().registerReceiver(this.mEcmExitReceiver, filter);
        this.updatePhoneType(true);
    }

    public void updatePhoneType() {
        this.updatePhoneType(false);
    }

    private void updatePhoneType(boolean duringInit) {
        if (!duringInit) {
            this.reset();
            this.pollCallsWhenSafe();
        }
        if (this.mPhone.isPhoneTypeGsm()) {
            this.mConnections = new GsmCdmaConnection[19];
            this.mCi.unregisterForCallWaitingInfo(this);
            if (this.mIsInEmergencyCall) {
                this.mPhone.mDcTracker.setInternalDataEnabled(true);
            }
        } else {
            this.mConnections = new GsmCdmaConnection[8];
            this.mPendingCallInEcm = false;
            this.mIsInEmergencyCall = false;
            this.mPendingCallClirMode = 0;
            this.mIsEcmTimerCanceled = false;
            this.m3WayCallFlashDelay = 0;
            this.mCi.registerForCallWaitingInfo(this, 15, null);
        }
    }

    private void reset() {
        Rlog.d(LOG_TAG, "reset");
        for (GsmCdmaConnection gsmCdmaConnection : this.mConnections) {
            if (gsmCdmaConnection == null) continue;
            gsmCdmaConnection.onDisconnect(36);
            gsmCdmaConnection.dispose();
        }
        if (this.mPendingMO != null) {
            this.mPendingMO.dispose();
        }
        this.mConnections = null;
        this.mPendingMO = null;
        this.clearDisconnected();
    }

    protected void finalize() {
        Rlog.d(LOG_TAG, "GsmCdmaCallTracker finalized");
    }

    @Override
    public void registerForVoiceCallStarted(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.mVoiceCallStartedRegistrants.add(r);
        if (this.mState != PhoneConstants.State.IDLE) {
            r.notifyRegistrant(new AsyncResult(null, null, null));
        }
    }

    @Override
    public void unregisterForVoiceCallStarted(Handler h) {
        this.mVoiceCallStartedRegistrants.remove(h);
    }

    @Override
    public void registerForVoiceCallEnded(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.mVoiceCallEndedRegistrants.add(r);
    }

    @Override
    public void unregisterForVoiceCallEnded(Handler h) {
        this.mVoiceCallEndedRegistrants.remove(h);
    }

    public void registerForCallWaiting(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.mCallWaitingRegistrants.add(r);
    }

    public void unregisterForCallWaiting(Handler h) {
        this.mCallWaitingRegistrants.remove(h);
    }

    private void fakeHoldForegroundBeforeDial() {
        List connCopy = (List)this.mForegroundCall.mConnections.clone();
        int s = connCopy.size();
        for (int i = 0; i < s; ++i) {
            GsmCdmaConnection conn = (GsmCdmaConnection)connCopy.get(i);
            conn.fakeHoldBeforeDial();
        }
    }

    public synchronized Connection dial(String dialString, int clirMode, UUSInfo uusInfo, Bundle intentExtras) throws CallStateException {
        this.clearDisconnected();
        if (!this.canDial()) {
            throw new CallStateException("cannot dial in current state");
        }
        String origNumber = dialString;
        dialString = this.convertNumberIfNecessary(this.mPhone, dialString);
        if (this.mForegroundCall.getState() == Call.State.ACTIVE) {
            this.switchWaitingOrHoldingAndActive();
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.fakeHoldForegroundBeforeDial();
        }
        if (this.mForegroundCall.getState() != Call.State.IDLE) {
            throw new CallStateException("cannot dial in current state");
        }
        boolean isEmergencyCall = PhoneNumberUtils.isLocalEmergencyNumber(this.mPhone.getContext(), dialString);
        this.mPendingMO = new GsmCdmaConnection(this.mPhone, this.checkForTestEmergencyNumber(dialString), this, this.mForegroundCall, isEmergencyCall);
        this.mHangupPendingMO = false;
        this.mMetrics.writeRilDial(this.mPhone.getPhoneId(), this.mPendingMO, clirMode, uusInfo);
        if (this.mPendingMO.getAddress() == null || this.mPendingMO.getAddress().length() == 0 || this.mPendingMO.getAddress().indexOf(78) >= 0) {
            this.mPendingMO.mCause = 7;
            this.pollCallsWhenSafe();
        } else {
            this.setMute(false);
            this.mCi.dial(this.mPendingMO.getAddress(), clirMode, uusInfo, this.obtainCompleteMessage());
        }
        if (this.mNumberConverted) {
            this.mPendingMO.setConverted(origNumber);
            this.mNumberConverted = false;
        }
        this.updatePhoneState();
        this.mPhone.notifyPreciseCallStateChanged();
        return this.mPendingMO;
    }

    private void handleEcmTimer(int action) {
        this.mPhone.handleTimerInEmergencyCallbackMode(action);
        switch (action) {
            case 1: {
                this.mIsEcmTimerCanceled = true;
                break;
            }
            case 0: {
                this.mIsEcmTimerCanceled = false;
                break;
            }
            default: {
                Rlog.e(LOG_TAG, "handleEcmTimer, unsupported action " + action);
            }
        }
    }

    private void disableDataCallInEmergencyCall(String dialString) {
        if (PhoneNumberUtils.isLocalEmergencyNumber(this.mPhone.getContext(), dialString)) {
            this.log("disableDataCallInEmergencyCall");
            this.setIsInEmergencyCall();
        }
    }

    public void setIsInEmergencyCall() {
        this.mIsInEmergencyCall = true;
        this.mPhone.mDcTracker.setInternalDataEnabled(false);
        this.mPhone.notifyEmergencyCallRegistrants(true);
        this.mPhone.sendEmergencyCallStateChange(true);
    }

    private Connection dial(String dialString, int clirMode) throws CallStateException {
        boolean internationalRoaming;
        this.clearDisconnected();
        if (!this.canDial()) {
            throw new CallStateException("cannot dial in current state");
        }
        TelephonyManager tm = (TelephonyManager)this.mPhone.getContext().getSystemService("phone");
        String origNumber = dialString;
        String operatorIsoContry = tm.getNetworkCountryIsoForPhone(this.mPhone.getPhoneId());
        String simIsoContry = tm.getSimCountryIsoForPhone(this.mPhone.getPhoneId());
        boolean bl = internationalRoaming = !TextUtils.isEmpty(operatorIsoContry) && !TextUtils.isEmpty(simIsoContry) && !simIsoContry.equals(operatorIsoContry);
        if (internationalRoaming) {
            if ("us".equals(simIsoContry)) {
                internationalRoaming = internationalRoaming && !"vi".equals(operatorIsoContry);
            } else if ("vi".equals(simIsoContry)) {
                boolean bl2 = internationalRoaming = internationalRoaming && !"us".equals(operatorIsoContry);
            }
        }
        if (internationalRoaming) {
            dialString = this.convertNumberIfNecessary(this.mPhone, dialString);
        }
        boolean isPhoneInEcmMode = this.mPhone.isInEcm();
        boolean isEmergencyCall = PhoneNumberUtils.isLocalEmergencyNumber(this.mPhone.getContext(), dialString);
        if (isPhoneInEcmMode && isEmergencyCall) {
            this.handleEcmTimer(1);
        }
        if (this.mForegroundCall.getState() == Call.State.ACTIVE) {
            return this.dialThreeWay(dialString);
        }
        this.mPendingMO = new GsmCdmaConnection(this.mPhone, this.checkForTestEmergencyNumber(dialString), this, this.mForegroundCall, isEmergencyCall);
        this.mHangupPendingMO = false;
        if (this.mPendingMO.getAddress() == null || this.mPendingMO.getAddress().length() == 0 || this.mPendingMO.getAddress().indexOf(78) >= 0) {
            this.mPendingMO.mCause = 7;
            this.pollCallsWhenSafe();
        } else {
            this.setMute(false);
            this.disableDataCallInEmergencyCall(dialString);
            if (!isPhoneInEcmMode || isPhoneInEcmMode && isEmergencyCall) {
                this.mCi.dial(this.mPendingMO.getAddress(), clirMode, this.obtainCompleteMessage());
            } else {
                this.mPhone.exitEmergencyCallbackMode();
                this.mPhone.setOnEcbModeExitResponse(this, 14, null);
                this.mPendingCallClirMode = clirMode;
                this.mPendingCallInEcm = true;
            }
        }
        if (this.mNumberConverted) {
            this.mPendingMO.setConverted(origNumber);
            this.mNumberConverted = false;
        }
        this.updatePhoneState();
        this.mPhone.notifyPreciseCallStateChanged();
        return this.mPendingMO;
    }

    private Connection dialThreeWay(String dialString) {
        if (!this.mForegroundCall.isIdle()) {
            this.disableDataCallInEmergencyCall(dialString);
            this.mPendingMO = new GsmCdmaConnection(this.mPhone, this.checkForTestEmergencyNumber(dialString), this, this.mForegroundCall, this.mIsInEmergencyCall);
            CarrierConfigManager configManager = (CarrierConfigManager)this.mPhone.getContext().getSystemService("carrier_config");
            PersistableBundle bundle = configManager.getConfig();
            this.m3WayCallFlashDelay = bundle != null ? bundle.getInt("cdma_3waycall_flash_delay_int") : 0;
            if (this.m3WayCallFlashDelay > 0) {
                this.mCi.sendCDMAFeatureCode("", this.obtainMessage(20));
            } else {
                this.mCi.sendCDMAFeatureCode(this.mPendingMO.getAddress(), this.obtainMessage(16));
            }
            return this.mPendingMO;
        }
        return null;
    }

    public Connection dial(String dialString) throws CallStateException {
        if (this.isPhoneTypeGsm()) {
            return this.dial(dialString, 0, null);
        }
        return this.dial(dialString, 0);
    }

    public Connection dial(String dialString, UUSInfo uusInfo, Bundle intentExtras) throws CallStateException {
        return this.dial(dialString, 0, uusInfo, intentExtras);
    }

    private Connection dial(String dialString, int clirMode, Bundle intentExtras) throws CallStateException {
        return this.dial(dialString, clirMode, null, intentExtras);
    }

    public void acceptCall() throws CallStateException {
        if (this.mRingingCall.getState() == Call.State.INCOMING) {
            Rlog.i("phone", "acceptCall: incoming...");
            this.setMute(false);
            this.mCi.acceptCall(this.obtainCompleteMessage());
        } else if (this.mRingingCall.getState() == Call.State.WAITING) {
            if (this.isPhoneTypeGsm()) {
                this.setMute(false);
            } else {
                GsmCdmaConnection cwConn = (GsmCdmaConnection)this.mRingingCall.getLatestConnection();
                cwConn.updateParent(this.mRingingCall, this.mForegroundCall);
                cwConn.onConnectedInOrOut();
                this.updatePhoneState();
            }
            this.switchWaitingOrHoldingAndActive();
        } else {
            throw new CallStateException("phone not ringing");
        }
    }

    public void rejectCall() throws CallStateException {
        if (!this.mRingingCall.getState().isRinging()) {
            throw new CallStateException("phone not ringing");
        }
        this.mCi.rejectCall(this.obtainCompleteMessage());
    }

    private void flashAndSetGenericTrue() {
        this.mCi.sendCDMAFeatureCode("", this.obtainMessage(8));
        this.mPhone.notifyPreciseCallStateChanged();
    }

    public void switchWaitingOrHoldingAndActive() throws CallStateException {
        if (this.mRingingCall.getState() == Call.State.INCOMING) {
            throw new CallStateException("cannot be in the incoming state");
        }
        if (this.isPhoneTypeGsm()) {
            this.mCi.switchWaitingOrHoldingAndActive(this.obtainCompleteMessage(8));
        } else if (this.mForegroundCall.getConnections().size() > 1) {
            this.flashAndSetGenericTrue();
        } else {
            this.mCi.sendCDMAFeatureCode("", this.obtainMessage(8));
        }
    }

    public void conference() {
        if (this.isPhoneTypeGsm()) {
            this.mCi.conference(this.obtainCompleteMessage(11));
        } else {
            this.flashAndSetGenericTrue();
        }
    }

    public void explicitCallTransfer() {
        this.mCi.explicitCallTransfer(this.obtainCompleteMessage(13));
    }

    public void clearDisconnected() {
        this.internalClearDisconnected();
        this.updatePhoneState();
        this.mPhone.notifyPreciseCallStateChanged();
    }

    public boolean canConference() {
        return this.mForegroundCall.getState() == Call.State.ACTIVE && this.mBackgroundCall.getState() == Call.State.HOLDING && !this.mBackgroundCall.isFull() && !this.mForegroundCall.isFull();
    }

    private boolean canDial() {
        boolean ret;
        int serviceState = this.mPhone.getServiceState().getState();
        String disableCall = SystemProperties.get("ro.telephony.disable-call", "false");
        boolean bl = ret = serviceState != 3 && this.mPendingMO == null && !this.mRingingCall.isRinging() && !disableCall.equals("true") && (!this.mForegroundCall.getState().isAlive() || !this.mBackgroundCall.getState().isAlive() || !this.isPhoneTypeGsm() && this.mForegroundCall.getState() == Call.State.ACTIVE);
        if (!ret) {
            this.log(String.format("canDial is false\n((serviceState=%d) != ServiceState.STATE_POWER_OFF)::=%s\n&& pendingMO == null::=%s\n&& !ringingCall.isRinging()::=%s\n&& !disableCall.equals(\"true\")::=%s\n&& (!foregroundCall.getState().isAlive()::=%s\n   || foregroundCall.getState() == GsmCdmaCall.State.ACTIVE::=%s\n   ||!backgroundCall.getState().isAlive())::=%s)", serviceState, serviceState != 3, this.mPendingMO == null, !this.mRingingCall.isRinging(), !disableCall.equals("true"), !this.mForegroundCall.getState().isAlive(), this.mForegroundCall.getState() == Call.State.ACTIVE, !this.mBackgroundCall.getState().isAlive()));
        }
        return ret;
    }

    public boolean canTransfer() {
        if (this.isPhoneTypeGsm()) {
            return (this.mForegroundCall.getState() == Call.State.ACTIVE || this.mForegroundCall.getState() == Call.State.ALERTING || this.mForegroundCall.getState() == Call.State.DIALING) && this.mBackgroundCall.getState() == Call.State.HOLDING;
        }
        Rlog.e(LOG_TAG, "canTransfer: not possible in CDMA");
        return false;
    }

    private void internalClearDisconnected() {
        this.mRingingCall.clearDisconnected();
        this.mForegroundCall.clearDisconnected();
        this.mBackgroundCall.clearDisconnected();
    }

    private Message obtainCompleteMessage() {
        return this.obtainCompleteMessage(4);
    }

    private Message obtainCompleteMessage(int what) {
        ++this.mPendingOperations;
        this.mLastRelevantPoll = null;
        this.mNeedsPoll = true;
        return this.obtainMessage(what);
    }

    private void operationComplete() {
        --this.mPendingOperations;
        if (this.mPendingOperations == 0 && this.mNeedsPoll) {
            this.mLastRelevantPoll = this.obtainMessage(1);
            this.mCi.getCurrentCalls(this.mLastRelevantPoll);
        } else if (this.mPendingOperations < 0) {
            Rlog.e(LOG_TAG, "GsmCdmaCallTracker.pendingOperations < 0");
            this.mPendingOperations = 0;
        }
    }

    private void updatePhoneState() {
        PhoneConstants.State oldState = this.mState;
        if (this.mRingingCall.isRinging()) {
            this.mState = PhoneConstants.State.RINGING;
        } else if (this.mPendingMO != null || !this.mForegroundCall.isIdle() || !this.mBackgroundCall.isIdle()) {
            this.mState = PhoneConstants.State.OFFHOOK;
        } else {
            Phone imsPhone = this.mPhone.getImsPhone();
            if (this.mState == PhoneConstants.State.OFFHOOK && imsPhone != null) {
                imsPhone.callEndCleanupHandOverCallIfAny();
            }
            this.mState = PhoneConstants.State.IDLE;
        }
        if (this.mState == PhoneConstants.State.IDLE && oldState != this.mState) {
            this.mVoiceCallEndedRegistrants.notifyRegistrants(new AsyncResult(null, null, null));
        } else if (oldState == PhoneConstants.State.IDLE && oldState != this.mState) {
            this.mVoiceCallStartedRegistrants.notifyRegistrants(new AsyncResult(null, null, null));
        }
        this.log("update phone state, old=" + (Object)((Object)oldState) + " new=" + (Object)((Object)this.mState));
        if (this.mState != oldState) {
            this.mPhone.notifyPhoneStateChanged();
            this.mMetrics.writePhoneState(this.mPhone.getPhoneId(), this.mState);
        }
    }

    @Override
    protected synchronized void handlePollCalls(AsyncResult ar) {
        Phone imsPhone;
        ArrayList polledCalls;
        if (ar.exception == null) {
            polledCalls = (ArrayList)ar.result;
        } else if (this.isCommandExceptionRadioNotAvailable(ar.exception)) {
            polledCalls = new ArrayList();
        } else {
            this.pollCallsAfterDelay();
            return;
        }
        Connection newRinging = null;
        ArrayList<GsmCdmaConnection> newUnknownConnectionsGsm = new ArrayList<GsmCdmaConnection>();
        GsmCdmaConnection newUnknownConnectionCdma = null;
        boolean hasNonHangupStateChanged = false;
        boolean hasAnyCallDisconnected = false;
        boolean needsPollDelay = false;
        boolean unknownConnectionAppeared = false;
        int handoverConnectionsSize = this.mHandoverConnections.size();
        boolean noConnectionExists = true;
        int curDC = 0;
        int n = polledCalls.size();
        for (int i = 0; i < this.mConnections.length; ++i) {
            GsmCdmaConnection conn = this.mConnections[i];
            DriverCall dc = null;
            if (curDC < n) {
                dc = (DriverCall)polledCalls.get(curDC);
                if (dc.index == i + 1) {
                    ++curDC;
                } else {
                    dc = null;
                }
            }
            if (conn != null || dc != null) {
                noConnectionExists = false;
            }
            if (conn == null && dc != null) {
                if (this.mPendingMO != null && this.mPendingMO.compareTo(dc)) {
                    this.mConnections[i] = this.mPendingMO;
                    this.mPendingMO.mIndex = i;
                    this.mPendingMO.update(dc);
                    this.mPendingMO = null;
                    if (this.mHangupPendingMO) {
                        this.mHangupPendingMO = false;
                        if (!this.isPhoneTypeGsm() && this.mIsEcmTimerCanceled) {
                            this.handleEcmTimer(0);
                        }
                        try {
                            this.log("poll: hangupPendingMO, hangup conn " + i);
                            this.hangup(this.mConnections[i]);
                        }
                        catch (CallStateException ex) {
                            Rlog.e(LOG_TAG, "unexpected error on hangup");
                        }
                        return;
                    }
                } else {
                    this.log("pendingMo=" + this.mPendingMO + ", dc=" + dc);
                    this.mConnections[i] = new GsmCdmaConnection(this.mPhone, dc, this, i);
                    Connection hoConnection = this.getHoConnection(dc);
                    if (hoConnection != null) {
                        this.mConnections[i].migrateFrom(hoConnection);
                        if (hoConnection.mPreHandoverState != Call.State.ACTIVE && hoConnection.mPreHandoverState != Call.State.HOLDING && dc.state == DriverCall.State.ACTIVE) {
                            this.mConnections[i].onConnectedInOrOut();
                        }
                        this.mHandoverConnections.remove(hoConnection);
                        if (this.isPhoneTypeGsm()) {
                            Iterator it = this.mHandoverConnections.iterator();
                            while (it.hasNext()) {
                                Connection c = (Connection)it.next();
                                Rlog.i(LOG_TAG, "HO Conn state is " + (Object)((Object)c.mPreHandoverState));
                                if (c.mPreHandoverState != this.mConnections[i].getState()) continue;
                                Rlog.i(LOG_TAG, "Removing HO conn " + hoConnection + (Object)((Object)c.mPreHandoverState));
                                it.remove();
                            }
                        }
                        this.mPhone.notifyHandoverStateChanged(this.mConnections[i]);
                    } else {
                        newRinging = this.checkMtFindNewRinging(dc, i);
                        if (newRinging == null) {
                            unknownConnectionAppeared = true;
                            if (this.isPhoneTypeGsm()) {
                                newUnknownConnectionsGsm.add(this.mConnections[i]);
                            } else {
                                newUnknownConnectionCdma = this.mConnections[i];
                            }
                        }
                    }
                }
                hasNonHangupStateChanged = true;
                continue;
            }
            if (conn != null && dc == null) {
                if (this.isPhoneTypeGsm()) {
                    this.mDroppedDuringPoll.add(conn);
                } else {
                    GsmCdmaConnection cn;
                    int n2;
                    int count = this.mForegroundCall.mConnections.size();
                    for (n2 = 0; n2 < count; ++n2) {
                        this.log("adding fgCall cn " + n2 + " to droppedDuringPoll");
                        cn = (GsmCdmaConnection)this.mForegroundCall.mConnections.get(n2);
                        this.mDroppedDuringPoll.add(cn);
                    }
                    count = this.mRingingCall.mConnections.size();
                    for (n2 = 0; n2 < count; ++n2) {
                        this.log("adding rgCall cn " + n2 + " to droppedDuringPoll");
                        cn = (GsmCdmaConnection)this.mRingingCall.mConnections.get(n2);
                        this.mDroppedDuringPoll.add(cn);
                    }
                    if (this.mIsEcmTimerCanceled) {
                        this.handleEcmTimer(0);
                    }
                    this.checkAndEnableDataCallAfterEmergencyCallDropped();
                }
                this.mConnections[i] = null;
                continue;
            }
            if (conn != null && dc != null && !conn.compareTo(dc) && this.isPhoneTypeGsm()) {
                this.mDroppedDuringPoll.add(conn);
                this.mConnections[i] = new GsmCdmaConnection(this.mPhone, dc, this, i);
                if (this.mConnections[i].getCall() == this.mRingingCall) {
                    newRinging = this.mConnections[i];
                }
                hasNonHangupStateChanged = true;
                continue;
            }
            if (conn == null || dc == null) continue;
            if (!this.isPhoneTypeGsm() && conn.isIncoming() != dc.isMT) {
                if (dc.isMT) {
                    this.mDroppedDuringPoll.add(conn);
                    newRinging = this.checkMtFindNewRinging(dc, i);
                    if (newRinging == null) {
                        unknownConnectionAppeared = true;
                        newUnknownConnectionCdma = conn;
                    }
                    this.checkAndEnableDataCallAfterEmergencyCallDropped();
                    continue;
                }
                Rlog.e(LOG_TAG, "Error in RIL, Phantom call appeared " + dc);
                continue;
            }
            boolean changed = conn.update(dc);
            hasNonHangupStateChanged = hasNonHangupStateChanged || changed;
        }
        if (!this.isPhoneTypeGsm() && noConnectionExists) {
            this.checkAndEnableDataCallAfterEmergencyCallDropped();
        }
        if (this.mPendingMO != null) {
            Rlog.d(LOG_TAG, "Pending MO dropped before poll fg state:" + (Object)((Object)this.mForegroundCall.getState()));
            this.mDroppedDuringPoll.add(this.mPendingMO);
            this.mPendingMO = null;
            this.mHangupPendingMO = false;
            if (!this.isPhoneTypeGsm()) {
                if (this.mPendingCallInEcm) {
                    this.mPendingCallInEcm = false;
                }
                this.checkAndEnableDataCallAfterEmergencyCallDropped();
            }
        }
        if (newRinging != null) {
            this.mPhone.notifyNewRingingConnection(newRinging);
        }
        ArrayList<GsmCdmaConnection> locallyDisconnectedConnections = new ArrayList<GsmCdmaConnection>();
        for (int i = this.mDroppedDuringPoll.size() - 1; i >= 0; --i) {
            GsmCdmaConnection gsmCdmaConnection = this.mDroppedDuringPoll.get(i);
            boolean wasDisconnected = false;
            if (gsmCdmaConnection.isIncoming() && gsmCdmaConnection.getConnectTime() == 0L) {
                int cause = gsmCdmaConnection.mCause == 3 ? 16 : 1;
                this.log("missed/rejected call, conn.cause=" + gsmCdmaConnection.mCause);
                this.log("setting cause to " + cause);
                this.mDroppedDuringPoll.remove(i);
                hasAnyCallDisconnected |= gsmCdmaConnection.onDisconnect(cause);
                wasDisconnected = true;
                locallyDisconnectedConnections.add(gsmCdmaConnection);
            } else if (gsmCdmaConnection.mCause == 3 || gsmCdmaConnection.mCause == 7) {
                this.mDroppedDuringPoll.remove(i);
                hasAnyCallDisconnected |= gsmCdmaConnection.onDisconnect(gsmCdmaConnection.mCause);
                wasDisconnected = true;
                locallyDisconnectedConnections.add(gsmCdmaConnection);
            }
            if (this.isPhoneTypeGsm() || !wasDisconnected || !unknownConnectionAppeared || gsmCdmaConnection != newUnknownConnectionCdma) continue;
            unknownConnectionAppeared = false;
            newUnknownConnectionCdma = null;
        }
        if (locallyDisconnectedConnections.size() > 0) {
            this.mMetrics.writeRilCallList(this.mPhone.getPhoneId(), locallyDisconnectedConnections);
        }
        Iterator it = this.mHandoverConnections.iterator();
        while (it.hasNext()) {
            Connection connection = (Connection)it.next();
            this.log("handlePollCalls - disconnect hoConn= " + connection + " hoConn.State= " + (Object)((Object)connection.getState()));
            if (connection.getState().isRinging()) {
                connection.onDisconnect(1);
            } else {
                connection.onDisconnect(-1);
            }
            it.remove();
        }
        if (this.mDroppedDuringPoll.size() > 0) {
            this.mCi.getLastCallFailCause(this.obtainNoPollCompleteMessage(5));
        }
        if (needsPollDelay) {
            this.pollCallsAfterDelay();
        }
        if (newRinging != null || hasNonHangupStateChanged || hasAnyCallDisconnected) {
            this.internalClearDisconnected();
        }
        this.updatePhoneState();
        if (unknownConnectionAppeared) {
            if (this.isPhoneTypeGsm()) {
                for (Connection connection : newUnknownConnectionsGsm) {
                    this.log("Notify unknown for " + connection);
                    this.mPhone.notifyUnknownConnection(connection);
                }
            } else {
                this.mPhone.notifyUnknownConnection(newUnknownConnectionCdma);
            }
        }
        if (hasNonHangupStateChanged || newRinging != null || hasAnyCallDisconnected) {
            this.mPhone.notifyPreciseCallStateChanged();
            this.updateMetrics(this.mConnections);
        }
        if (handoverConnectionsSize > 0 && this.mHandoverConnections.size() == 0 && (imsPhone = this.mPhone.getImsPhone()) != null) {
            imsPhone.callEndCleanupHandOverCallIfAny();
        }
    }

    private void updateMetrics(GsmCdmaConnection[] connections) {
        ArrayList<GsmCdmaConnection> activeConnections = new ArrayList<GsmCdmaConnection>();
        for (GsmCdmaConnection conn : connections) {
            if (conn == null) continue;
            activeConnections.add(conn);
        }
        this.mMetrics.writeRilCallList(this.mPhone.getPhoneId(), activeConnections);
    }

    private void handleRadioNotAvailable() {
        this.pollCallsWhenSafe();
    }

    private void dumpState() {
        int i;
        Rlog.i(LOG_TAG, "Phone State:" + (Object)((Object)this.mState));
        Rlog.i(LOG_TAG, "Ringing call: " + this.mRingingCall.toString());
        List<Connection> l = this.mRingingCall.getConnections();
        int s = l.size();
        for (i = 0; i < s; ++i) {
            Rlog.i(LOG_TAG, ((Object)l.get(i)).toString());
        }
        Rlog.i(LOG_TAG, "Foreground call: " + this.mForegroundCall.toString());
        l = this.mForegroundCall.getConnections();
        s = l.size();
        for (i = 0; i < s; ++i) {
            Rlog.i(LOG_TAG, ((Object)l.get(i)).toString());
        }
        Rlog.i(LOG_TAG, "Background call: " + this.mBackgroundCall.toString());
        l = this.mBackgroundCall.getConnections();
        s = l.size();
        for (i = 0; i < s; ++i) {
            Rlog.i(LOG_TAG, ((Object)l.get(i)).toString());
        }
    }

    public void hangup(GsmCdmaConnection conn) throws CallStateException {
        if (conn.mOwner != this) {
            throw new CallStateException("GsmCdmaConnection " + conn + "does not belong to GsmCdmaCallTracker " + this);
        }
        if (conn == this.mPendingMO) {
            this.log("hangup: set hangupPendingMO to true");
            this.mHangupPendingMO = true;
        } else {
            if (!this.isPhoneTypeGsm() && conn.getCall() == this.mRingingCall && this.mRingingCall.getState() == Call.State.WAITING) {
                conn.onLocalDisconnect();
                this.updatePhoneState();
                this.mPhone.notifyPreciseCallStateChanged();
                return;
            }
            try {
                this.mMetrics.writeRilHangup(this.mPhone.getPhoneId(), conn, conn.getGsmCdmaIndex());
                this.mCi.hangupConnection(conn.getGsmCdmaIndex(), this.obtainCompleteMessage());
            }
            catch (CallStateException ex) {
                Rlog.w(LOG_TAG, "GsmCdmaCallTracker WARN: hangup() on absent connection " + conn);
            }
        }
        conn.onHangupLocal();
    }

    public void separate(GsmCdmaConnection conn) throws CallStateException {
        if (conn.mOwner != this) {
            throw new CallStateException("GsmCdmaConnection " + conn + "does not belong to GsmCdmaCallTracker " + this);
        }
        try {
            this.mCi.separateConnection(conn.getGsmCdmaIndex(), this.obtainCompleteMessage(12));
        }
        catch (CallStateException ex) {
            Rlog.w(LOG_TAG, "GsmCdmaCallTracker WARN: separate() on absent connection " + conn);
        }
    }

    public void setMute(boolean mute) {
        this.mDesiredMute = mute;
        this.mCi.setMute(this.mDesiredMute, null);
    }

    public boolean getMute() {
        return this.mDesiredMute;
    }

    public void hangup(GsmCdmaCall call) throws CallStateException {
        if (call.getConnections().size() == 0) {
            throw new CallStateException("no connections in call");
        }
        if (call == this.mRingingCall) {
            this.log("(ringing) hangup waiting or background");
            this.logHangupEvent(call);
            this.mCi.hangupWaitingOrBackground(this.obtainCompleteMessage());
        } else if (call == this.mForegroundCall) {
            if (call.isDialingOrAlerting()) {
                this.log("(foregnd) hangup dialing or alerting...");
                this.hangup((GsmCdmaConnection)call.getConnections().get(0));
            } else if (this.isPhoneTypeGsm() && this.mRingingCall.isRinging()) {
                this.log("hangup all conns in active/background call, without affecting ringing call");
                this.hangupAllConnections(call);
            } else {
                this.logHangupEvent(call);
                this.hangupForegroundResumeBackground();
            }
        } else if (call == this.mBackgroundCall) {
            if (this.mRingingCall.isRinging()) {
                this.log("hangup all conns in background call");
                this.hangupAllConnections(call);
            } else {
                this.hangupWaitingOrBackground();
            }
        } else {
            throw new RuntimeException("GsmCdmaCall " + call + "does not belong to GsmCdmaCallTracker " + this);
        }
        call.onHangupLocal();
        this.mPhone.notifyPreciseCallStateChanged();
    }

    private void logHangupEvent(GsmCdmaCall call) {
        int count = call.mConnections.size();
        for (int i = 0; i < count; ++i) {
            int call_index;
            GsmCdmaConnection cn = (GsmCdmaConnection)call.mConnections.get(i);
            try {
                call_index = cn.getGsmCdmaIndex();
            }
            catch (CallStateException ex) {
                call_index = -1;
            }
            this.mMetrics.writeRilHangup(this.mPhone.getPhoneId(), cn, call_index);
        }
    }

    public void hangupWaitingOrBackground() {
        this.log("hangupWaitingOrBackground");
        this.logHangupEvent(this.mBackgroundCall);
        this.mCi.hangupWaitingOrBackground(this.obtainCompleteMessage());
    }

    public void hangupForegroundResumeBackground() {
        this.log("hangupForegroundResumeBackground");
        this.mCi.hangupForegroundResumeBackground(this.obtainCompleteMessage());
    }

    public void hangupConnectionByIndex(GsmCdmaCall call, int index) throws CallStateException {
        int count = call.mConnections.size();
        for (int i = 0; i < count; ++i) {
            GsmCdmaConnection cn = (GsmCdmaConnection)call.mConnections.get(i);
            if (cn.mDisconnected || cn.getGsmCdmaIndex() != index) continue;
            this.mMetrics.writeRilHangup(this.mPhone.getPhoneId(), cn, cn.getGsmCdmaIndex());
            this.mCi.hangupConnection(index, this.obtainCompleteMessage());
            return;
        }
        throw new CallStateException("no GsmCdma index found");
    }

    public void hangupAllConnections(GsmCdmaCall call) {
        try {
            int count = call.mConnections.size();
            for (int i = 0; i < count; ++i) {
                GsmCdmaConnection cn = (GsmCdmaConnection)call.mConnections.get(i);
                if (cn.mDisconnected) continue;
                this.mMetrics.writeRilHangup(this.mPhone.getPhoneId(), cn, cn.getGsmCdmaIndex());
                this.mCi.hangupConnection(cn.getGsmCdmaIndex(), this.obtainCompleteMessage());
            }
        }
        catch (CallStateException ex) {
            Rlog.e(LOG_TAG, "hangupConnectionByIndex caught " + ex);
        }
    }

    public GsmCdmaConnection getConnectionByIndex(GsmCdmaCall call, int index) throws CallStateException {
        int count = call.mConnections.size();
        for (int i = 0; i < count; ++i) {
            GsmCdmaConnection cn = (GsmCdmaConnection)call.mConnections.get(i);
            if (cn.mDisconnected || cn.getGsmCdmaIndex() != index) continue;
            return cn;
        }
        return null;
    }

    private void notifyCallWaitingInfo(CdmaCallWaitingNotification obj) {
        if (this.mCallWaitingRegistrants != null) {
            this.mCallWaitingRegistrants.notifyRegistrants(new AsyncResult(null, obj, null));
        }
    }

    private void handleCallWaitingInfo(CdmaCallWaitingNotification cw) {
        new GsmCdmaConnection(this.mPhone.getContext(), cw, this, this.mRingingCall);
        this.updatePhoneState();
        this.notifyCallWaitingInfo(cw);
    }

    private PhoneInternalInterface.SuppService getFailedService(int what) {
        switch (what) {
            case 8: {
                return PhoneInternalInterface.SuppService.SWITCH;
            }
            case 11: {
                return PhoneInternalInterface.SuppService.CONFERENCE;
            }
            case 12: {
                return PhoneInternalInterface.SuppService.SEPARATE;
            }
            case 13: {
                return PhoneInternalInterface.SuppService.TRANSFER;
            }
        }
        return PhoneInternalInterface.SuppService.UNKNOWN;
    }

    @Override
    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 1: {
                Rlog.d(LOG_TAG, "Event EVENT_POLL_CALLS_RESULT Received");
                if (msg != this.mLastRelevantPoll) break;
                this.mNeedsPoll = false;
                this.mLastRelevantPoll = null;
                this.handlePollCalls((AsyncResult)msg.obj);
                break;
            }
            case 4: {
                this.operationComplete();
                break;
            }
            case 11: {
                Connection connection;
                if (this.isPhoneTypeGsm() && (connection = this.mForegroundCall.getLatestConnection()) != null) {
                    connection.onConferenceMergeFailed();
                }
            }
            case 8: 
            case 12: 
            case 13: {
                if (this.isPhoneTypeGsm()) {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    if (ar.exception != null) {
                        this.mPhone.notifySuppServiceFailed(this.getFailedService(msg.what));
                    }
                    this.operationComplete();
                    break;
                }
                if (msg.what == 8) break;
                throw new RuntimeException("unexpected event " + msg.what + " not handled by phone type " + this.mPhone.getPhoneType());
            }
            case 5: {
                int causeCode;
                String vendorCause = null;
                AsyncResult ar = (AsyncResult)msg.obj;
                this.operationComplete();
                if (ar.exception != null) {
                    causeCode = 16;
                    Rlog.i(LOG_TAG, "Exception during getLastCallFailCause, assuming normal disconnect");
                } else {
                    LastCallFailCause failCause = (LastCallFailCause)ar.result;
                    causeCode = failCause.causeCode;
                    vendorCause = failCause.vendorCause;
                }
                if (causeCode == 34 || causeCode == 41 || causeCode == 42 || causeCode == 44 || causeCode == 49 || causeCode == 58 || causeCode == 65535) {
                    CellLocation loc = this.mPhone.getCellLocation();
                    int cid = -1;
                    if (loc != null) {
                        cid = this.isPhoneTypeGsm() ? ((GsmCellLocation)loc).getCid() : ((CdmaCellLocation)loc).getBaseStationId();
                    }
                    EventLog.writeEvent(50106, causeCode, cid, TelephonyManager.getDefault().getNetworkType());
                }
                int s = this.mDroppedDuringPoll.size();
                for (int i = 0; i < s; ++i) {
                    GsmCdmaConnection conn = this.mDroppedDuringPoll.get(i);
                    conn.onRemoteDisconnect(causeCode, vendorCause);
                }
                this.updatePhoneState();
                this.mPhone.notifyPreciseCallStateChanged();
                this.mMetrics.writeRilCallList(this.mPhone.getPhoneId(), this.mDroppedDuringPoll);
                this.mDroppedDuringPoll.clear();
                break;
            }
            case 2: 
            case 3: {
                this.pollCallsWhenSafe();
                break;
            }
            case 9: {
                this.handleRadioAvailable();
                break;
            }
            case 10: {
                this.handleRadioNotAvailable();
                break;
            }
            case 14: {
                if (!this.isPhoneTypeGsm()) {
                    if (this.mPendingCallInEcm) {
                        this.mCi.dial(this.mPendingMO.getAddress(), this.mPendingCallClirMode, this.obtainCompleteMessage());
                        this.mPendingCallInEcm = false;
                    }
                    this.mPhone.unsetOnEcbModeExitResponse(this);
                    break;
                }
                throw new RuntimeException("unexpected event " + msg.what + " not handled by phone type " + this.mPhone.getPhoneType());
            }
            case 15: {
                if (!this.isPhoneTypeGsm()) {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    if (ar.exception != null) break;
                    this.handleCallWaitingInfo((CdmaCallWaitingNotification)ar.result);
                    Rlog.d(LOG_TAG, "Event EVENT_CALL_WAITING_INFO_CDMA Received");
                    break;
                }
                throw new RuntimeException("unexpected event " + msg.what + " not handled by phone type " + this.mPhone.getPhoneType());
            }
            case 16: {
                if (!this.isPhoneTypeGsm()) {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    if (ar.exception != null) break;
                    this.mPendingMO.onConnectedInOrOut();
                    this.mPendingMO = null;
                    break;
                }
                throw new RuntimeException("unexpected event " + msg.what + " not handled by phone type " + this.mPhone.getPhoneType());
            }
            case 20: {
                if (!this.isPhoneTypeGsm()) {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    if (ar.exception == null) {
                        this.postDelayed(new Runnable(){

                            @Override
                            public void run() {
                                if (GsmCdmaCallTracker.this.mPendingMO != null) {
                                    GsmCdmaCallTracker.this.mCi.sendCDMAFeatureCode(GsmCdmaCallTracker.this.mPendingMO.getAddress(), GsmCdmaCallTracker.this.obtainMessage(16));
                                }
                            }
                        }, this.m3WayCallFlashDelay);
                        break;
                    }
                    this.mPendingMO = null;
                    Rlog.w(LOG_TAG, "exception happened on Blank Flash for 3-way call");
                    break;
                }
                throw new RuntimeException("unexpected event " + msg.what + " not handled by phone type " + this.mPhone.getPhoneType());
            }
            default: {
                throw new RuntimeException("unexpected event " + msg.what + " not handled by phone type " + this.mPhone.getPhoneType());
            }
        }
    }

    private void checkAndEnableDataCallAfterEmergencyCallDropped() {
        if (this.mIsInEmergencyCall) {
            this.mIsInEmergencyCall = false;
            boolean inEcm = this.mPhone.isInEcm();
            this.log("checkAndEnableDataCallAfterEmergencyCallDropped,inEcm=" + inEcm);
            if (!inEcm) {
                this.mPhone.mDcTracker.setInternalDataEnabled(true);
                this.mPhone.notifyEmergencyCallRegistrants(false);
            }
            this.mPhone.sendEmergencyCallStateChange(false);
        }
    }

    private Connection checkMtFindNewRinging(DriverCall dc, int i) {
        GsmCdmaConnection newRinging = null;
        if (this.mConnections[i].getCall() == this.mRingingCall) {
            newRinging = this.mConnections[i];
            this.log("Notify new ring " + dc);
        } else {
            Rlog.e(LOG_TAG, "Phantom call appeared " + dc);
            if (dc.state != DriverCall.State.ALERTING && dc.state != DriverCall.State.DIALING) {
                this.mConnections[i].onConnectedInOrOut();
                if (dc.state == DriverCall.State.HOLDING) {
                    this.mConnections[i].onStartedHolding();
                }
            }
        }
        return newRinging;
    }

    public boolean isInEmergencyCall() {
        return this.mIsInEmergencyCall;
    }

    private boolean isPhoneTypeGsm() {
        return this.mPhone.getPhoneType() == 1;
    }

    public GsmCdmaPhone getPhone() {
        return this.mPhone;
    }

    @Override
    protected void log(String msg) {
        Rlog.d(LOG_TAG, "[GsmCdmaCallTracker] " + msg);
    }

    @Override
    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        int i;
        pw.println("GsmCdmaCallTracker extends:");
        super.dump(fd, pw, args);
        pw.println("mConnections: length=" + this.mConnections.length);
        for (i = 0; i < this.mConnections.length; ++i) {
            pw.printf("  mConnections[%d]=%s\n", i, this.mConnections[i]);
        }
        pw.println(" mVoiceCallEndedRegistrants=" + this.mVoiceCallEndedRegistrants);
        pw.println(" mVoiceCallStartedRegistrants=" + this.mVoiceCallStartedRegistrants);
        if (!this.isPhoneTypeGsm()) {
            pw.println(" mCallWaitingRegistrants=" + this.mCallWaitingRegistrants);
        }
        pw.println(" mDroppedDuringPoll: size=" + this.mDroppedDuringPoll.size());
        for (i = 0; i < this.mDroppedDuringPoll.size(); ++i) {
            pw.printf("  mDroppedDuringPoll[%d]=%s\n", i, this.mDroppedDuringPoll.get(i));
        }
        pw.println(" mRingingCall=" + this.mRingingCall);
        pw.println(" mForegroundCall=" + this.mForegroundCall);
        pw.println(" mBackgroundCall=" + this.mBackgroundCall);
        pw.println(" mPendingMO=" + this.mPendingMO);
        pw.println(" mHangupPendingMO=" + this.mHangupPendingMO);
        pw.println(" mPhone=" + this.mPhone);
        pw.println(" mDesiredMute=" + this.mDesiredMute);
        pw.println(" mState=" + (Object)((Object)this.mState));
        if (!this.isPhoneTypeGsm()) {
            pw.println(" mPendingCallInEcm=" + this.mPendingCallInEcm);
            pw.println(" mIsInEmergencyCall=" + this.mIsInEmergencyCall);
            pw.println(" mPendingCallClirMode=" + this.mPendingCallClirMode);
            pw.println(" mIsEcmTimerCanceled=" + this.mIsEcmTimerCanceled);
        }
    }

    @Override
    public PhoneConstants.State getState() {
        return this.mState;
    }

    public int getMaxConnectionsPerCall() {
        return this.mPhone.isPhoneTypeGsm() ? 5 : 1;
    }

    @Override
    public void cleanupCalls() {
        this.pollCallsWhenSafe();
    }
}

