/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.os.Handler;
import android.os.Looper;

public class ExponentialBackoff {
    private int mRetryCounter = 0;
    private long mStartDelayMs;
    private long mMaximumDelayMs;
    private long mCurrentDelayMs;
    private int mMultiplier;
    private Runnable mRunnable;
    private Handler mHandler;

    public ExponentialBackoff(long initialDelayMs, long maximumDelayMs, int multiplier, Looper looper, Runnable runnable) {
        this(initialDelayMs, maximumDelayMs, multiplier, new Handler(looper), runnable);
    }

    public ExponentialBackoff(long initialDelayMs, long maximumDelayMs, int multiplier, Handler handler, Runnable runnable) {
        this.mStartDelayMs = initialDelayMs;
        this.mMaximumDelayMs = maximumDelayMs;
        this.mMultiplier = multiplier;
        this.mHandler = handler;
        this.mRunnable = runnable;
    }

    public void start() {
        this.mRetryCounter = 0;
        this.mCurrentDelayMs = this.mStartDelayMs;
        this.mHandler.removeCallbacks(this.mRunnable);
        this.mHandler.postDelayed(this.mRunnable, this.mCurrentDelayMs);
    }

    public void stop() {
        this.mRetryCounter = 0;
        this.mHandler.removeCallbacks(this.mRunnable);
    }

    public void notifyFailed() {
        ++this.mRetryCounter;
        long temp = Math.min(this.mMaximumDelayMs, (long)((double)this.mStartDelayMs * Math.pow(this.mMultiplier, this.mRetryCounter)));
        this.mCurrentDelayMs = (long)((1.0 + Math.random()) / 2.0 * (double)temp);
        this.mHandler.removeCallbacks(this.mRunnable);
        this.mHandler.postDelayed(this.mRunnable, this.mCurrentDelayMs);
    }

    public long getCurrentDelay() {
        return this.mCurrentDelayMs;
    }
}

