/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.display.DisplayManager;
import android.os.BatteryManager;
import android.os.Handler;
import android.os.Message;
import android.os.PowerManager;
import android.util.LocalLog;
import android.view.Display;
import com.android.internal.telephony.Phone;
import com.android.internal.util.IndentingPrintWriter;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;

public class DeviceStateMonitor
extends Handler {
    protected static final boolean DBG = false;
    protected static final String TAG = DeviceStateMonitor.class.getSimpleName();
    private static final int EVENT_RIL_CONNECTED = 0;
    private static final int EVENT_SCREEN_STATE_CHANGED = 1;
    private static final int EVENT_POWER_SAVE_MODE_CHANGED = 2;
    private static final int EVENT_CHARGING_STATE_CHANGED = 3;
    private static final int EVENT_TETHERING_STATE_CHANGED = 4;
    private final Phone mPhone;
    private final LocalLog mLocalLog = new LocalLog(100);
    private boolean mIsTetheringOn;
    private boolean mIsScreenOn;
    private boolean mIsCharging;
    private boolean mIsPowerSaveOn;
    private boolean mIsLowDataExpected;
    private int mUnsolicitedResponseFilter = 7;
    private final DisplayManager.DisplayListener mDisplayListener = new DisplayManager.DisplayListener(){

        @Override
        public void onDisplayAdded(int displayId) {
        }

        @Override
        public void onDisplayRemoved(int displayId) {
        }

        @Override
        public void onDisplayChanged(int displayId) {
            boolean screenOn = DeviceStateMonitor.this.isScreenOn();
            Message msg = DeviceStateMonitor.this.obtainMessage(1);
            msg.arg1 = screenOn ? 1 : 0;
            DeviceStateMonitor.this.sendMessage(msg);
        }
    };
    private final BroadcastReceiver mBroadcastReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            Message msg;
            DeviceStateMonitor.this.log("received: " + intent, true);
            switch (intent.getAction()) {
                case "android.os.action.POWER_SAVE_MODE_CHANGED": {
                    msg = DeviceStateMonitor.this.obtainMessage(2);
                    msg.arg1 = DeviceStateMonitor.this.isPowerSaveModeOn() ? 1 : 0;
                    DeviceStateMonitor.this.log("Power Save mode " + (msg.arg1 == 1 ? "on" : "off"), true);
                    break;
                }
                case "android.os.action.CHARGING": {
                    msg = DeviceStateMonitor.this.obtainMessage(3);
                    msg.arg1 = 1;
                    break;
                }
                case "android.os.action.DISCHARGING": {
                    msg = DeviceStateMonitor.this.obtainMessage(3);
                    msg.arg1 = 0;
                    break;
                }
                case "android.net.conn.TETHER_STATE_CHANGED": {
                    ArrayList<String> activeTetherIfaces = intent.getStringArrayListExtra("tetherArray");
                    boolean isTetheringOn = activeTetherIfaces != null && activeTetherIfaces.size() > 0;
                    DeviceStateMonitor.this.log("Tethering " + (isTetheringOn ? "on" : "off"), true);
                    msg = DeviceStateMonitor.this.obtainMessage(4);
                    msg.arg1 = isTetheringOn ? 1 : 0;
                    break;
                }
                default: {
                    DeviceStateMonitor.this.log("Unexpected broadcast intent: " + intent, false);
                    return;
                }
            }
            DeviceStateMonitor.this.sendMessage(msg);
        }
    };

    public DeviceStateMonitor(Phone phone) {
        this.mPhone = phone;
        DisplayManager dm = (DisplayManager)phone.getContext().getSystemService("display");
        dm.registerDisplayListener(this.mDisplayListener, null);
        this.mIsPowerSaveOn = this.isPowerSaveModeOn();
        this.mIsCharging = this.isDeviceCharging();
        this.mIsScreenOn = this.isScreenOn();
        this.mIsTetheringOn = false;
        this.mIsLowDataExpected = false;
        this.log("DeviceStateMonitor mIsPowerSaveOn=" + this.mIsPowerSaveOn + ",mIsScreenOn=" + this.mIsScreenOn + ",mIsCharging=" + this.mIsCharging, false);
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.os.action.POWER_SAVE_MODE_CHANGED");
        filter.addAction("android.os.action.CHARGING");
        filter.addAction("android.os.action.DISCHARGING");
        filter.addAction("android.net.conn.TETHER_STATE_CHANGED");
        this.mPhone.getContext().registerReceiver(this.mBroadcastReceiver, filter, null, this.mPhone);
        this.mPhone.mCi.registerForRilConnected(this, 0, null);
    }

    private boolean isLowDataExpected() {
        return this.mIsPowerSaveOn || !this.mIsCharging && !this.mIsTetheringOn && !this.mIsScreenOn;
    }

    private boolean shouldTurnOffSignalStrength() {
        return this.mIsPowerSaveOn || !this.mIsCharging && !this.mIsScreenOn;
    }

    private boolean shouldTurnOffFullNetworkUpdate() {
        return this.mIsPowerSaveOn || !this.mIsCharging && !this.mIsScreenOn && !this.mIsTetheringOn;
    }

    private boolean shouldTurnOffDormancyUpdate() {
        return this.mIsPowerSaveOn || !this.mIsCharging && !this.mIsTetheringOn && !this.mIsScreenOn;
    }

    @Override
    public void handleMessage(Message msg) {
        this.log("handleMessage msg=" + msg, false);
        switch (msg.what) {
            case 0: {
                this.onRilConnected();
                break;
            }
            default: {
                this.updateDeviceState(msg.what, msg.arg1 != 0);
            }
        }
    }

    private void updateDeviceState(int eventType, boolean state) {
        switch (eventType) {
            case 1: {
                if (this.mIsScreenOn == state) {
                    return;
                }
                this.mIsScreenOn = state;
                break;
            }
            case 3: {
                if (this.mIsCharging == state) {
                    return;
                }
                this.mIsCharging = state;
                this.sendDeviceState(1, this.mIsCharging);
                break;
            }
            case 4: {
                if (this.mIsTetheringOn == state) {
                    return;
                }
                this.mIsTetheringOn = state;
                break;
            }
            case 2: {
                if (this.mIsPowerSaveOn == state) {
                    return;
                }
                this.mIsPowerSaveOn = state;
                this.sendDeviceState(0, this.mIsPowerSaveOn);
                break;
            }
            default: {
                return;
            }
        }
        if (this.mIsLowDataExpected != this.isLowDataExpected()) {
            this.mIsLowDataExpected = !this.mIsLowDataExpected;
            this.sendDeviceState(2, this.mIsLowDataExpected);
        }
        int newFilter = 0;
        if (!this.shouldTurnOffSignalStrength()) {
            newFilter |= 1;
        }
        if (!this.shouldTurnOffFullNetworkUpdate()) {
            newFilter |= 2;
        }
        if (!this.shouldTurnOffDormancyUpdate()) {
            newFilter |= 4;
        }
        this.setUnsolResponseFilter(newFilter, false);
    }

    private void onRilConnected() {
        this.log("RIL connected.", true);
        this.sendDeviceState(1, this.mIsCharging);
        this.sendDeviceState(2, this.mIsLowDataExpected);
        this.sendDeviceState(0, this.mIsPowerSaveOn);
        this.setUnsolResponseFilter(this.mUnsolicitedResponseFilter, true);
    }

    private String deviceTypeToString(int type) {
        switch (type) {
            case 1: {
                return "CHARGING_STATE";
            }
            case 2: {
                return "LOW_DATA_EXPECTED";
            }
            case 0: {
                return "POWER_SAVE_MODE";
            }
        }
        return "UNKNOWN";
    }

    private void sendDeviceState(int type, boolean state) {
        this.log("send type: " + this.deviceTypeToString(type) + ", state=" + state, true);
        this.mPhone.mCi.sendDeviceState(type, state, null);
    }

    private void setUnsolResponseFilter(int newFilter, boolean force) {
        if (force || newFilter != this.mUnsolicitedResponseFilter) {
            this.log("old filter: " + this.mUnsolicitedResponseFilter + ", new filter: " + newFilter, true);
            this.mPhone.mCi.setUnsolResponseFilter(newFilter, null);
            this.mUnsolicitedResponseFilter = newFilter;
        }
    }

    private boolean isPowerSaveModeOn() {
        PowerManager pm = (PowerManager)this.mPhone.getContext().getSystemService("power");
        return pm.isPowerSaveMode();
    }

    private boolean isDeviceCharging() {
        BatteryManager bm = (BatteryManager)this.mPhone.getContext().getSystemService("batterymanager");
        return bm.isCharging();
    }

    private boolean isScreenOn() {
        DisplayManager dm = (DisplayManager)this.mPhone.getContext().getSystemService("display");
        Display[] displays = dm.getDisplays();
        if (displays != null) {
            for (Display display : displays) {
                if (display.getState() != 2) continue;
                this.log("Screen " + Display.typeToString(display.getType()) + " on", true);
                return true;
            }
            this.log("Screens all off", true);
            return false;
        }
        this.log("No displays found", true);
        return false;
    }

    private void log(String msg, boolean logIntoLocalLog) {
        if (logIntoLocalLog) {
            this.mLocalLog.log(msg);
        }
    }

    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        IndentingPrintWriter ipw = new IndentingPrintWriter((Writer)pw, "  ");
        ipw.increaseIndent();
        ipw.println("mIsTetheringOn=" + this.mIsTetheringOn);
        ipw.println("mIsScreenOn=" + this.mIsScreenOn);
        ipw.println("mIsCharging=" + this.mIsCharging);
        ipw.println("mIsPowerSaveOn=" + this.mIsPowerSaveOn);
        ipw.println("mIsLowDataExpected=" + this.mIsLowDataExpected);
        ipw.println("mUnsolicitedResponseFilter=" + this.mUnsolicitedResponseFilter);
        ipw.println("Local logs:");
        ipw.increaseIndent();
        this.mLocalLog.dump(fd, ipw, args);
        ipw.decreaseIndent();
        ipw.decreaseIndent();
        ipw.flush();
    }
}

