/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.net.Uri;
import android.os.Bundle;
import android.os.SystemClock;
import android.telecom.ConferenceParticipant;
import android.telecom.Connection;
import android.telephony.Rlog;
import com.android.internal.telephony.Call;
import com.android.internal.telephony.CallStateException;
import com.android.internal.telephony.UUSInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

public abstract class Connection {
    public static final int AUDIO_QUALITY_STANDARD = 1;
    public static final int AUDIO_QUALITY_HIGH_DEFINITION = 2;
    private String mTelecomCallId;
    protected String mCnapName;
    protected int mCnapNamePresentation = 1;
    protected String mAddress;
    protected String mDialString;
    protected int mNumberPresentation = 1;
    protected boolean mIsIncoming;
    protected long mCreateTime;
    protected long mConnectTime;
    protected long mConnectTimeReal;
    protected long mDuration;
    protected long mHoldingStartTime;
    protected Connection mOrigConnection;
    private List<PostDialListener> mPostDialListeners = new ArrayList<PostDialListener>();
    public Set<Listener> mListeners = new CopyOnWriteArraySet<Listener>();
    protected boolean mNumberConverted = false;
    protected String mConvertedNumber;
    protected String mPostDialString;
    protected int mNextPostDialChar;
    protected int mCause = 0;
    protected PostDialState mPostDialState = PostDialState.NOT_STARTED;
    private static String LOG_TAG = "Connection";
    Object mUserData;
    private int mVideoState;
    private int mConnectionCapabilities;
    private boolean mIsWifi;
    private boolean mAudioModeIsVoip;
    private int mAudioQuality;
    private int mCallSubstate;
    private Connection.VideoProvider mVideoProvider;
    public Call.State mPreHandoverState = Call.State.IDLE;
    private Bundle mExtras;
    private int mPhoneType;
    private boolean mAnsweringDisconnectsActiveCall;
    private boolean mAllowAddCallDuringVideoCall;
    private boolean mIsPulledCall = false;
    private int mPulledDialogId;

    protected Connection(int phoneType) {
        this.mPhoneType = phoneType;
    }

    public String getTelecomCallId() {
        return this.mTelecomCallId;
    }

    public void setTelecomCallId(String telecomCallId) {
        this.mTelecomCallId = telecomCallId;
    }

    public String getAddress() {
        return this.mAddress;
    }

    public String getCnapName() {
        return this.mCnapName;
    }

    public String getOrigDialString() {
        return null;
    }

    public int getCnapNamePresentation() {
        return this.mCnapNamePresentation;
    }

    public abstract Call getCall();

    public long getCreateTime() {
        return this.mCreateTime;
    }

    public long getConnectTime() {
        return this.mConnectTime;
    }

    public void setConnectTime(long connectTime) {
        this.mConnectTime = connectTime;
    }

    public void setConnectTimeReal(long connectTimeReal) {
        this.mConnectTimeReal = connectTimeReal;
    }

    public long getConnectTimeReal() {
        return this.mConnectTimeReal;
    }

    public abstract long getDisconnectTime();

    public long getDurationMillis() {
        if (this.mConnectTimeReal == 0L) {
            return 0L;
        }
        if (this.mDuration == 0L) {
            return SystemClock.elapsedRealtime() - this.mConnectTimeReal;
        }
        return this.mDuration;
    }

    public long getHoldingStartTime() {
        return this.mHoldingStartTime;
    }

    public abstract long getHoldDurationMillis();

    public int getDisconnectCause() {
        return this.mCause;
    }

    public abstract String getVendorDisconnectCause();

    public boolean isIncoming() {
        return this.mIsIncoming;
    }

    public void setIsIncoming(boolean isIncoming) {
        this.mIsIncoming = isIncoming;
    }

    public Call.State getState() {
        Call c = this.getCall();
        if (c == null) {
            return Call.State.IDLE;
        }
        return c.getState();
    }

    public Call.State getStateBeforeHandover() {
        return this.mPreHandoverState;
    }

    public List<ConferenceParticipant> getConferenceParticipants() {
        Call c = this.getCall();
        if (c == null) {
            return null;
        }
        return c.getConferenceParticipants();
    }

    public boolean isAlive() {
        return this.getState().isAlive();
    }

    public boolean isRinging() {
        return this.getState().isRinging();
    }

    public Object getUserData() {
        return this.mUserData;
    }

    public void setUserData(Object userdata) {
        this.mUserData = userdata;
    }

    public abstract void hangup() throws CallStateException;

    public abstract void separate() throws CallStateException;

    public void clearUserData() {
        this.mUserData = null;
    }

    public final void addPostDialListener(PostDialListener listener) {
        if (!this.mPostDialListeners.contains(listener)) {
            this.mPostDialListeners.add(listener);
        }
    }

    public final void removePostDialListener(PostDialListener listener) {
        this.mPostDialListeners.remove(listener);
    }

    protected final void clearPostDialListeners() {
        if (this.mPostDialListeners != null) {
            this.mPostDialListeners.clear();
        }
    }

    protected final void notifyPostDialListeners() {
        if (this.getPostDialState() == PostDialState.WAIT) {
            for (PostDialListener listener : new ArrayList<PostDialListener>(this.mPostDialListeners)) {
                listener.onPostDialWait();
            }
        }
    }

    protected final void notifyPostDialListenersNextChar(char c) {
        for (PostDialListener listener : new ArrayList<PostDialListener>(this.mPostDialListeners)) {
            listener.onPostDialChar(c);
        }
    }

    public PostDialState getPostDialState() {
        return this.mPostDialState;
    }

    public String getRemainingPostDialString() {
        if (this.mPostDialState == PostDialState.CANCELLED || this.mPostDialState == PostDialState.COMPLETE || this.mPostDialString == null || this.mPostDialString.length() <= this.mNextPostDialChar) {
            return "";
        }
        return this.mPostDialString.substring(this.mNextPostDialChar);
    }

    public abstract void proceedAfterWaitChar();

    public abstract void proceedAfterWildChar(String var1);

    public abstract void cancelPostDial();

    public boolean onDisconnect(int cause) {
        return false;
    }

    public abstract int getNumberPresentation();

    public abstract UUSInfo getUUSInfo();

    public abstract int getPreciseDisconnectCause();

    public Connection getOrigConnection() {
        return this.mOrigConnection;
    }

    public abstract boolean isMultiparty();

    public boolean isConferenceHost() {
        return false;
    }

    public boolean isMemberOfPeerConference() {
        return false;
    }

    public void migrateFrom(Connection c) {
        if (c == null) {
            return;
        }
        this.mListeners = c.mListeners;
        this.mDialString = c.getOrigDialString();
        this.mCreateTime = c.getCreateTime();
        this.mConnectTime = c.getConnectTime();
        this.mConnectTimeReal = c.getConnectTimeReal();
        this.mHoldingStartTime = c.getHoldingStartTime();
        this.mOrigConnection = c.getOrigConnection();
        this.mPostDialString = c.mPostDialString;
        this.mNextPostDialChar = c.mNextPostDialChar;
        this.mPostDialState = c.mPostDialState;
    }

    public final void addListener(Listener listener) {
        this.mListeners.add(listener);
    }

    public final void removeListener(Listener listener) {
        this.mListeners.remove(listener);
    }

    public int getVideoState() {
        return this.mVideoState;
    }

    public int getConnectionCapabilities() {
        return this.mConnectionCapabilities;
    }

    public boolean hasCapabilities(int connectionCapabilities) {
        return (this.mConnectionCapabilities & connectionCapabilities) == connectionCapabilities;
    }

    public static int addCapability(int capabilities, int capability) {
        return capabilities | capability;
    }

    public static int removeCapability(int capabilities, int capability) {
        return capabilities & ~capability;
    }

    public boolean isWifi() {
        return this.mIsWifi;
    }

    public boolean getAudioModeIsVoip() {
        return this.mAudioModeIsVoip;
    }

    public Connection.VideoProvider getVideoProvider() {
        return this.mVideoProvider;
    }

    public int getAudioQuality() {
        return this.mAudioQuality;
    }

    public int getCallSubstate() {
        return this.mCallSubstate;
    }

    public void setVideoState(int videoState) {
        this.mVideoState = videoState;
        for (Listener l : this.mListeners) {
            l.onVideoStateChanged(this.mVideoState);
        }
    }

    public void setConnectionCapabilities(int capabilities) {
        if (this.mConnectionCapabilities != capabilities) {
            this.mConnectionCapabilities = capabilities;
            for (Listener l : this.mListeners) {
                l.onConnectionCapabilitiesChanged(this.mConnectionCapabilities);
            }
        }
    }

    public void setWifi(boolean isWifi) {
        this.mIsWifi = isWifi;
        for (Listener l : this.mListeners) {
            l.onWifiChanged(this.mIsWifi);
        }
    }

    public void setAudioModeIsVoip(boolean isVoip) {
        this.mAudioModeIsVoip = isVoip;
    }

    public void setAudioQuality(int audioQuality) {
        this.mAudioQuality = audioQuality;
        for (Listener l : this.mListeners) {
            l.onAudioQualityChanged(this.mAudioQuality);
        }
    }

    public void setConnectionExtras(Bundle extras) {
        this.mExtras = extras != null ? new Bundle(extras) : null;
        for (Listener l : this.mListeners) {
            l.onExtrasChanged(this.mExtras);
        }
    }

    public Bundle getConnectionExtras() {
        return this.mExtras == null ? null : new Bundle(this.mExtras);
    }

    public boolean isActiveCallDisconnectedOnAnswer() {
        return this.mAnsweringDisconnectsActiveCall;
    }

    public void setActiveCallDisconnectedOnAnswer(boolean answeringDisconnectsActiveCall) {
        this.mAnsweringDisconnectsActiveCall = answeringDisconnectsActiveCall;
    }

    public boolean shouldAllowAddCallDuringVideoCall() {
        return this.mAllowAddCallDuringVideoCall;
    }

    public void setAllowAddCallDuringVideoCall(boolean allowAddCallDuringVideoCall) {
        this.mAllowAddCallDuringVideoCall = allowAddCallDuringVideoCall;
    }

    public void setIsPulledCall(boolean isPulledCall) {
        this.mIsPulledCall = isPulledCall;
    }

    public boolean isPulledCall() {
        return this.mIsPulledCall;
    }

    public void setPulledDialogId(int pulledDialogId) {
        this.mPulledDialogId = pulledDialogId;
    }

    public int getPulledDialogId() {
        return this.mPulledDialogId;
    }

    public void setCallSubstate(int callSubstate) {
        this.mCallSubstate = callSubstate;
        for (Listener l : this.mListeners) {
            l.onCallSubstateChanged(this.mCallSubstate);
        }
    }

    public void setVideoProvider(Connection.VideoProvider videoProvider) {
        this.mVideoProvider = videoProvider;
        for (Listener l : this.mListeners) {
            l.onVideoProviderChanged(this.mVideoProvider);
        }
    }

    public void setConverted(String oriNumber) {
        this.mNumberConverted = true;
        this.mConvertedNumber = this.mAddress;
        this.mAddress = oriNumber;
        this.mDialString = oriNumber;
    }

    public void updateConferenceParticipants(List<ConferenceParticipant> conferenceParticipants) {
        for (Listener l : this.mListeners) {
            l.onConferenceParticipantsChanged(conferenceParticipants);
        }
    }

    public void updateMultipartyState(boolean isMultiparty) {
        for (Listener l : this.mListeners) {
            l.onMultipartyStateChanged(isMultiparty);
        }
    }

    public void onConferenceMergeFailed() {
        for (Listener l : this.mListeners) {
            l.onConferenceMergedFailed();
        }
    }

    public void onExitedEcmMode() {
        for (Listener l : this.mListeners) {
            l.onExitedEcmMode();
        }
    }

    public void onCallPullFailed(Connection externalConnection) {
        for (Listener l : this.mListeners) {
            l.onCallPullFailed(externalConnection);
        }
    }

    public void onHandoverToWifiFailed() {
        for (Listener l : this.mListeners) {
            l.onHandoverToWifiFailed();
        }
    }

    public void onConnectionEvent(String event, Bundle extras) {
        for (Listener l : this.mListeners) {
            l.onConnectionEvent(event, extras);
        }
    }

    public void onDisconnectConferenceParticipant(Uri endpoint) {
    }

    public void pullExternalCall() {
    }

    public void onRttModifyRequestReceived() {
        for (Listener l : this.mListeners) {
            l.onRttModifyRequestReceived();
        }
    }

    public void onRttModifyResponseReceived(int status) {
        for (Listener l : this.mListeners) {
            l.onRttModifyResponseReceived(status);
        }
    }

    public int getPhoneType() {
        return this.mPhoneType;
    }

    public String toString() {
        StringBuilder str = new StringBuilder(128);
        str.append(" callId: " + this.getTelecomCallId());
        str.append(" isExternal: " + ((this.mConnectionCapabilities & 0x10) == 16 ? "Y" : "N"));
        if (Rlog.isLoggable(LOG_TAG, 3)) {
            str.append("addr: " + this.getAddress()).append(" pres.: " + this.getNumberPresentation()).append(" dial: " + this.getOrigDialString()).append(" postdial: " + this.getRemainingPostDialString()).append(" cnap name: " + this.getCnapName()).append("(" + this.getCnapNamePresentation() + ")");
        }
        str.append(" incoming: " + this.isIncoming()).append(" state: " + (Object)((Object)this.getState())).append(" post dial state: " + (Object)((Object)this.getPostDialState()));
        return str.toString();
    }

    public static enum PostDialState {
        NOT_STARTED,
        STARTED,
        WAIT,
        WILD,
        COMPLETE,
        CANCELLED,
        PAUSE;

    }

    public static abstract class ListenerBase
    implements Listener {
        @Override
        public void onVideoStateChanged(int videoState) {
        }

        @Override
        public void onConnectionCapabilitiesChanged(int capability) {
        }

        @Override
        public void onWifiChanged(boolean isWifi) {
        }

        @Override
        public void onVideoProviderChanged(Connection.VideoProvider videoProvider) {
        }

        @Override
        public void onAudioQualityChanged(int audioQuality) {
        }

        @Override
        public void onConferenceParticipantsChanged(List<ConferenceParticipant> participants) {
        }

        @Override
        public void onCallSubstateChanged(int callSubstate) {
        }

        @Override
        public void onMultipartyStateChanged(boolean isMultiParty) {
        }

        @Override
        public void onConferenceMergedFailed() {
        }

        @Override
        public void onExtrasChanged(Bundle extras) {
        }

        @Override
        public void onExitedEcmMode() {
        }

        @Override
        public void onCallPullFailed(Connection externalConnection) {
        }

        @Override
        public void onHandoverToWifiFailed() {
        }

        @Override
        public void onConnectionEvent(String event, Bundle extras) {
        }

        @Override
        public void onRttModifyRequestReceived() {
        }

        @Override
        public void onRttModifyResponseReceived(int status) {
        }
    }

    public static interface Listener {
        public void onVideoStateChanged(int var1);

        public void onConnectionCapabilitiesChanged(int var1);

        public void onWifiChanged(boolean var1);

        public void onVideoProviderChanged(Connection.VideoProvider var1);

        public void onAudioQualityChanged(int var1);

        public void onConferenceParticipantsChanged(List<ConferenceParticipant> var1);

        public void onCallSubstateChanged(int var1);

        public void onMultipartyStateChanged(boolean var1);

        public void onConferenceMergedFailed();

        public void onExtrasChanged(Bundle var1);

        public void onExitedEcmMode();

        public void onCallPullFailed(Connection var1);

        public void onHandoverToWifiFailed();

        public void onConnectionEvent(String var1, Bundle var2);

        public void onRttModifyRequestReceived();

        public void onRttModifyResponseReceived(int var1);
    }

    public static class Capability {
        public static final int SUPPORTS_DOWNGRADE_TO_VOICE_LOCAL = 1;
        public static final int SUPPORTS_DOWNGRADE_TO_VOICE_REMOTE = 2;
        public static final int SUPPORTS_VT_LOCAL_BIDIRECTIONAL = 4;
        public static final int SUPPORTS_VT_REMOTE_BIDIRECTIONAL = 8;
        public static final int IS_EXTERNAL_CONNECTION = 16;
        public static final int IS_PULLABLE = 32;
    }

    public static interface PostDialListener {
        public void onPostDialWait();

        public void onPostDialChar(char var1);
    }
}

