/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.policy;

import android.app.ActivityManager;
import android.app.KeyguardManager;
import android.app.SearchManager;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.media.AudioManager;
import android.media.session.MediaController;
import android.media.session.MediaSessionLegacyHelper;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.UserHandle;
import android.provider.Settings;
import android.text.TextUtils;
import android.transition.Scene;
import android.transition.Transition;
import android.transition.TransitionInflater;
import android.transition.TransitionManager;
import android.transition.TransitionSet;
import android.util.AndroidRuntimeException;
import android.util.EventLog;
import android.util.Log;
import android.util.SparseArray;
import android.util.TypedValue;
import android.view.ContextThemeWrapper;
import android.view.IRotationWatcher;
import android.view.IWindowManager;
import android.view.InputDevice;
import android.view.InputEvent;
import android.view.InputQueue;
import android.view.KeyCharacterMap;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.SearchEvent;
import android.view.SurfaceHolder;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewRootImpl;
import android.view.Window;
import android.view.WindowManager;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.android.internal.R;
import com.android.internal.policy.DecorContext;
import com.android.internal.policy.DecorView;
import com.android.internal.view.menu.ContextMenuBuilder;
import com.android.internal.view.menu.IconMenuPresenter;
import com.android.internal.view.menu.ListMenuPresenter;
import com.android.internal.view.menu.MenuBuilder;
import com.android.internal.view.menu.MenuDialogHelper;
import com.android.internal.view.menu.MenuHelper;
import com.android.internal.view.menu.MenuPresenter;
import com.android.internal.view.menu.MenuView;
import com.android.internal.widget.DecorContentParent;
import com.android.internal.widget.SwipeDismissLayout;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

public class PhoneWindow
extends Window
implements MenuBuilder.Callback {
    private static final String TAG = "PhoneWindow";
    private static final boolean DEBUG = false;
    private static final int DEFAULT_BACKGROUND_FADE_DURATION_MS = 300;
    private static final int CUSTOM_TITLE_COMPATIBLE_FEATURES = 13505;
    private static final Transition USE_DEFAULT_TRANSITION = new TransitionSet();
    final PhoneWindowMenuCallback mContextMenuCallback = new PhoneWindowMenuCallback(this);
    final TypedValue mMinWidthMajor = new TypedValue();
    final TypedValue mMinWidthMinor = new TypedValue();
    TypedValue mFixedWidthMajor;
    TypedValue mFixedWidthMinor;
    TypedValue mFixedHeightMajor;
    TypedValue mFixedHeightMinor;
    private DecorView mDecor;
    private boolean mForceDecorInstall = false;
    ViewGroup mContentParent;
    private boolean mContentParentExplicitlySet = false;
    SurfaceHolder.Callback2 mTakeSurfaceCallback;
    InputQueue.Callback mTakeInputQueueCallback;
    boolean mIsFloating;
    private boolean mIsTranslucent;
    private LayoutInflater mLayoutInflater;
    private TextView mTitleView;
    DecorContentParent mDecorContentParent;
    private ActionMenuPresenterCallback mActionMenuPresenterCallback;
    private PanelMenuPresenterCallback mPanelMenuPresenterCallback;
    private TransitionManager mTransitionManager;
    private Scene mContentScene;
    static final int FLAG_RESOURCE_SET_ICON = 1;
    static final int FLAG_RESOURCE_SET_LOGO = 2;
    static final int FLAG_RESOURCE_SET_ICON_FALLBACK = 4;
    int mResourcesSetFlags;
    int mIconRes;
    int mLogoRes;
    private DrawableFeatureState[] mDrawables;
    private PanelFeatureState[] mPanels;
    PanelFeatureState mPreparedPanel;
    int mPanelChordingKey;
    private boolean mSupportsPictureInPicture;
    private ImageView mLeftIconView;
    private ImageView mRightIconView;
    private ProgressBar mCircularProgressBar;
    private ProgressBar mHorizontalProgressBar;
    int mBackgroundResource = 0;
    int mBackgroundFallbackResource = 0;
    private Drawable mBackgroundDrawable;
    private boolean mLoadElevation = true;
    private float mElevation;
    private boolean mClipToOutline;
    private int mFrameResource = 0;
    private int mTextColor = 0;
    int mStatusBarColor = 0;
    int mNavigationBarColor = 0;
    int mNavigationBarDividerColor = 0;
    private boolean mForcedStatusBarColor = false;
    private boolean mForcedNavigationBarColor = false;
    private CharSequence mTitle = null;
    private int mTitleColor = 0;
    private boolean mAlwaysReadCloseOnTouchAttr = false;
    ContextMenuBuilder mContextMenu;
    MenuHelper mContextMenuHelper;
    private boolean mClosingActionMenu;
    private int mVolumeControlStreamType = Integer.MIN_VALUE;
    private MediaController mMediaController;
    private AudioManager mAudioManager;
    private KeyguardManager mKeyguardManager;
    private int mUiOptions = 0;
    private boolean mInvalidatePanelMenuPosted;
    private int mInvalidatePanelMenuFeatures;
    private final Runnable mInvalidatePanelMenuRunnable = new Runnable(){

        @Override
        public void run() {
            for (int i = 0; i <= 13; ++i) {
                if ((PhoneWindow.this.mInvalidatePanelMenuFeatures & 1 << i) == 0) continue;
                PhoneWindow.this.doInvalidatePanelMenu(i);
            }
            PhoneWindow.this.mInvalidatePanelMenuPosted = false;
            PhoneWindow.this.mInvalidatePanelMenuFeatures = 0;
        }
    };
    private Transition mEnterTransition = null;
    private Transition mReturnTransition = USE_DEFAULT_TRANSITION;
    private Transition mExitTransition = null;
    private Transition mReenterTransition = USE_DEFAULT_TRANSITION;
    private Transition mSharedElementEnterTransition = null;
    private Transition mSharedElementReturnTransition = USE_DEFAULT_TRANSITION;
    private Transition mSharedElementExitTransition = null;
    private Transition mSharedElementReenterTransition = USE_DEFAULT_TRANSITION;
    private Boolean mAllowReturnTransitionOverlap;
    private Boolean mAllowEnterTransitionOverlap;
    private long mBackgroundFadeDurationMillis = -1L;
    private Boolean mSharedElementsUseOverlay;
    private boolean mIsStartingWindow;
    private int mTheme = -1;
    private int mDecorCaptionShade = 0;
    private boolean mUseDecorContext = false;
    private ViewRootImpl.ActivityConfigCallback mActivityConfigCallback;
    static final RotationWatcher sRotationWatcher = new RotationWatcher();
    private static final String FOCUSED_ID_TAG = "android:focusedViewId";
    private static final String VIEWS_TAG = "android:views";
    private static final String PANELS_TAG = "android:Panels";
    private static final String ACTION_BAR_TAG = "android:ActionBar";

    public PhoneWindow(Context context) {
        super(context);
        this.mLayoutInflater = LayoutInflater.from(context);
    }

    public PhoneWindow(Context context, Window preservedWindow, ViewRootImpl.ActivityConfigCallback activityConfigCallback) {
        this(context);
        this.mUseDecorContext = true;
        if (preservedWindow != null) {
            this.mDecor = (DecorView)preservedWindow.getDecorView();
            this.mElevation = preservedWindow.getElevation();
            this.mLoadElevation = false;
            this.mForceDecorInstall = true;
            this.getAttributes().token = preservedWindow.getAttributes().token;
        }
        boolean forceResizable = Settings.Global.getInt(context.getContentResolver(), "force_resizable_activities", 0) != 0;
        this.mSupportsPictureInPicture = forceResizable || context.getPackageManager().hasSystemFeature("android.software.picture_in_picture");
        this.mActivityConfigCallback = activityConfigCallback;
    }

    @Override
    public final void setContainer(Window container) {
        super.setContainer(container);
    }

    @Override
    public boolean requestFeature(int featureId) {
        if (this.mContentParentExplicitlySet) {
            throw new AndroidRuntimeException("requestFeature() must be called before adding content");
        }
        int features = this.getFeatures();
        int newFeatures = features | 1 << featureId;
        if ((newFeatures & 0x80) != 0 && (newFeatures & 0xFFFFCB3E) != 0) {
            throw new AndroidRuntimeException("You cannot combine custom titles with other title features");
        }
        if ((features & 2) != 0 && featureId == 8) {
            return false;
        }
        if ((features & 0x100) != 0 && featureId == 1) {
            this.removeFeature(8);
        }
        if ((features & 0x100) != 0 && featureId == 11) {
            throw new AndroidRuntimeException("You cannot combine swipe dismissal and the action bar.");
        }
        if ((features & 0x800) != 0 && featureId == 8) {
            throw new AndroidRuntimeException("You cannot combine swipe dismissal and the action bar.");
        }
        if (featureId == 5 && this.getContext().getPackageManager().hasSystemFeature("android.hardware.type.watch")) {
            throw new AndroidRuntimeException("You cannot use indeterminate progress on a watch.");
        }
        return super.requestFeature(featureId);
    }

    @Override
    public void setUiOptions(int uiOptions) {
        this.mUiOptions = uiOptions;
    }

    @Override
    public void setUiOptions(int uiOptions, int mask) {
        this.mUiOptions = this.mUiOptions & ~mask | uiOptions & mask;
    }

    @Override
    public TransitionManager getTransitionManager() {
        return this.mTransitionManager;
    }

    @Override
    public void setTransitionManager(TransitionManager tm) {
        this.mTransitionManager = tm;
    }

    @Override
    public Scene getContentScene() {
        return this.mContentScene;
    }

    @Override
    public void setContentView(int layoutResID) {
        if (this.mContentParent == null) {
            this.installDecor();
        } else if (!this.hasFeature(12)) {
            this.mContentParent.removeAllViews();
        }
        if (this.hasFeature(12)) {
            Scene newScene = Scene.getSceneForLayout(this.mContentParent, layoutResID, this.getContext());
            this.transitionTo(newScene);
        } else {
            this.mLayoutInflater.inflate(layoutResID, this.mContentParent);
        }
        this.mContentParent.requestApplyInsets();
        Window.Callback cb = this.getCallback();
        if (cb != null && !this.isDestroyed()) {
            cb.onContentChanged();
        }
        this.mContentParentExplicitlySet = true;
    }

    @Override
    public void setContentView(View view) {
        this.setContentView(view, new ViewGroup.LayoutParams(-1, -1));
    }

    @Override
    public void setContentView(View view, ViewGroup.LayoutParams params) {
        if (this.mContentParent == null) {
            this.installDecor();
        } else if (!this.hasFeature(12)) {
            this.mContentParent.removeAllViews();
        }
        if (this.hasFeature(12)) {
            view.setLayoutParams(params);
            Scene newScene = new Scene(this.mContentParent, view);
            this.transitionTo(newScene);
        } else {
            this.mContentParent.addView(view, params);
        }
        this.mContentParent.requestApplyInsets();
        Window.Callback cb = this.getCallback();
        if (cb != null && !this.isDestroyed()) {
            cb.onContentChanged();
        }
        this.mContentParentExplicitlySet = true;
    }

    @Override
    public void addContentView(View view, ViewGroup.LayoutParams params) {
        if (this.mContentParent == null) {
            this.installDecor();
        }
        if (this.hasFeature(12)) {
            Log.v(TAG, "addContentView does not support content transitions");
        }
        this.mContentParent.addView(view, params);
        this.mContentParent.requestApplyInsets();
        Window.Callback cb = this.getCallback();
        if (cb != null && !this.isDestroyed()) {
            cb.onContentChanged();
        }
    }

    @Override
    public void clearContentView() {
        if (this.mDecor != null) {
            this.mDecor.clearContentView();
        }
    }

    private void transitionTo(Scene scene) {
        if (this.mContentScene == null) {
            scene.enter();
        } else {
            this.mTransitionManager.transitionTo(scene);
        }
        this.mContentScene = scene;
    }

    @Override
    public View getCurrentFocus() {
        return this.mDecor != null ? this.mDecor.findFocus() : null;
    }

    @Override
    public void takeSurface(SurfaceHolder.Callback2 callback) {
        this.mTakeSurfaceCallback = callback;
    }

    @Override
    public void takeInputQueue(InputQueue.Callback callback) {
        this.mTakeInputQueueCallback = callback;
    }

    @Override
    public boolean isFloating() {
        return this.mIsFloating;
    }

    public boolean isTranslucent() {
        return this.mIsTranslucent;
    }

    boolean isShowingWallpaper() {
        return (this.getAttributes().flags & 0x100000) != 0;
    }

    @Override
    public LayoutInflater getLayoutInflater() {
        return this.mLayoutInflater;
    }

    @Override
    public void setTitle(CharSequence title) {
        this.setTitle(title, true);
    }

    public void setTitle(CharSequence title, boolean updateAccessibilityTitle) {
        if (this.mTitleView != null) {
            this.mTitleView.setText(title);
        } else if (this.mDecorContentParent != null) {
            this.mDecorContentParent.setWindowTitle(title);
        }
        this.mTitle = title;
        if (updateAccessibilityTitle) {
            WindowManager.LayoutParams params = this.getAttributes();
            if (!TextUtils.equals(title, params.accessibilityTitle)) {
                ViewRootImpl vr;
                params.accessibilityTitle = TextUtils.stringOrSpannedString(title);
                if (this.mDecor != null && (vr = this.mDecor.getViewRootImpl()) != null) {
                    vr.onWindowTitleChanged();
                }
                this.dispatchWindowAttributesChanged(this.getAttributes());
            }
        }
    }

    @Override
    @Deprecated
    public void setTitleColor(int textColor) {
        if (this.mTitleView != null) {
            this.mTitleView.setTextColor(textColor);
        }
        this.mTitleColor = textColor;
    }

    public final boolean preparePanel(PanelFeatureState st, KeyEvent event) {
        boolean isActionBarMenu;
        Window.Callback cb;
        if (this.isDestroyed()) {
            return false;
        }
        if (st.isPrepared) {
            return true;
        }
        if (this.mPreparedPanel != null && this.mPreparedPanel != st) {
            this.closePanel(this.mPreparedPanel, false);
        }
        if ((cb = this.getCallback()) != null) {
            st.createdPanelView = cb.onCreatePanelView(st.featureId);
        }
        boolean bl = isActionBarMenu = st.featureId == 0 || st.featureId == 8;
        if (isActionBarMenu && this.mDecorContentParent != null) {
            this.mDecorContentParent.setMenuPrepared();
        }
        if (st.createdPanelView == null) {
            if (st.menu == null || st.refreshMenuContent) {
                if (!(st.menu != null || this.initializePanelMenu(st) && st.menu != null)) {
                    return false;
                }
                if (isActionBarMenu && this.mDecorContentParent != null) {
                    if (this.mActionMenuPresenterCallback == null) {
                        this.mActionMenuPresenterCallback = new ActionMenuPresenterCallback();
                    }
                    this.mDecorContentParent.setMenu(st.menu, this.mActionMenuPresenterCallback);
                }
                st.menu.stopDispatchingItemsChanged();
                if (cb == null || !cb.onCreatePanelMenu(st.featureId, st.menu)) {
                    st.setMenu(null);
                    if (isActionBarMenu && this.mDecorContentParent != null) {
                        this.mDecorContentParent.setMenu(null, this.mActionMenuPresenterCallback);
                    }
                    return false;
                }
                st.refreshMenuContent = false;
            }
            st.menu.stopDispatchingItemsChanged();
            if (st.frozenActionViewState != null) {
                st.menu.restoreActionViewStates(st.frozenActionViewState);
                st.frozenActionViewState = null;
            }
            if (!cb.onPreparePanel(st.featureId, st.createdPanelView, st.menu)) {
                if (isActionBarMenu && this.mDecorContentParent != null) {
                    this.mDecorContentParent.setMenu(null, this.mActionMenuPresenterCallback);
                }
                st.menu.startDispatchingItemsChanged();
                return false;
            }
            KeyCharacterMap kmap = KeyCharacterMap.load(event != null ? event.getDeviceId() : -1);
            st.qwertyMode = kmap.getKeyboardType() != 1;
            st.menu.setQwertyMode(st.qwertyMode);
            st.menu.startDispatchingItemsChanged();
        }
        st.isPrepared = true;
        st.isHandled = false;
        this.mPreparedPanel = st;
        return true;
    }

    @Override
    public void onConfigurationChanged(Configuration newConfig) {
        PanelFeatureState st;
        if (this.mDecorContentParent == null && (st = this.getPanelState(0, false)) != null && st.menu != null) {
            if (st.isOpen) {
                Bundle state = new Bundle();
                if (st.iconMenuPresenter != null) {
                    st.iconMenuPresenter.saveHierarchyState(state);
                }
                if (st.listMenuPresenter != null) {
                    st.listMenuPresenter.saveHierarchyState(state);
                }
                PhoneWindow.clearMenuViews(st);
                this.reopenMenu(false);
                if (st.iconMenuPresenter != null) {
                    st.iconMenuPresenter.restoreHierarchyState(state);
                }
                if (st.listMenuPresenter != null) {
                    st.listMenuPresenter.restoreHierarchyState(state);
                }
            } else {
                PhoneWindow.clearMenuViews(st);
            }
        }
    }

    @Override
    public void onMultiWindowModeChanged() {
        if (this.mDecor != null) {
            this.mDecor.onConfigurationChanged(this.getContext().getResources().getConfiguration());
        }
    }

    @Override
    public void onPictureInPictureModeChanged(boolean isInPictureInPictureMode) {
        if (this.mDecor != null) {
            this.mDecor.updatePictureInPictureOutlineProvider(isInPictureInPictureMode);
        }
    }

    @Override
    public void reportActivityRelaunched() {
        if (this.mDecor != null && this.mDecor.getViewRootImpl() != null) {
            this.mDecor.getViewRootImpl().reportActivityRelaunched();
        }
    }

    private static void clearMenuViews(PanelFeatureState st) {
        st.createdPanelView = null;
        st.refreshDecorView = true;
        st.clearMenuPresenters();
    }

    @Override
    public final void openPanel(int featureId, KeyEvent event) {
        if (featureId == 0 && this.mDecorContentParent != null && this.mDecorContentParent.canShowOverflowMenu() && !ViewConfiguration.get(this.getContext()).hasPermanentMenuKey()) {
            this.mDecorContentParent.showOverflowMenu();
        } else {
            this.openPanel(this.getPanelState(featureId, true), event);
        }
    }

    private void openPanel(PanelFeatureState st, KeyEvent event) {
        ViewGroup.LayoutParams lp;
        Window.Callback cb;
        if (st.isOpen || this.isDestroyed()) {
            return;
        }
        if (st.featureId == 0) {
            boolean isHoneycombApp;
            Context context = this.getContext();
            Configuration config = context.getResources().getConfiguration();
            boolean isXLarge = (config.screenLayout & 0xF) == 4;
            boolean bl = isHoneycombApp = context.getApplicationInfo().targetSdkVersion >= 11;
            if (isXLarge && isHoneycombApp) {
                return;
            }
        }
        if ((cb = this.getCallback()) != null && !cb.onMenuOpened(st.featureId, st.menu)) {
            this.closePanel(st, true);
            return;
        }
        WindowManager wm = this.getWindowManager();
        if (wm == null) {
            return;
        }
        if (!this.preparePanel(st, event)) {
            return;
        }
        int width = -2;
        if (st.decorView == null || st.refreshDecorView) {
            int backgroundResId;
            if (st.decorView == null) {
                if (!this.initializePanelDecor(st) || st.decorView == null) {
                    return;
                }
            } else if (st.refreshDecorView && st.decorView.getChildCount() > 0) {
                st.decorView.removeAllViews();
            }
            if (!this.initializePanelContent(st) || !st.hasPanelItems()) {
                return;
            }
            ViewGroup.LayoutParams lp2 = st.shownPanelView.getLayoutParams();
            if (lp2 == null) {
                lp2 = new ViewGroup.LayoutParams(-2, -2);
            }
            if (lp2.width == -1) {
                backgroundResId = st.fullBackground;
                width = -1;
            } else {
                backgroundResId = st.background;
            }
            st.decorView.setWindowBackground(this.getContext().getDrawable(backgroundResId));
            ViewParent shownPanelParent = st.shownPanelView.getParent();
            if (shownPanelParent != null && shownPanelParent instanceof ViewGroup) {
                ((ViewGroup)shownPanelParent).removeView(st.shownPanelView);
            }
            st.decorView.addView(st.shownPanelView, lp2);
            if (!st.shownPanelView.hasFocus()) {
                st.shownPanelView.requestFocus();
            }
        } else if (!st.isInListMode()) {
            width = -1;
        } else if (st.createdPanelView != null && (lp = st.createdPanelView.getLayoutParams()) != null && lp.width == -1) {
            width = -1;
        }
        st.isHandled = false;
        WindowManager.LayoutParams lp2 = new WindowManager.LayoutParams(width, -2, st.x, st.y, 1003, 0x820000, st.decorView.mDefaultOpacity);
        if (st.isCompact) {
            lp2.gravity = this.getOptionsPanelGravity();
            sRotationWatcher.addWindow(this);
        } else {
            lp2.gravity = st.gravity;
        }
        lp2.windowAnimations = st.windowAnimations;
        wm.addView(st.decorView, lp2);
        st.isOpen = true;
    }

    @Override
    public final void closePanel(int featureId) {
        if (featureId == 0 && this.mDecorContentParent != null && this.mDecorContentParent.canShowOverflowMenu() && !ViewConfiguration.get(this.getContext()).hasPermanentMenuKey()) {
            this.mDecorContentParent.hideOverflowMenu();
        } else if (featureId == 6) {
            this.closeContextMenu();
        } else {
            this.closePanel(this.getPanelState(featureId, true), true);
        }
    }

    public final void closePanel(PanelFeatureState st, boolean doCallback) {
        if (doCallback && st.featureId == 0 && this.mDecorContentParent != null && this.mDecorContentParent.isOverflowMenuShowing()) {
            this.checkCloseActionMenu(st.menu);
            return;
        }
        WindowManager wm = this.getWindowManager();
        if (wm != null && st.isOpen) {
            if (st.decorView != null) {
                wm.removeView(st.decorView);
                if (st.isCompact) {
                    sRotationWatcher.removeWindow(this);
                }
            }
            if (doCallback) {
                this.callOnPanelClosed(st.featureId, st, null);
            }
        }
        st.isPrepared = false;
        st.isHandled = false;
        st.isOpen = false;
        st.shownPanelView = null;
        if (st.isInExpandedMode) {
            st.refreshDecorView = true;
            st.isInExpandedMode = false;
        }
        if (this.mPreparedPanel == st) {
            this.mPreparedPanel = null;
            this.mPanelChordingKey = 0;
        }
    }

    void checkCloseActionMenu(Menu menu2) {
        if (this.mClosingActionMenu) {
            return;
        }
        this.mClosingActionMenu = true;
        this.mDecorContentParent.dismissPopups();
        Window.Callback cb = this.getCallback();
        if (cb != null && !this.isDestroyed()) {
            cb.onPanelClosed(8, menu2);
        }
        this.mClosingActionMenu = false;
    }

    @Override
    public final void togglePanel(int featureId, KeyEvent event) {
        PanelFeatureState st = this.getPanelState(featureId, true);
        if (st.isOpen) {
            this.closePanel(st, true);
        } else {
            this.openPanel(st, event);
        }
    }

    @Override
    public void invalidatePanelMenu(int featureId) {
        this.mInvalidatePanelMenuFeatures |= 1 << featureId;
        if (!this.mInvalidatePanelMenuPosted && this.mDecor != null) {
            this.mDecor.postOnAnimation(this.mInvalidatePanelMenuRunnable);
            this.mInvalidatePanelMenuPosted = true;
        }
    }

    void doPendingInvalidatePanelMenu() {
        if (this.mInvalidatePanelMenuPosted) {
            this.mDecor.removeCallbacks(this.mInvalidatePanelMenuRunnable);
            this.mInvalidatePanelMenuRunnable.run();
        }
    }

    void doInvalidatePanelMenu(int featureId) {
        PanelFeatureState st = this.getPanelState(featureId, false);
        if (st == null) {
            return;
        }
        Bundle savedActionViewStates = null;
        if (st.menu != null) {
            savedActionViewStates = new Bundle();
            st.menu.saveActionViewStates(savedActionViewStates);
            if (savedActionViewStates.size() > 0) {
                st.frozenActionViewState = savedActionViewStates;
            }
            st.menu.stopDispatchingItemsChanged();
            st.menu.clear();
        }
        st.refreshMenuContent = true;
        st.refreshDecorView = true;
        if ((featureId == 8 || featureId == 0) && this.mDecorContentParent != null && (st = this.getPanelState(0, false)) != null) {
            st.isPrepared = false;
            this.preparePanel(st, null);
        }
    }

    public final boolean onKeyDownPanel(int featureId, KeyEvent event) {
        int keyCode = event.getKeyCode();
        if (event.getRepeatCount() == 0) {
            this.mPanelChordingKey = keyCode;
            PanelFeatureState st = this.getPanelState(featureId, false);
            if (st != null && !st.isOpen) {
                return this.preparePanel(st, event);
            }
        }
        return false;
    }

    public final void onKeyUpPanel(int featureId, KeyEvent event) {
        if (this.mPanelChordingKey != 0) {
            this.mPanelChordingKey = 0;
            PanelFeatureState st = this.getPanelState(featureId, false);
            if (event.isCanceled() || this.mDecor != null && this.mDecor.mPrimaryActionMode != null || st == null) {
                return;
            }
            boolean playSoundEffect = false;
            if (featureId == 0 && this.mDecorContentParent != null && this.mDecorContentParent.canShowOverflowMenu() && !ViewConfiguration.get(this.getContext()).hasPermanentMenuKey()) {
                if (!this.mDecorContentParent.isOverflowMenuShowing()) {
                    if (!this.isDestroyed() && this.preparePanel(st, event)) {
                        playSoundEffect = this.mDecorContentParent.showOverflowMenu();
                    }
                } else {
                    playSoundEffect = this.mDecorContentParent.hideOverflowMenu();
                }
            } else if (st.isOpen || st.isHandled) {
                playSoundEffect = st.isOpen;
                this.closePanel(st, true);
            } else if (st.isPrepared) {
                boolean show = true;
                if (st.refreshMenuContent) {
                    st.isPrepared = false;
                    show = this.preparePanel(st, event);
                }
                if (show) {
                    EventLog.writeEvent(50001, 0);
                    this.openPanel(st, event);
                    playSoundEffect = true;
                }
            }
            if (playSoundEffect) {
                AudioManager audioManager = (AudioManager)this.getContext().getSystemService("audio");
                if (audioManager != null) {
                    audioManager.playSoundEffect(0);
                } else {
                    Log.w(TAG, "Couldn't get audio manager");
                }
            }
        }
    }

    @Override
    public final void closeAllPanels() {
        WindowManager wm = this.getWindowManager();
        if (wm == null) {
            return;
        }
        PanelFeatureState[] panels = this.mPanels;
        int N = panels != null ? panels.length : 0;
        for (int i = 0; i < N; ++i) {
            PanelFeatureState panel = panels[i];
            if (panel == null) continue;
            this.closePanel(panel, true);
        }
        this.closeContextMenu();
    }

    private synchronized void closeContextMenu() {
        if (this.mContextMenu != null) {
            this.mContextMenu.close();
            this.dismissContextMenu();
        }
    }

    private synchronized void dismissContextMenu() {
        this.mContextMenu = null;
        if (this.mContextMenuHelper != null) {
            this.mContextMenuHelper.dismiss();
            this.mContextMenuHelper = null;
        }
    }

    @Override
    public boolean performPanelShortcut(int featureId, int keyCode, KeyEvent event, int flags) {
        return this.performPanelShortcut(this.getPanelState(featureId, false), keyCode, event, flags);
    }

    boolean performPanelShortcut(PanelFeatureState st, int keyCode, KeyEvent event, int flags) {
        if (event.isSystem() || st == null) {
            return false;
        }
        boolean handled = false;
        if ((st.isPrepared || this.preparePanel(st, event)) && st.menu != null) {
            handled = st.menu.performShortcut(keyCode, event, flags);
        }
        if (handled) {
            st.isHandled = true;
            if ((flags & 1) == 0 && this.mDecorContentParent == null) {
                this.closePanel(st, true);
            }
        }
        return handled;
    }

    @Override
    public boolean performPanelIdentifierAction(int featureId, int id2, int flags) {
        PanelFeatureState st = this.getPanelState(featureId, true);
        if (!this.preparePanel(st, new KeyEvent(0, 82))) {
            return false;
        }
        if (st.menu == null) {
            return false;
        }
        boolean res = st.menu.performIdentifierAction(id2, flags);
        if (this.mDecorContentParent == null) {
            this.closePanel(st, true);
        }
        return res;
    }

    public PanelFeatureState findMenuPanel(Menu menu2) {
        PanelFeatureState[] panels = this.mPanels;
        int N = panels != null ? panels.length : 0;
        for (int i = 0; i < N; ++i) {
            PanelFeatureState panel = panels[i];
            if (panel == null || panel.menu != menu2) continue;
            return panel;
        }
        return null;
    }

    @Override
    public boolean onMenuItemSelected(MenuBuilder menu2, MenuItem item) {
        PanelFeatureState panel;
        Window.Callback cb = this.getCallback();
        if (cb != null && !this.isDestroyed() && (panel = this.findMenuPanel(menu2.getRootMenu())) != null) {
            return cb.onMenuItemSelected(panel.featureId, item);
        }
        return false;
    }

    @Override
    public void onMenuModeChange(MenuBuilder menu2) {
        this.reopenMenu(true);
    }

    private void reopenMenu(boolean toggleMenuMode) {
        if (this.mDecorContentParent != null && this.mDecorContentParent.canShowOverflowMenu() && (!ViewConfiguration.get(this.getContext()).hasPermanentMenuKey() || this.mDecorContentParent.isOverflowMenuShowPending())) {
            Window.Callback cb = this.getCallback();
            if (!this.mDecorContentParent.isOverflowMenuShowing() || !toggleMenuMode) {
                if (cb != null && !this.isDestroyed()) {
                    PanelFeatureState st;
                    if (this.mInvalidatePanelMenuPosted && (this.mInvalidatePanelMenuFeatures & 1) != 0) {
                        this.mDecor.removeCallbacks(this.mInvalidatePanelMenuRunnable);
                        this.mInvalidatePanelMenuRunnable.run();
                    }
                    if ((st = this.getPanelState(0, false)) != null && st.menu != null && !st.refreshMenuContent && cb.onPreparePanel(0, st.createdPanelView, st.menu)) {
                        cb.onMenuOpened(8, st.menu);
                        this.mDecorContentParent.showOverflowMenu();
                    }
                }
            } else {
                this.mDecorContentParent.hideOverflowMenu();
                PanelFeatureState st = this.getPanelState(0, false);
                if (st != null && cb != null && !this.isDestroyed()) {
                    cb.onPanelClosed(8, st.menu);
                }
            }
            return;
        }
        PanelFeatureState st = this.getPanelState(0, false);
        if (st == null) {
            return;
        }
        boolean newExpandedMode = toggleMenuMode ? !st.isInExpandedMode : st.isInExpandedMode;
        st.refreshDecorView = true;
        this.closePanel(st, false);
        st.isInExpandedMode = newExpandedMode;
        this.openPanel(st, null);
    }

    protected boolean initializePanelMenu(PanelFeatureState st) {
        Context context = this.getContext();
        if ((st.featureId == 0 || st.featureId == 8) && this.mDecorContentParent != null) {
            TypedValue outValue = new TypedValue();
            Resources.Theme baseTheme = context.getTheme();
            baseTheme.resolveAttribute(16843825, outValue, true);
            Resources.Theme widgetTheme = null;
            if (outValue.resourceId != 0) {
                widgetTheme = context.getResources().newTheme();
                widgetTheme.setTo(baseTheme);
                widgetTheme.applyStyle(outValue.resourceId, true);
                widgetTheme.resolveAttribute(16843671, outValue, true);
            } else {
                baseTheme.resolveAttribute(16843671, outValue, true);
            }
            if (outValue.resourceId != 0) {
                if (widgetTheme == null) {
                    widgetTheme = context.getResources().newTheme();
                    widgetTheme.setTo(baseTheme);
                }
                widgetTheme.applyStyle(outValue.resourceId, true);
            }
            if (widgetTheme != null) {
                context = new ContextThemeWrapper(context, 0);
                context.getTheme().setTo(widgetTheme);
            }
        }
        MenuBuilder menu2 = new MenuBuilder(context);
        menu2.setCallback(this);
        st.setMenu(menu2);
        return true;
    }

    protected boolean initializePanelDecor(PanelFeatureState st) {
        st.decorView = this.generateDecor(st.featureId);
        st.gravity = 81;
        st.setStyle(this.getContext());
        TypedArray a = this.getContext().obtainStyledAttributes(null, R.styleable.Window, 0, st.listPresenterTheme);
        float elevation = a.getDimension(38, 0.0f);
        if (elevation != 0.0f) {
            st.decorView.setElevation(elevation);
        }
        a.recycle();
        return true;
    }

    private int getOptionsPanelGravity() {
        try {
            return WindowManagerHolder.sWindowManager.getPreferredOptionsPanelGravity();
        }
        catch (RemoteException ex) {
            Log.e(TAG, "Couldn't getOptionsPanelGravity; using default", ex);
            return 81;
        }
    }

    void onOptionsPanelRotationChanged() {
        WindowManager.LayoutParams lp;
        PanelFeatureState st = this.getPanelState(0, false);
        if (st == null) {
            return;
        }
        WindowManager.LayoutParams layoutParams = lp = st.decorView != null ? (WindowManager.LayoutParams)st.decorView.getLayoutParams() : null;
        if (lp != null) {
            lp.gravity = this.getOptionsPanelGravity();
            WindowManager wm = this.getWindowManager();
            if (wm != null) {
                wm.updateViewLayout(st.decorView, lp);
            }
        }
    }

    protected boolean initializePanelContent(PanelFeatureState st) {
        if (st.createdPanelView != null) {
            st.shownPanelView = st.createdPanelView;
            return true;
        }
        if (st.menu == null) {
            return false;
        }
        if (this.mPanelMenuPresenterCallback == null) {
            this.mPanelMenuPresenterCallback = new PanelMenuPresenterCallback();
        }
        MenuView menuView = st.isInListMode() ? st.getListMenuView(this.getContext(), this.mPanelMenuPresenterCallback) : st.getIconMenuView(this.getContext(), this.mPanelMenuPresenterCallback);
        st.shownPanelView = (View)((Object)menuView);
        if (st.shownPanelView != null) {
            int defaultAnimations = menuView.getWindowAnimations();
            if (defaultAnimations != 0) {
                st.windowAnimations = defaultAnimations;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean performContextMenuIdentifierAction(int id2, int flags) {
        return this.mContextMenu != null ? this.mContextMenu.performIdentifierAction(id2, flags) : false;
    }

    @Override
    public final void setElevation(float elevation) {
        this.mElevation = elevation;
        WindowManager.LayoutParams attrs = this.getAttributes();
        if (this.mDecor != null) {
            this.mDecor.setElevation(elevation);
            attrs.setSurfaceInsets(this.mDecor, true, false);
        }
        this.dispatchWindowAttributesChanged(attrs);
    }

    @Override
    public float getElevation() {
        return this.mElevation;
    }

    @Override
    public final void setClipToOutline(boolean clipToOutline) {
        this.mClipToOutline = clipToOutline;
        if (this.mDecor != null) {
            this.mDecor.setClipToOutline(clipToOutline);
        }
    }

    @Override
    public final void setBackgroundDrawable(Drawable drawable2) {
        if (drawable2 != this.mBackgroundDrawable || this.mBackgroundResource != 0) {
            this.mBackgroundResource = 0;
            this.mBackgroundDrawable = drawable2;
            if (this.mDecor != null) {
                this.mDecor.setWindowBackground(drawable2);
            }
            if (this.mBackgroundFallbackResource != 0) {
                this.mDecor.setBackgroundFallback(drawable2 != null ? 0 : this.mBackgroundFallbackResource);
            }
        }
    }

    @Override
    public final void setFeatureDrawableResource(int featureId, int resId) {
        if (resId != 0) {
            DrawableFeatureState st = this.getDrawableState(featureId, true);
            if (st.resid != resId) {
                st.resid = resId;
                st.uri = null;
                st.local = this.getContext().getDrawable(resId);
                this.updateDrawable(featureId, st, false);
            }
        } else {
            this.setFeatureDrawable(featureId, null);
        }
    }

    @Override
    public final void setFeatureDrawableUri(int featureId, Uri uri) {
        if (uri != null) {
            DrawableFeatureState st = this.getDrawableState(featureId, true);
            if (st.uri == null || !st.uri.equals(uri)) {
                st.resid = 0;
                st.uri = uri;
                st.local = this.loadImageURI(uri);
                this.updateDrawable(featureId, st, false);
            }
        } else {
            this.setFeatureDrawable(featureId, null);
        }
    }

    @Override
    public final void setFeatureDrawable(int featureId, Drawable drawable2) {
        DrawableFeatureState st = this.getDrawableState(featureId, true);
        st.resid = 0;
        st.uri = null;
        if (st.local != drawable2) {
            st.local = drawable2;
            this.updateDrawable(featureId, st, false);
        }
    }

    @Override
    public void setFeatureDrawableAlpha(int featureId, int alpha) {
        DrawableFeatureState st = this.getDrawableState(featureId, true);
        if (st.alpha != alpha) {
            st.alpha = alpha;
            this.updateDrawable(featureId, st, false);
        }
    }

    protected final void setFeatureDefaultDrawable(int featureId, Drawable drawable2) {
        DrawableFeatureState st = this.getDrawableState(featureId, true);
        if (st.def != drawable2) {
            st.def = drawable2;
            this.updateDrawable(featureId, st, false);
        }
    }

    @Override
    public final void setFeatureInt(int featureId, int value) {
        this.updateInt(featureId, value, false);
    }

    protected final void updateDrawable(int featureId, boolean fromActive) {
        DrawableFeatureState st = this.getDrawableState(featureId, false);
        if (st != null) {
            this.updateDrawable(featureId, st, fromActive);
        }
    }

    protected void onDrawableChanged(int featureId, Drawable drawable2, int alpha) {
        ImageView view;
        if (featureId == 3) {
            view = this.getLeftIconView();
        } else if (featureId == 4) {
            view = this.getRightIconView();
        } else {
            return;
        }
        if (drawable2 != null) {
            drawable2.setAlpha(alpha);
            view.setImageDrawable(drawable2);
            view.setVisibility(0);
        } else {
            view.setVisibility(8);
        }
    }

    protected void onIntChanged(int featureId, int value) {
        FrameLayout titleContainer;
        if (featureId == 2 || featureId == 5) {
            this.updateProgressBars(value);
        } else if (featureId == 7 && (titleContainer = (FrameLayout)this.findViewById(16909372)) != null) {
            this.mLayoutInflater.inflate(value, (ViewGroup)titleContainer);
        }
    }

    private void updateProgressBars(int value) {
        ProgressBar circularProgressBar = this.getCircularProgressBar(true);
        ProgressBar horizontalProgressBar = this.getHorizontalProgressBar(true);
        int features = this.getLocalFeatures();
        if (value == -1) {
            if ((features & 4) != 0) {
                if (horizontalProgressBar != null) {
                    int level = horizontalProgressBar.getProgress();
                    int visibility = horizontalProgressBar.isIndeterminate() || level < 10000 ? 0 : 4;
                    horizontalProgressBar.setVisibility(visibility);
                } else {
                    Log.e(TAG, "Horizontal progress bar not located in current window decor");
                }
            }
            if ((features & 0x20) != 0) {
                if (circularProgressBar != null) {
                    circularProgressBar.setVisibility(0);
                } else {
                    Log.e(TAG, "Circular progress bar not located in current window decor");
                }
            }
        } else if (value == -2) {
            if ((features & 4) != 0) {
                if (horizontalProgressBar != null) {
                    horizontalProgressBar.setVisibility(8);
                } else {
                    Log.e(TAG, "Horizontal progress bar not located in current window decor");
                }
            }
            if ((features & 0x20) != 0) {
                if (circularProgressBar != null) {
                    circularProgressBar.setVisibility(8);
                } else {
                    Log.e(TAG, "Circular progress bar not located in current window decor");
                }
            }
        } else if (value == -3) {
            if (horizontalProgressBar != null) {
                horizontalProgressBar.setIndeterminate(true);
            } else {
                Log.e(TAG, "Horizontal progress bar not located in current window decor");
            }
        } else if (value == -4) {
            if (horizontalProgressBar != null) {
                horizontalProgressBar.setIndeterminate(false);
            } else {
                Log.e(TAG, "Horizontal progress bar not located in current window decor");
            }
        } else if (0 <= value && value <= 10000) {
            if (horizontalProgressBar != null) {
                horizontalProgressBar.setProgress(value - 0);
            } else {
                Log.e(TAG, "Horizontal progress bar not located in current window decor");
            }
            if (value < 10000) {
                this.showProgressBars(horizontalProgressBar, circularProgressBar);
            } else {
                this.hideProgressBars(horizontalProgressBar, circularProgressBar);
            }
        } else if (20000 <= value && value <= 30000) {
            if (horizontalProgressBar != null) {
                horizontalProgressBar.setSecondaryProgress(value - 20000);
            } else {
                Log.e(TAG, "Horizontal progress bar not located in current window decor");
            }
            this.showProgressBars(horizontalProgressBar, circularProgressBar);
        }
    }

    private void showProgressBars(ProgressBar horizontalProgressBar, ProgressBar spinnyProgressBar) {
        int features = this.getLocalFeatures();
        if ((features & 0x20) != 0 && spinnyProgressBar != null && spinnyProgressBar.getVisibility() == 4) {
            spinnyProgressBar.setVisibility(0);
        }
        if ((features & 4) != 0 && horizontalProgressBar != null && horizontalProgressBar.getProgress() < 10000) {
            horizontalProgressBar.setVisibility(0);
        }
    }

    private void hideProgressBars(ProgressBar horizontalProgressBar, ProgressBar spinnyProgressBar) {
        int features = this.getLocalFeatures();
        Animation anim2 = AnimationUtils.loadAnimation(this.getContext(), 0x10A0001);
        anim2.setDuration(1000L);
        if ((features & 0x20) != 0 && spinnyProgressBar != null && spinnyProgressBar.getVisibility() == 0) {
            spinnyProgressBar.startAnimation(anim2);
            spinnyProgressBar.setVisibility(4);
        }
        if ((features & 4) != 0 && horizontalProgressBar != null && horizontalProgressBar.getVisibility() == 0) {
            horizontalProgressBar.startAnimation(anim2);
            horizontalProgressBar.setVisibility(4);
        }
    }

    @Override
    public void setIcon(int resId) {
        this.mIconRes = resId;
        this.mResourcesSetFlags |= 1;
        this.mResourcesSetFlags &= 0xFFFFFFFB;
        if (this.mDecorContentParent != null) {
            this.mDecorContentParent.setIcon(resId);
        }
    }

    @Override
    public void setDefaultIcon(int resId) {
        if ((this.mResourcesSetFlags & 1) != 0) {
            return;
        }
        this.mIconRes = resId;
        if (!(this.mDecorContentParent == null || this.mDecorContentParent.hasIcon() && (this.mResourcesSetFlags & 4) == 0)) {
            if (resId != 0) {
                this.mDecorContentParent.setIcon(resId);
                this.mResourcesSetFlags &= 0xFFFFFFFB;
            } else {
                this.mDecorContentParent.setIcon(this.getContext().getPackageManager().getDefaultActivityIcon());
                this.mResourcesSetFlags |= 4;
            }
        }
    }

    @Override
    public void setLogo(int resId) {
        this.mLogoRes = resId;
        this.mResourcesSetFlags |= 2;
        if (this.mDecorContentParent != null) {
            this.mDecorContentParent.setLogo(resId);
        }
    }

    @Override
    public void setDefaultLogo(int resId) {
        if ((this.mResourcesSetFlags & 2) != 0) {
            return;
        }
        this.mLogoRes = resId;
        if (this.mDecorContentParent != null && !this.mDecorContentParent.hasLogo()) {
            this.mDecorContentParent.setLogo(resId);
        }
    }

    @Override
    public void setLocalFocus(boolean hasFocus, boolean inTouchMode) {
        this.getViewRootImpl().windowFocusChanged(hasFocus, inTouchMode);
    }

    @Override
    public void injectInputEvent(InputEvent event) {
        this.getViewRootImpl().dispatchInputEvent(event);
    }

    private ViewRootImpl getViewRootImpl() {
        ViewRootImpl viewRootImpl;
        if (this.mDecor != null && (viewRootImpl = this.mDecor.getViewRootImpl()) != null) {
            return viewRootImpl;
        }
        throw new IllegalStateException("view not added");
    }

    @Override
    public void takeKeyEvents(boolean get) {
        this.mDecor.setFocusable(get);
    }

    @Override
    public boolean superDispatchKeyEvent(KeyEvent event) {
        return this.mDecor.superDispatchKeyEvent(event);
    }

    @Override
    public boolean superDispatchKeyShortcutEvent(KeyEvent event) {
        return this.mDecor.superDispatchKeyShortcutEvent(event);
    }

    @Override
    public boolean superDispatchTouchEvent(MotionEvent event) {
        return this.mDecor.superDispatchTouchEvent(event);
    }

    @Override
    public boolean superDispatchTrackballEvent(MotionEvent event) {
        return this.mDecor.superDispatchTrackballEvent(event);
    }

    @Override
    public boolean superDispatchGenericMotionEvent(MotionEvent event) {
        return this.mDecor.superDispatchGenericMotionEvent(event);
    }

    protected boolean onKeyDown(int featureId, int keyCode, KeyEvent event) {
        KeyEvent.DispatcherState dispatcher = this.mDecor != null ? this.mDecor.getKeyDispatcherState() : null;
        switch (keyCode) {
            case 24: 
            case 25: 
            case 164: {
                if (this.mMediaController != null) {
                    int direction = 0;
                    switch (keyCode) {
                        case 24: {
                            direction = 1;
                            break;
                        }
                        case 25: {
                            direction = -1;
                            break;
                        }
                        case 164: {
                            direction = 101;
                        }
                    }
                    this.mMediaController.adjustVolume(direction, 1);
                } else {
                    MediaSessionLegacyHelper.getHelper(this.getContext()).sendVolumeKeyEvent(event, this.mVolumeControlStreamType, false);
                }
                return true;
            }
            case 79: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 126: 
            case 127: 
            case 130: {
                return this.mMediaController != null && this.mMediaController.dispatchMediaButtonEvent(event);
            }
            case 82: {
                this.onKeyDownPanel(featureId < 0 ? 0 : featureId, event);
                return true;
            }
            case 4: {
                if (event.getRepeatCount() > 0 || featureId < 0) break;
                if (dispatcher != null) {
                    dispatcher.startTracking(event, this);
                }
                return true;
            }
        }
        return false;
    }

    private KeyguardManager getKeyguardManager() {
        if (this.mKeyguardManager == null) {
            this.mKeyguardManager = (KeyguardManager)this.getContext().getSystemService("keyguard");
        }
        return this.mKeyguardManager;
    }

    AudioManager getAudioManager() {
        if (this.mAudioManager == null) {
            this.mAudioManager = (AudioManager)this.getContext().getSystemService("audio");
        }
        return this.mAudioManager;
    }

    protected boolean onKeyUp(int featureId, int keyCode, KeyEvent event) {
        KeyEvent.DispatcherState dispatcher;
        KeyEvent.DispatcherState dispatcherState = dispatcher = this.mDecor != null ? this.mDecor.getKeyDispatcherState() : null;
        if (dispatcher != null) {
            dispatcher.handleUpEvent(event);
        }
        switch (keyCode) {
            case 24: 
            case 25: {
                if (this.mMediaController != null) {
                    int flags = 4116;
                    this.mMediaController.adjustVolume(0, 4116);
                } else {
                    MediaSessionLegacyHelper.getHelper(this.getContext()).sendVolumeKeyEvent(event, this.mVolumeControlStreamType, false);
                }
                return true;
            }
            case 164: {
                MediaSessionLegacyHelper.getHelper(this.getContext()).sendVolumeKeyEvent(event, Integer.MIN_VALUE, false);
                return true;
            }
            case 79: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 126: 
            case 127: 
            case 130: {
                return this.mMediaController != null && this.mMediaController.dispatchMediaButtonEvent(event);
            }
            case 82: {
                this.onKeyUpPanel(featureId < 0 ? 0 : featureId, event);
                return true;
            }
            case 4: {
                PanelFeatureState st;
                if (featureId < 0 || !event.isTracking() || event.isCanceled()) break;
                if (featureId == 0 && (st = this.getPanelState(featureId, false)) != null && st.isInExpandedMode) {
                    this.reopenMenu(true);
                    return true;
                }
                this.closePanel(featureId);
                return true;
            }
            case 84: {
                if (this.getKeyguardManager().inKeyguardRestrictedInputMode()) break;
                if (event.isTracking() && !event.isCanceled()) {
                    this.launchDefaultSearch(event);
                }
                return true;
            }
            case 171: {
                if (this.mSupportsPictureInPicture && !event.isCanceled()) {
                    this.getWindowControllerCallback().enterPictureInPictureModeIfPossible();
                }
                return true;
            }
        }
        return false;
    }

    @Override
    protected void onActive() {
    }

    @Override
    public final View getDecorView() {
        if (this.mDecor == null || this.mForceDecorInstall) {
            this.installDecor();
        }
        return this.mDecor;
    }

    @Override
    public final View peekDecorView() {
        return this.mDecor;
    }

    void onViewRootImplSet(ViewRootImpl viewRoot) {
        viewRoot.setActivityConfigCallback(this.mActivityConfigCallback);
    }

    @Override
    public Bundle saveHierarchyState() {
        Bundle outState = new Bundle();
        if (this.mContentParent == null) {
            return outState;
        }
        SparseArray<Parcelable> states = new SparseArray<Parcelable>();
        this.mContentParent.saveHierarchyState(states);
        outState.putSparseParcelableArray(VIEWS_TAG, states);
        View focusedView = this.mContentParent.findFocus();
        if (focusedView != null && focusedView.getId() != -1) {
            outState.putInt(FOCUSED_ID_TAG, focusedView.getId());
        }
        SparseArray<Parcelable> panelStates = new SparseArray<Parcelable>();
        this.savePanelState(panelStates);
        if (panelStates.size() > 0) {
            outState.putSparseParcelableArray(PANELS_TAG, panelStates);
        }
        if (this.mDecorContentParent != null) {
            SparseArray<Parcelable> actionBarStates = new SparseArray<Parcelable>();
            this.mDecorContentParent.saveToolbarHierarchyState(actionBarStates);
            outState.putSparseParcelableArray(ACTION_BAR_TAG, actionBarStates);
        }
        return outState;
    }

    @Override
    public void restoreHierarchyState(Bundle savedInstanceState) {
        SparseArray<Parcelable> panelStates;
        int focusedViewId;
        if (this.mContentParent == null) {
            return;
        }
        SparseArray<Parcelable> savedStates = savedInstanceState.getSparseParcelableArray(VIEWS_TAG);
        if (savedStates != null) {
            this.mContentParent.restoreHierarchyState(savedStates);
        }
        if ((focusedViewId = savedInstanceState.getInt(FOCUSED_ID_TAG, -1)) != -1) {
            Object needsFocus = this.mContentParent.findViewById(focusedViewId);
            if (needsFocus != null) {
                ((View)needsFocus).requestFocus();
            } else {
                Log.w(TAG, "Previously focused view reported id " + focusedViewId + " during save, but can't be found during restore.");
            }
        }
        if ((panelStates = savedInstanceState.getSparseParcelableArray(PANELS_TAG)) != null) {
            this.restorePanelState(panelStates);
        }
        if (this.mDecorContentParent != null) {
            SparseArray<Parcelable> actionBarStates = savedInstanceState.getSparseParcelableArray(ACTION_BAR_TAG);
            if (actionBarStates != null) {
                this.doPendingInvalidatePanelMenu();
                this.mDecorContentParent.restoreToolbarHierarchyState(actionBarStates);
            } else {
                Log.w(TAG, "Missing saved instance states for action bar views! State will not be restored.");
            }
        }
    }

    private void savePanelState(SparseArray<Parcelable> icicles) {
        PanelFeatureState[] panels = this.mPanels;
        if (panels == null) {
            return;
        }
        for (int curFeatureId = panels.length - 1; curFeatureId >= 0; --curFeatureId) {
            if (panels[curFeatureId] == null) continue;
            icicles.put(curFeatureId, panels[curFeatureId].onSaveInstanceState());
        }
    }

    private void restorePanelState(SparseArray<Parcelable> icicles) {
        for (int i = icicles.size() - 1; i >= 0; --i) {
            int curFeatureId = icicles.keyAt(i);
            PanelFeatureState st = this.getPanelState(curFeatureId, false);
            if (st == null) continue;
            st.onRestoreInstanceState(icicles.get(curFeatureId));
            this.invalidatePanelMenu(curFeatureId);
        }
    }

    void openPanelsAfterRestore() {
        PanelFeatureState[] panels = this.mPanels;
        if (panels == null) {
            return;
        }
        for (int i = panels.length - 1; i >= 0; --i) {
            PanelFeatureState st = panels[i];
            if (st == null) continue;
            st.applyFrozenState();
            if (st.isOpen || !st.wasLastOpen) continue;
            st.isInExpandedMode = st.wasLastExpanded;
            this.openPanel(st, null);
        }
    }

    protected DecorView generateDecor(int featureId) {
        Context context;
        if (this.mUseDecorContext) {
            Context applicationContext = this.getContext().getApplicationContext();
            if (applicationContext == null) {
                context = this.getContext();
            } else {
                context = new DecorContext(applicationContext, this.getContext().getResources());
                if (this.mTheme != -1) {
                    context.setTheme(this.mTheme);
                }
            }
        } else {
            context = this.getContext();
        }
        return new DecorView(context, featureId, this, this.getAttributes());
    }

    protected ViewGroup generateLayout(DecorView decor) {
        ProgressBar progress;
        TypedValue res;
        int layoutResource;
        int features;
        boolean noActionBar;
        TypedArray a = this.getWindowStyle();
        this.mIsFloating = a.getBoolean(4, false);
        int flagsToUpdate = 0x10100 & ~this.getForcedWindowFlags();
        if (this.mIsFloating) {
            this.setLayout(-2, -2);
            this.setFlags(0, flagsToUpdate);
        } else {
            this.setFlags(65792, flagsToUpdate);
        }
        if (a.getBoolean(3, false)) {
            this.requestFeature(1);
        } else if (a.getBoolean(15, false)) {
            this.requestFeature(8);
        }
        if (a.getBoolean(17, false)) {
            this.requestFeature(9);
        }
        if (a.getBoolean(16, false)) {
            this.requestFeature(10);
        }
        if (a.getBoolean(25, false)) {
            this.requestFeature(11);
        }
        if (a.getBoolean(9, false)) {
            this.setFlags(1024, 0x400 & ~this.getForcedWindowFlags());
        }
        if (a.getBoolean(23, false)) {
            this.setFlags(0x4000000, 0x4000000 & ~this.getForcedWindowFlags());
        }
        if (a.getBoolean(24, false)) {
            this.setFlags(0x8000000, 0x8000000 & ~this.getForcedWindowFlags());
        }
        if (a.getBoolean(22, false)) {
            this.setFlags(0x2000000, 0x2000000 & ~this.getForcedWindowFlags());
        }
        if (a.getBoolean(14, false)) {
            this.setFlags(0x100000, 0x100000 & ~this.getForcedWindowFlags());
        }
        if (a.getBoolean(18, this.getContext().getApplicationInfo().targetSdkVersion >= 11)) {
            this.setFlags(0x800000, 0x800000 & ~this.getForcedWindowFlags());
        }
        a.getValue(19, this.mMinWidthMajor);
        a.getValue(20, this.mMinWidthMinor);
        if (a.hasValue(54)) {
            if (this.mFixedWidthMajor == null) {
                this.mFixedWidthMajor = new TypedValue();
            }
            a.getValue(54, this.mFixedWidthMajor);
        }
        if (a.hasValue(55)) {
            if (this.mFixedWidthMinor == null) {
                this.mFixedWidthMinor = new TypedValue();
            }
            a.getValue(55, this.mFixedWidthMinor);
        }
        if (a.hasValue(52)) {
            if (this.mFixedHeightMajor == null) {
                this.mFixedHeightMajor = new TypedValue();
            }
            a.getValue(52, this.mFixedHeightMajor);
        }
        if (a.hasValue(53)) {
            if (this.mFixedHeightMinor == null) {
                this.mFixedHeightMinor = new TypedValue();
            }
            a.getValue(53, this.mFixedHeightMinor);
        }
        if (a.getBoolean(26, false)) {
            this.requestFeature(12);
        }
        if (a.getBoolean(45, false)) {
            this.requestFeature(13);
        }
        this.mIsTranslucent = a.getBoolean(5, false);
        Context context = this.getContext();
        int targetSdk = context.getApplicationInfo().targetSdkVersion;
        boolean targetPreHoneycomb = targetSdk < 11;
        boolean targetPreIcs = targetSdk < 14;
        boolean targetPreL = targetSdk < 21;
        boolean targetHcNeedsOptions = context.getResources().getBoolean(17957090);
        boolean bl = noActionBar = !this.hasFeature(8) || this.hasFeature(1);
        if (targetPreHoneycomb || targetPreIcs && targetHcNeedsOptions && noActionBar) {
            this.setNeedsMenuKey(1);
        } else {
            this.setNeedsMenuKey(2);
        }
        if (!this.mForcedStatusBarColor) {
            this.mStatusBarColor = a.getColor(35, -16777216);
        }
        if (!this.mForcedNavigationBarColor) {
            this.mNavigationBarColor = a.getColor(36, -16777216);
            this.mNavigationBarDividerColor = a.getColor(50, 0);
        }
        WindowManager.LayoutParams params = this.getAttributes();
        if (!this.mIsFloating) {
            if (!targetPreL && a.getBoolean(34, false)) {
                this.setFlags(Integer.MIN_VALUE, Integer.MIN_VALUE & ~this.getForcedWindowFlags());
            }
            if (this.mDecor.mForceWindowDrawsStatusBarBackground) {
                params.privateFlags |= 0x20000;
            }
        }
        if (a.getBoolean(46, false)) {
            decor.setSystemUiVisibility(decor.getSystemUiVisibility() | 0x2000);
        }
        if (a.getBoolean(49, false)) {
            decor.setSystemUiVisibility(decor.getSystemUiVisibility() | 0x10);
        }
        if ((this.mAlwaysReadCloseOnTouchAttr || this.getContext().getApplicationInfo().targetSdkVersion >= 11) && a.getBoolean(21, false)) {
            this.setCloseOnTouchOutsideIfNotSet(true);
        }
        if (!this.hasSoftInputMode()) {
            params.softInputMode = a.getInt(13, params.softInputMode);
        }
        if (a.getBoolean(11, this.mIsFloating)) {
            if ((this.getForcedWindowFlags() & 2) == 0) {
                params.flags |= 2;
            }
            if (!this.haveDimAmount()) {
                params.dimAmount = a.getFloat(0, 0.5f);
            }
        }
        if (params.windowAnimations == 0) {
            params.windowAnimations = a.getResourceId(8, 0);
        }
        if (this.getContainer() == null) {
            if (this.mBackgroundDrawable == null) {
                if (this.mBackgroundResource == 0) {
                    this.mBackgroundResource = a.getResourceId(1, 0);
                }
                if (this.mFrameResource == 0) {
                    this.mFrameResource = a.getResourceId(2, 0);
                }
                this.mBackgroundFallbackResource = a.getResourceId(47, 0);
            }
            if (this.mLoadElevation) {
                this.mElevation = a.getDimension(38, 0.0f);
            }
            this.mClipToOutline = a.getBoolean(39, false);
            this.mTextColor = a.getColor(7, 0);
        }
        if (((features = this.getLocalFeatures()) & 0x800) != 0) {
            layoutResource = 17367252;
            this.setCloseOnSwipeEnabled(true);
        } else if ((features & 0x18) != 0) {
            if (this.mIsFloating) {
                res = new TypedValue();
                this.getContext().getTheme().resolveAttribute(17891366, res, true);
                layoutResource = res.resourceId;
            } else {
                layoutResource = 17367254;
            }
            this.removeFeature(8);
        } else if ((features & 0x24) != 0 && (features & 0x100) == 0) {
            layoutResource = 17367249;
        } else if ((features & 0x80) != 0) {
            if (this.mIsFloating) {
                res = new TypedValue();
                this.getContext().getTheme().resolveAttribute(17891363, res, true);
                layoutResource = res.resourceId;
            } else {
                layoutResource = 17367248;
            }
            this.removeFeature(8);
        } else if ((features & 2) == 0) {
            if (this.mIsFloating) {
                res = new TypedValue();
                this.getContext().getTheme().resolveAttribute(17891365, res, true);
                layoutResource = res.resourceId;
            } else {
                layoutResource = (features & 0x100) != 0 ? a.getResourceId(51, 17367247) : 17367253;
            }
        } else {
            layoutResource = (features & 0x400) != 0 ? 17367251 : 17367250;
        }
        this.mDecor.startChanging();
        this.mDecor.onResourcesLoaded(this.mLayoutInflater, layoutResource);
        ViewGroup contentParent = (ViewGroup)this.findViewById(0x1020002);
        if (contentParent == null) {
            throw new RuntimeException("Window couldn't find content container view");
        }
        if ((features & 0x20) != 0 && (progress = this.getCircularProgressBar(false)) != null) {
            progress.setIndeterminate(true);
        }
        if ((features & 0x800) != 0) {
            this.registerSwipeCallbacks(contentParent);
        }
        if (this.getContainer() == null) {
            Drawable background = this.mBackgroundResource != 0 ? this.getContext().getDrawable(this.mBackgroundResource) : this.mBackgroundDrawable;
            this.mDecor.setWindowBackground(background);
            Drawable frame = this.mFrameResource != 0 ? this.getContext().getDrawable(this.mFrameResource) : null;
            this.mDecor.setWindowFrame(frame);
            this.mDecor.setElevation(this.mElevation);
            this.mDecor.setClipToOutline(this.mClipToOutline);
            if (this.mTitle != null) {
                this.setTitle(this.mTitle);
            }
            if (this.mTitleColor == 0) {
                this.mTitleColor = this.mTextColor;
            }
            this.setTitleColor(this.mTitleColor);
        }
        this.mDecor.finishChanging();
        return contentParent;
    }

    @Override
    public void alwaysReadCloseOnTouchAttr() {
        this.mAlwaysReadCloseOnTouchAttr = true;
    }

    private void installDecor() {
        this.mForceDecorInstall = false;
        if (this.mDecor == null) {
            this.mDecor = this.generateDecor(-1);
            this.mDecor.setDescendantFocusability(262144);
            this.mDecor.setIsRootNamespace(true);
            if (!this.mInvalidatePanelMenuPosted && this.mInvalidatePanelMenuFeatures != 0) {
                this.mDecor.postOnAnimation(this.mInvalidatePanelMenuRunnable);
            }
        } else {
            this.mDecor.setWindow(this);
        }
        if (this.mContentParent == null) {
            this.mContentParent = this.generateLayout(this.mDecor);
            this.mDecor.makeOptionalFitsSystemWindows();
            DecorContentParent decorContentParent = (DecorContentParent)this.mDecor.findViewById(16908823);
            if (decorContentParent != null) {
                this.mDecorContentParent = decorContentParent;
                this.mDecorContentParent.setWindowCallback(this.getCallback());
                if (this.mDecorContentParent.getTitle() == null) {
                    this.mDecorContentParent.setWindowTitle(this.mTitle);
                }
                int localFeatures = this.getLocalFeatures();
                for (int i = 0; i < 13; ++i) {
                    if ((localFeatures & 1 << i) == 0) continue;
                    this.mDecorContentParent.initFeature(i);
                }
                this.mDecorContentParent.setUiOptions(this.mUiOptions);
                if ((this.mResourcesSetFlags & 1) != 0 || this.mIconRes != 0 && !this.mDecorContentParent.hasIcon()) {
                    this.mDecorContentParent.setIcon(this.mIconRes);
                } else if ((this.mResourcesSetFlags & 1) == 0 && this.mIconRes == 0 && !this.mDecorContentParent.hasIcon()) {
                    this.mDecorContentParent.setIcon(this.getContext().getPackageManager().getDefaultActivityIcon());
                    this.mResourcesSetFlags |= 4;
                }
                if ((this.mResourcesSetFlags & 2) != 0 || this.mLogoRes != 0 && !this.mDecorContentParent.hasLogo()) {
                    this.mDecorContentParent.setLogo(this.mLogoRes);
                }
                PanelFeatureState st = this.getPanelState(0, false);
                if (!(this.isDestroyed() || st != null && st.menu != null || this.mIsStartingWindow)) {
                    this.invalidatePanelMenu(8);
                }
            } else {
                this.mTitleView = (TextView)this.findViewById(16908310);
                if (this.mTitleView != null) {
                    if ((this.getLocalFeatures() & 2) != 0) {
                        Object titleContainer = this.findViewById(16909372);
                        if (titleContainer != null) {
                            ((View)titleContainer).setVisibility(8);
                        } else {
                            this.mTitleView.setVisibility(8);
                        }
                        this.mContentParent.setForeground(null);
                    } else {
                        this.mTitleView.setText(this.mTitle);
                    }
                }
            }
            if (this.mDecor.getBackground() == null && this.mBackgroundFallbackResource != 0) {
                this.mDecor.setBackgroundFallback(this.mBackgroundFallbackResource);
            }
            if (this.hasFeature(13)) {
                if (this.mTransitionManager == null) {
                    int transitionRes = this.getWindowStyle().getResourceId(27, 0);
                    if (transitionRes != 0) {
                        TransitionInflater inflater = TransitionInflater.from(this.getContext());
                        this.mTransitionManager = inflater.inflateTransitionManager(transitionRes, this.mContentParent);
                    } else {
                        this.mTransitionManager = new TransitionManager();
                    }
                }
                this.mEnterTransition = this.getTransition(this.mEnterTransition, null, 28);
                this.mReturnTransition = this.getTransition(this.mReturnTransition, USE_DEFAULT_TRANSITION, 40);
                this.mExitTransition = this.getTransition(this.mExitTransition, null, 29);
                this.mReenterTransition = this.getTransition(this.mReenterTransition, USE_DEFAULT_TRANSITION, 41);
                this.mSharedElementEnterTransition = this.getTransition(this.mSharedElementEnterTransition, null, 30);
                this.mSharedElementReturnTransition = this.getTransition(this.mSharedElementReturnTransition, USE_DEFAULT_TRANSITION, 42);
                this.mSharedElementExitTransition = this.getTransition(this.mSharedElementExitTransition, null, 31);
                this.mSharedElementReenterTransition = this.getTransition(this.mSharedElementReenterTransition, USE_DEFAULT_TRANSITION, 43);
                if (this.mAllowEnterTransitionOverlap == null) {
                    this.mAllowEnterTransitionOverlap = this.getWindowStyle().getBoolean(33, true);
                }
                if (this.mAllowReturnTransitionOverlap == null) {
                    this.mAllowReturnTransitionOverlap = this.getWindowStyle().getBoolean(32, true);
                }
                if (this.mBackgroundFadeDurationMillis < 0L) {
                    this.mBackgroundFadeDurationMillis = this.getWindowStyle().getInteger(37, 300);
                }
                if (this.mSharedElementsUseOverlay == null) {
                    this.mSharedElementsUseOverlay = this.getWindowStyle().getBoolean(44, true);
                }
            }
        }
    }

    private Transition getTransition(Transition currentValue, Transition defaultValue, int id2) {
        TransitionInflater inflater;
        if (currentValue != defaultValue) {
            return currentValue;
        }
        int transitionId = this.getWindowStyle().getResourceId(id2, -1);
        Transition transition2 = defaultValue;
        if (transitionId != -1 && transitionId != 0x10F0000 && (transition2 = (inflater = TransitionInflater.from(this.getContext())).inflateTransition(transitionId)) instanceof TransitionSet && ((TransitionSet)transition2).getTransitionCount() == 0) {
            transition2 = null;
        }
        return transition2;
    }

    private Drawable loadImageURI(Uri uri) {
        try {
            return Drawable.createFromStream(this.getContext().getContentResolver().openInputStream(uri), null);
        }
        catch (Exception e) {
            Log.w(TAG, "Unable to open content: " + uri);
            return null;
        }
    }

    private DrawableFeatureState getDrawableState(int featureId, boolean required) {
        DrawableFeatureState st;
        if ((this.getFeatures() & 1 << featureId) == 0) {
            if (!required) {
                return null;
            }
            throw new RuntimeException("The feature has not been requested");
        }
        DrawableFeatureState[] ar = this.mDrawables;
        if (this.mDrawables == null || ar.length <= featureId) {
            DrawableFeatureState[] nar = new DrawableFeatureState[featureId + 1];
            if (ar != null) {
                System.arraycopy(ar, 0, nar, 0, ar.length);
            }
            ar = nar;
            this.mDrawables = nar;
        }
        if ((st = ar[featureId]) == null) {
            ar[featureId] = st = new DrawableFeatureState(featureId);
        }
        return st;
    }

    PanelFeatureState getPanelState(int featureId, boolean required) {
        return this.getPanelState(featureId, required, null);
    }

    private PanelFeatureState getPanelState(int featureId, boolean required, PanelFeatureState convertPanelState) {
        PanelFeatureState st;
        if ((this.getFeatures() & 1 << featureId) == 0) {
            if (!required) {
                return null;
            }
            throw new RuntimeException("The feature has not been requested");
        }
        PanelFeatureState[] ar = this.mPanels;
        if (this.mPanels == null || ar.length <= featureId) {
            PanelFeatureState[] nar = new PanelFeatureState[featureId + 1];
            if (ar != null) {
                System.arraycopy(ar, 0, nar, 0, ar.length);
            }
            ar = nar;
            this.mPanels = nar;
        }
        if ((st = ar[featureId]) == null) {
            st = convertPanelState != null ? convertPanelState : new PanelFeatureState(featureId);
            ar[featureId] = st;
        }
        return st;
    }

    @Override
    public final void setChildDrawable(int featureId, Drawable drawable2) {
        DrawableFeatureState st = this.getDrawableState(featureId, true);
        st.child = drawable2;
        this.updateDrawable(featureId, st, false);
    }

    @Override
    public final void setChildInt(int featureId, int value) {
        this.updateInt(featureId, value, false);
    }

    @Override
    public boolean isShortcutKey(int keyCode, KeyEvent event) {
        PanelFeatureState st = this.getPanelState(0, false);
        return st != null && st.menu != null && st.menu.isShortcutKey(keyCode, event);
    }

    private void updateDrawable(int featureId, DrawableFeatureState st, boolean fromResume) {
        if (this.mContentParent == null) {
            return;
        }
        int featureMask = 1 << featureId;
        if ((this.getFeatures() & featureMask) == 0 && !fromResume) {
            return;
        }
        Drawable drawable2 = null;
        if (st != null) {
            drawable2 = st.child;
            if (drawable2 == null) {
                drawable2 = st.local;
            }
            if (drawable2 == null) {
                drawable2 = st.def;
            }
        }
        if ((this.getLocalFeatures() & featureMask) == 0) {
            if (this.getContainer() != null && (this.isActive() || fromResume)) {
                this.getContainer().setChildDrawable(featureId, drawable2);
            }
        } else if (st != null && (st.cur != drawable2 || st.curAlpha != st.alpha)) {
            st.cur = drawable2;
            st.curAlpha = st.alpha;
            this.onDrawableChanged(featureId, drawable2, st.alpha);
        }
    }

    private void updateInt(int featureId, int value, boolean fromResume) {
        if (this.mContentParent == null) {
            return;
        }
        int featureMask = 1 << featureId;
        if ((this.getFeatures() & featureMask) == 0 && !fromResume) {
            return;
        }
        if ((this.getLocalFeatures() & featureMask) == 0) {
            if (this.getContainer() != null) {
                this.getContainer().setChildInt(featureId, value);
            }
        } else {
            this.onIntChanged(featureId, value);
        }
    }

    private ImageView getLeftIconView() {
        if (this.mLeftIconView != null) {
            return this.mLeftIconView;
        }
        if (this.mContentParent == null) {
            this.installDecor();
        }
        this.mLeftIconView = (ImageView)this.findViewById(16909007);
        return this.mLeftIconView;
    }

    @Override
    protected void dispatchWindowAttributesChanged(WindowManager.LayoutParams attrs) {
        super.dispatchWindowAttributesChanged(attrs);
        if (this.mDecor != null) {
            this.mDecor.updateColorViews(null, true);
        }
    }

    private ProgressBar getCircularProgressBar(boolean shouldInstallDecor) {
        if (this.mCircularProgressBar != null) {
            return this.mCircularProgressBar;
        }
        if (this.mContentParent == null && shouldInstallDecor) {
            this.installDecor();
        }
        this.mCircularProgressBar = (ProgressBar)this.findViewById(16909177);
        if (this.mCircularProgressBar != null) {
            this.mCircularProgressBar.setVisibility(4);
        }
        return this.mCircularProgressBar;
    }

    private ProgressBar getHorizontalProgressBar(boolean shouldInstallDecor) {
        if (this.mHorizontalProgressBar != null) {
            return this.mHorizontalProgressBar;
        }
        if (this.mContentParent == null && shouldInstallDecor) {
            this.installDecor();
        }
        this.mHorizontalProgressBar = (ProgressBar)this.findViewById(16909178);
        if (this.mHorizontalProgressBar != null) {
            this.mHorizontalProgressBar.setVisibility(4);
        }
        return this.mHorizontalProgressBar;
    }

    private ImageView getRightIconView() {
        if (this.mRightIconView != null) {
            return this.mRightIconView;
        }
        if (this.mContentParent == null) {
            this.installDecor();
        }
        this.mRightIconView = (ImageView)this.findViewById(16909206);
        return this.mRightIconView;
    }

    private void registerSwipeCallbacks(ViewGroup contentParent) {
        if (!(contentParent instanceof SwipeDismissLayout)) {
            Log.w(TAG, "contentParent is not a SwipeDismissLayout: " + contentParent);
            return;
        }
        SwipeDismissLayout swipeDismiss = (SwipeDismissLayout)contentParent;
        swipeDismiss.setOnDismissedListener(new SwipeDismissLayout.OnDismissedListener(){

            @Override
            public void onDismissed(SwipeDismissLayout layout2) {
                PhoneWindow.this.dispatchOnWindowSwipeDismissed();
                PhoneWindow.this.dispatchOnWindowDismissed(false, true);
            }
        });
        swipeDismiss.setOnSwipeProgressChangedListener(new SwipeDismissLayout.OnSwipeProgressChangedListener(){

            @Override
            public void onSwipeProgressChanged(SwipeDismissLayout layout2, float alpha, float translate) {
                WindowManager.LayoutParams newParams = PhoneWindow.this.getAttributes();
                newParams.x = (int)translate;
                newParams.alpha = alpha;
                PhoneWindow.this.setAttributes(newParams);
                int flags = 0;
                flags = newParams.x == 0 ? 1024 : 512;
                PhoneWindow.this.setFlags(flags, 1536);
            }

            @Override
            public void onSwipeCancelled(SwipeDismissLayout layout2) {
                WindowManager.LayoutParams newParams = PhoneWindow.this.getAttributes();
                if (newParams.x != 0 || newParams.alpha != 1.0f) {
                    newParams.x = 0;
                    newParams.alpha = 1.0f;
                    PhoneWindow.this.setAttributes(newParams);
                    PhoneWindow.this.setFlags(1024, 1536);
                }
            }
        });
    }

    @Override
    public void setCloseOnSwipeEnabled(boolean closeOnSwipeEnabled) {
        if (this.hasFeature(11) && this.mContentParent instanceof SwipeDismissLayout) {
            ((SwipeDismissLayout)this.mContentParent).setDismissable(closeOnSwipeEnabled);
        }
        super.setCloseOnSwipeEnabled(closeOnSwipeEnabled);
    }

    private void callOnPanelClosed(int featureId, PanelFeatureState panel, Menu menu2) {
        Window.Callback cb = this.getCallback();
        if (cb == null) {
            return;
        }
        if (menu2 == null) {
            if (panel == null && featureId >= 0 && featureId < this.mPanels.length) {
                panel = this.mPanels[featureId];
            }
            if (panel != null) {
                menu2 = panel.menu;
            }
        }
        if (panel != null && !panel.isOpen) {
            return;
        }
        if (!this.isDestroyed()) {
            cb.onPanelClosed(featureId, menu2);
        }
    }

    private boolean isTvUserSetupComplete() {
        boolean isTvSetupComplete = Settings.Secure.getInt(this.getContext().getContentResolver(), "user_setup_complete", 0) != 0;
        return isTvSetupComplete &= Settings.Secure.getInt(this.getContext().getContentResolver(), "tv_user_setup_complete", 0) != 0;
    }

    private boolean launchDefaultSearch(KeyEvent event) {
        boolean result;
        if (this.getContext().getPackageManager().hasSystemFeature("android.software.leanback") && !this.isTvUserSetupComplete()) {
            return false;
        }
        Window.Callback cb = this.getCallback();
        if (cb == null || this.isDestroyed()) {
            result = false;
        } else {
            this.sendCloseSystemWindows("search");
            int deviceId = event.getDeviceId();
            SearchEvent searchEvent = null;
            if (deviceId != 0) {
                searchEvent = new SearchEvent(InputDevice.getDevice(deviceId));
            }
            try {
                result = cb.onSearchRequested(searchEvent);
            }
            catch (AbstractMethodError e) {
                Log.e(TAG, "WindowCallback " + cb.getClass().getName() + " does not implement method onSearchRequested(SearchEvent); fa", e);
                result = cb.onSearchRequested();
            }
        }
        if (!result && (this.getContext().getResources().getConfiguration().uiMode & 0xF) == 4) {
            Bundle args = new Bundle();
            args.putInt("android.intent.extra.ASSIST_INPUT_DEVICE_ID", event.getDeviceId());
            return ((SearchManager)this.getContext().getSystemService("search")).launchLegacyAssist(null, UserHandle.myUserId(), args);
        }
        return result;
    }

    @Override
    public void setVolumeControlStream(int streamType) {
        this.mVolumeControlStreamType = streamType;
    }

    @Override
    public int getVolumeControlStream() {
        return this.mVolumeControlStreamType;
    }

    @Override
    public void setMediaController(MediaController controller) {
        this.mMediaController = controller;
    }

    @Override
    public MediaController getMediaController() {
        return this.mMediaController;
    }

    @Override
    public void setEnterTransition(Transition enterTransition) {
        this.mEnterTransition = enterTransition;
    }

    @Override
    public void setReturnTransition(Transition transition2) {
        this.mReturnTransition = transition2;
    }

    @Override
    public void setExitTransition(Transition exitTransition) {
        this.mExitTransition = exitTransition;
    }

    @Override
    public void setReenterTransition(Transition transition2) {
        this.mReenterTransition = transition2;
    }

    @Override
    public void setSharedElementEnterTransition(Transition sharedElementEnterTransition) {
        this.mSharedElementEnterTransition = sharedElementEnterTransition;
    }

    @Override
    public void setSharedElementReturnTransition(Transition transition2) {
        this.mSharedElementReturnTransition = transition2;
    }

    @Override
    public void setSharedElementExitTransition(Transition sharedElementExitTransition) {
        this.mSharedElementExitTransition = sharedElementExitTransition;
    }

    @Override
    public void setSharedElementReenterTransition(Transition transition2) {
        this.mSharedElementReenterTransition = transition2;
    }

    @Override
    public Transition getEnterTransition() {
        return this.mEnterTransition;
    }

    @Override
    public Transition getReturnTransition() {
        return this.mReturnTransition == USE_DEFAULT_TRANSITION ? this.getEnterTransition() : this.mReturnTransition;
    }

    @Override
    public Transition getExitTransition() {
        return this.mExitTransition;
    }

    @Override
    public Transition getReenterTransition() {
        return this.mReenterTransition == USE_DEFAULT_TRANSITION ? this.getExitTransition() : this.mReenterTransition;
    }

    @Override
    public Transition getSharedElementEnterTransition() {
        return this.mSharedElementEnterTransition;
    }

    @Override
    public Transition getSharedElementReturnTransition() {
        return this.mSharedElementReturnTransition == USE_DEFAULT_TRANSITION ? this.getSharedElementEnterTransition() : this.mSharedElementReturnTransition;
    }

    @Override
    public Transition getSharedElementExitTransition() {
        return this.mSharedElementExitTransition;
    }

    @Override
    public Transition getSharedElementReenterTransition() {
        return this.mSharedElementReenterTransition == USE_DEFAULT_TRANSITION ? this.getSharedElementExitTransition() : this.mSharedElementReenterTransition;
    }

    @Override
    public void setAllowEnterTransitionOverlap(boolean allow) {
        this.mAllowEnterTransitionOverlap = allow;
    }

    @Override
    public boolean getAllowEnterTransitionOverlap() {
        return this.mAllowEnterTransitionOverlap == null ? true : this.mAllowEnterTransitionOverlap;
    }

    @Override
    public void setAllowReturnTransitionOverlap(boolean allowExitTransitionOverlap) {
        this.mAllowReturnTransitionOverlap = allowExitTransitionOverlap;
    }

    @Override
    public boolean getAllowReturnTransitionOverlap() {
        return this.mAllowReturnTransitionOverlap == null ? true : this.mAllowReturnTransitionOverlap;
    }

    @Override
    public long getTransitionBackgroundFadeDuration() {
        return this.mBackgroundFadeDurationMillis < 0L ? 300L : this.mBackgroundFadeDurationMillis;
    }

    @Override
    public void setTransitionBackgroundFadeDuration(long fadeDurationMillis) {
        if (fadeDurationMillis < 0L) {
            throw new IllegalArgumentException("negative durations are not allowed");
        }
        this.mBackgroundFadeDurationMillis = fadeDurationMillis;
    }

    @Override
    public void setSharedElementsUseOverlay(boolean sharedElementsUseOverlay) {
        this.mSharedElementsUseOverlay = sharedElementsUseOverlay;
    }

    @Override
    public boolean getSharedElementsUseOverlay() {
        return this.mSharedElementsUseOverlay == null ? true : this.mSharedElementsUseOverlay;
    }

    int getLocalFeaturesPrivate() {
        return super.getLocalFeatures();
    }

    @Override
    protected void setDefaultWindowFormat(int format) {
        super.setDefaultWindowFormat(format);
    }

    void sendCloseSystemWindows() {
        PhoneWindow.sendCloseSystemWindows(this.getContext(), null);
    }

    void sendCloseSystemWindows(String reason) {
        PhoneWindow.sendCloseSystemWindows(this.getContext(), reason);
    }

    public static void sendCloseSystemWindows(Context context, String reason) {
        if (ActivityManager.isSystemReady()) {
            try {
                ActivityManager.getService().closeSystemDialogs(reason);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    @Override
    public int getStatusBarColor() {
        return this.mStatusBarColor;
    }

    @Override
    public void setStatusBarColor(int color2) {
        this.mStatusBarColor = color2;
        this.mForcedStatusBarColor = true;
        if (this.mDecor != null) {
            this.mDecor.updateColorViews(null, false);
        }
    }

    @Override
    public int getNavigationBarColor() {
        return this.mNavigationBarColor;
    }

    @Override
    public void setNavigationBarColor(int color2) {
        this.mNavigationBarColor = color2;
        this.mForcedNavigationBarColor = true;
        if (this.mDecor != null) {
            this.mDecor.updateColorViews(null, false);
            this.mDecor.updateNavigationGuardColor();
        }
    }

    public void setIsStartingWindow(boolean isStartingWindow) {
        this.mIsStartingWindow = isStartingWindow;
    }

    @Override
    public void setTheme(int resid) {
        Context context;
        this.mTheme = resid;
        if (this.mDecor != null && (context = this.mDecor.getContext()) instanceof DecorContext) {
            context.setTheme(resid);
        }
    }

    @Override
    public void setResizingCaptionDrawable(Drawable drawable2) {
        this.mDecor.setUserCaptionBackgroundDrawable(drawable2);
    }

    @Override
    public void setDecorCaptionShade(int decorCaptionShade) {
        this.mDecorCaptionShade = decorCaptionShade;
        if (this.mDecor != null) {
            this.mDecor.updateDecorCaptionShade();
        }
    }

    int getDecorCaptionShade() {
        return this.mDecorCaptionShade;
    }

    @Override
    public void setAttributes(WindowManager.LayoutParams params) {
        super.setAttributes(params);
        if (this.mDecor != null) {
            this.mDecor.updateLogTag(params);
        }
    }

    public static final class PhoneWindowMenuCallback
    implements MenuBuilder.Callback,
    MenuPresenter.Callback {
        private static final int FEATURE_ID = 6;
        private final PhoneWindow mWindow;
        private MenuDialogHelper mSubMenuHelper;
        private boolean mShowDialogForSubmenu;

        public PhoneWindowMenuCallback(PhoneWindow window) {
            this.mWindow = window;
        }

        @Override
        public void onCloseMenu(MenuBuilder menu2, boolean allMenusAreClosing) {
            if (menu2.getRootMenu() != menu2) {
                this.onCloseSubMenu(menu2);
            }
            if (allMenusAreClosing) {
                Window.Callback callback = this.mWindow.getCallback();
                if (callback != null && !this.mWindow.isDestroyed()) {
                    callback.onPanelClosed(6, menu2);
                }
                if (menu2 == this.mWindow.mContextMenu) {
                    this.mWindow.dismissContextMenu();
                }
                if (this.mSubMenuHelper != null) {
                    this.mSubMenuHelper.dismiss();
                    this.mSubMenuHelper = null;
                }
            }
        }

        private void onCloseSubMenu(MenuBuilder menu2) {
            Window.Callback callback = this.mWindow.getCallback();
            if (callback != null && !this.mWindow.isDestroyed()) {
                callback.onPanelClosed(6, menu2.getRootMenu());
            }
        }

        @Override
        public boolean onMenuItemSelected(MenuBuilder menu2, MenuItem item) {
            Window.Callback callback = this.mWindow.getCallback();
            return callback != null && !this.mWindow.isDestroyed() && callback.onMenuItemSelected(6, item);
        }

        @Override
        public void onMenuModeChange(MenuBuilder menu2) {
        }

        @Override
        public boolean onOpenSubMenu(MenuBuilder subMenu) {
            if (subMenu == null) {
                return false;
            }
            subMenu.setCallback(this);
            if (this.mShowDialogForSubmenu) {
                this.mSubMenuHelper = new MenuDialogHelper(subMenu);
                this.mSubMenuHelper.show(null);
                return true;
            }
            return false;
        }

        public void setShowDialogForSubmenu(boolean enabled) {
            this.mShowDialogForSubmenu = enabled;
        }
    }

    static class RotationWatcher
    extends IRotationWatcher.Stub {
        private Handler mHandler;
        private final Runnable mRotationChanged = new Runnable(){

            @Override
            public void run() {
                this.dispatchRotationChanged();
            }
        };
        private final ArrayList<WeakReference<PhoneWindow>> mWindows = new ArrayList();
        private boolean mIsWatching;

        RotationWatcher() {
        }

        @Override
        public void onRotationChanged(int rotation) throws RemoteException {
            this.mHandler.post(this.mRotationChanged);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addWindow(PhoneWindow phoneWindow) {
            ArrayList<WeakReference<PhoneWindow>> arrayList = this.mWindows;
            synchronized (arrayList) {
                if (!this.mIsWatching) {
                    try {
                        WindowManagerHolder.sWindowManager.watchRotation(this, phoneWindow.getContext().getDisplay().getDisplayId());
                        this.mHandler = new Handler();
                        this.mIsWatching = true;
                    }
                    catch (RemoteException ex) {
                        Log.e(PhoneWindow.TAG, "Couldn't start watching for device rotation", ex);
                    }
                }
                this.mWindows.add(new WeakReference<PhoneWindow>(phoneWindow));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeWindow(PhoneWindow phoneWindow) {
            ArrayList<WeakReference<PhoneWindow>> arrayList = this.mWindows;
            synchronized (arrayList) {
                int i = 0;
                while (i < this.mWindows.size()) {
                    WeakReference<PhoneWindow> ref = this.mWindows.get(i);
                    PhoneWindow win = (PhoneWindow)ref.get();
                    if (win == null || win == phoneWindow) {
                        this.mWindows.remove(i);
                        continue;
                    }
                    ++i;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void dispatchRotationChanged() {
            ArrayList<WeakReference<PhoneWindow>> arrayList = this.mWindows;
            synchronized (arrayList) {
                int i = 0;
                while (i < this.mWindows.size()) {
                    WeakReference<PhoneWindow> ref = this.mWindows.get(i);
                    PhoneWindow win = (PhoneWindow)ref.get();
                    if (win != null) {
                        win.onOptionsPanelRotationChanged();
                        ++i;
                        continue;
                    }
                    this.mWindows.remove(i);
                }
            }
        }
    }

    static final class PanelFeatureState {
        int featureId;
        int background;
        int fullBackground;
        int gravity;
        int x;
        int y;
        int windowAnimations;
        DecorView decorView;
        View createdPanelView;
        View shownPanelView;
        MenuBuilder menu;
        IconMenuPresenter iconMenuPresenter;
        ListMenuPresenter listMenuPresenter;
        boolean isCompact;
        int listPresenterTheme;
        boolean isPrepared;
        boolean isHandled;
        boolean isOpen;
        boolean isInExpandedMode;
        public boolean qwertyMode;
        boolean refreshDecorView;
        boolean refreshMenuContent;
        boolean wasLastOpen;
        boolean wasLastExpanded;
        Bundle frozenMenuState;
        Bundle frozenActionViewState;

        PanelFeatureState(int featureId) {
            this.featureId = featureId;
            this.refreshDecorView = false;
        }

        public boolean isInListMode() {
            return this.isInExpandedMode || this.isCompact;
        }

        public boolean hasPanelItems() {
            if (this.shownPanelView == null) {
                return false;
            }
            if (this.createdPanelView != null) {
                return true;
            }
            if (this.isCompact || this.isInExpandedMode) {
                return this.listMenuPresenter.getAdapter().getCount() > 0;
            }
            return ((ViewGroup)this.shownPanelView).getChildCount() > 0;
        }

        public void clearMenuPresenters() {
            if (this.menu != null) {
                this.menu.removeMenuPresenter(this.iconMenuPresenter);
                this.menu.removeMenuPresenter(this.listMenuPresenter);
            }
            this.iconMenuPresenter = null;
            this.listMenuPresenter = null;
        }

        void setStyle(Context context) {
            TypedArray a = context.obtainStyledAttributes(R.styleable.Theme);
            this.background = a.getResourceId(46, 0);
            this.fullBackground = a.getResourceId(47, 0);
            this.windowAnimations = a.getResourceId(93, 0);
            this.isCompact = a.getBoolean(306, false);
            this.listPresenterTheme = a.getResourceId(307, 16974801);
            a.recycle();
        }

        void setMenu(MenuBuilder menu2) {
            if (menu2 == this.menu) {
                return;
            }
            if (this.menu != null) {
                this.menu.removeMenuPresenter(this.iconMenuPresenter);
                this.menu.removeMenuPresenter(this.listMenuPresenter);
            }
            this.menu = menu2;
            if (menu2 != null) {
                if (this.iconMenuPresenter != null) {
                    menu2.addMenuPresenter(this.iconMenuPresenter);
                }
                if (this.listMenuPresenter != null) {
                    menu2.addMenuPresenter(this.listMenuPresenter);
                }
            }
        }

        MenuView getListMenuView(Context context, MenuPresenter.Callback cb) {
            if (this.menu == null) {
                return null;
            }
            if (!this.isCompact) {
                this.getIconMenuView(context, cb);
            }
            if (this.listMenuPresenter == null) {
                this.listMenuPresenter = new ListMenuPresenter(17367164, this.listPresenterTheme);
                this.listMenuPresenter.setCallback(cb);
                this.listMenuPresenter.setId(16909016);
                this.menu.addMenuPresenter(this.listMenuPresenter);
            }
            if (this.iconMenuPresenter != null) {
                this.listMenuPresenter.setItemIndexOffset(this.iconMenuPresenter.getNumActualItemsShown());
            }
            MenuView result = this.listMenuPresenter.getMenuView(this.decorView);
            return result;
        }

        MenuView getIconMenuView(Context context, MenuPresenter.Callback cb) {
            if (this.menu == null) {
                return null;
            }
            if (this.iconMenuPresenter == null) {
                this.iconMenuPresenter = new IconMenuPresenter(context);
                this.iconMenuPresenter.setCallback(cb);
                this.iconMenuPresenter.setId(16908940);
                this.menu.addMenuPresenter(this.iconMenuPresenter);
            }
            MenuView result = this.iconMenuPresenter.getMenuView(this.decorView);
            return result;
        }

        Parcelable onSaveInstanceState() {
            SavedState savedState = new SavedState();
            savedState.featureId = this.featureId;
            savedState.isOpen = this.isOpen;
            savedState.isInExpandedMode = this.isInExpandedMode;
            if (this.menu != null) {
                savedState.menuState = new Bundle();
                this.menu.savePresenterStates(savedState.menuState);
            }
            return savedState;
        }

        void onRestoreInstanceState(Parcelable state) {
            SavedState savedState = (SavedState)state;
            this.featureId = savedState.featureId;
            this.wasLastOpen = savedState.isOpen;
            this.wasLastExpanded = savedState.isInExpandedMode;
            this.frozenMenuState = savedState.menuState;
            this.createdPanelView = null;
            this.shownPanelView = null;
            this.decorView = null;
        }

        void applyFrozenState() {
            if (this.menu != null && this.frozenMenuState != null) {
                this.menu.restorePresenterStates(this.frozenMenuState);
                this.frozenMenuState = null;
            }
        }

        private static class SavedState
        implements Parcelable {
            int featureId;
            boolean isOpen;
            boolean isInExpandedMode;
            Bundle menuState;
            public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

                @Override
                public SavedState createFromParcel(Parcel in) {
                    return SavedState.readFromParcel(in);
                }

                public SavedState[] newArray(int size) {
                    return new SavedState[size];
                }
            };

            private SavedState() {
            }

            @Override
            public int describeContents() {
                return 0;
            }

            @Override
            public void writeToParcel(Parcel dest, int flags) {
                dest.writeInt(this.featureId);
                dest.writeInt(this.isOpen ? 1 : 0);
                dest.writeInt(this.isInExpandedMode ? 1 : 0);
                if (this.isOpen) {
                    dest.writeBundle(this.menuState);
                }
            }

            private static SavedState readFromParcel(Parcel source) {
                SavedState savedState = new SavedState();
                savedState.featureId = source.readInt();
                savedState.isOpen = source.readInt() == 1;
                boolean bl = savedState.isInExpandedMode = source.readInt() == 1;
                if (savedState.isOpen) {
                    savedState.menuState = source.readBundle();
                }
                return savedState;
            }
        }
    }

    private static final class DrawableFeatureState {
        final int featureId;
        int resid;
        Uri uri;
        Drawable local;
        Drawable child;
        Drawable def;
        Drawable cur;
        int alpha = 255;
        int curAlpha = 255;

        DrawableFeatureState(int _featureId) {
            this.featureId = _featureId;
        }
    }

    private final class ActionMenuPresenterCallback
    implements MenuPresenter.Callback {
        private ActionMenuPresenterCallback() {
        }

        @Override
        public boolean onOpenSubMenu(MenuBuilder subMenu) {
            Window.Callback cb = PhoneWindow.this.getCallback();
            if (cb != null) {
                cb.onMenuOpened(8, subMenu);
                return true;
            }
            return false;
        }

        @Override
        public void onCloseMenu(MenuBuilder menu2, boolean allMenusAreClosing) {
            PhoneWindow.this.checkCloseActionMenu(menu2);
        }
    }

    private class PanelMenuPresenterCallback
    implements MenuPresenter.Callback {
        private PanelMenuPresenterCallback() {
        }

        @Override
        public void onCloseMenu(MenuBuilder menu2, boolean allMenusAreClosing) {
            MenuBuilder parentMenu = menu2.getRootMenu();
            boolean isSubMenu = parentMenu != menu2;
            PanelFeatureState panel = PhoneWindow.this.findMenuPanel(isSubMenu ? parentMenu : menu2);
            if (panel != null) {
                if (isSubMenu) {
                    PhoneWindow.this.callOnPanelClosed(panel.featureId, panel, parentMenu);
                    PhoneWindow.this.closePanel(panel, true);
                } else {
                    PhoneWindow.this.closePanel(panel, allMenusAreClosing);
                }
            }
        }

        @Override
        public boolean onOpenSubMenu(MenuBuilder subMenu) {
            Window.Callback cb;
            if (subMenu == null && PhoneWindow.this.hasFeature(8) && (cb = PhoneWindow.this.getCallback()) != null && !PhoneWindow.this.isDestroyed()) {
                cb.onMenuOpened(8, subMenu);
            }
            return true;
        }
    }

    static class WindowManagerHolder {
        static final IWindowManager sWindowManager = IWindowManager.Stub.asInterface(ServiceManager.getService("window"));

        WindowManagerHolder() {
        }
    }
}

