/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.net.LocalServerSocket;
import android.net.LocalSocket;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.system.StructPollfd;
import android.util.Log;
import android.util.Slog;
import com.android.internal.os.ZygoteConnection;
import java.io.FileDescriptor;
import java.io.IOException;
import java.util.ArrayList;

class ZygoteServer {
    public static final String TAG = "ZygoteServer";
    private static final String ANDROID_SOCKET_PREFIX = "ANDROID_SOCKET_";
    private LocalServerSocket mServerSocket;
    private boolean mIsForkChild;

    ZygoteServer() {
    }

    void setForkChild() {
        this.mIsForkChild = true;
    }

    void registerServerSocket(String socketName) {
        if (this.mServerSocket == null) {
            int fileDesc;
            String fullSocketName = ANDROID_SOCKET_PREFIX + socketName;
            try {
                String env = System.getenv(fullSocketName);
                fileDesc = Integer.parseInt(env);
            }
            catch (RuntimeException ex) {
                throw new RuntimeException(fullSocketName + " unset or invalid", ex);
            }
            try {
                FileDescriptor fd = new FileDescriptor();
                fd.setInt$(fileDesc);
                this.mServerSocket = new LocalServerSocket(fd);
            }
            catch (IOException ex) {
                throw new RuntimeException("Error binding to local socket '" + fileDesc + "'", ex);
            }
        }
    }

    private ZygoteConnection acceptCommandPeer(String abiList) {
        try {
            return this.createNewConnection(this.mServerSocket.accept(), abiList);
        }
        catch (IOException ex) {
            throw new RuntimeException("IOException during accept()", ex);
        }
    }

    protected ZygoteConnection createNewConnection(LocalSocket socket, String abiList) throws IOException {
        return new ZygoteConnection(socket, abiList);
    }

    void closeServerSocket() {
        try {
            if (this.mServerSocket != null) {
                FileDescriptor fd = this.mServerSocket.getFileDescriptor();
                this.mServerSocket.close();
                if (fd != null) {
                    Os.close(fd);
                }
            }
        }
        catch (IOException ex) {
            Log.e(TAG, "Zygote:  error closing sockets", ex);
        }
        catch (ErrnoException ex) {
            Log.e(TAG, "Zygote:  error closing descriptor", ex);
        }
        this.mServerSocket = null;
    }

    FileDescriptor getServerSocketFileDescriptor() {
        return this.mServerSocket.getFileDescriptor();
    }

    Runnable runSelectLoop(String abiList) {
        ArrayList<FileDescriptor> fds = new ArrayList<FileDescriptor>();
        ArrayList<ZygoteConnection> peers = new ArrayList<ZygoteConnection>();
        fds.add(this.mServerSocket.getFileDescriptor());
        peers.add(null);
        block4: while (true) {
            int i;
            StructPollfd[] pollFds = new StructPollfd[fds.size()];
            for (i = 0; i < pollFds.length; ++i) {
                pollFds[i] = new StructPollfd();
                pollFds[i].fd = (FileDescriptor)fds.get(i);
                pollFds[i].events = (short)OsConstants.POLLIN;
            }
            try {
                Os.poll(pollFds, -1);
            }
            catch (ErrnoException ex) {
                throw new RuntimeException("poll failed", ex);
            }
            i = pollFds.length - 1;
            while (true) {
                if (i < 0) continue block4;
                if ((pollFds[i].revents & OsConstants.POLLIN) != 0) {
                    if (i == 0) {
                        ZygoteConnection newPeer = this.acceptCommandPeer(abiList);
                        peers.add(newPeer);
                        fds.add(newPeer.getFileDesciptor());
                    } else {
                        try {
                            ZygoteConnection connection = (ZygoteConnection)peers.get(i);
                            Runnable command = connection.processOneCommand(this);
                            if (this.mIsForkChild) {
                                if (command == null) {
                                    throw new IllegalStateException("command == null");
                                }
                                return command;
                            }
                            if (command != null) {
                                throw new IllegalStateException("command != null");
                            }
                            if (connection.isClosedByPeer()) {
                                connection.closeSocket();
                                peers.remove(i);
                                fds.remove(i);
                            }
                        }
                        catch (Exception e) {
                            if (!this.mIsForkChild) {
                                Slog.e(TAG, "Exception executing zygote command: ", e);
                                ZygoteConnection conn = (ZygoteConnection)peers.remove(i);
                                conn.closeSocket();
                                fds.remove(i);
                            }
                            Log.e(TAG, "Caught post-fork exception in child process.", e);
                            throw e;
                        }
                    }
                }
                --i;
            }
            break;
        }
    }
}

