/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.BatteryStats;
import com.android.internal.os.BatterySipper;
import com.android.internal.os.PowerCalculator;
import com.android.internal.os.PowerProfile;

public class MobileRadioPowerCalculator
extends PowerCalculator {
    private static final String TAG = "MobileRadioPowerController";
    private static final boolean DEBUG = false;
    private final double mPowerRadioOn;
    private final double[] mPowerBins = new double[5];
    private final double mPowerScan;
    private BatteryStats mStats;
    private long mTotalAppMobileActiveMs = 0L;

    private double getMobilePowerPerPacket(long rawRealtimeUs, int statsType) {
        long MOBILE_BPS = 200000L;
        double MOBILE_POWER = this.mPowerRadioOn / 3600.0;
        long mobileRx = this.mStats.getNetworkActivityPackets(0, statsType);
        long mobileTx = this.mStats.getNetworkActivityPackets(1, statsType);
        long mobileData = mobileRx + mobileTx;
        long radioDataUptimeMs = this.mStats.getMobileRadioActiveTime(rawRealtimeUs, statsType) / 1000L;
        double mobilePps = mobileData != 0L && radioDataUptimeMs != 0L ? (double)mobileData / (double)radioDataUptimeMs : 12.20703125;
        return MOBILE_POWER / mobilePps / 3600.0;
    }

    public MobileRadioPowerCalculator(PowerProfile profile, BatteryStats stats) {
        this.mPowerRadioOn = profile.getAveragePower("radio.active");
        for (int i = 0; i < this.mPowerBins.length; ++i) {
            this.mPowerBins[i] = profile.getAveragePower("radio.on", i);
        }
        this.mPowerScan = profile.getAveragePower("radio.scanning");
        this.mStats = stats;
    }

    @Override
    public void calculateApp(BatterySipper app, BatteryStats.Uid u, long rawRealtimeUs, long rawUptimeUs, int statsType) {
        app.mobileRxPackets = u.getNetworkActivityPackets(0, statsType);
        app.mobileTxPackets = u.getNetworkActivityPackets(1, statsType);
        app.mobileActive = u.getMobileRadioActiveTime(statsType) / 1000L;
        app.mobileActiveCount = u.getMobileRadioActiveCount(statsType);
        app.mobileRxBytes = u.getNetworkActivityBytes(0, statsType);
        app.mobileTxBytes = u.getNetworkActivityBytes(1, statsType);
        if (app.mobileActive > 0L) {
            this.mTotalAppMobileActiveMs += app.mobileActive;
            app.mobileRadioPowerMah = (double)app.mobileActive * this.mPowerRadioOn / 3600000.0;
        } else {
            app.mobileRadioPowerMah = (double)(app.mobileRxPackets + app.mobileTxPackets) * this.getMobilePowerPerPacket(rawRealtimeUs, statsType);
        }
    }

    @Override
    public void calculateRemaining(BatterySipper app, BatteryStats stats, long rawRealtimeUs, long rawUptimeUs, int statsType) {
        double power = 0.0;
        long signalTimeMs = 0L;
        long noCoverageTimeMs = 0L;
        for (int i = 0; i < this.mPowerBins.length; ++i) {
            long strengthTimeMs = stats.getPhoneSignalStrengthTime(i, rawRealtimeUs, statsType) / 1000L;
            double p = (double)strengthTimeMs * this.mPowerBins[i] / 3600000.0;
            power += p;
            signalTimeMs += strengthTimeMs;
            if (i != 0) continue;
            noCoverageTimeMs = strengthTimeMs;
        }
        long scanningTimeMs = stats.getPhoneSignalScanningTime(rawRealtimeUs, statsType) / 1000L;
        double p = (double)scanningTimeMs * this.mPowerScan / 3600000.0;
        power += p;
        long radioActiveTimeMs = this.mStats.getMobileRadioActiveTime(rawRealtimeUs, statsType) / 1000L;
        long remainingActiveTimeMs = radioActiveTimeMs - this.mTotalAppMobileActiveMs;
        if (remainingActiveTimeMs > 0L) {
            power += this.mPowerRadioOn * (double)remainingActiveTimeMs / 3600000.0;
        }
        if (power != 0.0) {
            if (signalTimeMs != 0L) {
                app.noCoveragePercent = (double)noCoverageTimeMs * 100.0 / (double)signalTimeMs;
            }
            app.mobileActive = remainingActiveTimeMs;
            app.mobileActiveCount = stats.getMobileRadioActiveUnknownCount(statsType);
            app.mobileRadioPowerMah = power;
        }
    }

    @Override
    public void reset() {
        this.mTotalAppMobileActiveMs = 0L;
    }

    public void reset(BatteryStats stats) {
        this.reset();
        this.mStats = stats;
    }
}

