/*
 * Decompiled with CFR 0.152.
 */
package com.android.ims.internal;

import android.telecom.Log;
import android.util.ArraySet;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;

public class VideoPauseTracker {
    public static final int SOURCE_INCALL = 1;
    public static final int SOURCE_DATA_ENABLED = 2;
    private static final String SOURCE_INCALL_STR = "INCALL";
    private static final String SOURCE_DATA_ENABLED_STR = "DATA_ENABLED";
    private Set<Integer> mPauseRequests = new ArraySet<Integer>(2);
    private Object mPauseRequestsLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldPauseVideoFor(int source) {
        Object object = this.mPauseRequestsLock;
        synchronized (object) {
            boolean wasPaused = this.isPaused();
            this.mPauseRequests.add(source);
            if (!wasPaused) {
                Log.i(this, "shouldPauseVideoFor: source=%s, pendingRequests=%s - should pause", this.sourceToString(source), this.sourcesToString(this.mPauseRequests));
                return true;
            }
            Log.i(this, "shouldPauseVideoFor: source=%s, pendingRequests=%s - already paused", this.sourceToString(source), this.sourcesToString(this.mPauseRequests));
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldResumeVideoFor(int source) {
        Object object = this.mPauseRequestsLock;
        synchronized (object) {
            boolean wasPaused = this.isPaused();
            this.mPauseRequests.remove(source);
            boolean isPaused = this.isPaused();
            if (wasPaused && !isPaused) {
                Log.i(this, "shouldResumeVideoFor: source=%s, pendingRequests=%s - should resume", this.sourceToString(source), this.sourcesToString(this.mPauseRequests));
                return true;
            }
            if (wasPaused && isPaused) {
                Log.i(this, "shouldResumeVideoFor: source=%s, pendingRequests=%s - stay paused", this.sourceToString(source), this.sourcesToString(this.mPauseRequests));
                return false;
            }
            Log.i(this, "shouldResumeVideoFor: source=%s, pendingRequests=%s - not paused", this.sourceToString(source), this.sourcesToString(this.mPauseRequests));
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPaused() {
        Object object = this.mPauseRequestsLock;
        synchronized (object) {
            return !this.mPauseRequests.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean wasVideoPausedFromSource(int source) {
        Object object = this.mPauseRequestsLock;
        synchronized (object) {
            return this.mPauseRequests.contains(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearPauseRequests() {
        Object object = this.mPauseRequestsLock;
        synchronized (object) {
            this.mPauseRequests.clear();
        }
    }

    private String sourceToString(int source) {
        switch (source) {
            case 2: {
                return SOURCE_DATA_ENABLED_STR;
            }
            case 1: {
                return SOURCE_INCALL_STR;
            }
        }
        return "unknown";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String sourcesToString(Collection<Integer> sources) {
        Object object = this.mPauseRequestsLock;
        synchronized (object) {
            return sources.stream().map(source -> this.sourceToString((int)source)).collect(Collectors.joining(", "));
        }
    }
}

