/*
 * Decompiled with CFR 0.152.
 */
package com.android.ims.internal;

import android.os.Message;
import android.os.RemoteException;
import android.telephony.ims.stub.ImsCallSessionListenerImplBase;
import android.util.Log;
import com.android.ims.ImsCallProfile;
import com.android.ims.ImsConferenceState;
import com.android.ims.ImsReasonInfo;
import com.android.ims.ImsStreamMediaProfile;
import com.android.ims.ImsSuppServiceNotification;
import com.android.ims.internal.IImsCallSession;
import com.android.ims.internal.IImsVideoCallProvider;
import java.util.Objects;

public class ImsCallSession {
    private static final String TAG = "ImsCallSession";
    private final IImsCallSession miSession;
    private boolean mClosed = false;
    private Listener mListener;

    public ImsCallSession(IImsCallSession iSession) {
        this.miSession = iSession;
        if (iSession != null) {
            try {
                iSession.setListener(new IImsCallSessionListenerProxy());
            }
            catch (RemoteException remoteException) {}
        } else {
            this.mClosed = true;
        }
    }

    public ImsCallSession(IImsCallSession iSession, Listener listener) {
        this(iSession);
        this.setListener(listener);
    }

    public synchronized void close() {
        if (this.mClosed) {
            return;
        }
        try {
            this.miSession.close();
            this.mClosed = true;
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public String getCallId() {
        if (this.mClosed) {
            return null;
        }
        try {
            return this.miSession.getCallId();
        }
        catch (RemoteException e) {
            return null;
        }
    }

    public ImsCallProfile getCallProfile() {
        if (this.mClosed) {
            return null;
        }
        try {
            return this.miSession.getCallProfile();
        }
        catch (RemoteException e) {
            return null;
        }
    }

    public ImsCallProfile getLocalCallProfile() {
        if (this.mClosed) {
            return null;
        }
        try {
            return this.miSession.getLocalCallProfile();
        }
        catch (RemoteException e) {
            return null;
        }
    }

    public ImsCallProfile getRemoteCallProfile() {
        if (this.mClosed) {
            return null;
        }
        try {
            return this.miSession.getRemoteCallProfile();
        }
        catch (RemoteException e) {
            return null;
        }
    }

    public IImsVideoCallProvider getVideoCallProvider() {
        if (this.mClosed) {
            return null;
        }
        try {
            return this.miSession.getVideoCallProvider();
        }
        catch (RemoteException e) {
            return null;
        }
    }

    public String getProperty(String name) {
        if (this.mClosed) {
            return null;
        }
        try {
            return this.miSession.getProperty(name);
        }
        catch (RemoteException e) {
            return null;
        }
    }

    public int getState() {
        if (this.mClosed) {
            return -1;
        }
        try {
            return this.miSession.getState();
        }
        catch (RemoteException e) {
            return -1;
        }
    }

    public boolean isAlive() {
        if (this.mClosed) {
            return false;
        }
        int state = this.getState();
        switch (state) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    public IImsCallSession getSession() {
        return this.miSession;
    }

    public boolean isInCall() {
        if (this.mClosed) {
            return false;
        }
        try {
            return this.miSession.isInCall();
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public void setListener(Listener listener) {
        this.mListener = listener;
    }

    public void setMute(boolean muted) {
        if (this.mClosed) {
            return;
        }
        try {
            this.miSession.setMute(muted);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void start(String callee, ImsCallProfile profile) {
        if (this.mClosed) {
            return;
        }
        try {
            this.miSession.start(callee, profile);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void start(String[] participants, ImsCallProfile profile) {
        if (this.mClosed) {
            return;
        }
        try {
            this.miSession.startConference(participants, profile);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void accept(int callType, ImsStreamMediaProfile profile) {
        if (this.mClosed) {
            return;
        }
        try {
            this.miSession.accept(callType, profile);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void reject(int reason) {
        if (this.mClosed) {
            return;
        }
        try {
            this.miSession.reject(reason);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void terminate(int reason) {
        if (this.mClosed) {
            return;
        }
        try {
            this.miSession.terminate(reason);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void hold(ImsStreamMediaProfile profile) {
        if (this.mClosed) {
            return;
        }
        try {
            this.miSession.hold(profile);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void resume(ImsStreamMediaProfile profile) {
        if (this.mClosed) {
            return;
        }
        try {
            this.miSession.resume(profile);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void merge() {
        if (this.mClosed) {
            return;
        }
        try {
            this.miSession.merge();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void update(int callType, ImsStreamMediaProfile profile) {
        if (this.mClosed) {
            return;
        }
        try {
            this.miSession.update(callType, profile);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void extendToConference(String[] participants) {
        if (this.mClosed) {
            return;
        }
        try {
            this.miSession.extendToConference(participants);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void inviteParticipants(String[] participants) {
        if (this.mClosed) {
            return;
        }
        try {
            this.miSession.inviteParticipants(participants);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void removeParticipants(String[] participants) {
        if (this.mClosed) {
            return;
        }
        try {
            this.miSession.removeParticipants(participants);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void sendDtmf(char c, Message result) {
        if (this.mClosed) {
            return;
        }
        try {
            this.miSession.sendDtmf(c, result);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void startDtmf(char c) {
        if (this.mClosed) {
            return;
        }
        try {
            this.miSession.startDtmf(c);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void stopDtmf() {
        if (this.mClosed) {
            return;
        }
        try {
            this.miSession.stopDtmf();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void sendUssd(String ussdMessage) {
        if (this.mClosed) {
            return;
        }
        try {
            this.miSession.sendUssd(ussdMessage);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public boolean isMultiparty() {
        if (this.mClosed) {
            return false;
        }
        try {
            return this.miSession.isMultiparty();
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public void sendRttMessage(String rttMessage) {
        if (this.mClosed) {
            return;
        }
        try {
            this.miSession.sendRttMessage(rttMessage);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void sendRttModifyRequest(ImsCallProfile to) {
        if (this.mClosed) {
            return;
        }
        try {
            this.miSession.sendRttModifyRequest(to);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void sendRttModifyResponse(boolean response) {
        if (this.mClosed) {
            return;
        }
        try {
            this.miSession.sendRttModifyResponse(response);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[ImsCallSession objId:");
        sb.append(System.identityHashCode(this));
        sb.append(" state:");
        sb.append(State.toString(this.getState()));
        sb.append(" callId:");
        sb.append(this.getCallId());
        sb.append("]");
        return sb.toString();
    }

    private class IImsCallSessionListenerProxy
    extends ImsCallSessionListenerImplBase {
        private IImsCallSessionListenerProxy() {
        }

        @Override
        public void callSessionProgressing(IImsCallSession session, ImsStreamMediaProfile profile) {
            if (ImsCallSession.this.mListener != null) {
                ImsCallSession.this.mListener.callSessionProgressing(ImsCallSession.this, profile);
            }
        }

        @Override
        public void callSessionStarted(IImsCallSession session, ImsCallProfile profile) {
            if (ImsCallSession.this.mListener != null) {
                ImsCallSession.this.mListener.callSessionStarted(ImsCallSession.this, profile);
            }
        }

        @Override
        public void callSessionStartFailed(IImsCallSession session, ImsReasonInfo reasonInfo) {
            if (ImsCallSession.this.mListener != null) {
                ImsCallSession.this.mListener.callSessionStartFailed(ImsCallSession.this, reasonInfo);
            }
        }

        @Override
        public void callSessionTerminated(IImsCallSession session, ImsReasonInfo reasonInfo) {
            if (ImsCallSession.this.mListener != null) {
                ImsCallSession.this.mListener.callSessionTerminated(ImsCallSession.this, reasonInfo);
            }
        }

        @Override
        public void callSessionHeld(IImsCallSession session, ImsCallProfile profile) {
            if (ImsCallSession.this.mListener != null) {
                ImsCallSession.this.mListener.callSessionHeld(ImsCallSession.this, profile);
            }
        }

        @Override
        public void callSessionHoldFailed(IImsCallSession session, ImsReasonInfo reasonInfo) {
            if (ImsCallSession.this.mListener != null) {
                ImsCallSession.this.mListener.callSessionHoldFailed(ImsCallSession.this, reasonInfo);
            }
        }

        @Override
        public void callSessionHoldReceived(IImsCallSession session, ImsCallProfile profile) {
            if (ImsCallSession.this.mListener != null) {
                ImsCallSession.this.mListener.callSessionHoldReceived(ImsCallSession.this, profile);
            }
        }

        @Override
        public void callSessionResumed(IImsCallSession session, ImsCallProfile profile) {
            if (ImsCallSession.this.mListener != null) {
                ImsCallSession.this.mListener.callSessionResumed(ImsCallSession.this, profile);
            }
        }

        @Override
        public void callSessionResumeFailed(IImsCallSession session, ImsReasonInfo reasonInfo) {
            if (ImsCallSession.this.mListener != null) {
                ImsCallSession.this.mListener.callSessionResumeFailed(ImsCallSession.this, reasonInfo);
            }
        }

        @Override
        public void callSessionResumeReceived(IImsCallSession session, ImsCallProfile profile) {
            if (ImsCallSession.this.mListener != null) {
                ImsCallSession.this.mListener.callSessionResumeReceived(ImsCallSession.this, profile);
            }
        }

        @Override
        public void callSessionMergeStarted(IImsCallSession session, IImsCallSession newSession, ImsCallProfile profile) {
            Log.d(ImsCallSession.TAG, "callSessionMergeStarted");
        }

        @Override
        public void callSessionMergeComplete(IImsCallSession newSession) {
            if (ImsCallSession.this.mListener != null) {
                if (newSession != null) {
                    ImsCallSession validActiveSession = ImsCallSession.this;
                    try {
                        if (!Objects.equals(ImsCallSession.this.miSession.getCallId(), newSession.getCallId())) {
                            validActiveSession = new ImsCallSession(newSession);
                        }
                    }
                    catch (RemoteException rex) {
                        Log.e(ImsCallSession.TAG, "callSessionMergeComplete: exception for getCallId!");
                    }
                    ImsCallSession.this.mListener.callSessionMergeComplete(validActiveSession);
                } else {
                    ImsCallSession.this.mListener.callSessionMergeComplete(null);
                }
            }
        }

        @Override
        public void callSessionMergeFailed(IImsCallSession session, ImsReasonInfo reasonInfo) {
            if (ImsCallSession.this.mListener != null) {
                ImsCallSession.this.mListener.callSessionMergeFailed(ImsCallSession.this, reasonInfo);
            }
        }

        @Override
        public void callSessionUpdated(IImsCallSession session, ImsCallProfile profile) {
            if (ImsCallSession.this.mListener != null) {
                ImsCallSession.this.mListener.callSessionUpdated(ImsCallSession.this, profile);
            }
        }

        @Override
        public void callSessionUpdateFailed(IImsCallSession session, ImsReasonInfo reasonInfo) {
            if (ImsCallSession.this.mListener != null) {
                ImsCallSession.this.mListener.callSessionUpdateFailed(ImsCallSession.this, reasonInfo);
            }
        }

        @Override
        public void callSessionUpdateReceived(IImsCallSession session, ImsCallProfile profile) {
            if (ImsCallSession.this.mListener != null) {
                ImsCallSession.this.mListener.callSessionUpdateReceived(ImsCallSession.this, profile);
            }
        }

        @Override
        public void callSessionConferenceExtended(IImsCallSession session, IImsCallSession newSession, ImsCallProfile profile) {
            if (ImsCallSession.this.mListener != null) {
                ImsCallSession.this.mListener.callSessionConferenceExtended(ImsCallSession.this, new ImsCallSession(newSession), profile);
            }
        }

        @Override
        public void callSessionConferenceExtendFailed(IImsCallSession session, ImsReasonInfo reasonInfo) {
            if (ImsCallSession.this.mListener != null) {
                ImsCallSession.this.mListener.callSessionConferenceExtendFailed(ImsCallSession.this, reasonInfo);
            }
        }

        @Override
        public void callSessionConferenceExtendReceived(IImsCallSession session, IImsCallSession newSession, ImsCallProfile profile) {
            if (ImsCallSession.this.mListener != null) {
                ImsCallSession.this.mListener.callSessionConferenceExtendReceived(ImsCallSession.this, new ImsCallSession(newSession), profile);
            }
        }

        @Override
        public void callSessionInviteParticipantsRequestDelivered(IImsCallSession session) {
            if (ImsCallSession.this.mListener != null) {
                ImsCallSession.this.mListener.callSessionInviteParticipantsRequestDelivered(ImsCallSession.this);
            }
        }

        @Override
        public void callSessionInviteParticipantsRequestFailed(IImsCallSession session, ImsReasonInfo reasonInfo) {
            if (ImsCallSession.this.mListener != null) {
                ImsCallSession.this.mListener.callSessionInviteParticipantsRequestFailed(ImsCallSession.this, reasonInfo);
            }
        }

        @Override
        public void callSessionRemoveParticipantsRequestDelivered(IImsCallSession session) {
            if (ImsCallSession.this.mListener != null) {
                ImsCallSession.this.mListener.callSessionRemoveParticipantsRequestDelivered(ImsCallSession.this);
            }
        }

        @Override
        public void callSessionRemoveParticipantsRequestFailed(IImsCallSession session, ImsReasonInfo reasonInfo) {
            if (ImsCallSession.this.mListener != null) {
                ImsCallSession.this.mListener.callSessionRemoveParticipantsRequestFailed(ImsCallSession.this, reasonInfo);
            }
        }

        @Override
        public void callSessionConferenceStateUpdated(IImsCallSession session, ImsConferenceState state) {
            if (ImsCallSession.this.mListener != null) {
                ImsCallSession.this.mListener.callSessionConferenceStateUpdated(ImsCallSession.this, state);
            }
        }

        @Override
        public void callSessionUssdMessageReceived(IImsCallSession session, int mode, String ussdMessage) {
            if (ImsCallSession.this.mListener != null) {
                ImsCallSession.this.mListener.callSessionUssdMessageReceived(ImsCallSession.this, mode, ussdMessage);
            }
        }

        @Override
        public void callSessionMayHandover(IImsCallSession session, int srcAccessTech, int targetAccessTech) {
            if (ImsCallSession.this.mListener != null) {
                ImsCallSession.this.mListener.callSessionMayHandover(ImsCallSession.this, srcAccessTech, targetAccessTech);
            }
        }

        @Override
        public void callSessionHandover(IImsCallSession session, int srcAccessTech, int targetAccessTech, ImsReasonInfo reasonInfo) {
            if (ImsCallSession.this.mListener != null) {
                ImsCallSession.this.mListener.callSessionHandover(ImsCallSession.this, srcAccessTech, targetAccessTech, reasonInfo);
            }
        }

        @Override
        public void callSessionHandoverFailed(IImsCallSession session, int srcAccessTech, int targetAccessTech, ImsReasonInfo reasonInfo) {
            if (ImsCallSession.this.mListener != null) {
                ImsCallSession.this.mListener.callSessionHandoverFailed(ImsCallSession.this, srcAccessTech, targetAccessTech, reasonInfo);
            }
        }

        @Override
        public void callSessionTtyModeReceived(IImsCallSession session, int mode) {
            if (ImsCallSession.this.mListener != null) {
                ImsCallSession.this.mListener.callSessionTtyModeReceived(ImsCallSession.this, mode);
            }
        }

        @Override
        public void callSessionMultipartyStateChanged(IImsCallSession session, boolean isMultiParty) {
            if (ImsCallSession.this.mListener != null) {
                ImsCallSession.this.mListener.callSessionMultipartyStateChanged(ImsCallSession.this, isMultiParty);
            }
        }

        @Override
        public void callSessionSuppServiceReceived(IImsCallSession session, ImsSuppServiceNotification suppServiceInfo) {
            if (ImsCallSession.this.mListener != null) {
                ImsCallSession.this.mListener.callSessionSuppServiceReceived(ImsCallSession.this, suppServiceInfo);
            }
        }

        @Override
        public void callSessionRttModifyRequestReceived(IImsCallSession session, ImsCallProfile callProfile) {
            if (ImsCallSession.this.mListener != null) {
                ImsCallSession.this.mListener.callSessionRttModifyRequestReceived(ImsCallSession.this, callProfile);
            }
        }

        @Override
        public void callSessionRttModifyResponseReceived(int status) {
            if (ImsCallSession.this.mListener != null) {
                ImsCallSession.this.mListener.callSessionRttModifyResponseReceived(status);
            }
        }

        @Override
        public void callSessionRttMessageReceived(String rttMessage) {
            if (ImsCallSession.this.mListener != null) {
                ImsCallSession.this.mListener.callSessionRttMessageReceived(rttMessage);
            }
        }
    }

    public static class Listener {
        public void callSessionProgressing(ImsCallSession session, ImsStreamMediaProfile profile) {
        }

        public void callSessionStarted(ImsCallSession session, ImsCallProfile profile) {
        }

        public void callSessionStartFailed(ImsCallSession session, ImsReasonInfo reasonInfo) {
        }

        public void callSessionTerminated(ImsCallSession session, ImsReasonInfo reasonInfo) {
        }

        public void callSessionHeld(ImsCallSession session, ImsCallProfile profile) {
        }

        public void callSessionHoldFailed(ImsCallSession session, ImsReasonInfo reasonInfo) {
        }

        public void callSessionHoldReceived(ImsCallSession session, ImsCallProfile profile) {
        }

        public void callSessionResumed(ImsCallSession session, ImsCallProfile profile) {
        }

        public void callSessionResumeFailed(ImsCallSession session, ImsReasonInfo reasonInfo) {
        }

        public void callSessionResumeReceived(ImsCallSession session, ImsCallProfile profile) {
        }

        public void callSessionMergeStarted(ImsCallSession session, ImsCallSession newSession, ImsCallProfile profile) {
        }

        public void callSessionMergeComplete(ImsCallSession session) {
        }

        public void callSessionMergeFailed(ImsCallSession session, ImsReasonInfo reasonInfo) {
        }

        public void callSessionUpdated(ImsCallSession session, ImsCallProfile profile) {
        }

        public void callSessionUpdateFailed(ImsCallSession session, ImsReasonInfo reasonInfo) {
        }

        public void callSessionUpdateReceived(ImsCallSession session, ImsCallProfile profile) {
        }

        public void callSessionConferenceExtended(ImsCallSession session, ImsCallSession newSession, ImsCallProfile profile) {
        }

        public void callSessionConferenceExtendFailed(ImsCallSession session, ImsReasonInfo reasonInfo) {
        }

        public void callSessionConferenceExtendReceived(ImsCallSession session, ImsCallSession newSession, ImsCallProfile profile) {
        }

        public void callSessionInviteParticipantsRequestDelivered(ImsCallSession session) {
        }

        public void callSessionInviteParticipantsRequestFailed(ImsCallSession session, ImsReasonInfo reasonInfo) {
        }

        public void callSessionRemoveParticipantsRequestDelivered(ImsCallSession session) {
        }

        public void callSessionRemoveParticipantsRequestFailed(ImsCallSession session, ImsReasonInfo reasonInfo) {
        }

        public void callSessionConferenceStateUpdated(ImsCallSession session, ImsConferenceState state) {
        }

        public void callSessionUssdMessageReceived(ImsCallSession session, int mode, String ussdMessage) {
        }

        public void callSessionMayHandover(ImsCallSession session, int srcAccessTech, int targetAccessTech) {
        }

        public void callSessionHandover(ImsCallSession session, int srcAccessTech, int targetAccessTech, ImsReasonInfo reasonInfo) {
        }

        public void callSessionHandoverFailed(ImsCallSession session, int srcAccessTech, int targetAccessTech, ImsReasonInfo reasonInfo) {
        }

        public void callSessionTtyModeReceived(ImsCallSession session, int mode) {
        }

        public void callSessionMultipartyStateChanged(ImsCallSession session, boolean isMultiParty) {
        }

        public void callSessionSuppServiceReceived(ImsCallSession session, ImsSuppServiceNotification suppServiceInfo) {
        }

        public void callSessionRttModifyRequestReceived(ImsCallSession session, ImsCallProfile callProfile) {
        }

        public void callSessionRttModifyResponseReceived(int status) {
        }

        public void callSessionRttMessageReceived(String rttMessage) {
        }
    }

    public static class State {
        public static final int IDLE = 0;
        public static final int INITIATED = 1;
        public static final int NEGOTIATING = 2;
        public static final int ESTABLISHING = 3;
        public static final int ESTABLISHED = 4;
        public static final int RENEGOTIATING = 5;
        public static final int REESTABLISHING = 6;
        public static final int TERMINATING = 7;
        public static final int TERMINATED = 8;
        public static final int INVALID = -1;

        public static String toString(int state) {
            switch (state) {
                case 0: {
                    return "IDLE";
                }
                case 1: {
                    return "INITIATED";
                }
                case 2: {
                    return "NEGOTIATING";
                }
                case 3: {
                    return "ESTABLISHING";
                }
                case 4: {
                    return "ESTABLISHED";
                }
                case 5: {
                    return "RENEGOTIATING";
                }
                case 6: {
                    return "REESTABLISHING";
                }
                case 7: {
                    return "TERMINATING";
                }
                case 8: {
                    return "TERMINATED";
                }
            }
            return "UNKNOWN";
        }

        private State() {
        }
    }
}

