/*
 * Decompiled with CFR 0.152.
 */
package android.view.textclassifier;

import android.view.textclassifier.EntityConfidence;
import com.android.internal.util.Preconditions;
import java.util.List;

public final class TextSelection {
    private final int mStartIndex;
    private final int mEndIndex;
    private final EntityConfidence<String> mEntityConfidence;
    private final List<String> mEntities;
    private final String mLogSource;
    private final String mVersionInfo;

    private TextSelection(int startIndex, int endIndex, EntityConfidence<String> entityConfidence, String logSource, String versionInfo) {
        this.mStartIndex = startIndex;
        this.mEndIndex = endIndex;
        this.mEntityConfidence = new EntityConfidence<String>(entityConfidence);
        this.mEntities = this.mEntityConfidence.getEntities();
        this.mLogSource = logSource;
        this.mVersionInfo = versionInfo;
    }

    public int getSelectionStartIndex() {
        return this.mStartIndex;
    }

    public int getSelectionEndIndex() {
        return this.mEndIndex;
    }

    public int getEntityCount() {
        return this.mEntities.size();
    }

    public String getEntity(int index) {
        return this.mEntities.get(index);
    }

    public float getConfidenceScore(String entity) {
        return this.mEntityConfidence.getConfidenceScore(entity);
    }

    public String getSourceClassifier() {
        return this.mLogSource;
    }

    public String getVersionInfo() {
        return this.mVersionInfo;
    }

    public String toString() {
        return String.format("TextSelection {%d, %d, %s}", this.mStartIndex, this.mEndIndex, this.mEntityConfidence);
    }

    public static final class Builder {
        private final int mStartIndex;
        private final int mEndIndex;
        private final EntityConfidence<String> mEntityConfidence = new EntityConfidence();
        private String mLogSource = "";
        private String mVersionInfo = "";

        public Builder(int startIndex, int endIndex) {
            Preconditions.checkArgument(startIndex >= 0);
            Preconditions.checkArgument(endIndex > startIndex);
            this.mStartIndex = startIndex;
            this.mEndIndex = endIndex;
        }

        public Builder setEntityType(String type, float confidenceScore) {
            this.mEntityConfidence.setEntityType(type, confidenceScore);
            return this;
        }

        Builder setLogSource(String logSource) {
            this.mLogSource = Preconditions.checkNotNull(logSource);
            return this;
        }

        Builder setVersionInfo(String versionInfo) {
            this.mVersionInfo = Preconditions.checkNotNull(versionInfo);
            return this;
        }

        public TextSelection build() {
            return new TextSelection(this.mStartIndex, this.mEndIndex, this.mEntityConfidence, this.mLogSource, this.mVersionInfo);
        }
    }
}

