/*
 * Decompiled with CFR 0.152.
 */
package android.view.textclassifier;

final class SmartSelection {
    static final int HINT_FLAG_URL = 1;
    static final int HINT_FLAG_EMAIL = 2;
    private final long mCtx;

    SmartSelection(int fd) {
        this.mCtx = SmartSelection.nativeNew(fd);
    }

    public int[] suggest(String context, int selectionBegin, int selectionEnd) {
        return SmartSelection.nativeSuggest(this.mCtx, context, selectionBegin, selectionEnd);
    }

    public ClassificationResult[] classifyText(String context, int selectionBegin, int selectionEnd, int hintFlags) {
        return SmartSelection.nativeClassifyText(this.mCtx, context, selectionBegin, selectionEnd, hintFlags);
    }

    public void close() {
        SmartSelection.nativeClose(this.mCtx);
    }

    public static String getLanguage(int fd) {
        return SmartSelection.nativeGetLanguage(fd);
    }

    public static int getVersion(int fd) {
        return SmartSelection.nativeGetVersion(fd);
    }

    private static native long nativeNew(int var0);

    private static native int[] nativeSuggest(long var0, String var2, int var3, int var4);

    private static native ClassificationResult[] nativeClassifyText(long var0, String var2, int var3, int var4, int var5);

    private static native void nativeClose(long var0);

    private static native String nativeGetLanguage(int var0);

    private static native int nativeGetVersion(int var0);

    static {
        System.loadLibrary("textclassifier");
    }

    static final class ClassificationResult {
        final String mCollection;
        final float mScore;

        ClassificationResult(String collection, float score) {
            this.mCollection = collection;
            this.mScore = score;
        }
    }
}

