/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import com.android.internal.R;

public class StateSet {
    private static final int[][] VIEW_STATE_SETS;
    public static final int VIEW_STATE_WINDOW_FOCUSED = 1;
    public static final int VIEW_STATE_SELECTED = 2;
    public static final int VIEW_STATE_FOCUSED = 4;
    public static final int VIEW_STATE_ENABLED = 8;
    public static final int VIEW_STATE_PRESSED = 16;
    public static final int VIEW_STATE_ACTIVATED = 32;
    public static final int VIEW_STATE_ACCELERATED = 64;
    public static final int VIEW_STATE_HOVERED = 128;
    public static final int VIEW_STATE_DRAG_CAN_ACCEPT = 256;
    public static final int VIEW_STATE_DRAG_HOVERED = 512;
    static final int[] VIEW_STATE_IDS;
    public static final int[] WILD_CARD;
    public static final int[] NOTHING;

    public static int[] get(int mask) {
        if (mask >= VIEW_STATE_SETS.length) {
            throw new IllegalArgumentException("Invalid state set mask");
        }
        return VIEW_STATE_SETS[mask];
    }

    public static boolean isWildCard(int[] stateSetOrSpec) {
        return stateSetOrSpec.length == 0 || stateSetOrSpec[0] == 0;
    }

    public static boolean stateSetMatches(int[] stateSpec, int[] stateSet) {
        if (stateSet == null) {
            return stateSpec == null || StateSet.isWildCard(stateSpec);
        }
        int stateSpecSize = stateSpec.length;
        int stateSetSize = stateSet.length;
        for (int i = 0; i < stateSpecSize; ++i) {
            boolean mustMatch;
            int stateSpecState = stateSpec[i];
            if (stateSpecState == 0) {
                return true;
            }
            if (stateSpecState > 0) {
                mustMatch = true;
            } else {
                mustMatch = false;
                stateSpecState = -stateSpecState;
            }
            boolean found = false;
            for (int j = 0; j < stateSetSize; ++j) {
                int state = stateSet[j];
                if (state == 0) {
                    if (!mustMatch) break;
                    return false;
                }
                if (state != stateSpecState) continue;
                if (mustMatch) {
                    found = true;
                    break;
                }
                return false;
            }
            if (!mustMatch || found) continue;
            return false;
        }
        return true;
    }

    public static boolean stateSetMatches(int[] stateSpec, int state) {
        for (int stateSpecState : stateSpec) {
            if (stateSpecState == 0) {
                return true;
            }
            if (!(stateSpecState > 0 ? state != stateSpecState : state == -stateSpecState)) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAttribute(int[][] stateSpecs, int attr2) {
        if (stateSpecs != null) {
            for (int[] spec : stateSpecs) {
                if (spec == null) break;
                for (int specAttr : spec) {
                    if (specAttr != attr2 && -specAttr != attr2) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static int[] trimStateSet(int[] states, int newSize) {
        if (states.length == newSize) {
            return states;
        }
        int[] trimmedStates = new int[newSize];
        System.arraycopy((int[])states, (int)0, (int[])trimmedStates, (int)0, (int)newSize);
        return trimmedStates;
    }

    public static String dump(int[] states) {
        StringBuilder sb = new StringBuilder();
        int count = states.length;
        block9: for (int i = 0; i < count; ++i) {
            switch (states[i]) {
                case 16842909: {
                    sb.append("W ");
                    continue block9;
                }
                case 16842919: {
                    sb.append("P ");
                    continue block9;
                }
                case 0x10100A1: {
                    sb.append("S ");
                    continue block9;
                }
                case 16842908: {
                    sb.append("F ");
                    continue block9;
                }
                case 16842910: {
                    sb.append("E ");
                    continue block9;
                }
                case 0x10100A0: {
                    sb.append("C ");
                    continue block9;
                }
                case 16843518: {
                    sb.append("A ");
                }
            }
        }
        return sb.toString();
    }

    static {
        VIEW_STATE_IDS = new int[]{16842909, 1, 0x10100A1, 2, 16842908, 4, 16842910, 8, 16842919, 16, 16843518, 32, 16843547, 64, 16843623, 128, 16843624, 256, 16843625, 512};
        if (VIEW_STATE_IDS.length / 2 != R.styleable.ViewDrawableStates.length) {
            throw new IllegalStateException("VIEW_STATE_IDs array length does not match ViewDrawableStates style array");
        }
        int[] orderedIds = new int[VIEW_STATE_IDS.length];
        for (int i = 0; i < R.styleable.ViewDrawableStates.length; ++i) {
            int viewState = R.styleable.ViewDrawableStates[i];
            for (int j = 0; j < VIEW_STATE_IDS.length; j += 2) {
                if (VIEW_STATE_IDS[j] != viewState) continue;
                orderedIds[i * 2] = viewState;
                orderedIds[i * 2 + 1] = VIEW_STATE_IDS[j + 1];
            }
        }
        int NUM_BITS = VIEW_STATE_IDS.length / 2;
        VIEW_STATE_SETS = new int[1 << NUM_BITS][];
        for (int i = 0; i < VIEW_STATE_SETS.length; ++i) {
            int numBits = Integer.bitCount(i);
            int[] set = new int[numBits];
            int pos = 0;
            for (int j = 0; j < orderedIds.length; j += 2) {
                if ((i & orderedIds[j + 1]) == 0) continue;
                set[pos++] = orderedIds[j];
            }
            StateSet.VIEW_STATE_SETS[i] = set;
        }
        WILD_CARD = new int[0];
        NOTHING = new int[]{0};
    }
}

