/*
 * Decompiled with CFR 0.152.
 */
package android.text.format;

import android.content.Context;
import android.content.res.Resources;
import android.icu.text.DecimalFormat;
import android.icu.text.MeasureFormat;
import android.icu.text.NumberFormat;
import android.icu.text.UnicodeSet;
import android.icu.text.UnicodeSetSpanner;
import android.icu.util.Measure;
import android.icu.util.MeasureUnit;
import android.net.NetworkUtils;
import android.text.BidiFormatter;
import android.text.TextUtils;
import java.lang.reflect.Constructor;
import java.util.Locale;

public final class Formatter {
    public static final int FLAG_DEFAULT = 0;
    public static final int FLAG_SHORTER = 1;
    public static final int FLAG_CALCULATE_ROUNDED = 2;
    private static final UnicodeSetSpanner SPACES_AND_CONTROLS = new UnicodeSetSpanner(new UnicodeSet("[[:Zs:][:Cf:]]").freeze());
    private static final MeasureUnit PETABYTE = Formatter.createPetaByte();
    private static final int SECONDS_PER_MINUTE = 60;
    private static final int SECONDS_PER_HOUR = 3600;
    private static final int SECONDS_PER_DAY = 86400;
    private static final int MILLIS_PER_MINUTE = 60000;

    private static Locale localeFromContext(Context context) {
        return context.getResources().getConfiguration().getLocales().get(0);
    }

    private static String bidiWrap(Context context, String source) {
        Locale locale = Formatter.localeFromContext(context);
        if (TextUtils.getLayoutDirectionFromLocale(locale) == 1) {
            return BidiFormatter.getInstance(true).unicodeWrap(source);
        }
        return source;
    }

    public static String formatFileSize(Context context, long sizeBytes) {
        return Formatter.formatFileSize(context, sizeBytes, 0);
    }

    public static String formatShortFileSize(Context context, long sizeBytes) {
        return Formatter.formatFileSize(context, sizeBytes, 1);
    }

    private static String formatFileSize(Context context, long sizeBytes, int flags) {
        if (context == null) {
            return "";
        }
        RoundedBytesResult res = RoundedBytesResult.roundBytes(sizeBytes, flags);
        return Formatter.bidiWrap(context, Formatter.formatRoundedBytesResult(context, res));
    }

    private static String getSuffixOverride(Resources res, MeasureUnit unit) {
        if (unit == MeasureUnit.BYTE) {
            return res.getString(17039581);
        }
        return res.getString(17040581);
    }

    private static NumberFormat getNumberFormatter(Locale locale, int fractionDigits) {
        NumberFormat numberFormatter = NumberFormat.getInstance(locale);
        numberFormatter.setMinimumFractionDigits(fractionDigits);
        numberFormatter.setMaximumFractionDigits(fractionDigits);
        numberFormatter.setGroupingUsed(false);
        if (numberFormatter instanceof DecimalFormat) {
            numberFormatter.setRoundingMode(4);
        }
        return numberFormatter;
    }

    private static String deleteFirstFromString(String source, String toDelete) {
        int location = source.indexOf(toDelete);
        if (location == -1) {
            return source;
        }
        return source.substring(0, location) + source.substring(location + toDelete.length(), source.length());
    }

    private static String formatMeasureShort(Locale locale, NumberFormat numberFormatter, float value, MeasureUnit units) {
        MeasureFormat measureFormatter = MeasureFormat.getInstance(locale, MeasureFormat.FormatWidth.SHORT, numberFormatter);
        return measureFormatter.format(new Measure(Float.valueOf(value), units));
    }

    private static String formatRoundedBytesResult(Context context, RoundedBytesResult input) {
        Locale locale = Formatter.localeFromContext(context);
        NumberFormat numberFormatter = Formatter.getNumberFormatter(locale, input.fractionDigits);
        if (input.units == MeasureUnit.BYTE || input.units == PETABYTE) {
            String formattedNumber = numberFormatter.format(input.value);
            return context.getString(17039857, formattedNumber, Formatter.getSuffixOverride(context.getResources(), input.units));
        }
        return Formatter.formatMeasureShort(locale, numberFormatter, input.value, input.units);
    }

    public static BytesResult formatBytes(Resources res, long sizeBytes, int flags) {
        String units;
        RoundedBytesResult rounded = RoundedBytesResult.roundBytes(sizeBytes, flags);
        Locale locale = res.getConfiguration().getLocales().get(0);
        NumberFormat numberFormatter = Formatter.getNumberFormatter(locale, rounded.fractionDigits);
        String formattedNumber = numberFormatter.format(rounded.value);
        if (rounded.units == MeasureUnit.BYTE || rounded.units == PETABYTE) {
            units = Formatter.getSuffixOverride(res, rounded.units);
        } else {
            String formattedMeasure = Formatter.formatMeasureShort(locale, numberFormatter, rounded.value, rounded.units);
            String numberRemoved = Formatter.deleteFirstFromString(formattedMeasure, formattedNumber);
            units = SPACES_AND_CONTROLS.trim(numberRemoved).toString();
        }
        return new BytesResult(formattedNumber, units, rounded.roundedBytes);
    }

    private static MeasureUnit createPetaByte() {
        try {
            Constructor constructor = MeasureUnit.class.getDeclaredConstructor(String.class, String.class);
            constructor.setAccessible(true);
            return (MeasureUnit)constructor.newInstance("digital", "petabyte");
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Failed to create petabyte MeasureUnit", e);
        }
    }

    @Deprecated
    public static String formatIpAddress(int ipv4Address) {
        return NetworkUtils.intToInetAddress(ipv4Address).getHostAddress();
    }

    public static String formatShortElapsedTime(Context context, long millis) {
        long secondsLong = millis / 1000L;
        int days = 0;
        int hours = 0;
        int minutes = 0;
        if (secondsLong >= 86400L) {
            days = (int)(secondsLong / 86400L);
            secondsLong -= (long)(days * 86400);
        }
        if (secondsLong >= 3600L) {
            hours = (int)(secondsLong / 3600L);
            secondsLong -= (long)(hours * 3600);
        }
        if (secondsLong >= 60L) {
            minutes = (int)(secondsLong / 60L);
            secondsLong -= (long)(minutes * 60);
        }
        int seconds = (int)secondsLong;
        Locale locale = Formatter.localeFromContext(context);
        MeasureFormat measureFormat = MeasureFormat.getInstance(locale, MeasureFormat.FormatWidth.SHORT);
        if (days >= 2) {
            return measureFormat.format(new Measure(days += (hours + 12) / 24, MeasureUnit.DAY));
        }
        if (days > 0) {
            return measureFormat.formatMeasures(new Measure(days, MeasureUnit.DAY), new Measure(hours, MeasureUnit.HOUR));
        }
        if (hours >= 2) {
            return measureFormat.format(new Measure(hours += (minutes + 30) / 60, MeasureUnit.HOUR));
        }
        if (hours > 0) {
            return measureFormat.formatMeasures(new Measure(hours, MeasureUnit.HOUR), new Measure(minutes, MeasureUnit.MINUTE));
        }
        if (minutes >= 2) {
            return measureFormat.format(new Measure(minutes += (seconds + 30) / 60, MeasureUnit.MINUTE));
        }
        if (minutes > 0) {
            return measureFormat.formatMeasures(new Measure(minutes, MeasureUnit.MINUTE), new Measure(seconds, MeasureUnit.SECOND));
        }
        return measureFormat.format(new Measure(seconds, MeasureUnit.SECOND));
    }

    public static String formatShortElapsedTimeRoundingUpToMinutes(Context context, long millis) {
        long minutesRoundedUp = (millis + 60000L - 1L) / 60000L;
        if (minutesRoundedUp == 0L || minutesRoundedUp == 1L) {
            Locale locale = Formatter.localeFromContext(context);
            MeasureFormat measureFormat = MeasureFormat.getInstance(locale, MeasureFormat.FormatWidth.SHORT);
            return measureFormat.format(new Measure(minutesRoundedUp, MeasureUnit.MINUTE));
        }
        return Formatter.formatShortElapsedTime(context, minutesRoundedUp * 60000L);
    }

    private static class RoundedBytesResult {
        public final float value;
        public final MeasureUnit units;
        public final int fractionDigits;
        public final long roundedBytes;

        private RoundedBytesResult(float value, MeasureUnit units, int fractionDigits, long roundedBytes) {
            this.value = value;
            this.units = units;
            this.fractionDigits = fractionDigits;
            this.roundedBytes = roundedBytes;
        }

        static RoundedBytesResult roundBytes(long sizeBytes, int flags) {
            int roundDigits;
            int roundFactor;
            boolean isNegative = sizeBytes < 0L;
            float result = isNegative ? (float)(-sizeBytes) : (float)sizeBytes;
            MeasureUnit units = MeasureUnit.BYTE;
            long mult = 1L;
            if (result > 900.0f) {
                units = MeasureUnit.KILOBYTE;
                mult = 1000L;
                result /= 1000.0f;
            }
            if (result > 900.0f) {
                units = MeasureUnit.MEGABYTE;
                mult *= 1000L;
                result /= 1000.0f;
            }
            if (result > 900.0f) {
                units = MeasureUnit.GIGABYTE;
                mult *= 1000L;
                result /= 1000.0f;
            }
            if (result > 900.0f) {
                units = MeasureUnit.TERABYTE;
                mult *= 1000L;
                result /= 1000.0f;
            }
            if (result > 900.0f) {
                units = PETABYTE;
                mult *= 1000L;
                result /= 1000.0f;
            }
            if (mult == 1L || result >= 100.0f) {
                roundFactor = 1;
                roundDigits = 0;
            } else if (result < 1.0f) {
                roundFactor = 100;
                roundDigits = 2;
            } else if (result < 10.0f) {
                if ((flags & 1) != 0) {
                    roundFactor = 10;
                    roundDigits = 1;
                } else {
                    roundFactor = 100;
                    roundDigits = 2;
                }
            } else if ((flags & 1) != 0) {
                roundFactor = 1;
                roundDigits = 0;
            } else {
                roundFactor = 100;
                roundDigits = 2;
            }
            if (isNegative) {
                result = -result;
            }
            long roundedBytes = (flags & 2) == 0 ? 0L : (long)Math.round(result * (float)roundFactor) * mult / (long)roundFactor;
            return new RoundedBytesResult(result, units, roundDigits, roundedBytes);
        }
    }

    public static class BytesResult {
        public final String value;
        public final String units;
        public final long roundedBytes;

        public BytesResult(String value, String units, long roundedBytes) {
            this.value = value;
            this.units = units;
            this.roundedBytes = roundedBytes;
        }
    }
}

