/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.mbms.vendor;

import android.os.Binder;
import android.os.IBinder;
import android.os.RemoteException;
import android.telephony.mbms.DownloadRequest;
import android.telephony.mbms.DownloadStateCallback;
import android.telephony.mbms.FileInfo;
import android.telephony.mbms.FileServiceInfo;
import android.telephony.mbms.IDownloadStateCallback;
import android.telephony.mbms.IMbmsDownloadSessionCallback;
import android.telephony.mbms.MbmsDownloadSessionCallback;
import android.telephony.mbms.vendor.IMbmsDownloadService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MbmsDownloadServiceBase
extends IMbmsDownloadService.Stub {
    private final Map<IBinder, DownloadStateCallback> mDownloadCallbackBinderMap = new HashMap<IBinder, DownloadStateCallback>();
    private final Map<IBinder, IBinder.DeathRecipient> mDownloadCallbackDeathRecipients = new HashMap<IBinder, IBinder.DeathRecipient>();

    public int initialize(int subscriptionId, MbmsDownloadSessionCallback callback) throws RemoteException {
        return 0;
    }

    @Override
    public final int initialize(final int subscriptionId, final IMbmsDownloadSessionCallback callback) throws RemoteException {
        final int uid = Binder.getCallingUid();
        callback.asBinder().linkToDeath(new IBinder.DeathRecipient(){

            @Override
            public void binderDied() {
                MbmsDownloadServiceBase.this.onAppCallbackDied(uid, subscriptionId);
            }
        }, 0);
        return this.initialize(subscriptionId, new MbmsDownloadSessionCallback(){

            @Override
            public void onError(int errorCode, String message) {
                try {
                    callback.onError(errorCode, message);
                }
                catch (RemoteException e) {
                    MbmsDownloadServiceBase.this.onAppCallbackDied(uid, subscriptionId);
                }
            }

            @Override
            public void onFileServicesUpdated(List<FileServiceInfo> services) {
                try {
                    callback.onFileServicesUpdated(services);
                }
                catch (RemoteException e) {
                    MbmsDownloadServiceBase.this.onAppCallbackDied(uid, subscriptionId);
                }
            }

            @Override
            public void onMiddlewareReady() {
                try {
                    callback.onMiddlewareReady();
                }
                catch (RemoteException e) {
                    MbmsDownloadServiceBase.this.onAppCallbackDied(uid, subscriptionId);
                }
            }
        });
    }

    @Override
    public int requestUpdateFileServices(int subscriptionId, List<String> serviceClasses) throws RemoteException {
        return 0;
    }

    @Override
    public int setTempFileRootDirectory(int subscriptionId, String rootDirectoryPath) throws RemoteException {
        return 0;
    }

    @Override
    public int download(DownloadRequest downloadRequest) throws RemoteException {
        return 0;
    }

    public int registerStateCallback(DownloadRequest downloadRequest, DownloadStateCallback callback) throws RemoteException {
        return 0;
    }

    @Override
    public final int registerStateCallback(final DownloadRequest downloadRequest, final IDownloadStateCallback callback, int flags) throws RemoteException {
        final int uid = Binder.getCallingUid();
        IBinder.DeathRecipient deathRecipient = new IBinder.DeathRecipient(){

            @Override
            public void binderDied() {
                MbmsDownloadServiceBase.this.onAppCallbackDied(uid, downloadRequest.getSubscriptionId());
                MbmsDownloadServiceBase.this.mDownloadCallbackBinderMap.remove(callback.asBinder());
                MbmsDownloadServiceBase.this.mDownloadCallbackDeathRecipients.remove(callback.asBinder());
            }
        };
        this.mDownloadCallbackDeathRecipients.put(callback.asBinder(), deathRecipient);
        callback.asBinder().linkToDeath(deathRecipient, 0);
        FilteredDownloadStateCallback exposedCallback = new FilteredDownloadStateCallback(callback, flags){

            @Override
            protected void onRemoteException(RemoteException e) {
                MbmsDownloadServiceBase.this.onAppCallbackDied(uid, downloadRequest.getSubscriptionId());
            }
        };
        this.mDownloadCallbackBinderMap.put(callback.asBinder(), exposedCallback);
        return this.registerStateCallback(downloadRequest, exposedCallback);
    }

    public int unregisterStateCallback(DownloadRequest downloadRequest, DownloadStateCallback callback) throws RemoteException {
        return 0;
    }

    @Override
    public final int unregisterStateCallback(DownloadRequest downloadRequest, IDownloadStateCallback callback) throws RemoteException {
        IBinder.DeathRecipient deathRecipient = this.mDownloadCallbackDeathRecipients.remove(callback.asBinder());
        if (deathRecipient == null) {
            throw new IllegalArgumentException("Unknown callback");
        }
        callback.asBinder().unlinkToDeath(deathRecipient, 0);
        DownloadStateCallback exposedCallback = this.mDownloadCallbackBinderMap.remove(callback.asBinder());
        if (exposedCallback == null) {
            throw new IllegalArgumentException("Unknown callback");
        }
        return this.unregisterStateCallback(downloadRequest, exposedCallback);
    }

    @Override
    public List<DownloadRequest> listPendingDownloads(int subscriptionId) throws RemoteException {
        return null;
    }

    @Override
    public int cancelDownload(DownloadRequest downloadRequest) throws RemoteException {
        return 0;
    }

    @Override
    public int getDownloadStatus(DownloadRequest downloadRequest, FileInfo fileInfo) throws RemoteException {
        return 0;
    }

    @Override
    public int resetDownloadKnowledge(DownloadRequest downloadRequest) throws RemoteException {
        return 0;
    }

    @Override
    public void dispose(int subscriptionId) throws RemoteException {
    }

    public void onAppCallbackDied(int uid, int subscriptionId) {
    }

    private static abstract class FilteredDownloadStateCallback
    extends DownloadStateCallback {
        private final IDownloadStateCallback mCallback;

        public FilteredDownloadStateCallback(IDownloadStateCallback callback, int callbackFlags) {
            super(callbackFlags);
            this.mCallback = callback;
        }

        @Override
        public void onProgressUpdated(DownloadRequest request, FileInfo fileInfo, int currentDownloadSize, int fullDownloadSize, int currentDecodedSize, int fullDecodedSize) {
            if (!this.isFilterFlagSet(1)) {
                return;
            }
            try {
                this.mCallback.onProgressUpdated(request, fileInfo, currentDownloadSize, fullDownloadSize, currentDecodedSize, fullDecodedSize);
            }
            catch (RemoteException e) {
                this.onRemoteException(e);
            }
        }

        @Override
        public void onStateUpdated(DownloadRequest request, FileInfo fileInfo, int state) {
            if (!this.isFilterFlagSet(2)) {
                return;
            }
            try {
                this.mCallback.onStateUpdated(request, fileInfo, state);
            }
            catch (RemoteException e) {
                this.onRemoteException(e);
            }
        }

        protected abstract void onRemoteException(RemoteException var1);
    }
}

