/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.ims;

import android.app.PendingIntent;
import android.os.IBinder;
import android.os.Message;
import android.os.RemoteException;
import android.telephony.ims.ImsServiceProxyCompat;
import android.telephony.ims.feature.IRcsFeature;
import android.util.Log;
import com.android.ims.ImsCallProfile;
import com.android.ims.internal.IImsCallSession;
import com.android.ims.internal.IImsCallSessionListener;
import com.android.ims.internal.IImsConfig;
import com.android.ims.internal.IImsEcbm;
import com.android.ims.internal.IImsMultiEndpoint;
import com.android.ims.internal.IImsRegistrationListener;
import com.android.ims.internal.IImsServiceController;
import com.android.ims.internal.IImsServiceFeatureListener;
import com.android.ims.internal.IImsUt;

public class ImsServiceProxy
extends ImsServiceProxyCompat
implements IRcsFeature {
    protected String LOG_TAG = "ImsServiceProxy";
    private final int mSupportedFeature;
    private boolean mIsAvailable = true;
    private Integer mFeatureStatusCached = null;
    private INotifyStatusChanged mStatusCallback;
    private final Object mLock = new Object();
    private final IImsServiceFeatureListener mListenerBinder = new IImsServiceFeatureListener.Stub(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void imsFeatureCreated(int slotId, int feature) throws RemoteException {
            Object object = ImsServiceProxy.this.mLock;
            synchronized (object) {
                if (!ImsServiceProxy.this.mIsAvailable && ImsServiceProxy.this.mSlotId == slotId && feature == ImsServiceProxy.this.mSupportedFeature) {
                    Log.i(ImsServiceProxy.this.LOG_TAG, "Feature enabled on slotId: " + slotId + " for feature: " + feature);
                    ImsServiceProxy.this.mIsAvailable = true;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void imsFeatureRemoved(int slotId, int feature) throws RemoteException {
            Object object = ImsServiceProxy.this.mLock;
            synchronized (object) {
                if (ImsServiceProxy.this.mIsAvailable && ImsServiceProxy.this.mSlotId == slotId && feature == ImsServiceProxy.this.mSupportedFeature) {
                    Log.i(ImsServiceProxy.this.LOG_TAG, "Feature disabled on slotId: " + slotId + " for feature: " + feature);
                    ImsServiceProxy.this.mIsAvailable = false;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void imsStatusChanged(int slotId, int feature, int status) throws RemoteException {
            Object object = ImsServiceProxy.this.mLock;
            synchronized (object) {
                Log.i(ImsServiceProxy.this.LOG_TAG, "imsStatusChanged: slot: " + slotId + " feature: " + feature + " status: " + status);
                if (ImsServiceProxy.this.mSlotId == slotId && feature == ImsServiceProxy.this.mSupportedFeature) {
                    ImsServiceProxy.this.mFeatureStatusCached = status;
                    if (ImsServiceProxy.this.mStatusCallback != null) {
                        ImsServiceProxy.this.mStatusCallback.notifyStatusChanged();
                    }
                }
            }
        }
    };

    public ImsServiceProxy(int slotId, IBinder binder, int featureType) {
        super(slotId, binder);
        this.mSupportedFeature = featureType;
    }

    public ImsServiceProxy(int slotId, int featureType) {
        super(slotId, null);
        this.mSupportedFeature = featureType;
    }

    public IImsServiceFeatureListener getListener() {
        return this.mListenerBinder;
    }

    public void setBinder(IBinder binder) {
        this.mBinder = binder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int startSession(PendingIntent incomingCallIntent, IImsRegistrationListener listener) throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            this.checkServiceIsReady();
            return this.getServiceInterface(this.mBinder).startSession(this.mSlotId, this.mSupportedFeature, incomingCallIntent, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endSession(int sessionId) throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            this.checkBinderConnection();
            this.getServiceInterface(this.mBinder).endSession(this.mSlotId, this.mSupportedFeature, sessionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConnected(int callServiceType, int callType) throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            this.checkServiceIsReady();
            return this.getServiceInterface(this.mBinder).isConnected(this.mSlotId, this.mSupportedFeature, callServiceType, callType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isOpened() throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            this.checkServiceIsReady();
            return this.getServiceInterface(this.mBinder).isOpened(this.mSlotId, this.mSupportedFeature);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRegistrationListener(IImsRegistrationListener listener) throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            this.checkServiceIsReady();
            this.getServiceInterface(this.mBinder).addRegistrationListener(this.mSlotId, this.mSupportedFeature, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRegistrationListener(IImsRegistrationListener listener) throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            this.checkServiceIsReady();
            this.getServiceInterface(this.mBinder).removeRegistrationListener(this.mSlotId, this.mSupportedFeature, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImsCallProfile createCallProfile(int sessionId, int callServiceType, int callType) throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            this.checkServiceIsReady();
            return this.getServiceInterface(this.mBinder).createCallProfile(this.mSlotId, this.mSupportedFeature, sessionId, callServiceType, callType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IImsCallSession createCallSession(int sessionId, ImsCallProfile profile, IImsCallSessionListener listener) throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            this.checkServiceIsReady();
            return this.getServiceInterface(this.mBinder).createCallSession(this.mSlotId, this.mSupportedFeature, sessionId, profile, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IImsCallSession getPendingCallSession(int sessionId, String callId) throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            this.checkServiceIsReady();
            return this.getServiceInterface(this.mBinder).getPendingCallSession(this.mSlotId, this.mSupportedFeature, sessionId, callId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IImsUt getUtInterface() throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            this.checkServiceIsReady();
            return this.getServiceInterface(this.mBinder).getUtInterface(this.mSlotId, this.mSupportedFeature);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IImsConfig getConfigInterface() throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            this.checkServiceIsReady();
            return this.getServiceInterface(this.mBinder).getConfigInterface(this.mSlotId, this.mSupportedFeature);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void turnOnIms() throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            this.checkServiceIsReady();
            this.getServiceInterface(this.mBinder).turnOnIms(this.mSlotId, this.mSupportedFeature);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void turnOffIms() throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            this.checkServiceIsReady();
            this.getServiceInterface(this.mBinder).turnOffIms(this.mSlotId, this.mSupportedFeature);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IImsEcbm getEcbmInterface() throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            this.checkServiceIsReady();
            return this.getServiceInterface(this.mBinder).getEcbmInterface(this.mSlotId, this.mSupportedFeature);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUiTTYMode(int uiTtyMode, Message onComplete) throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            this.checkServiceIsReady();
            this.getServiceInterface(this.mBinder).setUiTTYMode(this.mSlotId, this.mSupportedFeature, uiTtyMode, onComplete);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IImsMultiEndpoint getMultiEndpointInterface() throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            this.checkServiceIsReady();
            return this.getServiceInterface(this.mBinder).getMultiEndpointInterface(this.mSlotId, this.mSupportedFeature);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getFeatureStatus() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.isBinderAlive() && this.mFeatureStatusCached != null) {
                Log.i(this.LOG_TAG, "getFeatureStatus - returning cached: " + this.mFeatureStatusCached);
                return this.mFeatureStatusCached;
            }
        }
        Integer status = this.retrieveFeatureStatus();
        Object object2 = this.mLock;
        synchronized (object2) {
            if (status == null) {
                return 0;
            }
            this.mFeatureStatusCached = status;
        }
        Log.i(this.LOG_TAG, "getFeatureStatus - returning " + status);
        return status;
    }

    private Integer retrieveFeatureStatus() {
        if (this.mBinder != null) {
            try {
                return this.getServiceInterface(this.mBinder).getFeatureStatus(this.mSlotId, this.mSupportedFeature);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return null;
    }

    public void setStatusCallback(INotifyStatusChanged c) {
        this.mStatusCallback = c;
    }

    public boolean isBinderReady() {
        return this.isBinderAlive() && this.getFeatureStatus() == 2;
    }

    @Override
    public boolean isBinderAlive() {
        return this.mIsAvailable && this.mBinder != null && this.mBinder.isBinderAlive();
    }

    protected void checkServiceIsReady() throws RemoteException {
        if (!this.isBinderReady()) {
            throw new RemoteException("ImsServiceProxy is not ready to accept commands.");
        }
    }

    private IImsServiceController getServiceInterface(IBinder b) {
        return IImsServiceController.Stub.asInterface(b);
    }

    public static interface INotifyStatusChanged {
        public void notifyStatusChanged();
    }
}

