/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.content.ComponentName;
import android.content.Context;
import android.content.ServiceConnection;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.RemoteException;
import android.telephony.SubscriptionManager;
import android.telephony.mbms.InternalStreamingServiceCallback;
import android.telephony.mbms.InternalStreamingSessionCallback;
import android.telephony.mbms.MbmsStreamingSessionCallback;
import android.telephony.mbms.MbmsUtils;
import android.telephony.mbms.StreamingService;
import android.telephony.mbms.StreamingServiceCallback;
import android.telephony.mbms.StreamingServiceInfo;
import android.telephony.mbms.vendor.IMbmsStreamingService;
import android.util.ArraySet;
import android.util.Log;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public class MbmsStreamingSession
implements AutoCloseable {
    private static final String LOG_TAG = "MbmsStreamingSession";
    public static final String MBMS_STREAMING_SERVICE_ACTION = "android.telephony.action.EmbmsStreaming";
    private static AtomicBoolean sIsInitialized = new AtomicBoolean(false);
    private AtomicReference<IMbmsStreamingService> mService = new AtomicReference<Object>(null);
    private IBinder.DeathRecipient mDeathRecipient = new IBinder.DeathRecipient(){

        @Override
        public void binderDied() {
            sIsInitialized.set(false);
            MbmsStreamingSession.this.sendErrorToApp(3, "Received death notification");
        }
    };
    private InternalStreamingSessionCallback mInternalCallback;
    private Set<StreamingService> mKnownActiveStreamingServices = new ArraySet<StreamingService>();
    private final Context mContext;
    private int mSubscriptionId = -1;

    private MbmsStreamingSession(Context context, MbmsStreamingSessionCallback callback, int subscriptionId, Handler handler) {
        this.mContext = context;
        this.mSubscriptionId = subscriptionId;
        if (handler == null) {
            handler = new Handler(Looper.getMainLooper());
        }
        this.mInternalCallback = new InternalStreamingSessionCallback(callback, handler);
    }

    public static MbmsStreamingSession create(Context context, final MbmsStreamingSessionCallback callback, int subscriptionId, Handler handler) {
        if (!sIsInitialized.compareAndSet(false, true)) {
            throw new IllegalStateException("Cannot create two instances of MbmsStreamingSession");
        }
        MbmsStreamingSession session = new MbmsStreamingSession(context, callback, subscriptionId, handler);
        final int result = session.bindAndInitialize();
        if (result != 0) {
            sIsInitialized.set(false);
            handler.post(new Runnable(){

                @Override
                public void run() {
                    callback.onError(result, null);
                }
            });
            return null;
        }
        return session;
    }

    public static MbmsStreamingSession create(Context context, MbmsStreamingSessionCallback callback, Handler handler) {
        return MbmsStreamingSession.create(context, callback, SubscriptionManager.getDefaultSubscriptionId(), handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            IMbmsStreamingService streamingService = this.mService.get();
            if (streamingService == null) {
                return;
            }
            streamingService.dispose(this.mSubscriptionId);
            for (StreamingService s : this.mKnownActiveStreamingServices) {
                s.getCallback().stop();
            }
            this.mKnownActiveStreamingServices.clear();
        }
        catch (RemoteException remoteException) {
        }
        finally {
            this.mService.set(null);
            sIsInitialized.set(false);
            this.mInternalCallback.stop();
        }
    }

    public void requestUpdateStreamingServices(List<String> serviceClassList) {
        IMbmsStreamingService streamingService = this.mService.get();
        if (streamingService == null) {
            throw new IllegalStateException("Middleware not yet bound");
        }
        try {
            int returnCode = streamingService.requestUpdateStreamingServices(this.mSubscriptionId, serviceClassList);
            if (returnCode != 0) {
                this.sendErrorToApp(returnCode, null);
            }
        }
        catch (RemoteException e) {
            Log.w(LOG_TAG, "Remote process died");
            this.mService.set(null);
            sIsInitialized.set(false);
            this.sendErrorToApp(3, null);
        }
    }

    public StreamingService startStreaming(StreamingServiceInfo serviceInfo, StreamingServiceCallback callback, Handler handler) {
        IMbmsStreamingService streamingService = this.mService.get();
        if (streamingService == null) {
            throw new IllegalStateException("Middleware not yet bound");
        }
        InternalStreamingServiceCallback serviceCallback = new InternalStreamingServiceCallback(callback, handler);
        StreamingService serviceForApp = new StreamingService(this.mSubscriptionId, streamingService, this, serviceInfo, serviceCallback);
        this.mKnownActiveStreamingServices.add(serviceForApp);
        try {
            int returnCode = streamingService.startStreaming(this.mSubscriptionId, serviceInfo.getServiceId(), serviceCallback);
            if (returnCode != 0) {
                this.sendErrorToApp(returnCode, null);
                return null;
            }
        }
        catch (RemoteException e) {
            Log.w(LOG_TAG, "Remote process died");
            this.mService.set(null);
            sIsInitialized.set(false);
            this.sendErrorToApp(3, null);
            return null;
        }
        return serviceForApp;
    }

    public void onStreamingServiceStopped(StreamingService service) {
        this.mKnownActiveStreamingServices.remove(service);
    }

    private int bindAndInitialize() {
        return MbmsUtils.startBinding(this.mContext, MBMS_STREAMING_SERVICE_ACTION, new ServiceConnection(){

            @Override
            public void onServiceConnected(ComponentName name, IBinder service) {
                int result;
                IMbmsStreamingService streamingService = IMbmsStreamingService.Stub.asInterface(service);
                try {
                    result = streamingService.initialize(MbmsStreamingSession.this.mInternalCallback, MbmsStreamingSession.this.mSubscriptionId);
                }
                catch (RemoteException e) {
                    Log.e(MbmsStreamingSession.LOG_TAG, "Service died before initialization");
                    MbmsStreamingSession.this.sendErrorToApp(103, e.toString());
                    sIsInitialized.set(false);
                    return;
                }
                catch (RuntimeException e) {
                    Log.e(MbmsStreamingSession.LOG_TAG, "Runtime exception during initialization");
                    MbmsStreamingSession.this.sendErrorToApp(103, e.toString());
                    sIsInitialized.set(false);
                    return;
                }
                if (result != 0) {
                    MbmsStreamingSession.this.sendErrorToApp(result, "Error returned during initialization");
                    sIsInitialized.set(false);
                    return;
                }
                try {
                    streamingService.asBinder().linkToDeath(MbmsStreamingSession.this.mDeathRecipient, 0);
                }
                catch (RemoteException e) {
                    MbmsStreamingSession.this.sendErrorToApp(3, "Middleware lost during initialization");
                    sIsInitialized.set(false);
                    return;
                }
                MbmsStreamingSession.this.mService.set(streamingService);
            }

            @Override
            public void onServiceDisconnected(ComponentName name) {
                sIsInitialized.set(false);
                MbmsStreamingSession.this.mService.set(null);
            }
        });
    }

    private void sendErrorToApp(int errorCode, String message) {
        try {
            this.mInternalCallback.onError(errorCode, message);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }
}

