/*
 * Decompiled with CFR 0.152.
 */
package android.speech.tts;

import android.speech.tts.AbstractEventLogger;
import android.speech.tts.AbstractSynthesisCallback;
import android.speech.tts.AudioPlaybackHandler;
import android.speech.tts.BlockingAudioTrack;
import android.speech.tts.SynthesisPlaybackQueueItem;
import android.speech.tts.TextToSpeechService;
import android.util.Log;

class PlaybackSynthesisCallback
extends AbstractSynthesisCallback {
    private static final String TAG = "PlaybackSynthesisRequest";
    private static final boolean DBG = false;
    private static final int MIN_AUDIO_BUFFER_SIZE = 8192;
    private final TextToSpeechService.AudioOutputParams mAudioParams;
    private final Object mStateLock = new Object();
    private final AudioPlaybackHandler mAudioTrackHandler;
    private SynthesisPlaybackQueueItem mItem = null;
    private volatile boolean mDone = false;
    protected int mStatusCode;
    private final TextToSpeechService.UtteranceProgressDispatcher mDispatcher;
    private final Object mCallerIdentity;
    private final AbstractEventLogger mLogger;

    PlaybackSynthesisCallback(TextToSpeechService.AudioOutputParams audioParams, AudioPlaybackHandler audioTrackHandler, TextToSpeechService.UtteranceProgressDispatcher dispatcher, Object callerIdentity, AbstractEventLogger logger, boolean clientIsUsingV2) {
        super(clientIsUsingV2);
        this.mAudioParams = audioParams;
        this.mAudioTrackHandler = audioTrackHandler;
        this.mDispatcher = dispatcher;
        this.mCallerIdentity = callerIdentity;
        this.mLogger = logger;
        this.mStatusCode = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void stop() {
        SynthesisPlaybackQueueItem item;
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mDone) {
                return;
            }
            if (this.mStatusCode == -2) {
                Log.w(TAG, "stop() called twice");
                return;
            }
            item = this.mItem;
            this.mStatusCode = -2;
        }
        if (item != null) {
            item.stop(-2);
        } else {
            this.mLogger.onCompleted(-2);
            this.mDispatcher.dispatchOnStop();
        }
    }

    @Override
    public int getMaxBufferSize() {
        return 8192;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasStarted() {
        Object object = this.mStateLock;
        synchronized (object) {
            return this.mItem != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasFinished() {
        Object object = this.mStateLock;
        synchronized (object) {
            return this.mDone;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int start(int sampleRateInHz, int audioFormat, int channelCount) {
        if (audioFormat != 3 && audioFormat != 2 && audioFormat != 4) {
            Log.w(TAG, "Audio format encoding " + audioFormat + " not supported. Please use one of AudioFormat.ENCODING_PCM_8BIT, AudioFormat.ENCODING_PCM_16BIT or AudioFormat.ENCODING_PCM_FLOAT");
        }
        this.mDispatcher.dispatchOnBeginSynthesis(sampleRateInHz, audioFormat, channelCount);
        int channelConfig = BlockingAudioTrack.getChannelConfig(channelCount);
        Object object = this.mStateLock;
        synchronized (object) {
            if (channelConfig == 0) {
                Log.e(TAG, "Unsupported number of channels :" + channelCount);
                this.mStatusCode = -5;
                return -1;
            }
            if (this.mStatusCode == -2) {
                return this.errorCodeOnStop();
            }
            if (this.mStatusCode != 0) {
                return -1;
            }
            if (this.mItem != null) {
                Log.e(TAG, "Start called twice");
                return -1;
            }
            SynthesisPlaybackQueueItem item = new SynthesisPlaybackQueueItem(this.mAudioParams, sampleRateInHz, audioFormat, channelCount, this.mDispatcher, this.mCallerIdentity, this.mLogger);
            this.mAudioTrackHandler.enqueue(item);
            this.mItem = item;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int audioAvailable(byte[] buffer, int offset, int length) {
        if (length > this.getMaxBufferSize() || length <= 0) {
            throw new IllegalArgumentException("buffer is too large or of zero length (" + length + " bytes)");
        }
        SynthesisPlaybackQueueItem item = null;
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mItem == null) {
                this.mStatusCode = -5;
                return -1;
            }
            if (this.mStatusCode != 0) {
                return -1;
            }
            if (this.mStatusCode == -2) {
                return this.errorCodeOnStop();
            }
            item = this.mItem;
        }
        byte[] bufferCopy = new byte[length];
        System.arraycopy((byte[])buffer, (int)offset, (byte[])bufferCopy, (int)0, (int)length);
        this.mDispatcher.dispatchOnAudioAvailable(bufferCopy);
        try {
            item.put(bufferCopy);
        }
        catch (InterruptedException ie) {
            Object object2 = this.mStateLock;
            synchronized (object2) {
                this.mStatusCode = -5;
                return -1;
            }
        }
        this.mLogger.onEngineDataReceived();
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int done() {
        int statusCode = 0;
        SynthesisPlaybackQueueItem item = null;
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mDone) {
                Log.w(TAG, "Duplicate call to done()");
                return -1;
            }
            if (this.mStatusCode == -2) {
                return this.errorCodeOnStop();
            }
            this.mDone = true;
            if (this.mItem == null) {
                Log.w(TAG, "done() was called before start() call");
                if (this.mStatusCode == 0) {
                    this.mDispatcher.dispatchOnSuccess();
                } else {
                    this.mDispatcher.dispatchOnError(this.mStatusCode);
                }
                this.mLogger.onEngineComplete();
                return -1;
            }
            item = this.mItem;
            statusCode = this.mStatusCode;
        }
        if (statusCode == 0) {
            item.done();
        } else {
            item.stop(statusCode);
        }
        this.mLogger.onEngineComplete();
        return 0;
    }

    @Override
    public void error() {
        this.error(-3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void error(int errorCode) {
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mDone) {
                return;
            }
            this.mStatusCode = errorCode;
        }
    }

    @Override
    public void rangeStart(int markerInFrames, int start, int end) {
        if (this.mItem == null) {
            Log.e(TAG, "mItem is null");
            return;
        }
        this.mItem.rangeStart(markerInFrames, start, end);
    }
}

