/*
 * Decompiled with CFR 0.152.
 */
package android.speech.tts;

import android.media.AudioFormat;
import android.speech.tts.AbstractSynthesisCallback;
import android.speech.tts.TextToSpeechService;
import android.util.Log;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;

class FileSynthesisCallback
extends AbstractSynthesisCallback {
    private static final String TAG = "FileSynthesisRequest";
    private static final boolean DBG = false;
    private static final int MAX_AUDIO_BUFFER_SIZE = 8192;
    private static final int WAV_HEADER_LENGTH = 44;
    private static final short WAV_FORMAT_PCM = 1;
    private final Object mStateLock = new Object();
    private int mSampleRateInHz;
    private int mAudioFormat;
    private int mChannelCount;
    private FileChannel mFileChannel;
    private final TextToSpeechService.UtteranceProgressDispatcher mDispatcher;
    private boolean mStarted = false;
    private boolean mDone = false;
    protected int mStatusCode;

    FileSynthesisCallback(FileChannel fileChannel, TextToSpeechService.UtteranceProgressDispatcher dispatcher, boolean clientIsUsingV2) {
        super(clientIsUsingV2);
        this.mFileChannel = fileChannel;
        this.mDispatcher = dispatcher;
        this.mStatusCode = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void stop() {
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mDone) {
                return;
            }
            if (this.mStatusCode == -2) {
                return;
            }
            this.mStatusCode = -2;
            this.cleanUp();
            this.mDispatcher.dispatchOnStop();
        }
    }

    private void cleanUp() {
        this.closeFile();
    }

    private void closeFile() {
        this.mFileChannel = null;
    }

    @Override
    public int getMaxBufferSize() {
        return 8192;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int start(int sampleRateInHz, int audioFormat, int channelCount) {
        if (audioFormat != 3 && audioFormat != 2 && audioFormat != 4) {
            Log.e(TAG, "Audio format encoding " + audioFormat + " not supported. Please use one of AudioFormat.ENCODING_PCM_8BIT, AudioFormat.ENCODING_PCM_16BIT or AudioFormat.ENCODING_PCM_FLOAT");
        }
        this.mDispatcher.dispatchOnBeginSynthesis(sampleRateInHz, audioFormat, channelCount);
        FileChannel fileChannel = null;
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mStatusCode == -2) {
                return this.errorCodeOnStop();
            }
            if (this.mStatusCode != 0) {
                return -1;
            }
            if (this.mStarted) {
                Log.e(TAG, "Start called twice");
                return -1;
            }
            this.mStarted = true;
            this.mSampleRateInHz = sampleRateInHz;
            this.mAudioFormat = audioFormat;
            this.mChannelCount = channelCount;
            this.mDispatcher.dispatchOnStart();
            fileChannel = this.mFileChannel;
        }
        try {
            fileChannel.write(ByteBuffer.allocate(44));
            return 0;
        }
        catch (IOException ex) {
            Log.e(TAG, "Failed to write wav header to output file descriptor", ex);
            Object object2 = this.mStateLock;
            synchronized (object2) {
                this.cleanUp();
                this.mStatusCode = -5;
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int audioAvailable(byte[] buffer, int offset, int length) {
        FileChannel fileChannel = null;
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mStatusCode == -2) {
                return this.errorCodeOnStop();
            }
            if (this.mStatusCode != 0) {
                return -1;
            }
            if (this.mFileChannel == null) {
                Log.e(TAG, "File not open");
                this.mStatusCode = -5;
                return -1;
            }
            if (!this.mStarted) {
                Log.e(TAG, "Start method was not called");
                return -1;
            }
            fileChannel = this.mFileChannel;
        }
        byte[] bufferCopy = new byte[length];
        System.arraycopy((byte[])buffer, (int)offset, (byte[])bufferCopy, (int)0, (int)length);
        this.mDispatcher.dispatchOnAudioAvailable(bufferCopy);
        try {
            fileChannel.write(ByteBuffer.wrap(buffer, offset, length));
            return 0;
        }
        catch (IOException ex) {
            Log.e(TAG, "Failed to write to output file descriptor", ex);
            Object object2 = this.mStateLock;
            synchronized (object2) {
                this.cleanUp();
                this.mStatusCode = -5;
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int done() {
        FileChannel fileChannel = null;
        int sampleRateInHz = 0;
        int audioFormat = 0;
        int channelCount = 0;
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mDone) {
                Log.w(TAG, "Duplicate call to done()");
                return -1;
            }
            if (this.mStatusCode == -2) {
                return this.errorCodeOnStop();
            }
            if (this.mStatusCode != 0 && this.mStatusCode != -2) {
                this.mDispatcher.dispatchOnError(this.mStatusCode);
                return -1;
            }
            if (this.mFileChannel == null) {
                Log.e(TAG, "File not open");
                return -1;
            }
            this.mDone = true;
            fileChannel = this.mFileChannel;
            sampleRateInHz = this.mSampleRateInHz;
            audioFormat = this.mAudioFormat;
            channelCount = this.mChannelCount;
        }
        try {
            fileChannel.position(0L);
            int dataLength = (int)(fileChannel.size() - 44L);
            fileChannel.write(this.makeWavHeader(sampleRateInHz, audioFormat, channelCount, dataLength));
            Object object2 = this.mStateLock;
            synchronized (object2) {
                this.closeFile();
                this.mDispatcher.dispatchOnSuccess();
                return 0;
            }
        }
        catch (IOException ex) {
            Log.e(TAG, "Failed to write to output file descriptor", ex);
            Object object3 = this.mStateLock;
            synchronized (object3) {
                this.cleanUp();
            }
            return -1;
        }
    }

    @Override
    public void error() {
        this.error(-3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void error(int errorCode) {
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mDone) {
                return;
            }
            this.cleanUp();
            this.mStatusCode = errorCode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasStarted() {
        Object object = this.mStateLock;
        synchronized (object) {
            return this.mStarted;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasFinished() {
        Object object = this.mStateLock;
        synchronized (object) {
            return this.mDone;
        }
    }

    private ByteBuffer makeWavHeader(int sampleRateInHz, int audioFormat, int channelCount, int dataLength) {
        int sampleSizeInBytes = AudioFormat.getBytesPerSample(audioFormat);
        int byteRate = sampleRateInHz * sampleSizeInBytes * channelCount;
        short blockAlign = (short)(sampleSizeInBytes * channelCount);
        short bitsPerSample = (short)(sampleSizeInBytes * 8);
        byte[] headerBuf = new byte[44];
        ByteBuffer header = ByteBuffer.wrap(headerBuf);
        header.order(ByteOrder.LITTLE_ENDIAN);
        header.put(new byte[]{82, 73, 70, 70});
        header.putInt(dataLength + 44 - 8);
        header.put(new byte[]{87, 65, 86, 69});
        header.put(new byte[]{102, 109, 116, 32});
        header.putInt(16);
        header.putShort((short)1);
        header.putShort((short)channelCount);
        header.putInt(sampleRateInHz);
        header.putInt(byteRate);
        header.putShort(blockAlign);
        header.putShort(bitsPerSample);
        header.put(new byte[]{100, 97, 116, 97});
        header.putInt(dataLength);
        header.flip();
        return header;
    }

    @Override
    public void rangeStart(int markerInFrames, int start, int end) {
        this.mDispatcher.dispatchOnRangeStart(markerInFrames, start, end);
    }
}

