/*
 * Decompiled with CFR 0.152.
 */
package android.service.carrier;

import android.app.Service;
import android.content.Intent;
import android.os.IBinder;
import android.os.PersistableBundle;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.service.carrier.CarrierIdentifier;
import android.service.carrier.ICarrierService;
import com.android.internal.telephony.ITelephonyRegistry;

public abstract class CarrierService
extends Service {
    public static final String CARRIER_SERVICE_INTERFACE = "android.service.carrier.CarrierService";
    private static ITelephonyRegistry sRegistry;
    private final ICarrierService.Stub mStubWrapper = new ICarrierServiceWrapper();

    public CarrierService() {
        if (sRegistry == null) {
            sRegistry = ITelephonyRegistry.Stub.asInterface(ServiceManager.getService("telephony.registry"));
        }
    }

    public abstract PersistableBundle onLoadConfig(CarrierIdentifier var1);

    public final void notifyCarrierNetworkChange(boolean active) {
        try {
            if (sRegistry != null) {
                sRegistry.notifyCarrierNetworkChange(active);
            }
        }
        catch (RemoteException | NullPointerException exception) {
            // empty catch block
        }
    }

    @Override
    public IBinder onBind(Intent intent) {
        return this.mStubWrapper;
    }

    private class ICarrierServiceWrapper
    extends ICarrierService.Stub {
        private ICarrierServiceWrapper() {
        }

        @Override
        public PersistableBundle getCarrierConfig(CarrierIdentifier id2) {
            return CarrierService.this.onLoadConfig(id2);
        }
    }
}

